/* Flegita - Scanner utility
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * Flegita is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Flegita is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Flegita. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef __FLEGITA_OPTION_WIDGETS_H__
#define __FLEGITA_OPTION_WIDGETS_H__

#include <glib.h>
#include <glib-object.h>
#include <gnome-scan-option-widget.h>

G_BEGIN_DECLS


#define FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET (flegita_output_filename_widget_get_type ())
#define FLEGITA_OUTPUT_FILENAME_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET, FlegitaOutputFilenameWidget))
#define FLEGITA_OUTPUT_FILENAME_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET, FlegitaOutputFilenameWidgetClass))
#define FLEGITA_IS_OUTPUT_FILENAME_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET))
#define FLEGITA_IS_OUTPUT_FILENAME_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET))
#define FLEGITA_OUTPUT_FILENAME_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET, FlegitaOutputFilenameWidgetClass))

typedef struct _FlegitaOutputFilenameWidget FlegitaOutputFilenameWidget;
typedef struct _FlegitaOutputFilenameWidgetClass FlegitaOutputFilenameWidgetClass;
typedef struct _FlegitaOutputFilenameWidgetPrivate FlegitaOutputFilenameWidgetPrivate;

struct _FlegitaOutputFilenameWidget {
	GnomeScanOptionWidget parent_instance;
	FlegitaOutputFilenameWidgetPrivate * priv;
};

struct _FlegitaOutputFilenameWidgetClass {
	GnomeScanOptionWidgetClass parent_class;
};


FlegitaOutputFilenameWidget* flegita_output_filename_widget_construct (GType object_type);
FlegitaOutputFilenameWidget* flegita_output_filename_widget_new (void);
GType flegita_output_filename_widget_get_type (void);


G_END_DECLS

#endif
