/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef __GNOME_SCAN_CHECKBOX_WIDGET_H__
#define __GNOME_SCAN_CHECKBOX_WIDGET_H__

#include <glib.h>
#include <glib-object.h>
#include <gnome-scan-option-widget.h>

G_BEGIN_DECLS


#define GNOME_SCAN_TYPE_CHECKBOX_WIDGET (gnome_scan_checkbox_widget_get_type ())
#define GNOME_SCAN_CHECKBOX_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_CHECKBOX_WIDGET, GnomeScanCheckboxWidget))
#define GNOME_SCAN_CHECKBOX_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_CHECKBOX_WIDGET, GnomeScanCheckboxWidgetClass))
#define GNOME_SCAN_IS_CHECKBOX_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_CHECKBOX_WIDGET))
#define GNOME_SCAN_IS_CHECKBOX_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_CHECKBOX_WIDGET))
#define GNOME_SCAN_CHECKBOX_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_CHECKBOX_WIDGET, GnomeScanCheckboxWidgetClass))

typedef struct _GnomeScanCheckboxWidget GnomeScanCheckboxWidget;
typedef struct _GnomeScanCheckboxWidgetClass GnomeScanCheckboxWidgetClass;
typedef struct _GnomeScanCheckboxWidgetPrivate GnomeScanCheckboxWidgetPrivate;

struct _GnomeScanCheckboxWidget {
	GnomeScanOptionWidget parent_instance;
	GnomeScanCheckboxWidgetPrivate * priv;
};

struct _GnomeScanCheckboxWidgetClass {
	GnomeScanOptionWidgetClass parent_class;
};


GnomeScanCheckboxWidget* gnome_scan_checkbox_widget_construct (GType object_type);
GnomeScanCheckboxWidget* gnome_scan_checkbox_widget_new (void);
GType gnome_scan_checkbox_widget_get_type (void);


G_END_DECLS

#endif
