/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <gnome-scan-scanner-selector.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gnome-scan-backend.h>
#include <gnome-scan-scanner.h>
#include <gnome-scan-node.h>
#include <gnome-scan-common.h>


#define GNOME_SCAN_TYPE_COLUMN (gnome_scan_column_get_type ())

typedef enum  {
	GNOME_SCAN_COLUMN_ICON,
	GNOME_SCAN_COLUMN_NAME,
	GNOME_SCAN_COLUMN_STATUS,
	GNOME_SCAN_COLUMN_OBJECT,
	GNOME_SCAN_COLUMN_LAST
} GnomeScanColumn;



GType gnome_scan_column_get_type (void);
struct _GnomeScanScannerSelectorPrivate {
	GtkListStore* scanners;
	GtkTreeView* view;
	GtkTreeSelection* selection;
	GSList* backends;
	gint backends_probing_count;
	GnomeScanJob* _job;
};

#define GNOME_SCAN_SCANNER_SELECTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_SCANNER_SELECTOR, GnomeScanScannerSelectorPrivate))
enum  {
	GNOME_SCAN_SCANNER_SELECTOR_DUMMY_PROPERTY,
	GNOME_SCAN_SCANNER_SELECTOR_JOB
};
static void _g_slist_free_g_object_unref (GSList* self);
static void* _gnome_scan_backend_probe_scanners_gthread_func (gpointer self);
static void _gnome_scan_scanner_selector_on_scanner_added_gnome_scan_backend_scanner_added (GnomeScanBackend* _sender, GnomeScanScanner* scanner, gpointer self);
static void _gnome_scan_scanner_selector_on_probe_done_gnome_scan_backend_probe_done (GnomeScanBackend* _sender, gpointer self);
static gboolean _gnome_scan_scanner_selector_on_check_probe_done_gsource_func (gpointer self);
static void gnome_scan_scanner_selector_load_backends (GnomeScanScannerSelector* self);
static void _gnome_scan_scanner_selector_on_scanner_status_changed_g_object_notify (GnomeScanScanner* _sender, GParamSpec* pspec, gpointer self);
static void gnome_scan_scanner_selector_on_scanner_added (GnomeScanScannerSelector* self, GnomeScanBackend* backend, GnomeScanScanner* new_scanner);
static void gnome_scan_scanner_selector_on_probe_done (GnomeScanScannerSelector* self, GnomeScanBackend* backend);
static gboolean gnome_scan_scanner_selector_on_check_probe_done (GnomeScanScannerSelector* self);
static gboolean gnome_scan_scanner_selector_select_scanner_if_usable (GnomeScanScannerSelector* self);
static gboolean _gnome_scan_scanner_selector_select_scanner_if_usable_gsource_func (gpointer self);
static void gnome_scan_scanner_selector_on_selection_changed (GnomeScanScannerSelector* self, GtkTreeSelection* selection);
static void gnome_scan_scanner_selector_on_scanner_status_changed (GnomeScanScannerSelector* self, GnomeScanScanner* scanner, GParamSpec* pspec);
static void _gnome_scan_scanner_selector_on_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static GObject * gnome_scan_scanner_selector_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer gnome_scan_scanner_selector_parent_class = NULL;
static void gnome_scan_scanner_selector_finalize (GObject* obj);




GType gnome_scan_column_get_type (void) {
	static GType gnome_scan_column_type_id = 0;
	if (G_UNLIKELY (gnome_scan_column_type_id == 0)) {
		static const GEnumValue values[] = {{GNOME_SCAN_COLUMN_ICON, "GNOME_SCAN_COLUMN_ICON", "icon"}, {GNOME_SCAN_COLUMN_NAME, "GNOME_SCAN_COLUMN_NAME", "name"}, {GNOME_SCAN_COLUMN_STATUS, "GNOME_SCAN_COLUMN_STATUS", "status"}, {GNOME_SCAN_COLUMN_OBJECT, "GNOME_SCAN_COLUMN_OBJECT", "object"}, {GNOME_SCAN_COLUMN_LAST, "GNOME_SCAN_COLUMN_LAST", "last"}, {0, NULL, NULL}};
		gnome_scan_column_type_id = g_enum_register_static ("GnomeScanColumn", values);
	}
	return gnome_scan_column_type_id;
}


static void _g_slist_free_g_object_unref (GSList* self) {
	g_slist_foreach (self, (GFunc) g_object_unref, NULL);
	g_slist_free (self);
}


GnomeScanScannerSelector* gnome_scan_scanner_selector_construct (GType object_type, GnomeScanJob* job) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanScannerSelector * self;
	g_return_val_if_fail (job != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "job";
	g_value_init (&__params_it->value, GNOME_SCAN_TYPE_JOB);
	g_value_set_object (&__params_it->value, job);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanScannerSelector* gnome_scan_scanner_selector_new (GnomeScanJob* job) {
	return gnome_scan_scanner_selector_construct (GNOME_SCAN_TYPE_SCANNER_SELECTOR, job);
}


static void* _gnome_scan_backend_probe_scanners_gthread_func (gpointer self) {
	return gnome_scan_backend_probe_scanners (self);
}


void gnome_scan_scanner_selector_probe_scanners (GnomeScanScannerSelector* self) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	{
		GSList* backend_collection;
		GSList* backend_it;
		backend_collection = self->priv->backends;
		for (backend_it = backend_collection; backend_it != NULL; backend_it = backend_it->next) {
			GnomeScanBackend* _tmp0;
			GnomeScanBackend* backend;
			_tmp0 = NULL;
			backend = (_tmp0 = (GnomeScanBackend*) backend_it->data, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
			{
				{
					self->priv->backends_probing_count++;
					g_thread_create (_gnome_scan_backend_probe_scanners_gthread_func, backend, FALSE, &inner_error);
					if (inner_error != NULL) {
						if (inner_error->domain == G_THREAD_ERROR) {
							goto __catch1_g_thread_error;
						}
						goto __finally1;
					}
				}
				goto __finally1;
				__catch1_g_thread_error:
				{
					GError * error;
					error = inner_error;
					inner_error = NULL;
					{
						g_warning ("gnome-scan-scanner-selector.vala:93: Unable to create new thread : %s", error->message);
						self->priv->backends_probing_count--;
						(error == NULL) ? NULL : (error = (g_error_free (error), NULL));
					}
				}
				__finally1:
				if (inner_error != NULL) {
					(backend == NULL) ? NULL : (backend = (g_object_unref (backend), NULL));
					g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
					g_clear_error (&inner_error);
					return;
				}
				(backend == NULL) ? NULL : (backend = (g_object_unref (backend), NULL));
			}
		}
	}
}


static void _gnome_scan_scanner_selector_on_scanner_added_gnome_scan_backend_scanner_added (GnomeScanBackend* _sender, GnomeScanScanner* scanner, gpointer self) {
	gnome_scan_scanner_selector_on_scanner_added (self, _sender, scanner);
}


static void _gnome_scan_scanner_selector_on_probe_done_gnome_scan_backend_probe_done (GnomeScanBackend* _sender, gpointer self) {
	gnome_scan_scanner_selector_on_probe_done (self, _sender);
}


static gboolean _gnome_scan_scanner_selector_on_check_probe_done_gsource_func (gpointer self) {
	return gnome_scan_scanner_selector_on_check_probe_done (self);
}


static void gnome_scan_scanner_selector_load_backends (GnomeScanScannerSelector* self) {
	gint backend_types_size;
	gint backend_types_length1;
	GType* backend_types;
	GnomeScanBackend* backend;
	GType* _tmp1;
	gint _tmp0;
	g_return_if_fail (self != NULL);
	backend_types = (backend_types_length1 = 0, NULL);
	backend = NULL;
	_tmp1 = NULL;
	backend_types = (_tmp1 = g_type_children (GNOME_SCAN_TYPE_BACKEND, &_tmp0), backend_types = (g_free (backend_types), NULL), backend_types_length1 = _tmp0, backend_types_size = backend_types_length1, _tmp1);
	{
		GType* type_collection;
		int type_collection_length1;
		int type_it;
		type_collection = backend_types;
		type_collection_length1 = backend_types_length1;
		for (type_it = 0; type_it < backend_types_length1; type_it = type_it + 1) {
			GType type;
			type = type_collection[type_it];
			{
				GnomeScanBackend* _tmp2;
				GnomeScanBackend* _tmp3;
				_tmp2 = NULL;
				backend = (_tmp2 = GNOME_SCAN_BACKEND (g_object_new (type, NULL)), (backend == NULL) ? NULL : (backend = (g_object_unref (backend), NULL)), _tmp2);
				_tmp3 = NULL;
				self->priv->backends = g_slist_append (self->priv->backends, (_tmp3 = backend, (_tmp3 == NULL) ? NULL : g_object_ref (_tmp3)));
				g_signal_connect_object (backend, "scanner-added", (GCallback) _gnome_scan_scanner_selector_on_scanner_added_gnome_scan_backend_scanner_added, self, 0);
				g_signal_connect_object (backend, "probe-done", (GCallback) _gnome_scan_scanner_selector_on_probe_done_gnome_scan_backend_probe_done, self, 0);
				g_idle_add (_gnome_scan_scanner_selector_on_check_probe_done_gsource_func, self);
			}
		}
	}
	backend_types = (g_free (backend_types), NULL);
	(backend == NULL) ? NULL : (backend = (g_object_unref (backend), NULL));
}


static void _gnome_scan_scanner_selector_on_scanner_status_changed_g_object_notify (GnomeScanScanner* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_scanner_selector_on_scanner_status_changed (self, _sender, pspec);
}


static void gnome_scan_scanner_selector_on_scanner_added (GnomeScanScannerSelector* self, GnomeScanBackend* backend, GnomeScanScanner* new_scanner) {
	GtkTreeIter iter = {0};
	GtkTreePath* _tmp0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	g_return_if_fail (new_scanner != NULL);
	gtk_list_store_append (self->priv->scanners, &iter);
	gtk_list_store_set (self->priv->scanners, &iter, GNOME_SCAN_COLUMN_ICON, gnome_scan_scanner_get_icon_name (new_scanner), GNOME_SCAN_COLUMN_NAME, gnome_scan_scanner_get_name (new_scanner), GNOME_SCAN_COLUMN_STATUS, _ (gnome_scan_node_get_message ((GnomeScanNode*) new_scanner)), GNOME_SCAN_COLUMN_OBJECT, new_scanner, -1);
	_tmp0 = NULL;
	g_object_set_data ((GObject*) new_scanner, "path", gtk_tree_path_to_string (_tmp0 = gtk_tree_model_get_path ((GtkTreeModel*) self->priv->scanners, &iter)));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (gtk_tree_path_free (_tmp0), NULL));
	g_signal_connect_object ((GObject*) new_scanner, "notify::status", (GCallback) _gnome_scan_scanner_selector_on_scanner_status_changed_g_object_notify, self, 0);
}


static void gnome_scan_scanner_selector_on_probe_done (GnomeScanScannerSelector* self, GnomeScanBackend* backend) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (backend != NULL);
	self->priv->backends_probing_count--;
}


static gboolean gnome_scan_scanner_selector_on_check_probe_done (GnomeScanScannerSelector* self) {
	GtkTreeIter iter = {0};
	g_return_val_if_fail (self != NULL, FALSE);
	/* auto select first scanners
	 TODO: remember selection in GConf*/
	gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->scanners, &iter);
	if (gtk_list_store_iter_is_valid (self->priv->scanners, &iter)) {
		gtk_tree_selection_select_iter (gtk_tree_view_get_selection (self->priv->view), &iter);
	}
	/* stop polling once all backends ended probing.*/
	if (self->priv->backends_probing_count == 0) {
		g_signal_emit_by_name (self, "probe-done");
		return FALSE;
	}
	return TRUE;
}


static gboolean gnome_scan_scanner_selector_select_scanner_if_usable (GnomeScanScannerSelector* self) {
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GnomeScanScanner* scanner;
	GtkTreeModel* _tmp3;
	GtkTreeModel* _tmp2;
	gboolean _tmp1;
	GtkTreeModel* _tmp0;
	gboolean _tmp8;
	g_return_val_if_fail (self != NULL, FALSE);
	model = NULL;
	scanner = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp0 = NULL;
	if ((_tmp1 = gtk_tree_selection_get_selected (self->priv->selection, &_tmp0, &iter), model = (_tmp2 = (_tmp3 = _tmp0, (_tmp3 == NULL) ? NULL : g_object_ref (_tmp3)), (model == NULL) ? NULL : (model = (g_object_unref (model), NULL)), _tmp2), _tmp1)) {
		gtk_tree_model_get (model, &iter, GNOME_SCAN_COLUMN_OBJECT, &scanner, -1);
	} else {
		GnomeScanScanner* _tmp4;
		_tmp4 = NULL;
		scanner = (_tmp4 = NULL, (scanner == NULL) ? NULL : (scanner = (g_object_unref (scanner), NULL)), _tmp4);
	}
	if (scanner == NULL) {
		gboolean _tmp5;
		gnome_scan_job_set_scanner (self->priv->_job, NULL);
		return (_tmp5 = FALSE, (model == NULL) ? NULL : (model = (g_object_unref (model), NULL)), (scanner == NULL) ? NULL : (scanner = (g_object_unref (scanner), NULL)), _tmp5);
	}
	if (gnome_scan_node_get_status ((GnomeScanNode*) scanner) == GNOME_SCAN_STATUS_FAILED) {
		gboolean _tmp6;
		gtk_tree_selection_unselect_all (self->priv->selection);
		return (_tmp6 = FALSE, (model == NULL) ? NULL : (model = (g_object_unref (model), NULL)), (scanner == NULL) ? NULL : (scanner = (g_object_unref (scanner), NULL)), _tmp6);
	}
	if (((gint) gnome_scan_node_get_status ((GnomeScanNode*) scanner)) >= ((gint) GNOME_SCAN_STATUS_UNCONFIGURED)) {
		gboolean _tmp7;
		gnome_scan_job_set_scanner (self->priv->_job, scanner);
		return (_tmp7 = FALSE, (model == NULL) ? NULL : (model = (g_object_unref (model), NULL)), (scanner == NULL) ? NULL : (scanner = (g_object_unref (scanner), NULL)), _tmp7);
	}
	return (_tmp8 = TRUE, (model == NULL) ? NULL : (model = (g_object_unref (model), NULL)), (scanner == NULL) ? NULL : (scanner = (g_object_unref (scanner), NULL)), _tmp8);
}


static gboolean _gnome_scan_scanner_selector_select_scanner_if_usable_gsource_func (gpointer self) {
	return gnome_scan_scanner_selector_select_scanner_if_usable (self);
}


static void gnome_scan_scanner_selector_on_selection_changed (GnomeScanScannerSelector* self, GtkTreeSelection* selection) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (selection != NULL);
	g_idle_add (_gnome_scan_scanner_selector_select_scanner_if_usable_gsource_func, self);
}


static void gnome_scan_scanner_selector_on_scanner_status_changed (GnomeScanScannerSelector* self, GnomeScanScanner* scanner, GParamSpec* pspec) {
	GtkTreeIter iter = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	g_return_if_fail (pspec != NULL);
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) self->priv->scanners, &iter, (const char*) g_object_get_data ((GObject*) scanner, "path"));
	if (!gtk_list_store_iter_is_valid (self->priv->scanners, &iter)) {
		g_warning ("gnome-scan-scanner-selector.vala:191: Unable to update '%s' status in scanner selector!", gnome_scan_scanner_get_name (scanner));
	}
	gtk_list_store_set (self->priv->scanners, &iter, GNOME_SCAN_COLUMN_STATUS, _ (gnome_scan_node_get_message ((GnomeScanNode*) scanner)), -1);
}


GnomeScanJob* gnome_scan_scanner_selector_get_job (GnomeScanScannerSelector* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_job;
}


void gnome_scan_scanner_selector_set_job (GnomeScanScannerSelector* self, GnomeScanJob* value) {
	GnomeScanJob* _tmp2;
	GnomeScanJob* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_job = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_job == NULL) ? NULL : (self->priv->_job = (g_object_unref (self->priv->_job), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "job");
}


static void _gnome_scan_scanner_selector_on_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	gnome_scan_scanner_selector_on_selection_changed (self, _sender);
}


static GObject * gnome_scan_scanner_selector_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanScannerSelectorClass * klass;
	GObjectClass * parent_class;
	GnomeScanScannerSelector * self;
	klass = GNOME_SCAN_SCANNER_SELECTOR_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_SCANNER_SELECTOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_SCANNER_SELECTOR (obj);
	{
		GtkCellRenderer* renderer;
		GtkTreeViewColumn* col;
		GtkListStore* _tmp0;
		GtkTreeView* _tmp1;
		GtkTreeSelection* _tmp3;
		GtkTreeSelection* _tmp2;
		GtkCellRenderer* _tmp4;
		GtkTreeViewColumn* _tmp5;
		GtkCellRenderer* _tmp6;
		GtkTreeViewColumn* _tmp7;
		GtkCellRenderer* _tmp8;
		GtkTreeViewColumn* _tmp9;
		renderer = NULL;
		col = NULL;
		self->priv->backends_probing_count = 0;
		gtk_scrolled_window_set_policy ((GtkScrolledWindow*) self, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
		/* list*/
		gnome_scan_scanner_selector_load_backends (self);
		_tmp0 = NULL;
		self->priv->scanners = (_tmp0 = gtk_list_store_new ((gint) GNOME_SCAN_COLUMN_LAST, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_OBJECT, NULL), (self->priv->scanners == NULL) ? NULL : (self->priv->scanners = (g_object_unref (self->priv->scanners), NULL)), _tmp0);
		/* view*/
		_tmp1 = NULL;
		self->priv->view = (_tmp1 = g_object_ref_sink ((GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) self->priv->scanners)), (self->priv->view == NULL) ? NULL : (self->priv->view = (g_object_unref (self->priv->view), NULL)), _tmp1);
		gtk_tree_view_set_headers_visible (self->priv->view, TRUE);
		_tmp3 = NULL;
		_tmp2 = NULL;
		self->priv->selection = (_tmp3 = (_tmp2 = gtk_tree_view_get_selection (self->priv->view), (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2)), (self->priv->selection == NULL) ? NULL : (self->priv->selection = (g_object_unref (self->priv->selection), NULL)), _tmp3);
		gtk_tree_selection_set_mode (self->priv->selection, GTK_SELECTION_SINGLE);
		g_signal_connect_object (self->priv->selection, "changed", (GCallback) _gnome_scan_scanner_selector_on_selection_changed_gtk_tree_selection_changed, self, 0);
		/* columns;*/
		_tmp4 = NULL;
		renderer = (_tmp4 = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ()), (renderer == NULL) ? NULL : (renderer = (g_object_unref (renderer), NULL)), _tmp4);
		_tmp5 = NULL;
		col = (_tmp5 = g_object_ref_sink (gtk_tree_view_column_new_with_attributes (NULL, renderer, "icon-name", GNOME_SCAN_COLUMN_ICON, NULL)), (col == NULL) ? NULL : (col = (g_object_unref (col), NULL)), _tmp5);
		gtk_tree_view_append_column (self->priv->view, col);
		_tmp6 = NULL;
		renderer = (_tmp6 = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), (renderer == NULL) ? NULL : (renderer = (g_object_unref (renderer), NULL)), _tmp6);
		_tmp7 = NULL;
		col = (_tmp7 = g_object_ref_sink (gtk_tree_view_column_new_with_attributes (_ ("Device"), renderer, "text", GNOME_SCAN_COLUMN_NAME, NULL)), (col == NULL) ? NULL : (col = (g_object_unref (col), NULL)), _tmp7);
		gtk_tree_view_append_column (self->priv->view, col);
		_tmp8 = NULL;
		renderer = (_tmp8 = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), (renderer == NULL) ? NULL : (renderer = (g_object_unref (renderer), NULL)), _tmp8);
		_tmp9 = NULL;
		col = (_tmp9 = g_object_ref_sink (gtk_tree_view_column_new_with_attributes (_ ("Status"), renderer, "text", GNOME_SCAN_COLUMN_STATUS, NULL)), (col == NULL) ? NULL : (col = (g_object_unref (col), NULL)), _tmp9);
		gtk_tree_view_append_column (self->priv->view, col);
		gtk_scrolled_window_add_with_viewport ((GtkScrolledWindow*) self, (GtkWidget*) self->priv->view);
		(renderer == NULL) ? NULL : (renderer = (g_object_unref (renderer), NULL));
		(col == NULL) ? NULL : (col = (g_object_unref (col), NULL));
	}
	return obj;
}


static void gnome_scan_scanner_selector_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanScannerSelector * self;
	gpointer boxed;
	self = GNOME_SCAN_SCANNER_SELECTOR (object);
	switch (property_id) {
		case GNOME_SCAN_SCANNER_SELECTOR_JOB:
		g_value_set_object (value, gnome_scan_scanner_selector_get_job (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_scanner_selector_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanScannerSelector * self;
	self = GNOME_SCAN_SCANNER_SELECTOR (object);
	switch (property_id) {
		case GNOME_SCAN_SCANNER_SELECTOR_JOB:
		gnome_scan_scanner_selector_set_job (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_scanner_selector_class_init (GnomeScanScannerSelectorClass * klass) {
	gnome_scan_scanner_selector_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanScannerSelectorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_scanner_selector_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_scanner_selector_set_property;
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_scanner_selector_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_scanner_selector_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_SCANNER_SELECTOR_JOB, g_param_spec_object ("job", "job", "job", GNOME_SCAN_TYPE_JOB, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_signal_new ("probe_done", GNOME_SCAN_TYPE_SCANNER_SELECTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void gnome_scan_scanner_selector_instance_init (GnomeScanScannerSelector * self) {
	self->priv = GNOME_SCAN_SCANNER_SELECTOR_GET_PRIVATE (self);
}


static void gnome_scan_scanner_selector_finalize (GObject* obj) {
	GnomeScanScannerSelector * self;
	self = GNOME_SCAN_SCANNER_SELECTOR (obj);
	(self->priv->scanners == NULL) ? NULL : (self->priv->scanners = (g_object_unref (self->priv->scanners), NULL));
	(self->priv->view == NULL) ? NULL : (self->priv->view = (g_object_unref (self->priv->view), NULL));
	(self->priv->selection == NULL) ? NULL : (self->priv->selection = (g_object_unref (self->priv->selection), NULL));
	(self->priv->backends == NULL) ? NULL : (self->priv->backends = (_g_slist_free_g_object_unref (self->priv->backends), NULL));
	(self->priv->_job == NULL) ? NULL : (self->priv->_job = (g_object_unref (self->priv->_job), NULL));
	G_OBJECT_CLASS (gnome_scan_scanner_selector_parent_class)->finalize (obj);
}


GType gnome_scan_scanner_selector_get_type (void) {
	static GType gnome_scan_scanner_selector_type_id = 0;
	if (gnome_scan_scanner_selector_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanScannerSelectorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_scanner_selector_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanScannerSelector), 0, (GInstanceInitFunc) gnome_scan_scanner_selector_instance_init, NULL };
		gnome_scan_scanner_selector_type_id = g_type_register_static (GTK_TYPE_SCROLLED_WINDOW, "GnomeScanScannerSelector", &g_define_type_info, 0);
	}
	return gnome_scan_scanner_selector_type_id;
}




