/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef __GNOME_SCAN_OPTION_H__
#define __GNOME_SCAN_OPTION_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gnome-scan-common.h>

G_BEGIN_DECLS


#define GNOME_SCAN_TYPE_OPTION_HINT (gnome_scan_option_hint_get_type ())

#define GNOME_SCAN_TYPE_OPTION (gnome_scan_option_get_type ())
#define GNOME_SCAN_OPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOption))
#define GNOME_SCAN_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))
#define GNOME_SCAN_IS_OPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_IS_OPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION))
#define GNOME_SCAN_OPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION, GnomeScanOptionClass))

typedef struct _GnomeScanOption GnomeScanOption;
typedef struct _GnomeScanOptionClass GnomeScanOptionClass;
typedef struct _GnomeScanOptionPrivate GnomeScanOptionPrivate;

#define GNOME_SCAN_TYPE_OPTION_BOOL (gnome_scan_option_bool_get_type ())
#define GNOME_SCAN_OPTION_BOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_BOOL, GnomeScanOptionBool))
#define GNOME_SCAN_OPTION_BOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_BOOL, GnomeScanOptionBoolClass))
#define GNOME_SCAN_IS_OPTION_BOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_BOOL))
#define GNOME_SCAN_IS_OPTION_BOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_BOOL))
#define GNOME_SCAN_OPTION_BOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_BOOL, GnomeScanOptionBoolClass))

typedef struct _GnomeScanOptionBool GnomeScanOptionBool;
typedef struct _GnomeScanOptionBoolClass GnomeScanOptionBoolClass;
typedef struct _GnomeScanOptionBoolPrivate GnomeScanOptionBoolPrivate;

#define GNOME_SCAN_TYPE_OPTION_INT (gnome_scan_option_int_get_type ())
#define GNOME_SCAN_OPTION_INT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_INT, GnomeScanOptionInt))
#define GNOME_SCAN_OPTION_INT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_INT, GnomeScanOptionIntClass))
#define GNOME_SCAN_IS_OPTION_INT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_INT))
#define GNOME_SCAN_IS_OPTION_INT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_INT))
#define GNOME_SCAN_OPTION_INT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_INT, GnomeScanOptionIntClass))

typedef struct _GnomeScanOptionInt GnomeScanOptionInt;
typedef struct _GnomeScanOptionIntClass GnomeScanOptionIntClass;
typedef struct _GnomeScanOptionIntPrivate GnomeScanOptionIntPrivate;

#define GNOME_SCAN_TYPE_OPTION_DOUBLE (gnome_scan_option_double_get_type ())
#define GNOME_SCAN_OPTION_DOUBLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_DOUBLE, GnomeScanOptionDouble))
#define GNOME_SCAN_OPTION_DOUBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_DOUBLE, GnomeScanOptionDoubleClass))
#define GNOME_SCAN_IS_OPTION_DOUBLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_DOUBLE))
#define GNOME_SCAN_IS_OPTION_DOUBLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_DOUBLE))
#define GNOME_SCAN_OPTION_DOUBLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_DOUBLE, GnomeScanOptionDoubleClass))

typedef struct _GnomeScanOptionDouble GnomeScanOptionDouble;
typedef struct _GnomeScanOptionDoubleClass GnomeScanOptionDoubleClass;
typedef struct _GnomeScanOptionDoublePrivate GnomeScanOptionDoublePrivate;

#define GNOME_SCAN_TYPE_OPTION_STRING (gnome_scan_option_string_get_type ())
#define GNOME_SCAN_OPTION_STRING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_STRING, GnomeScanOptionString))
#define GNOME_SCAN_OPTION_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_STRING, GnomeScanOptionStringClass))
#define GNOME_SCAN_IS_OPTION_STRING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_STRING))
#define GNOME_SCAN_IS_OPTION_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_STRING))
#define GNOME_SCAN_OPTION_STRING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_STRING, GnomeScanOptionStringClass))

typedef struct _GnomeScanOptionString GnomeScanOptionString;
typedef struct _GnomeScanOptionStringClass GnomeScanOptionStringClass;
typedef struct _GnomeScanOptionStringPrivate GnomeScanOptionStringPrivate;

#define GNOME_SCAN_TYPE_OPTION_ENUM (gnome_scan_option_enum_get_type ())
#define GNOME_SCAN_OPTION_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnum))
#define GNOME_SCAN_OPTION_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnumClass))
#define GNOME_SCAN_IS_OPTION_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_ENUM))
#define GNOME_SCAN_IS_OPTION_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_ENUM))
#define GNOME_SCAN_OPTION_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_ENUM, GnomeScanOptionEnumClass))

typedef struct _GnomeScanOptionEnum GnomeScanOptionEnum;
typedef struct _GnomeScanOptionEnumClass GnomeScanOptionEnumClass;
typedef struct _GnomeScanOptionEnumPrivate GnomeScanOptionEnumPrivate;

#define GNOME_SCAN_TYPE_OPTION_BOXED (gnome_scan_option_boxed_get_type ())
#define GNOME_SCAN_OPTION_BOXED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_BOXED, GnomeScanOptionBoxed))
#define GNOME_SCAN_OPTION_BOXED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_BOXED, GnomeScanOptionBoxedClass))
#define GNOME_SCAN_IS_OPTION_BOXED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_BOXED))
#define GNOME_SCAN_IS_OPTION_BOXED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_BOXED))
#define GNOME_SCAN_OPTION_BOXED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_BOXED, GnomeScanOptionBoxedClass))

typedef struct _GnomeScanOptionBoxed GnomeScanOptionBoxed;
typedef struct _GnomeScanOptionBoxedClass GnomeScanOptionBoxedClass;
typedef struct _GnomeScanOptionBoxedPrivate GnomeScanOptionBoxedPrivate;

#define GNOME_SCAN_TYPE_OPTION_POINTER (gnome_scan_option_pointer_get_type ())
#define GNOME_SCAN_OPTION_POINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_POINTER, GnomeScanOptionPointer))
#define GNOME_SCAN_OPTION_POINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_POINTER, GnomeScanOptionPointerClass))
#define GNOME_SCAN_IS_OPTION_POINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_POINTER))
#define GNOME_SCAN_IS_OPTION_POINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_POINTER))
#define GNOME_SCAN_OPTION_POINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_POINTER, GnomeScanOptionPointerClass))

typedef struct _GnomeScanOptionPointer GnomeScanOptionPointer;
typedef struct _GnomeScanOptionPointerClass GnomeScanOptionPointerClass;
typedef struct _GnomeScanOptionPointerPrivate GnomeScanOptionPointerPrivate;

/**
 * GnomeScanOptionHint:
 *
 * Hint for packing option widget in UI.
 */
typedef enum  {
	GNOME_SCAN_OPTION_HINT_HIDDEN,
	GNOME_SCAN_OPTION_HINT_PRIMARY,
	GNOME_SCAN_OPTION_HINT_SECONDARY,
	GNOME_SCAN_OPTION_HINT_PREVIEW,
	GNOME_SCAN_OPTION_HINT_REPEAT
} GnomeScanOptionHint;

/* imply PRIMARY*/
struct _GnomeScanOption {
	GObject parent_instance;
	GnomeScanOptionPrivate * priv;
};

struct _GnomeScanOptionClass {
	GObjectClass parent_class;
};

struct _GnomeScanOptionBool {
	GnomeScanOption parent_instance;
	GnomeScanOptionBoolPrivate * priv;
};

struct _GnomeScanOptionBoolClass {
	GnomeScanOptionClass parent_class;
};

struct _GnomeScanOptionInt {
	GnomeScanOption parent_instance;
	GnomeScanOptionIntPrivate * priv;
};

struct _GnomeScanOptionIntClass {
	GnomeScanOptionClass parent_class;
};

struct _GnomeScanOptionDouble {
	GnomeScanOption parent_instance;
	GnomeScanOptionDoublePrivate * priv;
};

struct _GnomeScanOptionDoubleClass {
	GnomeScanOptionClass parent_class;
};

struct _GnomeScanOptionString {
	GnomeScanOption parent_instance;
	GnomeScanOptionStringPrivate * priv;
};

struct _GnomeScanOptionStringClass {
	GnomeScanOptionClass parent_class;
};

struct _GnomeScanOptionEnum {
	GnomeScanOption parent_instance;
	GnomeScanOptionEnumPrivate * priv;
};

struct _GnomeScanOptionEnumClass {
	GnomeScanOptionClass parent_class;
};

struct _GnomeScanOptionBoxed {
	GnomeScanOption parent_instance;
	GnomeScanOptionBoxedPrivate * priv;
};

struct _GnomeScanOptionBoxedClass {
	GnomeScanOptionClass parent_class;
};

struct _GnomeScanOptionPointer {
	GnomeScanOption parent_instance;
	GnomeScanOptionPointerPrivate * priv;
};

struct _GnomeScanOptionPointerClass {
	GnomeScanOptionClass parent_class;
};


#define GNOME_SCAN_OPTION_GROUP_SCANNER N_ ("Scan Options")
#define GNOME_SCAN_OPTION_GROUP_SINK N_ ("Output Options")
#define GNOME_SCAN_OPTION_GROUP_FORMAT N_ ("Format")
GType gnome_scan_option_hint_get_type (void);
const char* gnome_scan_option_get_name (GnomeScanOption* self);
void gnome_scan_option_set_name (GnomeScanOption* self, const char* value);
const char* gnome_scan_option_get_title (GnomeScanOption* self);
void gnome_scan_option_set_title (GnomeScanOption* self, const char* value);
const char* gnome_scan_option_get_desc (GnomeScanOption* self);
void gnome_scan_option_set_desc (GnomeScanOption* self, const char* value);
const char* gnome_scan_option_get_group (GnomeScanOption* self);
void gnome_scan_option_set_group (GnomeScanOption* self, const char* value);
const char* gnome_scan_option_get_domain (GnomeScanOption* self);
void gnome_scan_option_set_domain (GnomeScanOption* self, const char* value);
GnomeScanUnit gnome_scan_option_get_unit (GnomeScanOption* self);
void gnome_scan_option_set_unit (GnomeScanOption* self, GnomeScanUnit value);
GnomeScanOptionHint gnome_scan_option_get_hint (GnomeScanOption* self);
void gnome_scan_option_set_hint (GnomeScanOption* self, GnomeScanOptionHint value);
gboolean gnome_scan_option_get_active (GnomeScanOption* self);
void gnome_scan_option_set_active (GnomeScanOption* self, gboolean value);
GType gnome_scan_option_get_type (void);
GnomeScanOptionBool* gnome_scan_option_bool_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, gboolean value, GnomeScanOptionHint hint);
GnomeScanOptionBool* gnome_scan_option_bool_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, gboolean value, GnomeScanOptionHint hint);
gboolean gnome_scan_option_bool_get_value (GnomeScanOptionBool* self);
void gnome_scan_option_bool_set_value (GnomeScanOptionBool* self, gboolean value);
GType gnome_scan_option_bool_get_type (void);
GnomeScanOptionInt* gnome_scan_option_int_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, gint value, gint min, gint step, gint max, GnomeScanUnit unit, GnomeScanOptionHint hint);
GnomeScanOptionInt* gnome_scan_option_int_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, gint value, gint min, gint step, gint max, GnomeScanUnit unit, GnomeScanOptionHint hint);
gint gnome_scan_option_int_get_value (GnomeScanOptionInt* self);
void gnome_scan_option_int_set_value (GnomeScanOptionInt* self, gint value);
gint gnome_scan_option_int_get_min (GnomeScanOptionInt* self);
void gnome_scan_option_int_set_min (GnomeScanOptionInt* self, gint value);
gint gnome_scan_option_int_get_step (GnomeScanOptionInt* self);
void gnome_scan_option_int_set_step (GnomeScanOptionInt* self, gint value);
gint gnome_scan_option_int_get_max (GnomeScanOptionInt* self);
void gnome_scan_option_int_set_max (GnomeScanOptionInt* self, gint value);
GType gnome_scan_option_int_get_type (void);
GnomeScanOptionDouble* gnome_scan_option_double_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, double value, double min, double step, double max, GnomeScanUnit unit, GnomeScanOptionHint hint);
GnomeScanOptionDouble* gnome_scan_option_double_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, double value, double min, double step, double max, GnomeScanUnit unit, GnomeScanOptionHint hint);
double gnome_scan_option_double_get_value (GnomeScanOptionDouble* self);
void gnome_scan_option_double_set_value (GnomeScanOptionDouble* self, double value);
double gnome_scan_option_double_get_min (GnomeScanOptionDouble* self);
void gnome_scan_option_double_set_min (GnomeScanOptionDouble* self, double value);
double gnome_scan_option_double_get_step (GnomeScanOptionDouble* self);
void gnome_scan_option_double_set_step (GnomeScanOptionDouble* self, double value);
double gnome_scan_option_double_get_max (GnomeScanOptionDouble* self);
void gnome_scan_option_double_set_max (GnomeScanOptionDouble* self, double value);
GType gnome_scan_option_double_get_type (void);
GnomeScanOptionString* gnome_scan_option_string_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, const char* value, GnomeScanOptionHint hint);
GnomeScanOptionString* gnome_scan_option_string_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, const char* value, GnomeScanOptionHint hint);
const char* gnome_scan_option_string_get_value (GnomeScanOptionString* self);
void gnome_scan_option_string_set_value (GnomeScanOptionString* self, const char* value);
GType gnome_scan_option_string_get_type (void);
GnomeScanOptionEnum* gnome_scan_option_enum_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, const GnomeScanEnumValue* value, GSList* values, GnomeScanOptionHint hint);
GnomeScanOptionEnum* gnome_scan_option_enum_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, const GnomeScanEnumValue* value, GSList* values, GnomeScanOptionHint hint);
void gnome_scan_option_enum_get_value (GnomeScanOptionEnum* self, GnomeScanEnumValue** value);
void gnome_scan_option_enum_set_value (GnomeScanOptionEnum* self, GnomeScanEnumValue** value);
GSList* gnome_scan_option_enum_get_values (GnomeScanOptionEnum* self);
GType gnome_scan_option_enum_get_type (void);
GnomeScanOptionBoxed* gnome_scan_option_boxed_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, gpointer* value, GnomeScanOptionHint hint);
GnomeScanOptionBoxed* gnome_scan_option_boxed_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, gpointer* value, GnomeScanOptionHint hint);
gpointer* gnome_scan_option_boxed_get_value (GnomeScanOptionBoxed* self);
void gnome_scan_option_boxed_set_value (GnomeScanOptionBoxed* self, gpointer* value);
GType gnome_scan_option_boxed_get_type (void);
GnomeScanOptionPointer* gnome_scan_option_pointer_construct (GType object_type, const char* name, const char* title, const char* desc, const char* group, const char* domain, void* value, GnomeScanOptionHint hint);
GnomeScanOptionPointer* gnome_scan_option_pointer_new (const char* name, const char* title, const char* desc, const char* group, const char* domain, void* value, GnomeScanOptionHint hint);
void* gnome_scan_option_pointer_get_value (GnomeScanOptionPointer* self);
void gnome_scan_option_pointer_set_value (GnomeScanOptionPointer* self, void* value);
GType gnome_scan_option_pointer_get_type (void);


G_END_DECLS

#endif
