/* GnomeScanUI - Widgets for scan dialogs
 *
 * gnomescanareaselector.h
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/**
 * SECTION:gnomescanareaselector:
 * @title:		GnomeScanAreaSelector
 * @short_description:	A Widget that do something
 *
 * #GnomeScanAreaSelector do blah.
 */

#ifndef GNOME_SCAN_AREA_SELECTOR_H
#define GNOME_SCAN_AREA_SELECTOR_H

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gnomescan.h>

G_BEGIN_DECLS;

#define	GNOME_TYPE_SCAN_AREA_SELECTOR			(gnome_scan_area_selector_get_type ())
#define GNOME_SCAN_AREA_SELECTOR(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_AREA_SELECTOR, GnomeScanAreaSelector))
#define GNOME_SCAN_AREA_SELECTOR_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCAN_AREA_SELECTOR, GnomeScanAreaSelectorClass))
#define GNOME_IS_GNOME_SCAN_AREA_SELECTOR(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCAN_AREA_SELECTOR))
#define GNOME_IS_GNOME_SCAN_AREA_SELECTOR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCAN_AREA_SELECTOR))
#define GNOME_SCAN_AREA_SELECTOR_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCAN_AREA_SELECTOR, GnomeScanAreaSelectorClass))

typedef struct _GnomeScanAreaSelector			GnomeScanAreaSelector;
typedef struct _GnomeScanAreaSelectorClass		GnomeScanAreaSelectorClass;

struct _GnomeScanAreaSelector {
  GtkVBox		parent;

  /*< public >*/
  GnomeScanContext	*context;
};

struct _GnomeScanAreaSelectorClass {
  GtkVBoxClass		parent;
  GSList*		formats;

  /* SIGNALS */
};

enum {
  GNOME_SCAN_AREA_SELECTOR_ERROR_FAILED
};

/* GObject functions */
GType			gnome_scan_area_selector_get_type		(void)	G_GNUC_CONST;

/* Methods */

GtkWidget*		gnome_scan_area_selector_new 			(GnomeScanContext *context);

void			gnome_scan_area_selector_add_stock		(GnomeScanAreaSelector *gsas,
									 gchar* stock_id);

G_END_DECLS

#endif
