/* GnomeScanUI - Widgets for scan dialogs
 *
 * gnomescanacquisitiondialog.h
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/**
 * SECTION:gnomescanacquisitiondialog
 * @short_description: A dialog to manage and survey the acquisition process
 *
 * #GnomeScanAcquisitionDialog is just a popup dialog that show the
 * percentage of data received and allow user to cancel
 * acquisition. In later version the widget will allow user to manage
 * multiple acquisition as easy as possible even with flatbed devices.
 *
 */

#ifndef GNOME_SCAN_ACQUISITION_DIALOG_H
#define GNOME_SCAN_ACQUISITION_DIALOG_H

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gnomescan.h>

#define	GNOME_TYPE_SCAN_ACQUISITION_DIALOG		(gnome_scan_acquisition_dialog_get_type ())
#define GNOME_SCAN_ACQUISITION_DIALOG(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_ACQUISITION_DIALOG, GnomeScanAcquisitionDialog))
#define GNOME_SCAN_ACQUISITION_DIALOG_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCAN_ACQUISITION_DIALOG, GnomeScanAcquisitionDialogClass))
#define GNOME_IS_SCAN_ACQUISITION_DIALOG(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCAN_ACQUISITION_DIALOG))
#define GNOME_IS_SCAN_ACQUISITION_DIALOG_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCAN_ACQUISITION_DIALOG))
#define GNOME_SCAN_ACQUISITION_DIALOG_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCAN_ACQUISITION_DIALOG, GnomeScanAcquisitionDialogClass))

typedef struct _GnomeScanAcquisitionDialog			GnomeScanAcquisitionDialog;
typedef struct _GnomeScanAcquisitionDialogClass		GnomeScanAcquisitionDialogClass;

struct _GnomeScanAcquisitionDialog {
  GtkWindow				parent;

  /*< public >*/
  GnomeScanContext	*context;
};

struct _GnomeScanAcquisitionDialogClass {
  GtkWindowClass			parent;

  /* SIGNALS */
};

enum {
  GNOME_SCAN_ACQUISITION_DIALOG_ERROR_FAILED
};

/* GObject functions */
GType			gnome_scan_acquisition_dialog_get_type				(void);

/* Methods */

GtkWidget*		gnome_scan_acquisition_dialog_new 				(GnomeScanContext *context,
											 GtkWindow *parent);

#endif
