/* -*- Mode: C; c-basic-offset: 4 -*- */
#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif
#include <Python.h>
#include <pygobject.h>
#include <bonobo/bonobo-main.h>

/* include any extra headers needed here */

void pybonobo_register_classes(PyObject *d);
extern PyMethodDef pybonobo_functions[];

DL_EXPORT(void)
init_bonobo(void)
{
    PyObject *m, *d;

    PyObject *av;
    int argc, i;
    char **argv;

    /* perform any initialisation required by the library here */
    init_pygobject();

    /* make sure ORBit2-python is ready? */

    av = PySys_GetObject("argv");
    argc = PyList_Size(av);
    argv = g_new(char *, argc);
    for (i = 0; i < argc; i++)
	argv[i] = g_strdup(PyString_AsString(PyList_GetItem(av, i)));
    if (!bonobo_init(&argc, argv)) {
	if (argv != NULL) {
	    for (i = 0; i < argc; i++)
		g_free(argv[i]);
	    g_free(argv);
	}
	PyErr_SetString(PyExc_RuntimeError, "could not initialise Bonobo");
	return;
    }
    PySys_SetArgv(argc, argv);
    if (argv != NULL) {
	for (i = 0; i < argc; i++)
	    g_free(argv[i]);
	g_free(argv);
    }

    /* now initialise the module */
    m = Py_InitModule("bonobo._bonobo", pybonobo_functions);
    d = PyModule_GetDict(m);

    pybonobo_register_classes(d);

    /* add anything else to the module dictionary (such as constants) */

    if (PyErr_Occurred())
        Py_FatalError("could not initialise module _bonobo");
}
