/*
 *  Copyright (C) 2000 Helix Code Inc.
 *
 *  Authors: Michael Zucchi <notzed@helixcode.com>
 *
 *  A system print-copies widget.
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _GNOME_PRINT_COPIES_H
#define _GNOME_PRINT_COPIES_H

#include <gtk/gtk.h>
#include <libgnome/gnome-defs.h>

#define GNOME_PRINT_COPIES(obj)         GTK_CHECK_CAST (obj, gnome_print_copies_get_type (), GnomePrintcopies)
#define GNOME_PRINT_COPIES_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, gnome_print_copies_get_type (), GnomePrintcopiesClass)
#define GNOME_IS_PRINT_COPIES(obj)      GTK_CHECK_TYPE (obj, gnome_print_copies_get_type ())


typedef struct _GnomePrintCopies      GnomePrintCopies;
typedef struct _GnomePrintCopiesClass GnomePrintCopiesClass;

struct _GnomePrintCopies {
	GtkVBox vbox;
  
	GtkWidget *copies;
	GtkWidget *collate;
	GtkWidget *collate_image;
};

struct _GnomePrintCopiesClass {
  GtkVBoxClass parent_class;
};

guint		gnome_print_copies_get_type	(void);
GtkWidget	*gnome_print_copies_new	(void);

void gnome_print_copies_set_copies (GnomePrintCopies *gpc, int copies, int collate);
void gnome_print_copies_get_copies (GnomePrintCopies *gpc, int *copies, int *collate);

#endif /* ! _GNOME_PRINT_COPIES_H */
