#include <config.h>
#include <gnome.h>
#include <sys/stat.h>

#include "gnome-printer.h"
#include "gnome-print.h"
#include "gnome-print-meta.h"
#include "gnome-font.h"
#include "gnome-printer-dialog.h"

static void
print_test_page (GnomePrintContext *pc)

{
  GnomeFont *font;
  double matrix[6] = {0.9, 0.1, -0.1, 0.9, 0, 0};
  double matrix2[6] = {1, 0, 0, 1, 0, 100};
  double matrix3[6] = {100, 0, 0, 100, 50, 300};
  double matrix4[6] = {100, 0, 0, 100, 50, 410};
  char img[256][256];
  char colorimg[256][256][3];
  int x, y;
  double width;

  gnome_print_gsave (pc);
  gnome_print_concat (pc, matrix);
  font = gnome_font_new_closest ("Times", GNOME_FONT_BOLD, 1, 36);
  gnome_print_setfont (pc, font);
  gnome_print_setrgbcolor (pc, 0.9, 0.8, 0.6);
  width = gnome_font_get_width_string (font, _("Gnome-print test page"));
  gnome_print_moveto (pc, 145, 590);
  gnome_print_lineto (pc, 155 + width, 590);
  gnome_print_lineto (pc, 155 + width, 630);
  gnome_print_lineto (pc, 145, 630);
  gnome_print_fill (pc);
  gnome_print_moveto (pc, 150, 600);
  gnome_print_setrgbcolor (pc, 0, 0, 0);
  gnome_print_show (pc, _("Gnome-print test page"));
  gnome_print_grestore (pc);

#if 0
  font = gnome_font_new ("NimbusRomNo9L-Regu", 36);
  gnome_print_setfont (pc, font);
  gnome_print_show (pc, "Gnome-print test page");
  gnome_print_grestore (pc);
#endif

  gnome_print_setrgbcolor (pc, 1, 0, 0.5);
  gnome_print_moveto (pc, 50, 50);
  gnome_print_lineto (pc, 50, 90);
  gnome_print_curveto (pc, 70, 90, 90, 70, 90, 50);
  gnome_print_closepath (pc);
  gnome_print_fill (pc);

  for (y = 0; y < 256; y++)
      for (x = 0; x < 256; x++)
	img[y][x] = (x + y) >> 1;

  gnome_print_gsave (pc);
  gnome_print_concat (pc, matrix3);
  gnome_print_grayimage (pc, (char *)img, 256, 256, 256);
  gnome_print_grestore (pc);

  for (y = 0; y < 256; y++)
      for (x = 0; x < 256; x++)
	{
	  colorimg[y][x][0] = (x + y) >> 1;
	  colorimg[y][x][1] = (x + (255 - y)) >> 1;
	  colorimg[y][x][2] = ((255 - x) + y) >> 1;
	}

  gnome_print_gsave (pc);
  gnome_print_concat (pc, matrix4);
  gnome_print_rgbimage (pc, (char *)colorimg, 256, 256, 768);
  gnome_print_grestore (pc);

  gnome_print_concat (pc, matrix2);
  gnome_print_setrgbcolor (pc, 0, 0.5, 0);
  gnome_print_moveto (pc, 50, 50);
  gnome_print_lineto (pc, 50, 90);
  gnome_print_curveto (pc, 70, 90, 90, 70, 90, 50);
  gnome_print_closepath (pc);
  gnome_print_stroke (pc);

  gnome_print_concat (pc, matrix2);
  gnome_print_setrgbcolor (pc, 0, 0, 0.5);
  gnome_print_moveto (pc, 50, 50);
  gnome_print_lineto (pc, 50, 90);
  gnome_print_curveto (pc, 70, 90, 90, 70, 90, 50);
  gnome_print_closepath (pc);
  gnome_print_gsave (pc);
  gnome_print_stroke (pc);
  gnome_print_grestore (pc);
  gnome_print_clip (pc);

  gnome_print_moveto (pc, 50, 50);
  gtk_object_unref (GTK_OBJECT (font));
  font = gnome_font_new ("Courier", 18);
  gnome_print_setfont (pc, font);
  gnome_print_show (pc, "clip!");

  gnome_print_showpage (pc);

  gnome_print_context_close (pc);

  gtk_object_unref (GTK_OBJECT (font));
}

void
test_dump_metafile (char *file)
{
	GnomePrintMeta *meta;
	FILE *f;
	void *data;
	int len;
	
	meta = gnome_print_meta_new ();
	print_test_page (GNOME_PRINT_CONTEXT (meta));
	gnome_print_meta_access_buffer (meta, &data, &len);

	f = fopen (file, "w");
	if (!f){
		printf ("Can not write to %s\n", file);
		exit (1);
	}

	fwrite (data, len, 1, f);
	fclose (f);
}

void
test_load_metafile (char *file)
{
	GnomePrinter *printer;
	GnomePrintContext *pc;
	GnomePrintMeta *meta;
	char *buffer;
	FILE *f;
	struct stat s;
	
	f = fopen (file, "r");
	if (!f){
		printf ("Can not open %s\n", file);
		exit (1);
	}
	if (stat (file, &s) == -1){
		printf ("Can not stat %s\n", file);
		exit (1);
	}

	buffer = g_malloc (s.st_size);
	if (!buffer){
		printf ("not enough memory to load %s\n", file);
		exit (1);
	}

	fread (buffer, s.st_size, 1, f);
	
	meta = gnome_print_meta_new_from (buffer);
	if (!meta){
		printf ("Can not create GnomePrintMeta object from buffer\n");
		exit (1);
	}
	g_free (buffer);
	
	printer = gnome_printer_dialog_new_modal ();
	pc = gnome_print_context_new (printer);

	gnome_print_meta_render_from_object (pc, meta);
	gtk_object_unref (GTK_OBJECT (meta));
	gtk_object_unref (GTK_OBJECT (pc));
	gtk_object_unref (GTK_OBJECT (printer));
}

void
test_ps (void)
{
  GnomePrinter *printer;
  GnomePrintContext *pc;
  
  printer = gnome_printer_dialog_new_modal ();

  if (printer)
    {
      pc = gnome_print_context_new (printer);
      print_test_page (pc);
      gtk_object_unref (GTK_OBJECT (printer));
      gtk_object_unref (GTK_OBJECT (pc));
    }
}

static char *dump_file, *load_file;

static struct poptOption options [] = {
	{ "dump", 0, POPT_ARG_STRING, &dump_file },
	{ "load", 0, POPT_ARG_STRING, &load_file },
	{ NULL }
};

int
main (int argc, char **argv)
{
  gnome_init_with_popt_table ("TestPrint", VERSION, argc, argv, options, 0, NULL);

  if (dump_file){
	  test_dump_metafile (dump_file);
	  return 0;
  }

  if (load_file){
	  test_load_metafile (load_file);
	  return 0;
  }

  test_ps ();
  return 0;
}
