#ifndef __GNOME_PRINT_H__
#define __GNOME_PRINT_H__

#include <stdio.h> /* for FILE */
#include "gnome-printer.h"
#include "gnome-font.h"
#include "gnome-text.h"

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


#define GNOME_TYPE_PRINT_CONTEXT		 (gnome_print_context_get_type ())
#define GNOME_PRINT_CONTEXT(obj)		 (GTK_CHECK_CAST ((obj), GNOME_TYPE_PRINT_CONTEXT, GnomePrintContext))
#define GNOME_PRINT_CONTEXT_CLASS(klass)	 (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_PRINT_CONTEXT, GnomePrintContextClass))
#define GNOME_IS_PRINT_CONTEXT(obj)	 (GTK_CHECK_TYPE ((obj), GNOME_TYPE_PRINT_CONTEXT))
#define GNOME_IS_PRINT_CONTEXT_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_PRINT_CONTEXT))



typedef struct _GnomePrintContext       GnomePrintContext;
typedef struct _GnomePrintContextClass  GnomePrintContextClass;

typedef enum {
  GNOME_PRINT_CONTEXT_TYPE_GENERIC_PS
} GnomePrintContextType;

struct _GnomePrintContext
{
  GtkObject object;

  FILE *f;
  gboolean is_pipe;
};

/* The method defs, autogenned */
struct _GnomePrintContextClass
{
  GtkObjectClass parent_class;

  int (* newpath)          (GnomePrintContext *pc);

  int (* moveto)           (GnomePrintContext *pc, double x, double y);

  int (* lineto)           (GnomePrintContext *pc, double x, double y);

  int (* curveto)          (GnomePrintContext *pc, double x1, double y1, double x2, double y2, double x3, double y3);

  int (* closepath)        (GnomePrintContext *pc);

  int (* setrgbcolor)      (GnomePrintContext *pc, double r, double g, double b);

  int (* fill)             (GnomePrintContext *pc);

  int (* eofill)           (GnomePrintContext *pc);

  int (* setlinewidth)     (GnomePrintContext *pc, double width);

  int (* setmiterlimit)    (GnomePrintContext *pc, double limit);

  int (* setlinejoin)      (GnomePrintContext *pc, int jointype);

  int (* setlinecap)       (GnomePrintContext *pc, int captype);

  int (* setdash)          (GnomePrintContext *pc, int n_values, double *values, double offset);

  int (* strokepath)       (GnomePrintContext *pc);

  int (* stroke)           (GnomePrintContext *pc);

  int (* setfont)          (GnomePrintContext *pc, GnomeFont *font);

  int (* show)             (GnomePrintContext *pc, char *text);

  int (* concat)           (GnomePrintContext *pc, double matrix[6]);

  int (* setmatrix)        (GnomePrintContext *pc, double matrix[6]);

  int (* gsave)            (GnomePrintContext *pc);

  int (* grestore)         (GnomePrintContext *pc);

  int (* clip)             (GnomePrintContext *pc);

  int (* eoclip)           (GnomePrintContext *pc);

  int (* grayimage)        (GnomePrintContext *pc, char *data, int width, int height, int rowstride);

  int (* rgbimage)         (GnomePrintContext *pc, char *data, int width, int height, int rowstride);

  int (* textline)	   (GnomePrintContext *pc, GnomeTextLine *line);

  int (* showpage)         (GnomePrintContext *pc);

  int (* close)            (GnomePrintContext *pc);
};



GtkType gnome_print_context_get_type (void);

GnomePrintContext *gnome_print_context_new (GnomePrinter *printer);

int
gnome_print_context_close (GnomePrintContext *pc);


/* The declarations of the virtual paint methods, autogenned */
int
gnome_print_newpath          (GnomePrintContext *pc);

int
gnome_print_moveto           (GnomePrintContext *pc, double x, double y);

int
gnome_print_lineto           (GnomePrintContext *pc, double x, double y);

int
gnome_print_curveto          (GnomePrintContext *pc, double x1, double y1, double x2, double y2, double x3, double y3);

int
gnome_print_closepath        (GnomePrintContext *pc);

int
gnome_print_setrgbcolor      (GnomePrintContext *pc, double r, double g, double b);

int
gnome_print_fill             (GnomePrintContext *pc);

int
gnome_print_eofill           (GnomePrintContext *pc);

int
gnome_print_setlinewidth     (GnomePrintContext *pc, double width);

int
gnome_print_setmiterlimit    (GnomePrintContext *pc, double limit);

int
gnome_print_setlinejoin      (GnomePrintContext *pc, int jointype);

int
gnome_print_setlinecap       (GnomePrintContext *pc, int captype);

int
gnome_print_setdash          (GnomePrintContext *pc, int n_values, double *values, double offset);

int
gnome_print_strokepath       (GnomePrintContext *pc);

int
gnome_print_stroke           (GnomePrintContext *pc);

int
gnome_print_setfont          (GnomePrintContext *pc, GnomeFont *font);

int
gnome_print_show             (GnomePrintContext *pc, char *text);

int
gnome_print_concat           (GnomePrintContext *pc, double matrix[6]);

int
gnome_print_setmatrix        (GnomePrintContext *pc, double matrix[6]);

int
gnome_print_gsave            (GnomePrintContext *pc);

int
gnome_print_grestore         (GnomePrintContext *pc);

int
gnome_print_clip             (GnomePrintContext *pc);

int
gnome_print_eoclip           (GnomePrintContext *pc);

int
gnome_print_grayimage        (GnomePrintContext *pc, char *data, int width, int height, int rowstride);

int
gnome_print_rgbimage         (GnomePrintContext *pc, char *data, int width, int height, int rowstride);

int
gnome_print_textline	     (GnomePrintContext *pc, GnomeTextLine *line);

int
gnome_print_showpage         (GnomePrintContext *pc);

/* These functions are wrapper functions around capabilities that may
   or may not be deconvolved in back ends. */

int
gnome_print_scale (GnomePrintContext *pc, double sx, double sy);

/* theta is in degrees */
int
gnome_print_rotate (GnomePrintContext *pc, double theta);

int
gnome_print_translate (GnomePrintContext *pc, double x, double y);

/* These are functions for writing bytes to the printer - generally to a
   file or piped to lpr. */

int
gnome_print_context_open_file (GnomePrintContext *pc, const char *filename);

int
gnome_print_context_write_file (GnomePrintContext *pc, char *buf, size_t size);

int
gnome_print_context_fprintf (GnomePrintContext *pc, const char *fmt, ...);

int
gnome_print_context_close_file (GnomePrintContext *pc);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GNOME_PRINT_H__ */
