/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
 *
 * Copyright (C) 2006 William Jon McCann <mccann@jhu.edu>
 * Copyright (C) 2009 Richard Hughes <richard@hughsie.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GPM_POPUP_WINDOW_H
#define GPM_POPUP_WINDOW_H

#include <glib-object.h>
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GPM_TYPE_POPUP_WINDOW			(gpm_popup_window_get_type ())
#define GPM_POPUP_WINDOW(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GPM_TYPE_POPUP_WINDOW, GpmPopupWindow))
#define GPM_POPUP_WINDOW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), GPM_TYPE_POPUP_WINDOW, GpmPopupWindowClass))
#define GPM_IS_POPUP_WINDOW(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GPM_TYPE_POPUP_WINDOW))
#define GPM_IS_POPUP_WINDOW_CLASS(klass)	(G_TYPE_INSTANCE_GET_CLASS ((klass), GPM_TYPE_POPUP_WINDOW))

typedef struct GpmPopupWindow		GpmPopupWindow;
typedef struct GpmPopupWindowClass	GpmPopupWindowClass;
typedef struct GpmPopupWindowPrivate	GpmPopupWindowPrivate;

struct GpmPopupWindow
{
	GtkWindow		 parent;
	GpmPopupWindowPrivate	*priv;
};

struct GpmPopupWindowClass
{
	GtkWindowClass		 parent_class;
};

GType		 gpm_popup_window_get_type		(void);
GtkWidget	*gpm_popup_window_new			(void);
void		 gpm_popup_window_set_icon_name		(GpmPopupWindow	*popup,
							 const gchar	*icon_name);
void		 gpm_popup_window_set_value		(GpmPopupWindow	*popup,
							 gfloat		 value);

G_END_DECLS

#endif
