Summary: GNOME Power Manager
Name: gnome-power-manager
Version: 2.15.2
Release: rhughes1
License: GPL
Group: Applications/System
Source: http://ftp.gnome.org/pub/GNOME/sources/gnome-power-manager/0.3/gnome-power-manager-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
URL: http://www.gnome.org/projects/gnome-power-manager/
BuildRequires: gtk2-devel >= 2.6.0
BuildRequires: libgnomeui-devel >= 2.10.0
BuildRequires: libglade2-devel >= 2.5.0
BuildRequires: libwnck-devel >= 2.10.0
BuildRequires: hal-devel >= 0.5.6
BuildRequires: dbus-devel >= 0.60
BuildRequires: docbook-utils >= 0.6

Requires: gtk2 >= 2.6.0
Requires: gnome-mime-data
Requires: gnome-icon-theme
Requires: libglade2 >= 2.5.0
Requires: libwnck >= 2.10.0
Requires: hal >= 0.5.6
Requires: dbus-glib >= 0.60
Requires: dbus-x11 >= 0.60
Requires: libnotify >= 0.3.0
Requires(pre): GConf2
Requires(post): GConf2
Requires(preun): GConf2

%description
GNOME Power Manager uses the information and facilities provided by HAL
displaying icons and handling user callbacks in an interactive GNOME session.
GNOME Power Preferences allows authorised users to set policy and
change preferences.

%prep
%setup -q

%build
%configure \
	--enable-libnotify \
	--disable-scrollkeeper \
	--with-doc-dir=%{buildroot}%{_datadir}/doc \
	--with-dbus-sys=%{buildroot}/etc/dbus-1/system.d \
	--with-dbus-services=%{buildroot}%{_datadir}/dbus-1/services
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL=1
%makeinstall
unset GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL

desktop-file-install --vendor gnome --delete-original \
  --dir $RPM_BUILD_ROOT%{_datadir}/applications       \
  --add-only-show-in GNOME                            \
  --add-category X-Red-Hat-Base                       \
  $RPM_BUILD_ROOT%{_datadir}/applications/*

%find_lang %{name}

%clean
rm -rf $RPM_BUILD_ROOT

%post
#install new schema for a new package
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
gconftool-2 --makefile-install-rule \
  %{_sysconfdir}/gconf/schemas/gnome-power-manager.schemas > /dev/null || :
killall -HUP gconfd-2 || :
touch --no-create %{_datadir}/icons/hicolor
if [ -x /usr/bin/gtk-update-icon-cache ]; then
  gtk-update-icon-cache -q %{_datadir}/icons/hicolor
fi

%preun
if [ $1 -eq 0 ]; then
    #deleting the schema on package removal
    export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
    gconftool-2 --makefile-uninstall-rule \
      %{_sysconfdir}/gconf/schemas/gnome-power-manager.schemas > /dev/null || :
    killall -HUP gconfd-2 || :
fi

%postun
touch --no-create %{_datadir}/icons/hicolor
if [ -x /usr/bin/gtk-update-icon-cache ]; then
  gtk-update-icon-cache -q %{_datadir}/icons/hicolor
fi

%files -f %{name}.lang
%defattr(-,root,root,0755)
%doc AUTHORS ChangeLog COPYING NEWS README
%{_bindir}/*
%{_datadir}/applications/*
%{_datadir}/dbus-1/*
%{_datadir}/gnome-power-manager/
%{_datadir}/man/man1/*
%{_sysconfdir}/dbus-1/system.d/*
%{_sysconfdir}/gconf/schemas/*.schemas
%{_datadir}/gnome/help/gnome-power-manager/C/*
%{_datadir}/omf/gnome-power-manager/*
%{_datadir}/gnome/autostart/*
%{_datadir}/icons/hicolor/icon-theme.cache
%{_datadir}/icons/hicolor/*/apps/*.png
%{_datadir}/icons/hicolor/*/apps/*.svg

%changelog
* Thu Apr 20 2006 Richard Hughes <richard@hughsie.com> 2.15.1-cvs20060420rhughes
- Update from CVS, new info page

* Thu Apr 17 2006 Richard Hughes <richard@hughsie.com> 2.15.1-cvs20060417rhughes
- Update from CVS, new tango icons

* Thu Apr 06 2006 Richard Hughes <richard@hughsie.com> 2.15.0-cvs20060406rhughes
- Update from CVS, new graph widgets

* Thu Apr 04 2006 Richard Hughes <richard@hughsie.com> 2.15.0-cvs20060404rhughes
- 2.15.0 Release, First public build of this new branch
