Summary: GNOME Power Manager
Name: gnome-power-manager
Version: 2.14.3
Release: rhughes1
License: GPL
Group: Applications/System
Source: http://ftp.gnome.org/pub/GNOME/sources/gnome-power-manager/0.3/gnome-power-manager-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
URL: http://www.gnome.org/projects/gnome-power-manager/
BuildRequires: gtk2-devel >= 2.6.0
BuildRequires: libgnomeui-devel >= 2.10.0
BuildRequires: libglade2-devel >= 2.5.0
BuildRequires: libwnck-devel >= 2.10.0
BuildRequires: hal-devel >= 0.5.6
BuildRequires: dbus-devel >= 0.50
BuildRequires: docbook-utils >= 0.6

Requires: gtk2 >= 2.6.0
Requires: gnome-mime-data
Requires: gnome-icon-theme
Requires: libglade2 >= 2.5.0
Requires: libwnck >= 2.10.0
Requires: hal >= 0.5.6
Requires: dbus-glib >= 0.50
Requires: dbus-x11 >= 0.50
Requires: libnotify >= 0.2.2
Requires(pre): GConf2
Requires(post): GConf2
Requires(preun): GConf2

%description
GNOME Power Manager uses the information and facilities provided by HAL
displaying icons and handling user callbacks in an interactive GNOME session.
GNOME Power Preferences allows authorised users to set policy and
change preferences.

%prep
%setup -q

%build
%configure \
	--enable-libnotify \
	--disable-scrollkeeper \
	--enable-doxygen-docs=no \
	--with-doc-dir=%{buildroot}%{_datadir}/doc \
	--with-dbus-sys=%{buildroot}/etc/dbus-1/system.d \
	--with-dbus-services=%{buildroot}%{_datadir}/dbus-1/services
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL=1
%makeinstall
unset GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL

desktop-file-install --vendor gnome --delete-original \
  --dir $RPM_BUILD_ROOT%{_datadir}/applications       \
  --add-only-show-in GNOME                            \
  --add-category X-Red-Hat-Base                       \
  $RPM_BUILD_ROOT%{_datadir}/applications/*

%find_lang %{name}

%clean
rm -rf $RPM_BUILD_ROOT

%post
#install new schema for a new package
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
gconftool-2 --makefile-install-rule \
  %{_sysconfdir}/gconf/schemas/gnome-power-manager.schemas > /dev/null || :
killall -HUP gconfd-2 || :

%preun
if [ $1 -eq 0 ]; then
    #deleting the schema on package removal
    export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
    gconftool-2 --makefile-uninstall-rule \
      %{_sysconfdir}/gconf/schemas/gnome-power-manager.schemas > /dev/null || :
    killall -HUP gconfd-2 || :
fi

%files -f %{name}.lang
%defattr(-,root,root,0755)
%doc AUTHORS ChangeLog COPYING NEWS README
%{_bindir}/*
%{_datadir}/applications/*
%{_datadir}/dbus-1/*
%{_datadir}/gnome-power-manager/
%{_datadir}/man/man1/*
# TODO: remove system.d as g-p-m shouldn't be on the system bus
%{_sysconfdir}/dbus-1/system.d/*
%{_sysconfdir}/gconf/schemas/*.schemas
%{_datadir}/gnome/help/gnome-power-manager/C/*
%{_datadir}/omf/gnome-power-manager/*
%{_datadir}/gnome/autostart/*

%changelog
* Sun Nov 27 2005 Richard Hughes <richard@hughsie.com> 0.3.1-1
- 0.3.3 Release, Make this file generic example, not for debug builds.

* Sun Nov 27 2005 Richard Hughes <richard@hughsie.com> 0.3.1-1
- 0.3.1 Release, minor tidyups.

* Fri Oct 31 2005 Richard Hughes <richard@hughsie.com> 0.2.9.1-1
- New spec file with dep values got from autoconf.

* Fri Sep 02 2005 David Zeuthen <davidz@redhat.com> 0.2.3.1-1
- Initial import based on an SRPM from Richard Hughes

* Mon Jun 19 2005 Richard Hughes <richard@hughsie.com> 0.1.1-1
- New RPM version 0.1.1

* Mon Jun 18 2005 Richard Hughes <richard@hughsie.com> 0.1.0-1
- New RPM version 0.1.0

* Mon Jun 18 2005 Richard Hughes <richard@hughsie.com> 0.0.5-1
- New RPM version 0.0.5

* Mon Apr 04 2005 Richard Hughes <richard@hughsie.com> 0.0.3-1
- initial packaging of 0.0.3
