# Note that this is NOT a relocatable package
%define name     gnome-pim
%define ver      1.0.50
%define rel      1
%define prefix   /usr

Summary: GNOME Personal Information Manager
Name: %name
Version: %ver
Release: %rel
Copyright: GPL
Group: X11/Gnome
Source: ftp://ftp.gnome.org/pub/GNOME/sources/gnome-pim/gnome-pim-%{ver}.tar.gz
BuildRoot: /var/tmp/gnome-pim-%{PACKAGE_VERSION}-root
Obsoletes: %name
URL: http://www.gnome.org
Docdir: %{prefix}/doc
Requires: gnome-libs >= 1.0.0
Requires: ORBit >= 0.4.0

%description
The GNOME Personal Information Manager consists of applications to make
keeping up with your busy life easier.

Currently these apps are present:

 - gnomecal :  personal calendar and todo list
 - gnomecard:  contact list of friends and business associates

%package devel
Summary: Libraries, includes and other misc bits to develop gnome-pim apps
Group : X11/Gnome
Requires: %name = %{PACKAGE_VERSION}
Obsoletes: %name

%description devel 
Libraries, include files and other assorted stuff for developing gnome-pim
applications and utilities.

%changelog

* Fri Feb 26 1999 Gregory McLean <gregm@comstar.net>

- Fixed the devel section, updated to 1.0.0

* Mon Dec 14 1998 Michael Fulbright <drmike@redhat.com>

- first try at an RPM for the 0.99.0 release

%prep
%setup

%build
# Needed for snapshot releases.
%ifarch alpha
  ARCH_FLAGS="--host=alpha-redhat-linux"
%endif

if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh $ARCH_FLAGS --prefix=%prefix
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure $ARCH_FLAGS --prefix=%prefix
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog NEWS README
%{prefix}/bin/*
%{prefix}/etc/CORBA/*
%{prefix}/share/gnome/*
%{prefix}/share/locale/*
%{prefix}/share/mime-info/*

%files devel
%defattr(-, root, root)

%{prefix}/lib/*a
%{prefix}/share/idl
