#ifndef _INTERNAL_MANAGER_H_
#define _INTERNAL_MANAGER_H_

#include <glib.h>
#include <gmodule.h>
#include <pi-source.h>
#include <pi-dlp.h>
#include "gnome-pilot-conduit.h"
#include "gpilot-userinfo.h"
#include "gpilot-structures.h"
#include <time.h>

typedef struct _GnomePilotSyncStamp GnomePilotSyncStamp;
struct _GnomePilotSyncStamp {
	guint32 sync_PC_Id;
};

gboolean gpilot_initial_synchronize_operations(int pilot_socket,
					       GnomePilotSyncStamp *,
					       struct PilotUser *,
					       GList *conduit_list,
					       GList *backup_conduit_list, 
					       GList *file_conduit_list,
					       GPilotContext *context);
gint gpilot_synchronize(int pilot_socket,
			GnomePilotSyncStamp *,
			struct PilotUser *,
			GList *conduit_list,
			GList *backup_conduit_list, 
			GList *file_conduit_list,
			GPilotContext *context);
gint gpilot_copy_to_pilot(int pilot_socket,
			  GnomePilotSyncStamp *,
			  struct PilotUser *,
			  GList *conduit_list,
			  GList *backup_conduit_list, 
			  GList *file_conduit_list,
			  GPilotContext *context);
gint gpilot_copy_from_pilot(int pilot_socket,
			    GnomePilotSyncStamp *,
			    struct PilotUser *,
			    GList *conduit_list,
			    GList *backup_conduit_list, 
			    GPilotContext *context);
gint gpilot_merge_to_pilot(int pilot_socket,
			   GnomePilotSyncStamp *,
			   struct PilotUser *,
			   GList *conduit_list,
			   GList *backup_conduit_list, 
			   GList *file_conduit_list, 
			   GPilotContext *context);
gint gpilot_merge_from_pilot(int pilot_socket,
			     GnomePilotSyncStamp *,
			     struct PilotUser *,
			     GList *conduit_list,
			     GList *backup_conduit_list, 
			     GPilotContext *context);
gint gpilot_sync_default(int pilot_socket,
			 GnomePilotSyncStamp *,
			 struct PilotUser *,
			 GList *conduit_list,
			 GList *backup_conduit_list, 
			 GList *file_conduit_list, 
			 GPilotContext *context);

void gpilot_add_log_entry(int pilot_socket,
			  gchar *entry,...);

void gpilot_remove_first_sync_settings(guint32 pilot_id,
				       gchar *config_name);

/* Given a context, a pilot, loads the conduits into three lists,
   The conduits, the backup conduits and the file install conduits.
   The latter two are typically only 1 element a list */
void gpilot_load_conduits(GPilotContext *context,
			  GPilotPilot *, 
			  GList **, 
			  GList **, 
			  GList **);

/* Deinstantiate a list of conduits */
void gpilot_unload_conduits(GList *l);

#endif /* _INTERNAL_MANAGER_H_ */
