/* Generated by GOB (v0.92.4) on Fri Mar 31 19:05:23 2000
   (do not edit directly) */

#define GOB_VERSION_MAJOR 0
#define GOB_VERSION_MINOR 92
#define GOB_VERSION_PATCHLEVEL 4

#include "gnome-pilot-conduit-management.h"

#include "gnome-pilot-conduit-management-private.h"


#line 77 "gnome-pilot-conduit-management.gob"

#include <config.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <unistd.h>
#include <gnome-xml/tree.h>
#include <gnome-xml/parser.h>

/* 
   MT-Level :
   Change these defines to make the lib MT safe. 
   (UN)LOCK_MY_HASHES should mutex the conduitname_to_datastruct hash
   (UN)LOCK_MY_COUNTER should mutex the number_of_instances counter
   (UN)LOCK_INSTANCE should mutex the current Gnome:Pilot:Conduit:Management instance
   uhm, don't think I'll use LOCK_INSTANCE
*/
#define LOCK_MY_COUNTER
#define UNLOCK_MY_COUNTER

#define LOCK_MY_HASHES
#define UNLOCK_MY_HASHES

#define LOCK_INSTANCE
#define UNLOCK_INSTANCE

  /* the version that the conduit xml spec files should have */
#define CONDUIT_XML_VERSION "1.0"

gboolean initialized = FALSE;
int number_of_instances  = 0;
GHashTable *conduitname_to_datastruct; 
GHashTable *conduitid_to_datastruct; 

/* these are the list of valid tags in addition to conduit-attribute */
static const gchar *valid_tags[] = {"conduit","name",NULL};

#line 52 "gnome-pilot-conduit-management.c"
/* utility types we may need */
typedef struct { gpointer a; gpointer b; } ___twopointertype;
typedef struct { gpointer a; gpointer b; gpointer c; } ___threepointertype;

/* self casting macros */
#define SELF(x) GNOME_PILOT_CONDUIT_MANAGEMENT(x)
#define IS_SELF(x) GNOME_IS_PILOT_CONDUIT_MANAGEMENT(x)
#define SELF_CLASS(x) GNOME_PILOT_CONDUIT_MANAGEMENT_CLASS(x)

/* here are local prototypes */
static void gnome_pilot_conduit_management_init (GnomePilotConduitManagement *o) G_GNUC_UNUSED;
static void gnome_pilot_conduit_management_class_init (GnomePilotConduitManagementClass *c) G_GNUC_UNUSED;
static void gnome_pilot_conduit_management_initializer (void) G_GNUC_UNUSED;
static int gnome_pilot_conduit_management_select_dir_entry (struct dirent *de) G_GNUC_UNUSED;
static gboolean gnome_pilot_conduit_management_is_other_valid_tag (const gchar *s) G_GNUC_UNUSED;
static GnomePilotConduitMgmtData *gnome_pilot_conduit_management_check_xml_version (xmlNodePtr root) G_GNUC_UNUSED;
static gboolean gnome_pilot_conduit_management_read_conduit_topdata (GnomePilotConduitMgmtData *obj, xmlNodePtr root) G_GNUC_UNUSED;
static gboolean gnome_pilot_conduit_management_read_conduit_name (GnomePilotConduitMgmtData *obj, xmlNodePtr root) G_GNUC_UNUSED;
static void gnome_pilot_conduit_management_read_conduit_attributes (GnomePilotConduitMgmtData *obj, xmlNodePtr root) G_GNUC_UNUSED;
static GnomePilotConduitMgmtData *gnome_pilot_conduit_management_read_conduit_xml (gchar *fname) G_GNUC_UNUSED;
static void gnome_pilot_conduit_management_hfunc_build_name_list (gchar *name, GnomePilotConduitMgmtData *data, GList **output) G_GNUC_UNUSED;
static void gnome_pilot_conduit_management_attribs_foreach (gchar *key, gpointer unused, GList **l) G_GNUC_UNUSED;
static void gnome_pilot_conduit_management_attribs_filter_lang_foreach (gchar *key, gpointer unused, GList **l) G_GNUC_UNUSED;
static gint gnome_pilot_conduit_management_shlib_loader (GnomePilotConduitManagement *self) G_GNUC_UNUSED;
static void gnome_pilot_conduit_management_finalize (GtkObject *o) G_GNUC_UNUSED;

static GtkObjectClass *parent_class = NULL;

guint
gnome_pilot_conduit_management_get_type (void)
{
	static guint type = 0;

	if (!type) {
		static const GtkTypeInfo info = {
			"GnomePilotConduitManagement",
			sizeof (GnomePilotConduitManagement),
			sizeof (GnomePilotConduitManagementClass),
			(GtkClassInitFunc) gnome_pilot_conduit_management_class_init,
			(GtkObjectInitFunc) gnome_pilot_conduit_management_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		type = gtk_type_unique (gtk_object_get_type(), &info);
	}

	return type;
}


#ifdef __GNUC__
static const typeof(&gnome_pilot_conduit_management_initializer) initializer __attribute__ ((__unused__)) = gnome_pilot_conduit_management_initializer;
#define initializer(args...) gnome_pilot_conduit_management_initializer(##args)
static const typeof(&gnome_pilot_conduit_management_new) new __attribute__ ((__unused__)) = gnome_pilot_conduit_management_new;
#define new(args...) gnome_pilot_conduit_management_new(##args)
static const typeof(&gnome_pilot_conduit_management_destroy) destroy __attribute__ ((__unused__)) = gnome_pilot_conduit_management_destroy;
#define destroy(args...) gnome_pilot_conduit_management_destroy(##args)
static const typeof(&gnome_pilot_conduit_management_select_dir_entry) select_dir_entry __attribute__ ((__unused__)) = gnome_pilot_conduit_management_select_dir_entry;
#define select_dir_entry(args...) gnome_pilot_conduit_management_select_dir_entry(##args)
static const typeof(&gnome_pilot_conduit_management_is_other_valid_tag) is_other_valid_tag __attribute__ ((__unused__)) = gnome_pilot_conduit_management_is_other_valid_tag;
#define is_other_valid_tag(args...) gnome_pilot_conduit_management_is_other_valid_tag(##args)
static const typeof(&gnome_pilot_conduit_management_check_xml_version) check_xml_version __attribute__ ((__unused__)) = gnome_pilot_conduit_management_check_xml_version;
#define check_xml_version(args...) gnome_pilot_conduit_management_check_xml_version(##args)
static const typeof(&gnome_pilot_conduit_management_read_conduit_topdata) read_conduit_topdata __attribute__ ((__unused__)) = gnome_pilot_conduit_management_read_conduit_topdata;
#define read_conduit_topdata(args...) gnome_pilot_conduit_management_read_conduit_topdata(##args)
static const typeof(&gnome_pilot_conduit_management_read_conduit_name) read_conduit_name __attribute__ ((__unused__)) = gnome_pilot_conduit_management_read_conduit_name;
#define read_conduit_name(args...) gnome_pilot_conduit_management_read_conduit_name(##args)
static const typeof(&gnome_pilot_conduit_management_read_conduit_attributes) read_conduit_attributes __attribute__ ((__unused__)) = gnome_pilot_conduit_management_read_conduit_attributes;
#define read_conduit_attributes(args...) gnome_pilot_conduit_management_read_conduit_attributes(##args)
static const typeof(&gnome_pilot_conduit_management_read_conduit_xml) read_conduit_xml __attribute__ ((__unused__)) = gnome_pilot_conduit_management_read_conduit_xml;
#define read_conduit_xml(args...) gnome_pilot_conduit_management_read_conduit_xml(##args)
static const typeof(&gnome_pilot_conduit_management_get_name) get_name __attribute__ ((__unused__)) = gnome_pilot_conduit_management_get_name;
#define get_name(args...) gnome_pilot_conduit_management_get_name(##args)
static const typeof(&gnome_pilot_conduit_management_get_id) get_id __attribute__ ((__unused__)) = gnome_pilot_conduit_management_get_id;
#define get_id(args...) gnome_pilot_conduit_management_get_id(##args)
static const typeof(&gnome_pilot_conduit_management_hfunc_build_name_list) hfunc_build_name_list __attribute__ ((__unused__)) = gnome_pilot_conduit_management_hfunc_build_name_list;
#define hfunc_build_name_list(args...) gnome_pilot_conduit_management_hfunc_build_name_list(##args)
static const typeof(&gnome_pilot_conduit_management_get_conduits) get_conduits __attribute__ ((__unused__)) = gnome_pilot_conduit_management_get_conduits;
#define get_conduits(args...) gnome_pilot_conduit_management_get_conduits(##args)
static const typeof(&gnome_pilot_conduit_management_attribs_foreach) attribs_foreach __attribute__ ((__unused__)) = gnome_pilot_conduit_management_attribs_foreach;
#define attribs_foreach(args...) gnome_pilot_conduit_management_attribs_foreach(##args)
static const typeof(&gnome_pilot_conduit_management_attribs_filter_lang_foreach) attribs_filter_lang_foreach __attribute__ ((__unused__)) = gnome_pilot_conduit_management_attribs_filter_lang_foreach;
#define attribs_filter_lang_foreach(args...) gnome_pilot_conduit_management_attribs_filter_lang_foreach(##args)
static const typeof(&gnome_pilot_conduit_management_get_attribute_list) get_attribute_list __attribute__ ((__unused__)) = gnome_pilot_conduit_management_get_attribute_list;
#define get_attribute_list(args...) gnome_pilot_conduit_management_get_attribute_list(##args)
static const typeof(&gnome_pilot_conduit_management_get_attribute) get_attribute __attribute__ ((__unused__)) = gnome_pilot_conduit_management_get_attribute;
#define get_attribute(args...) gnome_pilot_conduit_management_get_attribute(##args)
static const typeof(&gnome_pilot_conduit_management_shlib_loader) shlib_loader __attribute__ ((__unused__)) = gnome_pilot_conduit_management_shlib_loader;
#define shlib_loader(args...) gnome_pilot_conduit_management_shlib_loader(##args)
static const typeof(&gnome_pilot_conduit_management_instantiate_conduit) instantiate_conduit __attribute__ ((__unused__)) = gnome_pilot_conduit_management_instantiate_conduit;
#define instantiate_conduit(args...) gnome_pilot_conduit_management_instantiate_conduit(##args)
static const typeof(&gnome_pilot_conduit_management_destroy_conduit) destroy_conduit __attribute__ ((__unused__)) = gnome_pilot_conduit_management_destroy_conduit;
#define destroy_conduit(args...) gnome_pilot_conduit_management_destroy_conduit(##args)
#else /* __GNUC__ */
static void (* initializer) (void) = gnome_pilot_conduit_management_initializer;
static GnomePilotConduitManagement *(* new) (gchar *_name, enum GnomePilotConduitFilter filter) = gnome_pilot_conduit_management_new;
static void (* destroy) (GnomePilotConduitManagement *self) = gnome_pilot_conduit_management_destroy;
static int (* select_dir_entry) (struct dirent *de) = gnome_pilot_conduit_management_select_dir_entry;
static gboolean (* is_other_valid_tag) (const gchar *s) = gnome_pilot_conduit_management_is_other_valid_tag;
static GnomePilotConduitMgmtData *(* check_xml_version) (xmlNodePtr root) = gnome_pilot_conduit_management_check_xml_version;
static gboolean (* read_conduit_topdata) (GnomePilotConduitMgmtData *obj, xmlNodePtr root) = gnome_pilot_conduit_management_read_conduit_topdata;
static gboolean (* read_conduit_name) (GnomePilotConduitMgmtData *obj, xmlNodePtr root) = gnome_pilot_conduit_management_read_conduit_name;
static void (* read_conduit_attributes) (GnomePilotConduitMgmtData *obj, xmlNodePtr root) = gnome_pilot_conduit_management_read_conduit_attributes;
static GnomePilotConduitMgmtData *(* read_conduit_xml) (gchar *fname) = gnome_pilot_conduit_management_read_conduit_xml;
static const gchar *(* get_name) (GnomePilotConduitManagement *self) = gnome_pilot_conduit_management_get_name;
static const gchar *(* get_id) (GnomePilotConduitManagement *self) = gnome_pilot_conduit_management_get_id;
static void (* hfunc_build_name_list) (gchar *name, GnomePilotConduitMgmtData *data, GList **output) = gnome_pilot_conduit_management_hfunc_build_name_list;
static gint (* get_conduits) (GList **output, enum GnomePilotConduitFilter filter) = gnome_pilot_conduit_management_get_conduits;
static void (* attribs_foreach) (gchar *key, gpointer unused, GList **l) = gnome_pilot_conduit_management_attribs_foreach;
static void (* attribs_filter_lang_foreach) (gchar *key, gpointer unused, GList **l) = gnome_pilot_conduit_management_attribs_filter_lang_foreach;
static GList *(* get_attribute_list) (GnomePilotConduitManagement *self, gboolean filter_lang) = gnome_pilot_conduit_management_get_attribute_list;
static const gpointer *(* get_attribute) (GnomePilotConduitManagement *self, gchar *attribute_name, gchar *lang) = gnome_pilot_conduit_management_get_attribute;
static gint (* shlib_loader) (GnomePilotConduitManagement *self) = gnome_pilot_conduit_management_shlib_loader;
static gint (* instantiate_conduit) (GnomePilotConduitManagement *self, guint pilot_id, GnomePilotConduit **instance) = gnome_pilot_conduit_management_instantiate_conduit;
static gint (* destroy_conduit) (GnomePilotConduitManagement *self, GnomePilotConduit **instance) = gnome_pilot_conduit_management_destroy_conduit;
#endif /* __GNUC__ */

#define GET_NEW (gtk_type_new(gnome_pilot_conduit_management_get_type()))
static void 
gnome_pilot_conduit_management_init (GnomePilotConduitManagement *o)
{
	o->_priv = g_new0 (GnomePilotConduitManagementPrivate,1);
return;
}
static void 
gnome_pilot_conduit_management_class_init (GnomePilotConduitManagementClass *c)
{
	GtkObjectClass *gtk_object_class = (GtkObjectClass *)c;

	parent_class = gtk_type_class (gtk_object_get_type ());

	gtk_object_class->finalize = gnome_pilot_conduit_management_finalize;
return;
}



#line 137 "gnome-pilot-conduit-management.gob"
static void 
gnome_pilot_conduit_management_initializer (void)
{
#line 196 "gnome-pilot-conduit-management.c"
{
#line 138 "gnome-pilot-conduit-management.gob"
	
		if (!initialized) {
			struct dirent **namelist;
			int dirs;
			g_message("reading .conduit's from %s",CONDUITDIR);
			/* Do read of all .conduit files here */
			LOCK_MY_HASHES;
			conduitname_to_datastruct  = g_hash_table_new(g_str_hash,g_str_equal);
			conduitid_to_datastruct  = g_hash_table_new(g_str_hash,g_str_equal);
			dirs = scandir(CONDUITDIR,
				       &namelist,
				       (int (*)(const struct dirent*))gnome_pilot_conduit_management_select_dir_entry,
				       alphasort);
			/* g_message("direntries = %d",dirs); */
			for (; dirs>0;dirs--) {
				GnomePilotConduitMgmtData *conduitdata;
				conduitdata = read_conduit_xml(namelist[dirs-1]->d_name);
			}
			UNLOCK_MY_HASHES;
		}
		initialized = TRUE;
	}}
#line 221 "gnome-pilot-conduit-management.c"

#line 162 "gnome-pilot-conduit-management.gob"
GnomePilotConduitManagement *
gnome_pilot_conduit_management_new (gchar *_name, enum GnomePilotConduitFilter filter)
{
#line 227 "gnome-pilot-conduit-management.c"
{
#line 163 "gnome-pilot-conduit-management.gob"
	
		GtkObject *ret = NULL;
		GHashTable *which_to_use = NULL;
		GnomePilotConduitManagement *obj  = NULL;
		GnomePilotConduitMgmtData *_mgmtdata = NULL;

		LOCK_MY_COUNTER;
		if (number_of_instances==0) {
			gnome_pilot_conduit_management_initializer();
		}
		number_of_instances++;
		UNLOCK_MY_COUNTER;
		
		switch (filter) {
		case GNOME_PILOT_CONDUIT_MGMT_ID:
			which_to_use = conduitid_to_datastruct;
			break;
		case GNOME_PILOT_CONDUIT_MGMT_NAME:
			which_to_use = conduitname_to_datastruct;
			break;
		}

		_mgmtdata = g_hash_table_lookup(which_to_use,_name);
		if (_mgmtdata) {
			ret = GTK_OBJECT(GET_NEW);
			obj = SELF(ret);
			obj->_priv->loaded = FALSE;
			obj->_priv->mgmtdata = _mgmtdata;
		} else {
			g_warning("Unknown conduit, name=\"%s\"",_name);
		}

		return obj;
	}}
#line 264 "gnome-pilot-conduit-management.c"

#line 201 "gnome-pilot-conduit-management.gob"
void 
gnome_pilot_conduit_management_destroy (GnomePilotConduitManagement *self)
{
#line 201 "gnome-pilot-conduit-management.gob"
	g_return_if_fail (self != NULL);
#line 201 "gnome-pilot-conduit-management.gob"
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self));
#line 274 "gnome-pilot-conduit-management.c"
{
#line 202 "gnome-pilot-conduit-management.gob"
	
		LOCK_INSTANCE;
		LOCK_MY_COUNTER;
		number_of_instances--;
		if (number_of_instances==0) {
			/* g_message("No more instances"); */
		}
		gtk_object_destroy(GTK_OBJECT(self));
		UNLOCK_MY_COUNTER;
		UNLOCK_INSTANCE;
	}}
#line 288 "gnome-pilot-conduit-management.c"

#line 220 "gnome-pilot-conduit-management.gob"
static int 
gnome_pilot_conduit_management_select_dir_entry (struct dirent *de)
{
#line 294 "gnome-pilot-conduit-management.c"
{
#line 221 "gnome-pilot-conduit-management.gob"
	
		gchar *ptr;
		struct stat st;
		if (de==NULL || de->d_name==NULL) return 0;
		/* g_message("select_dir_entry(%s)",de->d_name); */
		if (strlen(de->d_name) < strlen(".conduit")) return 0;
		ptr = de->d_name;
		ptr += strlen(de->d_name) - strlen(".conduit");
		if (strcmp(ptr,".conduit")) return 0;
		ptr = g_strdup_printf("%s%s",CONDUITDIR,de->d_name);
		stat(ptr,&st);
		if (S_ISDIR(st.st_mode) || 
		    S_ISCHR(st.st_mode) || 
		    S_ISFIFO(st.st_mode) || 
		    S_ISSOCK(st.st_mode)) return 0;
		g_message("select_dir_entry(%s)",de->d_name);
		return 1;
	}}
#line 315 "gnome-pilot-conduit-management.c"

#line 241 "gnome-pilot-conduit-management.gob"
static gboolean 
gnome_pilot_conduit_management_is_other_valid_tag (const gchar *s)
{
#line 321 "gnome-pilot-conduit-management.c"
{
#line 242 "gnome-pilot-conduit-management.gob"
	
		gint i = 0;
		for (i=0;valid_tags[i];i++)
			if (g_strcasecmp(s,valid_tags[i])==0) return TRUE;
		return FALSE;
		
	}}
#line 331 "gnome-pilot-conduit-management.c"

#line 251 "gnome-pilot-conduit-management.gob"
static GnomePilotConduitMgmtData *
gnome_pilot_conduit_management_check_xml_version (xmlNodePtr root)
{
#line 337 "gnome-pilot-conduit-management.c"
{
#line 252 "gnome-pilot-conduit-management.gob"
	
		GnomePilotConduitMgmtData *ret;
		xmlChar *version;
		
		version = xmlGetProp(root,"version");
		/* g_message("version = %s",version); */
		if (version==NULL || g_strcasecmp(version,CONDUIT_XML_VERSION)!=0) {
			g_warning("incompatible version");
			return NULL;	
		}
		/* g_message("XML version is ok, creating entry"); */
		ret = g_new(GnomePilotConduitMgmtData,1);
		ret->string_attributes = g_hash_table_new(g_str_hash,g_str_equal);
		return ret;
	}}
#line 355 "gnome-pilot-conduit-management.c"

#line 269 "gnome-pilot-conduit-management.gob"
static gboolean 
gnome_pilot_conduit_management_read_conduit_topdata (GnomePilotConduitMgmtData *obj, xmlNodePtr root)
{
#line 361 "gnome-pilot-conduit-management.c"
{
#line 270 "gnome-pilot-conduit-management.gob"
	
		xmlNodePtr node;
		xmlChar *type,*location,*id_string;

		node = root->childs;
		/* until we find the "conduit" node */
		while (node && g_strcasecmp(node->name,"conduit")!=0) {
			node = node->next;
		}
		if (!node) {
			g_warning("error in XML, missing the \"conduit\" node");
			return FALSE;
		}
		type = xmlGetProp(node,"type");
		location = xmlGetProp(node,"location");
		id_string = xmlGetProp(node,"id");

		if (id_string==NULL) {
			g_warning("error in XML, missing id_string");
			return FALSE;
		} else {
			if (strchr(id_string,' ')) {
				g_warning("error in XML, id_string bad");
				return FALSE;
			}
		}
		if (location==NULL) {
			g_warning("error in XML, missing location");
			return FALSE;
		}

		if(g_strcasecmp(type,"shlib")==0) {
			obj->type = GNOME_PILOT_CONDUIT_TYPE_SHLIB;
		} else {
			g_warning("Unknown conduit type");
			return FALSE;	
		}
		obj->location = g_strdup(location);
		obj->id = g_strdup(id_string);
		g_hash_table_insert(conduitid_to_datastruct,
				    obj->id,
				    obj);
		return TRUE;
	}}
#line 408 "gnome-pilot-conduit-management.c"

#line 316 "gnome-pilot-conduit-management.gob"
static gboolean 
gnome_pilot_conduit_management_read_conduit_name (GnomePilotConduitMgmtData *obj, xmlNodePtr root)
{
#line 414 "gnome-pilot-conduit-management.c"
{
#line 317 "gnome-pilot-conduit-management.gob"
	
		xmlNodePtr node;
		xmlChar *value,*lang;
		gchar *current_name=NULL;

		node = root->childs;
		/* until we find a name node */
		while (node) {
			while (node && g_strcasecmp(node->name,"name")) {
				node = node->next;
			}
			if (node) {
				value = xmlGetProp(node,"value");
				lang = xmlGetProp(node,"lang");
				/* if this is a default name, and there
				   is no current_name, set it. If on the
				   other hand there is a lang, and it's the current, set it*/
				if ((!lang && !current_name) ||
				    (lang && gnome_i18n_get_language() && g_strcasecmp(lang,gnome_i18n_get_language())==0)) {
					if (current_name) g_free(current_name);
					current_name = g_strdup(value);
				}
				node = node->next;
			}
		}
		if (!current_name) {
			g_warning("could not determine name from XML");
			return FALSE;
		}

		obj->name = g_strdup(current_name);
		g_hash_table_insert(conduitname_to_datastruct,
				    obj->name,
				    obj);
		return TRUE;
	}}
#line 453 "gnome-pilot-conduit-management.c"

#line 356 "gnome-pilot-conduit-management.gob"
static void 
gnome_pilot_conduit_management_read_conduit_attributes (GnomePilotConduitMgmtData *obj, xmlNodePtr root)
{
#line 459 "gnome-pilot-conduit-management.c"
{
#line 357 "gnome-pilot-conduit-management.gob"
	
		xmlNodePtr node;

		/* loop over the children */
		for (node = root->childs; node!=NULL; node=node->next) {
			if (g_strcasecmp(node->name,"conduit-attribute")==0) {
				xmlChar *lang,*name,*type,*value;
				gchar *attr_with_lang;
				
				lang = xmlGetProp(node,"lang");
				name = xmlGetProp(node,"name");
				type = xmlGetProp(node,"type");
				value = xmlGetProp(node,"value");

				if (value==NULL) {
					g_warning("attribute has no value");
					continue;
				}
				if (name==NULL) {
					g_warning("attribute has no name");
					continue;
				}

				/* g_message("conduit-attribute [%s-%s] is \"%s\"/%s",
				  name,lang,value,type); */
				if (lang) {
					attr_with_lang = g_strdup_printf("%s##%s",
									 lang,name);
				} else {
					attr_with_lang = g_strdup(name);
				}
				/* if no type, assume string */
				if(type==NULL || g_strcasecmp(type,"string")==0) {
					g_hash_table_insert(obj->string_attributes,
							    attr_with_lang,
							    g_strdup(value));
				} else {
					g_warning("Unknown type %s",type);
				}
				
			} else if (!is_other_valid_tag(node->name)) { 
				g_warning("node->name = \"%s\", unhandled ",node->name);
			} 
		} 
	}}
#line 507 "gnome-pilot-conduit-management.c"

#line 405 "gnome-pilot-conduit-management.gob"
static GnomePilotConduitMgmtData *
gnome_pilot_conduit_management_read_conduit_xml (gchar *fname)
{
#line 513 "gnome-pilot-conduit-management.c"
{
#line 406 "gnome-pilot-conduit-management.gob"
	
		gchar *name;
		xmlDocPtr doc;
		xmlNodePtr root;
		GnomePilotConduitMgmtData *ret;
		
		name = g_strdup_printf("%s%s",CONDUITDIR,fname);
		/* g_message("read_conduit_xml: reading from %s",name); */
		
		/* load the thing */
		doc = xmlParseFile(name);
		
		/* check validity 1 */
		if(!doc->root ||
		   !doc->root->name ||
		   g_strcasecmp(doc->root->name,"gnome-pilot-conduit")!=0) {
			xmlFreeDoc(doc);
			return NULL;
		}      
		
		root = doc->root;
		ret = check_xml_version(root);
		if (!read_conduit_topdata(ret,root) ||
		    !read_conduit_name(ret,root)) {
			g_hash_table_destroy(ret->string_attributes);
			g_free(ret);
			xmlFreeDoc(doc);
			return NULL;
		}
		;
		read_conduit_attributes(ret,root);

		xmlFreeDoc(doc);
		return ret;
	}}
#line 551 "gnome-pilot-conduit-management.c"

#line 448 "gnome-pilot-conduit-management.gob"
const gchar *
gnome_pilot_conduit_management_get_name (GnomePilotConduitManagement *self)
{
#line 448 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (const gchar *)0);
#line 448 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (const gchar *)0);
#line 561 "gnome-pilot-conduit-management.c"
{
#line 449 "gnome-pilot-conduit-management.gob"
	
		return self->_priv->mgmtdata->name;
	}}
#line 567 "gnome-pilot-conduit-management.c"

#line 454 "gnome-pilot-conduit-management.gob"
const gchar *
gnome_pilot_conduit_management_get_id (GnomePilotConduitManagement *self)
{
#line 454 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (const gchar *)0);
#line 454 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (const gchar *)0);
#line 577 "gnome-pilot-conduit-management.c"
{
#line 455 "gnome-pilot-conduit-management.gob"
	
		return self->_priv->mgmtdata->id;
	}}
#line 583 "gnome-pilot-conduit-management.c"

#line 460 "gnome-pilot-conduit-management.gob"
static void 
gnome_pilot_conduit_management_hfunc_build_name_list (gchar *name, GnomePilotConduitMgmtData *data, GList **output)
{
#line 589 "gnome-pilot-conduit-management.c"
{
#line 461 "gnome-pilot-conduit-management.gob"
	
		(*output) = g_list_append(*output,name);
	}}
#line 595 "gnome-pilot-conduit-management.c"

#line 465 "gnome-pilot-conduit-management.gob"
gint 
gnome_pilot_conduit_management_get_conduits (GList **output, enum GnomePilotConduitFilter filter)
{
#line 465 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (output != NULL, (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 603 "gnome-pilot-conduit-management.c"
{
#line 468 "gnome-pilot-conduit-management.gob"
	
		GHashTable *which_to_use = NULL;
		gnome_pilot_conduit_management_initializer();
		LOCK_MY_HASHES;
		switch (filter) {
		case GNOME_PILOT_CONDUIT_MGMT_ID:
			which_to_use = conduitid_to_datastruct;
			break;
		case GNOME_PILOT_CONDUIT_MGMT_NAME:
			which_to_use = conduitname_to_datastruct;
			break;
		}
		g_hash_table_foreach(which_to_use,
				     (GHFunc)hfunc_build_name_list,
				     output);
		UNLOCK_MY_HASHES;		
		return GNOME_PILOT_CONDUIT_MGMT_OK;
	}}
#line 624 "gnome-pilot-conduit-management.c"

#line 489 "gnome-pilot-conduit-management.gob"
static void 
gnome_pilot_conduit_management_attribs_foreach (gchar *key, gpointer unused, GList **l)
{
#line 630 "gnome-pilot-conduit-management.c"
{
#line 490 "gnome-pilot-conduit-management.gob"
	
		(*l) = g_list_append(*l,key);
	}}
#line 636 "gnome-pilot-conduit-management.c"

#line 495 "gnome-pilot-conduit-management.gob"
static void 
gnome_pilot_conduit_management_attribs_filter_lang_foreach (gchar *key, gpointer unused, GList **l)
{
#line 642 "gnome-pilot-conduit-management.c"
{
#line 496 "gnome-pilot-conduit-management.gob"
	
		if (!strstr(key,"##"))
			(*l) = g_list_append(*l,key);
	}}
#line 649 "gnome-pilot-conduit-management.c"

#line 505 "gnome-pilot-conduit-management.gob"
GList *
gnome_pilot_conduit_management_get_attribute_list (GnomePilotConduitManagement *self, gboolean filter_lang)
{
#line 505 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (GList *)0);
#line 505 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (GList *)0);
#line 659 "gnome-pilot-conduit-management.c"
{
#line 506 "gnome-pilot-conduit-management.gob"
	
		GList *attribs = NULL;
		LOCK_MY_HASHES;
		
		if (filter_lang) {
			g_hash_table_foreach(self->_priv->mgmtdata->string_attributes,(GHFunc)attribs_filter_lang_foreach,&attribs);
		} else {
			g_hash_table_foreach(self->_priv->mgmtdata->string_attributes,(GHFunc)attribs_foreach,&attribs);
		}
		UNLOCK_MY_HASHES;
		return attribs;
	}}
#line 674 "gnome-pilot-conduit-management.c"

#line 521 "gnome-pilot-conduit-management.gob"
const gpointer *
gnome_pilot_conduit_management_get_attribute (GnomePilotConduitManagement *self, gchar *attribute_name, gchar *lang)
{
#line 521 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (const gpointer *)NULL);
#line 521 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (const gpointer *)NULL);
#line 521 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (attribute_name != NULL, (const gpointer *)NULL);
#line 686 "gnome-pilot-conduit-management.c"
{
#line 526 "gnome-pilot-conduit-management.gob"
			
		gpointer *attr = NULL;		
		gchar *attribute_name_with_lang;
		LOCK_MY_HASHES;
		/* if no such conduit, do nothing and NULL will be returned */
		if (strstr(attribute_name,"##")==NULL) {
			attribute_name_with_lang = g_strdup_printf("%s##%s",
								   lang?lang:gnome_i18n_get_language(),
								   attribute_name);
		} else {
			attribute_name_with_lang = g_strdup(attribute_name);
		}
		attr = g_hash_table_lookup(self->_priv->mgmtdata->string_attributes,
					   attribute_name_with_lang);
		g_free(attribute_name_with_lang);
		if (!attr) {
			/* no luck, try without language */
			attr = g_hash_table_lookup(self->_priv->mgmtdata->string_attributes,attribute_name);
		}
		UNLOCK_MY_HASHES;
		return attr;
	}}
#line 711 "gnome-pilot-conduit-management.c"

#line 556 "gnome-pilot-conduit-management.gob"
static gint 
gnome_pilot_conduit_management_shlib_loader (GnomePilotConduitManagement *self)
{
#line 556 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (gint )0);
#line 556 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (gint )0);
#line 721 "gnome-pilot-conduit-management.c"
{
#line 557 "gnome-pilot-conduit-management.gob"
	
		gchar *location = self->_priv->mgmtdata->location;
		GModule *dlhandle = self->_priv->dlhandle;
		if (g_module_supported()!=TRUE) {
			g_warning(_("module loading not supported, fatal!"));
			return GNOME_PILOT_CONDUIT_MGMT_FATAL;
		}
		if ((dlhandle = g_module_open(location,0))==NULL) {
			g_warning("unable to g_module_open(%s)",location);
			return GNOME_PILOT_CONDUIT_MGMT_ERROR;
		} 
		if (g_module_symbol(dlhandle,"conduit_get_gpilot_conduit",
				    (gpointer)&(self->_priv->load_func))==FALSE) {
			g_warning("malformed conduit, cannot locate symbol"
				  "\"conduit_get_gpilot_conduit\", error %s",
				  g_module_error());
			return GNOME_PILOT_CONDUIT_MGMT_ERROR;
		}
		if (g_module_symbol(dlhandle,"conduit_destroy_gpilot_conduit",
				    (gpointer)&(self->_priv->destroy_func))==FALSE) {
			g_warning("malformed conduit, cannot locate symbol"
				  "\"conduit_destroy_gpilot_conduit\", error %s",
				  g_module_error());
			return GNOME_PILOT_CONDUIT_MGMT_ERROR;
		}
		self->_priv->loaded = TRUE;
		return GNOME_PILOT_CONDUIT_MGMT_OK;
	}}
#line 752 "gnome-pilot-conduit-management.c"

#line 590 "gnome-pilot-conduit-management.gob"
gint 
gnome_pilot_conduit_management_instantiate_conduit (GnomePilotConduitManagement *self, guint pilot_id, GnomePilotConduit **instance)
{
#line 590 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 590 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 590 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (instance != NULL, (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 764 "gnome-pilot-conduit-management.c"
{
#line 593 "gnome-pilot-conduit-management.gob"
	
		gint err = GNOME_PILOT_CONDUIT_MGMT_OK;
		(*instance) = NULL;
		LOCK_INSTANCE;
		if (self->_priv->loaded==FALSE) {
			switch(self->_priv->mgmtdata->type) {
			case GNOME_PILOT_CONDUIT_TYPE_SHLIB: 
				err = shlib_loader(self);
				break;
			default:
				g_warning("unknown conduit type");
				break;
			}
		}
		if (err == GNOME_PILOT_CONDUIT_MGMT_OK) {
			(*instance) = self->_priv->load_func(pilot_id);
		}
		UNLOCK_INSTANCE;
		return err;
	}}
#line 787 "gnome-pilot-conduit-management.c"

#line 615 "gnome-pilot-conduit-management.gob"
gint 
gnome_pilot_conduit_management_destroy_conduit (GnomePilotConduitManagement *self, GnomePilotConduit **instance)
{
#line 615 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (self != NULL, (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 615 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_MANAGEMENT (self), (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 615 "gnome-pilot-conduit-management.gob"
	g_return_val_if_fail (instance != NULL, (gint )GNOME_PILOT_CONDUIT_MGMT_ERROR);
#line 799 "gnome-pilot-conduit-management.c"
{
#line 618 "gnome-pilot-conduit-management.gob"
	
		LOCK_INSTANCE;
		if (self->_priv->loaded==TRUE) {
			self->_priv->destroy_func(*instance);
		}
		UNLOCK_INSTANCE;
		return GNOME_PILOT_CONDUIT_MGMT_OK;
	}}
#line 810 "gnome-pilot-conduit-management.c"

static void 
gnome_pilot_conduit_management_finalize (GtkObject *o)
#define PARENT_HANDLER(___o) \
	{ if(GTK_OBJECT_CLASS(parent_class)->finalize) \
		(* GTK_OBJECT_CLASS(parent_class)->finalize)(___o); }
{
	g_free (GNOME_PILOT_CONDUIT_MANAGEMENT (o)->_priv);
	GNOME_PILOT_CONDUIT_MANAGEMENT (o)->_priv = NULL;
{
	PARENT_HANDLER (o);
}}
#undef PARENT_HANDLER
#undef GET_NEW


#ifndef __GNUC__
/*REALLY BAD HACK
  This is to avoid unused warnings if you don't call
  some method.  I need to find a better way to do
  this, not needed in GCC since we use some gcc
  extentions to make saner, faster code */
static void
___gnome_pilot_conduit_management_really_bad_hack_to_avoid_warnings(void)
{
	((void (*)(void))initializer)();
	((void (*)(void))new)();
	((void (*)(void))destroy)();
	((void (*)(void))select_dir_entry)();
	((void (*)(void))is_other_valid_tag)();
	((void (*)(void))check_xml_version)();
	((void (*)(void))read_conduit_topdata)();
	((void (*)(void))read_conduit_name)();
	((void (*)(void))read_conduit_attributes)();
	((void (*)(void))read_conduit_xml)();
	((void (*)(void))get_name)();
	((void (*)(void))get_id)();
	((void (*)(void))hfunc_build_name_list)();
	((void (*)(void))get_conduits)();
	((void (*)(void))attribs_foreach)();
	((void (*)(void))attribs_filter_lang_foreach)();
	((void (*)(void))get_attribute_list)();
	((void (*)(void))get_attribute)();
	((void (*)(void))shlib_loader)();
	((void (*)(void))instantiate_conduit)();
	((void (*)(void))destroy_conduit)();
	___gnome_pilot_conduit_management_really_bad_hack_to_avoid_warnings();
}
#endif /* __GNUC__ */


#line 628 "gnome-pilot-conduit-management.gob"



#line 866 "gnome-pilot-conduit-management.c"
