#ifndef _GPILOT_USERINFO_H_
#define _GPILOT_USERINFO_H_

#include <glib.h>
#include "gnome-pilot-conduit.h"

typedef struct GPilotSyncOpt {
	GnomePilotConduitSyncType default_sync_action;
	gchar *basedir;
} GPilotSyncOpt;

struct GPilotUser;
typedef struct GPilotUser GPilotUser;

struct GPilotPilot {
	/* The pilots name */
	gchar *name;
	/* The userspecified password for the pilot */
	gchar *passwd;
        /* To look up conduits file */
	int number; 
	/* Pilot owners name */
	gchar *pilot_username;
	/* Pilots ID number */
	guint32 pilot_id;

      /* list of gchar* unix usernames that may operate on the pilot (not implemented) */
	GList *trusted_users;  
	GPilotSyncOpt sync_options;
};

typedef struct GPilotPilot GPilotPilot;


struct GPilotUser {
	gchar *username;  /* We can get the real name from getpwent */
};

GPilotPilot *gpilot_pilot_new (void);
void gpilot_pilot_init (GPilotPilot *pilot, gint i);
void gpilot_pilot_free (GPilotPilot *pilot);

GPilotUser *gpilot_user_new (void);
void gpilot_user_free (GPilotUser *user);

GPilotPilot* gpilot_find_pilot_by_name(gchar*,GList*);
GPilotPilot* gpilot_find_pilot_by_id(guint32, GList*);

#define GPILOT_PILOT(s) ((GPilotPilot*)(s))
#define GPILOT_USER(s) ((GPilotUser*)(s))

#endif /* _GPILOT_USERINFO_H_ */
