/* $Id: file_conduit.c,v 1.12 2000/02/27 12:03:57 eskil Exp $ */

#include <glib.h>
#include <gnome.h>

#include <pi-source.h>
#include <pi-socket.h>
#include <pi-file.h>
#include <pi-dlp.h>
#include <pi-version.h>

#include <sys/stat.h>
#include <sys/types.h>
#include <utime.h>
#include <unistd.h>
#include <pwd.h>
#include <signal.h>

#include <gpilotd/gnome-pilot-conduit-file.h>

/* pilot stuff begin */
#include <stdio.h>
#include <time.h>
#ifdef __EMX__
#include <sys/types.h>
#endif
#include "getopt.h"
#include <sys/stat.h>
#include <signal.h>
#include <utime.h>
#include "pi-source.h"
#include "pi-socket.h"
#include "pi-file.h"
#include "pi-dlp.h"
#define pi_mktag(c1,c2,c3,c4) (((c1)<<24)|((c2)<<16)|((c3)<<8)|(c4))
#define MAXDBS 256
/* pilot stuff end */

GnomePilotConduit *conduit_get_gpilot_conduit (guint32 pilotId);
void conduit_destroy_gpilot_conduit (GnomePilotConduit *conduit);

typedef struct file_db {
        gchar name[256];
        gchar dbname[256];
        gint flags;
        gulong creator;
        gulong type;
        gint maxblock;
} file_db;

static gint
gnome_real_pilot_conduit_file_install_db (GnomePilotConduitFile *file_conduit,
					  int psock,
					  gchar *src_file)
{
	GnomePilotDBInfo info;
	struct pi_file *file;
#ifdef DEBUG
	g_print ("in gnome_real_pilot_conduit_file_install_db\nsrc_file is %s\n", src_file);
#endif
	
	if ( dlp_OpenConduit(psock) < 0) {
#ifdef DEBUG
		fprintf(stderr, "file_conduit: Exiting on cancel, stopped before installing '%s'.\n", src_file);
#endif
		return -1;
	}

	file = pi_file_open(src_file);
	if (file == NULL) {
#ifdef DEBUG
		fprintf(stderr,"file_conduit: Unable to open '%s'!\n", src_file);
#endif
		return -1;
	}

#ifdef DEBUG
	fprintf(stderr,"file_conduit: Installing %s... ", src_file);
	fflush(stdout);
#endif
	pi_file_get_info (file, (PI_DBINFO (&info)));
	g_message(_("Installing %s from %s..."),PI_DBINFO (&info)->name, src_file);
	gnome_pilot_conduit_message(GNOME_PILOT_CONDUIT(file_conduit),
				    _("Installing %s from %s..."),
				    PI_DBINFO (&info)->name,
				    src_file);
	if (pi_file_install (file, psock, 0) < 0) {
#ifdef DEBUG
		fprintf(stderr,"failed.\n");
#endif
		gnome_pilot_conduit_error(GNOME_PILOT_CONDUIT(file_conduit),
					  _("Installing %s failed"),
					  PI_DBINFO (&info)->name);
		pi_file_close (file);
		return -1;
	} else {
#ifdef DEBUG
		fprintf(stderr,"OK\n");
#endif
		pi_file_close (file);
		unlink (src_file);
		return 0;
	}
};

static int 
compare(file_db *d1, file_db *d2)
{
	/* types of 'appl' sort later then other types */
	if(d1->creator == d2->creator) {
		if(d1->type != d2->type) {
			if(d1->type == pi_mktag('a','p','p','l'))
				return 1;
			if(d2->type == pi_mktag('a','p','p','l'))
				return -1;
		}
	}
	return d1->maxblock < d2->maxblock;
}

static gint
gnome_real_pilot_conduit_file_restore_directory (GnomePilotConduitFile *file_conduit,
						 int psock,
						 gchar *src_dir)
{
	DIR *dir;
	struct dirent *dirent;
	GnomePilotDBInfo info;
	file_db **db;
	int dbcount = 0;
	int i, j, max, size;
	struct pi_file *file;

	g_return_val_if_fail (src_dir != NULL, -1);

	dir = opendir (src_dir);

	db = (file_db**)g_malloc (MAXDBS * sizeof (file_db*));
	while( (dirent = readdir(dir)) ) {

		/* skip dotfiles. */
		if (dirent->d_name[0] == '.')
			continue;

		db[dbcount] = (file_db*)g_malloc (sizeof (file_db));
		g_snprintf (db[dbcount]->name, 255, "%s/%s", src_dir, dirent->d_name);

		file = pi_file_open (db[dbcount]->name);
		if (file == 0) {
#ifdef DEBUG
			printf("file_conduit: Unable to open '%s'!\n", db[dbcount]->name);
#endif
			/* Skip this file */
			continue;

		}

		pi_file_get_info (file, (PI_DBINFO (&info)));

		g_snprintf (db[dbcount]->dbname, 255, "%s", PI_DBINFO (&info)->name);
		db[dbcount]->creator = PI_DBINFO (&info)->creator;
		db[dbcount]->type = PI_DBINFO (&info)->type;
		db[dbcount]->flags = PI_DBINFO (&info)->flags;
		db[dbcount]->maxblock = 0;

		pi_file_get_entries(file, &max);
		for (i = 0; i < max; i++) {
			if (PI_DBINFO (&info)->flags & dlpDBFlagResource)
				pi_file_read_resource(file, i, 0, &size, 0, 0);
			else
				pi_file_read_record(file, i, 0, &size, 0, 0,0 );

			if (size > db[dbcount]->maxblock)
				db[dbcount]->maxblock = size;
		}

		pi_file_close (file);
		dbcount++;
	}

	closedir(dir);

	for (i=0;i<dbcount;i++) {
		for (j=i+1;j<dbcount;j++)
			if (compare(db[i],db[j])>0) {
				file_db *temp = db[i];
				db[i] = db[j];
				db[j] = temp;
			}
	}

	for (i=0;i<dbcount;i++) {

		if ( dlp_OpenConduit(psock) < 0) {
#ifdef DEBUG
			fprintf(stderr,"file_conduit: file_conduit: Exiting on cancel. All data not restored.\n");
#endif
			return -1;
		}

		file = pi_file_open (db[i]->name);
		if (file == NULL) {
#ifdef DEBUG
			fprintf (stderr,"file_conduit: Unable to open '%s'!\n", db[i]->name);
#endif
			break;
		}
#ifdef DEBUG
		fprintf (stdout,"file_conduit: Restoring %s... ", db[i]->name);
		fflush (stdout);
#endif
		g_message(_("Restoring %s from %s... "), db[i]->dbname, db[i]->name);
		gnome_pilot_conduit_message(GNOME_PILOT_CONDUIT(file_conduit),
					    _("Restoring %s from %s... "), 
					    db[i]->dbname, 
					    db[i]->name);
		if (pi_file_install(file, psock, 0)<0) {
#ifdef DEBUG
			printf("failed.\n");
#endif
			g_message(_("Restore of %s failed"),db[i]->dbname);
			gnome_pilot_conduit_error(GNOME_PILOT_CONDUIT(file_conduit),
						    _("Restore of %s failed"),
						    db[i]->dbname);
		} else {
#ifdef DEBUG
			printf("OK\n");
#endif
		}

		pi_file_close(file);
	}

#ifdef DEBUG
	fprintf (stderr,"file_conduit: Restore done\n");
#endif

	for(i=0;i<dbcount;i++){
		g_free(db[i]);
	}
	g_free(db);
	return 0;
}

GnomePilotConduit *
conduit_get_gpilot_conduit (guint32 pilotId)
{
	GnomePilotConduit *retval;

	retval = GNOME_PILOT_CONDUIT (gnome_pilot_conduit_file_new ());
	g_assert (retval != NULL);
	gnome_pilot_conduit_file_construct (GNOME_PILOT_CONDUIT_FILE (retval), pilotId);
	gtk_signal_connect (GTK_OBJECT (retval), "install_db", (GtkSignalFunc) gnome_real_pilot_conduit_file_install_db, NULL);
	gtk_signal_connect (GTK_OBJECT (retval), "restore_directory", (GtkSignalFunc) gnome_real_pilot_conduit_file_restore_directory, NULL);

	return retval;
}

void
conduit_destroy_gpilot_conduit (GnomePilotConduit *conduit)
{
	gtk_object_destroy (GTK_OBJECT (conduit));
}
