#ifndef _GPILOT_STRUCTURES_H_
#define _GPILOT_STRUCTURES_H_
#include <glib.h>
#include "gpilot-userinfo.h"

typedef struct GPilotContext {
  GList *devices;
  GList *pilots;
  GPilotUser *user; /* Null in master global gpilotd */
  guint32 sync_PC_Id; /* Different for every gpilotd instance */
} GPilotContext;

GPilotContext *gpilot_context_new (void);
void gpilot_context_init_user (GPilotContext *context);
void gpilot_context_free (GPilotContext *context);

typedef struct GPilotDevice {
	gchar *name;
	gchar *port;
	guint speed;
	/* These are used at runtime, to associate 
	   an opened file with the device */
	int fd;
	GIOChannel *io;
} GPilotDevice;

GPilotDevice *gpilot_device_new (void);
gint gpilot_device_init (GPilotDevice *device, gint i);
void gpilot_device_free (GPilotDevice *device);

#define GPILOT_DEVICE(s) ((GPilotDevice*)(s))
#endif /* _GPILOT_USERINFO_H_ */
