/* gnome-pilot-conduit-file.h
 * Copyright (C) 1999  J. Arthur Random
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __GNOME_PILOT_CONDUIT_FILE_H__
#define __GNOME_PILOT_CONDUIT_FILE_H__

#include <gnome.h>
#include "gnome-pilot-conduit.h"

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#define GNOME_TYPE_PILOT_CONDUIT_FILE			(gnome_pilot_conduit_file_get_type ())
#define GNOME_PILOT_CONDUIT_FILE(obj)			(GTK_CHECK_CAST ((obj), GNOME_TYPE_PILOT_CONDUIT_FILE, GnomePilotConduitFile))
#define GNOME_PILOT_CONDUIT_FILE_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_PILOT_CONDUIT_FILE, GnomePilotConduitFileClass))
#define GNOME_IS_PILOT_CONDUIT_FILE(obj)			(GTK_CHECK_TYPE ((obj), GNOME_TYPE_PILOT_CONDUIT_FILE))
#define GNOME_IS_PILOT_CONDUIT_FILE_CLASS(klass)		(GTK_CHECK_CLASS_TYPE ((obj), GNOME_TYPE_PILOT_CONDUIT_FILE))


typedef struct _GnomePilotConduitFile       GnomePilotConduitFile;
typedef struct _GnomePilotConduitFileClass  GnomePilotConduitFileClass;

struct _GnomePilotConduitFile
{
	GnomePilotConduit parent;

	guint32 pilotId;
};
struct _GnomePilotConduitFileClass
{
	GnomePilotConduitClass parent_class;

	/* Signals go here */
	void (*install_db)		(GnomePilotConduitFile *pilot_conduit_file);
	void (*restore_directory)	(GnomePilotConduitFile *pilot_conduit_file);
};


GtkType    gnome_pilot_conduit_file_get_type          (void);
GtkObject *gnome_pilot_conduit_file_new               (void);
void       gnome_pilot_conduit_file_construct         (GnomePilotConduitFile *file,
						       guint32 pilotId);
gint       gnome_pilot_conduit_file_install_db        (GnomePilotConduitFile *file,
						       int pisock,
						       gchar *src_file);
/* Restores all the files in a directory.  Useful with backup_db
   with a NULL database name, and dest as a file name.  If
   src_dir is NULL the conduit will restore all files from a
   default directory.  This provides the standard install
   behavior as seen in windows. */
gint       gnome_pilot_conduit_file_restore_directory (GnomePilotConduitFile *file,
						       int pisock,
						       gchar *src_file);
#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GNOME_PILOT_CONDUIT_FILE_H__ */
