/* $Id: backup_conduit.h,v 1.19 2000/01/08 20:24:13 vadim Exp $ */
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

typedef struct ConduitCfg {
  gchar *backup_dir;
  GList *exclude_files;
  GList *files_in_backup;   /* contains the file in backup, any entries when
                               destroy is called are considered deleted on PDA */
  gboolean remove_deleted;
  gboolean updated_only;
  guint32 pilotId;
  pid_t child;
} ConduitCfg;

#define CONDUIT_CFG(s) ((ConduitCfg*)(s))
#define GET_CFG(s) ((ConduitCfg*)(gtk_object_get_data(GTK_OBJECT(s),"configuration")))
#define BC_DEBUG

GCompareFunc
exclude_sort( gconstpointer *a , gconstpointer *b ) 
{
  
}

void 
load_configuration(ConduitCfg **c,guint32 pilotId) 
{
	gchar *prefix;
	gchar *exclude;
	gchar **excs;
	guint i;

	*c = g_new0(ConduitCfg,1);
	(*c)->child = -1;
	
	prefix = g_strdup_printf("/gnome-pilot.d/backup-conduit/Pilot_%u/",pilotId);
	
	gnome_config_push_prefix(prefix);
	(*c)->backup_dir = gnome_config_get_string("backup_dir");
	(*c)->updated_only = gnome_config_get_bool("updated_only=TRUE");
	(*c)->remove_deleted = gnome_config_get_bool("remove_deleted=FALSE");	
	exclude = gnome_config_get_string("exclude_files");
	if(exclude != NULL) {
	  (*c)->exclude_files = NULL;
	  excs = g_strsplit( exclude, ",", 0 );
	  for( i = 0; excs[i] != NULL ; i++ ) {
	    (*c)->exclude_files = g_list_insert_sorted( (*c)->exclude_files , 
							g_strdup(excs[i]),
							(GCompareFunc)g_strcasecmp);
	  }
	  g_strfreev(excs);
	}
	gnome_config_pop_prefix();
	
	(*c)->files_in_backup = NULL;

	if ((*c)->backup_dir == NULL) {
		gchar *tmp;
		tmp = gpilotd_get_pilot_basedir_by_id(pilotId);
		(*c)->backup_dir = g_strdup_printf("%s/backup/",tmp);
		g_free(tmp);
	}
	/*
	if((*c)->backup_dir==NULL) {
		(*c)->backup_dir = g_strdup_printf("%s/pilot/",g_get_home_dir());
	} 
	*/
	
	if(mkdir((*c)->backup_dir,(mode_t)0755) < 0) { /* Wow, I never though I would
							  use octal in C :) */
		if(errno != EEXIST) {
			/* YECH! 
			   CONDUIT_CFG(c.gpilotd_methods)->log_error("Cannot open whatever...");
			*/
		}
	}    
	(*c)->pilotId = pilotId;
	g_free(prefix);
}

void 
save_configuration(ConduitCfg *c) 
{
	gchar *prefix;
	gchar **exclude;
	gchar *exc=NULL;
	GList *iterator;
	guint i;

	g_return_if_fail(c!=NULL);
       	
	prefix= g_strdup_printf("/gnome-pilot.d/backup-conduit/Pilot_%u/",c->pilotId);
	
#ifdef BC_DEBUG
	fprintf(stderr,"backup_conduit: savecfg: prefix = %s\n",prefix);
#endif
	if( c->exclude_files != NULL ) {
	  iterator = c->exclude_files;
	  exclude = g_malloc( sizeof(char *) * (g_list_length(iterator)+1) );
	  for( i=0 ; iterator != NULL ; iterator = iterator->next, i++ ) {
	    exclude[i] = iterator->data;
	  }
	  exclude[i] = NULL;
	  exc = g_strjoinv( ",", exclude);
	  g_free(exclude);
	}
	gnome_config_push_prefix(prefix);
	gnome_config_set_string("backup_dir",c->backup_dir);
	gnome_config_set_bool("updated_only",c->updated_only);
	gnome_config_set_bool("remove_deleted",c->remove_deleted);
	gnome_config_set_string("exclude_files",exc);
	gnome_config_pop_prefix();
	gnome_config_sync();
	gnome_config_drop_all();
	g_free(prefix);
	g_free(exc);
}
static void 
copy_configuration(ConduitCfg *d, ConduitCfg *c)
{
        g_return_if_fail(c!=NULL);
        g_return_if_fail(d!=NULL);
	if(d->backup_dir) g_free(d->backup_dir);
	d->backup_dir = g_strdup(c->backup_dir);
	d->remove_deleted = c->remove_deleted;
	d->updated_only = c->updated_only;
	d->pilotId = c->pilotId;
	d->child = c->child;
	if(d->exclude_files) g_list_free(d->exclude_files);
	d->exclude_files = g_list_copy(c->exclude_files);
	if(d->files_in_backup) g_list_free(d->files_in_backup);
	d->files_in_backup = g_list_copy(c->files_in_backup);
}

static ConduitCfg*
dupe_configuration(ConduitCfg *c) 
{
	ConduitCfg *d;
	g_return_val_if_fail(c!=NULL,NULL);
	d = g_new0(ConduitCfg,1);
	copy_configuration(d,c);
	return d;
}

/** this method frees all data from the conduit config */
void 
destroy_configuration(ConduitCfg **c) 
{
	g_return_if_fail(c!=NULL);
	g_return_if_fail(*c!=NULL);

	if((*c)->remove_deleted) {
		g_list_free((*c)->files_in_backup);
	}
	
	g_list_free((*c)->exclude_files);
	g_free((*c)->backup_dir);
	g_free(*c);
	*c = NULL;
}

