#ifndef GPILOTD_CAPPLET_PILOT_H
#define GPILOTD_CAPPLET_PILOT_H

#include <gpilotd/gpilot-userinfo.h>
#include <gpilotd/gpilot-structures.h>
#include <gpilotd/gnome-pilot-conduit.h>

extern const char *deviceList[];
extern const guint  speedList[];

/* variables describing pilotd configuration state */
typedef struct _PilotState PilotState;
struct _PilotState {
	guint32       syncPCid;     /* SyncPCid for this machine */
	GPilotPilot   *pilot;        /* pilot parameters */
	GPilotUser    *user;         /* name of UNIX user for this pilot */
	GPilotDevice  *device;       /* device cradle is attached to */
	GnomePilotConduitSyncType sync_type; /* the ruling sync type */
};


PilotState *newPilotState(void);
PilotState *dupPilotState(PilotState *state);
void copyPilotState(PilotState *dest, PilotState *src);
gint loadPilotState(PilotState **p);
gint savePilotState(PilotState *p);

#endif

