#ifndef _GPILOT_USERINFO_H_
#define _GPILOT_USERINFO_H_

#include <glib.h>

typedef struct GPilotSyncOpt {
  gint default_sync_action; /* Copy from pilot, to pilot, or synchronize */
} GPilotSyncOpt;

struct GPilotUser;
typedef struct GPilotUser GPilotUser;

typedef struct GPilotPilot {
  gchar *name;
  gchar *passwd;
  int number; /* To look up conduits file */
  gchar *pilot_username;
  guint32 pilot_id;
  GList *trusted_users;  /* list of gchar* unix usernames */
  GPilotSyncOpt sync_options;
} GPilotPilot;


struct GPilotUser {
  gchar *username;  /* We can get the real name from getpwent */
};

GPilotPilot *gpilot_pilot_new (void);
void gpilot_pilot_init (GPilotPilot *pilot, gint i);
void gpilot_pilot_free (GPilotPilot *pilot);

GPilotUser *gpilot_user_new (void);
void gpilot_user_free (GPilotUser *user);


#define GPILOT_PILOT(s) ((GPilotPilot*)(s))
#define GPILOT_USER(s) ((GPilotUser*)(s))

#endif /* _GPILOT_USERINFO_H_ */
