#include "gnome.h"
#include <pwd.h>
#include <sys/types.h>
#include "gpilot-userinfo.h"
#include "gnome-pilot-conduit.h"
#include "manager.h"

GPilotPilot *
gpilot_pilot_new (void)
{
  GPilotPilot *retval;

  retval = (GPilotPilot *)g_malloc(sizeof(GPilotPilot));
  if (!retval)
    return NULL;
  retval->name = NULL;
  retval->passwd = NULL;
  retval->number = 0;
  retval->pilot_username = NULL;
  retval->pilot_id = 0;
  retval->trusted_users = NULL;
  retval->sync_options.default_sync_action = 0;
  
  return retval;
}

void
gpilot_pilot_init (GPilotPilot *pilot, gint i)
{
  gchar tmp_str[64];
  gchar *tmp_str2;
  struct passwd *pwd;
  gchar prefix[33];
  gint seed;


  /* set up stuff  */
  seed = time(NULL);
  srandom(seed);
  g_free (pilot->name);
  g_free (pilot->passwd);
  g_free (pilot->pilot_username);
  g_list_foreach (pilot->trusted_users, (GFunc) g_free, NULL);
  g_list_free (pilot->trusted_users);
  g_snprintf (prefix, 32,"/gnome-pilot.d/gpilotd/Pilot%d/", i);
  gnome_config_push_prefix (prefix);

  /* start filling in fields */
  pwd = getpwuid(geteuid());
  if (pwd && pwd->pw_gecos)
    g_snprintf (tmp_str, 63, "name=%s", pwd->pw_gecos);
  else
    g_snprintf (tmp_str, 63, "name=J. Random Pilotuser");
  pilot->name = gnome_config_get_string(tmp_str);

  g_snprintf (tmp_str, 63, "pilotid=%d", 
	      1 + ((guint) 1000000.0*random()));
  pilot->pilot_id = gnome_config_get_int(tmp_str);
  pilot->pilot_username = gnome_config_get_string("pilotusername");
  pilot->passwd = gnome_config_get_string("password");
  pilot->number=i;
  pilot->trusted_users=NULL;
  tmp_str2 = gnome_config_get_string("default_sync_action=synchronize");
  pilot->sync_options.default_sync_action = gnome_pilot_conduit_sync_type_str_to_int(tmp_str2);
  g_free (tmp_str2);
  gnome_config_pop_prefix ();
}

void
gpilot_pilot_free (GPilotPilot *pilot)
{
  g_free (pilot->name);
  g_free (pilot->passwd);
  g_free (pilot->pilot_username);
  g_list_foreach (pilot->trusted_users, (GFunc) g_free, NULL);
  g_list_free (pilot->trusted_users);
  g_free (pilot);
}

GPilotUser *
gpilot_user_new (void) {
  GPilotUser *retval;

  retval = (GPilotUser *)g_malloc(sizeof(GPilotUser));
  retval->username = NULL;

  return retval;
}

void
gpilot_user_free (GPilotUser *user)
{
  g_free (user->username);
  g_free (user);
}
 
