/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

/* Owner:  miket */

#ifndef __AGUSERCONFIG_H__
#define __AGUSERCONFIG_H__

#include <AGArray.h>
#include <AGServerConfig.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/*  Note:  This data structure has been published to the world.
    If anything in it changes, it must remain compatible with previous
    versions.
*/
typedef struct AGUserConfig {

    AGBool dirty;
    int32 nextUID;
    AGBool resetCookiesAtNextSync;
    AGArray * servers;
    AGArray * serversToAdd;
    AGArray * serversToDelete;

} AGUserConfig;

typedef enum {
    AGUSERCONFIG_FIND,
    AGUSERCONFIG_CREATE,
    AGUSERCONFIG_CREATETEMP
} AGUserConfigFindMode;

typedef struct {
    int32 count, addCount;
} AGUserConfigEnumerateState;

ExportFunc AGUserConfig * AGUserConfigNew();
ExportFunc void AGUserConfigInit(AGUserConfig * serverList);
ExportFunc void AGUserConfigFinalize(AGUserConfig * serverList);
ExportFunc void AGUserConfigFree(AGUserConfig * serverList);

ExportFunc AGUserConfig *AGUserConfigCopy(AGUserConfig *dstConfig, 
                                          AGUserConfig *srcConfig);
ExportFunc AGUserConfig *AGUserConfigDup(AGUserConfig *srcConfig);

ExportFunc int32 AGUserConfigCount(AGUserConfig * serverList);
ExportFunc int32 AGUserConfigAddServer(AGUserConfig * serverList,
                                       AGServerConfig * serverConfig);
ExportFunc int32 AGUserConfigAddServerToDevice(AGUserConfig * userConfig,
                                               AGServerConfig * serverConfig);
ExportFunc int32 AGUserConfigAddServerToDesktop(AGUserConfig * userConfig,
                                                AGServerConfig * serverConfig);
ExportFunc void AGUserConfigRemoveServerFromDesktop(AGUserConfig * userConfig,
                                                    char * serverName,
                                                    int16 serverPort);
ExportFunc void AGUserConfigRemoveServerFromDevice(AGUserConfig * userConfig,
                                                   char * serverName,
                                                   int16 serverPort);
ExportFunc AGServerConfig *
AGUserConfigEnumerate(AGUserConfig * userConfig,
                      AGUserConfigEnumerateState ** state);
ExportFunc void AGUserConfigRemoveServer(AGUserConfig * serverList,
                                         AGServerConfig * serverConfig);
ExportFunc AGServerConfig *
AGUserConfigGetServerByIndex(AGUserConfig * serverList,
                             int32 index);
ExportFunc AGServerConfig *
AGUserConfigGetServerByUID(AGUserConfig * serverList,
                           int32 uid,
                           AGUserConfigFindMode mode);
ExportFunc AGServerConfig * 
AGUserConfigGetServerByName(AGUserConfig * userConfig,
                            char * serverName,
                            AGUserConfigFindMode mode);
ExportFunc AGServerConfig *
AGUserConfigGetServerByNameAndPort(AGUserConfig * userConfig,
                                   char * servername,
                                   int32 port,
                                   AGUserConfigFindMode mode);
ExportFunc void AGUserConfigReadData(AGUserConfig * serverList, AGReader *r);
ExportFunc AGUserConfig * AGUserConfigNewAndReadData(AGReader *r);
ExportFunc AGUserConfig *
AGUserConfigInitAndReadData(AGUserConfig * userConfig,
                            AGReader *r);
ExportFunc void AGUserConfigWriteData(AGUserConfig * serverList, AGWriter *w);
#ifndef REMOVE_SYNCHRONIZE_FEATURE
ExportFunc AGUserConfig * AGUserConfigSynchronize(AGUserConfig *agreed,
                                                  AGUserConfig *device,
                                                  AGUserConfig *desktop);
#endif                                                  
ExportFunc void AGUserConfigResetCookies(AGUserConfig *config);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* of #ifndef __AGUSERCONFIG_H__ */
