/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

#ifndef __AGTYPES_H__
#define __AGTYPES_H__


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifdef _WIN32
#define ExportFunc __declspec( dllexport )
#else
#define ExportFunc
#endif /* _WIN32 */

#ifdef _WIN32
#define ImportFunc __declspec(dllimport)
#else
#define ImportFunc
#endif

#ifndef __palmos__
/* Standard scalar types */

#ifndef PROTYPES_H
/* The Netscape portable runtime (NSPR) package also defines scalar types int<n>
 * and uint<n>, so we avoid defining these types when PROTYPES_H is defined.
 */
typedef char             int8;
typedef short            int16;
typedef int              int32;

#ifndef _CDGLOBAL_H_
/* The SSLPlus library defines these (but oddly enough not the int*
   typedefs)
*/
typedef unsigned char    uint8;
typedef unsigned short   uint16;
typedef unsigned int     uint32;
#endif /* _CDGLOBAL_H_ */

#endif /* PROTYPES_H */

typedef int 			 sword;
typedef unsigned int 	 uword;

typedef int AGBool;
#else
/* Standard scalar types for __palmos__ */
#ifndef PROTYPES_H
typedef char             int8;
typedef short            int16;
typedef long             int32;
 
#ifndef _CDGLOBAL_H_
/* The SSLPlus library defines these (but oddly enough not the int*
   typedefs)
*/
typedef unsigned char    uint8;
typedef unsigned short   uint16;
typedef unsigned long    uint32;
#endif /* _CDGLOBAL_H_ */

#endif /* PROTYPES_H */

typedef short 			 sword;
typedef unsigned short 	 uword;

typedef int AGBool;
#endif /* !__palmos__ */

#ifdef FALSE
#undef FALSE
#endif /* FALSE */

#define FALSE 0

#ifdef TRUE
#undef TRUE
#endif /* TRUE */

#define TRUE 1

#ifdef NULL
#undef NULL
#endif /* NULL */

#define NULL 0

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __AGTYPES_H__ */

