/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributor(s):
 */

// Owner:  miket

#include <AGLocationConfig.h>
#include <AGUtil.h>

/* Version 0 - original creation */
#define RECORD_VERSION_0 (0)

/* Version 1 - added secure proxy server address/port */
#define RECORD_VERSION_1 (1)

/* This is the version number that is written to new records */
#define CURRENT_RECORD_VERSION (RECORD_VERSION_1)

void AGLocationConfigInit(AGLocationConfig * locationConfig)
{
    if (NULL != locationConfig)
        bzero(locationConfig, sizeof(AGLocationConfig));
}

void AGLocationConfigFinalize(AGLocationConfig * locationConfig)
{
    if (NULL != locationConfig) {

        int n;

        if (NULL != locationConfig->HTTPName)
            free(locationConfig->HTTPName);

        if (NULL != locationConfig->HTTPUsername)
            free(locationConfig->HTTPUsername);

        if (NULL != locationConfig->HTTPPassword)
            free(locationConfig->HTTPPassword);

        if (NULL != locationConfig->SOCKSName)
            free(locationConfig->SOCKSName);

        if (NULL != locationConfig->SecureName)
            free(locationConfig->SecureName);

        if (NULL != locationConfig->exclusionServers) {
            n = AGArrayCount(locationConfig->exclusionServers);
            while (n--)
                free(AGArrayElementAt(locationConfig->exclusionServers, n));
            AGArrayRemoveAll(locationConfig->exclusionServers);
            AGArrayFree(locationConfig->exclusionServers);
        }

        if (NULL != locationConfig->autoConfigProxyURL)
            free(locationConfig->autoConfigProxyURL);

        bzero(locationConfig, sizeof(AGLocationConfig));
    }
}

AGLocationConfig * AGLocationConfigNew(void)
{
    AGLocationConfig * result = (AGLocationConfig *)malloc(sizeof(AGLocationConfig));
    if (NULL == result)
        return NULL;

    AGLocationConfigInit(result);

    return result;
}

void AGLocationConfigFree(AGLocationConfig * locationConfig)
{
    if (NULL != locationConfig) {
        AGLocationConfigFinalize(locationConfig);
        free(locationConfig);
    }
}

/* ----------------------------------------------------------------------------
    void AGLocationConfigReadData(AGLocationConfig * locationConfig,
    AGReader * r)

    Note to future developers:  do not change the order in which the ReadData
    and WriteData handle fields.  Every time you add a field, add another
    record version and update the CURRENT_RECORD_VERSION macro.  Then read
    conditionally according to what the record's version is.
    
*/
void AGLocationConfigReadData(AGLocationConfig * locationConfig, AGReader * r)
{
    int n;
    int16 version;

    version = AGReadCompactInt(r);
    locationConfig->source = (AGLocationConfigSource)AGReadCompactInt(r);
    locationConfig->HTTPUseProxy = AGReadBoolean(r);
    locationConfig->HTTPName = AGReadCString(r);
    locationConfig->HTTPPort = AGReadInt16(r);
    locationConfig->HTTPUseAuthentication = AGReadBoolean(r);
    locationConfig->HTTPUsername = AGReadCString(r);
    locationConfig->HTTPPassword = AGReadCString(r);
    locationConfig->SOCKSUseProxy = AGReadBoolean(r);
    locationConfig->SOCKSName = AGReadCString(r);
    locationConfig->SOCKSPort = AGReadInt16(r);
    locationConfig->exclusionServers =
        AGArrayNew(AGUnownedPointerElements, 0);
    n = AGReadCompactInt(r);
    while (n--) {
        char * domain = AGReadCString(r);
        AGArrayAppend(locationConfig->exclusionServers, domain);
    }
    locationConfig->bypassLocal = AGReadBoolean(r);
    locationConfig->autoConfigProxyURL = AGReadCString(r);

    if (RECORD_VERSION_0 == version) {
        locationConfig->SecureName = NULL;
        locationConfig->SecurePort = 0;
    }
    else {
        locationConfig->SecureName = AGReadCString(r);
        locationConfig->SecurePort = AGReadInt16(r);
    }
}

AGLocationConfig * AGLocationConfigNewAndReadData(AGReader * r)
{
    AGLocationConfig * result;

    result = (AGLocationConfig *)malloc(sizeof(AGLocationConfig));
    if (NULL != result) {
        bzero(result, sizeof(AGLocationConfig));
        AGLocationConfigReadData(result, r);
    }
    return result;
}

void AGLocationConfigWriteData(AGLocationConfig * locationConfig, AGWriter * w)
{
    int i, n;
    AGWriteCompactInt(w, CURRENT_RECORD_VERSION);
    AGWriteCompactInt(w, locationConfig->source);
    AGWriteBoolean(w, locationConfig->HTTPUseProxy);
    AGWriteCString(w, locationConfig->HTTPName);
    AGWriteInt16(w, (uint16)locationConfig->HTTPPort);
    AGWriteBoolean(w, locationConfig->HTTPUseAuthentication);
    AGWriteCString(w, locationConfig->HTTPUsername);
    AGWriteCString(w, locationConfig->HTTPPassword);
    AGWriteBoolean(w, locationConfig->SOCKSUseProxy);
    AGWriteCString(w, locationConfig->SOCKSName);
    AGWriteInt16(w, (uint16)locationConfig->SOCKSPort);
    n = AGArrayCount(locationConfig->exclusionServers);
    AGWriteCompactInt(w, n);
    for (i = 0; i < n; ++i)
        AGWriteCString(w, (char*)
            AGArrayElementAt(locationConfig->exclusionServers, i));
    AGWriteBoolean(w, locationConfig->bypassLocal);
    AGWriteCString(w, locationConfig->autoConfigProxyURL);
    AGWriteCString(w, locationConfig->SecureName);
    AGWriteInt16(w, (uint16)locationConfig->SecurePort);
}