#include "obgtkSpinButton.h"

@implementation Gtk_SpinButton
- castGtkSpinButton:(GtkSpinButton *) castitem
{
  gtkspinbutton = castitem;
  return [super castGtkEntry:GTK_ENTRY(castitem)];
}

- initWithSpinInfo:(id) adjustment
		  :(gfloat) climb_rate
		  :(gint) digits
{
  return [self castGtkSpinButton:GTK_SPIN_BUTTON(gtk_spin_button_new(GTK_ADJUSTMENT([adjustment getGtkObject]), climb_rate, digits))];
}

- set_adjustment:(id) adjustment
{
  gtk_spin_button_set_adjustment(gtkspinbutton,
				 GTK_ADJUSTMENT([adjustment getGtkObject]));

  return self;
}

- (id) get_adjustment
{
  return (id)gtk_object_get_data_by_id(GTK_OBJECT(gtk_spin_button_get_adjustment(gtkspinbutton)), OBJC_ID());
}

- set_digits:(gint) digits
{
  gtk_spin_button_set_digits(gtkspinbutton, digits);
  return self;
}

- (gfloat) get_value_as_float
{
  return gtk_spin_button_get_value_as_float(gtkspinbutton);
}

- (gint) get_value_as_int
{
  return gtk_spin_button_get_value_as_int(gtkspinbutton);
}

- set_value:(gfloat) value
{
  gtk_spin_button_set_value(gtkspinbutton, value);
  return self;
}

- set_update_policy:(GtkSpinButtonUpdatePolicy) policy
{
  gtk_spin_button_set_update_policy(gtkspinbutton, policy);
  return self;
}

- set_numeric:(gint) numeric
{
  gtk_spin_button_set_numeric(gtkspinbutton, numeric);
  return self;
}

- spin:(guint) direction :(gfloat) step
{
  gtk_spin_button_spin(gtkspinbutton, direction, step);
  return self;
}

- set_wrap:(gint) wrap
{
  gtk_spin_button_set_wrap(gtkspinbutton, wrap);
  return self;
}
@end
