#include "obgtkRange.h"

@implementation Gtk_Range
- castGtkRange:(GtkRange *) castitem
{
  gtkrange = castitem;
  return [super castGtkWidget:GTK_WIDGET(castitem)];
}

- (Gtk_Adjustment *) get_adjustment
{
  return [[Gtk_Adjustment alloc] castGtkAdjustment:GTK_ADJUSTMENT(gtk_range_get_adjustment(gtkrange))];
}

- set_update_policy:(GtkUpdateType) policy
{
  gtk_range_set_update_policy(gtkrange, policy);
  return self;
}

- set_adjustment:(Gtk_Adjustment *) adjustment
{
  gtk_range_set_adjustment(gtkrange, adjustment->gtkadjustment);
  return self;  
}

- draw_background
{
  gtk_range_draw_background(gtkrange);
  return self;
}

- draw_trough
{
  gtk_range_draw_trough(gtkrange);
  return self;
}

- draw_slider
{
  gtk_range_draw_slider(gtkrange);
  return self;
}

- draw_step_forward
{
  gtk_range_draw_step_forw(gtkrange);
  return self;
}

- draw_step_backward
{
  gtk_range_draw_step_back(gtkrange);
  return self;
}

- slider_update
{
  gtk_range_slider_update(gtkrange);
  return self;
}

- trough_click:(gint) x
	      :(gint) y
	      :(gfloat *) jump_perc
{
  gtk_range_trough_click(gtkrange, x, y, jump_perc);
  return self;
}

- default_hslider_update
{
  gtk_range_default_hslider_update(gtkrange);
  return self;
}

- default_vslider_update
{
  gtk_range_default_vslider_update(gtkrange);
  return self;
}

- default_htrough_click:(gint) x
		       :(gint) y
		       :(gfloat *) jump_perc
{
  gtk_range_default_htrough_click(gtkrange, x, y, jump_perc);
  return self;
}

- default_vtrough_click:(gint) x
		       :(gint) y
		       :(gfloat *) jump_perc
{
  gtk_range_default_vtrough_click(gtkrange, x, y, jump_perc);
  return self;
}

- default_hmotion:(gint) xdelta
		 :(gint) ydelta
{
  gtk_range_default_hmotion(gtkrange, xdelta, ydelta);

  return self;
}

- default_vmotion:(gint) xdelta
		 :(gint) ydelta
{
  gtk_range_default_vmotion(gtkrange, xdelta, ydelta);
  return self;
}
@end
