#include "obgtkCurve.h"

@implementation Gtk_Curve
- castGtkCurve:(GtkCurve *)castitem
{
  gtkcurve = castitem;
  return [super castGtkDrawingArea:GTK_DRAWING_AREA(castitem)];
}

- init
{
  gtkcurve = GTK_CURVE(gtk_curve_new());
  return [super castGtkDrawingArea:GTK_DRAWING_AREA(gtkcurve)];
}

- reset
{
  gtk_curve_reset(gtkcurve);
  return self;
}

- set_gamma:(gfloat) gamma
{
  gtk_curve_set_gamma(gtkcurve, gamma);
  return self;
}

- set_range:(gfloat) min_x
       maxX:(gfloat) max_x
       minY:(gfloat) min_y
       maxY:(gfloat) max_y
{
  gtk_curve_set_range(gtkcurve, min_x, max_x,
		      min_y, max_y);
  return self;
}

- get_vector:(int) veclen
   getVector:(gfloat *) vector
{
  gtk_curve_get_vector(gtkcurve, veclen, vector);
  return self;
}

- set_vector:(int) veclen
   getVector:(gfloat *) vector
{
  gtk_curve_set_vector(gtkcurve, veclen, vector);
  return self;
}

- set_curve_type:(GtkCurveType)type
{
  gtk_curve_set_curve_type(gtkcurve, type);
  return self;
}

@end
