/* warp.c generated by valac 0.44.6, the Vala compiler
 * generated from warp.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* This is a fairly literal translation of the GPLv2+ original by*/
/* Sean MacIsaac, Ian Peters, Guillaume Béland.*/

#include <glib-object.h>
#include <glib.h>
#include <gee.h>

#define TYPE_WARP (warp_get_type ())
#define WARP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP, Warp))
#define WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP, WarpClass))
#define IS_WARP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP))
#define IS_WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP))
#define WARP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP, WarpClass))

typedef struct _Warp Warp;
typedef struct _WarpClass WarpClass;
typedef struct _WarpPrivate WarpPrivate;
enum  {
	WARP_0_PROPERTY,
	WARP_NUM_PROPERTIES
};
static GParamSpec* warp_properties[WARP_NUM_PROPERTIES];

#define TYPE_WARP_MANAGER (warp_manager_get_type ())
#define WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP_MANAGER, WarpManager))
#define WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP_MANAGER, WarpManagerClass))
#define IS_WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP_MANAGER))
#define IS_WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP_MANAGER))
#define WARP_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP_MANAGER, WarpManagerClass))

typedef struct _WarpManager WarpManager;
typedef struct _WarpManagerClass WarpManagerClass;
typedef struct _WarpManagerPrivate WarpManagerPrivate;
enum  {
	WARP_MANAGER_0_PROPERTY,
	WARP_MANAGER_NUM_PROPERTIES
};
static GParamSpec* warp_manager_properties[WARP_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	WARP_MANAGER_WARP_ADDED_SIGNAL,
	WARP_MANAGER_NUM_SIGNALS
};
static guint warp_manager_signals[WARP_MANAGER_NUM_SIGNALS] = {0};

struct _Warp {
	GObject parent_instance;
	WarpPrivate * priv;
	gint x;
	gint y;
	gint wx;
	gint wy;
};

struct _WarpClass {
	GObjectClass parent_class;
};

struct _WarpManager {
	GObject parent_instance;
	WarpManagerPrivate * priv;
	GeeLinkedList* warps;
};

struct _WarpManagerClass {
	GObjectClass parent_class;
};

static gpointer warp_parent_class = NULL;
static gpointer warp_manager_parent_class = NULL;

GType warp_get_type (void) G_GNUC_CONST;
Warp* warp_new (gint x,
                gint y,
                gint wx,
                gint wy);
Warp* warp_construct (GType object_type,
                      gint x,
                      gint y,
                      gint wx,
                      gint wy);
static void warp_finalize (GObject * obj);
GType warp_manager_get_type (void) G_GNUC_CONST;
#define WARP_MANAGER_MAX_WARPS 200
WarpManager* warp_manager_new (void);
WarpManager* warp_manager_construct (GType object_type);
void warp_manager_add_warp (WarpManager* self,
                            gint* board,
                            gint board_length1,
                            gint board_length2,
                            gint x,
                            gint y,
                            gint wx,
                            gint wy);
#define NIBBLES_GAME_WARPCHAR 'W'
Warp* warp_manager_get_warp (WarpManager* self,
                             gint x,
                             gint y);
static void warp_manager_finalize (GObject * obj);

Warp*
warp_construct (GType object_type,
                gint x,
                gint y,
                gint wx,
                gint wy)
{
	Warp * self = NULL;
#line 30 "warp.vala"
	self = (Warp*) g_object_new (object_type, NULL);
#line 32 "warp.vala"
	self->x = x;
#line 33 "warp.vala"
	self->y = y;
#line 35 "warp.vala"
	self->wx = wx;
#line 36 "warp.vala"
	self->wy = wy;
#line 30 "warp.vala"
	return self;
#line 142 "warp.c"
}

Warp*
warp_new (gint x,
          gint y,
          gint wx,
          gint wy)
{
#line 30 "warp.vala"
	return warp_construct (TYPE_WARP, x, y, wx, wy);
#line 153 "warp.c"
}

static void
warp_class_init (WarpClass * klass,
                 gpointer klass_data)
{
#line 22 "warp.vala"
	warp_parent_class = g_type_class_peek_parent (klass);
#line 22 "warp.vala"
	G_OBJECT_CLASS (klass)->finalize = warp_finalize;
#line 164 "warp.c"
}

static void
warp_instance_init (Warp * self,
                    gpointer klass)
{
}

static void
warp_finalize (GObject * obj)
{
	Warp * self;
#line 22 "warp.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WARP, Warp);
#line 22 "warp.vala"
	G_OBJECT_CLASS (warp_parent_class)->finalize (obj);
#line 181 "warp.c"
}

GType
warp_get_type (void)
{
	static volatile gsize warp_type_id__volatile = 0;
	if (g_once_init_enter (&warp_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WarpClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) warp_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Warp), 0, (GInstanceInitFunc) warp_instance_init, NULL };
		GType warp_type_id;
		warp_type_id = g_type_register_static (G_TYPE_OBJECT, "Warp", &g_define_type_info, 0);
		g_once_init_leave (&warp_type_id__volatile, warp_type_id);
	}
	return warp_type_id__volatile;
}

WarpManager*
warp_manager_construct (GType object_type)
{
	WarpManager * self = NULL;
	GeeLinkedList* _tmp0_;
#line 48 "warp.vala"
	self = (WarpManager*) g_object_new (object_type, NULL);
#line 50 "warp.vala"
	_tmp0_ = gee_linked_list_new (TYPE_WARP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 50 "warp.vala"
	_g_object_unref0 (self->warps);
#line 50 "warp.vala"
	self->warps = _tmp0_;
#line 48 "warp.vala"
	return self;
#line 212 "warp.c"
}

WarpManager*
warp_manager_new (void)
{
#line 48 "warp.vala"
	return warp_manager_construct (TYPE_WARP_MANAGER);
#line 220 "warp.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 59 "warp.vala"
	return self ? g_object_ref (self) : NULL;
#line 228 "warp.c"
}

void
warp_manager_add_warp (WarpManager* self,
                       gint* board,
                       gint board_length1,
                       gint board_length2,
                       gint x,
                       gint y,
                       gint wx,
                       gint wy)
{
	gboolean add = FALSE;
#line 53 "warp.vala"
	g_return_if_fail (self != NULL);
#line 55 "warp.vala"
	add = TRUE;
#line 57 "warp.vala"
	if (x < 0) {
#line 248 "warp.c"
		GeeLinkedList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		GeeLinkedList* _tmp13_;
		Warp* _tmp14_;
		Warp* _tmp15_;
		{
			GeeLinkedList* _warp_list = NULL;
			GeeLinkedList* _tmp0_;
			GeeLinkedList* _tmp1_;
			gint _warp_size = 0;
			GeeLinkedList* _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _warp_index = 0;
#line 59 "warp.vala"
			_tmp0_ = self->warps;
#line 59 "warp.vala"
			_tmp1_ = _g_object_ref0 (_tmp0_);
#line 59 "warp.vala"
			_warp_list = _tmp1_;
#line 59 "warp.vala"
			_tmp2_ = _warp_list;
#line 59 "warp.vala"
			_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 59 "warp.vala"
			_tmp4_ = _tmp3_;
#line 59 "warp.vala"
			_warp_size = _tmp4_;
#line 59 "warp.vala"
			_warp_index = -1;
#line 59 "warp.vala"
			while (TRUE) {
#line 282 "warp.c"
				Warp* warp = NULL;
				GeeLinkedList* _tmp5_;
				gpointer _tmp6_;
				Warp* _tmp7_;
#line 59 "warp.vala"
				_warp_index = _warp_index + 1;
#line 59 "warp.vala"
				if (!(_warp_index < _warp_size)) {
#line 59 "warp.vala"
					break;
#line 293 "warp.c"
				}
#line 59 "warp.vala"
				_tmp5_ = _warp_list;
#line 59 "warp.vala"
				_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _warp_index);
#line 59 "warp.vala"
				warp = (Warp*) _tmp6_;
#line 61 "warp.vala"
				_tmp7_ = warp;
#line 61 "warp.vala"
				if (_tmp7_->wx == x) {
#line 305 "warp.c"
					Warp* _tmp8_;
					Warp* _tmp9_;
#line 63 "warp.vala"
					_tmp8_ = warp;
#line 63 "warp.vala"
					_tmp8_->wx = wx;
#line 64 "warp.vala"
					_tmp9_ = warp;
#line 64 "warp.vala"
					_tmp9_->wy = wy;
#line 65 "warp.vala"
					_g_object_unref0 (warp);
#line 65 "warp.vala"
					_g_object_unref0 (_warp_list);
#line 65 "warp.vala"
					return;
#line 322 "warp.c"
				}
#line 59 "warp.vala"
				_g_object_unref0 (warp);
#line 326 "warp.c"
			}
#line 59 "warp.vala"
			_g_object_unref0 (_warp_list);
#line 330 "warp.c"
		}
#line 69 "warp.vala"
		_tmp10_ = self->warps;
#line 69 "warp.vala"
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
#line 69 "warp.vala"
		_tmp12_ = _tmp11_;
#line 69 "warp.vala"
		if (_tmp12_ == WARP_MANAGER_MAX_WARPS) {
#line 70 "warp.vala"
			return;
#line 342 "warp.c"
		}
#line 72 "warp.vala"
		_tmp13_ = self->warps;
#line 72 "warp.vala"
		_tmp14_ = warp_new (x, y, wx, wy);
#line 72 "warp.vala"
		_tmp15_ = _tmp14_;
#line 72 "warp.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
#line 72 "warp.vala"
		_g_object_unref0 (_tmp15_);
#line 354 "warp.c"
	} else {
		{
			GeeLinkedList* _warp_list = NULL;
			GeeLinkedList* _tmp16_;
			GeeLinkedList* _tmp17_;
			gint _warp_size = 0;
			GeeLinkedList* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint _warp_index = 0;
#line 76 "warp.vala"
			_tmp16_ = self->warps;
#line 76 "warp.vala"
			_tmp17_ = _g_object_ref0 (_tmp16_);
#line 76 "warp.vala"
			_warp_list = _tmp17_;
#line 76 "warp.vala"
			_tmp18_ = _warp_list;
#line 76 "warp.vala"
			_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
#line 76 "warp.vala"
			_tmp20_ = _tmp19_;
#line 76 "warp.vala"
			_warp_size = _tmp20_;
#line 76 "warp.vala"
			_warp_index = -1;
#line 76 "warp.vala"
			while (TRUE) {
#line 383 "warp.c"
				Warp* warp = NULL;
				GeeLinkedList* _tmp21_;
				gpointer _tmp22_;
				Warp* _tmp23_;
#line 76 "warp.vala"
				_warp_index = _warp_index + 1;
#line 76 "warp.vala"
				if (!(_warp_index < _warp_size)) {
#line 76 "warp.vala"
					break;
#line 394 "warp.c"
				}
#line 76 "warp.vala"
				_tmp21_ = _warp_list;
#line 76 "warp.vala"
				_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _warp_index);
#line 76 "warp.vala"
				warp = (Warp*) _tmp22_;
#line 78 "warp.vala"
				_tmp23_ = warp;
#line 78 "warp.vala"
				if (_tmp23_->x == wx) {
#line 406 "warp.c"
					Warp* _tmp24_;
					Warp* _tmp25_;
					Warp* _tmp26_;
#line 80 "warp.vala"
					_tmp24_ = warp;
#line 80 "warp.vala"
					_tmp24_->x = x;
#line 81 "warp.vala"
					_tmp25_ = warp;
#line 81 "warp.vala"
					_tmp25_->y = y;
#line 82 "warp.vala"
					add = FALSE;
#line 84 "warp.vala"
					_tmp26_ = warp;
#line 84 "warp.vala"
					g_signal_emit (self, warp_manager_signals[WARP_MANAGER_WARP_ADDED_SIGNAL], 0, _tmp26_);
#line 424 "warp.c"
				}
#line 76 "warp.vala"
				_g_object_unref0 (warp);
#line 428 "warp.c"
			}
#line 76 "warp.vala"
			_g_object_unref0 (_warp_list);
#line 432 "warp.c"
		}
#line 88 "warp.vala"
		if (add) {
#line 436 "warp.c"
			GeeLinkedList* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			Warp* warp = NULL;
			Warp* _tmp30_;
			GeeLinkedList* _tmp31_;
			Warp* _tmp32_;
			Warp* _tmp33_;
#line 90 "warp.vala"
			_tmp27_ = self->warps;
#line 90 "warp.vala"
			_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp27_);
#line 90 "warp.vala"
			_tmp29_ = _tmp28_;
#line 90 "warp.vala"
			if (_tmp29_ == WARP_MANAGER_MAX_WARPS) {
#line 91 "warp.vala"
				return;
#line 455 "warp.c"
			}
#line 93 "warp.vala"
			_tmp30_ = warp_new (x, y, wx, wy);
#line 93 "warp.vala"
			warp = _tmp30_;
#line 94 "warp.vala"
			_tmp31_ = self->warps;
#line 94 "warp.vala"
			_tmp32_ = warp;
#line 94 "warp.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, _tmp32_);
#line 96 "warp.vala"
			_tmp33_ = warp;
#line 96 "warp.vala"
			g_signal_emit (self, warp_manager_signals[WARP_MANAGER_WARP_ADDED_SIGNAL], 0, _tmp33_);
#line 88 "warp.vala"
			_g_object_unref0 (warp);
#line 473 "warp.c"
		}
#line 99 "warp.vala"
		board[(x * board_length2) + y] = (gint) NIBBLES_GAME_WARPCHAR;
#line 100 "warp.vala"
		board[((x + 1) * board_length2) + y] = (gint) NIBBLES_GAME_WARPCHAR;
#line 101 "warp.vala"
		board[(x * board_length2) + (y + 1)] = (gint) NIBBLES_GAME_WARPCHAR;
#line 102 "warp.vala"
		board[((x + 1) * board_length2) + (y + 1)] = (gint) NIBBLES_GAME_WARPCHAR;
#line 483 "warp.c"
	}
}

Warp*
warp_manager_get_warp (WarpManager* self,
                       gint x,
                       gint y)
{
	Warp* result = NULL;
#line 106 "warp.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 495 "warp.c"
	{
		GeeLinkedList* _warp_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _warp_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _warp_index = 0;
#line 108 "warp.vala"
		_tmp0_ = self->warps;
#line 108 "warp.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 108 "warp.vala"
		_warp_list = _tmp1_;
#line 108 "warp.vala"
		_tmp2_ = _warp_list;
#line 108 "warp.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 108 "warp.vala"
		_tmp4_ = _tmp3_;
#line 108 "warp.vala"
		_warp_size = _tmp4_;
#line 108 "warp.vala"
		_warp_index = -1;
#line 108 "warp.vala"
		while (TRUE) {
#line 523 "warp.c"
			Warp* warp = NULL;
			GeeLinkedList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			Warp* _tmp11_;
#line 108 "warp.vala"
			_warp_index = _warp_index + 1;
#line 108 "warp.vala"
			if (!(_warp_index < _warp_size)) {
#line 108 "warp.vala"
				break;
#line 538 "warp.c"
			}
#line 108 "warp.vala"
			_tmp5_ = _warp_list;
#line 108 "warp.vala"
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _warp_index);
#line 108 "warp.vala"
			warp = (Warp*) _tmp6_;
#line 110 "warp.vala"
			_tmp11_ = warp;
#line 110 "warp.vala"
			if (x == _tmp11_->x) {
#line 550 "warp.c"
				Warp* _tmp12_;
#line 110 "warp.vala"
				_tmp12_ = warp;
#line 110 "warp.vala"
				_tmp10_ = y == _tmp12_->y;
#line 556 "warp.c"
			} else {
#line 110 "warp.vala"
				_tmp10_ = FALSE;
#line 560 "warp.c"
			}
#line 110 "warp.vala"
			if (_tmp10_) {
#line 110 "warp.vala"
				_tmp9_ = TRUE;
#line 566 "warp.c"
			} else {
				gboolean _tmp13_ = FALSE;
				Warp* _tmp14_;
#line 111 "warp.vala"
				_tmp14_ = warp;
#line 111 "warp.vala"
				if (x == (_tmp14_->x + 1)) {
#line 574 "warp.c"
					Warp* _tmp15_;
#line 111 "warp.vala"
					_tmp15_ = warp;
#line 111 "warp.vala"
					_tmp13_ = y == _tmp15_->y;
#line 580 "warp.c"
				} else {
#line 111 "warp.vala"
					_tmp13_ = FALSE;
#line 584 "warp.c"
				}
#line 111 "warp.vala"
				_tmp9_ = _tmp13_;
#line 588 "warp.c"
			}
#line 110 "warp.vala"
			if (_tmp9_) {
#line 110 "warp.vala"
				_tmp8_ = TRUE;
#line 594 "warp.c"
			} else {
				gboolean _tmp16_ = FALSE;
				Warp* _tmp17_;
#line 112 "warp.vala"
				_tmp17_ = warp;
#line 112 "warp.vala"
				if (x == _tmp17_->x) {
#line 602 "warp.c"
					Warp* _tmp18_;
#line 112 "warp.vala"
					_tmp18_ = warp;
#line 112 "warp.vala"
					_tmp16_ = y == (_tmp18_->y + 1);
#line 608 "warp.c"
				} else {
#line 112 "warp.vala"
					_tmp16_ = FALSE;
#line 612 "warp.c"
				}
#line 112 "warp.vala"
				_tmp8_ = _tmp16_;
#line 616 "warp.c"
			}
#line 110 "warp.vala"
			if (_tmp8_) {
#line 110 "warp.vala"
				_tmp7_ = TRUE;
#line 622 "warp.c"
			} else {
				gboolean _tmp19_ = FALSE;
				Warp* _tmp20_;
#line 113 "warp.vala"
				_tmp20_ = warp;
#line 113 "warp.vala"
				if (x == (_tmp20_->x + 1)) {
#line 630 "warp.c"
					Warp* _tmp21_;
#line 113 "warp.vala"
					_tmp21_ = warp;
#line 113 "warp.vala"
					_tmp19_ = y == (_tmp21_->y + 1);
#line 636 "warp.c"
				} else {
#line 113 "warp.vala"
					_tmp19_ = FALSE;
#line 640 "warp.c"
				}
#line 113 "warp.vala"
				_tmp7_ = _tmp19_;
#line 644 "warp.c"
			}
#line 110 "warp.vala"
			if (_tmp7_) {
#line 114 "warp.vala"
				result = warp;
#line 114 "warp.vala"
				_g_object_unref0 (_warp_list);
#line 114 "warp.vala"
				return result;
#line 654 "warp.c"
			}
#line 108 "warp.vala"
			_g_object_unref0 (warp);
#line 658 "warp.c"
		}
#line 108 "warp.vala"
		_g_object_unref0 (_warp_list);
#line 662 "warp.c"
	}
#line 117 "warp.vala"
	result = NULL;
#line 117 "warp.vala"
	return result;
#line 668 "warp.c"
}

static void
warp_manager_class_init (WarpManagerClass * klass,
                         gpointer klass_data)
{
#line 40 "warp.vala"
	warp_manager_parent_class = g_type_class_peek_parent (klass);
#line 40 "warp.vala"
	G_OBJECT_CLASS (klass)->finalize = warp_manager_finalize;
#line 40 "warp.vala"
	warp_manager_signals[WARP_MANAGER_WARP_ADDED_SIGNAL] = g_signal_new ("warp-added", TYPE_WARP_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_WARP);
#line 681 "warp.c"
}

static void
warp_manager_instance_init (WarpManager * self,
                            gpointer klass)
{
}

static void
warp_manager_finalize (GObject * obj)
{
	WarpManager * self;
#line 40 "warp.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WARP_MANAGER, WarpManager);
#line 44 "warp.vala"
	_g_object_unref0 (self->warps);
#line 40 "warp.vala"
	G_OBJECT_CLASS (warp_manager_parent_class)->finalize (obj);
#line 700 "warp.c"
}

GType
warp_manager_get_type (void)
{
	static volatile gsize warp_manager_type_id__volatile = 0;
	if (g_once_init_enter (&warp_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WarpManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) warp_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WarpManager), 0, (GInstanceInitFunc) warp_manager_instance_init, NULL };
		GType warp_manager_type_id;
		warp_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "WarpManager", &g_define_type_info, 0);
		g_once_init_leave (&warp_manager_type_id__volatile, warp_manager_type_id);
	}
	return warp_manager_type_id__volatile;
}

