/* gnome-nibbles.c generated by valac 0.44.6, the Vala compiler
 * generated from gnome-nibbles.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <clutter-gtk/clutter-gtk.h>
#include <libgnome-games-support.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <pango/pango.h>

#define TYPE_NIBBLES (nibbles_get_type ())
#define NIBBLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES, Nibbles))
#define NIBBLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES, NibblesClass))
#define IS_NIBBLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES))
#define IS_NIBBLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES))
#define NIBBLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES, NibblesClass))

typedef struct _Nibbles Nibbles;
typedef struct _NibblesClass NibblesClass;
typedef struct _NibblesPrivate NibblesPrivate;

#define TYPE_SCOREBOARD (scoreboard_get_type ())
#define SCOREBOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCOREBOARD, Scoreboard))
#define SCOREBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCOREBOARD, ScoreboardClass))
#define IS_SCOREBOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCOREBOARD))
#define IS_SCOREBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCOREBOARD))
#define SCOREBOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCOREBOARD, ScoreboardClass))

typedef struct _Scoreboard Scoreboard;
typedef struct _ScoreboardClass ScoreboardClass;

#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;

#define TYPE_NIBBLES_VIEW (nibbles_view_get_type ())
#define NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_VIEW, NibblesView))
#define NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_VIEW, NibblesViewClass))
#define IS_NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_VIEW))
#define IS_NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_VIEW))
#define NIBBLES_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_VIEW, NibblesViewClass))

typedef struct _NibblesView NibblesView;
typedef struct _NibblesViewClass NibblesViewClass;

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
enum  {
	NIBBLES_0_PROPERTY,
	NIBBLES_NUM_PROPERTIES
};
static GParamSpec* nibbles_properties[NIBBLES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _NibblesViewPrivate NibblesViewPrivate;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
typedef struct _WormProperties WormProperties;
#define _worm_properties_free0(var) ((var == NULL) ? NULL : (var = (worm_properties_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _WormPrivate WormPrivate;
typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP
} WormDirection;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())

#define TYPE_CONTROLS_GRID (controls_grid_get_type ())
#define CONTROLS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTROLS_GRID, ControlsGrid))
#define CONTROLS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTROLS_GRID, ControlsGridClass))
#define IS_CONTROLS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTROLS_GRID))
#define IS_CONTROLS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTROLS_GRID))
#define CONTROLS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTROLS_GRID, ControlsGridClass))

typedef struct _ControlsGrid ControlsGrid;
typedef struct _ControlsGridClass ControlsGridClass;
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _ScoreboardPrivate ScoreboardPrivate;

#define TYPE_PLAYER_SCORE_BOX (player_score_box_get_type ())
#define PLAYER_SCORE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_SCORE_BOX, PlayerScoreBox))
#define PLAYER_SCORE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_SCORE_BOX, PlayerScoreBoxClass))
#define IS_PLAYER_SCORE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_SCORE_BOX))
#define IS_PLAYER_SCORE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_SCORE_BOX))
#define PLAYER_SCORE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_SCORE_BOX, PlayerScoreBoxClass))

typedef struct _PlayerScoreBox PlayerScoreBox;
typedef struct _PlayerScoreBoxClass PlayerScoreBoxClass;
enum  {
	SCOREBOARD_0_PROPERTY,
	SCOREBOARD_NUM_PROPERTIES
};
static GParamSpec* scoreboard_properties[SCOREBOARD_NUM_PROPERTIES];
typedef struct _PlayerScoreBoxPrivate PlayerScoreBoxPrivate;
enum  {
	PLAYER_SCORE_BOX_0_PROPERTY,
	PLAYER_SCORE_BOX_NUM_PROPERTIES
};
static GParamSpec* player_score_box_properties[PLAYER_SCORE_BOX_NUM_PROPERTIES];
typedef struct _ControlsGridPrivate ControlsGridPrivate;
enum  {
	CONTROLS_GRID_0_PROPERTY,
	CONTROLS_GRID_NUM_PROPERTIES
};
static GParamSpec* controls_grid_properties[CONTROLS_GRID_NUM_PROPERTIES];

struct _Nibbles {
	GtkApplication parent_instance;
	NibblesPrivate * priv;
};

struct _NibblesClass {
	GtkApplicationClass parent_class;
};

struct _NibblesPrivate {
	GSettings* settings;
	GeeArrayList* worm_settings;
	GtkApplicationWindow* window;
	gboolean is_maximized;
	gboolean is_tiled;
	gint window_width;
	gint window_height;
	GtkStack* main_stack;
	GtkOverlay* overlay;
	GtkHeaderBar* headerbar;
	GtkButton* new_game_button;
	GtkButton* pause_button;
	GeeLinkedList* number_of_players_buttons;
	GeeLinkedList* number_of_ai_buttons;
	GtkButton* next_button;
	GtkButton* start_button;
	GtkBox* grids_box;
	GdkPixbuf* arrow_pixbuf;
	GdkPixbuf* arrow_key_pixbuf;
	GtkStack* statusbar_stack;
	GtkLabel* countdown;
	Scoreboard* scoreboard;
	GdkPixbuf* scoreboard_life;
	PreferencesDialog* preferences_dialog;
	NibblesView* view;
	GtkBox* game_box;
	GamesGridFrame* frame;
	NibblesGame* game;
	GamesScoresContext* scores_context;
	GeeLinkedList* scorecats;
	GSimpleAction* new_game_action;
	GSimpleAction* pause_action;
	GSimpleAction* back_action;
	guint countdown_id;
	gint seconds;
};

struct _NibblesView {
	GtkClutterEmbed parent_instance;
	NibblesViewPrivate * priv;
	gboolean is_muted;
};

struct _NibblesViewClass {
	GtkClutterEmbedClass parent_class;
};

struct _WormProperties {
	gint color;
	guint up;
	guint down;
	guint left;
	guint right;
};

struct _Block1Data {
	int _ref_count_;
	Nibbles* self;
	GtkMessageDialog* dialog;
};

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gboolean is_stopped;
	gint change;
	WormDirection direction;
	WormDirection starting_direction;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	Nibbles* self;
	glong lowest_high_score;
	gint score;
	gint level_reached;
};

struct _Block3Data {
	int _ref_count_;
	Nibbles* self;
	GtkLabel* label;
	GtkButton* button;
};

struct _Block4Data {
	int _ref_count_;
	Nibbles* self;
	gboolean should_unpause;
};

struct _Block5Data {
	int _ref_count_;
	Nibbles* self;
	GtkLabel* game_over_label;
	GtkLabel* msg_label;
	GtkLabel* score_label;
	GtkLabel* points_left_label;
	GtkButton* button;
};

struct _Scoreboard {
	GtkBox parent_instance;
	ScoreboardPrivate * priv;
};

struct _ScoreboardClass {
	GtkBoxClass parent_class;
};

struct _ScoreboardPrivate {
	GeeHashMap* boxes;
};

struct _PlayerScoreBox {
	GtkBox parent_instance;
	PlayerScoreBoxPrivate * priv;
};

struct _PlayerScoreBoxClass {
	GtkBoxClass parent_class;
};

struct _PlayerScoreBoxPrivate {
	GtkLabel* name_label;
	GtkLabel* score_label;
	GtkGrid* lives_grid;
	GeeLinkedList* life_images;
};

struct _ControlsGrid {
	GtkGrid parent_instance;
	ControlsGridPrivate * priv;
};

struct _ControlsGridClass {
	GtkGridClass parent_class;
};

struct _ControlsGridPrivate {
	GtkLabel* name_label;
	GtkImage* arrow_up;
	GtkImage* arrow_down;
	GtkImage* arrow_left;
	GtkImage* arrow_right;
	GtkOverlay* move_up;
	GtkLabel* move_up_label;
	GtkOverlay* move_down;
	GtkLabel* move_down_label;
	GtkOverlay* move_left;
	GtkLabel* move_left_label;
	GtkOverlay* move_right;
	GtkLabel* move_right_label;
};

static gint Nibbles_private_offset;
static gpointer nibbles_parent_class = NULL;
static gint Scoreboard_private_offset;
static gpointer scoreboard_parent_class = NULL;
static gint PlayerScoreBox_private_offset;
static gpointer player_score_box_parent_class = NULL;
static gint ControlsGrid_private_offset;
static gpointer controls_grid_parent_class = NULL;

GType nibbles_get_type (void) G_GNUC_CONST;
GType scoreboard_get_type (void) G_GNUC_CONST;
GType preferences_dialog_get_type (void) G_GNUC_CONST;
GType nibbles_view_get_type (void) G_GNUC_CONST;
GType nibbles_game_get_type (void) G_GNUC_CONST;
#define NIBBLES_COUNTDOWN_TIME 3
static void nibbles_start_game_cb (Nibbles* self);
static void _nibbles_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void nibbles_new_game_cb (Nibbles* self);
static void _nibbles_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void nibbles_pause_cb (Nibbles* self);
static void _nibbles_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void nibbles_preferences_cb (Nibbles* self);
static void _nibbles_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void nibbles_scores_cb (Nibbles* self);
static void _nibbles_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self);
static void nibbles_help_cb (Nibbles* self);
static void _nibbles_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self);
static void nibbles_about_cb (Nibbles* self);
static void _nibbles_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void nibbles_show_new_game_screen_cb (Nibbles* self);
static void _nibbles_show_new_game_screen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void nibbles_show_controls_screen_cb (Nibbles* self);
static void _nibbles_show_controls_screen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void nibbles_back_cb (Nibbles* self);
static void _nibbles_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self);
Nibbles* nibbles_new (void);
Nibbles* nibbles_construct (GType object_type);
static gint nibbles_real_handle_local_options (GApplication* base,
                                        GVariantDict* options);
static void nibbles_real_startup (GApplication* base);
static void nibbles_settings_changed_cb (Nibbles* self,
                                  const gchar* key);
static void _nibbles_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                      const gchar* key,
                                                      gpointer self);
#define NIBBLES_GAME_MAX_WORMS 6
static void nibbles_worm_settings_changed_cb (Nibbles* self,
                                       GSettings* changed_worm_settings,
                                       const gchar* key);
static void _nibbles_worm_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                           const gchar* key,
                                                           gpointer self);
static void nibbles_size_allocate_cb (Nibbles* self,
                               GtkAllocation* allocation);
static void _nibbles_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                         GtkAllocation* allocation,
                                                         gpointer self);
static gboolean nibbles_window_state_event_cb (Nibbles* self,
                                        GdkEventWindowState* event);
static gboolean _nibbles_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                       GdkEventWindowState* event,
                                                                       gpointer self);
static gboolean nibbles_key_press_event_cb (Nibbles* self,
                                     GtkWidget* widget,
                                     GdkEventKey* event);
static gboolean _nibbles_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                 GdkEventKey* event,
                                                                 gpointer self);
#define NIBBLES_GAME_MAX_HUMANS 4
static void nibbles_change_number_of_players_cb (Nibbles* self,
                                          GtkToggleButton* button);
static void _nibbles_change_number_of_players_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                     gpointer self);
#define NIBBLES_GAME_MAX_AI 5
static void nibbles_change_number_of_ai_cb (Nibbles* self,
                                     GtkToggleButton* button);
static void _nibbles_change_number_of_ai_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                gpointer self);
NibblesGame* nibbles_game_new (GSettings* settings);
NibblesGame* nibbles_game_construct (GType object_type,
                                     GSettings* settings);
static void nibbles_log_score_cb (Nibbles* self,
                           gint score,
                           gint level_reached);
static void _nibbles_log_score_cb_nibbles_game_log_score (NibblesGame* _sender,
                                                   gint score,
                                                   gint level_reached,
                                                   gpointer self);
static void nibbles_level_completed_cb (Nibbles* self);
static void _nibbles_level_completed_cb_nibbles_game_level_completed (NibblesGame* _sender,
                                                               gpointer self);
static void __lambda13_ (Nibbles* self);
gboolean nibbles_game_get_is_paused (NibblesGame* self);
static void ___lambda13__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
NibblesView* nibbles_view_new (NibblesGame* game);
NibblesView* nibbles_view_construct (GType object_type,
                                     NibblesGame* game);
static gboolean nibbles_configure_event_cb (Nibbles* self,
                                     GdkEventConfigure* event);
static gboolean _nibbles_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender,
                                                                 GdkEventConfigure* event,
                                                                 gpointer self);
#define NIBBLES_GAME_WIDTH 92
#define NIBBLES_GAME_HEIGHT 66
Scoreboard* scoreboard_new (void);
Scoreboard* scoreboard_construct (GType object_type);
GdkPixbuf* nibbles_view_load_pixmap_file (NibblesView* self,
                                          const gchar* pixmap,
                                          gint xsize,
                                          gint ysize);
gint nibbles_game_get_tile_size (NibblesGame* self);
void nibbles_game_set_numhumans (NibblesGame* self,
                                 gint value);
void nibbles_game_set_numai (NibblesGame* self,
                             gint value);
static void nibbles_show_first_run_screen (Nibbles* self);
static void nibbles_create_scores (Nibbles* self);
static void nibbles_real_activate (GApplication* base);
static void nibbles_real_shutdown (GApplication* base);
void nibbles_game_save_properties (NibblesGame* self,
                                   GSettings* settings);
static gboolean nibbles_countdown_cb (Nibbles* self);
ClutterActor* nibbles_view_get_name_labels (NibblesView* self);
void nibbles_game_add_bonus (NibblesGame* self,
                             gboolean regular);
void nibbles_game_start (NibblesGame* self);
gboolean nibbles_game_handle_keypress (NibblesGame* self,
                                       guint keyval);
void nibbles_view_board_rescale (NibblesView* self,
                                 gint tile_size);
void nibbles_view_boni_rescale (NibblesView* self,
                                gint tile_size);
void nibbles_view_warps_rescale (NibblesView* self,
                                 gint tile_size);
GType worm_get_type (void) G_GNUC_CONST;
GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
void nibbles_game_set_tile_size (NibblesGame* self,
                                 gint value);
void nibbles_game_reset (NibblesGame* self);
void nibbles_view_new_level (NibblesView* self,
                             gint level);
gint nibbles_game_get_current_level (NibblesGame* self);
void nibbles_view_connect_worm_signals (NibblesView* self);
void scoreboard_clear (Scoreboard* self);
GType worm_properties_get_type (void) G_GNUC_CONST;
WormProperties* worm_properties_dup (const WormProperties* self);
void worm_properties_free (WormProperties* self);
GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
void scoreboard_register (Scoreboard* self,
                          Worm* worm,
                          const gchar* color_name,
                          GdkPixbuf* life_pixbuf);
gchar* nibbles_view_colorval_name (gint colorval);
void scoreboard_update (Scoreboard* self);
static void _scoreboard_update_g_object_notify (GObject* _sender,
                                         GParamSpec* pspec,
                                         gpointer self);
void nibbles_game_add_worms (NibblesGame* self);
void nibbles_view_create_name_labels (NibblesView* self);
static void nibbles_show_game_view (Nibbles* self);
static void nibbles_start_game_with_countdown (Nibbles* self);
static gboolean _nibbles_countdown_cb_gsource_func (gpointer self);
static void nibbles_restart_game (Nibbles* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
gboolean nibbles_game_get_is_running (NibblesGame* self);
void nibbles_game_stop (NibblesGame* self);
static void __lambda7_ (Block1Data* _data1_,
                 gint response_id);
static void ___lambda7__gtk_dialog_response (GtkDialog* _sender,
                                      gint response_id,
                                      gpointer self);
void nibbles_game_pause (NibblesGame* self);
void nibbles_game_unpause (NibblesGame* self);
void nibbles_game_set_speed (NibblesGame* self,
                             gint value);
void nibbles_game_set_fakes (NibblesGame* self,
                             gboolean value);
gint nibbles_game_get_numworms (NibblesGame* self);
gint nibbles_game_get_numhumans (NibblesGame* self);
gint nibbles_game_get_numai (NibblesGame* self);
void nibbles_game_create_worms (NibblesGame* self);
void nibbles_game_load_worm_properties (NibblesGame* self,
                                        GeeArrayList* worm_settings);
GType worm_direction_get_type (void) G_GNUC_CONST;
GType controls_grid_get_type (void) G_GNUC_CONST;
gint worm_get_id (Worm* self);
ControlsGrid* controls_grid_new (gint worm_id,
                                 WormProperties* worm_props,
                                 GdkPixbuf* arrow,
                                 GdkPixbuf* arrow_key);
ControlsGrid* controls_grid_construct (GType object_type,
                                       gint worm_id,
                                       WormProperties* worm_props,
                                       GdkPixbuf* arrow,
                                       GdkPixbuf* arrow_key);
static GamesScoresCategory* nibbles_category_request (Nibbles* self,
                                               const gchar* key);
static gchar* nibbles_get_new_scores_key (Nibbles* self,
                                   const gchar* old_key);
static GamesScoresCategory* _nibbles_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                                           gpointer self);
static gchar* _nibbles_get_new_scores_key_games_scores_directory_importer_category_convert_func (const gchar* old_key,
                                                                                          gpointer self);
static GamesScoresCategory* nibbles_get_scores_category (Nibbles* self,
                                                  gint speed,
                                                  gboolean fakes);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
gint nibbles_game_get_speed (NibblesGame* self);
gboolean nibbles_game_get_fakes (NibblesGame* self);
static void nibbles_game_over (Nibbles* self,
                        gint score,
                        glong lowest_high_score,
                        gint level_reached);
gint nibbles_game_get_start_level (NibblesGame* self);
static void __lambda10_ (Block2Data* _data2_,
                  GObject* object,
                  GAsyncResult* _result_);
static void ___lambda10__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
#define NIBBLES_GAME_MAX_LEVEL 26
static void __lambda11_ (Block3Data* _data3_);
static void ___lambda11__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static gboolean __lambda12_ (Block3Data* _data3_);
static gboolean ___lambda12__gsource_func (gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
PreferencesDialog* preferences_dialog_new (GtkApplicationWindow* window,
                                           GSettings* settings,
                                           GeeArrayList* worm_settings);
PreferencesDialog* preferences_dialog_construct (GType object_type,
                                                 GtkApplicationWindow* window,
                                                 GSettings* settings,
                                                 GeeArrayList* worm_settings);
static void __lambda8_ (Block4Data* _data4_);
static void ___lambda8__gtk_widget_destroy (GtkWidget* _sender,
                                     gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda9_ (Block5Data* _data5_);
static void ___lambda9__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
gint nibbles_main (gchar** args,
                   gint args_length1);
static void nibbles_finalize (GObject * obj);
GType player_score_box_get_type (void) G_GNUC_CONST;
gint worm_get_score (Worm* self);
gint worm_get_lives (Worm* self);
PlayerScoreBox* player_score_box_new (const gchar* name,
                                      PangoColor* color,
                                      gint score,
                                      gint lives_left,
                                      GdkPixbuf* life_pixbuf);
PlayerScoreBox* player_score_box_construct (GType object_type,
                                            const gchar* name,
                                            PangoColor* color,
                                            gint score,
                                            gint lives_left,
                                            GdkPixbuf* life_pixbuf);
void player_score_box_update (PlayerScoreBox* self,
                              gint score,
                              gint lives_left);
static void scoreboard_finalize (GObject * obj);
#define WORM_MAX_LIVES 12
#define WORM_STARTING_LIVES 6
void player_score_box_update_score (PlayerScoreBox* self,
                                    gint score);
void player_score_box_update_lives (PlayerScoreBox* self,
                                    gint lives_left);
static void player_score_box_finalize (GObject * obj);
static void controls_grid_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry NIBBLES_action_entries[8] = {{"start-game", _nibbles_start_game_cb_gsimple_action_activate_callback}, {"new-game", _nibbles_new_game_cb_gsimple_action_activate_callback}, {"pause", _nibbles_pause_cb_gsimple_action_activate_callback}, {"preferences", _nibbles_preferences_cb_gsimple_action_activate_callback}, {"scores", _nibbles_scores_cb_gsimple_action_activate_callback}, {"help", _nibbles_help_cb_gsimple_action_activate_callback}, {"about", _nibbles_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};
static const GActionEntry NIBBLES_menu_entries[3] = {{"show-new-game-screen", _nibbles_show_new_game_screen_cb_gsimple_action_activate_callback}, {"show-controls-screen", _nibbles_show_controls_screen_cb_gsimple_action_activate_callback}, {"back", _nibbles_back_cb_gsimple_action_activate_callback}};
static const GOptionEntry NIBBLES_option_entries[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, N_ ("Show release version"), NULL}, {NULL}};

static inline gpointer
nibbles_get_instance_private (Nibbles* self)
{
	return G_STRUCT_MEMBER_P (self, Nibbles_private_offset);
}

static void
_nibbles_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
#line 81 "gnome-nibbles.vala"
	nibbles_start_game_cb ((Nibbles*) self);
#line 665 "gnome-nibbles.c"
}

static void
_nibbles_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
#line 81 "gnome-nibbles.vala"
	nibbles_new_game_cb ((Nibbles*) self);
#line 675 "gnome-nibbles.c"
}

static void
_nibbles_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
#line 81 "gnome-nibbles.vala"
	nibbles_pause_cb ((Nibbles*) self);
#line 685 "gnome-nibbles.c"
}

static void
_nibbles_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
#line 81 "gnome-nibbles.vala"
	nibbles_preferences_cb ((Nibbles*) self);
#line 695 "gnome-nibbles.c"
}

static void
_nibbles_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                     GVariant* parameter,
                                                     gpointer self)
{
#line 81 "gnome-nibbles.vala"
	nibbles_scores_cb ((Nibbles*) self);
#line 705 "gnome-nibbles.c"
}

static void
_nibbles_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                   GVariant* parameter,
                                                   gpointer self)
{
#line 81 "gnome-nibbles.vala"
	nibbles_help_cb ((Nibbles*) self);
#line 715 "gnome-nibbles.c"
}

static void
_nibbles_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
#line 81 "gnome-nibbles.vala"
	nibbles_about_cb ((Nibbles*) self);
#line 725 "gnome-nibbles.c"
}

static void
_g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
#line 81 "gnome-nibbles.vala"
	g_application_quit ((GApplication*) self);
#line 735 "gnome-nibbles.c"
}

static void
_nibbles_show_new_game_screen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
#line 93 "gnome-nibbles.vala"
	nibbles_show_new_game_screen_cb ((Nibbles*) self);
#line 745 "gnome-nibbles.c"
}

static void
_nibbles_show_controls_screen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
#line 93 "gnome-nibbles.vala"
	nibbles_show_controls_screen_cb ((Nibbles*) self);
#line 755 "gnome-nibbles.c"
}

static void
_nibbles_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                   GVariant* parameter,
                                                   gpointer self)
{
#line 93 "gnome-nibbles.vala"
	nibbles_back_cb ((Nibbles*) self);
#line 765 "gnome-nibbles.c"
}

Nibbles*
nibbles_construct (GType object_type)
{
	Nibbles * self = NULL;
#line 111 "gnome-nibbles.vala"
	self = (Nibbles*) g_object_new (object_type, "application-id", "org.gnome.Nibbles", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 113 "gnome-nibbles.vala"
	g_application_add_main_option_entries ((GApplication*) self, NIBBLES_option_entries);
#line 109 "gnome-nibbles.vala"
	return self;
#line 778 "gnome-nibbles.c"
}

Nibbles*
nibbles_new (void)
{
#line 109 "gnome-nibbles.vala"
	return nibbles_construct (TYPE_NIBBLES);
#line 786 "gnome-nibbles.c"
}

static gint
nibbles_real_handle_local_options (GApplication* base,
                                   GVariantDict* options)
{
	Nibbles * self;
	gint result = 0;
#line 116 "gnome-nibbles.vala"
	self = (Nibbles*) base;
#line 116 "gnome-nibbles.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 118 "gnome-nibbles.vala"
	if (g_variant_dict_contains (options, "version")) {
#line 801 "gnome-nibbles.c"
		FILE* _tmp0_;
#line 121 "gnome-nibbles.vala"
		_tmp0_ = stderr;
#line 121 "gnome-nibbles.vala"
		fprintf (_tmp0_, "gnome-nibbles %s\n", VERSION);
#line 122 "gnome-nibbles.vala"
		result = EXIT_SUCCESS;
#line 122 "gnome-nibbles.vala"
		return result;
#line 811 "gnome-nibbles.c"
	}
#line 126 "gnome-nibbles.vala"
	result = -1;
#line 126 "gnome-nibbles.vala"
	return result;
#line 817 "gnome-nibbles.c"
}

static void
_nibbles_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                 const gchar* key,
                                                 gpointer self)
{
#line 151 "gnome-nibbles.vala"
	nibbles_settings_changed_cb ((Nibbles*) self, key);
#line 827 "gnome-nibbles.c"
}

static void
_nibbles_worm_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                      const gchar* key,
                                                      gpointer self)
{
#line 158 "gnome-nibbles.vala"
	nibbles_worm_settings_changed_cb ((Nibbles*) self, _sender, key);
#line 837 "gnome-nibbles.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 164 "gnome-nibbles.vala"
	return self ? g_object_ref (self) : NULL;
#line 845 "gnome-nibbles.c"
}

static void
_nibbles_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                    GtkAllocation* allocation,
                                                    gpointer self)
{
#line 170 "gnome-nibbles.vala"
	nibbles_size_allocate_cb ((Nibbles*) self, allocation);
#line 855 "gnome-nibbles.c"
}

static gboolean
_nibbles_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender,
                                                              GdkEventWindowState* event,
                                                              gpointer self)
{
	gboolean result;
	result = nibbles_window_state_event_cb ((Nibbles*) self, event);
#line 171 "gnome-nibbles.vala"
	return result;
#line 867 "gnome-nibbles.c"
}

static gboolean
_nibbles_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender,
                                                        GdkEventKey* event,
                                                        gpointer self)
{
	gboolean result;
	result = nibbles_key_press_event_cb ((Nibbles*) self, _sender, event);
#line 172 "gnome-nibbles.vala"
	return result;
#line 879 "gnome-nibbles.c"
}

static void
_nibbles_change_number_of_players_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                gpointer self)
{
#line 189 "gnome-nibbles.vala"
	nibbles_change_number_of_players_cb ((Nibbles*) self, _sender);
#line 888 "gnome-nibbles.c"
}

static void
_nibbles_change_number_of_ai_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                           gpointer self)
{
#line 196 "gnome-nibbles.vala"
	nibbles_change_number_of_ai_cb ((Nibbles*) self, _sender);
#line 897 "gnome-nibbles.c"
}

static void
_nibbles_log_score_cb_nibbles_game_log_score (NibblesGame* _sender,
                                              gint score,
                                              gint level_reached,
                                              gpointer self)
{
#line 208 "gnome-nibbles.vala"
	nibbles_log_score_cb ((Nibbles*) self, score, level_reached);
#line 908 "gnome-nibbles.c"
}

static void
_nibbles_level_completed_cb_nibbles_game_level_completed (NibblesGame* _sender,
                                                          gpointer self)
{
#line 209 "gnome-nibbles.vala"
	nibbles_level_completed_cb ((Nibbles*) self);
#line 917 "gnome-nibbles.c"
}

static void
__lambda13_ (Nibbles* self)
{
	NibblesGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 211 "gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 211 "gnome-nibbles.vala"
	_tmp1_ = nibbles_game_get_is_paused (_tmp0_);
#line 211 "gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 211 "gnome-nibbles.vala"
	if (_tmp2_) {
#line 934 "gnome-nibbles.c"
		GtkStack* _tmp3_;
#line 212 "gnome-nibbles.vala"
		_tmp3_ = self->priv->statusbar_stack;
#line 212 "gnome-nibbles.vala"
		gtk_stack_set_visible_child_name (_tmp3_, "paused");
#line 940 "gnome-nibbles.c"
	} else {
		GtkStack* _tmp4_;
#line 214 "gnome-nibbles.vala"
		_tmp4_ = self->priv->statusbar_stack;
#line 214 "gnome-nibbles.vala"
		gtk_stack_set_visible_child_name (_tmp4_, "scoreboard");
#line 947 "gnome-nibbles.c"
	}
}

static void
___lambda13__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 210 "gnome-nibbles.vala"
	__lambda13_ ((Nibbles*) self);
#line 958 "gnome-nibbles.c"
}

static gboolean
_nibbles_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender,
                                                        GdkEventConfigure* event,
                                                        gpointer self)
{
	gboolean result;
	result = nibbles_configure_event_cb ((Nibbles*) self, event);
#line 219 "gnome-nibbles.vala"
	return result;
#line 970 "gnome-nibbles.c"
}

static void
nibbles_real_startup (GApplication* base)
{
	Nibbles * self;
	gchar** argv = NULL;
	gint argv_length1;
	gint _argv_size_;
	GtkSettings* _tmp0_;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp1_;
	GtkCssProvider* _tmp2_;
	GdkScreen* _tmp3_;
	GtkCssProvider* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GeeArrayList* _tmp7_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	GAction* _tmp27_;
	GSimpleAction* _tmp28_;
	GAction* _tmp29_;
	GSimpleAction* _tmp30_;
	GAction* _tmp31_;
	GSimpleAction* _tmp32_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp33_;
	GtkBuilder* _tmp34_;
	GObject* _tmp35_;
	GtkApplicationWindow* _tmp36_;
	GtkApplicationWindow* _tmp37_;
	GtkApplicationWindow* _tmp38_;
	GtkApplicationWindow* _tmp39_;
	GtkApplicationWindow* _tmp40_;
	GSettings* _tmp41_;
	GSettings* _tmp42_;
	GSettings* _tmp43_;
	GtkBuilder* _tmp45_;
	GObject* _tmp46_;
	GtkHeaderBar* _tmp47_;
	GtkBuilder* _tmp48_;
	GObject* _tmp49_;
	GtkOverlay* _tmp50_;
	GtkBuilder* _tmp51_;
	GObject* _tmp52_;
	GtkButton* _tmp53_;
	GtkBuilder* _tmp54_;
	GObject* _tmp55_;
	GtkButton* _tmp56_;
	GtkBuilder* _tmp57_;
	GObject* _tmp58_;
	GtkStack* _tmp59_;
	GtkBuilder* _tmp60_;
	GObject* _tmp61_;
	GtkBox* _tmp62_;
	GtkBuilder* _tmp63_;
	GObject* _tmp64_;
	GtkStack* _tmp65_;
	GtkBuilder* _tmp66_;
	GObject* _tmp67_;
	GtkLabel* _tmp68_;
	GeeLinkedList* _tmp69_;
	GeeLinkedList* _tmp81_;
	GtkBuilder* _tmp93_;
	GObject* _tmp94_;
	GtkButton* _tmp95_;
	GtkBuilder* _tmp96_;
	GObject* _tmp97_;
	GtkButton* _tmp98_;
	GtkBuilder* _tmp99_;
	GObject* _tmp100_;
	GtkBox* _tmp101_;
	GtkApplicationWindow* _tmp102_;
	GtkHeaderBar* _tmp103_;
	GtkApplicationWindow* _tmp104_;
	GSettings* _tmp105_;
	NibblesGame* _tmp106_;
	NibblesGame* _tmp107_;
	NibblesGame* _tmp108_;
	NibblesGame* _tmp109_;
	NibblesGame* _tmp110_;
	NibblesView* _tmp111_;
	NibblesView* _tmp112_;
	NibblesView* _tmp113_;
	GSettings* _tmp114_;
	NibblesView* _tmp115_;
	GamesGridFrame* _tmp116_;
	GtkBox* _tmp117_;
	GamesGridFrame* _tmp118_;
	Scoreboard* _tmp119_;
	NibblesView* _tmp120_;
	NibblesGame* _tmp121_;
	gint _tmp122_;
	gint _tmp123_;
	NibblesGame* _tmp124_;
	gint _tmp125_;
	gint _tmp126_;
	GdkPixbuf* _tmp127_;
	Scoreboard* _tmp128_;
	GtkStack* _tmp129_;
	Scoreboard* _tmp130_;
	GamesGridFrame* _tmp131_;
	NibblesView* _tmp132_;
	GamesGridFrame* _tmp133_;
	NibblesGame* _tmp134_;
	GSettings* _tmp135_;
	NibblesGame* _tmp136_;
	GSettings* _tmp137_;
	NibblesView* _tmp138_;
	NibblesGame* _tmp139_;
	gint _tmp140_;
	gint _tmp141_;
	NibblesGame* _tmp142_;
	gint _tmp143_;
	gint _tmp144_;
	GdkPixbuf* _tmp145_;
	NibblesView* _tmp146_;
	NibblesGame* _tmp147_;
	gint _tmp148_;
	gint _tmp149_;
	NibblesGame* _tmp150_;
	gint _tmp151_;
	gint _tmp152_;
	GdkPixbuf* _tmp153_;
	gboolean first_run = FALSE;
	GSettings* _tmp154_;
	GtkApplicationWindow* _tmp155_;
#line 129 "gnome-nibbles.vala"
	self = (Nibbles*) base;
#line 131 "gnome-nibbles.vala"
	G_APPLICATION_CLASS (nibbles_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 133 "gnome-nibbles.vala"
	argv = NULL;
#line 133 "gnome-nibbles.vala"
	argv_length1 = 0;
#line 133 "gnome-nibbles.vala"
	_argv_size_ = argv_length1;
#line 134 "gnome-nibbles.vala"
	gtk_clutter_init ((gint*) (&argv_length1), &argv);
#line 136 "gnome-nibbles.vala"
	g_set_prgname ("org.gnome.Nibbles");
#line 137 "gnome-nibbles.vala"
	g_set_application_name (_ ("Nibbles"));
#line 139 "gnome-nibbles.vala"
	gtk_window_set_default_icon_name ("gnome-nibbles");
#line 141 "gnome-nibbles.vala"
	_tmp0_ = gtk_settings_get_default ();
#line 141 "gnome-nibbles.vala"
	g_object_set ((GObject*) _tmp0_, "gtk-application-prefer-dark-theme", TRUE, NULL);
#line 143 "gnome-nibbles.vala"
	_tmp1_ = gtk_css_provider_new ();
#line 143 "gnome-nibbles.vala"
	css_provider = _tmp1_;
#line 144 "gnome-nibbles.vala"
	_tmp2_ = css_provider;
#line 144 "gnome-nibbles.vala"
	gtk_css_provider_load_from_resource (_tmp2_, "/org/gnome/nibbles/ui/nibbles.css");
#line 145 "gnome-nibbles.vala"
	_tmp3_ = gdk_screen_get_default ();
#line 145 "gnome-nibbles.vala"
	_tmp4_ = css_provider;
#line 145 "gnome-nibbles.vala"
	gtk_style_context_add_provider_for_screen (_tmp3_, (GtkStyleProvider*) _tmp4_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 147 "gnome-nibbles.vala"
	g_action_map_add_action_entries ((GActionMap*) self, NIBBLES_action_entries, (gint) G_N_ELEMENTS (NIBBLES_action_entries), self);
#line 148 "gnome-nibbles.vala"
	g_action_map_add_action_entries ((GActionMap*) self, NIBBLES_menu_entries, (gint) G_N_ELEMENTS (NIBBLES_menu_entries), self);
#line 150 "gnome-nibbles.vala"
	_tmp5_ = g_settings_new ("org.gnome.nibbles");
#line 150 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->settings);
#line 150 "gnome-nibbles.vala"
	self->priv->settings = _tmp5_;
#line 151 "gnome-nibbles.vala"
	_tmp6_ = self->priv->settings;
#line 151 "gnome-nibbles.vala"
	g_signal_connect_object (_tmp6_, "changed", (GCallback) _nibbles_settings_changed_cb_g_settings_changed, self, 0);
#line 153 "gnome-nibbles.vala"
	_tmp7_ = gee_array_list_new (g_settings_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 153 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->worm_settings);
#line 153 "gnome-nibbles.vala"
	self->priv->worm_settings = _tmp7_;
#line 1165 "gnome-nibbles.c"
	{
		gint i = 0;
#line 154 "gnome-nibbles.vala"
		i = 0;
#line 1170 "gnome-nibbles.c"
		{
			gboolean _tmp8_ = FALSE;
#line 154 "gnome-nibbles.vala"
			_tmp8_ = TRUE;
#line 154 "gnome-nibbles.vala"
			while (TRUE) {
#line 1177 "gnome-nibbles.c"
				gchar* name = NULL;
				gchar* _tmp10_;
				GeeArrayList* _tmp11_;
				const gchar* _tmp12_;
				GSettings* _tmp13_;
				GSettings* _tmp14_;
				GeeArrayList* _tmp15_;
				gpointer _tmp16_;
				GSettings* _tmp17_;
#line 154 "gnome-nibbles.vala"
				if (!_tmp8_) {
#line 1189 "gnome-nibbles.c"
					gint _tmp9_;
#line 154 "gnome-nibbles.vala"
					_tmp9_ = i;
#line 154 "gnome-nibbles.vala"
					i = _tmp9_ + 1;
#line 1195 "gnome-nibbles.c"
				}
#line 154 "gnome-nibbles.vala"
				_tmp8_ = FALSE;
#line 154 "gnome-nibbles.vala"
				if (!(i < NIBBLES_GAME_MAX_WORMS)) {
#line 154 "gnome-nibbles.vala"
					break;
#line 1203 "gnome-nibbles.c"
				}
#line 156 "gnome-nibbles.vala"
				_tmp10_ = g_strdup_printf ("org.gnome.nibbles.worm%d", i);
#line 156 "gnome-nibbles.vala"
				name = _tmp10_;
#line 157 "gnome-nibbles.vala"
				_tmp11_ = self->priv->worm_settings;
#line 157 "gnome-nibbles.vala"
				_tmp12_ = name;
#line 157 "gnome-nibbles.vala"
				_tmp13_ = g_settings_new (_tmp12_);
#line 157 "gnome-nibbles.vala"
				_tmp14_ = _tmp13_;
#line 157 "gnome-nibbles.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp14_);
#line 157 "gnome-nibbles.vala"
				_g_object_unref0 (_tmp14_);
#line 158 "gnome-nibbles.vala"
				_tmp15_ = self->priv->worm_settings;
#line 158 "gnome-nibbles.vala"
				_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, i);
#line 158 "gnome-nibbles.vala"
				_tmp17_ = (GSettings*) _tmp16_;
#line 158 "gnome-nibbles.vala"
				g_signal_connect_object (_tmp17_, "changed", (GCallback) _nibbles_worm_settings_changed_cb_g_settings_changed, self, 0);
#line 158 "gnome-nibbles.vala"
				_g_object_unref0 (_tmp17_);
#line 154 "gnome-nibbles.vala"
				_g_free0 (name);
#line 1233 "gnome-nibbles.c"
			}
		}
	}
#line 161 "gnome-nibbles.vala"
	_tmp18_ = g_strdup ("<Primary>q");
#line 161 "gnome-nibbles.vala"
	_tmp19_ = g_new0 (gchar*, 1 + 1);
#line 161 "gnome-nibbles.vala"
	_tmp19_[0] = _tmp18_;
#line 161 "gnome-nibbles.vala"
	_tmp20_ = _tmp19_;
#line 161 "gnome-nibbles.vala"
	_tmp20__length1 = 1;
#line 161 "gnome-nibbles.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp20_);
#line 161 "gnome-nibbles.vala"
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
#line 162 "gnome-nibbles.vala"
	_tmp21_ = g_strdup ("Escape");
#line 162 "gnome-nibbles.vala"
	_tmp22_ = g_new0 (gchar*, 1 + 1);
#line 162 "gnome-nibbles.vala"
	_tmp22_[0] = _tmp21_;
#line 162 "gnome-nibbles.vala"
	_tmp23_ = _tmp22_;
#line 162 "gnome-nibbles.vala"
	_tmp23__length1 = 1;
#line 162 "gnome-nibbles.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.back", _tmp23_);
#line 162 "gnome-nibbles.vala"
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
#line 163 "gnome-nibbles.vala"
	_tmp24_ = g_strdup ("F1");
#line 163 "gnome-nibbles.vala"
	_tmp25_ = g_new0 (gchar*, 1 + 1);
#line 163 "gnome-nibbles.vala"
	_tmp25_[0] = _tmp24_;
#line 163 "gnome-nibbles.vala"
	_tmp26_ = _tmp25_;
#line 163 "gnome-nibbles.vala"
	_tmp26__length1 = 1;
#line 163 "gnome-nibbles.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp26_);
#line 163 "gnome-nibbles.vala"
	_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
#line 164 "gnome-nibbles.vala"
	_tmp27_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
#line 164 "gnome-nibbles.vala"
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, g_simple_action_get_type (), GSimpleAction));
#line 164 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->new_game_action);
#line 164 "gnome-nibbles.vala"
	self->priv->new_game_action = _tmp28_;
#line 165 "gnome-nibbles.vala"
	_tmp29_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
#line 165 "gnome-nibbles.vala"
	_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, g_simple_action_get_type (), GSimpleAction));
#line 165 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->pause_action);
#line 165 "gnome-nibbles.vala"
	self->priv->pause_action = _tmp30_;
#line 166 "gnome-nibbles.vala"
	_tmp31_ = g_action_map_lookup_action ((GActionMap*) self, "back");
#line 166 "gnome-nibbles.vala"
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, g_simple_action_get_type (), GSimpleAction));
#line 166 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->back_action);
#line 166 "gnome-nibbles.vala"
	self->priv->back_action = _tmp32_;
#line 168 "gnome-nibbles.vala"
	_tmp33_ = gtk_builder_new_from_resource ("/org/gnome/nibbles/ui/nibbles.ui");
#line 168 "gnome-nibbles.vala"
	builder = _tmp33_;
#line 169 "gnome-nibbles.vala"
	_tmp34_ = builder;
#line 169 "gnome-nibbles.vala"
	_tmp35_ = gtk_builder_get_object (_tmp34_, "nibbles-window");
#line 169 "gnome-nibbles.vala"
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, gtk_application_window_get_type ()) ? ((GtkApplicationWindow*) _tmp35_) : NULL);
#line 169 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->window);
#line 169 "gnome-nibbles.vala"
	self->priv->window = _tmp36_;
#line 170 "gnome-nibbles.vala"
	_tmp37_ = self->priv->window;
#line 170 "gnome-nibbles.vala"
	g_signal_connect_object ((GtkWidget*) _tmp37_, "size-allocate", (GCallback) _nibbles_size_allocate_cb_gtk_widget_size_allocate, self, 0);
#line 171 "gnome-nibbles.vala"
	_tmp38_ = self->priv->window;
#line 171 "gnome-nibbles.vala"
	g_signal_connect_object ((GtkWidget*) _tmp38_, "window-state-event", (GCallback) _nibbles_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 172 "gnome-nibbles.vala"
	_tmp39_ = self->priv->window;
#line 172 "gnome-nibbles.vala"
	g_signal_connect_object ((GtkWidget*) _tmp39_, "key-press-event", (GCallback) _nibbles_key_press_event_cb_gtk_widget_key_press_event, self, 0);
#line 173 "gnome-nibbles.vala"
	_tmp40_ = self->priv->window;
#line 173 "gnome-nibbles.vala"
	_tmp41_ = self->priv->settings;
#line 173 "gnome-nibbles.vala"
	_tmp42_ = self->priv->settings;
#line 173 "gnome-nibbles.vala"
	gtk_window_set_default_size ((GtkWindow*) _tmp40_, g_settings_get_int (_tmp41_, "window-width"), g_settings_get_int (_tmp42_, "window-height"));
#line 174 "gnome-nibbles.vala"
	_tmp43_ = self->priv->settings;
#line 174 "gnome-nibbles.vala"
	if (g_settings_get_boolean (_tmp43_, "window-is-maximized")) {
#line 1341 "gnome-nibbles.c"
		GtkApplicationWindow* _tmp44_;
#line 175 "gnome-nibbles.vala"
		_tmp44_ = self->priv->window;
#line 175 "gnome-nibbles.vala"
		gtk_window_maximize ((GtkWindow*) _tmp44_);
#line 1347 "gnome-nibbles.c"
	}
#line 177 "gnome-nibbles.vala"
	_tmp45_ = builder;
#line 177 "gnome-nibbles.vala"
	_tmp46_ = gtk_builder_get_object (_tmp45_, "headerbar");
#line 177 "gnome-nibbles.vala"
	_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, gtk_header_bar_get_type (), GtkHeaderBar));
#line 177 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 177 "gnome-nibbles.vala"
	self->priv->headerbar = _tmp47_;
#line 178 "gnome-nibbles.vala"
	_tmp48_ = builder;
#line 178 "gnome-nibbles.vala"
	_tmp49_ = gtk_builder_get_object (_tmp48_, "main_overlay");
#line 178 "gnome-nibbles.vala"
	_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, gtk_overlay_get_type (), GtkOverlay));
#line 178 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->overlay);
#line 178 "gnome-nibbles.vala"
	self->priv->overlay = _tmp50_;
#line 179 "gnome-nibbles.vala"
	_tmp51_ = builder;
#line 179 "gnome-nibbles.vala"
	_tmp52_ = gtk_builder_get_object (_tmp51_, "new_game_button");
#line 179 "gnome-nibbles.vala"
	_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_button_get_type (), GtkButton));
#line 179 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->new_game_button);
#line 179 "gnome-nibbles.vala"
	self->priv->new_game_button = _tmp53_;
#line 180 "gnome-nibbles.vala"
	_tmp54_ = builder;
#line 180 "gnome-nibbles.vala"
	_tmp55_ = gtk_builder_get_object (_tmp54_, "pause_button");
#line 180 "gnome-nibbles.vala"
	_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, gtk_button_get_type (), GtkButton));
#line 180 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->pause_button);
#line 180 "gnome-nibbles.vala"
	self->priv->pause_button = _tmp56_;
#line 181 "gnome-nibbles.vala"
	_tmp57_ = builder;
#line 181 "gnome-nibbles.vala"
	_tmp58_ = gtk_builder_get_object (_tmp57_, "main_stack");
#line 181 "gnome-nibbles.vala"
	_tmp59_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_stack_get_type (), GtkStack));
#line 181 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 181 "gnome-nibbles.vala"
	self->priv->main_stack = _tmp59_;
#line 182 "gnome-nibbles.vala"
	_tmp60_ = builder;
#line 182 "gnome-nibbles.vala"
	_tmp61_ = gtk_builder_get_object (_tmp60_, "game_box");
#line 182 "gnome-nibbles.vala"
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, gtk_box_get_type (), GtkBox));
#line 182 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->game_box);
#line 182 "gnome-nibbles.vala"
	self->priv->game_box = _tmp62_;
#line 183 "gnome-nibbles.vala"
	_tmp63_ = builder;
#line 183 "gnome-nibbles.vala"
	_tmp64_ = gtk_builder_get_object (_tmp63_, "statusbar_stack");
#line 183 "gnome-nibbles.vala"
	_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, gtk_stack_get_type (), GtkStack));
#line 183 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->statusbar_stack);
#line 183 "gnome-nibbles.vala"
	self->priv->statusbar_stack = _tmp65_;
#line 184 "gnome-nibbles.vala"
	_tmp66_ = builder;
#line 184 "gnome-nibbles.vala"
	_tmp67_ = gtk_builder_get_object (_tmp66_, "countdown");
#line 184 "gnome-nibbles.vala"
	_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, gtk_label_get_type (), GtkLabel));
#line 184 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->countdown);
#line 184 "gnome-nibbles.vala"
	self->priv->countdown = _tmp68_;
#line 185 "gnome-nibbles.vala"
	_tmp69_ = gee_linked_list_new (gtk_toggle_button_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 185 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->number_of_players_buttons);
#line 185 "gnome-nibbles.vala"
	self->priv->number_of_players_buttons = _tmp69_;
#line 1435 "gnome-nibbles.c"
	{
		gint i = 0;
#line 186 "gnome-nibbles.vala"
		i = 0;
#line 1440 "gnome-nibbles.c"
		{
			gboolean _tmp70_ = FALSE;
#line 186 "gnome-nibbles.vala"
			_tmp70_ = TRUE;
#line 186 "gnome-nibbles.vala"
			while (TRUE) {
#line 1447 "gnome-nibbles.c"
				GtkToggleButton* button = NULL;
				GtkBuilder* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				GObject* _tmp75_;
				GtkToggleButton* _tmp76_;
				GtkToggleButton* _tmp77_;
				GtkToggleButton* _tmp78_;
				GeeLinkedList* _tmp79_;
				GtkToggleButton* _tmp80_;
#line 186 "gnome-nibbles.vala"
				if (!_tmp70_) {
#line 1460 "gnome-nibbles.c"
					gint _tmp71_;
#line 186 "gnome-nibbles.vala"
					_tmp71_ = i;
#line 186 "gnome-nibbles.vala"
					i = _tmp71_ + 1;
#line 1466 "gnome-nibbles.c"
				}
#line 186 "gnome-nibbles.vala"
				_tmp70_ = FALSE;
#line 186 "gnome-nibbles.vala"
				if (!(i < NIBBLES_GAME_MAX_HUMANS)) {
#line 186 "gnome-nibbles.vala"
					break;
#line 1474 "gnome-nibbles.c"
				}
#line 188 "gnome-nibbles.vala"
				_tmp72_ = builder;
#line 188 "gnome-nibbles.vala"
				_tmp73_ = g_strdup_printf ("players%d", i + 1);
#line 188 "gnome-nibbles.vala"
				_tmp74_ = _tmp73_;
#line 188 "gnome-nibbles.vala"
				_tmp75_ = gtk_builder_get_object (_tmp72_, _tmp74_);
#line 188 "gnome-nibbles.vala"
				_tmp76_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 188 "gnome-nibbles.vala"
				_tmp77_ = _tmp76_;
#line 188 "gnome-nibbles.vala"
				_g_free0 (_tmp74_);
#line 188 "gnome-nibbles.vala"
				button = _tmp77_;
#line 189 "gnome-nibbles.vala"
				_tmp78_ = button;
#line 189 "gnome-nibbles.vala"
				g_signal_connect_object (_tmp78_, "toggled", (GCallback) _nibbles_change_number_of_players_cb_gtk_toggle_button_toggled, self, 0);
#line 190 "gnome-nibbles.vala"
				_tmp79_ = self->priv->number_of_players_buttons;
#line 190 "gnome-nibbles.vala"
				_tmp80_ = button;
#line 190 "gnome-nibbles.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp79_, _tmp80_);
#line 186 "gnome-nibbles.vala"
				_g_object_unref0 (button);
#line 1504 "gnome-nibbles.c"
			}
		}
	}
#line 192 "gnome-nibbles.vala"
	_tmp81_ = gee_linked_list_new (gtk_toggle_button_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 192 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->number_of_ai_buttons);
#line 192 "gnome-nibbles.vala"
	self->priv->number_of_ai_buttons = _tmp81_;
#line 1514 "gnome-nibbles.c"
	{
		gint i = 0;
#line 193 "gnome-nibbles.vala"
		i = 0;
#line 1519 "gnome-nibbles.c"
		{
			gboolean _tmp82_ = FALSE;
#line 193 "gnome-nibbles.vala"
			_tmp82_ = TRUE;
#line 193 "gnome-nibbles.vala"
			while (TRUE) {
#line 1526 "gnome-nibbles.c"
				GtkToggleButton* button = NULL;
				GtkBuilder* _tmp84_;
				gchar* _tmp85_;
				gchar* _tmp86_;
				GObject* _tmp87_;
				GtkToggleButton* _tmp88_;
				GtkToggleButton* _tmp89_;
				GtkToggleButton* _tmp90_;
				GeeLinkedList* _tmp91_;
				GtkToggleButton* _tmp92_;
#line 193 "gnome-nibbles.vala"
				if (!_tmp82_) {
#line 1539 "gnome-nibbles.c"
					gint _tmp83_;
#line 193 "gnome-nibbles.vala"
					_tmp83_ = i;
#line 193 "gnome-nibbles.vala"
					i = _tmp83_ + 1;
#line 1545 "gnome-nibbles.c"
				}
#line 193 "gnome-nibbles.vala"
				_tmp82_ = FALSE;
#line 193 "gnome-nibbles.vala"
				if (!(i <= NIBBLES_GAME_MAX_AI)) {
#line 193 "gnome-nibbles.vala"
					break;
#line 1553 "gnome-nibbles.c"
				}
#line 195 "gnome-nibbles.vala"
				_tmp84_ = builder;
#line 195 "gnome-nibbles.vala"
				_tmp85_ = g_strdup_printf ("ai%d", i);
#line 195 "gnome-nibbles.vala"
				_tmp86_ = _tmp85_;
#line 195 "gnome-nibbles.vala"
				_tmp87_ = gtk_builder_get_object (_tmp84_, _tmp86_);
#line 195 "gnome-nibbles.vala"
				_tmp88_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 195 "gnome-nibbles.vala"
				_tmp89_ = _tmp88_;
#line 195 "gnome-nibbles.vala"
				_g_free0 (_tmp86_);
#line 195 "gnome-nibbles.vala"
				button = _tmp89_;
#line 196 "gnome-nibbles.vala"
				_tmp90_ = button;
#line 196 "gnome-nibbles.vala"
				g_signal_connect_object (_tmp90_, "toggled", (GCallback) _nibbles_change_number_of_ai_cb_gtk_toggle_button_toggled, self, 0);
#line 197 "gnome-nibbles.vala"
				_tmp91_ = self->priv->number_of_ai_buttons;
#line 197 "gnome-nibbles.vala"
				_tmp92_ = button;
#line 197 "gnome-nibbles.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp91_, _tmp92_);
#line 193 "gnome-nibbles.vala"
				_g_object_unref0 (button);
#line 1583 "gnome-nibbles.c"
			}
		}
	}
#line 199 "gnome-nibbles.vala"
	_tmp93_ = builder;
#line 199 "gnome-nibbles.vala"
	_tmp94_ = gtk_builder_get_object (_tmp93_, "next_button");
#line 199 "gnome-nibbles.vala"
	_tmp95_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, gtk_button_get_type (), GtkButton));
#line 199 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->next_button);
#line 199 "gnome-nibbles.vala"
	self->priv->next_button = _tmp95_;
#line 200 "gnome-nibbles.vala"
	_tmp96_ = builder;
#line 200 "gnome-nibbles.vala"
	_tmp97_ = gtk_builder_get_object (_tmp96_, "start_button");
#line 200 "gnome-nibbles.vala"
	_tmp98_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, gtk_button_get_type (), GtkButton));
#line 200 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->start_button);
#line 200 "gnome-nibbles.vala"
	self->priv->start_button = _tmp98_;
#line 201 "gnome-nibbles.vala"
	_tmp99_ = builder;
#line 201 "gnome-nibbles.vala"
	_tmp100_ = gtk_builder_get_object (_tmp99_, "grids_box");
#line 201 "gnome-nibbles.vala"
	_tmp101_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, gtk_box_get_type (), GtkBox));
#line 201 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->grids_box);
#line 201 "gnome-nibbles.vala"
	self->priv->grids_box = _tmp101_;
#line 202 "gnome-nibbles.vala"
	_tmp102_ = self->priv->window;
#line 202 "gnome-nibbles.vala"
	_tmp103_ = self->priv->headerbar;
#line 202 "gnome-nibbles.vala"
	gtk_window_set_titlebar ((GtkWindow*) _tmp102_, (GtkWidget*) _tmp103_);
#line 204 "gnome-nibbles.vala"
	_tmp104_ = self->priv->window;
#line 204 "gnome-nibbles.vala"
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp104_);
#line 207 "gnome-nibbles.vala"
	_tmp105_ = self->priv->settings;
#line 207 "gnome-nibbles.vala"
	_tmp106_ = nibbles_game_new (_tmp105_);
#line 207 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->game);
#line 207 "gnome-nibbles.vala"
	self->priv->game = _tmp106_;
#line 208 "gnome-nibbles.vala"
	_tmp107_ = self->priv->game;
#line 208 "gnome-nibbles.vala"
	g_signal_connect_object (_tmp107_, "log-score", (GCallback) _nibbles_log_score_cb_nibbles_game_log_score, self, 0);
#line 209 "gnome-nibbles.vala"
	_tmp108_ = self->priv->game;
#line 209 "gnome-nibbles.vala"
	g_signal_connect_object (_tmp108_, "level-completed", (GCallback) _nibbles_level_completed_cb_nibbles_game_level_completed, self, 0);
#line 210 "gnome-nibbles.vala"
	_tmp109_ = self->priv->game;
#line 210 "gnome-nibbles.vala"
	g_signal_connect_object ((GObject*) _tmp109_, "notify::is-paused", (GCallback) ___lambda13__g_object_notify, self, 0);
#line 218 "gnome-nibbles.vala"
	_tmp110_ = self->priv->game;
#line 218 "gnome-nibbles.vala"
	_tmp111_ = nibbles_view_new (_tmp110_);
#line 218 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp111_);
#line 218 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->view);
#line 218 "gnome-nibbles.vala"
	self->priv->view = _tmp111_;
#line 219 "gnome-nibbles.vala"
	_tmp112_ = self->priv->view;
#line 219 "gnome-nibbles.vala"
	g_signal_connect_object ((GtkWidget*) _tmp112_, "configure-event", (GCallback) _nibbles_configure_event_cb_gtk_widget_configure_event, self, 0);
#line 220 "gnome-nibbles.vala"
	_tmp113_ = self->priv->view;
#line 220 "gnome-nibbles.vala"
	_tmp114_ = self->priv->settings;
#line 220 "gnome-nibbles.vala"
	_tmp113_->is_muted = !g_settings_get_boolean (_tmp114_, "sound");
#line 221 "gnome-nibbles.vala"
	_tmp115_ = self->priv->view;
#line 221 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp115_);
#line 223 "gnome-nibbles.vala"
	_tmp116_ = games_grid_frame_new (NIBBLES_GAME_WIDTH, NIBBLES_GAME_HEIGHT);
#line 223 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp116_);
#line 223 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->frame);
#line 223 "gnome-nibbles.vala"
	self->priv->frame = _tmp116_;
#line 224 "gnome-nibbles.vala"
	_tmp117_ = self->priv->game_box;
#line 224 "gnome-nibbles.vala"
	_tmp118_ = self->priv->frame;
#line 224 "gnome-nibbles.vala"
	gtk_box_pack_start (_tmp117_, (GtkWidget*) _tmp118_, TRUE, TRUE, (guint) 0);
#line 227 "gnome-nibbles.vala"
	_tmp119_ = scoreboard_new ();
#line 227 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp119_);
#line 227 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scoreboard);
#line 227 "gnome-nibbles.vala"
	self->priv->scoreboard = _tmp119_;
#line 228 "gnome-nibbles.vala"
	_tmp120_ = self->priv->view;
#line 228 "gnome-nibbles.vala"
	_tmp121_ = self->priv->game;
#line 228 "gnome-nibbles.vala"
	_tmp122_ = nibbles_game_get_tile_size (_tmp121_);
#line 228 "gnome-nibbles.vala"
	_tmp123_ = _tmp122_;
#line 228 "gnome-nibbles.vala"
	_tmp124_ = self->priv->game;
#line 228 "gnome-nibbles.vala"
	_tmp125_ = nibbles_game_get_tile_size (_tmp124_);
#line 228 "gnome-nibbles.vala"
	_tmp126_ = _tmp125_;
#line 228 "gnome-nibbles.vala"
	_tmp127_ = nibbles_view_load_pixmap_file (_tmp120_, "scoreboard-life.svg", 2 * _tmp123_, 2 * _tmp126_);
#line 228 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scoreboard_life);
#line 228 "gnome-nibbles.vala"
	self->priv->scoreboard_life = _tmp127_;
#line 229 "gnome-nibbles.vala"
	_tmp128_ = self->priv->scoreboard;
#line 229 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp128_);
#line 230 "gnome-nibbles.vala"
	_tmp129_ = self->priv->statusbar_stack;
#line 230 "gnome-nibbles.vala"
	_tmp130_ = self->priv->scoreboard;
#line 230 "gnome-nibbles.vala"
	gtk_stack_add_named (_tmp129_, (GtkWidget*) _tmp130_, "scoreboard");
#line 232 "gnome-nibbles.vala"
	_tmp131_ = self->priv->frame;
#line 232 "gnome-nibbles.vala"
	_tmp132_ = self->priv->view;
#line 232 "gnome-nibbles.vala"
	gtk_container_add ((GtkContainer*) _tmp131_, (GtkWidget*) _tmp132_);
#line 233 "gnome-nibbles.vala"
	_tmp133_ = self->priv->frame;
#line 233 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp133_);
#line 236 "gnome-nibbles.vala"
	_tmp134_ = self->priv->game;
#line 236 "gnome-nibbles.vala"
	_tmp135_ = self->priv->settings;
#line 236 "gnome-nibbles.vala"
	nibbles_game_set_numhumans (_tmp134_, g_settings_get_int (_tmp135_, "players"));
#line 237 "gnome-nibbles.vala"
	_tmp136_ = self->priv->game;
#line 237 "gnome-nibbles.vala"
	_tmp137_ = self->priv->settings;
#line 237 "gnome-nibbles.vala"
	nibbles_game_set_numai (_tmp136_, g_settings_get_int (_tmp137_, "ai"));
#line 240 "gnome-nibbles.vala"
	_tmp138_ = self->priv->view;
#line 240 "gnome-nibbles.vala"
	_tmp139_ = self->priv->game;
#line 240 "gnome-nibbles.vala"
	_tmp140_ = nibbles_game_get_tile_size (_tmp139_);
#line 240 "gnome-nibbles.vala"
	_tmp141_ = _tmp140_;
#line 240 "gnome-nibbles.vala"
	_tmp142_ = self->priv->game;
#line 240 "gnome-nibbles.vala"
	_tmp143_ = nibbles_game_get_tile_size (_tmp142_);
#line 240 "gnome-nibbles.vala"
	_tmp144_ = _tmp143_;
#line 240 "gnome-nibbles.vala"
	_tmp145_ = nibbles_view_load_pixmap_file (_tmp138_, "arrow.svg", 5 * _tmp141_, 5 * _tmp144_);
#line 240 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_pixbuf);
#line 240 "gnome-nibbles.vala"
	self->priv->arrow_pixbuf = _tmp145_;
#line 241 "gnome-nibbles.vala"
	_tmp146_ = self->priv->view;
#line 241 "gnome-nibbles.vala"
	_tmp147_ = self->priv->game;
#line 241 "gnome-nibbles.vala"
	_tmp148_ = nibbles_game_get_tile_size (_tmp147_);
#line 241 "gnome-nibbles.vala"
	_tmp149_ = _tmp148_;
#line 241 "gnome-nibbles.vala"
	_tmp150_ = self->priv->game;
#line 241 "gnome-nibbles.vala"
	_tmp151_ = nibbles_game_get_tile_size (_tmp150_);
#line 241 "gnome-nibbles.vala"
	_tmp152_ = _tmp151_;
#line 241 "gnome-nibbles.vala"
	_tmp153_ = nibbles_view_load_pixmap_file (_tmp146_, "arrow-key.svg", 5 * _tmp149_, 5 * _tmp152_);
#line 241 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_key_pixbuf);
#line 241 "gnome-nibbles.vala"
	self->priv->arrow_key_pixbuf = _tmp153_;
#line 244 "gnome-nibbles.vala"
	_tmp154_ = self->priv->settings;
#line 244 "gnome-nibbles.vala"
	first_run = g_settings_get_boolean (_tmp154_, "first-run");
#line 245 "gnome-nibbles.vala"
	if (first_run) {
#line 246 "gnome-nibbles.vala"
		nibbles_show_first_run_screen (self);
#line 1793 "gnome-nibbles.c"
	} else {
#line 248 "gnome-nibbles.vala"
		nibbles_show_new_game_screen_cb (self);
#line 1797 "gnome-nibbles.c"
	}
#line 251 "gnome-nibbles.vala"
	nibbles_create_scores (self);
#line 253 "gnome-nibbles.vala"
	_tmp155_ = self->priv->window;
#line 253 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp155_);
#line 129 "gnome-nibbles.vala"
	_g_object_unref0 (builder);
#line 129 "gnome-nibbles.vala"
	_g_object_unref0 (css_provider);
#line 1809 "gnome-nibbles.c"
}

static void
nibbles_real_activate (GApplication* base)
{
	Nibbles * self;
	GtkApplicationWindow* _tmp0_;
#line 256 "gnome-nibbles.vala"
	self = (Nibbles*) base;
#line 258 "gnome-nibbles.vala"
	G_APPLICATION_CLASS (nibbles_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 260 "gnome-nibbles.vala"
	_tmp0_ = self->priv->window;
#line 260 "gnome-nibbles.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 1825 "gnome-nibbles.c"
}

static void
nibbles_real_shutdown (GApplication* base)
{
	Nibbles * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	NibblesGame* _tmp3_;
	GSettings* _tmp4_;
#line 263 "gnome-nibbles.vala"
	self = (Nibbles*) base;
#line 265 "gnome-nibbles.vala"
	_tmp0_ = self->priv->settings;
#line 265 "gnome-nibbles.vala"
	g_settings_set_int (_tmp0_, "window-width", self->priv->window_width);
#line 266 "gnome-nibbles.vala"
	_tmp1_ = self->priv->settings;
#line 266 "gnome-nibbles.vala"
	g_settings_set_int (_tmp1_, "window-height", self->priv->window_height);
#line 267 "gnome-nibbles.vala"
	_tmp2_ = self->priv->settings;
#line 267 "gnome-nibbles.vala"
	g_settings_set_boolean (_tmp2_, "window-is-maximized", self->priv->is_maximized);
#line 268 "gnome-nibbles.vala"
	_tmp3_ = self->priv->game;
#line 268 "gnome-nibbles.vala"
	_tmp4_ = self->priv->settings;
#line 268 "gnome-nibbles.vala"
	nibbles_game_save_properties (_tmp3_, _tmp4_);
#line 270 "gnome-nibbles.vala"
	G_APPLICATION_CLASS (nibbles_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 1859 "gnome-nibbles.c"
}

static gboolean
nibbles_countdown_cb (Nibbles* self)
{
	gboolean result = FALSE;
	gint _tmp0_;
	GtkLabel* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
#line 273 "gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 275 "gnome-nibbles.vala"
	_tmp0_ = self->priv->seconds;
#line 275 "gnome-nibbles.vala"
	self->priv->seconds = _tmp0_ - 1;
#line 277 "gnome-nibbles.vala"
	if (self->priv->seconds == 0) {
#line 1878 "gnome-nibbles.c"
		GtkStack* _tmp1_;
		NibblesView* _tmp2_;
		ClutterActor* _tmp3_;
		ClutterActor* _tmp4_;
		NibblesGame* _tmp5_;
		NibblesGame* _tmp6_;
		GSimpleAction* _tmp7_;
		GSimpleAction* _tmp8_;
#line 279 "gnome-nibbles.vala"
		_tmp1_ = self->priv->statusbar_stack;
#line 279 "gnome-nibbles.vala"
		gtk_stack_set_visible_child_name (_tmp1_, "scoreboard");
#line 280 "gnome-nibbles.vala"
		_tmp2_ = self->priv->view;
#line 280 "gnome-nibbles.vala"
		_tmp3_ = nibbles_view_get_name_labels (_tmp2_);
#line 280 "gnome-nibbles.vala"
		_tmp4_ = _tmp3_;
#line 280 "gnome-nibbles.vala"
		clutter_actor_hide (_tmp4_);
#line 282 "gnome-nibbles.vala"
		_tmp5_ = self->priv->game;
#line 282 "gnome-nibbles.vala"
		nibbles_game_add_bonus (_tmp5_, TRUE);
#line 283 "gnome-nibbles.vala"
		_tmp6_ = self->priv->game;
#line 283 "gnome-nibbles.vala"
		nibbles_game_start (_tmp6_);
#line 285 "gnome-nibbles.vala"
		_tmp7_ = self->priv->pause_action;
#line 285 "gnome-nibbles.vala"
		g_simple_action_set_enabled (_tmp7_, TRUE);
#line 286 "gnome-nibbles.vala"
		_tmp8_ = self->priv->back_action;
#line 286 "gnome-nibbles.vala"
		g_simple_action_set_enabled (_tmp8_, TRUE);
#line 288 "gnome-nibbles.vala"
		self->priv->countdown_id = (guint) 0;
#line 289 "gnome-nibbles.vala"
		result = G_SOURCE_REMOVE;
#line 289 "gnome-nibbles.vala"
		return result;
#line 1921 "gnome-nibbles.c"
	}
#line 292 "gnome-nibbles.vala"
	_tmp9_ = self->priv->countdown;
#line 292 "gnome-nibbles.vala"
	_tmp10_ = g_strdup_printf ("%i", self->priv->seconds);
#line 292 "gnome-nibbles.vala"
	_tmp11_ = _tmp10_;
#line 292 "gnome-nibbles.vala"
	gtk_label_set_label (_tmp9_, _tmp11_);
#line 292 "gnome-nibbles.vala"
	_g_free0 (_tmp11_);
#line 293 "gnome-nibbles.vala"
	result = G_SOURCE_CONTINUE;
#line 293 "gnome-nibbles.vala"
	return result;
#line 1937 "gnome-nibbles.c"
}

static gboolean
nibbles_key_press_event_cb (Nibbles* self,
                            GtkWidget* widget,
                            GdkEventKey* event)
{
	gboolean result = FALSE;
	NibblesGame* _tmp0_;
#line 305 "gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 305 "gnome-nibbles.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 305 "gnome-nibbles.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 307 "gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 307 "gnome-nibbles.vala"
	result = nibbles_game_handle_keypress (_tmp0_, event->keyval);
#line 307 "gnome-nibbles.vala"
	return result;
#line 1959 "gnome-nibbles.c"
}

static void
nibbles_size_allocate_cb (Nibbles* self,
                          GtkAllocation* allocation)
{
	gboolean _tmp0_ = FALSE;
	GtkApplicationWindow* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 310 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 310 "gnome-nibbles.vala"
	g_return_if_fail (allocation != NULL);
#line 312 "gnome-nibbles.vala"
	if (self->priv->is_maximized) {
#line 312 "gnome-nibbles.vala"
		_tmp0_ = TRUE;
#line 1978 "gnome-nibbles.c"
	} else {
#line 312 "gnome-nibbles.vala"
		_tmp0_ = self->priv->is_tiled;
#line 1982 "gnome-nibbles.c"
	}
#line 312 "gnome-nibbles.vala"
	if (_tmp0_) {
#line 313 "gnome-nibbles.vala"
		return;
#line 1988 "gnome-nibbles.c"
	}
#line 314 "gnome-nibbles.vala"
	_tmp1_ = self->priv->window;
#line 314 "gnome-nibbles.vala"
	gtk_window_get_size ((GtkWindow*) _tmp1_, &_tmp2_, &_tmp3_);
#line 314 "gnome-nibbles.vala"
	self->priv->window_width = _tmp2_;
#line 314 "gnome-nibbles.vala"
	self->priv->window_height = _tmp3_;
#line 1998 "gnome-nibbles.c"
}

static gboolean
nibbles_window_state_event_cb (Nibbles* self,
                               GdkEventWindowState* event)
{
	gboolean result = FALSE;
	GdkWindowState _tmp0_;
	GdkWindowState _tmp2_;
#line 317 "gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 317 "gnome-nibbles.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 319 "gnome-nibbles.vala"
	_tmp0_ = event->changed_mask;
#line 319 "gnome-nibbles.vala"
	if ((_tmp0_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 2016 "gnome-nibbles.c"
		GdkWindowState _tmp1_;
#line 320 "gnome-nibbles.vala"
		_tmp1_ = event->new_window_state;
#line 320 "gnome-nibbles.vala"
		self->priv->is_maximized = (_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 2022 "gnome-nibbles.c"
	}
#line 322 "gnome-nibbles.vala"
	_tmp2_ = event->changed_mask;
#line 322 "gnome-nibbles.vala"
	if ((_tmp2_ & GDK_WINDOW_STATE_TILED) != 0) {
#line 2028 "gnome-nibbles.c"
		GdkWindowState _tmp3_;
#line 323 "gnome-nibbles.vala"
		_tmp3_ = event->new_window_state;
#line 323 "gnome-nibbles.vala"
		self->priv->is_tiled = (_tmp3_ & GDK_WINDOW_STATE_TILED) != 0;
#line 2034 "gnome-nibbles.c"
	}
#line 324 "gnome-nibbles.vala"
	result = FALSE;
#line 324 "gnome-nibbles.vala"
	return result;
#line 2040 "gnome-nibbles.c"
}

static gboolean
nibbles_configure_event_cb (Nibbles* self,
                            GdkEventConfigure* event)
{
	gboolean result = FALSE;
	gint tile_size = 0;
	gint ts_x = 0;
	gint ts_y = 0;
	gboolean _tmp2_ = FALSE;
	NibblesGame* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
#line 327 "gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 327 "gnome-nibbles.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 334 "gnome-nibbles.vala"
	ts_x = event->width / NIBBLES_GAME_WIDTH;
#line 335 "gnome-nibbles.vala"
	ts_y = event->height / NIBBLES_GAME_HEIGHT;
#line 336 "gnome-nibbles.vala"
	if ((ts_x * NIBBLES_GAME_WIDTH) > event->width) {
#line 2065 "gnome-nibbles.c"
		gint _tmp0_;
#line 337 "gnome-nibbles.vala"
		_tmp0_ = ts_x;
#line 337 "gnome-nibbles.vala"
		ts_x = _tmp0_ - 1;
#line 2071 "gnome-nibbles.c"
	}
#line 338 "gnome-nibbles.vala"
	if ((ts_y * NIBBLES_GAME_HEIGHT) > event->height) {
#line 2075 "gnome-nibbles.c"
		gint _tmp1_;
#line 339 "gnome-nibbles.vala"
		_tmp1_ = ts_y;
#line 339 "gnome-nibbles.vala"
		ts_y = _tmp1_ - 1;
#line 2081 "gnome-nibbles.c"
	}
#line 340 "gnome-nibbles.vala"
	tile_size = MIN (ts_x, ts_y);
#line 342 "gnome-nibbles.vala"
	if (tile_size == 0) {
#line 342 "gnome-nibbles.vala"
		_tmp2_ = TRUE;
#line 2089 "gnome-nibbles.c"
	} else {
		NibblesGame* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 342 "gnome-nibbles.vala"
		_tmp3_ = self->priv->game;
#line 342 "gnome-nibbles.vala"
		_tmp4_ = nibbles_game_get_tile_size (_tmp3_);
#line 342 "gnome-nibbles.vala"
		_tmp5_ = _tmp4_;
#line 342 "gnome-nibbles.vala"
		_tmp2_ = _tmp5_ == 0;
#line 2102 "gnome-nibbles.c"
	}
#line 342 "gnome-nibbles.vala"
	if (_tmp2_) {
#line 343 "gnome-nibbles.vala"
		result = TRUE;
#line 343 "gnome-nibbles.vala"
		return result;
#line 2110 "gnome-nibbles.c"
	}
#line 345 "gnome-nibbles.vala"
	_tmp6_ = self->priv->game;
#line 345 "gnome-nibbles.vala"
	_tmp7_ = nibbles_game_get_tile_size (_tmp6_);
#line 345 "gnome-nibbles.vala"
	_tmp8_ = _tmp7_;
#line 345 "gnome-nibbles.vala"
	if (_tmp8_ != tile_size) {
#line 2120 "gnome-nibbles.c"
		NibblesView* _tmp9_;
		ClutterActor* _tmp10_;
		NibblesView* _tmp11_;
		NibblesView* _tmp12_;
		NibblesView* _tmp13_;
		NibblesGame* _tmp24_;
#line 347 "gnome-nibbles.vala"
		_tmp9_ = self->priv->view;
#line 347 "gnome-nibbles.vala"
		_tmp10_ = gtk_clutter_embed_get_stage ((GtkClutterEmbed*) _tmp9_);
#line 347 "gnome-nibbles.vala"
		clutter_actor_set_size (_tmp10_, (gfloat) (tile_size * NIBBLES_GAME_WIDTH), (gfloat) (tile_size * NIBBLES_GAME_HEIGHT));
#line 349 "gnome-nibbles.vala"
		_tmp11_ = self->priv->view;
#line 349 "gnome-nibbles.vala"
		nibbles_view_board_rescale (_tmp11_, tile_size);
#line 350 "gnome-nibbles.vala"
		_tmp12_ = self->priv->view;
#line 350 "gnome-nibbles.vala"
		nibbles_view_boni_rescale (_tmp12_, tile_size);
#line 351 "gnome-nibbles.vala"
		_tmp13_ = self->priv->view;
#line 351 "gnome-nibbles.vala"
		nibbles_view_warps_rescale (_tmp13_, tile_size);
#line 2145 "gnome-nibbles.c"
		{
			GeeLinkedList* _worm_list = NULL;
			NibblesGame* _tmp14_;
			GeeLinkedList* _tmp15_;
			GeeLinkedList* _tmp16_;
			GeeLinkedList* _tmp17_;
			gint _worm_size = 0;
			GeeLinkedList* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint _worm_index = 0;
#line 352 "gnome-nibbles.vala"
			_tmp14_ = self->priv->game;
#line 352 "gnome-nibbles.vala"
			_tmp15_ = nibbles_game_get_worms (_tmp14_);
#line 352 "gnome-nibbles.vala"
			_tmp16_ = _tmp15_;
#line 352 "gnome-nibbles.vala"
			_tmp17_ = _g_object_ref0 (_tmp16_);
#line 352 "gnome-nibbles.vala"
			_worm_list = _tmp17_;
#line 352 "gnome-nibbles.vala"
			_tmp18_ = _worm_list;
#line 352 "gnome-nibbles.vala"
			_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
#line 352 "gnome-nibbles.vala"
			_tmp20_ = _tmp19_;
#line 352 "gnome-nibbles.vala"
			_worm_size = _tmp20_;
#line 352 "gnome-nibbles.vala"
			_worm_index = -1;
#line 352 "gnome-nibbles.vala"
			while (TRUE) {
#line 2179 "gnome-nibbles.c"
				Worm* worm = NULL;
				GeeLinkedList* _tmp21_;
				gpointer _tmp22_;
				Worm* _tmp23_;
#line 352 "gnome-nibbles.vala"
				_worm_index = _worm_index + 1;
#line 352 "gnome-nibbles.vala"
				if (!(_worm_index < _worm_size)) {
#line 352 "gnome-nibbles.vala"
					break;
#line 2190 "gnome-nibbles.c"
				}
#line 352 "gnome-nibbles.vala"
				_tmp21_ = _worm_list;
#line 352 "gnome-nibbles.vala"
				_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _worm_index);
#line 352 "gnome-nibbles.vala"
				worm = (Worm*) _tmp22_;
#line 353 "gnome-nibbles.vala"
				_tmp23_ = worm;
#line 353 "gnome-nibbles.vala"
				g_signal_emit_by_name (_tmp23_, "rescaled", tile_size);
#line 352 "gnome-nibbles.vala"
				_g_object_unref0 (worm);
#line 2204 "gnome-nibbles.c"
			}
#line 352 "gnome-nibbles.vala"
			_g_object_unref0 (_worm_list);
#line 2208 "gnome-nibbles.c"
		}
#line 355 "gnome-nibbles.vala"
		_tmp24_ = self->priv->game;
#line 355 "gnome-nibbles.vala"
		nibbles_game_set_tile_size (_tmp24_, tile_size);
#line 2214 "gnome-nibbles.c"
	}
#line 358 "gnome-nibbles.vala"
	result = FALSE;
#line 358 "gnome-nibbles.vala"
	return result;
#line 2220 "gnome-nibbles.c"
}

static void
_scoreboard_update_g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self)
{
#line 375 "gnome-nibbles.vala"
	scoreboard_update ((Scoreboard*) self);
#line 2230 "gnome-nibbles.c"
}

static void
nibbles_start_game_cb (Nibbles* self)
{
	GSettings* _tmp0_;
	NibblesGame* _tmp1_;
	NibblesView* _tmp2_;
	NibblesGame* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NibblesView* _tmp6_;
	Scoreboard* _tmp7_;
	NibblesGame* _tmp33_;
	NibblesView* _tmp34_;
#line 361 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 363 "gnome-nibbles.vala"
	_tmp0_ = self->priv->settings;
#line 363 "gnome-nibbles.vala"
	g_settings_set_boolean (_tmp0_, "first-run", FALSE);
#line 365 "gnome-nibbles.vala"
	_tmp1_ = self->priv->game;
#line 365 "gnome-nibbles.vala"
	nibbles_game_reset (_tmp1_);
#line 367 "gnome-nibbles.vala"
	_tmp2_ = self->priv->view;
#line 367 "gnome-nibbles.vala"
	_tmp3_ = self->priv->game;
#line 367 "gnome-nibbles.vala"
	_tmp4_ = nibbles_game_get_current_level (_tmp3_);
#line 367 "gnome-nibbles.vala"
	_tmp5_ = _tmp4_;
#line 367 "gnome-nibbles.vala"
	nibbles_view_new_level (_tmp2_, _tmp5_);
#line 368 "gnome-nibbles.vala"
	_tmp6_ = self->priv->view;
#line 368 "gnome-nibbles.vala"
	nibbles_view_connect_worm_signals (_tmp6_);
#line 370 "gnome-nibbles.vala"
	_tmp7_ = self->priv->scoreboard;
#line 370 "gnome-nibbles.vala"
	scoreboard_clear (_tmp7_);
#line 2274 "gnome-nibbles.c"
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp8_;
		GeeLinkedList* _tmp9_;
		GeeLinkedList* _tmp10_;
		GeeLinkedList* _tmp11_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _worm_index = 0;
#line 371 "gnome-nibbles.vala"
		_tmp8_ = self->priv->game;
#line 371 "gnome-nibbles.vala"
		_tmp9_ = nibbles_game_get_worms (_tmp8_);
#line 371 "gnome-nibbles.vala"
		_tmp10_ = _tmp9_;
#line 371 "gnome-nibbles.vala"
		_tmp11_ = _g_object_ref0 (_tmp10_);
#line 371 "gnome-nibbles.vala"
		_worm_list = _tmp11_;
#line 371 "gnome-nibbles.vala"
		_tmp12_ = _worm_list;
#line 371 "gnome-nibbles.vala"
		_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
#line 371 "gnome-nibbles.vala"
		_tmp14_ = _tmp13_;
#line 371 "gnome-nibbles.vala"
		_worm_size = _tmp14_;
#line 371 "gnome-nibbles.vala"
		_worm_index = -1;
#line 371 "gnome-nibbles.vala"
		while (TRUE) {
#line 2308 "gnome-nibbles.c"
			Worm* worm = NULL;
			GeeLinkedList* _tmp15_;
			gpointer _tmp16_;
			gint color = 0;
			NibblesGame* _tmp17_;
			GeeHashMap* _tmp18_;
			GeeHashMap* _tmp19_;
			Worm* _tmp20_;
			gpointer _tmp21_;
			WormProperties* _tmp22_;
			gint _tmp23_;
			Scoreboard* _tmp24_;
			Worm* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			GdkPixbuf* _tmp28_;
			Worm* _tmp29_;
			Scoreboard* _tmp30_;
			Worm* _tmp31_;
			Scoreboard* _tmp32_;
#line 371 "gnome-nibbles.vala"
			_worm_index = _worm_index + 1;
#line 371 "gnome-nibbles.vala"
			if (!(_worm_index < _worm_size)) {
#line 371 "gnome-nibbles.vala"
				break;
#line 2335 "gnome-nibbles.c"
			}
#line 371 "gnome-nibbles.vala"
			_tmp15_ = _worm_list;
#line 371 "gnome-nibbles.vala"
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _worm_index);
#line 371 "gnome-nibbles.vala"
			worm = (Worm*) _tmp16_;
#line 373 "gnome-nibbles.vala"
			_tmp17_ = self->priv->game;
#line 373 "gnome-nibbles.vala"
			_tmp18_ = nibbles_game_get_worm_props (_tmp17_);
#line 373 "gnome-nibbles.vala"
			_tmp19_ = _tmp18_;
#line 373 "gnome-nibbles.vala"
			_tmp20_ = worm;
#line 373 "gnome-nibbles.vala"
			_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp19_, _tmp20_);
#line 373 "gnome-nibbles.vala"
			_tmp22_ = (WormProperties*) _tmp21_;
#line 373 "gnome-nibbles.vala"
			_tmp23_ = (*_tmp22_).color;
#line 373 "gnome-nibbles.vala"
			_worm_properties_free0 (_tmp22_);
#line 373 "gnome-nibbles.vala"
			color = _tmp23_;
#line 374 "gnome-nibbles.vala"
			_tmp24_ = self->priv->scoreboard;
#line 374 "gnome-nibbles.vala"
			_tmp25_ = worm;
#line 374 "gnome-nibbles.vala"
			_tmp26_ = nibbles_view_colorval_name (color);
#line 374 "gnome-nibbles.vala"
			_tmp27_ = _tmp26_;
#line 374 "gnome-nibbles.vala"
			_tmp28_ = self->priv->scoreboard_life;
#line 374 "gnome-nibbles.vala"
			scoreboard_register (_tmp24_, _tmp25_, _tmp27_, _tmp28_);
#line 374 "gnome-nibbles.vala"
			_g_free0 (_tmp27_);
#line 375 "gnome-nibbles.vala"
			_tmp29_ = worm;
#line 375 "gnome-nibbles.vala"
			_tmp30_ = self->priv->scoreboard;
#line 375 "gnome-nibbles.vala"
			g_signal_connect_object ((GObject*) _tmp29_, "notify::lives", (GCallback) _scoreboard_update_g_object_notify, _tmp30_, 0);
#line 376 "gnome-nibbles.vala"
			_tmp31_ = worm;
#line 376 "gnome-nibbles.vala"
			_tmp32_ = self->priv->scoreboard;
#line 376 "gnome-nibbles.vala"
			g_signal_connect_object ((GObject*) _tmp31_, "notify::score", (GCallback) _scoreboard_update_g_object_notify, _tmp32_, 0);
#line 371 "gnome-nibbles.vala"
			_g_object_unref0 (worm);
#line 2389 "gnome-nibbles.c"
		}
#line 371 "gnome-nibbles.vala"
		_g_object_unref0 (_worm_list);
#line 2393 "gnome-nibbles.c"
	}
#line 378 "gnome-nibbles.vala"
	_tmp33_ = self->priv->game;
#line 378 "gnome-nibbles.vala"
	nibbles_game_add_worms (_tmp33_);
#line 380 "gnome-nibbles.vala"
	_tmp34_ = self->priv->view;
#line 380 "gnome-nibbles.vala"
	nibbles_view_create_name_labels (_tmp34_);
#line 382 "gnome-nibbles.vala"
	nibbles_show_game_view (self);
#line 384 "gnome-nibbles.vala"
	nibbles_start_game_with_countdown (self);
#line 2407 "gnome-nibbles.c"
}

static gboolean
_nibbles_countdown_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = nibbles_countdown_cb ((Nibbles*) self);
#line 397 "gnome-nibbles.vala"
	return result;
#line 2417 "gnome-nibbles.c"
}

static void
nibbles_start_game_with_countdown (Nibbles* self)
{
	GtkStack* _tmp0_;
	GSimpleAction* _tmp1_;
	NibblesView* _tmp2_;
	ClutterActor* _tmp3_;
	ClutterActor* _tmp4_;
	GtkLabel* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
#line 387 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 389 "gnome-nibbles.vala"
	_tmp0_ = self->priv->statusbar_stack;
#line 389 "gnome-nibbles.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "countdown");
#line 391 "gnome-nibbles.vala"
	_tmp1_ = self->priv->new_game_action;
#line 391 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp1_, TRUE);
#line 393 "gnome-nibbles.vala"
	self->priv->seconds = NIBBLES_COUNTDOWN_TIME;
#line 394 "gnome-nibbles.vala"
	_tmp2_ = self->priv->view;
#line 394 "gnome-nibbles.vala"
	_tmp3_ = nibbles_view_get_name_labels (_tmp2_);
#line 394 "gnome-nibbles.vala"
	_tmp4_ = _tmp3_;
#line 394 "gnome-nibbles.vala"
	clutter_actor_show (_tmp4_);
#line 396 "gnome-nibbles.vala"
	_tmp5_ = self->priv->countdown;
#line 396 "gnome-nibbles.vala"
	_tmp6_ = g_strdup_printf ("%i", NIBBLES_COUNTDOWN_TIME);
#line 396 "gnome-nibbles.vala"
	_tmp7_ = _tmp6_;
#line 396 "gnome-nibbles.vala"
	gtk_label_set_label (_tmp5_, _tmp7_);
#line 396 "gnome-nibbles.vala"
	_g_free0 (_tmp7_);
#line 397 "gnome-nibbles.vala"
	self->priv->countdown_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _nibbles_countdown_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 2463 "gnome-nibbles.c"
}

static void
nibbles_restart_game (Nibbles* self)
{
	NibblesView* _tmp0_;
	NibblesGame* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	NibblesGame* _tmp4_;
#line 400 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 402 "gnome-nibbles.vala"
	_tmp0_ = self->priv->view;
#line 402 "gnome-nibbles.vala"
	_tmp1_ = self->priv->game;
#line 402 "gnome-nibbles.vala"
	_tmp2_ = nibbles_game_get_current_level (_tmp1_);
#line 402 "gnome-nibbles.vala"
	_tmp3_ = _tmp2_;
#line 402 "gnome-nibbles.vala"
	nibbles_view_new_level (_tmp0_, _tmp3_);
#line 404 "gnome-nibbles.vala"
	_tmp4_ = self->priv->game;
#line 404 "gnome-nibbles.vala"
	nibbles_game_add_worms (_tmp4_);
#line 405 "gnome-nibbles.vala"
	nibbles_start_game_with_countdown (self);
#line 2492 "gnome-nibbles.c"
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 408 "gnome-nibbles.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 408 "gnome-nibbles.vala"
	return _data1_;
#line 2502 "gnome-nibbles.c"
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 408 "gnome-nibbles.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 2512 "gnome-nibbles.c"
		Nibbles* self;
#line 408 "gnome-nibbles.vala"
		self = _data1_->self;
#line 408 "gnome-nibbles.vala"
		_g_object_unref0 (_data1_->dialog);
#line 408 "gnome-nibbles.vala"
		_g_object_unref0 (self);
#line 408 "gnome-nibbles.vala"
		g_slice_free (Block1Data, _data1_);
#line 2522 "gnome-nibbles.c"
	}
}

static void
__lambda7_ (Block1Data* _data1_,
            gint response_id)
{
	Nibbles* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 428 "gnome-nibbles.vala"
	self = _data1_->self;
#line 429 "gnome-nibbles.vala"
	if (response_id == ((gint) GTK_RESPONSE_OK)) {
#line 430 "gnome-nibbles.vala"
		nibbles_show_new_game_screen_cb (self);
#line 2539 "gnome-nibbles.c"
	}
#line 431 "gnome-nibbles.vala"
	if (response_id == ((gint) GTK_RESPONSE_CANCEL)) {
#line 431 "gnome-nibbles.vala"
		_tmp1_ = TRUE;
#line 2545 "gnome-nibbles.c"
	} else {
#line 431 "gnome-nibbles.vala"
		_tmp1_ = response_id == ((gint) GTK_RESPONSE_DELETE_EVENT);
#line 2549 "gnome-nibbles.c"
	}
#line 431 "gnome-nibbles.vala"
	if (_tmp1_) {
#line 2553 "gnome-nibbles.c"
		NibblesGame* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 432 "gnome-nibbles.vala"
		_tmp2_ = self->priv->game;
#line 432 "gnome-nibbles.vala"
		_tmp3_ = nibbles_game_get_is_paused (_tmp2_);
#line 432 "gnome-nibbles.vala"
		_tmp4_ = _tmp3_;
#line 432 "gnome-nibbles.vala"
		_tmp0_ = !_tmp4_;
#line 2565 "gnome-nibbles.c"
	} else {
#line 431 "gnome-nibbles.vala"
		_tmp0_ = FALSE;
#line 2569 "gnome-nibbles.c"
	}
#line 431 "gnome-nibbles.vala"
	if (_tmp0_) {
#line 2573 "gnome-nibbles.c"
		NibblesView* _tmp6_;
#line 434 "gnome-nibbles.vala"
		if (self->priv->seconds == 0) {
#line 2577 "gnome-nibbles.c"
			NibblesGame* _tmp5_;
#line 435 "gnome-nibbles.vala"
			_tmp5_ = self->priv->game;
#line 435 "gnome-nibbles.vala"
			nibbles_game_start (_tmp5_);
#line 2583 "gnome-nibbles.c"
		} else {
#line 437 "gnome-nibbles.vala"
			self->priv->countdown_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _nibbles_countdown_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 2587 "gnome-nibbles.c"
		}
#line 439 "gnome-nibbles.vala"
		_tmp6_ = self->priv->view;
#line 439 "gnome-nibbles.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
#line 2593 "gnome-nibbles.c"
	}
#line 442 "gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _data1_->dialog);
#line 2597 "gnome-nibbles.c"
}

static void
___lambda7__gtk_dialog_response (GtkDialog* _sender,
                                 gint response_id,
                                 gpointer self)
{
#line 428 "gnome-nibbles.vala"
	__lambda7_ (self, response_id);
#line 2607 "gnome-nibbles.c"
}

static void
nibbles_new_game_cb (Nibbles* self)
{
	Block1Data* _data1_;
	NibblesGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkApplicationWindow* _tmp4_;
	GtkMessageDialog* _tmp5_;
	GtkButton* button = NULL;
	GtkWidget* _tmp6_;
	GtkButton* _tmp7_;
#line 408 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 408 "gnome-nibbles.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 408 "gnome-nibbles.vala"
	_data1_->_ref_count_ = 1;
#line 408 "gnome-nibbles.vala"
	_data1_->self = g_object_ref (self);
#line 410 "gnome-nibbles.vala"
	if (self->priv->countdown_id != ((guint) 0)) {
#line 412 "gnome-nibbles.vala"
		g_source_remove (self->priv->countdown_id);
#line 413 "gnome-nibbles.vala"
		self->priv->countdown_id = (guint) 0;
#line 2636 "gnome-nibbles.c"
	}
#line 416 "gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 416 "gnome-nibbles.vala"
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
#line 416 "gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 416 "gnome-nibbles.vala"
	if (_tmp2_) {
#line 2646 "gnome-nibbles.c"
		NibblesGame* _tmp3_;
#line 417 "gnome-nibbles.vala"
		_tmp3_ = self->priv->game;
#line 417 "gnome-nibbles.vala"
		nibbles_game_stop (_tmp3_);
#line 2652 "gnome-nibbles.c"
	}
#line 419 "gnome-nibbles.vala"
	_tmp4_ = self->priv->window;
#line 419 "gnome-nibbles.vala"
	_tmp5_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp4_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK_CANCEL, "%s", _ ("Are you sure you want to start a new game?"));
#line 419 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp5_);
#line 419 "gnome-nibbles.vala"
	_data1_->dialog = _tmp5_;
#line 424 "gnome-nibbles.vala"
	g_object_set (_data1_->dialog, "secondary-text", _ ("If you start a new game, the current one will be lost."), NULL);
#line 426 "gnome-nibbles.vala"
	_tmp6_ = gtk_dialog_get_widget_for_response ((GtkDialog*) _data1_->dialog, (gint) GTK_RESPONSE_OK);
#line 426 "gnome-nibbles.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_button_get_type (), GtkButton));
#line 426 "gnome-nibbles.vala"
	button = _tmp7_;
#line 427 "gnome-nibbles.vala"
	gtk_button_set_label (button, _ ("_New Game"));
#line 428 "gnome-nibbles.vala"
	g_signal_connect_data ((GtkDialog*) _data1_->dialog, "response", (GCallback) ___lambda7__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 445 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _data1_->dialog);
#line 408 "gnome-nibbles.vala"
	_g_object_unref0 (button);
#line 408 "gnome-nibbles.vala"
	block1_data_unref (_data1_);
#line 408 "gnome-nibbles.vala"
	_data1_ = NULL;
#line 2682 "gnome-nibbles.c"
}

static void
nibbles_pause_cb (Nibbles* self)
{
	NibblesGame* _tmp0_;
#line 448 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 450 "gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 450 "gnome-nibbles.vala"
	if (_tmp0_ != NULL) {
#line 2695 "gnome-nibbles.c"
		NibblesGame* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
#line 452 "gnome-nibbles.vala"
		_tmp1_ = self->priv->game;
#line 452 "gnome-nibbles.vala"
		_tmp2_ = nibbles_game_get_is_running (_tmp1_);
#line 452 "gnome-nibbles.vala"
		_tmp3_ = _tmp2_;
#line 452 "gnome-nibbles.vala"
		if (_tmp3_) {
#line 2707 "gnome-nibbles.c"
			NibblesGame* _tmp4_;
			GtkButton* _tmp5_;
#line 454 "gnome-nibbles.vala"
			_tmp4_ = self->priv->game;
#line 454 "gnome-nibbles.vala"
			nibbles_game_pause (_tmp4_);
#line 455 "gnome-nibbles.vala"
			_tmp5_ = self->priv->pause_button;
#line 455 "gnome-nibbles.vala"
			gtk_button_set_label (_tmp5_, _ ("_Resume"));
#line 2718 "gnome-nibbles.c"
		} else {
			NibblesGame* _tmp6_;
			GtkButton* _tmp7_;
			NibblesView* _tmp8_;
#line 459 "gnome-nibbles.vala"
			_tmp6_ = self->priv->game;
#line 459 "gnome-nibbles.vala"
			nibbles_game_unpause (_tmp6_);
#line 460 "gnome-nibbles.vala"
			_tmp7_ = self->priv->pause_button;
#line 460 "gnome-nibbles.vala"
			gtk_button_set_label (_tmp7_, _ ("_Pause"));
#line 461 "gnome-nibbles.vala"
			_tmp8_ = self->priv->view;
#line 461 "gnome-nibbles.vala"
			gtk_widget_grab_focus ((GtkWidget*) _tmp8_);
#line 2735 "gnome-nibbles.c"
		}
	}
}

static void
nibbles_settings_changed_cb (Nibbles* self,
                             const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 472 "gnome-nibbles.vala"
	static GQuark _tmp1_label0 = 0;
#line 472 "gnome-nibbles.vala"
	static GQuark _tmp1_label1 = 0;
#line 472 "gnome-nibbles.vala"
	static GQuark _tmp1_label2 = 0;
#line 470 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 470 "gnome-nibbles.vala"
	g_return_if_fail (key != NULL);
#line 472 "gnome-nibbles.vala"
	_tmp0_ = key;
#line 472 "gnome-nibbles.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 472 "gnome-nibbles.vala"
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("speed")))) {
#line 472 "gnome-nibbles.vala"
		switch (0) {
#line 2764 "gnome-nibbles.c"
			default:
			{
				NibblesGame* _tmp3_;
				GSettings* _tmp4_;
#line 475 "gnome-nibbles.vala"
				_tmp3_ = self->priv->game;
#line 475 "gnome-nibbles.vala"
				_tmp4_ = self->priv->settings;
#line 475 "gnome-nibbles.vala"
				nibbles_game_set_speed (_tmp3_, g_settings_get_int (_tmp4_, key));
#line 476 "gnome-nibbles.vala"
				break;
#line 2777 "gnome-nibbles.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("sound")))) {
#line 472 "gnome-nibbles.vala"
		switch (0) {
#line 2783 "gnome-nibbles.c"
			default:
			{
				NibblesView* _tmp5_;
				GSettings* _tmp6_;
#line 478 "gnome-nibbles.vala"
				_tmp5_ = self->priv->view;
#line 478 "gnome-nibbles.vala"
				_tmp6_ = self->priv->settings;
#line 478 "gnome-nibbles.vala"
				_tmp5_->is_muted = !g_settings_get_boolean (_tmp6_, key);
#line 479 "gnome-nibbles.vala"
				break;
#line 2796 "gnome-nibbles.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("fakes")))) {
#line 472 "gnome-nibbles.vala"
		switch (0) {
#line 2802 "gnome-nibbles.c"
			default:
			{
				NibblesGame* _tmp7_;
				GSettings* _tmp8_;
#line 481 "gnome-nibbles.vala"
				_tmp7_ = self->priv->game;
#line 481 "gnome-nibbles.vala"
				_tmp8_ = self->priv->settings;
#line 481 "gnome-nibbles.vala"
				nibbles_game_set_fakes (_tmp7_, g_settings_get_boolean (_tmp8_, key));
#line 482 "gnome-nibbles.vala"
				break;
#line 2815 "gnome-nibbles.c"
			}
		}
	}
}

static void
nibbles_worm_settings_changed_cb (Nibbles* self,
                                  GSettings* changed_worm_settings,
                                  const gchar* key)
{
	NibblesGame* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint id = 0;
	GeeArrayList* _tmp5_;
	NibblesGame* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	Worm* worm = NULL;
	NibblesGame* _tmp9_;
	GeeLinkedList* _tmp10_;
	GeeLinkedList* _tmp11_;
	gpointer _tmp12_;
	WormProperties* properties = NULL;
	NibblesGame* _tmp13_;
	GeeHashMap* _tmp14_;
	GeeHashMap* _tmp15_;
	Worm* _tmp16_;
	gpointer _tmp17_;
	const gchar* _tmp18_;
	GQuark _tmp20_ = 0U;
#line 500 "gnome-nibbles.vala"
	static GQuark _tmp19_label0 = 0;
#line 500 "gnome-nibbles.vala"
	static GQuark _tmp19_label1 = 0;
#line 500 "gnome-nibbles.vala"
	static GQuark _tmp19_label2 = 0;
#line 500 "gnome-nibbles.vala"
	static GQuark _tmp19_label3 = 0;
#line 500 "gnome-nibbles.vala"
	static GQuark _tmp19_label4 = 0;
#line 2859 "gnome-nibbles.c"
	NibblesGame* _tmp26_;
	GeeHashMap* _tmp27_;
	GeeHashMap* _tmp28_;
	Worm* _tmp29_;
	WormProperties* _tmp30_;
#line 486 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 486 "gnome-nibbles.vala"
	g_return_if_fail (changed_worm_settings != NULL);
#line 486 "gnome-nibbles.vala"
	g_return_if_fail (key != NULL);
#line 489 "gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 489 "gnome-nibbles.vala"
	_tmp1_ = nibbles_game_get_worm_props (_tmp0_);
#line 489 "gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 489 "gnome-nibbles.vala"
	_tmp3_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp2_);
#line 489 "gnome-nibbles.vala"
	_tmp4_ = _tmp3_;
#line 489 "gnome-nibbles.vala"
	if (_tmp4_ == 0) {
#line 490 "gnome-nibbles.vala"
		return;
#line 2885 "gnome-nibbles.c"
	}
#line 492 "gnome-nibbles.vala"
	_tmp5_ = self->priv->worm_settings;
#line 492 "gnome-nibbles.vala"
	id = gee_abstract_list_index_of ((GeeAbstractList*) _tmp5_, changed_worm_settings);
#line 494 "gnome-nibbles.vala"
	_tmp6_ = self->priv->game;
#line 494 "gnome-nibbles.vala"
	_tmp7_ = nibbles_game_get_numworms (_tmp6_);
#line 494 "gnome-nibbles.vala"
	_tmp8_ = _tmp7_;
#line 494 "gnome-nibbles.vala"
	if (id >= _tmp8_) {
#line 495 "gnome-nibbles.vala"
		return;
#line 2901 "gnome-nibbles.c"
	}
#line 497 "gnome-nibbles.vala"
	_tmp9_ = self->priv->game;
#line 497 "gnome-nibbles.vala"
	_tmp10_ = nibbles_game_get_worms (_tmp9_);
#line 497 "gnome-nibbles.vala"
	_tmp11_ = _tmp10_;
#line 497 "gnome-nibbles.vala"
	_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, id);
#line 497 "gnome-nibbles.vala"
	worm = (Worm*) _tmp12_;
#line 498 "gnome-nibbles.vala"
	_tmp13_ = self->priv->game;
#line 498 "gnome-nibbles.vala"
	_tmp14_ = nibbles_game_get_worm_props (_tmp13_);
#line 498 "gnome-nibbles.vala"
	_tmp15_ = _tmp14_;
#line 498 "gnome-nibbles.vala"
	_tmp16_ = worm;
#line 498 "gnome-nibbles.vala"
	_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, _tmp16_);
#line 498 "gnome-nibbles.vala"
	properties = (WormProperties*) _tmp17_;
#line 500 "gnome-nibbles.vala"
	_tmp18_ = key;
#line 500 "gnome-nibbles.vala"
	_tmp20_ = (NULL == _tmp18_) ? 0 : g_quark_from_string (_tmp18_);
#line 500 "gnome-nibbles.vala"
	if (_tmp20_ == ((0 != _tmp19_label0) ? _tmp19_label0 : (_tmp19_label0 = g_quark_from_static_string ("color")))) {
#line 500 "gnome-nibbles.vala"
		switch (0) {
#line 2933 "gnome-nibbles.c"
			default:
			{
				WormProperties* _tmp21_;
#line 503 "gnome-nibbles.vala"
				_tmp21_ = properties;
#line 503 "gnome-nibbles.vala"
				(*_tmp21_).color = g_settings_get_enum (changed_worm_settings, "color");
#line 504 "gnome-nibbles.vala"
				break;
#line 2943 "gnome-nibbles.c"
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label1) ? _tmp19_label1 : (_tmp19_label1 = g_quark_from_static_string ("key-up")))) {
#line 500 "gnome-nibbles.vala"
		switch (0) {
#line 2949 "gnome-nibbles.c"
			default:
			{
				WormProperties* _tmp22_;
#line 506 "gnome-nibbles.vala"
				_tmp22_ = properties;
#line 506 "gnome-nibbles.vala"
				(*_tmp22_).up = (guint) g_settings_get_int (changed_worm_settings, "key-up");
#line 507 "gnome-nibbles.vala"
				break;
#line 2959 "gnome-nibbles.c"
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label2) ? _tmp19_label2 : (_tmp19_label2 = g_quark_from_static_string ("key-down")))) {
#line 500 "gnome-nibbles.vala"
		switch (0) {
#line 2965 "gnome-nibbles.c"
			default:
			{
				WormProperties* _tmp23_;
#line 509 "gnome-nibbles.vala"
				_tmp23_ = properties;
#line 509 "gnome-nibbles.vala"
				(*_tmp23_).down = (guint) g_settings_get_int (changed_worm_settings, "key-down");
#line 510 "gnome-nibbles.vala"
				break;
#line 2975 "gnome-nibbles.c"
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label3) ? _tmp19_label3 : (_tmp19_label3 = g_quark_from_static_string ("key-left")))) {
#line 500 "gnome-nibbles.vala"
		switch (0) {
#line 2981 "gnome-nibbles.c"
			default:
			{
				WormProperties* _tmp24_;
#line 512 "gnome-nibbles.vala"
				_tmp24_ = properties;
#line 512 "gnome-nibbles.vala"
				(*_tmp24_).left = (guint) g_settings_get_int (changed_worm_settings, "key-left");
#line 513 "gnome-nibbles.vala"
				break;
#line 2991 "gnome-nibbles.c"
			}
		}
	} else if (_tmp20_ == ((0 != _tmp19_label4) ? _tmp19_label4 : (_tmp19_label4 = g_quark_from_static_string ("key-right")))) {
#line 500 "gnome-nibbles.vala"
		switch (0) {
#line 2997 "gnome-nibbles.c"
			default:
			{
				WormProperties* _tmp25_;
#line 515 "gnome-nibbles.vala"
				_tmp25_ = properties;
#line 515 "gnome-nibbles.vala"
				(*_tmp25_).right = (guint) g_settings_get_int (changed_worm_settings, "key-right");
#line 516 "gnome-nibbles.vala"
				break;
#line 3007 "gnome-nibbles.c"
			}
		}
	}
#line 519 "gnome-nibbles.vala"
	_tmp26_ = self->priv->game;
#line 519 "gnome-nibbles.vala"
	_tmp27_ = nibbles_game_get_worm_props (_tmp26_);
#line 519 "gnome-nibbles.vala"
	_tmp28_ = _tmp27_;
#line 519 "gnome-nibbles.vala"
	_tmp29_ = worm;
#line 519 "gnome-nibbles.vala"
	_tmp30_ = properties;
#line 519 "gnome-nibbles.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, _tmp29_, _tmp30_);
#line 486 "gnome-nibbles.vala"
	_worm_properties_free0 (properties);
#line 486 "gnome-nibbles.vala"
	_g_object_unref0 (worm);
#line 3027 "gnome-nibbles.c"
}

static void
nibbles_show_first_run_screen (Nibbles* self)
{
	GtkStack* _tmp0_;
#line 526 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 528 "gnome-nibbles.vala"
	_tmp0_ = self->priv->main_stack;
#line 528 "gnome-nibbles.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "first_run");
#line 3040 "gnome-nibbles.c"
}

static void
nibbles_show_new_game_screen_cb (Nibbles* self)
{
	NibblesGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkHeaderBar* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GeeLinkedList* _tmp10_;
	NibblesGame* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gpointer _tmp14_;
	GtkToggleButton* _tmp15_;
	GeeLinkedList* _tmp16_;
	NibblesGame* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gpointer _tmp20_;
	GtkToggleButton* _tmp21_;
	GtkApplicationWindow* _tmp22_;
	GtkButton* _tmp23_;
	GtkStack* _tmp24_;
	GtkStack* _tmp25_;
	GtkStack* _tmp26_;
#line 531 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 533 "gnome-nibbles.vala"
	if (self->priv->countdown_id != ((guint) 0)) {
#line 535 "gnome-nibbles.vala"
		g_source_remove (self->priv->countdown_id);
#line 536 "gnome-nibbles.vala"
		self->priv->countdown_id = (guint) 0;
#line 3080 "gnome-nibbles.c"
	}
#line 539 "gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 539 "gnome-nibbles.vala"
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
#line 539 "gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 539 "gnome-nibbles.vala"
	if (_tmp2_) {
#line 3090 "gnome-nibbles.c"
		NibblesGame* _tmp3_;
#line 540 "gnome-nibbles.vala"
		_tmp3_ = self->priv->game;
#line 540 "gnome-nibbles.vala"
		nibbles_game_stop (_tmp3_);
#line 3096 "gnome-nibbles.c"
	}
#line 542 "gnome-nibbles.vala"
	_tmp4_ = self->priv->headerbar;
#line 542 "gnome-nibbles.vala"
	gtk_header_bar_set_title (_tmp4_, _ ("Nibbles"));
#line 544 "gnome-nibbles.vala"
	_tmp5_ = self->priv->new_game_action;
#line 544 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp5_, FALSE);
#line 545 "gnome-nibbles.vala"
	_tmp6_ = self->priv->pause_action;
#line 545 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp6_, FALSE);
#line 546 "gnome-nibbles.vala"
	_tmp7_ = self->priv->back_action;
#line 546 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp7_, TRUE);
#line 548 "gnome-nibbles.vala"
	_tmp8_ = self->priv->new_game_button;
#line 548 "gnome-nibbles.vala"
	gtk_widget_hide ((GtkWidget*) _tmp8_);
#line 549 "gnome-nibbles.vala"
	_tmp9_ = self->priv->pause_button;
#line 549 "gnome-nibbles.vala"
	gtk_widget_hide ((GtkWidget*) _tmp9_);
#line 551 "gnome-nibbles.vala"
	_tmp10_ = self->priv->number_of_players_buttons;
#line 551 "gnome-nibbles.vala"
	_tmp11_ = self->priv->game;
#line 551 "gnome-nibbles.vala"
	_tmp12_ = nibbles_game_get_numhumans (_tmp11_);
#line 551 "gnome-nibbles.vala"
	_tmp13_ = _tmp12_;
#line 551 "gnome-nibbles.vala"
	_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp13_ - 1);
#line 551 "gnome-nibbles.vala"
	_tmp15_ = (GtkToggleButton*) _tmp14_;
#line 551 "gnome-nibbles.vala"
	gtk_toggle_button_set_active (_tmp15_, TRUE);
#line 551 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp15_);
#line 552 "gnome-nibbles.vala"
	_tmp16_ = self->priv->number_of_ai_buttons;
#line 552 "gnome-nibbles.vala"
	_tmp17_ = self->priv->game;
#line 552 "gnome-nibbles.vala"
	_tmp18_ = nibbles_game_get_numai (_tmp17_);
#line 552 "gnome-nibbles.vala"
	_tmp19_ = _tmp18_;
#line 552 "gnome-nibbles.vala"
	_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp19_);
#line 552 "gnome-nibbles.vala"
	_tmp21_ = (GtkToggleButton*) _tmp20_;
#line 552 "gnome-nibbles.vala"
	gtk_toggle_button_set_active (_tmp21_, TRUE);
#line 552 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp21_);
#line 554 "gnome-nibbles.vala"
	_tmp22_ = self->priv->window;
#line 554 "gnome-nibbles.vala"
	_tmp23_ = self->priv->next_button;
#line 554 "gnome-nibbles.vala"
	gtk_window_set_default ((GtkWindow*) _tmp22_, (GtkWidget*) _tmp23_);
#line 556 "gnome-nibbles.vala"
	_tmp24_ = self->priv->main_stack;
#line 556 "gnome-nibbles.vala"
	gtk_stack_set_transition_type (_tmp24_, GTK_STACK_TRANSITION_TYPE_NONE);
#line 557 "gnome-nibbles.vala"
	_tmp25_ = self->priv->main_stack;
#line 557 "gnome-nibbles.vala"
	gtk_stack_set_visible_child_name (_tmp25_, "number_of_players");
#line 558 "gnome-nibbles.vala"
	_tmp26_ = self->priv->main_stack;
#line 558 "gnome-nibbles.vala"
	gtk_stack_set_transition_type (_tmp26_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
#line 3172 "gnome-nibbles.c"
}

static void
nibbles_show_controls_screen_cb (Nibbles* self)
{
	NibblesGame* _tmp30_;
	NibblesGame* _tmp31_;
	GeeArrayList* _tmp32_;
	GtkBox* _tmp33_;
	GList* _tmp34_;
	GtkApplicationWindow* _tmp62_;
	GtkButton* _tmp63_;
	GtkStack* _tmp64_;
#line 561 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 3188 "gnome-nibbles.c"
	{
		GeeLinkedList* _button_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _button_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _button_index = 0;
#line 564 "gnome-nibbles.vala"
		_tmp0_ = self->priv->number_of_players_buttons;
#line 564 "gnome-nibbles.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 564 "gnome-nibbles.vala"
		_button_list = _tmp1_;
#line 564 "gnome-nibbles.vala"
		_tmp2_ = _button_list;
#line 564 "gnome-nibbles.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 564 "gnome-nibbles.vala"
		_tmp4_ = _tmp3_;
#line 564 "gnome-nibbles.vala"
		_button_size = _tmp4_;
#line 564 "gnome-nibbles.vala"
		_button_index = -1;
#line 564 "gnome-nibbles.vala"
		while (TRUE) {
#line 3216 "gnome-nibbles.c"
			GtkToggleButton* button = NULL;
			GeeLinkedList* _tmp5_;
			gpointer _tmp6_;
			GtkToggleButton* _tmp7_;
#line 564 "gnome-nibbles.vala"
			_button_index = _button_index + 1;
#line 564 "gnome-nibbles.vala"
			if (!(_button_index < _button_size)) {
#line 564 "gnome-nibbles.vala"
				break;
#line 3227 "gnome-nibbles.c"
			}
#line 564 "gnome-nibbles.vala"
			_tmp5_ = _button_list;
#line 564 "gnome-nibbles.vala"
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _button_index);
#line 564 "gnome-nibbles.vala"
			button = (GtkToggleButton*) _tmp6_;
#line 566 "gnome-nibbles.vala"
			_tmp7_ = button;
#line 566 "gnome-nibbles.vala"
			if (gtk_toggle_button_get_active (_tmp7_)) {
#line 3239 "gnome-nibbles.c"
				gint numhumans = 0;
				GtkToggleButton* _tmp8_;
				const gchar* _tmp9_;
				NibblesGame* _tmp10_;
				GSettings* _tmp11_;
				NibblesGame* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
#line 568 "gnome-nibbles.vala"
				numhumans = -1;
#line 569 "gnome-nibbles.vala"
				_tmp8_ = button;
#line 569 "gnome-nibbles.vala"
				_tmp9_ = gtk_button_get_label ((GtkButton*) _tmp8_);
#line 569 "gnome-nibbles.vala"
				sscanf (_tmp9_, "_%d", &numhumans);
#line 570 "gnome-nibbles.vala"
				_tmp10_ = self->priv->game;
#line 570 "gnome-nibbles.vala"
				nibbles_game_set_numhumans (_tmp10_, numhumans);
#line 573 "gnome-nibbles.vala"
				_tmp11_ = self->priv->settings;
#line 573 "gnome-nibbles.vala"
				_tmp12_ = self->priv->game;
#line 573 "gnome-nibbles.vala"
				_tmp13_ = nibbles_game_get_numhumans (_tmp12_);
#line 573 "gnome-nibbles.vala"
				_tmp14_ = _tmp13_;
#line 573 "gnome-nibbles.vala"
				g_settings_set_int (_tmp11_, "players", _tmp14_);
#line 574 "gnome-nibbles.vala"
				_g_object_unref0 (button);
#line 574 "gnome-nibbles.vala"
				break;
#line 3274 "gnome-nibbles.c"
			}
#line 564 "gnome-nibbles.vala"
			_g_object_unref0 (button);
#line 3278 "gnome-nibbles.c"
		}
#line 564 "gnome-nibbles.vala"
		_g_object_unref0 (_button_list);
#line 3282 "gnome-nibbles.c"
	}
	{
		GeeLinkedList* _button_list = NULL;
		GeeLinkedList* _tmp15_;
		GeeLinkedList* _tmp16_;
		gint _button_size = 0;
		GeeLinkedList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _button_index = 0;
#line 579 "gnome-nibbles.vala"
		_tmp15_ = self->priv->number_of_ai_buttons;
#line 579 "gnome-nibbles.vala"
		_tmp16_ = _g_object_ref0 (_tmp15_);
#line 579 "gnome-nibbles.vala"
		_button_list = _tmp16_;
#line 579 "gnome-nibbles.vala"
		_tmp17_ = _button_list;
#line 579 "gnome-nibbles.vala"
		_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
#line 579 "gnome-nibbles.vala"
		_tmp19_ = _tmp18_;
#line 579 "gnome-nibbles.vala"
		_button_size = _tmp19_;
#line 579 "gnome-nibbles.vala"
		_button_index = -1;
#line 579 "gnome-nibbles.vala"
		while (TRUE) {
#line 3311 "gnome-nibbles.c"
			GtkToggleButton* button = NULL;
			GeeLinkedList* _tmp20_;
			gpointer _tmp21_;
			GtkToggleButton* _tmp22_;
#line 579 "gnome-nibbles.vala"
			_button_index = _button_index + 1;
#line 579 "gnome-nibbles.vala"
			if (!(_button_index < _button_size)) {
#line 579 "gnome-nibbles.vala"
				break;
#line 3322 "gnome-nibbles.c"
			}
#line 579 "gnome-nibbles.vala"
			_tmp20_ = _button_list;
#line 579 "gnome-nibbles.vala"
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _button_index);
#line 579 "gnome-nibbles.vala"
			button = (GtkToggleButton*) _tmp21_;
#line 581 "gnome-nibbles.vala"
			_tmp22_ = button;
#line 581 "gnome-nibbles.vala"
			if (gtk_toggle_button_get_active (_tmp22_)) {
#line 3334 "gnome-nibbles.c"
				gint numai = 0;
				GtkToggleButton* _tmp23_;
				const gchar* _tmp24_;
				NibblesGame* _tmp25_;
				GSettings* _tmp26_;
				NibblesGame* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
#line 583 "gnome-nibbles.vala"
				numai = -1;
#line 584 "gnome-nibbles.vala"
				_tmp23_ = button;
#line 584 "gnome-nibbles.vala"
				_tmp24_ = gtk_button_get_label ((GtkButton*) _tmp23_);
#line 584 "gnome-nibbles.vala"
				sscanf (_tmp24_, "_%d", &numai);
#line 585 "gnome-nibbles.vala"
				_tmp25_ = self->priv->game;
#line 585 "gnome-nibbles.vala"
				nibbles_game_set_numai (_tmp25_, numai);
#line 588 "gnome-nibbles.vala"
				_tmp26_ = self->priv->settings;
#line 588 "gnome-nibbles.vala"
				_tmp27_ = self->priv->game;
#line 588 "gnome-nibbles.vala"
				_tmp28_ = nibbles_game_get_numai (_tmp27_);
#line 588 "gnome-nibbles.vala"
				_tmp29_ = _tmp28_;
#line 588 "gnome-nibbles.vala"
				g_settings_set_int (_tmp26_, "ai", _tmp29_);
#line 589 "gnome-nibbles.vala"
				_g_object_unref0 (button);
#line 589 "gnome-nibbles.vala"
				break;
#line 3369 "gnome-nibbles.c"
			}
#line 579 "gnome-nibbles.vala"
			_g_object_unref0 (button);
#line 3373 "gnome-nibbles.c"
		}
#line 579 "gnome-nibbles.vala"
		_g_object_unref0 (_button_list);
#line 3377 "gnome-nibbles.c"
	}
#line 594 "gnome-nibbles.vala"
	_tmp30_ = self->priv->game;
#line 594 "gnome-nibbles.vala"
	nibbles_game_create_worms (_tmp30_);
#line 595 "gnome-nibbles.vala"
	_tmp31_ = self->priv->game;
#line 595 "gnome-nibbles.vala"
	_tmp32_ = self->priv->worm_settings;
#line 595 "gnome-nibbles.vala"
	nibbles_game_load_worm_properties (_tmp31_, _tmp32_);
#line 597 "gnome-nibbles.vala"
	_tmp33_ = self->priv->grids_box;
#line 597 "gnome-nibbles.vala"
	_tmp34_ = gtk_container_get_children ((GtkContainer*) _tmp33_);
#line 3393 "gnome-nibbles.c"
	{
		GList* grid_collection = NULL;
		GList* grid_it = NULL;
#line 597 "gnome-nibbles.vala"
		grid_collection = _tmp34_;
#line 597 "gnome-nibbles.vala"
		for (grid_it = grid_collection; grid_it != NULL; grid_it = grid_it->next) {
#line 3401 "gnome-nibbles.c"
			GtkWidget* grid = NULL;
#line 597 "gnome-nibbles.vala"
			grid = (GtkWidget*) grid_it->data;
#line 3405 "gnome-nibbles.c"
			{
				GtkWidget* _tmp35_;
#line 598 "gnome-nibbles.vala"
				_tmp35_ = grid;
#line 598 "gnome-nibbles.vala"
				gtk_widget_destroy (_tmp35_);
#line 3412 "gnome-nibbles.c"
			}
		}
#line 597 "gnome-nibbles.vala"
		(grid_collection == NULL) ? NULL : (grid_collection = (g_list_free (grid_collection), NULL));
#line 3417 "gnome-nibbles.c"
	}
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp36_;
		GeeLinkedList* _tmp37_;
		GeeLinkedList* _tmp38_;
		GeeLinkedList* _tmp39_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _worm_index = 0;
#line 600 "gnome-nibbles.vala"
		_tmp36_ = self->priv->game;
#line 600 "gnome-nibbles.vala"
		_tmp37_ = nibbles_game_get_worms (_tmp36_);
#line 600 "gnome-nibbles.vala"
		_tmp38_ = _tmp37_;
#line 600 "gnome-nibbles.vala"
		_tmp39_ = _g_object_ref0 (_tmp38_);
#line 600 "gnome-nibbles.vala"
		_worm_list = _tmp39_;
#line 600 "gnome-nibbles.vala"
		_tmp40_ = _worm_list;
#line 600 "gnome-nibbles.vala"
		_tmp41_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp40_);
#line 600 "gnome-nibbles.vala"
		_tmp42_ = _tmp41_;
#line 600 "gnome-nibbles.vala"
		_worm_size = _tmp42_;
#line 600 "gnome-nibbles.vala"
		_worm_index = -1;
#line 600 "gnome-nibbles.vala"
		while (TRUE) {
#line 3452 "gnome-nibbles.c"
			Worm* worm = NULL;
			GeeLinkedList* _tmp43_;
			gpointer _tmp44_;
			Worm* _tmp45_;
#line 600 "gnome-nibbles.vala"
			_worm_index = _worm_index + 1;
#line 600 "gnome-nibbles.vala"
			if (!(_worm_index < _worm_size)) {
#line 600 "gnome-nibbles.vala"
				break;
#line 3463 "gnome-nibbles.c"
			}
#line 600 "gnome-nibbles.vala"
			_tmp43_ = _worm_list;
#line 600 "gnome-nibbles.vala"
			_tmp44_ = gee_abstract_list_get ((GeeAbstractList*) _tmp43_, _worm_index);
#line 600 "gnome-nibbles.vala"
			worm = (Worm*) _tmp44_;
#line 602 "gnome-nibbles.vala"
			_tmp45_ = worm;
#line 602 "gnome-nibbles.vala"
			if (_tmp45_->is_human) {
#line 3475 "gnome-nibbles.c"
				ControlsGrid* grid = NULL;
				Worm* _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				NibblesGame* _tmp49_;
				GeeHashMap* _tmp50_;
				GeeHashMap* _tmp51_;
				Worm* _tmp52_;
				gpointer _tmp53_;
				WormProperties* _tmp54_;
				GdkPixbuf* _tmp55_;
				GdkPixbuf* _tmp56_;
				WormProperties _tmp57_;
				ControlsGrid* _tmp58_;
				ControlsGrid* _tmp59_;
				GtkBox* _tmp60_;
				ControlsGrid* _tmp61_;
#line 604 "gnome-nibbles.vala"
				_tmp46_ = worm;
#line 604 "gnome-nibbles.vala"
				_tmp47_ = worm_get_id (_tmp46_);
#line 604 "gnome-nibbles.vala"
				_tmp48_ = _tmp47_;
#line 604 "gnome-nibbles.vala"
				_tmp49_ = self->priv->game;
#line 604 "gnome-nibbles.vala"
				_tmp50_ = nibbles_game_get_worm_props (_tmp49_);
#line 604 "gnome-nibbles.vala"
				_tmp51_ = _tmp50_;
#line 604 "gnome-nibbles.vala"
				_tmp52_ = worm;
#line 604 "gnome-nibbles.vala"
				_tmp53_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp51_, _tmp52_);
#line 604 "gnome-nibbles.vala"
				_tmp54_ = (WormProperties*) _tmp53_;
#line 604 "gnome-nibbles.vala"
				_tmp55_ = self->priv->arrow_pixbuf;
#line 604 "gnome-nibbles.vala"
				_tmp56_ = self->priv->arrow_key_pixbuf;
#line 604 "gnome-nibbles.vala"
				_tmp57_ = *_tmp54_;
#line 604 "gnome-nibbles.vala"
				_tmp58_ = controls_grid_new (_tmp48_, &_tmp57_, _tmp55_, _tmp56_);
#line 604 "gnome-nibbles.vala"
				g_object_ref_sink (_tmp58_);
#line 604 "gnome-nibbles.vala"
				_tmp59_ = _tmp58_;
#line 604 "gnome-nibbles.vala"
				_worm_properties_free0 (_tmp54_);
#line 604 "gnome-nibbles.vala"
				grid = _tmp59_;
#line 605 "gnome-nibbles.vala"
				_tmp60_ = self->priv->grids_box;
#line 605 "gnome-nibbles.vala"
				_tmp61_ = grid;
#line 605 "gnome-nibbles.vala"
				gtk_container_add ((GtkContainer*) _tmp60_, (GtkWidget*) _tmp61_);
#line 602 "gnome-nibbles.vala"
				_g_object_unref0 (grid);
#line 3535 "gnome-nibbles.c"
			}
#line 600 "gnome-nibbles.vala"
			_g_object_unref0 (worm);
#line 3539 "gnome-nibbles.c"
		}
#line 600 "gnome-nibbles.vala"
		_g_object_unref0 (_worm_list);
#line 3543 "gnome-nibbles.c"
	}
#line 609 "gnome-nibbles.vala"
	_tmp62_ = self->priv->window;
#line 609 "gnome-nibbles.vala"
	_tmp63_ = self->priv->start_button;
#line 609 "gnome-nibbles.vala"
	gtk_window_set_default ((GtkWindow*) _tmp62_, (GtkWidget*) _tmp63_);
#line 611 "gnome-nibbles.vala"
	_tmp64_ = self->priv->main_stack;
#line 611 "gnome-nibbles.vala"
	gtk_stack_set_visible_child_name (_tmp64_, "controls");
#line 3555 "gnome-nibbles.c"
}

static void
nibbles_show_game_view (Nibbles* self)
{
	GtkStack* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GSimpleAction* _tmp3_;
	GtkHeaderBar* _tmp4_;
	NibblesGame* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GtkStack* _tmp10_;
	GtkStack* _tmp11_;
#line 614 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 620 "gnome-nibbles.vala"
	_tmp0_ = self->priv->main_stack;
#line 620 "gnome-nibbles.vala"
	gtk_stack_set_transition_type (_tmp0_, GTK_STACK_TRANSITION_TYPE_NONE);
#line 621 "gnome-nibbles.vala"
	_tmp1_ = self->priv->new_game_button;
#line 621 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp1_);
#line 622 "gnome-nibbles.vala"
	_tmp2_ = self->priv->pause_button;
#line 622 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp2_);
#line 624 "gnome-nibbles.vala"
	_tmp3_ = self->priv->back_action;
#line 624 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp3_, FALSE);
#line 626 "gnome-nibbles.vala"
	_tmp4_ = self->priv->headerbar;
#line 626 "gnome-nibbles.vala"
	_tmp5_ = self->priv->game;
#line 626 "gnome-nibbles.vala"
	_tmp6_ = nibbles_game_get_current_level (_tmp5_);
#line 626 "gnome-nibbles.vala"
	_tmp7_ = _tmp6_;
#line 626 "gnome-nibbles.vala"
	_tmp8_ = g_strdup_printf (_ ("Level %d"), _tmp7_);
#line 626 "gnome-nibbles.vala"
	_tmp9_ = _tmp8_;
#line 626 "gnome-nibbles.vala"
	gtk_header_bar_set_title (_tmp4_, _tmp9_);
#line 626 "gnome-nibbles.vala"
	_g_free0 (_tmp9_);
#line 627 "gnome-nibbles.vala"
	_tmp10_ = self->priv->main_stack;
#line 627 "gnome-nibbles.vala"
	gtk_stack_set_visible_child_name (_tmp10_, "game_box");
#line 629 "gnome-nibbles.vala"
	_tmp11_ = self->priv->main_stack;
#line 629 "gnome-nibbles.vala"
	gtk_stack_set_transition_type (_tmp11_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
#line 3615 "gnome-nibbles.c"
}

static void
nibbles_back_cb (Nibbles* self)
{
	GtkStack* _tmp0_;
	gchar* child_name = NULL;
	GtkStack* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
#line 637 "gnome-nibbles.vala"
	static GQuark _tmp6_label0 = 0;
#line 637 "gnome-nibbles.vala"
	static GQuark _tmp6_label1 = 0;
#line 637 "gnome-nibbles.vala"
	static GQuark _tmp6_label2 = 0;
#line 637 "gnome-nibbles.vala"
	static GQuark _tmp6_label3 = 0;
#line 3637 "gnome-nibbles.c"
	GtkStack* _tmp9_;
#line 632 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 634 "gnome-nibbles.vala"
	_tmp0_ = self->priv->main_stack;
#line 634 "gnome-nibbles.vala"
	gtk_stack_set_transition_type (_tmp0_, GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN);
#line 636 "gnome-nibbles.vala"
	_tmp1_ = self->priv->main_stack;
#line 636 "gnome-nibbles.vala"
	_tmp2_ = gtk_stack_get_visible_child_name (_tmp1_);
#line 636 "gnome-nibbles.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 636 "gnome-nibbles.vala"
	child_name = _tmp3_;
#line 637 "gnome-nibbles.vala"
	_tmp4_ = child_name;
#line 637 "gnome-nibbles.vala"
	_tmp5_ = _tmp4_;
#line 637 "gnome-nibbles.vala"
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
#line 637 "gnome-nibbles.vala"
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("first_run")))) {
#line 637 "gnome-nibbles.vala"
		switch (0) {
#line 3663 "gnome-nibbles.c"
			default:
			{
#line 640 "gnome-nibbles.vala"
				break;
#line 3668 "gnome-nibbles.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("number_of_players")))) {
#line 637 "gnome-nibbles.vala"
		switch (0) {
#line 3674 "gnome-nibbles.c"
			default:
			{
#line 642 "gnome-nibbles.vala"
				break;
#line 3679 "gnome-nibbles.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("controls")))) {
#line 637 "gnome-nibbles.vala"
		switch (0) {
#line 3685 "gnome-nibbles.c"
			default:
			{
				GtkStack* _tmp8_;
#line 644 "gnome-nibbles.vala"
				_tmp8_ = self->priv->main_stack;
#line 644 "gnome-nibbles.vala"
				gtk_stack_set_visible_child_name (_tmp8_, "number_of_players");
#line 645 "gnome-nibbles.vala"
				break;
#line 3695 "gnome-nibbles.c"
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("game_box")))) {
#line 637 "gnome-nibbles.vala"
		switch (0) {
#line 3701 "gnome-nibbles.c"
			default:
			{
#line 647 "gnome-nibbles.vala"
				nibbles_new_game_cb (self);
#line 648 "gnome-nibbles.vala"
				break;
#line 3708 "gnome-nibbles.c"
			}
		}
	}
#line 651 "gnome-nibbles.vala"
	_tmp9_ = self->priv->main_stack;
#line 651 "gnome-nibbles.vala"
	gtk_stack_set_transition_type (_tmp9_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
#line 632 "gnome-nibbles.vala"
	_g_free0 (child_name);
#line 3718 "gnome-nibbles.c"
}

static void
nibbles_change_number_of_players_cb (Nibbles* self,
                                     GtkToggleButton* button)
{
	gint numhumans = 0;
	const gchar* _tmp12_;
	gint min_ai = 0;
	gint max_ai = 0;
	GeeLinkedList* _tmp34_;
	gpointer _tmp35_;
	GtkToggleButton* _tmp36_;
#line 654 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 654 "gnome-nibbles.vala"
	g_return_if_fail (button != NULL);
#line 3736 "gnome-nibbles.c"
	{
		GeeLinkedList* _other_button_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _other_button_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _other_button_index = 0;
#line 656 "gnome-nibbles.vala"
		_tmp0_ = self->priv->number_of_players_buttons;
#line 656 "gnome-nibbles.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 656 "gnome-nibbles.vala"
		_other_button_list = _tmp1_;
#line 656 "gnome-nibbles.vala"
		_tmp2_ = _other_button_list;
#line 656 "gnome-nibbles.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 656 "gnome-nibbles.vala"
		_tmp4_ = _tmp3_;
#line 656 "gnome-nibbles.vala"
		_other_button_size = _tmp4_;
#line 656 "gnome-nibbles.vala"
		_other_button_index = -1;
#line 656 "gnome-nibbles.vala"
		while (TRUE) {
#line 3764 "gnome-nibbles.c"
			GtkToggleButton* other_button = NULL;
			GeeLinkedList* _tmp5_;
			gpointer _tmp6_;
			GtkToggleButton* _tmp7_;
#line 656 "gnome-nibbles.vala"
			_other_button_index = _other_button_index + 1;
#line 656 "gnome-nibbles.vala"
			if (!(_other_button_index < _other_button_size)) {
#line 656 "gnome-nibbles.vala"
				break;
#line 3775 "gnome-nibbles.c"
			}
#line 656 "gnome-nibbles.vala"
			_tmp5_ = _other_button_list;
#line 656 "gnome-nibbles.vala"
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _other_button_index);
#line 656 "gnome-nibbles.vala"
			other_button = (GtkToggleButton*) _tmp6_;
#line 658 "gnome-nibbles.vala"
			_tmp7_ = other_button;
#line 658 "gnome-nibbles.vala"
			if (button != _tmp7_) {
#line 3787 "gnome-nibbles.c"
				GtkToggleButton* _tmp8_;
#line 660 "gnome-nibbles.vala"
				_tmp8_ = other_button;
#line 660 "gnome-nibbles.vala"
				if (gtk_toggle_button_get_active (_tmp8_)) {
#line 3793 "gnome-nibbles.c"
					GtkToggleButton* _tmp9_;
					GtkToggleButton* _tmp10_;
					GtkToggleButton* _tmp11_;
#line 665 "gnome-nibbles.vala"
					_tmp9_ = other_button;
#line 665 "gnome-nibbles.vala"
					g_signal_handlers_block_matched (_tmp9_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
#line 666 "gnome-nibbles.vala"
					_tmp10_ = other_button;
#line 666 "gnome-nibbles.vala"
					gtk_toggle_button_set_active (_tmp10_, FALSE);
#line 667 "gnome-nibbles.vala"
					_tmp11_ = other_button;
#line 667 "gnome-nibbles.vala"
					g_signal_handlers_unblock_matched (_tmp11_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
#line 668 "gnome-nibbles.vala"
					_g_object_unref0 (other_button);
#line 668 "gnome-nibbles.vala"
					break;
#line 3813 "gnome-nibbles.c"
				}
			}
#line 656 "gnome-nibbles.vala"
			_g_object_unref0 (other_button);
#line 3818 "gnome-nibbles.c"
		}
#line 656 "gnome-nibbles.vala"
		_g_object_unref0 (_other_button_list);
#line 3822 "gnome-nibbles.c"
	}
#line 672 "gnome-nibbles.vala"
	gtk_toggle_button_set_active (button, TRUE);
#line 674 "gnome-nibbles.vala"
	numhumans = -1;
#line 675 "gnome-nibbles.vala"
	_tmp12_ = gtk_button_get_label ((GtkButton*) button);
#line 675 "gnome-nibbles.vala"
	sscanf (_tmp12_, "_%d", &numhumans);
#line 677 "gnome-nibbles.vala"
	min_ai = 4 - numhumans;
#line 678 "gnome-nibbles.vala"
	max_ai = NIBBLES_GAME_MAX_WORMS - numhumans;
#line 3836 "gnome-nibbles.c"
	{
		gint i = 0;
#line 679 "gnome-nibbles.vala"
		i = 0;
#line 3841 "gnome-nibbles.c"
		{
			gboolean _tmp13_ = FALSE;
#line 679 "gnome-nibbles.vala"
			_tmp13_ = TRUE;
#line 679 "gnome-nibbles.vala"
			while (TRUE) {
#line 3848 "gnome-nibbles.c"
				GeeLinkedList* _tmp15_;
				gpointer _tmp16_;
				GtkToggleButton* _tmp17_;
#line 679 "gnome-nibbles.vala"
				if (!_tmp13_) {
#line 3854 "gnome-nibbles.c"
					gint _tmp14_;
#line 679 "gnome-nibbles.vala"
					_tmp14_ = i;
#line 679 "gnome-nibbles.vala"
					i = _tmp14_ + 1;
#line 3860 "gnome-nibbles.c"
				}
#line 679 "gnome-nibbles.vala"
				_tmp13_ = FALSE;
#line 679 "gnome-nibbles.vala"
				if (!(i < min_ai)) {
#line 679 "gnome-nibbles.vala"
					break;
#line 3868 "gnome-nibbles.c"
				}
#line 681 "gnome-nibbles.vala"
				_tmp15_ = self->priv->number_of_ai_buttons;
#line 681 "gnome-nibbles.vala"
				_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, i);
#line 681 "gnome-nibbles.vala"
				_tmp17_ = (GtkToggleButton*) _tmp16_;
#line 681 "gnome-nibbles.vala"
				gtk_widget_hide ((GtkWidget*) _tmp17_);
#line 681 "gnome-nibbles.vala"
				_g_object_unref0 (_tmp17_);
#line 3880 "gnome-nibbles.c"
			}
		}
	}
	{
		gint i = 0;
#line 683 "gnome-nibbles.vala"
		i = min_ai;
#line 3888 "gnome-nibbles.c"
		{
			gboolean _tmp18_ = FALSE;
#line 683 "gnome-nibbles.vala"
			_tmp18_ = TRUE;
#line 683 "gnome-nibbles.vala"
			while (TRUE) {
#line 3895 "gnome-nibbles.c"
				GeeLinkedList* _tmp20_;
				gpointer _tmp21_;
				GtkToggleButton* _tmp22_;
#line 683 "gnome-nibbles.vala"
				if (!_tmp18_) {
#line 3901 "gnome-nibbles.c"
					gint _tmp19_;
#line 683 "gnome-nibbles.vala"
					_tmp19_ = i;
#line 683 "gnome-nibbles.vala"
					i = _tmp19_ + 1;
#line 3907 "gnome-nibbles.c"
				}
#line 683 "gnome-nibbles.vala"
				_tmp18_ = FALSE;
#line 683 "gnome-nibbles.vala"
				if (!(i <= max_ai)) {
#line 683 "gnome-nibbles.vala"
					break;
#line 3915 "gnome-nibbles.c"
				}
#line 685 "gnome-nibbles.vala"
				_tmp20_ = self->priv->number_of_ai_buttons;
#line 685 "gnome-nibbles.vala"
				_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, i);
#line 685 "gnome-nibbles.vala"
				_tmp22_ = (GtkToggleButton*) _tmp21_;
#line 685 "gnome-nibbles.vala"
				gtk_widget_show ((GtkWidget*) _tmp22_);
#line 685 "gnome-nibbles.vala"
				_g_object_unref0 (_tmp22_);
#line 3927 "gnome-nibbles.c"
			}
		}
	}
	{
		gint i = 0;
#line 687 "gnome-nibbles.vala"
		i = max_ai + 1;
#line 3935 "gnome-nibbles.c"
		{
			gboolean _tmp23_ = FALSE;
#line 687 "gnome-nibbles.vala"
			_tmp23_ = TRUE;
#line 687 "gnome-nibbles.vala"
			while (TRUE) {
#line 3942 "gnome-nibbles.c"
				GeeLinkedList* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				GeeLinkedList* _tmp28_;
				gpointer _tmp29_;
				GtkToggleButton* _tmp30_;
#line 687 "gnome-nibbles.vala"
				if (!_tmp23_) {
#line 3951 "gnome-nibbles.c"
					gint _tmp24_;
#line 687 "gnome-nibbles.vala"
					_tmp24_ = i;
#line 687 "gnome-nibbles.vala"
					i = _tmp24_ + 1;
#line 3957 "gnome-nibbles.c"
				}
#line 687 "gnome-nibbles.vala"
				_tmp23_ = FALSE;
#line 687 "gnome-nibbles.vala"
				_tmp25_ = self->priv->number_of_ai_buttons;
#line 687 "gnome-nibbles.vala"
				_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
#line 687 "gnome-nibbles.vala"
				_tmp27_ = _tmp26_;
#line 687 "gnome-nibbles.vala"
				if (!(i < _tmp27_)) {
#line 687 "gnome-nibbles.vala"
					break;
#line 3971 "gnome-nibbles.c"
				}
#line 689 "gnome-nibbles.vala"
				_tmp28_ = self->priv->number_of_ai_buttons;
#line 689 "gnome-nibbles.vala"
				_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, i);
#line 689 "gnome-nibbles.vala"
				_tmp30_ = (GtkToggleButton*) _tmp29_;
#line 689 "gnome-nibbles.vala"
				gtk_widget_hide ((GtkWidget*) _tmp30_);
#line 689 "gnome-nibbles.vala"
				_g_object_unref0 (_tmp30_);
#line 3983 "gnome-nibbles.c"
			}
		}
	}
#line 692 "gnome-nibbles.vala"
	if (numhumans == 4) {
#line 3989 "gnome-nibbles.c"
		GeeLinkedList* _tmp31_;
		gpointer _tmp32_;
		GtkToggleButton* _tmp33_;
#line 694 "gnome-nibbles.vala"
		_tmp31_ = self->priv->number_of_ai_buttons;
#line 694 "gnome-nibbles.vala"
		_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, 0);
#line 694 "gnome-nibbles.vala"
		_tmp33_ = (GtkToggleButton*) _tmp32_;
#line 694 "gnome-nibbles.vala"
		gtk_widget_show ((GtkWidget*) _tmp33_);
#line 694 "gnome-nibbles.vala"
		_g_object_unref0 (_tmp33_);
#line 4003 "gnome-nibbles.c"
	}
#line 697 "gnome-nibbles.vala"
	_tmp34_ = self->priv->number_of_ai_buttons;
#line 697 "gnome-nibbles.vala"
	_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, min_ai);
#line 697 "gnome-nibbles.vala"
	_tmp36_ = (GtkToggleButton*) _tmp35_;
#line 697 "gnome-nibbles.vala"
	gtk_toggle_button_set_active (_tmp36_, TRUE);
#line 697 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp36_);
#line 4015 "gnome-nibbles.c"
}

static void
nibbles_change_number_of_ai_cb (Nibbles* self,
                                GtkToggleButton* button)
{
#line 700 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 700 "gnome-nibbles.vala"
	g_return_if_fail (button != NULL);
#line 4026 "gnome-nibbles.c"
	{
		GeeLinkedList* _other_button_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _other_button_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _other_button_index = 0;
#line 702 "gnome-nibbles.vala"
		_tmp0_ = self->priv->number_of_ai_buttons;
#line 702 "gnome-nibbles.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 702 "gnome-nibbles.vala"
		_other_button_list = _tmp1_;
#line 702 "gnome-nibbles.vala"
		_tmp2_ = _other_button_list;
#line 702 "gnome-nibbles.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 702 "gnome-nibbles.vala"
		_tmp4_ = _tmp3_;
#line 702 "gnome-nibbles.vala"
		_other_button_size = _tmp4_;
#line 702 "gnome-nibbles.vala"
		_other_button_index = -1;
#line 702 "gnome-nibbles.vala"
		while (TRUE) {
#line 4054 "gnome-nibbles.c"
			GtkToggleButton* other_button = NULL;
			GeeLinkedList* _tmp5_;
			gpointer _tmp6_;
			GtkToggleButton* _tmp7_;
#line 702 "gnome-nibbles.vala"
			_other_button_index = _other_button_index + 1;
#line 702 "gnome-nibbles.vala"
			if (!(_other_button_index < _other_button_size)) {
#line 702 "gnome-nibbles.vala"
				break;
#line 4065 "gnome-nibbles.c"
			}
#line 702 "gnome-nibbles.vala"
			_tmp5_ = _other_button_list;
#line 702 "gnome-nibbles.vala"
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _other_button_index);
#line 702 "gnome-nibbles.vala"
			other_button = (GtkToggleButton*) _tmp6_;
#line 704 "gnome-nibbles.vala"
			_tmp7_ = other_button;
#line 704 "gnome-nibbles.vala"
			if (button != _tmp7_) {
#line 4077 "gnome-nibbles.c"
				GtkToggleButton* _tmp8_;
#line 706 "gnome-nibbles.vala"
				_tmp8_ = other_button;
#line 706 "gnome-nibbles.vala"
				if (gtk_toggle_button_get_active (_tmp8_)) {
#line 4083 "gnome-nibbles.c"
					GtkToggleButton* _tmp9_;
					GtkToggleButton* _tmp10_;
					GtkToggleButton* _tmp11_;
#line 711 "gnome-nibbles.vala"
					_tmp9_ = other_button;
#line 711 "gnome-nibbles.vala"
					g_signal_handlers_block_matched (_tmp9_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
#line 712 "gnome-nibbles.vala"
					_tmp10_ = other_button;
#line 712 "gnome-nibbles.vala"
					gtk_toggle_button_set_active (_tmp10_, FALSE);
#line 713 "gnome-nibbles.vala"
					_tmp11_ = other_button;
#line 713 "gnome-nibbles.vala"
					g_signal_handlers_unblock_matched (_tmp11_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
#line 714 "gnome-nibbles.vala"
					_g_object_unref0 (other_button);
#line 714 "gnome-nibbles.vala"
					break;
#line 4103 "gnome-nibbles.c"
				}
			}
#line 702 "gnome-nibbles.vala"
			_g_object_unref0 (other_button);
#line 4108 "gnome-nibbles.c"
		}
#line 702 "gnome-nibbles.vala"
		_g_object_unref0 (_other_button_list);
#line 4112 "gnome-nibbles.c"
	}
#line 718 "gnome-nibbles.vala"
	gtk_toggle_button_set_active (button, TRUE);
#line 4116 "gnome-nibbles.c"
}

static GamesScoresCategory*
nibbles_category_request (Nibbles* self,
                          const gchar* key)
{
	GamesScoresCategory* result = NULL;
#line 725 "gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 725 "gnome-nibbles.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 4128 "gnome-nibbles.c"
	{
		GeeLinkedList* _cat_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _cat_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _cat_index = 0;
#line 727 "gnome-nibbles.vala"
		_tmp0_ = self->priv->scorecats;
#line 727 "gnome-nibbles.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 727 "gnome-nibbles.vala"
		_cat_list = _tmp1_;
#line 727 "gnome-nibbles.vala"
		_tmp2_ = _cat_list;
#line 727 "gnome-nibbles.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 727 "gnome-nibbles.vala"
		_tmp4_ = _tmp3_;
#line 727 "gnome-nibbles.vala"
		_cat_size = _tmp4_;
#line 727 "gnome-nibbles.vala"
		_cat_index = -1;
#line 727 "gnome-nibbles.vala"
		while (TRUE) {
#line 4156 "gnome-nibbles.c"
			GamesScoresCategory* cat = NULL;
			GeeLinkedList* _tmp5_;
			gpointer _tmp6_;
			GamesScoresCategory* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
#line 727 "gnome-nibbles.vala"
			_cat_index = _cat_index + 1;
#line 727 "gnome-nibbles.vala"
			if (!(_cat_index < _cat_size)) {
#line 727 "gnome-nibbles.vala"
				break;
#line 4169 "gnome-nibbles.c"
			}
#line 727 "gnome-nibbles.vala"
			_tmp5_ = _cat_list;
#line 727 "gnome-nibbles.vala"
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _cat_index);
#line 727 "gnome-nibbles.vala"
			cat = (GamesScoresCategory*) _tmp6_;
#line 729 "gnome-nibbles.vala"
			_tmp7_ = cat;
#line 729 "gnome-nibbles.vala"
			_tmp8_ = games_scores_category_get_key (_tmp7_);
#line 729 "gnome-nibbles.vala"
			_tmp9_ = _tmp8_;
#line 729 "gnome-nibbles.vala"
			if (g_strcmp0 (key, _tmp9_) == 0) {
#line 730 "gnome-nibbles.vala"
				result = cat;
#line 730 "gnome-nibbles.vala"
				_g_object_unref0 (_cat_list);
#line 730 "gnome-nibbles.vala"
				return result;
#line 4191 "gnome-nibbles.c"
			}
#line 727 "gnome-nibbles.vala"
			_g_object_unref0 (cat);
#line 4195 "gnome-nibbles.c"
		}
#line 727 "gnome-nibbles.vala"
		_g_object_unref0 (_cat_list);
#line 4199 "gnome-nibbles.c"
	}
#line 732 "gnome-nibbles.vala"
	result = NULL;
#line 732 "gnome-nibbles.vala"
	return result;
#line 4205 "gnome-nibbles.c"
}

static gchar*
nibbles_get_new_scores_key (Nibbles* self,
                            const gchar* old_key)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 737 "gnome-nibbles.vala"
	static GQuark _tmp1_label0 = 0;
#line 737 "gnome-nibbles.vala"
	static GQuark _tmp1_label1 = 0;
#line 737 "gnome-nibbles.vala"
	static GQuark _tmp1_label2 = 0;
#line 737 "gnome-nibbles.vala"
	static GQuark _tmp1_label3 = 0;
#line 737 "gnome-nibbles.vala"
	static GQuark _tmp1_label4 = 0;
#line 737 "gnome-nibbles.vala"
	static GQuark _tmp1_label5 = 0;
#line 737 "gnome-nibbles.vala"
	static GQuark _tmp1_label6 = 0;
#line 737 "gnome-nibbles.vala"
	static GQuark _tmp1_label7 = 0;
#line 735 "gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 735 "gnome-nibbles.vala"
	g_return_val_if_fail (old_key != NULL, NULL);
#line 737 "gnome-nibbles.vala"
	_tmp0_ = old_key;
#line 737 "gnome-nibbles.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 737 "gnome-nibbles.vala"
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("1.0")))) {
#line 737 "gnome-nibbles.vala"
		switch (0) {
#line 4243 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp3_;
#line 740 "gnome-nibbles.vala"
				_tmp3_ = g_strdup ("fast");
#line 740 "gnome-nibbles.vala"
				result = _tmp3_;
#line 740 "gnome-nibbles.vala"
				return result;
#line 4253 "gnome-nibbles.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("2.0")))) {
#line 737 "gnome-nibbles.vala"
		switch (0) {
#line 4259 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp4_;
#line 742 "gnome-nibbles.vala"
				_tmp4_ = g_strdup ("medium");
#line 742 "gnome-nibbles.vala"
				result = _tmp4_;
#line 742 "gnome-nibbles.vala"
				return result;
#line 4269 "gnome-nibbles.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("3.0")))) {
#line 737 "gnome-nibbles.vala"
		switch (0) {
#line 4275 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp5_;
#line 744 "gnome-nibbles.vala"
				_tmp5_ = g_strdup ("slow");
#line 744 "gnome-nibbles.vala"
				result = _tmp5_;
#line 744 "gnome-nibbles.vala"
				return result;
#line 4285 "gnome-nibbles.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("4.0")))) {
#line 737 "gnome-nibbles.vala"
		switch (0) {
#line 4291 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp6_;
#line 746 "gnome-nibbles.vala"
				_tmp6_ = g_strdup ("beginner");
#line 746 "gnome-nibbles.vala"
				result = _tmp6_;
#line 746 "gnome-nibbles.vala"
				return result;
#line 4301 "gnome-nibbles.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("1.1")))) {
#line 737 "gnome-nibbles.vala"
		switch (0) {
#line 4307 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp7_;
#line 748 "gnome-nibbles.vala"
				_tmp7_ = g_strdup ("fast-fakes");
#line 748 "gnome-nibbles.vala"
				result = _tmp7_;
#line 748 "gnome-nibbles.vala"
				return result;
#line 4317 "gnome-nibbles.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("2.1")))) {
#line 737 "gnome-nibbles.vala"
		switch (0) {
#line 4323 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp8_;
#line 750 "gnome-nibbles.vala"
				_tmp8_ = g_strdup ("medium-fakes");
#line 750 "gnome-nibbles.vala"
				result = _tmp8_;
#line 750 "gnome-nibbles.vala"
				return result;
#line 4333 "gnome-nibbles.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("3.1")))) {
#line 737 "gnome-nibbles.vala"
		switch (0) {
#line 4339 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp9_;
#line 752 "gnome-nibbles.vala"
				_tmp9_ = g_strdup ("slow-fakes");
#line 752 "gnome-nibbles.vala"
				result = _tmp9_;
#line 752 "gnome-nibbles.vala"
				return result;
#line 4349 "gnome-nibbles.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("4.1")))) {
#line 737 "gnome-nibbles.vala"
		switch (0) {
#line 4355 "gnome-nibbles.c"
			default:
			{
				gchar* _tmp10_;
#line 754 "gnome-nibbles.vala"
				_tmp10_ = g_strdup ("beginner-fakes");
#line 754 "gnome-nibbles.vala"
				result = _tmp10_;
#line 754 "gnome-nibbles.vala"
				return result;
#line 4365 "gnome-nibbles.c"
			}
		}
	}
#line 756 "gnome-nibbles.vala"
	result = NULL;
#line 756 "gnome-nibbles.vala"
	return result;
#line 4373 "gnome-nibbles.c"
}

static GamesScoresCategory*
_nibbles_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                      gpointer self)
{
	GamesScoresCategory* result;
	result = nibbles_category_request ((Nibbles*) self, category_key);
#line 779 "gnome-nibbles.vala"
	return result;
#line 4384 "gnome-nibbles.c"
}

static gchar*
_nibbles_get_new_scores_key_games_scores_directory_importer_category_convert_func (const gchar* old_key,
                                                                                   gpointer self)
{
	gchar* result;
	result = nibbles_get_new_scores_key ((Nibbles*) self, old_key);
#line 779 "gnome-nibbles.vala"
	return result;
#line 4395 "gnome-nibbles.c"
}

static void
nibbles_create_scores (Nibbles* self)
{
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GamesScoresCategory* _tmp3_;
	GeeLinkedList* _tmp4_;
	GamesScoresCategory* _tmp5_;
	GamesScoresCategory* _tmp6_;
	GeeLinkedList* _tmp7_;
	GamesScoresCategory* _tmp8_;
	GamesScoresCategory* _tmp9_;
	GeeLinkedList* _tmp10_;
	GamesScoresCategory* _tmp11_;
	GamesScoresCategory* _tmp12_;
	GeeLinkedList* _tmp13_;
	GamesScoresCategory* _tmp14_;
	GamesScoresCategory* _tmp15_;
	GeeLinkedList* _tmp16_;
	GamesScoresCategory* _tmp17_;
	GamesScoresCategory* _tmp18_;
	GeeLinkedList* _tmp19_;
	GamesScoresCategory* _tmp20_;
	GamesScoresCategory* _tmp21_;
	GeeLinkedList* _tmp22_;
	GamesScoresCategory* _tmp23_;
	GamesScoresCategory* _tmp24_;
	GtkApplicationWindow* _tmp25_;
	GamesScoresDirectoryImporter* _tmp26_;
	GamesScoresDirectoryImporter* _tmp27_;
	GamesScoresContext* _tmp28_;
#line 759 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 761 "gnome-nibbles.vala"
	_tmp0_ = gee_linked_list_new (GAMES_SCORES_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 761 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scorecats);
#line 761 "gnome-nibbles.vala"
	self->priv->scorecats = _tmp0_;
#line 763 "gnome-nibbles.vala"
	_tmp1_ = self->priv->scorecats;
#line 763 "gnome-nibbles.vala"
	_tmp2_ = games_scores_category_new ("beginner", _ ("Beginner"));
#line 763 "gnome-nibbles.vala"
	_tmp3_ = _tmp2_;
#line 763 "gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp3_);
#line 763 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp3_);
#line 765 "gnome-nibbles.vala"
	_tmp4_ = self->priv->scorecats;
#line 765 "gnome-nibbles.vala"
	_tmp5_ = games_scores_category_new ("slow", _ ("Slow"));
#line 765 "gnome-nibbles.vala"
	_tmp6_ = _tmp5_;
#line 765 "gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp6_);
#line 765 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp6_);
#line 767 "gnome-nibbles.vala"
	_tmp7_ = self->priv->scorecats;
#line 767 "gnome-nibbles.vala"
	_tmp8_ = games_scores_category_new ("medium", _ ("Medium"));
#line 767 "gnome-nibbles.vala"
	_tmp9_ = _tmp8_;
#line 767 "gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp9_);
#line 767 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp9_);
#line 769 "gnome-nibbles.vala"
	_tmp10_ = self->priv->scorecats;
#line 769 "gnome-nibbles.vala"
	_tmp11_ = games_scores_category_new ("fast", _ ("Fast"));
#line 769 "gnome-nibbles.vala"
	_tmp12_ = _tmp11_;
#line 769 "gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp12_);
#line 769 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp12_);
#line 771 "gnome-nibbles.vala"
	_tmp13_ = self->priv->scorecats;
#line 771 "gnome-nibbles.vala"
	_tmp14_ = games_scores_category_new ("beginner-fakes", _ ("Beginner with Fakes"));
#line 771 "gnome-nibbles.vala"
	_tmp15_ = _tmp14_;
#line 771 "gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
#line 771 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp15_);
#line 773 "gnome-nibbles.vala"
	_tmp16_ = self->priv->scorecats;
#line 773 "gnome-nibbles.vala"
	_tmp17_ = games_scores_category_new ("slow-fakes", _ ("Slow with Fakes"));
#line 773 "gnome-nibbles.vala"
	_tmp18_ = _tmp17_;
#line 773 "gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp18_);
#line 773 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp18_);
#line 775 "gnome-nibbles.vala"
	_tmp19_ = self->priv->scorecats;
#line 775 "gnome-nibbles.vala"
	_tmp20_ = games_scores_category_new ("medium-fakes", _ ("Medium with Fakes"));
#line 775 "gnome-nibbles.vala"
	_tmp21_ = _tmp20_;
#line 775 "gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp21_);
#line 775 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp21_);
#line 777 "gnome-nibbles.vala"
	_tmp22_ = self->priv->scorecats;
#line 777 "gnome-nibbles.vala"
	_tmp23_ = games_scores_category_new ("fast-fakes", _ ("Fast with Fakes"));
#line 777 "gnome-nibbles.vala"
	_tmp24_ = _tmp23_;
#line 777 "gnome-nibbles.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp24_);
#line 777 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp24_);
#line 779 "gnome-nibbles.vala"
	_tmp25_ = self->priv->window;
#line 779 "gnome-nibbles.vala"
	_tmp26_ = games_scores_directory_importer_new_with_convert_func (_nibbles_get_new_scores_key_games_scores_directory_importer_category_convert_func, self);
#line 779 "gnome-nibbles.vala"
	_tmp27_ = _tmp26_;
#line 779 "gnome-nibbles.vala"
	_tmp28_ = games_scores_context_new_with_importer ("gnome-nibbles", _ ("Difficulty Level:"), (GtkWindow*) _tmp25_, _nibbles_category_request_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, (GamesScoresImporter*) _tmp27_);
#line 779 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scores_context);
#line 779 "gnome-nibbles.vala"
	self->priv->scores_context = _tmp28_;
#line 779 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp27_);
#line 4532 "gnome-nibbles.c"
}

static GamesScoresCategory*
nibbles_get_scores_category (Nibbles* self,
                             gint speed,
                             gboolean fakes)
{
	GamesScoresCategory* result = NULL;
	gchar* key = NULL;
	GeeLinkedList* _tmp17_;
	gpointer _tmp18_;
#line 789 "gnome-nibbles.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 791 "gnome-nibbles.vala"
	key = NULL;
#line 792 "gnome-nibbles.vala"
	switch (speed) {
#line 792 "gnome-nibbles.vala"
		case 1:
#line 4552 "gnome-nibbles.c"
		{
			gchar* _tmp0_;
#line 795 "gnome-nibbles.vala"
			_tmp0_ = g_strdup ("fast");
#line 795 "gnome-nibbles.vala"
			_g_free0 (key);
#line 795 "gnome-nibbles.vala"
			key = _tmp0_;
#line 796 "gnome-nibbles.vala"
			break;
#line 4563 "gnome-nibbles.c"
		}
#line 792 "gnome-nibbles.vala"
		case 2:
#line 4567 "gnome-nibbles.c"
		{
			gchar* _tmp1_;
#line 798 "gnome-nibbles.vala"
			_tmp1_ = g_strdup ("medium");
#line 798 "gnome-nibbles.vala"
			_g_free0 (key);
#line 798 "gnome-nibbles.vala"
			key = _tmp1_;
#line 799 "gnome-nibbles.vala"
			break;
#line 4578 "gnome-nibbles.c"
		}
#line 792 "gnome-nibbles.vala"
		case 3:
#line 4582 "gnome-nibbles.c"
		{
			gchar* _tmp2_;
#line 801 "gnome-nibbles.vala"
			_tmp2_ = g_strdup ("slow");
#line 801 "gnome-nibbles.vala"
			_g_free0 (key);
#line 801 "gnome-nibbles.vala"
			key = _tmp2_;
#line 802 "gnome-nibbles.vala"
			break;
#line 4593 "gnome-nibbles.c"
		}
#line 792 "gnome-nibbles.vala"
		case 4:
#line 4597 "gnome-nibbles.c"
		{
			gchar* _tmp3_;
#line 804 "gnome-nibbles.vala"
			_tmp3_ = g_strdup ("beginner");
#line 804 "gnome-nibbles.vala"
			_g_free0 (key);
#line 804 "gnome-nibbles.vala"
			key = _tmp3_;
#line 805 "gnome-nibbles.vala"
			break;
#line 4608 "gnome-nibbles.c"
		}
		default:
#line 792 "gnome-nibbles.vala"
		break;
#line 4613 "gnome-nibbles.c"
	}
#line 808 "gnome-nibbles.vala"
	if (fakes) {
#line 4617 "gnome-nibbles.c"
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 809 "gnome-nibbles.vala"
		_tmp4_ = key;
#line 809 "gnome-nibbles.vala"
		_tmp5_ = g_strconcat (_tmp4_, "-fakes", NULL);
#line 809 "gnome-nibbles.vala"
		_g_free0 (key);
#line 809 "gnome-nibbles.vala"
		key = _tmp5_;
#line 4628 "gnome-nibbles.c"
	}
	{
		GeeLinkedList* _cat_list = NULL;
		GeeLinkedList* _tmp6_;
		GeeLinkedList* _tmp7_;
		gint _cat_size = 0;
		GeeLinkedList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _cat_index = 0;
#line 811 "gnome-nibbles.vala"
		_tmp6_ = self->priv->scorecats;
#line 811 "gnome-nibbles.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 811 "gnome-nibbles.vala"
		_cat_list = _tmp7_;
#line 811 "gnome-nibbles.vala"
		_tmp8_ = _cat_list;
#line 811 "gnome-nibbles.vala"
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
#line 811 "gnome-nibbles.vala"
		_tmp10_ = _tmp9_;
#line 811 "gnome-nibbles.vala"
		_cat_size = _tmp10_;
#line 811 "gnome-nibbles.vala"
		_cat_index = -1;
#line 811 "gnome-nibbles.vala"
		while (TRUE) {
#line 4657 "gnome-nibbles.c"
			GamesScoresCategory* cat = NULL;
			GeeLinkedList* _tmp11_;
			gpointer _tmp12_;
			const gchar* _tmp13_;
			GamesScoresCategory* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
#line 811 "gnome-nibbles.vala"
			_cat_index = _cat_index + 1;
#line 811 "gnome-nibbles.vala"
			if (!(_cat_index < _cat_size)) {
#line 811 "gnome-nibbles.vala"
				break;
#line 4671 "gnome-nibbles.c"
			}
#line 811 "gnome-nibbles.vala"
			_tmp11_ = _cat_list;
#line 811 "gnome-nibbles.vala"
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _cat_index);
#line 811 "gnome-nibbles.vala"
			cat = (GamesScoresCategory*) _tmp12_;
#line 813 "gnome-nibbles.vala"
			_tmp13_ = key;
#line 813 "gnome-nibbles.vala"
			_tmp14_ = cat;
#line 813 "gnome-nibbles.vala"
			_tmp15_ = games_scores_category_get_key (_tmp14_);
#line 813 "gnome-nibbles.vala"
			_tmp16_ = _tmp15_;
#line 813 "gnome-nibbles.vala"
			if (g_strcmp0 (_tmp13_, _tmp16_) == 0) {
#line 814 "gnome-nibbles.vala"
				result = cat;
#line 814 "gnome-nibbles.vala"
				_g_object_unref0 (_cat_list);
#line 814 "gnome-nibbles.vala"
				_g_free0 (key);
#line 814 "gnome-nibbles.vala"
				return result;
#line 4697 "gnome-nibbles.c"
			}
#line 811 "gnome-nibbles.vala"
			_g_object_unref0 (cat);
#line 4701 "gnome-nibbles.c"
		}
#line 811 "gnome-nibbles.vala"
		_g_object_unref0 (_cat_list);
#line 4705 "gnome-nibbles.c"
	}
#line 817 "gnome-nibbles.vala"
	_tmp17_ = self->priv->scorecats;
#line 817 "gnome-nibbles.vala"
	_tmp18_ = gee_linked_list_first (_tmp17_);
#line 817 "gnome-nibbles.vala"
	result = (GamesScoresCategory*) _tmp18_;
#line 817 "gnome-nibbles.vala"
	_g_free0 (key);
#line 817 "gnome-nibbles.vala"
	return result;
#line 4717 "gnome-nibbles.c"
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 820 "gnome-nibbles.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 820 "gnome-nibbles.vala"
	return _data2_;
#line 4727 "gnome-nibbles.c"
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 820 "gnome-nibbles.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 4737 "gnome-nibbles.c"
		Nibbles* self;
#line 820 "gnome-nibbles.vala"
		self = _data2_->self;
#line 820 "gnome-nibbles.vala"
		_g_object_unref0 (self);
#line 820 "gnome-nibbles.vala"
		g_slice_free (Block2Data, _data2_);
#line 4745 "gnome-nibbles.c"
	}
}

static void
__lambda10_ (Block2Data* _data2_,
             GObject* object,
             GAsyncResult* _result_)
{
	Nibbles* self;
	GError* _inner_error0_ = NULL;
#line 844 "gnome-nibbles.vala"
	self = _data2_->self;
#line 844 "gnome-nibbles.vala"
	g_return_if_fail (_result_ != NULL);
#line 4760 "gnome-nibbles.c"
	{
		GamesScoresContext* _tmp0_;
#line 847 "gnome-nibbles.vala"
		_tmp0_ = self->priv->scores_context;
#line 847 "gnome-nibbles.vala"
		games_scores_context_add_score_finish (_tmp0_, _result_, &_inner_error0_);
#line 847 "gnome-nibbles.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4769 "gnome-nibbles.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
#line 845 "gnome-nibbles.vala"
		e = _inner_error0_;
#line 845 "gnome-nibbles.vala"
		_inner_error0_ = NULL;
#line 851 "gnome-nibbles.vala"
		_tmp1_ = e;
#line 851 "gnome-nibbles.vala"
		_tmp2_ = _tmp1_->message;
#line 851 "gnome-nibbles.vala"
		g_warning ("gnome-nibbles.vala:851: Failed to add score: %s", _tmp2_);
#line 845 "gnome-nibbles.vala"
		_g_error_free0 (e);
#line 4791 "gnome-nibbles.c"
	}
	__finally0:
#line 845 "gnome-nibbles.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 845 "gnome-nibbles.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 845 "gnome-nibbles.vala"
		g_clear_error (&_inner_error0_);
#line 845 "gnome-nibbles.vala"
		return;
#line 4802 "gnome-nibbles.c"
	}
#line 854 "gnome-nibbles.vala"
	nibbles_game_over (self, _data2_->score, _data2_->lowest_high_score, _data2_->level_reached);
#line 4806 "gnome-nibbles.c"
}

static void
___lambda10__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
#line 841 "gnome-nibbles.vala"
	__lambda10_ (self, source_object, res);
#line 841 "gnome-nibbles.vala"
	block2_data_unref (self);
#line 4818 "gnome-nibbles.c"
}

static void
nibbles_log_score_cb (Nibbles* self,
                      gint score,
                      gint level_reached)
{
	Block2Data* _data2_;
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GeeList* scores = NULL;
	GamesScoresContext* _tmp2_;
	NibblesGame* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NibblesGame* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GamesScoresCategory* _tmp9_;
	GamesScoresCategory* _tmp10_;
	GeeList* _tmp11_;
	GeeList* _tmp12_;
	glong _tmp13_ = 0L;
	GeeList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	NibblesGame* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	NibblesGame* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	GamesScoresContext* _tmp28_;
	NibblesGame* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	NibblesGame* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	GamesScoresCategory* _tmp35_;
	GamesScoresCategory* _tmp36_;
#line 820 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 820 "gnome-nibbles.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 820 "gnome-nibbles.vala"
	_data2_->_ref_count_ = 1;
#line 820 "gnome-nibbles.vala"
	_data2_->self = g_object_ref (self);
#line 820 "gnome-nibbles.vala"
	_data2_->score = score;
#line 820 "gnome-nibbles.vala"
	_data2_->level_reached = level_reached;
#line 823 "gnome-nibbles.vala"
	_tmp0_ = self->priv->new_game_action;
#line 823 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp0_, FALSE);
#line 824 "gnome-nibbles.vala"
	_tmp1_ = self->priv->pause_action;
#line 824 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp1_, FALSE);
#line 826 "gnome-nibbles.vala"
	_tmp2_ = self->priv->scores_context;
#line 826 "gnome-nibbles.vala"
	_tmp3_ = self->priv->game;
#line 826 "gnome-nibbles.vala"
	_tmp4_ = nibbles_game_get_speed (_tmp3_);
#line 826 "gnome-nibbles.vala"
	_tmp5_ = _tmp4_;
#line 826 "gnome-nibbles.vala"
	_tmp6_ = self->priv->game;
#line 826 "gnome-nibbles.vala"
	_tmp7_ = nibbles_game_get_fakes (_tmp6_);
#line 826 "gnome-nibbles.vala"
	_tmp8_ = _tmp7_;
#line 826 "gnome-nibbles.vala"
	_tmp9_ = nibbles_get_scores_category (self, _tmp5_, _tmp8_);
#line 826 "gnome-nibbles.vala"
	_tmp10_ = _tmp9_;
#line 826 "gnome-nibbles.vala"
	_tmp11_ = games_scores_context_get_high_scores (_tmp2_, _tmp10_, 10);
#line 826 "gnome-nibbles.vala"
	_tmp12_ = _tmp11_;
#line 826 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp10_);
#line 826 "gnome-nibbles.vala"
	scores = _tmp12_;
#line 827 "gnome-nibbles.vala"
	_tmp14_ = scores;
#line 827 "gnome-nibbles.vala"
	_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
#line 827 "gnome-nibbles.vala"
	_tmp16_ = _tmp15_;
#line 827 "gnome-nibbles.vala"
	if (_tmp16_ == 10) {
#line 4914 "gnome-nibbles.c"
		GeeList* _tmp17_;
		gpointer _tmp18_;
		GamesScoresScore* _tmp19_;
		glong _tmp20_;
		glong _tmp21_;
#line 827 "gnome-nibbles.vala"
		_tmp17_ = scores;
#line 827 "gnome-nibbles.vala"
		_tmp18_ = gee_list_last (_tmp17_);
#line 827 "gnome-nibbles.vala"
		_tmp19_ = (GamesScoresScore*) _tmp18_;
#line 827 "gnome-nibbles.vala"
		_tmp20_ = games_scores_score_get_score (_tmp19_);
#line 827 "gnome-nibbles.vala"
		_tmp21_ = _tmp20_;
#line 827 "gnome-nibbles.vala"
		_tmp13_ = _tmp21_;
#line 827 "gnome-nibbles.vala"
		_g_object_unref0 (_tmp19_);
#line 4934 "gnome-nibbles.c"
	} else {
#line 827 "gnome-nibbles.vala"
		_tmp13_ = (glong) -1;
#line 4938 "gnome-nibbles.c"
	}
#line 827 "gnome-nibbles.vala"
	_data2_->lowest_high_score = _tmp13_;
#line 829 "gnome-nibbles.vala"
	_tmp22_ = self->priv->game;
#line 829 "gnome-nibbles.vala"
	_tmp23_ = nibbles_game_get_numhumans (_tmp22_);
#line 829 "gnome-nibbles.vala"
	_tmp24_ = _tmp23_;
#line 829 "gnome-nibbles.vala"
	if (_tmp24_ != 1) {
#line 831 "gnome-nibbles.vala"
		nibbles_game_over (self, _data2_->score, _data2_->lowest_high_score, _data2_->level_reached);
#line 832 "gnome-nibbles.vala"
		_g_object_unref0 (scores);
#line 832 "gnome-nibbles.vala"
		block2_data_unref (_data2_);
#line 832 "gnome-nibbles.vala"
		_data2_ = NULL;
#line 832 "gnome-nibbles.vala"
		return;
#line 4960 "gnome-nibbles.c"
	}
#line 835 "gnome-nibbles.vala"
	_tmp25_ = self->priv->game;
#line 835 "gnome-nibbles.vala"
	_tmp26_ = nibbles_game_get_start_level (_tmp25_);
#line 835 "gnome-nibbles.vala"
	_tmp27_ = _tmp26_;
#line 835 "gnome-nibbles.vala"
	if (_tmp27_ != 1) {
#line 837 "gnome-nibbles.vala"
		nibbles_game_over (self, _data2_->score, _data2_->lowest_high_score, _data2_->level_reached);
#line 838 "gnome-nibbles.vala"
		_g_object_unref0 (scores);
#line 838 "gnome-nibbles.vala"
		block2_data_unref (_data2_);
#line 838 "gnome-nibbles.vala"
		_data2_ = NULL;
#line 838 "gnome-nibbles.vala"
		return;
#line 4980 "gnome-nibbles.c"
	}
#line 841 "gnome-nibbles.vala"
	_tmp28_ = self->priv->scores_context;
#line 841 "gnome-nibbles.vala"
	_tmp29_ = self->priv->game;
#line 841 "gnome-nibbles.vala"
	_tmp30_ = nibbles_game_get_speed (_tmp29_);
#line 841 "gnome-nibbles.vala"
	_tmp31_ = _tmp30_;
#line 841 "gnome-nibbles.vala"
	_tmp32_ = self->priv->game;
#line 841 "gnome-nibbles.vala"
	_tmp33_ = nibbles_game_get_fakes (_tmp32_);
#line 841 "gnome-nibbles.vala"
	_tmp34_ = _tmp33_;
#line 841 "gnome-nibbles.vala"
	_tmp35_ = nibbles_get_scores_category (self, _tmp31_, _tmp34_);
#line 841 "gnome-nibbles.vala"
	_tmp36_ = _tmp35_;
#line 841 "gnome-nibbles.vala"
	games_scores_context_add_score (_tmp28_, (glong) _data2_->score, _tmp36_, NULL, ___lambda10__gasync_ready_callback, block2_data_ref (_data2_));
#line 841 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp36_);
#line 820 "gnome-nibbles.vala"
	_g_object_unref0 (scores);
#line 820 "gnome-nibbles.vala"
	block2_data_unref (_data2_);
#line 820 "gnome-nibbles.vala"
	_data2_ = NULL;
#line 5010 "gnome-nibbles.c"
}

static void
nibbles_scores_cb (Nibbles* self)
{
	gboolean should_unpause = FALSE;
	NibblesGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GamesScoresContext* _tmp4_;
#line 858 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 860 "gnome-nibbles.vala"
	should_unpause = FALSE;
#line 861 "gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 861 "gnome-nibbles.vala"
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
#line 861 "gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 861 "gnome-nibbles.vala"
	if (_tmp2_) {
#line 5033 "gnome-nibbles.c"
		GSimpleAction* _tmp3_;
#line 863 "gnome-nibbles.vala"
		_tmp3_ = self->priv->pause_action;
#line 863 "gnome-nibbles.vala"
		g_signal_emit_by_name (_tmp3_, "activate", NULL);
#line 864 "gnome-nibbles.vala"
		should_unpause = TRUE;
#line 5041 "gnome-nibbles.c"
	}
#line 867 "gnome-nibbles.vala"
	_tmp4_ = self->priv->scores_context;
#line 867 "gnome-nibbles.vala"
	games_scores_context_run_dialog (_tmp4_);
#line 870 "gnome-nibbles.vala"
	if (should_unpause) {
#line 5049 "gnome-nibbles.c"
		GSimpleAction* _tmp5_;
#line 871 "gnome-nibbles.vala"
		_tmp5_ = self->priv->pause_action;
#line 871 "gnome-nibbles.vala"
		g_signal_emit_by_name (_tmp5_, "activate", NULL);
#line 5055 "gnome-nibbles.c"
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 874 "gnome-nibbles.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 874 "gnome-nibbles.vala"
	return _data3_;
#line 5066 "gnome-nibbles.c"
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 874 "gnome-nibbles.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 5076 "gnome-nibbles.c"
		Nibbles* self;
#line 874 "gnome-nibbles.vala"
		self = _data3_->self;
#line 874 "gnome-nibbles.vala"
		_g_object_unref0 (_data3_->button);
#line 874 "gnome-nibbles.vala"
		_g_object_unref0 (_data3_->label);
#line 874 "gnome-nibbles.vala"
		_g_object_unref0 (self);
#line 874 "gnome-nibbles.vala"
		g_slice_free (Block3Data, _data3_);
#line 5088 "gnome-nibbles.c"
	}
}

static void
__lambda11_ (Block3Data* _data3_)
{
	Nibbles* self;
	GtkLabel* _tmp0_;
	GtkButton* _tmp1_;
	GtkHeaderBar* _tmp2_;
	NibblesGame* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	NibblesView* _tmp8_;
#line 899 "gnome-nibbles.vala"
	self = _data3_->self;
#line 900 "gnome-nibbles.vala"
	_tmp0_ = _data3_->label;
#line 900 "gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 901 "gnome-nibbles.vala"
	_tmp1_ = _data3_->button;
#line 901 "gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
#line 903 "gnome-nibbles.vala"
	_tmp2_ = self->priv->headerbar;
#line 903 "gnome-nibbles.vala"
	_tmp3_ = self->priv->game;
#line 903 "gnome-nibbles.vala"
	_tmp4_ = nibbles_game_get_current_level (_tmp3_);
#line 903 "gnome-nibbles.vala"
	_tmp5_ = _tmp4_;
#line 903 "gnome-nibbles.vala"
	_tmp6_ = g_strdup_printf (_ ("Level %d"), _tmp5_);
#line 903 "gnome-nibbles.vala"
	_tmp7_ = _tmp6_;
#line 903 "gnome-nibbles.vala"
	gtk_header_bar_set_title (_tmp2_, _tmp7_);
#line 903 "gnome-nibbles.vala"
	_g_free0 (_tmp7_);
#line 905 "gnome-nibbles.vala"
	_tmp8_ = self->priv->view;
#line 905 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp8_);
#line 907 "gnome-nibbles.vala"
	nibbles_restart_game (self);
#line 5137 "gnome-nibbles.c"
}

static void
___lambda11__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 899 "gnome-nibbles.vala"
	__lambda11_ (self);
#line 5146 "gnome-nibbles.c"
}

static gboolean
__lambda12_ (Block3Data* _data3_)
{
	Nibbles* self;
	gboolean result = FALSE;
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
#line 916 "gnome-nibbles.vala"
	self = _data3_->self;
#line 917 "gnome-nibbles.vala"
	_tmp0_ = _data3_->button;
#line 917 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 918 "gnome-nibbles.vala"
	_tmp1_ = _data3_->button;
#line 918 "gnome-nibbles.vala"
	gtk_widget_grab_default ((GtkWidget*) _tmp1_);
#line 920 "gnome-nibbles.vala"
	result = G_SOURCE_REMOVE;
#line 920 "gnome-nibbles.vala"
	return result;
#line 5170 "gnome-nibbles.c"
}

static gboolean
___lambda12__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda12_ (self);
#line 916 "gnome-nibbles.vala"
	return result;
#line 5180 "gnome-nibbles.c"
}

static void
nibbles_level_completed_cb (Nibbles* self)
{
	Block3Data* _data3_;
	NibblesGame* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NibblesView* _tmp3_;
	GSimpleAction* _tmp4_;
	GSimpleAction* _tmp5_;
	NibblesGame* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkStyleContext* _tmp17_;
	GtkLabel* _tmp18_;
	GtkButton* _tmp19_;
	GtkButton* _tmp20_;
	GtkButton* _tmp21_;
	GtkButton* _tmp22_;
	GtkButton* _tmp23_;
	GtkButton* _tmp24_;
	GtkStyleContext* _tmp25_;
	GtkButton* _tmp26_;
	GtkButton* _tmp27_;
	GtkOverlay* _tmp28_;
	GtkLabel* _tmp29_;
	GtkOverlay* _tmp30_;
	GtkButton* _tmp31_;
	GtkOverlay* _tmp32_;
	GtkOverlay* _tmp33_;
#line 874 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 874 "gnome-nibbles.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 874 "gnome-nibbles.vala"
	_data3_->_ref_count_ = 1;
#line 874 "gnome-nibbles.vala"
	_data3_->self = g_object_ref (self);
#line 876 "gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 876 "gnome-nibbles.vala"
	_tmp1_ = nibbles_game_get_current_level (_tmp0_);
#line 876 "gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 876 "gnome-nibbles.vala"
	if (_tmp2_ == NIBBLES_GAME_MAX_LEVEL) {
#line 877 "gnome-nibbles.vala"
		block3_data_unref (_data3_);
#line 877 "gnome-nibbles.vala"
		_data3_ = NULL;
#line 877 "gnome-nibbles.vala"
		return;
#line 5243 "gnome-nibbles.c"
	}
#line 879 "gnome-nibbles.vala"
	_tmp3_ = self->priv->view;
#line 879 "gnome-nibbles.vala"
	gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 881 "gnome-nibbles.vala"
	_tmp4_ = self->priv->new_game_action;
#line 881 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp4_, FALSE);
#line 882 "gnome-nibbles.vala"
	_tmp5_ = self->priv->pause_action;
#line 882 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp5_, FALSE);
#line 885 "gnome-nibbles.vala"
	_tmp6_ = self->priv->game;
#line 885 "gnome-nibbles.vala"
	_tmp7_ = nibbles_game_get_current_level (_tmp6_);
#line 885 "gnome-nibbles.vala"
	_tmp8_ = _tmp7_;
#line 885 "gnome-nibbles.vala"
	_tmp9_ = g_strdup_printf (_ ("Level %d Completed!"), _tmp8_);
#line 885 "gnome-nibbles.vala"
	_tmp10_ = _tmp9_;
#line 885 "gnome-nibbles.vala"
	_tmp11_ = (GtkLabel*) gtk_label_new (_tmp10_);
#line 885 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp11_);
#line 885 "gnome-nibbles.vala"
	_tmp12_ = _tmp11_;
#line 885 "gnome-nibbles.vala"
	_g_free0 (_tmp10_);
#line 885 "gnome-nibbles.vala"
	_data3_->label = _tmp12_;
#line 886 "gnome-nibbles.vala"
	_tmp13_ = _data3_->label;
#line 886 "gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_CENTER);
#line 887 "gnome-nibbles.vala"
	_tmp14_ = _data3_->label;
#line 887 "gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp14_, GTK_ALIGN_START);
#line 888 "gnome-nibbles.vala"
	_tmp15_ = _data3_->label;
#line 888 "gnome-nibbles.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp15_, 150);
#line 889 "gnome-nibbles.vala"
	_tmp16_ = _data3_->label;
#line 889 "gnome-nibbles.vala"
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) _tmp16_);
#line 889 "gnome-nibbles.vala"
	gtk_style_context_add_class (_tmp17_, "menu-title");
#line 890 "gnome-nibbles.vala"
	_tmp18_ = _data3_->label;
#line 890 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp18_);
#line 892 "gnome-nibbles.vala"
	_tmp19_ = (GtkButton*) gtk_button_new_with_label (_ ("_Next Level"));
#line 892 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp19_);
#line 892 "gnome-nibbles.vala"
	_data3_->button = _tmp19_;
#line 893 "gnome-nibbles.vala"
	_tmp20_ = _data3_->button;
#line 893 "gnome-nibbles.vala"
	gtk_button_set_use_underline (_tmp20_, TRUE);
#line 894 "gnome-nibbles.vala"
	_tmp21_ = _data3_->button;
#line 894 "gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp21_, GTK_ALIGN_CENTER);
#line 895 "gnome-nibbles.vala"
	_tmp22_ = _data3_->button;
#line 895 "gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp22_, GTK_ALIGN_END);
#line 896 "gnome-nibbles.vala"
	_tmp23_ = _data3_->button;
#line 896 "gnome-nibbles.vala"
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp23_, 100);
#line 897 "gnome-nibbles.vala"
	_tmp24_ = _data3_->button;
#line 897 "gnome-nibbles.vala"
	_tmp25_ = gtk_widget_get_style_context ((GtkWidget*) _tmp24_);
#line 897 "gnome-nibbles.vala"
	gtk_style_context_add_class (_tmp25_, "suggested-action");
#line 898 "gnome-nibbles.vala"
	_tmp26_ = _data3_->button;
#line 898 "gnome-nibbles.vala"
	gtk_widget_set_can_default ((GtkWidget*) _tmp26_, TRUE);
#line 899 "gnome-nibbles.vala"
	_tmp27_ = _data3_->button;
#line 899 "gnome-nibbles.vala"
	g_signal_connect_data (_tmp27_, "clicked", (GCallback) ___lambda11__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 910 "gnome-nibbles.vala"
	_tmp28_ = self->priv->overlay;
#line 910 "gnome-nibbles.vala"
	_tmp29_ = _data3_->label;
#line 910 "gnome-nibbles.vala"
	gtk_overlay_add_overlay (_tmp28_, (GtkWidget*) _tmp29_);
#line 911 "gnome-nibbles.vala"
	_tmp30_ = self->priv->overlay;
#line 911 "gnome-nibbles.vala"
	_tmp31_ = _data3_->button;
#line 911 "gnome-nibbles.vala"
	gtk_overlay_add_overlay (_tmp30_, (GtkWidget*) _tmp31_);
#line 913 "gnome-nibbles.vala"
	_tmp32_ = self->priv->overlay;
#line 913 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp32_);
#line 914 "gnome-nibbles.vala"
	_tmp33_ = self->priv->overlay;
#line 914 "gnome-nibbles.vala"
	gtk_widget_grab_default ((GtkWidget*) _tmp33_);
#line 916 "gnome-nibbles.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda12__gsource_func, block3_data_ref (_data3_), block3_data_unref);
#line 874 "gnome-nibbles.vala"
	block3_data_unref (_data3_);
#line 874 "gnome-nibbles.vala"
	_data3_ = NULL;
#line 5361 "gnome-nibbles.c"
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
#line 924 "gnome-nibbles.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 924 "gnome-nibbles.vala"
	return _data4_;
#line 5371 "gnome-nibbles.c"
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 924 "gnome-nibbles.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 5381 "gnome-nibbles.c"
		Nibbles* self;
#line 924 "gnome-nibbles.vala"
		self = _data4_->self;
#line 924 "gnome-nibbles.vala"
		_g_object_unref0 (self);
#line 924 "gnome-nibbles.vala"
		g_slice_free (Block4Data, _data4_);
#line 5389 "gnome-nibbles.c"
	}
}

static void
__lambda8_ (Block4Data* _data4_)
{
	Nibbles* self;
#line 945 "gnome-nibbles.vala"
	self = _data4_->self;
#line 946 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 946 "gnome-nibbles.vala"
	self->priv->preferences_dialog = NULL;
#line 948 "gnome-nibbles.vala"
	if (_data4_->should_unpause) {
#line 5405 "gnome-nibbles.c"
		GSimpleAction* _tmp0_;
#line 949 "gnome-nibbles.vala"
		_tmp0_ = self->priv->pause_action;
#line 949 "gnome-nibbles.vala"
		g_signal_emit_by_name (_tmp0_, "activate", NULL);
#line 5411 "gnome-nibbles.c"
	}
}

static void
___lambda8__gtk_widget_destroy (GtkWidget* _sender,
                                gpointer self)
{
#line 945 "gnome-nibbles.vala"
	__lambda8_ (self);
#line 5421 "gnome-nibbles.c"
}

static void
nibbles_preferences_cb (Nibbles* self)
{
	Block4Data* _data4_;
	NibblesGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	PreferencesDialog* _tmp4_;
	GtkApplicationWindow* _tmp7_;
	GSettings* _tmp8_;
	GeeArrayList* _tmp9_;
	PreferencesDialog* _tmp10_;
	PreferencesDialog* _tmp11_;
	PreferencesDialog* _tmp12_;
#line 924 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 924 "gnome-nibbles.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 924 "gnome-nibbles.vala"
	_data4_->_ref_count_ = 1;
#line 924 "gnome-nibbles.vala"
	_data4_->self = g_object_ref (self);
#line 926 "gnome-nibbles.vala"
	_data4_->should_unpause = FALSE;
#line 927 "gnome-nibbles.vala"
	_tmp0_ = self->priv->game;
#line 927 "gnome-nibbles.vala"
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
#line 927 "gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 927 "gnome-nibbles.vala"
	if (_tmp2_) {
#line 5456 "gnome-nibbles.c"
		GSimpleAction* _tmp3_;
#line 929 "gnome-nibbles.vala"
		_tmp3_ = self->priv->pause_action;
#line 929 "gnome-nibbles.vala"
		g_signal_emit_by_name (_tmp3_, "activate", NULL);
#line 930 "gnome-nibbles.vala"
		_data4_->should_unpause = TRUE;
#line 5464 "gnome-nibbles.c"
	}
#line 933 "gnome-nibbles.vala"
	_tmp4_ = self->priv->preferences_dialog;
#line 933 "gnome-nibbles.vala"
	if (_tmp4_ != NULL) {
#line 5470 "gnome-nibbles.c"
		PreferencesDialog* _tmp5_;
#line 935 "gnome-nibbles.vala"
		_tmp5_ = self->priv->preferences_dialog;
#line 935 "gnome-nibbles.vala"
		gtk_window_present ((GtkWindow*) _tmp5_);
#line 937 "gnome-nibbles.vala"
		if (_data4_->should_unpause) {
#line 5478 "gnome-nibbles.c"
			GSimpleAction* _tmp6_;
#line 938 "gnome-nibbles.vala"
			_tmp6_ = self->priv->pause_action;
#line 938 "gnome-nibbles.vala"
			g_signal_emit_by_name (_tmp6_, "activate", NULL);
#line 5484 "gnome-nibbles.c"
		}
#line 940 "gnome-nibbles.vala"
		block4_data_unref (_data4_);
#line 940 "gnome-nibbles.vala"
		_data4_ = NULL;
#line 940 "gnome-nibbles.vala"
		return;
#line 5492 "gnome-nibbles.c"
	}
#line 943 "gnome-nibbles.vala"
	_tmp7_ = self->priv->window;
#line 943 "gnome-nibbles.vala"
	_tmp8_ = self->priv->settings;
#line 943 "gnome-nibbles.vala"
	_tmp9_ = self->priv->worm_settings;
#line 943 "gnome-nibbles.vala"
	_tmp10_ = preferences_dialog_new (_tmp7_, _tmp8_, _tmp9_);
#line 943 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp10_);
#line 943 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 943 "gnome-nibbles.vala"
	self->priv->preferences_dialog = _tmp10_;
#line 945 "gnome-nibbles.vala"
	_tmp11_ = self->priv->preferences_dialog;
#line 945 "gnome-nibbles.vala"
	g_signal_connect_data ((GtkWidget*) _tmp11_, "destroy", (GCallback) ___lambda8__gtk_widget_destroy, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
#line 952 "gnome-nibbles.vala"
	_tmp12_ = self->priv->preferences_dialog;
#line 952 "gnome-nibbles.vala"
	gtk_dialog_run ((GtkDialog*) _tmp12_);
#line 924 "gnome-nibbles.vala"
	block4_data_unref (_data4_);
#line 924 "gnome-nibbles.vala"
	_data4_ = NULL;
#line 5520 "gnome-nibbles.c"
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
#line 955 "gnome-nibbles.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 955 "gnome-nibbles.vala"
	return _data5_;
#line 5530 "gnome-nibbles.c"
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 955 "gnome-nibbles.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 5540 "gnome-nibbles.c"
		Nibbles* self;
#line 955 "gnome-nibbles.vala"
		self = _data5_->self;
#line 955 "gnome-nibbles.vala"
		_g_object_unref0 (_data5_->button);
#line 955 "gnome-nibbles.vala"
		_g_object_unref0 (_data5_->points_left_label);
#line 955 "gnome-nibbles.vala"
		_g_object_unref0 (_data5_->score_label);
#line 955 "gnome-nibbles.vala"
		_g_object_unref0 (_data5_->msg_label);
#line 955 "gnome-nibbles.vala"
		_g_object_unref0 (_data5_->game_over_label);
#line 955 "gnome-nibbles.vala"
		_g_object_unref0 (self);
#line 955 "gnome-nibbles.vala"
		g_slice_free (Block5Data, _data5_);
#line 5558 "gnome-nibbles.c"
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1516 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1517 "glib-2.0.vapi"
	result = self;
#line 1517 "glib-2.0.vapi"
	return result;
#line 5572 "gnome-nibbles.c"
}

static void
__lambda9_ (Block5Data* _data5_)
{
	Nibbles* self;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkButton* _tmp3_;
	GtkLabel* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleAction* _tmp6_;
#line 996 "gnome-nibbles.vala"
	self = _data5_->self;
#line 997 "gnome-nibbles.vala"
	_tmp0_ = _data5_->game_over_label;
#line 997 "gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 998 "gnome-nibbles.vala"
	_tmp1_ = _data5_->score_label;
#line 998 "gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
#line 999 "gnome-nibbles.vala"
	_tmp2_ = _data5_->points_left_label;
#line 999 "gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp2_);
#line 1000 "gnome-nibbles.vala"
	_tmp3_ = _data5_->button;
#line 1000 "gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp3_);
#line 1001 "gnome-nibbles.vala"
	_tmp4_ = _data5_->msg_label;
#line 1001 "gnome-nibbles.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
#line 1003 "gnome-nibbles.vala"
	_tmp5_ = self->priv->new_game_action;
#line 1003 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp5_, TRUE);
#line 1004 "gnome-nibbles.vala"
	_tmp6_ = self->priv->pause_action;
#line 1004 "gnome-nibbles.vala"
	g_simple_action_set_enabled (_tmp6_, TRUE);
#line 1006 "gnome-nibbles.vala"
	nibbles_show_new_game_screen_cb (self);
#line 5618 "gnome-nibbles.c"
}

static void
___lambda9__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
#line 996 "gnome-nibbles.vala"
	__lambda9_ (self);
#line 5627 "gnome-nibbles.c"
}

static void
nibbles_game_over (Nibbles* self,
                   gint score,
                   glong lowest_high_score,
                   gint level_reached)
{
	Block5Data* _data5_;
	gboolean is_high_score = FALSE;
	gboolean is_game_won = FALSE;
	const gchar* _tmp0_ = NULL;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkLabel* _tmp14_;
	gchar* score_string = NULL;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkLabel* _tmp24_;
	GtkLabel* _tmp25_;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	GtkLabel* _tmp28_;
	glong points_left = 0L;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GtkLabel* _tmp31_;
	GtkLabel* _tmp32_;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_;
	GtkLabel* _tmp35_;
	GtkLabel* _tmp36_;
	GtkButton* _tmp37_;
	GtkButton* _tmp38_;
	GtkButton* _tmp39_;
	GtkButton* _tmp40_;
	GtkButton* _tmp41_;
	GtkButton* _tmp42_;
	GtkStyleContext* _tmp43_;
	GtkButton* _tmp44_;
	GtkButton* _tmp45_;
	GtkOverlay* _tmp46_;
	GtkLabel* _tmp47_;
	NibblesGame* _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	gboolean _tmp55_ = FALSE;
	NibblesGame* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	GtkOverlay* _tmp61_;
	GtkButton* _tmp62_;
	GtkButton* _tmp63_;
	GtkOverlay* _tmp64_;
#line 955 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 955 "gnome-nibbles.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 955 "gnome-nibbles.vala"
	_data5_->_ref_count_ = 1;
#line 955 "gnome-nibbles.vala"
	_data5_->self = g_object_ref (self);
#line 957 "gnome-nibbles.vala"
	is_high_score = ((glong) score) > lowest_high_score;
#line 958 "gnome-nibbles.vala"
	is_game_won = level_reached == (NIBBLES_GAME_MAX_LEVEL + 1);
#line 960 "gnome-nibbles.vala"
	if (is_game_won) {
#line 960 "gnome-nibbles.vala"
		_tmp0_ = _ ("Congratulations!");
#line 5716 "gnome-nibbles.c"
	} else {
#line 960 "gnome-nibbles.vala"
		_tmp0_ = _ ("Game Over!");
#line 5720 "gnome-nibbles.c"
	}
#line 960 "gnome-nibbles.vala"
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
#line 960 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp1_);
#line 960 "gnome-nibbles.vala"
	_data5_->game_over_label = _tmp1_;
#line 961 "gnome-nibbles.vala"
	_tmp2_ = _data5_->game_over_label;
#line 961 "gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_CENTER);
#line 962 "gnome-nibbles.vala"
	_tmp3_ = _data5_->game_over_label;
#line 962 "gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_START);
#line 963 "gnome-nibbles.vala"
	_tmp4_ = _data5_->game_over_label;
#line 963 "gnome-nibbles.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp4_, 150);
#line 964 "gnome-nibbles.vala"
	_tmp5_ = _data5_->game_over_label;
#line 964 "gnome-nibbles.vala"
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
#line 964 "gnome-nibbles.vala"
	gtk_style_context_add_class (_tmp6_, "menu-title");
#line 965 "gnome-nibbles.vala"
	_tmp7_ = _data5_->game_over_label;
#line 965 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp7_);
#line 967 "gnome-nibbles.vala"
	_tmp8_ = (GtkLabel*) gtk_label_new (_ ("You have completed the game."));
#line 967 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp8_);
#line 967 "gnome-nibbles.vala"
	_data5_->msg_label = _tmp8_;
#line 968 "gnome-nibbles.vala"
	_tmp9_ = _data5_->msg_label;
#line 968 "gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp9_, GTK_ALIGN_CENTER);
#line 969 "gnome-nibbles.vala"
	_tmp10_ = _data5_->msg_label;
#line 969 "gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp10_, GTK_ALIGN_START);
#line 970 "gnome-nibbles.vala"
	_tmp11_ = _data5_->msg_label;
#line 970 "gnome-nibbles.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp11_, self->priv->window_height / 3);
#line 971 "gnome-nibbles.vala"
	_tmp12_ = _data5_->msg_label;
#line 971 "gnome-nibbles.vala"
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
#line 971 "gnome-nibbles.vala"
	gtk_style_context_add_class (_tmp13_, "menu-title");
#line 972 "gnome-nibbles.vala"
	_tmp14_ = _data5_->msg_label;
#line 972 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp14_);
#line 974 "gnome-nibbles.vala"
	_tmp15_ = g_strdup (ngettext ("%d Point", "%d Points", (gulong) score));
#line 974 "gnome-nibbles.vala"
	score_string = _tmp15_;
#line 975 "gnome-nibbles.vala"
	_tmp16_ = score_string;
#line 975 "gnome-nibbles.vala"
	_tmp17_ = g_strdup_printf (_tmp16_, score);
#line 975 "gnome-nibbles.vala"
	_g_free0 (score_string);
#line 975 "gnome-nibbles.vala"
	score_string = _tmp17_;
#line 976 "gnome-nibbles.vala"
	_tmp18_ = score_string;
#line 976 "gnome-nibbles.vala"
	_tmp19_ = string_to_string (_tmp18_);
#line 976 "gnome-nibbles.vala"
	_tmp20_ = g_strconcat ("<b>", _tmp19_, "</b>", NULL);
#line 976 "gnome-nibbles.vala"
	_tmp21_ = _tmp20_;
#line 976 "gnome-nibbles.vala"
	_tmp22_ = (GtkLabel*) gtk_label_new (_tmp21_);
#line 976 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp22_);
#line 976 "gnome-nibbles.vala"
	_tmp23_ = _tmp22_;
#line 976 "gnome-nibbles.vala"
	_g_free0 (_tmp21_);
#line 976 "gnome-nibbles.vala"
	_data5_->score_label = _tmp23_;
#line 977 "gnome-nibbles.vala"
	_tmp24_ = _data5_->score_label;
#line 977 "gnome-nibbles.vala"
	gtk_label_set_use_markup (_tmp24_, TRUE);
#line 978 "gnome-nibbles.vala"
	_tmp25_ = _data5_->score_label;
#line 978 "gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp25_, GTK_ALIGN_CENTER);
#line 979 "gnome-nibbles.vala"
	_tmp26_ = _data5_->score_label;
#line 979 "gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp26_, GTK_ALIGN_START);
#line 980 "gnome-nibbles.vala"
	_tmp27_ = _data5_->score_label;
#line 980 "gnome-nibbles.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp27_, (self->priv->window_height / 3) + 80);
#line 981 "gnome-nibbles.vala"
	_tmp28_ = _data5_->score_label;
#line 981 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp28_);
#line 983 "gnome-nibbles.vala"
	points_left = lowest_high_score - score;
#line 984 "gnome-nibbles.vala"
	_tmp29_ = g_strdup_printf (_ ("(%ld more points to reach the leaderboard)"), points_left);
#line 984 "gnome-nibbles.vala"
	_tmp30_ = _tmp29_;
#line 984 "gnome-nibbles.vala"
	_tmp31_ = (GtkLabel*) gtk_label_new (_tmp30_);
#line 984 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp31_);
#line 984 "gnome-nibbles.vala"
	_tmp32_ = _tmp31_;
#line 984 "gnome-nibbles.vala"
	_g_free0 (_tmp30_);
#line 984 "gnome-nibbles.vala"
	_data5_->points_left_label = _tmp32_;
#line 985 "gnome-nibbles.vala"
	_tmp33_ = _data5_->points_left_label;
#line 985 "gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp33_, GTK_ALIGN_CENTER);
#line 986 "gnome-nibbles.vala"
	_tmp34_ = _data5_->points_left_label;
#line 986 "gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp34_, GTK_ALIGN_START);
#line 987 "gnome-nibbles.vala"
	_tmp35_ = _data5_->points_left_label;
#line 987 "gnome-nibbles.vala"
	gtk_widget_set_margin_top ((GtkWidget*) _tmp35_, (self->priv->window_height / 3) + 100);
#line 988 "gnome-nibbles.vala"
	_tmp36_ = _data5_->points_left_label;
#line 988 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp36_);
#line 990 "gnome-nibbles.vala"
	_tmp37_ = (GtkButton*) gtk_button_new_with_label (_ ("_Play Again"));
#line 990 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp37_);
#line 990 "gnome-nibbles.vala"
	_data5_->button = _tmp37_;
#line 991 "gnome-nibbles.vala"
	_tmp38_ = _data5_->button;
#line 991 "gnome-nibbles.vala"
	gtk_button_set_use_underline (_tmp38_, TRUE);
#line 992 "gnome-nibbles.vala"
	_tmp39_ = _data5_->button;
#line 992 "gnome-nibbles.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp39_, GTK_ALIGN_CENTER);
#line 993 "gnome-nibbles.vala"
	_tmp40_ = _data5_->button;
#line 993 "gnome-nibbles.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp40_, GTK_ALIGN_END);
#line 994 "gnome-nibbles.vala"
	_tmp41_ = _data5_->button;
#line 994 "gnome-nibbles.vala"
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp41_, 100);
#line 995 "gnome-nibbles.vala"
	_tmp42_ = _data5_->button;
#line 995 "gnome-nibbles.vala"
	_tmp43_ = gtk_widget_get_style_context ((GtkWidget*) _tmp42_);
#line 995 "gnome-nibbles.vala"
	gtk_style_context_add_class (_tmp43_, "suggested-action");
#line 996 "gnome-nibbles.vala"
	_tmp44_ = _data5_->button;
#line 996 "gnome-nibbles.vala"
	g_signal_connect_data (_tmp44_, "clicked", (GCallback) ___lambda9__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
#line 1008 "gnome-nibbles.vala"
	_tmp45_ = _data5_->button;
#line 1008 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp45_);
#line 1010 "gnome-nibbles.vala"
	_tmp46_ = self->priv->overlay;
#line 1010 "gnome-nibbles.vala"
	_tmp47_ = _data5_->game_over_label;
#line 1010 "gnome-nibbles.vala"
	gtk_overlay_add_overlay (_tmp46_, (GtkWidget*) _tmp47_);
#line 1011 "gnome-nibbles.vala"
	if (is_game_won) {
#line 5904 "gnome-nibbles.c"
		GtkOverlay* _tmp48_;
		GtkLabel* _tmp49_;
#line 1012 "gnome-nibbles.vala"
		_tmp48_ = self->priv->overlay;
#line 1012 "gnome-nibbles.vala"
		_tmp49_ = _data5_->msg_label;
#line 1012 "gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp48_, (GtkWidget*) _tmp49_);
#line 5913 "gnome-nibbles.c"
	}
#line 1013 "gnome-nibbles.vala"
	_tmp50_ = self->priv->game;
#line 1013 "gnome-nibbles.vala"
	_tmp51_ = nibbles_game_get_numhumans (_tmp50_);
#line 1013 "gnome-nibbles.vala"
	_tmp52_ = _tmp51_;
#line 1013 "gnome-nibbles.vala"
	if (_tmp52_ == 1) {
#line 5923 "gnome-nibbles.c"
		GtkOverlay* _tmp53_;
		GtkLabel* _tmp54_;
#line 1014 "gnome-nibbles.vala"
		_tmp53_ = self->priv->overlay;
#line 1014 "gnome-nibbles.vala"
		_tmp54_ = _data5_->score_label;
#line 1014 "gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp53_, (GtkWidget*) _tmp54_);
#line 5932 "gnome-nibbles.c"
	}
#line 1015 "gnome-nibbles.vala"
	_tmp56_ = self->priv->game;
#line 1015 "gnome-nibbles.vala"
	_tmp57_ = nibbles_game_get_numhumans (_tmp56_);
#line 1015 "gnome-nibbles.vala"
	_tmp58_ = _tmp57_;
#line 1015 "gnome-nibbles.vala"
	if (_tmp58_ == 1) {
#line 1015 "gnome-nibbles.vala"
		_tmp55_ = !is_high_score;
#line 5944 "gnome-nibbles.c"
	} else {
#line 1015 "gnome-nibbles.vala"
		_tmp55_ = FALSE;
#line 5948 "gnome-nibbles.c"
	}
#line 1015 "gnome-nibbles.vala"
	if (_tmp55_) {
#line 5952 "gnome-nibbles.c"
		GtkOverlay* _tmp59_;
		GtkLabel* _tmp60_;
#line 1016 "gnome-nibbles.vala"
		_tmp59_ = self->priv->overlay;
#line 1016 "gnome-nibbles.vala"
		_tmp60_ = _data5_->points_left_label;
#line 1016 "gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp59_, (GtkWidget*) _tmp60_);
#line 5961 "gnome-nibbles.c"
	}
#line 1017 "gnome-nibbles.vala"
	_tmp61_ = self->priv->overlay;
#line 1017 "gnome-nibbles.vala"
	_tmp62_ = _data5_->button;
#line 1017 "gnome-nibbles.vala"
	gtk_overlay_add_overlay (_tmp61_, (GtkWidget*) _tmp62_);
#line 1019 "gnome-nibbles.vala"
	_tmp63_ = _data5_->button;
#line 1019 "gnome-nibbles.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp63_);
#line 1021 "gnome-nibbles.vala"
	_tmp64_ = self->priv->overlay;
#line 1021 "gnome-nibbles.vala"
	gtk_widget_show ((GtkWidget*) _tmp64_);
#line 955 "gnome-nibbles.vala"
	_g_free0 (score_string);
#line 955 "gnome-nibbles.vala"
	block5_data_unref (_data5_);
#line 955 "gnome-nibbles.vala"
	_data5_ = NULL;
#line 5983 "gnome-nibbles.c"
}

static void
nibbles_help_cb (Nibbles* self)
{
	GError* _inner_error0_ = NULL;
#line 1024 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 5992 "gnome-nibbles.c"
	{
		GtkApplicationWindow* _tmp0_;
		GdkScreen* _tmp1_;
#line 1028 "gnome-nibbles.vala"
		_tmp0_ = self->priv->window;
#line 1028 "gnome-nibbles.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 1028 "gnome-nibbles.vala"
		gtk_show_uri (_tmp1_, "help:gnome-nibbles", gtk_get_current_event_time (), &_inner_error0_);
#line 1028 "gnome-nibbles.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 6004 "gnome-nibbles.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 1026 "gnome-nibbles.vala"
		e = _inner_error0_;
#line 1026 "gnome-nibbles.vala"
		_inner_error0_ = NULL;
#line 1032 "gnome-nibbles.vala"
		_tmp2_ = e;
#line 1032 "gnome-nibbles.vala"
		_tmp3_ = _tmp2_->message;
#line 1032 "gnome-nibbles.vala"
		g_warning ("gnome-nibbles.vala:1032: Unable to open help: %s", _tmp3_);
#line 1026 "gnome-nibbles.vala"
		_g_error_free0 (e);
#line 6026 "gnome-nibbles.c"
	}
	__finally1:
#line 1026 "gnome-nibbles.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1026 "gnome-nibbles.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1026 "gnome-nibbles.vala"
		g_clear_error (&_inner_error0_);
#line 1026 "gnome-nibbles.vala"
		return;
#line 6037 "gnome-nibbles.c"
	}
}

static void
nibbles_about_cb (Nibbles* self)
{
#line 1038 "gnome-nibbles.vala"
	static const gchar* authors[6] = {"Sean MacIsaac", "Ian Peters", "Andreas Røsdal", "Guillaume Beland", "Iulian-Gabriel Radu", NULL};
#line 1045 "gnome-nibbles.vala"
	static const gchar* documenters[2] = {"Kevin Breit", NULL};
#line 1048 "gnome-nibbles.vala"
	static const gchar* artists[2] = {"Allan Day", NULL};
#line 6050 "gnome-nibbles.c"
	GtkApplicationWindow* _tmp0_;
#line 1036 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 1051 "gnome-nibbles.vala"
	_tmp0_ = self->priv->window;
#line 1051 "gnome-nibbles.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp0_, "program-name", _ ("Nibbles"), "logo-icon-name", "gnome-nibbles", "version", VERSION, "comments", _ ("A worm game for GNOME"), "copyright", "Copyright © 1999–2008 Sean MacIsaac, Ian Peters, Andreas Røsdal\n" "Copyright © 2009 Guillaume Beland\n" "Copyright © 2015 Iulian-Gabriel Radu", "license-type", GTK_LICENSE_GPL_3_0, "authors", authors, "documenters", documenters, "artists", artists, "translator-credits", _ ("translator-credits"), "website", "https://wiki.gnome.org/Apps/Nibbles/", NULL);
#line 6058 "gnome-nibbles.c"
}

gint
nibbles_main (gchar** args,
              gint args_length1)
{
	gint result = 0;
	Nibbles* _tmp0_;
	Nibbles* _tmp1_;
	gint _tmp2_;
#line 1071 "gnome-nibbles.vala"
	setlocale (LC_ALL, "");
#line 1072 "gnome-nibbles.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 1073 "gnome-nibbles.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 1074 "gnome-nibbles.vala"
	textdomain (GETTEXT_PACKAGE);
#line 1076 "gnome-nibbles.vala"
	_tmp0_ = nibbles_new ();
#line 1076 "gnome-nibbles.vala"
	_tmp1_ = _tmp0_;
#line 1076 "gnome-nibbles.vala"
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, (gint) args_length1, args);
#line 1076 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp1_);
#line 1076 "gnome-nibbles.vala"
	result = _tmp2_;
#line 1076 "gnome-nibbles.vala"
	return result;
#line 6089 "gnome-nibbles.c"
}

int
main (int argc,
      char ** argv)
{
#line 1069 "gnome-nibbles.vala"
	return nibbles_main (argv, argc);
#line 6098 "gnome-nibbles.c"
}

static void
nibbles_class_init (NibblesClass * klass,
                    gpointer klass_data)
{
#line 19 "gnome-nibbles.vala"
	nibbles_parent_class = g_type_class_peek_parent (klass);
#line 19 "gnome-nibbles.vala"
	g_type_class_adjust_private_offset (klass, &Nibbles_private_offset);
#line 19 "gnome-nibbles.vala"
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) nibbles_real_handle_local_options;
#line 19 "gnome-nibbles.vala"
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) nibbles_real_startup;
#line 19 "gnome-nibbles.vala"
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) nibbles_real_activate;
#line 19 "gnome-nibbles.vala"
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) nibbles_real_shutdown;
#line 19 "gnome-nibbles.vala"
	G_OBJECT_CLASS (klass)->finalize = nibbles_finalize;
#line 6119 "gnome-nibbles.c"
}

static void
nibbles_instance_init (Nibbles * self,
                       gpointer klass)
{
#line 19 "gnome-nibbles.vala"
	self->priv = nibbles_get_instance_private (self);
#line 57 "gnome-nibbles.vala"
	self->priv->preferences_dialog = NULL;
#line 66 "gnome-nibbles.vala"
	self->priv->game = NULL;
#line 77 "gnome-nibbles.vala"
	self->priv->countdown_id = (guint) 0;
#line 79 "gnome-nibbles.vala"
	self->priv->seconds = 0;
#line 6136 "gnome-nibbles.c"
}

static void
nibbles_finalize (GObject * obj)
{
	Nibbles * self;
#line 19 "gnome-nibbles.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES, Nibbles);
#line 22 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->settings);
#line 23 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->worm_settings);
#line 26 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->window);
#line 32 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 33 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->overlay);
#line 36 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 37 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->new_game_button);
#line 38 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->pause_button);
#line 41 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->number_of_players_buttons);
#line 42 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->number_of_ai_buttons);
#line 43 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->next_button);
#line 44 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->start_button);
#line 46 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->grids_box);
#line 47 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_pixbuf);
#line 48 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_key_pixbuf);
#line 51 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->statusbar_stack);
#line 52 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->countdown);
#line 53 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scoreboard);
#line 54 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scoreboard_life);
#line 57 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 60 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->view);
#line 62 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->game_box);
#line 63 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->frame);
#line 66 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->game);
#line 69 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scores_context);
#line 70 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->scorecats);
#line 73 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->new_game_action);
#line 74 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->pause_action);
#line 75 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->back_action);
#line 19 "gnome-nibbles.vala"
	G_OBJECT_CLASS (nibbles_parent_class)->finalize (obj);
#line 6205 "gnome-nibbles.c"
}

GType
nibbles_get_type (void)
{
	static volatile gsize nibbles_type_id__volatile = 0;
	if (g_once_init_enter (&nibbles_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NibblesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Nibbles), 0, (GInstanceInitFunc) nibbles_instance_init, NULL };
		GType nibbles_type_id;
		nibbles_type_id = g_type_register_static (gtk_application_get_type (), "Nibbles", &g_define_type_info, 0);
		Nibbles_private_offset = g_type_add_instance_private (nibbles_type_id, sizeof (NibblesPrivate));
		g_once_init_leave (&nibbles_type_id__volatile, nibbles_type_id);
	}
	return nibbles_type_id__volatile;
}

static inline gpointer
scoreboard_get_instance_private (Scoreboard* self)
{
	return G_STRUCT_MEMBER_P (self, Scoreboard_private_offset);
}

Scoreboard*
scoreboard_construct (GType object_type)
{
	Scoreboard * self = NULL;
	GeeHashMap* _tmp0_;
#line 1085 "gnome-nibbles.vala"
	self = (Scoreboard*) g_object_new (object_type, NULL);
#line 1087 "gnome-nibbles.vala"
	_tmp0_ = gee_hash_map_new (TYPE_PLAYER_SCORE_BOX, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 1087 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->boxes);
#line 1087 "gnome-nibbles.vala"
	self->priv->boxes = _tmp0_;
#line 1085 "gnome-nibbles.vala"
	return self;
#line 6243 "gnome-nibbles.c"
}

Scoreboard*
scoreboard_new (void)
{
#line 1085 "gnome-nibbles.vala"
	return scoreboard_construct (TYPE_SCOREBOARD);
#line 6251 "gnome-nibbles.c"
}

void
scoreboard_register (Scoreboard* self,
                     Worm* worm,
                     const gchar* color_name,
                     GdkPixbuf* life_pixbuf)
{
	PangoColor color = {0};
	PlayerScoreBox* box = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	PangoColor _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	PlayerScoreBox* _tmp9_;
	PlayerScoreBox* _tmp10_;
	GeeHashMap* _tmp11_;
#line 1090 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 1090 "gnome-nibbles.vala"
	g_return_if_fail (worm != NULL);
#line 1090 "gnome-nibbles.vala"
	g_return_if_fail (color_name != NULL);
#line 1090 "gnome-nibbles.vala"
	g_return_if_fail (life_pixbuf != NULL);
#line 1092 "gnome-nibbles.vala"
	memset (&color, 0, sizeof (PangoColor));
#line 1093 "gnome-nibbles.vala"
	pango_color_parse (&color, color_name);
#line 1098 "gnome-nibbles.vala"
	_tmp0_ = worm_get_id (worm);
#line 1098 "gnome-nibbles.vala"
	_tmp1_ = _tmp0_;
#line 1098 "gnome-nibbles.vala"
	_tmp2_ = g_strdup_printf (_ ("Player %d"), _tmp1_ + 1);
#line 1098 "gnome-nibbles.vala"
	_tmp3_ = _tmp2_;
#line 1098 "gnome-nibbles.vala"
	_tmp4_ = color;
#line 1098 "gnome-nibbles.vala"
	_tmp5_ = worm_get_score (worm);
#line 1098 "gnome-nibbles.vala"
	_tmp6_ = _tmp5_;
#line 1098 "gnome-nibbles.vala"
	_tmp7_ = worm_get_lives (worm);
#line 1098 "gnome-nibbles.vala"
	_tmp8_ = _tmp7_;
#line 1098 "gnome-nibbles.vala"
	_tmp9_ = player_score_box_new (_tmp3_, &_tmp4_, _tmp6_, _tmp8_, life_pixbuf);
#line 1098 "gnome-nibbles.vala"
	g_object_ref_sink (_tmp9_);
#line 1098 "gnome-nibbles.vala"
	_tmp10_ = _tmp9_;
#line 1098 "gnome-nibbles.vala"
	_g_free0 (_tmp3_);
#line 1098 "gnome-nibbles.vala"
	box = _tmp10_;
#line 1099 "gnome-nibbles.vala"
	_tmp11_ = self->priv->boxes;
#line 1099 "gnome-nibbles.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, box, worm);
#line 1100 "gnome-nibbles.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) box);
#line 1090 "gnome-nibbles.vala"
	_g_object_unref0 (box);
#line 6322 "gnome-nibbles.c"
}

void
scoreboard_update (Scoreboard* self)
{
#line 1103 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 6330 "gnome-nibbles.c"
	{
		GeeIterator* _entry_it = NULL;
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
#line 1105 "gnome-nibbles.vala"
		_tmp0_ = self->priv->boxes;
#line 1105 "gnome-nibbles.vala"
		_tmp1_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp0_);
#line 1105 "gnome-nibbles.vala"
		_tmp2_ = _tmp1_;
#line 1105 "gnome-nibbles.vala"
		_tmp3_ = _tmp2_;
#line 1105 "gnome-nibbles.vala"
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
#line 1105 "gnome-nibbles.vala"
		_tmp5_ = _tmp4_;
#line 1105 "gnome-nibbles.vala"
		_g_object_unref0 (_tmp3_);
#line 1105 "gnome-nibbles.vala"
		_entry_it = _tmp5_;
#line 1105 "gnome-nibbles.vala"
		while (TRUE) {
#line 6357 "gnome-nibbles.c"
			GeeIterator* _tmp6_;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			PlayerScoreBox* box = NULL;
			GeeMapEntry* _tmp9_;
			gconstpointer _tmp10_;
			PlayerScoreBox* _tmp11_;
			PlayerScoreBox* _tmp12_;
			Worm* worm = NULL;
			GeeMapEntry* _tmp13_;
			gconstpointer _tmp14_;
			Worm* _tmp15_;
			Worm* _tmp16_;
			PlayerScoreBox* _tmp17_;
			Worm* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			Worm* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
#line 1105 "gnome-nibbles.vala"
			_tmp6_ = _entry_it;
#line 1105 "gnome-nibbles.vala"
			if (!gee_iterator_next (_tmp6_)) {
#line 1105 "gnome-nibbles.vala"
				break;
#line 6385 "gnome-nibbles.c"
			}
#line 1105 "gnome-nibbles.vala"
			_tmp7_ = _entry_it;
#line 1105 "gnome-nibbles.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 1105 "gnome-nibbles.vala"
			entry = (GeeMapEntry*) _tmp8_;
#line 1107 "gnome-nibbles.vala"
			_tmp9_ = entry;
#line 1107 "gnome-nibbles.vala"
			_tmp10_ = gee_map_entry_get_key (_tmp9_);
#line 1107 "gnome-nibbles.vala"
			_tmp11_ = _tmp10_;
#line 1107 "gnome-nibbles.vala"
			_tmp12_ = _g_object_ref0 ((PlayerScoreBox*) _tmp11_);
#line 1107 "gnome-nibbles.vala"
			box = _tmp12_;
#line 1108 "gnome-nibbles.vala"
			_tmp13_ = entry;
#line 1108 "gnome-nibbles.vala"
			_tmp14_ = gee_map_entry_get_value (_tmp13_);
#line 1108 "gnome-nibbles.vala"
			_tmp15_ = _tmp14_;
#line 1108 "gnome-nibbles.vala"
			_tmp16_ = _g_object_ref0 ((Worm*) _tmp15_);
#line 1108 "gnome-nibbles.vala"
			worm = _tmp16_;
#line 1110 "gnome-nibbles.vala"
			_tmp17_ = box;
#line 1110 "gnome-nibbles.vala"
			_tmp18_ = worm;
#line 1110 "gnome-nibbles.vala"
			_tmp19_ = worm_get_score (_tmp18_);
#line 1110 "gnome-nibbles.vala"
			_tmp20_ = _tmp19_;
#line 1110 "gnome-nibbles.vala"
			_tmp21_ = worm;
#line 1110 "gnome-nibbles.vala"
			_tmp22_ = worm_get_lives (_tmp21_);
#line 1110 "gnome-nibbles.vala"
			_tmp23_ = _tmp22_;
#line 1110 "gnome-nibbles.vala"
			player_score_box_update (_tmp17_, _tmp20_, _tmp23_);
#line 1105 "gnome-nibbles.vala"
			_g_object_unref0 (worm);
#line 1105 "gnome-nibbles.vala"
			_g_object_unref0 (box);
#line 1105 "gnome-nibbles.vala"
			_g_object_unref0 (entry);
#line 6435 "gnome-nibbles.c"
		}
#line 1105 "gnome-nibbles.vala"
		_g_object_unref0 (_entry_it);
#line 6439 "gnome-nibbles.c"
	}
}

void
scoreboard_clear (Scoreboard* self)
{
	GeeHashMap* _tmp14_;
#line 1114 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 6449 "gnome-nibbles.c"
	{
		GeeIterator* _entry_it = NULL;
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
#line 1116 "gnome-nibbles.vala"
		_tmp0_ = self->priv->boxes;
#line 1116 "gnome-nibbles.vala"
		_tmp1_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp0_);
#line 1116 "gnome-nibbles.vala"
		_tmp2_ = _tmp1_;
#line 1116 "gnome-nibbles.vala"
		_tmp3_ = _tmp2_;
#line 1116 "gnome-nibbles.vala"
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
#line 1116 "gnome-nibbles.vala"
		_tmp5_ = _tmp4_;
#line 1116 "gnome-nibbles.vala"
		_g_object_unref0 (_tmp3_);
#line 1116 "gnome-nibbles.vala"
		_entry_it = _tmp5_;
#line 1116 "gnome-nibbles.vala"
		while (TRUE) {
#line 6476 "gnome-nibbles.c"
			GeeIterator* _tmp6_;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			PlayerScoreBox* box = NULL;
			GeeMapEntry* _tmp9_;
			gconstpointer _tmp10_;
			PlayerScoreBox* _tmp11_;
			PlayerScoreBox* _tmp12_;
			PlayerScoreBox* _tmp13_;
#line 1116 "gnome-nibbles.vala"
			_tmp6_ = _entry_it;
#line 1116 "gnome-nibbles.vala"
			if (!gee_iterator_next (_tmp6_)) {
#line 1116 "gnome-nibbles.vala"
				break;
#line 6493 "gnome-nibbles.c"
			}
#line 1116 "gnome-nibbles.vala"
			_tmp7_ = _entry_it;
#line 1116 "gnome-nibbles.vala"
			_tmp8_ = gee_iterator_get (_tmp7_);
#line 1116 "gnome-nibbles.vala"
			entry = (GeeMapEntry*) _tmp8_;
#line 1118 "gnome-nibbles.vala"
			_tmp9_ = entry;
#line 1118 "gnome-nibbles.vala"
			_tmp10_ = gee_map_entry_get_key (_tmp9_);
#line 1118 "gnome-nibbles.vala"
			_tmp11_ = _tmp10_;
#line 1118 "gnome-nibbles.vala"
			_tmp12_ = _g_object_ref0 ((PlayerScoreBox*) _tmp11_);
#line 1118 "gnome-nibbles.vala"
			box = _tmp12_;
#line 1119 "gnome-nibbles.vala"
			_tmp13_ = box;
#line 1119 "gnome-nibbles.vala"
			gtk_widget_destroy ((GtkWidget*) _tmp13_);
#line 1116 "gnome-nibbles.vala"
			_g_object_unref0 (box);
#line 1116 "gnome-nibbles.vala"
			_g_object_unref0 (entry);
#line 6519 "gnome-nibbles.c"
		}
#line 1116 "gnome-nibbles.vala"
		_g_object_unref0 (_entry_it);
#line 6523 "gnome-nibbles.c"
	}
#line 1121 "gnome-nibbles.vala"
	_tmp14_ = self->priv->boxes;
#line 1121 "gnome-nibbles.vala"
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp14_);
#line 6529 "gnome-nibbles.c"
}

static void
scoreboard_class_init (ScoreboardClass * klass,
                       gpointer klass_data)
{
#line 1081 "gnome-nibbles.vala"
	scoreboard_parent_class = g_type_class_peek_parent (klass);
#line 1081 "gnome-nibbles.vala"
	g_type_class_adjust_private_offset (klass, &Scoreboard_private_offset);
#line 1081 "gnome-nibbles.vala"
	G_OBJECT_CLASS (klass)->finalize = scoreboard_finalize;
#line 1081 "gnome-nibbles.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/scoreboard.ui");
#line 6544 "gnome-nibbles.c"
}

static void
scoreboard_instance_init (Scoreboard * self,
                          gpointer klass)
{
#line 1081 "gnome-nibbles.vala"
	self->priv = scoreboard_get_instance_private (self);
#line 1081 "gnome-nibbles.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 6555 "gnome-nibbles.c"
}

static void
scoreboard_finalize (GObject * obj)
{
	Scoreboard * self;
#line 1081 "gnome-nibbles.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCOREBOARD, Scoreboard);
#line 1083 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->boxes);
#line 1081 "gnome-nibbles.vala"
	G_OBJECT_CLASS (scoreboard_parent_class)->finalize (obj);
#line 6568 "gnome-nibbles.c"
}

GType
scoreboard_get_type (void)
{
	static volatile gsize scoreboard_type_id__volatile = 0;
	if (g_once_init_enter (&scoreboard_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ScoreboardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scoreboard_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Scoreboard), 0, (GInstanceInitFunc) scoreboard_instance_init, NULL };
		GType scoreboard_type_id;
		scoreboard_type_id = g_type_register_static (gtk_box_get_type (), "Scoreboard", &g_define_type_info, 0);
		Scoreboard_private_offset = g_type_add_instance_private (scoreboard_type_id, sizeof (ScoreboardPrivate));
		g_once_init_leave (&scoreboard_type_id__volatile, scoreboard_type_id);
	}
	return scoreboard_type_id__volatile;
}

static inline gpointer
player_score_box_get_instance_private (PlayerScoreBox* self)
{
	return G_STRUCT_MEMBER_P (self, PlayerScoreBox_private_offset);
}

PlayerScoreBox*
player_score_box_construct (GType object_type,
                            const gchar* name,
                            PangoColor* color,
                            gint score,
                            gint lives_left,
                            GdkPixbuf* life_pixbuf)
{
	PlayerScoreBox * self = NULL;
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkLabel* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GeeLinkedList* _tmp14_;
#line 1137 "gnome-nibbles.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 1137 "gnome-nibbles.vala"
	g_return_val_if_fail (color != NULL, NULL);
#line 1137 "gnome-nibbles.vala"
	g_return_val_if_fail (life_pixbuf != NULL, NULL);
#line 1137 "gnome-nibbles.vala"
	self = (PlayerScoreBox*) g_object_new (object_type, NULL);
#line 1139 "gnome-nibbles.vala"
	_tmp0_ = self->priv->name_label;
#line 1139 "gnome-nibbles.vala"
	_tmp1_ = pango_color_to_string (color);
#line 1139 "gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 1139 "gnome-nibbles.vala"
	_tmp3_ = g_strconcat ("<span color=\"", _tmp2_, NULL);
#line 1139 "gnome-nibbles.vala"
	_tmp4_ = _tmp3_;
#line 1139 "gnome-nibbles.vala"
	_tmp5_ = g_strconcat (_tmp4_, "\">", NULL);
#line 1139 "gnome-nibbles.vala"
	_tmp6_ = _tmp5_;
#line 1139 "gnome-nibbles.vala"
	_tmp7_ = g_strconcat (_tmp6_, name, NULL);
#line 1139 "gnome-nibbles.vala"
	_tmp8_ = _tmp7_;
#line 1139 "gnome-nibbles.vala"
	_tmp9_ = g_strconcat (_tmp8_, "</span>", NULL);
#line 1139 "gnome-nibbles.vala"
	_tmp10_ = _tmp9_;
#line 1139 "gnome-nibbles.vala"
	gtk_label_set_markup (_tmp0_, _tmp10_);
#line 1139 "gnome-nibbles.vala"
	_g_free0 (_tmp10_);
#line 1139 "gnome-nibbles.vala"
	_g_free0 (_tmp8_);
#line 1139 "gnome-nibbles.vala"
	_g_free0 (_tmp6_);
#line 1139 "gnome-nibbles.vala"
	_g_free0 (_tmp4_);
#line 1139 "gnome-nibbles.vala"
	_g_free0 (_tmp2_);
#line 1140 "gnome-nibbles.vala"
	_tmp11_ = self->priv->score_label;
#line 1140 "gnome-nibbles.vala"
	_tmp12_ = g_strdup_printf ("%i", score);
#line 1140 "gnome-nibbles.vala"
	_tmp13_ = _tmp12_;
#line 1140 "gnome-nibbles.vala"
	gtk_label_set_label (_tmp11_, _tmp13_);
#line 1140 "gnome-nibbles.vala"
	_g_free0 (_tmp13_);
#line 1142 "gnome-nibbles.vala"
	_tmp14_ = gee_linked_list_new (gtk_image_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 1142 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->life_images);
#line 1142 "gnome-nibbles.vala"
	self->priv->life_images = _tmp14_;
#line 6673 "gnome-nibbles.c"
	{
		gint i = 0;
#line 1144 "gnome-nibbles.vala"
		i = 0;
#line 6678 "gnome-nibbles.c"
		{
			gboolean _tmp15_ = FALSE;
#line 1144 "gnome-nibbles.vala"
			_tmp15_ = TRUE;
#line 1144 "gnome-nibbles.vala"
			while (TRUE) {
#line 6685 "gnome-nibbles.c"
				GtkImage* life = NULL;
				GtkImage* _tmp17_;
				GtkImage* _tmp18_;
				GeeLinkedList* _tmp20_;
				GtkImage* _tmp21_;
				GtkGrid* _tmp22_;
				GtkImage* _tmp23_;
#line 1144 "gnome-nibbles.vala"
				if (!_tmp15_) {
#line 6695 "gnome-nibbles.c"
					gint _tmp16_;
#line 1144 "gnome-nibbles.vala"
					_tmp16_ = i;
#line 1144 "gnome-nibbles.vala"
					i = _tmp16_ + 1;
#line 6701 "gnome-nibbles.c"
				}
#line 1144 "gnome-nibbles.vala"
				_tmp15_ = FALSE;
#line 1144 "gnome-nibbles.vala"
				if (!(i < WORM_MAX_LIVES)) {
#line 1144 "gnome-nibbles.vala"
					break;
#line 6709 "gnome-nibbles.c"
				}
#line 1146 "gnome-nibbles.vala"
				_tmp17_ = (GtkImage*) gtk_image_new_from_pixbuf (life_pixbuf);
#line 1146 "gnome-nibbles.vala"
				g_object_ref_sink (_tmp17_);
#line 1146 "gnome-nibbles.vala"
				life = _tmp17_;
#line 1147 "gnome-nibbles.vala"
				_tmp18_ = life;
#line 1147 "gnome-nibbles.vala"
				gtk_widget_show ((GtkWidget*) _tmp18_);
#line 1149 "gnome-nibbles.vala"
				if (i >= WORM_STARTING_LIVES) {
#line 6723 "gnome-nibbles.c"
					GtkImage* _tmp19_;
#line 1150 "gnome-nibbles.vala"
					_tmp19_ = life;
#line 1150 "gnome-nibbles.vala"
					gtk_widget_set_opacity ((GtkWidget*) _tmp19_, (gdouble) 0);
#line 6729 "gnome-nibbles.c"
				}
#line 1152 "gnome-nibbles.vala"
				_tmp20_ = self->priv->life_images;
#line 1152 "gnome-nibbles.vala"
				_tmp21_ = life;
#line 1152 "gnome-nibbles.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp21_);
#line 1153 "gnome-nibbles.vala"
				_tmp22_ = self->priv->lives_grid;
#line 1153 "gnome-nibbles.vala"
				_tmp23_ = life;
#line 1153 "gnome-nibbles.vala"
				gtk_grid_attach (_tmp22_, (GtkWidget*) _tmp23_, i % 6, i / 6, 1, 1);
#line 1144 "gnome-nibbles.vala"
				_g_object_unref0 (life);
#line 6745 "gnome-nibbles.c"
			}
		}
	}
#line 1137 "gnome-nibbles.vala"
	return self;
#line 6751 "gnome-nibbles.c"
}

PlayerScoreBox*
player_score_box_new (const gchar* name,
                      PangoColor* color,
                      gint score,
                      gint lives_left,
                      GdkPixbuf* life_pixbuf)
{
#line 1137 "gnome-nibbles.vala"
	return player_score_box_construct (TYPE_PLAYER_SCORE_BOX, name, color, score, lives_left, life_pixbuf);
#line 6763 "gnome-nibbles.c"
}

void
player_score_box_update (PlayerScoreBox* self,
                         gint score,
                         gint lives_left)
{
#line 1157 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 1159 "gnome-nibbles.vala"
	player_score_box_update_score (self, score);
#line 1160 "gnome-nibbles.vala"
	player_score_box_update_lives (self, lives_left);
#line 6777 "gnome-nibbles.c"
}

void
player_score_box_update_score (PlayerScoreBox* self,
                               gint score)
{
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 1163 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 1165 "gnome-nibbles.vala"
	_tmp0_ = self->priv->score_label;
#line 1165 "gnome-nibbles.vala"
	_tmp1_ = g_strdup_printf ("%i", score);
#line 1165 "gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 1165 "gnome-nibbles.vala"
	gtk_label_set_label (_tmp0_, _tmp2_);
#line 1165 "gnome-nibbles.vala"
	_g_free0 (_tmp2_);
#line 6799 "gnome-nibbles.c"
}

void
player_score_box_update_lives (PlayerScoreBox* self,
                               gint lives_left)
{
#line 1168 "gnome-nibbles.vala"
	g_return_if_fail (self != NULL);
#line 6808 "gnome-nibbles.c"
	{
		gint i = 0;
		GeeLinkedList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
#line 1171 "gnome-nibbles.vala"
		_tmp0_ = self->priv->life_images;
#line 1171 "gnome-nibbles.vala"
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
#line 1171 "gnome-nibbles.vala"
		_tmp2_ = _tmp1_;
#line 1171 "gnome-nibbles.vala"
		i = _tmp2_ - 1;
#line 6822 "gnome-nibbles.c"
		{
			gboolean _tmp3_ = FALSE;
#line 1171 "gnome-nibbles.vala"
			_tmp3_ = TRUE;
#line 1171 "gnome-nibbles.vala"
			while (TRUE) {
#line 6829 "gnome-nibbles.c"
				GeeLinkedList* _tmp5_;
				gpointer _tmp6_;
				GtkImage* _tmp7_;
#line 1171 "gnome-nibbles.vala"
				if (!_tmp3_) {
#line 6835 "gnome-nibbles.c"
					gint _tmp4_;
#line 1171 "gnome-nibbles.vala"
					_tmp4_ = i;
#line 1171 "gnome-nibbles.vala"
					i = _tmp4_ - 1;
#line 6841 "gnome-nibbles.c"
				}
#line 1171 "gnome-nibbles.vala"
				_tmp3_ = FALSE;
#line 1171 "gnome-nibbles.vala"
				if (!(i >= lives_left)) {
#line 1171 "gnome-nibbles.vala"
					break;
#line 6849 "gnome-nibbles.c"
				}
#line 1172 "gnome-nibbles.vala"
				_tmp5_ = self->priv->life_images;
#line 1172 "gnome-nibbles.vala"
				_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, i);
#line 1172 "gnome-nibbles.vala"
				_tmp7_ = (GtkImage*) _tmp6_;
#line 1172 "gnome-nibbles.vala"
				gtk_widget_set_opacity ((GtkWidget*) _tmp7_, (gdouble) 0);
#line 1172 "gnome-nibbles.vala"
				_g_object_unref0 (_tmp7_);
#line 6861 "gnome-nibbles.c"
			}
		}
	}
	{
		gint i = 0;
#line 1175 "gnome-nibbles.vala"
		i = 0;
#line 6869 "gnome-nibbles.c"
		{
			gboolean _tmp8_ = FALSE;
#line 1175 "gnome-nibbles.vala"
			_tmp8_ = TRUE;
#line 1175 "gnome-nibbles.vala"
			while (TRUE) {
#line 6876 "gnome-nibbles.c"
				GeeLinkedList* _tmp10_;
				gpointer _tmp11_;
				GtkImage* _tmp12_;
#line 1175 "gnome-nibbles.vala"
				if (!_tmp8_) {
#line 6882 "gnome-nibbles.c"
					gint _tmp9_;
#line 1175 "gnome-nibbles.vala"
					_tmp9_ = i;
#line 1175 "gnome-nibbles.vala"
					i = _tmp9_ + 1;
#line 6888 "gnome-nibbles.c"
				}
#line 1175 "gnome-nibbles.vala"
				_tmp8_ = FALSE;
#line 1175 "gnome-nibbles.vala"
				if (!(i < lives_left)) {
#line 1175 "gnome-nibbles.vala"
					break;
#line 6896 "gnome-nibbles.c"
				}
#line 1176 "gnome-nibbles.vala"
				_tmp10_ = self->priv->life_images;
#line 1176 "gnome-nibbles.vala"
				_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, i);
#line 1176 "gnome-nibbles.vala"
				_tmp12_ = (GtkImage*) _tmp11_;
#line 1176 "gnome-nibbles.vala"
				gtk_widget_set_opacity ((GtkWidget*) _tmp12_, (gdouble) 1);
#line 1176 "gnome-nibbles.vala"
				_g_object_unref0 (_tmp12_);
#line 6908 "gnome-nibbles.c"
			}
		}
	}
}

static void
player_score_box_class_init (PlayerScoreBoxClass * klass,
                             gpointer klass_data)
{
#line 1126 "gnome-nibbles.vala"
	player_score_box_parent_class = g_type_class_peek_parent (klass);
#line 1126 "gnome-nibbles.vala"
	g_type_class_adjust_private_offset (klass, &PlayerScoreBox_private_offset);
#line 1126 "gnome-nibbles.vala"
	G_OBJECT_CLASS (klass)->finalize = player_score_box_finalize;
#line 1126 "gnome-nibbles.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/player-score-box.ui");
#line 1126 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, name_label));
#line 1126 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "score_label", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, score_label));
#line 1126 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "lives_grid", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, lives_grid));
#line 6932 "gnome-nibbles.c"
}

static void
player_score_box_instance_init (PlayerScoreBox * self,
                                gpointer klass)
{
#line 1126 "gnome-nibbles.vala"
	self->priv = player_score_box_get_instance_private (self);
#line 1126 "gnome-nibbles.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 6943 "gnome-nibbles.c"
}

static void
player_score_box_finalize (GObject * obj)
{
	PlayerScoreBox * self;
#line 1126 "gnome-nibbles.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PLAYER_SCORE_BOX, PlayerScoreBox);
#line 1129 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->name_label);
#line 1131 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->score_label);
#line 1133 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->lives_grid);
#line 1135 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->life_images);
#line 1126 "gnome-nibbles.vala"
	G_OBJECT_CLASS (player_score_box_parent_class)->finalize (obj);
#line 6962 "gnome-nibbles.c"
}

GType
player_score_box_get_type (void)
{
	static volatile gsize player_score_box_type_id__volatile = 0;
	if (g_once_init_enter (&player_score_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PlayerScoreBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) player_score_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlayerScoreBox), 0, (GInstanceInitFunc) player_score_box_instance_init, NULL };
		GType player_score_box_type_id;
		player_score_box_type_id = g_type_register_static (gtk_box_get_type (), "PlayerScoreBox", &g_define_type_info, 0);
		PlayerScoreBox_private_offset = g_type_add_instance_private (player_score_box_type_id, sizeof (PlayerScoreBoxPrivate));
		g_once_init_leave (&player_score_box_type_id__volatile, player_score_box_type_id);
	}
	return player_score_box_type_id__volatile;
}

static inline gpointer
controls_grid_get_instance_private (ControlsGrid* self)
{
	return G_STRUCT_MEMBER_P (self, ControlsGrid_private_offset);
}

ControlsGrid*
controls_grid_construct (GType object_type,
                         gint worm_id,
                         WormProperties* worm_props,
                         GdkPixbuf* arrow,
                         GdkPixbuf* arrow_key)
{
	ControlsGrid * self = NULL;
	PangoColor color = {0};
	WormProperties _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* player_id = NULL;
	gchar* _tmp3_;
	GtkLabel* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GtkImage* _tmp12_;
	GdkPixbuf* _tmp13_;
	GdkPixbuf* _tmp14_;
	GtkImage* _tmp15_;
	GdkPixbuf* _tmp16_;
	GdkPixbuf* _tmp17_;
	GtkImage* _tmp18_;
	GdkPixbuf* _tmp19_;
	GdkPixbuf* _tmp20_;
	GtkImage* _tmp21_;
	GdkPixbuf* _tmp22_;
	GdkPixbuf* _tmp23_;
	gchar* upper_key = NULL;
	WormProperties _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	WormProperties _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	const gchar* _tmp42_;
	WormProperties _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	const gchar* _tmp57_;
	WormProperties _tmp69_;
	const gchar* _tmp70_;
	gchar* _tmp71_;
	const gchar* _tmp72_;
#line 1210 "gnome-nibbles.vala"
	g_return_val_if_fail (worm_props != NULL, NULL);
#line 1210 "gnome-nibbles.vala"
	g_return_val_if_fail (arrow != NULL, NULL);
#line 1210 "gnome-nibbles.vala"
	g_return_val_if_fail (arrow_key != NULL, NULL);
#line 1210 "gnome-nibbles.vala"
	self = (ControlsGrid*) g_object_new (object_type, NULL);
#line 1212 "gnome-nibbles.vala"
	memset (&color, 0, sizeof (PangoColor));
#line 1213 "gnome-nibbles.vala"
	_tmp0_ = *worm_props;
#line 1213 "gnome-nibbles.vala"
	_tmp1_ = nibbles_view_colorval_name (_tmp0_.color);
#line 1213 "gnome-nibbles.vala"
	_tmp2_ = _tmp1_;
#line 1213 "gnome-nibbles.vala"
	pango_color_parse (&color, _tmp2_);
#line 1213 "gnome-nibbles.vala"
	_g_free0 (_tmp2_);
#line 1216 "gnome-nibbles.vala"
	_tmp3_ = g_strdup_printf (_ ("Player %d"), worm_id + 1);
#line 1216 "gnome-nibbles.vala"
	player_id = _tmp3_;
#line 1217 "gnome-nibbles.vala"
	_tmp4_ = self->priv->name_label;
#line 1217 "gnome-nibbles.vala"
	_tmp5_ = pango_color_to_string (&color);
#line 1217 "gnome-nibbles.vala"
	_tmp6_ = _tmp5_;
#line 1217 "gnome-nibbles.vala"
	_tmp7_ = string_to_string (_tmp6_);
#line 1217 "gnome-nibbles.vala"
	_tmp8_ = player_id;
#line 1217 "gnome-nibbles.vala"
	_tmp9_ = string_to_string (_tmp8_);
#line 1217 "gnome-nibbles.vala"
	_tmp10_ = g_strconcat ("<b><span font-family=\"Sans\" color=\"", _tmp7_, "\">", _tmp9_, "</span></b>", NULL);
#line 1217 "gnome-nibbles.vala"
	_tmp11_ = _tmp10_;
#line 1217 "gnome-nibbles.vala"
	gtk_label_set_markup (_tmp4_, _tmp11_);
#line 1217 "gnome-nibbles.vala"
	_g_free0 (_tmp11_);
#line 1217 "gnome-nibbles.vala"
	_g_free0 (_tmp6_);
#line 1219 "gnome-nibbles.vala"
	_tmp12_ = self->priv->arrow_up;
#line 1219 "gnome-nibbles.vala"
	_tmp13_ = gdk_pixbuf_rotate_simple (arrow, GDK_PIXBUF_ROTATE_NONE);
#line 1219 "gnome-nibbles.vala"
	_tmp14_ = _tmp13_;
#line 1219 "gnome-nibbles.vala"
	gtk_image_set_from_pixbuf (_tmp12_, _tmp14_);
#line 1219 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp14_);
#line 1220 "gnome-nibbles.vala"
	_tmp15_ = self->priv->arrow_down;
#line 1220 "gnome-nibbles.vala"
	_tmp16_ = gdk_pixbuf_rotate_simple (arrow, GDK_PIXBUF_ROTATE_UPSIDEDOWN);
#line 1220 "gnome-nibbles.vala"
	_tmp17_ = _tmp16_;
#line 1220 "gnome-nibbles.vala"
	gtk_image_set_from_pixbuf (_tmp15_, _tmp17_);
#line 1220 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp17_);
#line 1221 "gnome-nibbles.vala"
	_tmp18_ = self->priv->arrow_left;
#line 1221 "gnome-nibbles.vala"
	_tmp19_ = gdk_pixbuf_rotate_simple (arrow, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
#line 1221 "gnome-nibbles.vala"
	_tmp20_ = _tmp19_;
#line 1221 "gnome-nibbles.vala"
	gtk_image_set_from_pixbuf (_tmp18_, _tmp20_);
#line 1221 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp20_);
#line 1222 "gnome-nibbles.vala"
	_tmp21_ = self->priv->arrow_right;
#line 1222 "gnome-nibbles.vala"
	_tmp22_ = gdk_pixbuf_rotate_simple (arrow, GDK_PIXBUF_ROTATE_CLOCKWISE);
#line 1222 "gnome-nibbles.vala"
	_tmp23_ = _tmp22_;
#line 1222 "gnome-nibbles.vala"
	gtk_image_set_from_pixbuf (_tmp21_, _tmp23_);
#line 1222 "gnome-nibbles.vala"
	_g_object_unref0 (_tmp23_);
#line 1225 "gnome-nibbles.vala"
	_tmp24_ = *worm_props;
#line 1225 "gnome-nibbles.vala"
	_tmp25_ = gdk_keyval_name (_tmp24_.up);
#line 1225 "gnome-nibbles.vala"
	_tmp26_ = g_utf8_strup (_tmp25_, (gssize) -1);
#line 1225 "gnome-nibbles.vala"
	_g_free0 (upper_key);
#line 1225 "gnome-nibbles.vala"
	upper_key = _tmp26_;
#line 1226 "gnome-nibbles.vala"
	_tmp27_ = upper_key;
#line 1226 "gnome-nibbles.vala"
	if (g_strcmp0 (_tmp27_, "UP") == 0) {
#line 7136 "gnome-nibbles.c"
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp28_;
		GtkOverlay* _tmp29_;
		GdkPixbuf* _tmp30_;
		GtkImage* _tmp31_;
		GtkImage* _tmp32_;
		GtkOverlay* _tmp33_;
#line 1228 "gnome-nibbles.vala"
		_tmp28_ = gdk_pixbuf_rotate_simple (arrow_key, GDK_PIXBUF_ROTATE_NONE);
#line 1228 "gnome-nibbles.vala"
		rotated_pixbuf = _tmp28_;
#line 1229 "gnome-nibbles.vala"
		_tmp29_ = self->priv->move_up;
#line 1229 "gnome-nibbles.vala"
		_tmp30_ = rotated_pixbuf;
#line 1229 "gnome-nibbles.vala"
		_tmp31_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp30_);
#line 1229 "gnome-nibbles.vala"
		g_object_ref_sink (_tmp31_);
#line 1229 "gnome-nibbles.vala"
		_tmp32_ = _tmp31_;
#line 1229 "gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp29_, (GtkWidget*) _tmp32_);
#line 1229 "gnome-nibbles.vala"
		_g_object_unref0 (_tmp32_);
#line 1230 "gnome-nibbles.vala"
		_tmp33_ = self->priv->move_up;
#line 1230 "gnome-nibbles.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp33_);
#line 1226 "gnome-nibbles.vala"
		_g_object_unref0 (rotated_pixbuf);
#line 7168 "gnome-nibbles.c"
	} else {
		GtkLabel* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
#line 1233 "gnome-nibbles.vala"
		_tmp34_ = self->priv->move_up_label;
#line 1233 "gnome-nibbles.vala"
		_tmp35_ = upper_key;
#line 1233 "gnome-nibbles.vala"
		_tmp36_ = string_to_string (_tmp35_);
#line 1233 "gnome-nibbles.vala"
		_tmp37_ = g_strconcat ("<b>", _tmp36_, "</b>", NULL);
#line 1233 "gnome-nibbles.vala"
		_tmp38_ = _tmp37_;
#line 1233 "gnome-nibbles.vala"
		gtk_label_set_markup (_tmp34_, _tmp38_);
#line 1233 "gnome-nibbles.vala"
		_g_free0 (_tmp38_);
#line 7189 "gnome-nibbles.c"
	}
#line 1235 "gnome-nibbles.vala"
	_tmp39_ = *worm_props;
#line 1235 "gnome-nibbles.vala"
	_tmp40_ = gdk_keyval_name (_tmp39_.down);
#line 1235 "gnome-nibbles.vala"
	_tmp41_ = g_utf8_strup (_tmp40_, (gssize) -1);
#line 1235 "gnome-nibbles.vala"
	_g_free0 (upper_key);
#line 1235 "gnome-nibbles.vala"
	upper_key = _tmp41_;
#line 1236 "gnome-nibbles.vala"
	_tmp42_ = upper_key;
#line 1236 "gnome-nibbles.vala"
	if (g_strcmp0 (_tmp42_, "DOWN") == 0) {
#line 7205 "gnome-nibbles.c"
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp43_;
		GtkOverlay* _tmp44_;
		GdkPixbuf* _tmp45_;
		GtkImage* _tmp46_;
		GtkImage* _tmp47_;
		GtkOverlay* _tmp48_;
#line 1238 "gnome-nibbles.vala"
		_tmp43_ = gdk_pixbuf_rotate_simple (arrow_key, GDK_PIXBUF_ROTATE_UPSIDEDOWN);
#line 1238 "gnome-nibbles.vala"
		rotated_pixbuf = _tmp43_;
#line 1239 "gnome-nibbles.vala"
		_tmp44_ = self->priv->move_down;
#line 1239 "gnome-nibbles.vala"
		_tmp45_ = rotated_pixbuf;
#line 1239 "gnome-nibbles.vala"
		_tmp46_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp45_);
#line 1239 "gnome-nibbles.vala"
		g_object_ref_sink (_tmp46_);
#line 1239 "gnome-nibbles.vala"
		_tmp47_ = _tmp46_;
#line 1239 "gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp44_, (GtkWidget*) _tmp47_);
#line 1239 "gnome-nibbles.vala"
		_g_object_unref0 (_tmp47_);
#line 1240 "gnome-nibbles.vala"
		_tmp48_ = self->priv->move_down;
#line 1240 "gnome-nibbles.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp48_);
#line 1236 "gnome-nibbles.vala"
		_g_object_unref0 (rotated_pixbuf);
#line 7237 "gnome-nibbles.c"
	} else {
		GtkLabel* _tmp49_;
		const gchar* _tmp50_;
		const gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
#line 1243 "gnome-nibbles.vala"
		_tmp49_ = self->priv->move_down_label;
#line 1243 "gnome-nibbles.vala"
		_tmp50_ = upper_key;
#line 1243 "gnome-nibbles.vala"
		_tmp51_ = string_to_string (_tmp50_);
#line 1243 "gnome-nibbles.vala"
		_tmp52_ = g_strconcat ("<b>", _tmp51_, "</b>", NULL);
#line 1243 "gnome-nibbles.vala"
		_tmp53_ = _tmp52_;
#line 1243 "gnome-nibbles.vala"
		gtk_label_set_markup (_tmp49_, _tmp53_);
#line 1243 "gnome-nibbles.vala"
		_g_free0 (_tmp53_);
#line 7258 "gnome-nibbles.c"
	}
#line 1245 "gnome-nibbles.vala"
	_tmp54_ = *worm_props;
#line 1245 "gnome-nibbles.vala"
	_tmp55_ = gdk_keyval_name (_tmp54_.left);
#line 1245 "gnome-nibbles.vala"
	_tmp56_ = g_utf8_strup (_tmp55_, (gssize) -1);
#line 1245 "gnome-nibbles.vala"
	_g_free0 (upper_key);
#line 1245 "gnome-nibbles.vala"
	upper_key = _tmp56_;
#line 1246 "gnome-nibbles.vala"
	_tmp57_ = upper_key;
#line 1246 "gnome-nibbles.vala"
	if (g_strcmp0 (_tmp57_, "LEFT") == 0) {
#line 7274 "gnome-nibbles.c"
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp58_;
		GtkOverlay* _tmp59_;
		GdkPixbuf* _tmp60_;
		GtkImage* _tmp61_;
		GtkImage* _tmp62_;
		GtkOverlay* _tmp63_;
#line 1248 "gnome-nibbles.vala"
		_tmp58_ = gdk_pixbuf_rotate_simple (arrow_key, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
#line 1248 "gnome-nibbles.vala"
		rotated_pixbuf = _tmp58_;
#line 1249 "gnome-nibbles.vala"
		_tmp59_ = self->priv->move_left;
#line 1249 "gnome-nibbles.vala"
		_tmp60_ = rotated_pixbuf;
#line 1249 "gnome-nibbles.vala"
		_tmp61_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp60_);
#line 1249 "gnome-nibbles.vala"
		g_object_ref_sink (_tmp61_);
#line 1249 "gnome-nibbles.vala"
		_tmp62_ = _tmp61_;
#line 1249 "gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp59_, (GtkWidget*) _tmp62_);
#line 1249 "gnome-nibbles.vala"
		_g_object_unref0 (_tmp62_);
#line 1250 "gnome-nibbles.vala"
		_tmp63_ = self->priv->move_left;
#line 1250 "gnome-nibbles.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp63_);
#line 1246 "gnome-nibbles.vala"
		_g_object_unref0 (rotated_pixbuf);
#line 7306 "gnome-nibbles.c"
	} else {
		GtkLabel* _tmp64_;
		const gchar* _tmp65_;
		const gchar* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
#line 1253 "gnome-nibbles.vala"
		_tmp64_ = self->priv->move_left_label;
#line 1253 "gnome-nibbles.vala"
		_tmp65_ = upper_key;
#line 1253 "gnome-nibbles.vala"
		_tmp66_ = string_to_string (_tmp65_);
#line 1253 "gnome-nibbles.vala"
		_tmp67_ = g_strconcat ("<b>", _tmp66_, "</b>", NULL);
#line 1253 "gnome-nibbles.vala"
		_tmp68_ = _tmp67_;
#line 1253 "gnome-nibbles.vala"
		gtk_label_set_markup (_tmp64_, _tmp68_);
#line 1253 "gnome-nibbles.vala"
		_g_free0 (_tmp68_);
#line 7327 "gnome-nibbles.c"
	}
#line 1255 "gnome-nibbles.vala"
	_tmp69_ = *worm_props;
#line 1255 "gnome-nibbles.vala"
	_tmp70_ = gdk_keyval_name (_tmp69_.right);
#line 1255 "gnome-nibbles.vala"
	_tmp71_ = g_utf8_strup (_tmp70_, (gssize) -1);
#line 1255 "gnome-nibbles.vala"
	_g_free0 (upper_key);
#line 1255 "gnome-nibbles.vala"
	upper_key = _tmp71_;
#line 1256 "gnome-nibbles.vala"
	_tmp72_ = upper_key;
#line 1256 "gnome-nibbles.vala"
	if (g_strcmp0 (_tmp72_, "RIGHT") == 0) {
#line 7343 "gnome-nibbles.c"
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp73_;
		GtkOverlay* _tmp74_;
		GdkPixbuf* _tmp75_;
		GtkImage* _tmp76_;
		GtkImage* _tmp77_;
		GtkOverlay* _tmp78_;
#line 1258 "gnome-nibbles.vala"
		_tmp73_ = gdk_pixbuf_rotate_simple (arrow_key, GDK_PIXBUF_ROTATE_CLOCKWISE);
#line 1258 "gnome-nibbles.vala"
		rotated_pixbuf = _tmp73_;
#line 1259 "gnome-nibbles.vala"
		_tmp74_ = self->priv->move_right;
#line 1259 "gnome-nibbles.vala"
		_tmp75_ = rotated_pixbuf;
#line 1259 "gnome-nibbles.vala"
		_tmp76_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp75_);
#line 1259 "gnome-nibbles.vala"
		g_object_ref_sink (_tmp76_);
#line 1259 "gnome-nibbles.vala"
		_tmp77_ = _tmp76_;
#line 1259 "gnome-nibbles.vala"
		gtk_overlay_add_overlay (_tmp74_, (GtkWidget*) _tmp77_);
#line 1259 "gnome-nibbles.vala"
		_g_object_unref0 (_tmp77_);
#line 1260 "gnome-nibbles.vala"
		_tmp78_ = self->priv->move_right;
#line 1260 "gnome-nibbles.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp78_);
#line 1256 "gnome-nibbles.vala"
		_g_object_unref0 (rotated_pixbuf);
#line 7375 "gnome-nibbles.c"
	} else {
		GtkLabel* _tmp79_;
		const gchar* _tmp80_;
		const gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
#line 1263 "gnome-nibbles.vala"
		_tmp79_ = self->priv->move_right_label;
#line 1263 "gnome-nibbles.vala"
		_tmp80_ = upper_key;
#line 1263 "gnome-nibbles.vala"
		_tmp81_ = string_to_string (_tmp80_);
#line 1263 "gnome-nibbles.vala"
		_tmp82_ = g_strconcat ("<b>", _tmp81_, "</b>", NULL);
#line 1263 "gnome-nibbles.vala"
		_tmp83_ = _tmp82_;
#line 1263 "gnome-nibbles.vala"
		gtk_label_set_markup (_tmp79_, _tmp83_);
#line 1263 "gnome-nibbles.vala"
		_g_free0 (_tmp83_);
#line 7396 "gnome-nibbles.c"
	}
#line 1210 "gnome-nibbles.vala"
	_g_free0 (upper_key);
#line 1210 "gnome-nibbles.vala"
	_g_free0 (player_id);
#line 1210 "gnome-nibbles.vala"
	return self;
#line 7404 "gnome-nibbles.c"
}

ControlsGrid*
controls_grid_new (gint worm_id,
                   WormProperties* worm_props,
                   GdkPixbuf* arrow,
                   GdkPixbuf* arrow_key)
{
#line 1210 "gnome-nibbles.vala"
	return controls_grid_construct (TYPE_CONTROLS_GRID, worm_id, worm_props, arrow, arrow_key);
#line 7415 "gnome-nibbles.c"
}

static void
controls_grid_class_init (ControlsGridClass * klass,
                          gpointer klass_data)
{
#line 1181 "gnome-nibbles.vala"
	controls_grid_parent_class = g_type_class_peek_parent (klass);
#line 1181 "gnome-nibbles.vala"
	g_type_class_adjust_private_offset (klass, &ControlsGrid_private_offset);
#line 1181 "gnome-nibbles.vala"
	G_OBJECT_CLASS (klass)->finalize = controls_grid_finalize;
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/controls-grid.ui");
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, name_label));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_up", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_up));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_down", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_down));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_left", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_left));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_right", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_right));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_up", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_up));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_up_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_up_label));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_down", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_down));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_down_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_down_label));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_left", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_left));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_left_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_left_label));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_right", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_right));
#line 1181 "gnome-nibbles.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_right_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_right_label));
#line 7456 "gnome-nibbles.c"
}

static void
controls_grid_instance_init (ControlsGrid * self,
                             gpointer klass)
{
#line 1181 "gnome-nibbles.vala"
	self->priv = controls_grid_get_instance_private (self);
#line 1181 "gnome-nibbles.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 7467 "gnome-nibbles.c"
}

static void
controls_grid_finalize (GObject * obj)
{
	ControlsGrid * self;
#line 1181 "gnome-nibbles.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONTROLS_GRID, ControlsGrid);
#line 1184 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->name_label);
#line 1186 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_up);
#line 1188 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_down);
#line 1190 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_left);
#line 1192 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->arrow_right);
#line 1194 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_up);
#line 1196 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_up_label);
#line 1198 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_down);
#line 1200 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_down_label);
#line 1202 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_left);
#line 1204 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_left_label);
#line 1206 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_right);
#line 1208 "gnome-nibbles.vala"
	_g_object_unref0 (self->priv->move_right_label);
#line 1181 "gnome-nibbles.vala"
	G_OBJECT_CLASS (controls_grid_parent_class)->finalize (obj);
#line 7504 "gnome-nibbles.c"
}

GType
controls_grid_get_type (void)
{
	static volatile gsize controls_grid_type_id__volatile = 0;
	if (g_once_init_enter (&controls_grid_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ControlsGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) controls_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ControlsGrid), 0, (GInstanceInitFunc) controls_grid_instance_init, NULL };
		GType controls_grid_type_id;
		controls_grid_type_id = g_type_register_static (gtk_grid_get_type (), "ControlsGrid", &g_define_type_info, 0);
		ControlsGrid_private_offset = g_type_add_instance_private (controls_grid_type_id, sizeof (ControlsGridPrivate));
		g_once_init_leave (&controls_grid_type_id__volatile, controls_grid_type_id);
	}
	return controls_grid_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

