/* preferences-dialog.c generated by valac 0.40.8, the Vala compiler
 * generated from preferences-dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Gabriel Ivascu <ivascu.gabriel59@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>


#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;
typedef struct _PreferencesDialogPrivate PreferencesDialogPrivate;
enum  {
	PREFERENCES_DIALOG_0_PROPERTY,
	PREFERENCES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* preferences_dialog_properties[PREFERENCES_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

struct _PreferencesDialog {
	GtkDialog parent_instance;
	PreferencesDialogPrivate * priv;
};

struct _PreferencesDialogClass {
	GtkDialogClass parent_class;
};

struct _PreferencesDialogPrivate {
	GtkApplicationWindow* window;
	GSettings* settings;
	GeeArrayList* worm_settings;
	GtkNotebook* notebook;
	GtkRadioButton* beginner_radio_button;
	GtkRadioButton* slow_radio_button;
	GtkRadioButton* medium_radio_button;
	GtkRadioButton* fast_radio_button;
	GtkCheckButton* sound_check_button;
	GtkCheckButton* fakes_check_button;
	GtkListStore* list_store_1;
	GtkListStore* list_store_2;
	GtkListStore* list_store_3;
	GtkListStore* list_store_4;
	GtkTreeView* tree_view_1;
	GtkTreeView* tree_view_2;
	GtkTreeView* tree_view_3;
	GtkTreeView* tree_view_4;
	GtkComboBoxText* combo_box_1;
	GtkComboBoxText* combo_box_2;
	GtkComboBoxText* combo_box_3;
	GtkComboBoxText* combo_box_4;
	GeeArrayList* radio_buttons;
	GeeArrayList* list_stores;
	GeeArrayList* tree_views;
	GeeArrayList* combo_boxes;
};


static gpointer preferences_dialog_parent_class = NULL;

GType preferences_dialog_get_type (void) G_GNUC_CONST;
#define PREFERENCES_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PREFERENCES_DIALOG, PreferencesDialogPrivate))
PreferencesDialog* preferences_dialog_new (GtkApplicationWindow* window,
                                           GSettings* settings,
                                           GeeArrayList* worm_settings);
PreferencesDialog* preferences_dialog_construct (GType object_type,
                                                 GtkApplicationWindow* window,
                                                 GSettings* settings,
                                                 GeeArrayList* worm_settings);
static void __lambda4_ (PreferencesDialog* self);
static void ___lambda4__gtk_dialog_response (GtkDialog* _sender,
                                      gint response_id,
                                      gpointer self);
#define NIBBLES_GAME_MAX_SPEED 4
static void preferences_dialog_radio_button_toggled_cb (PreferencesDialog* self,
                                                 GtkToggleButton* button);
static void _preferences_dialog_radio_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                            gpointer self);
static void preferences_dialog_sound_toggled_cb (PreferencesDialog* self);
static void _preferences_dialog_sound_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                     gpointer self);
static void preferences_dialog_fakes_toggles_cb (PreferencesDialog* self);
static void _preferences_dialog_fakes_toggles_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                     gpointer self);
static void preferences_dialog_accel_edited_cb (PreferencesDialog* self,
                                         GtkCellRendererAccel* cell,
                                         const gchar* path_string,
                                         guint keyval,
                                         GdkModifierType mask,
                                         guint hardware_keycode);
static void _preferences_dialog_accel_edited_cb_gtk_cell_renderer_accel_accel_edited (GtkCellRendererAccel* _sender,
                                                                               const gchar* path_string,
                                                                               guint accel_key,
                                                                               GdkModifierType accel_mods,
                                                                               guint hardware_keycode,
                                                                               gpointer self);
static void preferences_dialog_accel_cleared_cb (PreferencesDialog* self,
                                          GtkCellRendererAccel* cell,
                                          const gchar* path_string);
static void _preferences_dialog_accel_cleared_cb_gtk_cell_renderer_accel_accel_cleared (GtkCellRendererAccel* _sender,
                                                                                 const gchar* path_string,
                                                                                 gpointer self);
#define NIBBLES_VIEW_NUM_COLORS 6
gchar* nibbles_view_colorval_name (gint colorval);
static void preferences_dialog_combo_box_changed_cb (PreferencesDialog* self,
                                              GtkComboBox* combo_box);
static void _preferences_dialog_combo_box_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                     gpointer self);
static void _vala_GtkTreePath_free (GtkTreePath* self);
#define NIBBLES_GAME_MAX_HUMANS 4
#define NIBBLES_GAME_MAX_WORMS 6
static void preferences_dialog_finalize (GObject * obj);


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
__lambda4_ (PreferencesDialog* self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}


static void
___lambda4__gtk_dialog_response (GtkDialog* _sender,
                                 gint response_id,
                                 gpointer self)
{
	__lambda4_ ((PreferencesDialog*) self);
}


static void
_preferences_dialog_radio_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self)
{
	preferences_dialog_radio_button_toggled_cb ((PreferencesDialog*) self, _sender);
}


static void
_preferences_dialog_sound_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                gpointer self)
{
	preferences_dialog_sound_toggled_cb ((PreferencesDialog*) self);
}


static void
_preferences_dialog_fakes_toggles_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                gpointer self)
{
	preferences_dialog_fakes_toggles_cb ((PreferencesDialog*) self);
}


static void
_preferences_dialog_accel_edited_cb_gtk_cell_renderer_accel_accel_edited (GtkCellRendererAccel* _sender,
                                                                          const gchar* path_string,
                                                                          guint accel_key,
                                                                          GdkModifierType accel_mods,
                                                                          guint hardware_keycode,
                                                                          gpointer self)
{
	preferences_dialog_accel_edited_cb ((PreferencesDialog*) self, _sender, path_string, accel_key, accel_mods, hardware_keycode);
}


static void
_preferences_dialog_accel_cleared_cb_gtk_cell_renderer_accel_accel_cleared (GtkCellRendererAccel* _sender,
                                                                            const gchar* path_string,
                                                                            gpointer self)
{
	preferences_dialog_accel_cleared_cb ((PreferencesDialog*) self, _sender, path_string);
}


static void
_preferences_dialog_combo_box_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                gpointer self)
{
	preferences_dialog_combo_box_changed_cb ((PreferencesDialog*) self, _sender);
}


PreferencesDialog*
preferences_dialog_construct (GType object_type,
                              GtkApplicationWindow* window,
                              GSettings* settings,
                              GeeArrayList* worm_settings)
{
	PreferencesDialog * self = NULL;
	GSettings* _tmp0_;
	GeeArrayList* _tmp1_;
	GtkApplicationWindow* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GtkRadioButton* _tmp5_;
	GeeArrayList* _tmp6_;
	GtkRadioButton* _tmp7_;
	GeeArrayList* _tmp8_;
	GtkRadioButton* _tmp9_;
	GeeArrayList* _tmp10_;
	GtkRadioButton* _tmp11_;
	GtkCheckButton* _tmp28_;
	GtkCheckButton* _tmp29_;
	GtkCheckButton* _tmp30_;
	GtkCheckButton* _tmp31_;
	GeeArrayList* _tmp32_;
	GeeArrayList* _tmp33_;
	GtkTreeView* _tmp34_;
	GeeArrayList* _tmp35_;
	GtkTreeView* _tmp36_;
	GeeArrayList* _tmp37_;
	GtkTreeView* _tmp38_;
	GeeArrayList* _tmp39_;
	GtkTreeView* _tmp40_;
	GeeArrayList* _tmp41_;
	GeeArrayList* _tmp42_;
	GtkListStore* _tmp43_;
	GeeArrayList* _tmp44_;
	GtkListStore* _tmp45_;
	GeeArrayList* _tmp46_;
	GtkListStore* _tmp47_;
	GeeArrayList* _tmp48_;
	GtkListStore* _tmp49_;
	GeeArrayList* _tmp109_;
	GeeArrayList* _tmp110_;
	GtkComboBoxText* _tmp111_;
	GeeArrayList* _tmp112_;
	GtkComboBoxText* _tmp113_;
	GeeArrayList* _tmp114_;
	GtkComboBoxText* _tmp115_;
	GeeArrayList* _tmp116_;
	GtkComboBoxText* _tmp117_;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (worm_settings != NULL, NULL);
	self = (PreferencesDialog*) g_object_new (object_type, "use-header-bar", 1, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = _g_object_ref0 (worm_settings);
	_g_object_unref0 (self->priv->worm_settings);
	self->priv->worm_settings = _tmp1_;
	_tmp2_ = _g_object_ref0 (window);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp2_;
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) ___lambda4__gtk_dialog_response, self, 0);
	gtk_window_set_transient_for ((GtkWindow*) self, (GtkWindow*) window);
	_tmp3_ = gee_array_list_new (gtk_radio_button_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->radio_buttons);
	self->priv->radio_buttons = _tmp3_;
	_tmp4_ = self->priv->radio_buttons;
	_tmp5_ = self->priv->beginner_radio_button;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp5_);
	_tmp6_ = self->priv->radio_buttons;
	_tmp7_ = self->priv->slow_radio_button;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp7_);
	_tmp8_ = self->priv->radio_buttons;
	_tmp9_ = self->priv->medium_radio_button;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
	_tmp10_ = self->priv->radio_buttons;
	_tmp11_ = self->priv->fast_radio_button;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
	{
		GeeArrayList* _radio_button_list = NULL;
		GeeArrayList* _tmp12_;
		GeeArrayList* _tmp13_;
		gint _radio_button_size = 0;
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _radio_button_index = 0;
		_tmp12_ = self->priv->radio_buttons;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		_radio_button_list = _tmp13_;
		_tmp14_ = _radio_button_list;
		_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_radio_button_size = _tmp16_;
		_radio_button_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			GtkRadioButton* radio_button = NULL;
			GeeArrayList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			gint speed = 0;
			GeeArrayList* _tmp23_;
			GtkRadioButton* _tmp24_;
			GtkRadioButton* _tmp25_;
			gint _tmp26_;
			GtkRadioButton* _tmp27_;
			_tmp17_ = _radio_button_index;
			_radio_button_index = _tmp17_ + 1;
			_tmp18_ = _radio_button_index;
			_tmp19_ = _radio_button_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _radio_button_list;
			_tmp21_ = _radio_button_index;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _tmp21_);
			radio_button = (GtkRadioButton*) _tmp22_;
			_tmp23_ = self->priv->radio_buttons;
			_tmp24_ = radio_button;
			speed = NIBBLES_GAME_MAX_SPEED - gee_abstract_list_index_of ((GeeAbstractList*) _tmp23_, _tmp24_);
			_tmp25_ = radio_button;
			_tmp26_ = speed;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp25_, _tmp26_ == g_settings_get_int (settings, "speed"));
			_tmp27_ = radio_button;
			g_signal_connect_object ((GtkToggleButton*) _tmp27_, "toggled", (GCallback) _preferences_dialog_radio_button_toggled_cb_gtk_toggle_button_toggled, self, 0);
			_g_object_unref0 (radio_button);
		}
		_g_object_unref0 (_radio_button_list);
	}
	_tmp28_ = self->priv->sound_check_button;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp28_, g_settings_get_boolean (settings, "sound"));
	_tmp29_ = self->priv->sound_check_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp29_, "toggled", (GCallback) _preferences_dialog_sound_toggled_cb_gtk_toggle_button_toggled, self, 0);
	_tmp30_ = self->priv->fakes_check_button;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp30_, g_settings_get_boolean (settings, "fakes"));
	_tmp31_ = self->priv->fakes_check_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp31_, "toggled", (GCallback) _preferences_dialog_fakes_toggles_cb_gtk_toggle_button_toggled, self, 0);
	_tmp32_ = gee_array_list_new (gtk_tree_view_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->tree_views);
	self->priv->tree_views = _tmp32_;
	_tmp33_ = self->priv->tree_views;
	_tmp34_ = self->priv->tree_view_1;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp34_);
	_tmp35_ = self->priv->tree_views;
	_tmp36_ = self->priv->tree_view_2;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, _tmp36_);
	_tmp37_ = self->priv->tree_views;
	_tmp38_ = self->priv->tree_view_3;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp37_, _tmp38_);
	_tmp39_ = self->priv->tree_views;
	_tmp40_ = self->priv->tree_view_4;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp40_);
	_tmp41_ = gee_array_list_new (gtk_list_store_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->list_stores);
	self->priv->list_stores = _tmp41_;
	_tmp42_ = self->priv->list_stores;
	_tmp43_ = self->priv->list_store_1;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp42_, _tmp43_);
	_tmp44_ = self->priv->list_stores;
	_tmp45_ = self->priv->list_store_2;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp44_, _tmp45_);
	_tmp46_ = self->priv->list_stores;
	_tmp47_ = self->priv->list_store_3;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, _tmp47_);
	_tmp48_ = self->priv->list_stores;
	_tmp49_ = self->priv->list_store_4;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp48_, _tmp49_);
	{
		GeeArrayList* _list_store_list = NULL;
		GeeArrayList* _tmp50_;
		GeeArrayList* _tmp51_;
		gint _list_store_size = 0;
		GeeArrayList* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		gint _list_store_index = 0;
		_tmp50_ = self->priv->list_stores;
		_tmp51_ = _g_object_ref0 (_tmp50_);
		_list_store_list = _tmp51_;
		_tmp52_ = _list_store_list;
		_tmp53_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp52_);
		_tmp54_ = _tmp53_;
		_list_store_size = _tmp54_;
		_list_store_index = -1;
		while (TRUE) {
			gint _tmp55_;
			gint _tmp56_;
			gint _tmp57_;
			GtkListStore* list_store = NULL;
			GeeArrayList* _tmp58_;
			gint _tmp59_;
			gpointer _tmp60_;
			gint id = 0;
			GeeArrayList* _tmp61_;
			GtkListStore* _tmp62_;
			GtkTreeView* tree_view = NULL;
			GeeArrayList* _tmp63_;
			gint _tmp64_;
			gpointer _tmp65_;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp66_;
			GtkTreeIter _tmp67_ = {0};
			gint keyval = 0;
			gint _tmp68_;
			gpointer _tmp69_;
			GSettings* _tmp70_;
			gint _tmp71_;
			GtkListStore* _tmp72_;
			GtkTreeIter _tmp73_;
			gint _tmp74_;
			GtkListStore* _tmp75_;
			GtkTreeIter _tmp76_ = {0};
			gint _tmp77_;
			gpointer _tmp78_;
			GSettings* _tmp79_;
			GtkListStore* _tmp80_;
			GtkTreeIter _tmp81_;
			gint _tmp82_;
			GtkListStore* _tmp83_;
			GtkTreeIter _tmp84_ = {0};
			gint _tmp85_;
			gpointer _tmp86_;
			GSettings* _tmp87_;
			GtkListStore* _tmp88_;
			GtkTreeIter _tmp89_;
			gint _tmp90_;
			GtkListStore* _tmp91_;
			GtkTreeIter _tmp92_ = {0};
			gint _tmp93_;
			gpointer _tmp94_;
			GSettings* _tmp95_;
			GtkListStore* _tmp96_;
			GtkTreeIter _tmp97_;
			gint _tmp98_;
			GtkCellRendererText* label_renderer = NULL;
			GtkCellRendererText* _tmp99_;
			GtkTreeView* _tmp100_;
			GtkCellRendererText* _tmp101_;
			GtkCellRendererAccel* key_renderer = NULL;
			GtkCellRendererAccel* _tmp102_;
			GtkCellRendererAccel* _tmp103_;
			GtkCellRendererAccel* _tmp104_;
			GtkCellRendererAccel* _tmp105_;
			GtkCellRendererAccel* _tmp106_;
			GtkTreeView* _tmp107_;
			GtkCellRendererAccel* _tmp108_;
			_tmp55_ = _list_store_index;
			_list_store_index = _tmp55_ + 1;
			_tmp56_ = _list_store_index;
			_tmp57_ = _list_store_size;
			if (!(_tmp56_ < _tmp57_)) {
				break;
			}
			_tmp58_ = _list_store_list;
			_tmp59_ = _list_store_index;
			_tmp60_ = gee_abstract_list_get ((GeeAbstractList*) _tmp58_, _tmp59_);
			list_store = (GtkListStore*) _tmp60_;
			_tmp61_ = self->priv->list_stores;
			_tmp62_ = list_store;
			id = gee_abstract_list_index_of ((GeeAbstractList*) _tmp61_, _tmp62_);
			_tmp63_ = self->priv->tree_views;
			_tmp64_ = id;
			_tmp65_ = gee_abstract_list_get ((GeeAbstractList*) _tmp63_, _tmp64_);
			tree_view = (GtkTreeView*) _tmp65_;
			_tmp66_ = list_store;
			gtk_list_store_append (_tmp66_, &_tmp67_);
			iter = _tmp67_;
			_tmp68_ = id;
			_tmp69_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp68_);
			_tmp70_ = (GSettings*) _tmp69_;
			_tmp71_ = g_settings_get_int (_tmp70_, "key-up");
			_g_object_unref0 (_tmp70_);
			keyval = _tmp71_;
			_tmp72_ = list_store;
			_tmp73_ = iter;
			_tmp74_ = keyval;
			gtk_list_store_set (_tmp72_, &_tmp73_, 0, "key-up", 1, _ ("Move up"), 2, _tmp74_, -1);
			_tmp75_ = list_store;
			gtk_list_store_append (_tmp75_, &_tmp76_);
			iter = _tmp76_;
			_tmp77_ = id;
			_tmp78_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp77_);
			_tmp79_ = (GSettings*) _tmp78_;
			keyval = g_settings_get_int (_tmp79_, "key-down");
			_g_object_unref0 (_tmp79_);
			_tmp80_ = list_store;
			_tmp81_ = iter;
			_tmp82_ = keyval;
			gtk_list_store_set (_tmp80_, &_tmp81_, 0, "key-down", 1, _ ("Move down"), 2, _tmp82_, -1);
			_tmp83_ = list_store;
			gtk_list_store_append (_tmp83_, &_tmp84_);
			iter = _tmp84_;
			_tmp85_ = id;
			_tmp86_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp85_);
			_tmp87_ = (GSettings*) _tmp86_;
			keyval = g_settings_get_int (_tmp87_, "key-left");
			_g_object_unref0 (_tmp87_);
			_tmp88_ = list_store;
			_tmp89_ = iter;
			_tmp90_ = keyval;
			gtk_list_store_set (_tmp88_, &_tmp89_, 0, "key-left", 1, _ ("Move left"), 2, _tmp90_, -1);
			_tmp91_ = list_store;
			gtk_list_store_append (_tmp91_, &_tmp92_);
			iter = _tmp92_;
			_tmp93_ = id;
			_tmp94_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp93_);
			_tmp95_ = (GSettings*) _tmp94_;
			keyval = g_settings_get_int (_tmp95_, "key-right");
			_g_object_unref0 (_tmp95_);
			_tmp96_ = list_store;
			_tmp97_ = iter;
			_tmp98_ = keyval;
			gtk_list_store_set (_tmp96_, &_tmp97_, 0, "key-right", 1, _ ("Move right"), 2, _tmp98_, -1);
			_tmp99_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
			g_object_ref_sink (_tmp99_);
			label_renderer = _tmp99_;
			_tmp100_ = tree_view;
			_tmp101_ = label_renderer;
			gtk_tree_view_insert_column_with_attributes (_tmp100_, -1, _ ("Action"), (GtkCellRenderer*) _tmp101_, "text", 1, NULL);
			_tmp102_ = (GtkCellRendererAccel*) gtk_cell_renderer_accel_new ();
			g_object_ref_sink (_tmp102_);
			key_renderer = _tmp102_;
			_tmp103_ = key_renderer;
			g_object_set ((GtkCellRendererText*) _tmp103_, "editable", TRUE, NULL);
			_tmp104_ = key_renderer;
			g_object_set (_tmp104_, "accel-mode", GTK_CELL_RENDERER_ACCEL_MODE_OTHER, NULL);
			_tmp105_ = key_renderer;
			g_signal_connect_object (_tmp105_, "accel-edited", (GCallback) _preferences_dialog_accel_edited_cb_gtk_cell_renderer_accel_accel_edited, self, 0);
			_tmp106_ = key_renderer;
			g_signal_connect_object (_tmp106_, "accel-cleared", (GCallback) _preferences_dialog_accel_cleared_cb_gtk_cell_renderer_accel_accel_cleared, self, 0);
			_tmp107_ = tree_view;
			_tmp108_ = key_renderer;
			gtk_tree_view_insert_column_with_attributes (_tmp107_, -1, _ ("Key"), (GtkCellRenderer*) _tmp108_, "accel-key", 2, NULL);
			_g_object_unref0 (key_renderer);
			_g_object_unref0 (label_renderer);
			_g_object_unref0 (tree_view);
			_g_object_unref0 (list_store);
		}
		_g_object_unref0 (_list_store_list);
	}
	_tmp109_ = gee_array_list_new (gtk_combo_box_text_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->combo_boxes);
	self->priv->combo_boxes = _tmp109_;
	_tmp110_ = self->priv->combo_boxes;
	_tmp111_ = self->priv->combo_box_1;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp110_, _tmp111_);
	_tmp112_ = self->priv->combo_boxes;
	_tmp113_ = self->priv->combo_box_2;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp112_, _tmp113_);
	_tmp114_ = self->priv->combo_boxes;
	_tmp115_ = self->priv->combo_box_3;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp114_, _tmp115_);
	_tmp116_ = self->priv->combo_boxes;
	_tmp117_ = self->priv->combo_box_4;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp116_, _tmp117_);
	{
		GeeArrayList* _combo_box_list = NULL;
		GeeArrayList* _tmp118_;
		GeeArrayList* _tmp119_;
		gint _combo_box_size = 0;
		GeeArrayList* _tmp120_;
		gint _tmp121_;
		gint _tmp122_;
		gint _combo_box_index = 0;
		_tmp118_ = self->priv->combo_boxes;
		_tmp119_ = _g_object_ref0 (_tmp118_);
		_combo_box_list = _tmp119_;
		_tmp120_ = _combo_box_list;
		_tmp121_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp120_);
		_tmp122_ = _tmp121_;
		_combo_box_size = _tmp122_;
		_combo_box_index = -1;
		while (TRUE) {
			gint _tmp123_;
			gint _tmp124_;
			gint _tmp125_;
			GtkComboBoxText* combo_box = NULL;
			GeeArrayList* _tmp126_;
			gint _tmp127_;
			gpointer _tmp128_;
			gint id = 0;
			GeeArrayList* _tmp136_;
			GtkComboBoxText* _tmp137_;
			gint color = 0;
			gint _tmp138_;
			gpointer _tmp139_;
			GSettings* _tmp140_;
			gint _tmp141_;
			GtkComboBoxText* _tmp142_;
			gint _tmp143_;
			GtkComboBoxText* _tmp144_;
			_tmp123_ = _combo_box_index;
			_combo_box_index = _tmp123_ + 1;
			_tmp124_ = _combo_box_index;
			_tmp125_ = _combo_box_size;
			if (!(_tmp124_ < _tmp125_)) {
				break;
			}
			_tmp126_ = _combo_box_list;
			_tmp127_ = _combo_box_index;
			_tmp128_ = gee_abstract_list_get ((GeeAbstractList*) _tmp126_, _tmp127_);
			combo_box = (GtkComboBoxText*) _tmp128_;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp129_ = FALSE;
					_tmp129_ = TRUE;
					while (TRUE) {
						gint _tmp131_;
						GtkComboBoxText* _tmp132_;
						gint _tmp133_;
						gchar* _tmp134_;
						gchar* _tmp135_;
						if (!_tmp129_) {
							gint _tmp130_;
							_tmp130_ = i;
							i = _tmp130_ + 1;
						}
						_tmp129_ = FALSE;
						_tmp131_ = i;
						if (!(_tmp131_ < NIBBLES_VIEW_NUM_COLORS)) {
							break;
						}
						_tmp132_ = combo_box;
						_tmp133_ = i;
						_tmp134_ = nibbles_view_colorval_name (_tmp133_);
						_tmp135_ = _tmp134_;
						gtk_combo_box_text_append_text (_tmp132_, _tmp135_);
						_g_free0 (_tmp135_);
					}
				}
			}
			_tmp136_ = self->priv->combo_boxes;
			_tmp137_ = combo_box;
			id = gee_abstract_list_index_of ((GeeAbstractList*) _tmp136_, _tmp137_);
			_tmp138_ = id;
			_tmp139_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp138_);
			_tmp140_ = (GSettings*) _tmp139_;
			_tmp141_ = g_settings_get_enum (_tmp140_, "color");
			_g_object_unref0 (_tmp140_);
			color = _tmp141_;
			_tmp142_ = combo_box;
			_tmp143_ = color;
			gtk_combo_box_set_active ((GtkComboBox*) _tmp142_, _tmp143_);
			_tmp144_ = combo_box;
			g_signal_connect_object ((GtkComboBox*) _tmp144_, "changed", (GCallback) _preferences_dialog_combo_box_changed_cb_gtk_combo_box_changed, self, 0);
			_g_object_unref0 (combo_box);
		}
		_g_object_unref0 (_combo_box_list);
	}
	return self;
}


PreferencesDialog*
preferences_dialog_new (GtkApplicationWindow* window,
                        GSettings* settings,
                        GeeArrayList* worm_settings)
{
	return preferences_dialog_construct (TYPE_PREFERENCES_DIALOG, window, settings, worm_settings);
}


static void
preferences_dialog_radio_button_toggled_cb (PreferencesDialog* self,
                                            GtkToggleButton* button)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (gtk_toggle_button_get_active (button)) {
		gint speed = 0;
		GeeArrayList* _tmp0_;
		GSettings* _tmp1_;
		gint _tmp2_;
		_tmp0_ = self->priv->radio_buttons;
		speed = NIBBLES_GAME_MAX_SPEED - gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (button, gtk_radio_button_get_type (), GtkRadioButton));
		_tmp1_ = self->priv->settings;
		_tmp2_ = speed;
		g_settings_set_int (_tmp1_, "speed", _tmp2_);
	}
}


static void
preferences_dialog_sound_toggled_cb (PreferencesDialog* self)
{
	gboolean play_sound = FALSE;
	GtkCheckButton* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sound_check_button;
	play_sound = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp1_ = self->priv->settings;
	g_settings_set_boolean (_tmp1_, "sound", play_sound);
}


static void
preferences_dialog_fakes_toggles_cb (PreferencesDialog* self)
{
	gboolean has_fakes = FALSE;
	GtkCheckButton* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->fakes_check_button;
	has_fakes = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp1_ = self->priv->settings;
	g_settings_set_boolean (_tmp1_, "fakes", has_fakes);
}


static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}


static void
preferences_dialog_accel_edited_cb (PreferencesDialog* self,
                                    GtkCellRendererAccel* cell,
                                    const gchar* path_string,
                                    guint keyval,
                                    GdkModifierType mask,
                                    guint hardware_keycode)
{
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	GtkTreePath* _tmp1_;
	gint id = 0;
	GtkNotebook* _tmp2_;
	GtkListStore* list_store = NULL;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gpointer _tmp5_;
	GtkTreeIter it = {0};
	GtkListStore* _tmp6_;
	GtkTreePath* _tmp7_;
	GtkTreeIter _tmp8_ = {0};
	gboolean _tmp9_;
	gchar* key = NULL;
	GtkListStore* _tmp10_;
	GtkTreeIter _tmp11_;
	const gchar* _tmp12_;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gpointer _tmp15_;
	GSettings* _tmp16_;
	const gchar* _tmp17_;
	gboolean _tmp18_;
	gboolean valid = FALSE;
	gboolean _tmp46_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (path_string != NULL);
	_tmp0_ = gtk_tree_path_new_from_string (path_string);
	path = _tmp0_;
	_tmp1_ = path;
	if (_tmp1_ == NULL) {
		__vala_GtkTreePath_free0 (path);
		return;
	}
	_tmp2_ = self->priv->notebook;
	id = gtk_notebook_get_current_page (_tmp2_) - 1;
	_tmp3_ = self->priv->list_stores;
	_tmp4_ = id;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp4_);
	list_store = (GtkListStore*) _tmp5_;
	_tmp6_ = list_store;
	_tmp7_ = path;
	_tmp9_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp6_, &_tmp8_, _tmp7_);
	it = _tmp8_;
	if (!_tmp9_) {
		_g_object_unref0 (list_store);
		__vala_GtkTreePath_free0 (path);
		return;
	}
	key = NULL;
	_tmp10_ = list_store;
	_tmp11_ = it;
	gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 0, &key, -1);
	_tmp12_ = key;
	if (_tmp12_ == NULL) {
		_g_free0 (key);
		_g_object_unref0 (list_store);
		__vala_GtkTreePath_free0 (path);
		return;
	}
	_tmp13_ = self->priv->worm_settings;
	_tmp14_ = id;
	_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _tmp14_);
	_tmp16_ = (GSettings*) _tmp15_;
	_tmp17_ = key;
	_tmp18_ = ((guint) g_settings_get_int (_tmp16_, _tmp17_)) == keyval;
	_g_object_unref0 (_tmp16_);
	if (_tmp18_) {
		_g_free0 (key);
		_g_object_unref0 (list_store);
		__vala_GtkTreePath_free0 (path);
		return;
	}
	valid = TRUE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				gint _tmp21_;
				gboolean _tmp22_ = FALSE;
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				GeeArrayList* _tmp25_;
				gint _tmp26_;
				gpointer _tmp27_;
				GSettings* _tmp28_;
				gboolean _tmp29_;
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = i;
					i = _tmp20_ + 1;
				}
				_tmp19_ = FALSE;
				_tmp21_ = i;
				if (!(_tmp21_ < NIBBLES_GAME_MAX_HUMANS)) {
					break;
				}
				_tmp25_ = self->priv->worm_settings;
				_tmp26_ = i;
				_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _tmp26_);
				_tmp28_ = (GSettings*) _tmp27_;
				_tmp29_ = ((guint) g_settings_get_int (_tmp28_, "key-up")) == keyval;
				_g_object_unref0 (_tmp28_);
				if (_tmp29_) {
					_tmp24_ = TRUE;
				} else {
					GeeArrayList* _tmp30_;
					gint _tmp31_;
					gpointer _tmp32_;
					GSettings* _tmp33_;
					_tmp30_ = self->priv->worm_settings;
					_tmp31_ = i;
					_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _tmp31_);
					_tmp33_ = (GSettings*) _tmp32_;
					_tmp24_ = ((guint) g_settings_get_int (_tmp33_, "key-down")) == keyval;
					_g_object_unref0 (_tmp33_);
				}
				if (_tmp24_) {
					_tmp23_ = TRUE;
				} else {
					GeeArrayList* _tmp34_;
					gint _tmp35_;
					gpointer _tmp36_;
					GSettings* _tmp37_;
					_tmp34_ = self->priv->worm_settings;
					_tmp35_ = i;
					_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _tmp35_);
					_tmp37_ = (GSettings*) _tmp36_;
					_tmp23_ = ((guint) g_settings_get_int (_tmp37_, "key-left")) == keyval;
					_g_object_unref0 (_tmp37_);
				}
				if (_tmp23_) {
					_tmp22_ = TRUE;
				} else {
					GeeArrayList* _tmp38_;
					gint _tmp39_;
					gpointer _tmp40_;
					GSettings* _tmp41_;
					_tmp38_ = self->priv->worm_settings;
					_tmp39_ = i;
					_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp38_, _tmp39_);
					_tmp41_ = (GSettings*) _tmp40_;
					_tmp22_ = ((guint) g_settings_get_int (_tmp41_, "key-right")) == keyval;
					_g_object_unref0 (_tmp41_);
				}
				if (_tmp22_) {
					GtkMessageDialog* dialog = NULL;
					GtkApplicationWindow* _tmp42_;
					GtkMessageDialog* _tmp43_;
					GtkMessageDialog* _tmp44_;
					GtkMessageDialog* _tmp45_;
					valid = FALSE;
					_tmp42_ = self->priv->window;
					_tmp43_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp42_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK, "%s", _ ("The key you selected is already assigned!"));
					g_object_ref_sink (_tmp43_);
					dialog = _tmp43_;
					_tmp44_ = dialog;
					gtk_dialog_run ((GtkDialog*) _tmp44_);
					_tmp45_ = dialog;
					gtk_widget_destroy ((GtkWidget*) _tmp45_);
					_g_object_unref0 (dialog);
					break;
				}
			}
		}
	}
	_tmp46_ = valid;
	if (_tmp46_) {
		GtkListStore* _tmp47_;
		GtkTreeIter _tmp48_;
		GeeArrayList* _tmp49_;
		gint _tmp50_;
		gpointer _tmp51_;
		GSettings* _tmp52_;
		const gchar* _tmp53_;
		_tmp47_ = list_store;
		_tmp48_ = it;
		gtk_list_store_set (_tmp47_, &_tmp48_, 2, keyval, -1);
		_tmp49_ = self->priv->worm_settings;
		_tmp50_ = id;
		_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp49_, _tmp50_);
		_tmp52_ = (GSettings*) _tmp51_;
		_tmp53_ = key;
		g_settings_set_int (_tmp52_, _tmp53_, (gint) keyval);
		_g_object_unref0 (_tmp52_);
	}
	_g_free0 (key);
	_g_object_unref0 (list_store);
	__vala_GtkTreePath_free0 (path);
}


static void
preferences_dialog_accel_cleared_cb (PreferencesDialog* self,
                                     GtkCellRendererAccel* cell,
                                     const gchar* path_string)
{
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	GtkTreePath* _tmp1_;
	gint id = 0;
	GtkNotebook* _tmp2_;
	GtkListStore* list_store = NULL;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gpointer _tmp5_;
	GtkTreeIter it = {0};
	GtkListStore* _tmp6_;
	GtkTreePath* _tmp7_;
	GtkTreeIter _tmp8_ = {0};
	gboolean _tmp9_;
	gchar* key = NULL;
	GtkListStore* _tmp10_;
	GtkTreeIter _tmp11_;
	const gchar* _tmp12_;
	GtkListStore* _tmp13_;
	GtkTreeIter _tmp14_;
	GeeArrayList* _tmp15_;
	gint _tmp16_;
	gpointer _tmp17_;
	GSettings* _tmp18_;
	const gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (path_string != NULL);
	_tmp0_ = gtk_tree_path_new_from_string (path_string);
	path = _tmp0_;
	_tmp1_ = path;
	if (_tmp1_ == NULL) {
		__vala_GtkTreePath_free0 (path);
		return;
	}
	_tmp2_ = self->priv->notebook;
	id = gtk_notebook_get_current_page (_tmp2_) - 1;
	_tmp3_ = self->priv->list_stores;
	_tmp4_ = id;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, _tmp4_);
	list_store = (GtkListStore*) _tmp5_;
	_tmp6_ = list_store;
	_tmp7_ = path;
	_tmp9_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp6_, &_tmp8_, _tmp7_);
	it = _tmp8_;
	if (!_tmp9_) {
		_g_object_unref0 (list_store);
		__vala_GtkTreePath_free0 (path);
		return;
	}
	key = NULL;
	_tmp10_ = list_store;
	_tmp11_ = it;
	gtk_tree_model_get ((GtkTreeModel*) _tmp10_, &_tmp11_, 0, &key, -1);
	_tmp12_ = key;
	if (_tmp12_ == NULL) {
		_g_free0 (key);
		_g_object_unref0 (list_store);
		__vala_GtkTreePath_free0 (path);
		return;
	}
	_tmp13_ = list_store;
	_tmp14_ = it;
	gtk_list_store_set (_tmp13_, &_tmp14_, 2, 0, -1);
	_tmp15_ = self->priv->worm_settings;
	_tmp16_ = id;
	_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_);
	_tmp18_ = (GSettings*) _tmp17_;
	_tmp19_ = key;
	g_settings_set_int (_tmp18_, _tmp19_, 0);
	_g_object_unref0 (_tmp18_);
	_g_free0 (key);
	_g_object_unref0 (list_store);
	__vala_GtkTreePath_free0 (path);
}


static void
preferences_dialog_combo_box_changed_cb (PreferencesDialog* self,
                                         GtkComboBox* combo_box)
{
	gint id = 0;
	GeeArrayList* _tmp0_;
	gint color_new = 0;
	gint color_old = 0;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gpointer _tmp3_;
	GSettings* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GeeArrayList* _tmp42_;
	gint _tmp43_;
	gpointer _tmp44_;
	GSettings* _tmp45_;
	gint _tmp46_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo_box != NULL);
	_tmp0_ = self->priv->combo_boxes;
	id = gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (combo_box, gtk_combo_box_text_get_type (), GtkComboBoxText));
	color_new = gtk_combo_box_get_active (combo_box);
	_tmp1_ = self->priv->worm_settings;
	_tmp2_ = id;
	_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _tmp1_, _tmp2_);
	_tmp4_ = (GSettings*) _tmp3_;
	_tmp5_ = g_settings_get_enum (_tmp4_, "color");
	_g_object_unref0 (_tmp4_);
	color_old = _tmp5_;
	_tmp6_ = color_new;
	_tmp7_ = color_old;
	if (_tmp6_ == _tmp7_) {
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint _tmp10_;
				gboolean _tmp11_ = FALSE;
				gint _tmp12_;
				gint _tmp13_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = i;
				if (!(_tmp10_ < NIBBLES_GAME_MAX_WORMS)) {
					break;
				}
				_tmp12_ = i;
				_tmp13_ = id;
				if (_tmp12_ != _tmp13_) {
					GeeArrayList* _tmp14_;
					gint _tmp15_;
					gpointer _tmp16_;
					GSettings* _tmp17_;
					gint _tmp18_;
					_tmp14_ = self->priv->worm_settings;
					_tmp15_ = i;
					_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _tmp15_);
					_tmp17_ = (GSettings*) _tmp16_;
					_tmp18_ = color_new;
					_tmp11_ = g_settings_get_enum (_tmp17_, "color") == _tmp18_;
					_g_object_unref0 (_tmp17_);
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					GeeArrayList* _tmp19_;
					gint _tmp20_;
					gpointer _tmp21_;
					GSettings* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					_tmp19_ = self->priv->worm_settings;
					_tmp20_ = i;
					_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _tmp20_);
					_tmp22_ = (GSettings*) _tmp21_;
					_tmp23_ = color_old;
					g_settings_set_enum (_tmp22_, "color", _tmp23_);
					_g_object_unref0 (_tmp22_);
					_tmp24_ = i;
					if (_tmp24_ < NIBBLES_GAME_MAX_HUMANS) {
						{
							GeeArrayList* _cbox_list = NULL;
							GeeArrayList* _tmp25_;
							GeeArrayList* _tmp26_;
							gint _cbox_size = 0;
							GeeArrayList* _tmp27_;
							gint _tmp28_;
							gint _tmp29_;
							gint _cbox_index = 0;
							_tmp25_ = self->priv->combo_boxes;
							_tmp26_ = _g_object_ref0 (_tmp25_);
							_cbox_list = _tmp26_;
							_tmp27_ = _cbox_list;
							_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp27_);
							_tmp29_ = _tmp28_;
							_cbox_size = _tmp29_;
							_cbox_index = -1;
							while (TRUE) {
								gint _tmp30_;
								gint _tmp31_;
								gint _tmp32_;
								GtkComboBoxText* cbox = NULL;
								GeeArrayList* _tmp33_;
								gint _tmp34_;
								gpointer _tmp35_;
								gint index = 0;
								GeeArrayList* _tmp36_;
								GtkComboBoxText* _tmp37_;
								gint _tmp38_;
								gint _tmp39_;
								_tmp30_ = _cbox_index;
								_cbox_index = _tmp30_ + 1;
								_tmp31_ = _cbox_index;
								_tmp32_ = _cbox_size;
								if (!(_tmp31_ < _tmp32_)) {
									break;
								}
								_tmp33_ = _cbox_list;
								_tmp34_ = _cbox_index;
								_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, _tmp34_);
								cbox = (GtkComboBoxText*) _tmp35_;
								_tmp36_ = self->priv->combo_boxes;
								_tmp37_ = cbox;
								index = gee_abstract_list_index_of ((GeeAbstractList*) _tmp36_, _tmp37_);
								_tmp38_ = index;
								_tmp39_ = i;
								if (_tmp38_ == _tmp39_) {
									GtkComboBoxText* _tmp40_;
									gint _tmp41_;
									_tmp40_ = cbox;
									_tmp41_ = color_old;
									gtk_combo_box_set_active ((GtkComboBox*) _tmp40_, _tmp41_);
									_g_object_unref0 (cbox);
									break;
								}
								_g_object_unref0 (cbox);
							}
							_g_object_unref0 (_cbox_list);
						}
					}
					break;
				}
			}
		}
	}
	_tmp42_ = self->priv->worm_settings;
	_tmp43_ = id;
	_tmp44_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, _tmp43_);
	_tmp45_ = (GSettings*) _tmp44_;
	_tmp46_ = color_new;
	g_settings_set_enum (_tmp45_, "color", _tmp46_);
	_g_object_unref0 (_tmp45_);
}


static void
preferences_dialog_class_init (PreferencesDialogClass * klass)
{
	gint PreferencesDialog_private_offset;
	preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PreferencesDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = preferences_dialog_finalize;
	PreferencesDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/preferences-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "notebook", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, notebook));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "beginner_radio_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, beginner_radio_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "slow_radio_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, slow_radio_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "medium_radio_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, medium_radio_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fast_radio_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, fast_radio_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "sound_check_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, sound_check_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fakes_check_button", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, fakes_check_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_store_1", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, list_store_1));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_store_2", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, list_store_2));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_store_3", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, list_store_3));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_store_4", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, list_store_4));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tree_view_1", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, tree_view_1));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tree_view_2", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, tree_view_2));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tree_view_3", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, tree_view_3));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tree_view_4", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, tree_view_4));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "combo_box_1", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, combo_box_1));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "combo_box_2", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, combo_box_2));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "combo_box_3", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, combo_box_3));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "combo_box_4", FALSE, PreferencesDialog_private_offset + G_STRUCT_OFFSET (PreferencesDialogPrivate, combo_box_4));
}


static void
preferences_dialog_instance_init (PreferencesDialog * self)
{
	self->priv = PREFERENCES_DIALOG_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void
preferences_dialog_finalize (GObject * obj)
{
	PreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREFERENCES_DIALOG, PreferencesDialog);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->worm_settings);
	_g_object_unref0 (self->priv->notebook);
	_g_object_unref0 (self->priv->beginner_radio_button);
	_g_object_unref0 (self->priv->slow_radio_button);
	_g_object_unref0 (self->priv->medium_radio_button);
	_g_object_unref0 (self->priv->fast_radio_button);
	_g_object_unref0 (self->priv->sound_check_button);
	_g_object_unref0 (self->priv->fakes_check_button);
	_g_object_unref0 (self->priv->list_store_1);
	_g_object_unref0 (self->priv->list_store_2);
	_g_object_unref0 (self->priv->list_store_3);
	_g_object_unref0 (self->priv->list_store_4);
	_g_object_unref0 (self->priv->tree_view_1);
	_g_object_unref0 (self->priv->tree_view_2);
	_g_object_unref0 (self->priv->tree_view_3);
	_g_object_unref0 (self->priv->tree_view_4);
	_g_object_unref0 (self->priv->combo_box_1);
	_g_object_unref0 (self->priv->combo_box_2);
	_g_object_unref0 (self->priv->combo_box_3);
	_g_object_unref0 (self->priv->combo_box_4);
	_g_object_unref0 (self->priv->radio_buttons);
	_g_object_unref0 (self->priv->list_stores);
	_g_object_unref0 (self->priv->tree_views);
	_g_object_unref0 (self->priv->combo_boxes);
	G_OBJECT_CLASS (preferences_dialog_parent_class)->finalize (obj);
}


GType
preferences_dialog_get_type (void)
{
	static volatile gsize preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialog), 0, (GInstanceInitFunc) preferences_dialog_instance_init, NULL };
		GType preferences_dialog_type_id;
		preferences_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "PreferencesDialog", &g_define_type_info, 0);
		g_once_init_leave (&preferences_dialog_type_id__volatile, preferences_dialog_type_id);
	}
	return preferences_dialog_type_id__volatile;
}



