/* nibbles-game.c generated by valac 0.31.1.12-d87fb, the Vala compiler
 * generated from nibbles-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* This is a fairly literal translation of the GPLv2+ original by*/
/* Sean MacIsaac, Ian Peters, Guillaume Béland.*/

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <time.h>
#include <string.h>


#define TYPE_GAME_STATUS (game_status_get_type ())

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
typedef struct _NibblesGamePrivate NibblesGamePrivate;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_BONI (boni_get_type ())
#define BONI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONI, Boni))
#define BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONI, BoniClass))
#define IS_BONI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONI))
#define IS_BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONI))
#define BONI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONI, BoniClass))

typedef struct _Boni Boni;
typedef struct _BoniClass BoniClass;

#define TYPE_WARP_MANAGER (warp_manager_get_type ())
#define WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP_MANAGER, WarpManager))
#define WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP_MANAGER, WarpManagerClass))
#define IS_WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP_MANAGER))
#define IS_WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP_MANAGER))
#define WARP_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP_MANAGER, WarpManagerClass))

typedef struct _WarpManager WarpManager;
typedef struct _WarpManagerClass WarpManagerClass;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
typedef struct _WormProperties WormProperties;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef struct _WormPrivate WormPrivate;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())
typedef struct _BoniPrivate BoniPrivate;

#define TYPE_BONUS (bonus_get_type ())
#define BONUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONUS, Bonus))
#define BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONUS, BonusClass))
#define IS_BONUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONUS))
#define IS_BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONUS))
#define BONUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONUS, BonusClass))

typedef struct _Bonus Bonus;
typedef struct _BonusClass BonusClass;
typedef struct _BonusPrivate BonusPrivate;

#define TYPE_BONUS_TYPE (bonus_type_get_type ())

#define TYPE_POSITION (position_get_type ())
typedef struct _Position Position;

#define TYPE_WARP (warp_get_type ())
#define WARP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP, Warp))
#define WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP, WarpClass))
#define IS_WARP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP))
#define IS_WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP))
#define WARP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP, WarpClass))

typedef struct _Warp Warp;
typedef struct _WarpClass WarpClass;

typedef enum  {
	GAME_STATUS_GAMEOVER,
	GAME_STATUS_VICTORY,
	GAME_STATUS_NEWROUND
} GameStatus;

struct _NibblesGame {
	GObject parent_instance;
	NibblesGamePrivate * priv;
	gint* board;
	gint board_length1;
	gint board_length2;
};

struct _NibblesGameClass {
	GObjectClass parent_class;
};

struct _WormProperties {
	gint color;
	guint up;
	guint down;
	guint left;
	guint right;
};

struct _NibblesGamePrivate {
	gint _start_level;
	gint _current_level;
	gint _speed;
	gint _tile_size;
	gint _numhumans;
	gint _numai;
	gint _numworms;
	GeeLinkedList* _worms;
	Boni* _boni;
	WarpManager* _warp_manager;
	GeeHashMap* _worm_props;
	gboolean _is_running;
	gboolean _is_paused;
	guint main_id;
	guint add_bonus_id;
	gboolean _fakes;
};

typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP
} WormDirection;

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gboolean is_stopped;
	gint change;
	WormDirection direction;
	WormDirection starting_direction;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _Boni {
	GObject parent_instance;
	BoniPrivate * priv;
	GeeLinkedList* bonuses;
	gint missed;
	gint numleft;
	gint numboni;
	gint numbonuses;
};

struct _BoniClass {
	GObjectClass parent_class;
};

typedef enum  {
	BONUS_TYPE_REGULAR,
	BONUS_TYPE_HALF,
	BONUS_TYPE_DOUBLE,
	BONUS_TYPE_LIFE,
	BONUS_TYPE_REVERSE,
	BONUS_TYPE_WARP
} BonusType;

struct _Bonus {
	GObject parent_instance;
	BonusPrivate * priv;
	gint x;
	gint y;
	BonusType type;
	gboolean fake;
	gint countdown;
};

struct _BonusClass {
	GObjectClass parent_class;
};

struct _Position {
	gint x;
	gint y;
};


static gpointer nibbles_game_parent_class = NULL;

GType game_status_get_type (void) G_GNUC_CONST;
GType nibbles_game_get_type (void) G_GNUC_CONST;
GType worm_get_type (void) G_GNUC_CONST;
GType boni_get_type (void) G_GNUC_CONST;
GType warp_manager_get_type (void) G_GNUC_CONST;
GType worm_properties_get_type (void) G_GNUC_CONST;
WormProperties* worm_properties_dup (const WormProperties* self);
void worm_properties_free (WormProperties* self);
#define NIBBLES_GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NIBBLES_GAME, NibblesGamePrivate))
enum  {
	NIBBLES_GAME_DUMMY_PROPERTY,
	NIBBLES_GAME_START_LEVEL,
	NIBBLES_GAME_CURRENT_LEVEL,
	NIBBLES_GAME_SPEED,
	NIBBLES_GAME_TILE_SIZE,
	NIBBLES_GAME_NUMHUMANS,
	NIBBLES_GAME_NUMAI,
	NIBBLES_GAME_NUMWORMS,
	NIBBLES_GAME_WORMS,
	NIBBLES_GAME_BONI,
	NIBBLES_GAME_WARP_MANAGER,
	NIBBLES_GAME_WORM_PROPS,
	NIBBLES_GAME_IS_RUNNING,
	NIBBLES_GAME_IS_PAUSED,
	NIBBLES_GAME_FAKES
};
#define NIBBLES_GAME_MINIMUM_TILE_SIZE 7
#define NIBBLES_GAME_GAMEDELAY 35
#define NIBBLES_GAME_BONUSDELAY 100
#define NIBBLES_GAME_MAX_HUMANS 4
#define NIBBLES_GAME_MAX_AI 5
#define NIBBLES_GAME_MAX_WORMS 6
#define NIBBLES_GAME_MAX_SPEED 4
#define NIBBLES_GAME_WIDTH 92
#define NIBBLES_GAME_HEIGHT 66
#define NIBBLES_GAME_CAPACITY (NIBBLES_GAME_WIDTH * NIBBLES_GAME_HEIGHT)
#define NIBBLES_GAME_EMPTYCHAR 'a'
#define NIBBLES_GAME_WORMCHAR 'w'
#define NIBBLES_GAME_WARPCHAR 'W'
#define NIBBLES_GAME_MAX_LEVEL 26
NibblesGame* nibbles_game_new (GSettings* settings);
NibblesGame* nibbles_game_construct (GType object_type, GSettings* settings);
gint nibbles_game_get_numworms (NibblesGame* self);
Boni* boni_new (gint numworms);
Boni* boni_construct (GType object_type, gint numworms);
static void nibbles_game_set_boni (NibblesGame* self, Boni* value);
WarpManager* warp_manager_new (void);
WarpManager* warp_manager_construct (GType object_type);
static void nibbles_game_set_warp_manager (NibblesGame* self, WarpManager* value);
static void nibbles_game_set_worms (NibblesGame* self, GeeLinkedList* value);
static void nibbles_game_set_worm_props (NibblesGame* self, GeeHashMap* value);
static void nibbles_game_set_is_paused (NibblesGame* self, gboolean value);
void nibbles_game_load_properties (NibblesGame* self, GSettings* settings);
gint nibbles_game_get_start_level (NibblesGame* self);
static void nibbles_game_set_current_level (NibblesGame* self, gint value);
void nibbles_game_start (NibblesGame* self);
static void nibbles_game_set_is_running (NibblesGame* self, gboolean value);
gint nibbles_game_get_speed (NibblesGame* self);
gboolean nibbles_game_main_loop_cb (NibblesGame* self);
static gboolean _nibbles_game_main_loop_cb_gsource_func (gpointer self);
gboolean nibbles_game_add_bonus_cb (NibblesGame* self);
static gboolean _nibbles_game_add_bonus_cb_gsource_func (gpointer self);
void nibbles_game_stop (NibblesGame* self);
void nibbles_game_pause (NibblesGame* self);
void nibbles_game_unpause (NibblesGame* self);
void nibbles_game_reset (NibblesGame* self);
static void nibbles_game_end (NibblesGame* self);
GameStatus* nibbles_game_get_game_status (NibblesGame* self);
static gboolean _game_status_equal (const GameStatus* s1, const GameStatus* s2);
GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
gint worm_get_score (Worm* self);
gint nibbles_game_get_current_level (NibblesGame* self);
Worm* nibbles_game_get_winner (NibblesGame* self);
void nibbles_game_move_worms (NibblesGame* self);
void nibbles_game_create_worms (NibblesGame* self);
gint nibbles_game_get_numai (NibblesGame* self);
gint nibbles_game_get_numhumans (NibblesGame* self);
static void nibbles_game_set_numworms (NibblesGame* self, gint value);
Worm* worm_new (gint id);
Worm* worm_construct (GType object_type, gint id);
void nibbles_game_bonus_found_cb (NibblesGame* self, Worm* worm);
static void _nibbles_game_bonus_found_cb_worm_bonus_found (Worm* _sender, gpointer self);
void nibbles_game_warp_found_cb (NibblesGame* self, Worm* worm);
static void _nibbles_game_warp_found_cb_worm_warp_found (Worm* _sender, gpointer self);
GType worm_direction_get_type (void) G_GNUC_CONST;
void nibbles_game_add_worms (NibblesGame* self);
void worm_spawn (Worm* self, gint* board, int board_length1, int board_length2);
Boni* nibbles_game_get_boni (NibblesGame* self);
GType bonus_get_type (void) G_GNUC_CONST;
#define BONI_MAX_MISSED 2
void worm_set_score (Worm* self, gint value);
GType bonus_type_get_type (void) G_GNUC_CONST;
void boni_remove_bonus (Boni* self, gint* board, int board_length1, int board_length2, Bonus* bonus);
void nibbles_game_add_bonus (NibblesGame* self, gboolean regular);
GType position_get_type (void) G_GNUC_CONST;
Position* position_dup (const Position* self);
void position_free (Position* self);
GeeLinkedList* worm_get_list (Worm* self);
void worm_ai_move (Worm* self, gint* board, int board_length1, int board_length2, gint numworms, GeeLinkedList* worms);
gboolean worm_will_collide_with_head (Worm* self, Worm* other_worm);
gboolean worm_can_move_to (Worm* self, gint* board, int board_length1, int board_length2, gint numworms);
void worm_move (Worm* self, gint* board, int board_length1, int board_length2);
gint worm_get_lives (Worm* self);
void worm_reset (Worm* self, gint* board, int board_length1, int board_length2);
static void nibbles_game_reverse_worms (NibblesGame* self, Worm* worm);
void worm_reverse (Worm* self, gint* board, int board_length1, int board_length2);
gboolean nibbles_game_get_fakes (NibblesGame* self);
void boni_add_bonus (Boni* self, gint* board, int board_length1, int board_length2, gint x, gint y, BonusType type, gboolean fake, gint countdown);
void nibbles_game_apply_bonus (NibblesGame* self, Bonus* bonus, Worm* worm);
void worm_get_head (Worm* self, Position* result);
#define WORM_GROW_FACTOR 4
gint worm_get_length (Worm* self);
void worm_reduce_tail (Worm* self, gint* board, int board_length1, int board_length2, gint erase_size);
void worm_add_life (Worm* self);
Bonus* boni_get_bonus (Boni* self, gint* board, int board_length1, int board_length2, gint x, gint y);
GType warp_get_type (void) G_GNUC_CONST;
WarpManager* nibbles_game_get_warp_manager (NibblesGame* self);
Warp* warp_manager_get_warp (WarpManager* self, gint x, gint y);
void worm_warp (Worm* self, Warp* warp);
static GameStatus* _game_status_dup (GameStatus* self);
void nibbles_game_set_tile_size (NibblesGame* self, gint value);
static void nibbles_game_set_start_level (NibblesGame* self, gint value);
void nibbles_game_set_speed (NibblesGame* self, gint value);
void nibbles_game_set_fakes (NibblesGame* self, gboolean value);
void nibbles_game_save_properties (NibblesGame* self, GSettings* settings);
gint nibbles_game_get_tile_size (NibblesGame* self);
void nibbles_game_load_worm_properties (NibblesGame* self, GeeArrayList* worm_settings);
GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
gint worm_get_id (Worm* self);
gboolean nibbles_game_handle_keypress (NibblesGame* self, guint keyval);
gboolean nibbles_game_get_is_running (NibblesGame* self);
gboolean worm_handle_keypress (Worm* self, guint keyval, GeeHashMap* worm_props);
void nibbles_game_set_numhumans (NibblesGame* self, gint value);
void nibbles_game_set_numai (NibblesGame* self, gint value);
gboolean nibbles_game_get_is_paused (NibblesGame* self);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void nibbles_game_finalize (GObject* obj);
static void _vala_nibbles_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_nibbles_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType game_status_get_type (void) {
	static volatile gsize game_status_type_id__volatile = 0;
	if (g_once_init_enter (&game_status_type_id__volatile)) {
		static const GEnumValue values[] = {{GAME_STATUS_GAMEOVER, "GAME_STATUS_GAMEOVER", "gameover"}, {GAME_STATUS_VICTORY, "GAME_STATUS_VICTORY", "victory"}, {GAME_STATUS_NEWROUND, "GAME_STATUS_NEWROUND", "newround"}, {0, NULL, NULL}};
		GType game_status_type_id;
		game_status_type_id = g_enum_register_static ("GameStatus", values);
		g_once_init_leave (&game_status_type_id__volatile, game_status_type_id);
	}
	return game_status_type_id__volatile;
}


NibblesGame* nibbles_game_construct (GType object_type, GSettings* settings) {
	NibblesGame * self = NULL;
	gint _tmp0_ = 0;
	Boni* _tmp1_ = NULL;
	Boni* _tmp2_ = NULL;
	WarpManager* _tmp3_ = NULL;
	WarpManager* _tmp4_ = NULL;
	gint* _tmp5_ = NULL;
	GeeLinkedList* _tmp6_ = NULL;
	GeeLinkedList* _tmp7_ = NULL;
	GeeHashMap* _tmp8_ = NULL;
	GeeHashMap* _tmp9_ = NULL;
	time_t _tmp10_ = 0;
	GSettings* _tmp11_ = NULL;
	gint _tmp12_ = 0;
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (settings != NULL, NULL);
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self = (NibblesGame*) g_object_new (object_type, NULL);
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_numworms;
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp1_ = boni_new (_tmp0_);
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp2_ = _tmp1_;
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_set_boni (self, _tmp2_);
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_g_object_unref0 (_tmp2_);
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp3_ = warp_manager_new ();
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp4_ = _tmp3_;
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_set_warp_manager (self, _tmp4_);
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_g_object_unref0 (_tmp4_);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp5_ = g_new0 (gint, NIBBLES_GAME_WIDTH * NIBBLES_GAME_HEIGHT);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->board = (g_free (self->board), NULL);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->board = _tmp5_;
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->board_length1 = NIBBLES_GAME_WIDTH;
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->board_length2 = NIBBLES_GAME_HEIGHT;
#line 91 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp6_ = gee_linked_list_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 91 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp7_ = _tmp6_;
#line 91 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_set_worms (self, _tmp7_);
#line 91 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_g_object_unref0 (_tmp7_);
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp8_ = gee_hash_map_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, g_object_unref, TYPE_WORM_PROPERTIES, (GBoxedCopyFunc) worm_properties_dup, worm_properties_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp9_ = _tmp8_;
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_set_worm_props (self, _tmp9_);
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_g_object_unref0 (_tmp9_);
#line 94 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_set_is_paused (self, FALSE);
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp10_ = time (NULL);
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_random_set_seed ((guint32) _tmp10_);
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp11_ = settings;
#line 97 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_load_properties (self, _tmp11_);
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp12_ = self->priv->_start_level;
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_set_current_level (self, _tmp12_);
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return self;
#line 457 "nibbles-game.c"
}


NibblesGame* nibbles_game_new (GSettings* settings) {
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return nibbles_game_construct (TYPE_NIBBLES_GAME, settings);
#line 464 "nibbles-game.c"
}


static gboolean _nibbles_game_main_loop_cb_gsource_func (gpointer self) {
	gboolean result;
	result = nibbles_game_main_loop_cb ((NibblesGame*) self);
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 473 "nibbles-game.c"
}


static gboolean _nibbles_game_add_bonus_cb_gsource_func (gpointer self) {
	gboolean result;
	result = nibbles_game_add_bonus_cb ((NibblesGame*) self);
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 482 "nibbles-game.c"
}


void nibbles_game_start (NibblesGame* self) {
	gint _tmp0_ = 0;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	gint _tmp3_ = 0;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_set_is_running (self, TRUE);
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_speed;
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (NIBBLES_GAME_GAMEDELAY * _tmp0_), _nibbles_game_main_loop_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv->main_id = _tmp1_;
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp2_ = self->priv->main_id;
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_source_set_name_by_id (_tmp2_, "[Nibbles] main_loop_cb");
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp3_ = self->priv->_speed;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp4_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (NIBBLES_GAME_BONUSDELAY * _tmp3_), _nibbles_game_add_bonus_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv->add_bonus_id = _tmp4_;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp5_ = self->priv->add_bonus_id;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_source_set_name_by_id (_tmp5_, "[Nibbles] add_bonus_cb");
#line 517 "nibbles-game.c"
}


void nibbles_game_stop (NibblesGame* self) {
	guint _tmp0_ = 0U;
	guint _tmp2_ = 0U;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_set_is_running (self, FALSE);
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->main_id;
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 532 "nibbles-game.c"
		guint _tmp1_ = 0U;
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp1_ = self->priv->main_id;
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		g_source_remove (_tmp1_);
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		self->priv->main_id = (guint) 0;
#line 540 "nibbles-game.c"
	}
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp2_ = self->priv->add_bonus_id;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (_tmp2_ != ((guint) 0)) {
#line 546 "nibbles-game.c"
		guint _tmp3_ = 0U;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp3_ = self->priv->add_bonus_id;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		g_source_remove (_tmp3_);
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		self->priv->add_bonus_id = (guint) 0;
#line 554 "nibbles-game.c"
	}
}


void nibbles_game_pause (NibblesGame* self) {
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_set_is_paused (self, TRUE);
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_stop (self);
#line 566 "nibbles-game.c"
}


void nibbles_game_unpause (NibblesGame* self) {
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_set_is_paused (self, FALSE);
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_start (self);
#line 577 "nibbles-game.c"
}


void nibbles_game_reset (NibblesGame* self) {
	gint _tmp0_ = 0;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_start_level;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_set_current_level (self, _tmp0_);
#line 589 "nibbles-game.c"
}


static void nibbles_game_end (NibblesGame* self) {
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_stop (self);
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_signal_emit_by_name (self, "animate-end-game");
#line 600 "nibbles-game.c"
}


static gboolean _game_status_equal (const GameStatus* s1, const GameStatus* s2) {
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (s1 == s2) {
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		return TRUE;
#line 609 "nibbles-game.c"
	}
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (s1 == NULL) {
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		return FALSE;
#line 615 "nibbles-game.c"
	}
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (s2 == NULL) {
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		return FALSE;
#line 621 "nibbles-game.c"
	}
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return (*s1) == (*s2);
#line 625 "nibbles-game.c"
}


gboolean nibbles_game_main_loop_cb (NibblesGame* self) {
	gboolean result = FALSE;
	GameStatus* status = NULL;
	GameStatus* _tmp0_ = NULL;
	GameStatus* _tmp1_ = NULL;
	GameStatus _tmp2_ = 0;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = nibbles_game_get_game_status (self);
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	status = _tmp0_;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp1_ = status;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp2_ = GAME_STATUS_GAMEOVER;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (_game_status_equal (_tmp1_, &_tmp2_) == TRUE) {
#line 647 "nibbles-game.c"
		GeeLinkedList* _tmp3_ = NULL;
		gpointer _tmp4_ = NULL;
		Worm* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		nibbles_game_end (self);
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp3_ = self->priv->_worms;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp4_ = gee_linked_list_first (_tmp3_);
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp5_ = (Worm*) _tmp4_;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp6_ = worm_get_score (_tmp5_);
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp7_ = _tmp6_;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp8_ = self->priv->_current_level;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		g_signal_emit_by_name (self, "log-score", _tmp7_, _tmp8_);
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_g_object_unref0 (_tmp5_);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		result = G_SOURCE_REMOVE;
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_g_free0 (status);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		return result;
#line 678 "nibbles-game.c"
	} else {
		GameStatus* _tmp9_ = NULL;
		GameStatus _tmp10_ = 0;
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp9_ = status;
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp10_ = GAME_STATUS_VICTORY;
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		if (_game_status_equal (_tmp9_, &_tmp10_) == TRUE) {
#line 688 "nibbles-game.c"
			Worm* winner = NULL;
			Worm* _tmp11_ = NULL;
			Worm* _tmp12_ = NULL;
			Worm* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			nibbles_game_end (self);
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp11_ = nibbles_game_get_winner (self);
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			winner = _tmp11_;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp12_ = winner;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp12_ == NULL) {
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				result = G_SOURCE_REMOVE;
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_g_object_unref0 (winner);
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_g_free0 (status);
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				return result;
#line 714 "nibbles-game.c"
			}
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp13_ = winner;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp14_ = worm_get_score (_tmp13_);
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp15_ = _tmp14_;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp16_ = self->priv->_current_level;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			g_signal_emit_by_name (self, "log-score", _tmp15_, _tmp16_);
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			result = G_SOURCE_REMOVE;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_g_object_unref0 (winner);
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_g_free0 (status);
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			return result;
#line 734 "nibbles-game.c"
		} else {
			GameStatus* _tmp17_ = NULL;
			GameStatus _tmp18_ = 0;
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp17_ = status;
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp18_ = GAME_STATUS_NEWROUND;
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_game_status_equal (_tmp17_, &_tmp18_) == TRUE) {
#line 744 "nibbles-game.c"
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				nibbles_game_stop (self);
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				g_signal_emit_by_name (self, "animate-end-game");
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				g_signal_emit_by_name (self, "level-completed");
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp19_ = self->priv->_current_level;
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				nibbles_game_set_current_level (self, _tmp19_ + 1);
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp20_ = self->priv->_current_level;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				if (_tmp20_ == (NIBBLES_GAME_MAX_LEVEL + 1)) {
#line 761 "nibbles-game.c"
					GeeLinkedList* _tmp21_ = NULL;
					gpointer _tmp22_ = NULL;
					Worm* _tmp23_ = NULL;
					gint _tmp24_ = 0;
					gint _tmp25_ = 0;
					gint _tmp26_ = 0;
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp21_ = self->priv->_worms;
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp22_ = gee_linked_list_first (_tmp21_);
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp23_ = (Worm*) _tmp22_;
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp24_ = worm_get_score (_tmp23_);
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp25_ = _tmp24_;
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp26_ = self->priv->_current_level;
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					g_signal_emit_by_name (self, "log-score", _tmp25_, _tmp26_);
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_g_object_unref0 (_tmp23_);
#line 784 "nibbles-game.c"
				}
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				result = G_SOURCE_REMOVE;
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_g_free0 (status);
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				return result;
#line 792 "nibbles-game.c"
			}
		}
	}
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_move_worms (self);
#line 196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	result = G_SOURCE_CONTINUE;
#line 196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_g_free0 (status);
#line 196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 804 "nibbles-game.c"
}


static void _nibbles_game_bonus_found_cb_worm_bonus_found (Worm* _sender, gpointer self) {
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_bonus_found_cb ((NibblesGame*) self, _sender);
#line 811 "nibbles-game.c"
}


static void _nibbles_game_warp_found_cb_worm_warp_found (Worm* _sender, gpointer self) {
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_warp_found_cb ((NibblesGame*) self, _sender);
#line 818 "nibbles-game.c"
}


void nibbles_game_create_worms (NibblesGame* self) {
	GeeLinkedList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 203 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_worms;
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp1_ = self->priv->_numai;
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp2_ = self->priv->_numhumans;
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_set_numworms (self, _tmp1_ + _tmp2_);
#line 838 "nibbles-game.c"
	{
		gint i = 0;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		i = 0;
#line 843 "nibbles-game.c"
		{
			gboolean _tmp3_ = FALSE;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp3_ = TRUE;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			while (TRUE) {
#line 850 "nibbles-game.c"
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				Worm* worm = NULL;
				gint _tmp7_ = 0;
				Worm* _tmp8_ = NULL;
				Worm* _tmp9_ = NULL;
				Worm* _tmp10_ = NULL;
				Worm* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				GeeLinkedList* _tmp14_ = NULL;
				Worm* _tmp15_ = NULL;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				if (!_tmp3_) {
#line 865 "nibbles-game.c"
					gint _tmp4_ = 0;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp4_ = i;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					i = _tmp4_ + 1;
#line 871 "nibbles-game.c"
				}
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp3_ = FALSE;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp5_ = i;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp6_ = self->priv->_numworms;
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					break;
#line 883 "nibbles-game.c"
				}
#line 210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp7_ = i;
#line 210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp8_ = worm_new (_tmp7_);
#line 210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				worm = _tmp8_;
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp9_ = worm;
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				g_signal_connect_object (_tmp9_, "bonus-found", (GCallback) _nibbles_game_bonus_found_cb_worm_bonus_found, self, 0);
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp10_ = worm;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				g_signal_connect_object (_tmp10_, "warp-found", (GCallback) _nibbles_game_warp_found_cb_worm_warp_found, self, 0);
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp11_ = worm;
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp12_ = i;
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp13_ = self->priv->_numhumans;
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp11_->is_human = _tmp12_ < _tmp13_;
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp14_ = self->priv->_worms;
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp15_ = worm;
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp15_);
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_g_object_unref0 (worm);
#line 915 "nibbles-game.c"
			}
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return self ? g_object_ref (self) : NULL;
#line 925 "nibbles-game.c"
}


void nibbles_game_add_worms (NibblesGame* self) {
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 932 "nibbles-game.c"
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _worm_index = 0;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp0_ = self->priv->_worms;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_list = _tmp1_;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp2_ = _worm_list;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp4_ = _tmp3_;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_size = _tmp4_;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_index = -1;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		while (TRUE) {
#line 960 "nibbles-game.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			Worm* _tmp11_ = NULL;
			Worm* _tmp12_ = NULL;
			gint* _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			gint _tmp13__length2 = 0;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp5_ = _worm_index;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_worm_index = _tmp5_ + 1;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp6_ = _worm_index;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp7_ = _worm_size;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				break;
#line 985 "nibbles-game.c"
			}
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp8_ = _worm_list;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp9_ = _worm_index;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			worm = (Worm*) _tmp10_;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp11_ = worm;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			g_signal_emit_by_name (_tmp11_, "added");
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp12_ = worm;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp13_ = self->board;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp13__length1 = self->board_length1;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp13__length2 = self->board_length2;
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			worm_spawn (_tmp12_, _tmp13_, _tmp13__length1, _tmp13__length2);
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_g_object_unref0 (worm);
#line 1011 "nibbles-game.c"
		}
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_g_object_unref0 (_worm_list);
#line 1015 "nibbles-game.c"
	}
}


void nibbles_game_move_worms (NibblesGame* self) {
	Boni* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GeeLinkedList* found = NULL;
	GeeLinkedList* _tmp19_ = NULL;
	Boni* _tmp51_ = NULL;
	GeeLinkedList* _tmp52_ = NULL;
	GeeLinkedList* _tmp53_ = NULL;
	GeeLinkedList* dead_worms = NULL;
	GeeLinkedList* _tmp54_ = NULL;
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_boni;
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp1_ = _tmp0_->missed;
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (_tmp1_ > BONI_MAX_MISSED) {
#line 1038 "nibbles-game.c"
		{
			GeeLinkedList* _worm_list = NULL;
			GeeLinkedList* _tmp2_ = NULL;
			GeeLinkedList* _tmp3_ = NULL;
			gint _worm_size = 0;
			GeeLinkedList* _tmp4_ = NULL;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _worm_index = 0;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp2_ = self->priv->_worms;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp3_ = _g_object_ref0 (_tmp2_);
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_worm_list = _tmp3_;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp4_ = _worm_list;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp6_ = _tmp5_;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_worm_size = _tmp6_;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_worm_index = -1;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			while (TRUE) {
#line 1066 "nibbles-game.c"
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				Worm* worm = NULL;
				GeeLinkedList* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gpointer _tmp12_ = NULL;
				Worm* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp7_ = _worm_index;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_worm_index = _tmp7_ + 1;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp8_ = _worm_index;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp9_ = _worm_size;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				if (!(_tmp8_ < _tmp9_)) {
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					break;
#line 1089 "nibbles-game.c"
				}
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp10_ = _worm_list;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp11_ = _worm_index;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				worm = (Worm*) _tmp12_;
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp13_ = worm;
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp14_ = worm_get_score (_tmp13_);
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp15_ = _tmp14_;
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				if (_tmp15_ > 0) {
#line 1107 "nibbles-game.c"
					Worm* _tmp16_ = NULL;
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp16_ = worm;
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp17_ = worm_get_score (_tmp16_);
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp18_ = _tmp17_;
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					worm_set_score (_tmp16_, _tmp18_ - 1);
#line 1119 "nibbles-game.c"
				}
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_g_object_unref0 (worm);
#line 1123 "nibbles-game.c"
			}
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_g_object_unref0 (_worm_list);
#line 1127 "nibbles-game.c"
		}
	}
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp19_ = gee_linked_list_new (TYPE_BONUS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	found = _tmp19_;
#line 1134 "nibbles-game.c"
	{
		GeeLinkedList* _bonus_list = NULL;
		Boni* _tmp20_ = NULL;
		GeeLinkedList* _tmp21_ = NULL;
		GeeLinkedList* _tmp22_ = NULL;
		gint _bonus_size = 0;
		GeeLinkedList* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gint _bonus_index = 0;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp20_ = self->priv->_boni;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp21_ = _tmp20_->bonuses;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp22_ = _g_object_ref0 (_tmp21_);
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_bonus_list = _tmp22_;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp23_ = _bonus_list;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp24_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp23_);
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp25_ = _tmp24_;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_bonus_size = _tmp25_;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_bonus_index = -1;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		while (TRUE) {
#line 1165 "nibbles-game.c"
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			Bonus* bonus = NULL;
			GeeLinkedList* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gpointer _tmp31_ = NULL;
			Bonus* _tmp32_ = NULL;
			gint _tmp33_ = 0;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp26_ = _bonus_index;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_bonus_index = _tmp26_ + 1;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp27_ = _bonus_index;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp28_ = _bonus_size;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (!(_tmp27_ < _tmp28_)) {
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				break;
#line 1187 "nibbles-game.c"
			}
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp29_ = _bonus_list;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp30_ = _bonus_index;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, _tmp30_);
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			bonus = (Bonus*) _tmp31_;
#line 247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp32_ = bonus;
#line 247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp33_ = _tmp32_->countdown;
#line 247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp32_->countdown = _tmp33_ - 1;
#line 247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp33_ == 0) {
#line 1205 "nibbles-game.c"
				gboolean _tmp34_ = FALSE;
				Bonus* _tmp35_ = NULL;
				BonusType _tmp36_ = 0;
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp35_ = bonus;
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp36_ = _tmp35_->type;
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				if (_tmp36_ == BONUS_TYPE_REGULAR) {
#line 1215 "nibbles-game.c"
					Bonus* _tmp37_ = NULL;
					gboolean _tmp38_ = FALSE;
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp37_ = bonus;
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp38_ = _tmp37_->fake;
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp34_ = !_tmp38_;
#line 1224 "nibbles-game.c"
				} else {
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp34_ = FALSE;
#line 1228 "nibbles-game.c"
				}
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				if (_tmp34_) {
#line 1232 "nibbles-game.c"
					GeeLinkedList* _tmp39_ = NULL;
					Bonus* _tmp40_ = NULL;
					Boni* _tmp41_ = NULL;
					gint* _tmp42_ = NULL;
					gint _tmp42__length1 = 0;
					gint _tmp42__length2 = 0;
					Bonus* _tmp43_ = NULL;
					Boni* _tmp44_ = NULL;
					gint _tmp45_ = 0;
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp39_ = found;
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp40_ = bonus;
#line 251 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp40_);
#line 252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp41_ = self->priv->_boni;
#line 252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp42_ = self->board;
#line 252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp42__length1 = self->board_length1;
#line 252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp42__length2 = self->board_length2;
#line 252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp43_ = bonus;
#line 252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					boni_remove_bonus (_tmp41_, _tmp42_, _tmp42__length1, _tmp42__length2, _tmp43_);
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp44_ = self->priv->_boni;
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp45_ = _tmp44_->missed;
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp44_->missed = _tmp45_ + 1;
#line 255 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					nibbles_game_add_bonus (self, TRUE);
#line 1268 "nibbles-game.c"
				} else {
					GeeLinkedList* _tmp46_ = NULL;
					Bonus* _tmp47_ = NULL;
					Boni* _tmp48_ = NULL;
					gint* _tmp49_ = NULL;
					gint _tmp49__length1 = 0;
					gint _tmp49__length2 = 0;
					Bonus* _tmp50_ = NULL;
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp46_ = found;
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp47_ = bonus;
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, _tmp47_);
#line 260 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp48_ = self->priv->_boni;
#line 260 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp49_ = self->board;
#line 260 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp49__length1 = self->board_length1;
#line 260 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp49__length2 = self->board_length2;
#line 260 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp50_ = bonus;
#line 260 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					boni_remove_bonus (_tmp48_, _tmp49_, _tmp49__length1, _tmp49__length2, _tmp50_);
#line 1295 "nibbles-game.c"
				}
			}
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_g_object_unref0 (bonus);
#line 1300 "nibbles-game.c"
		}
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_g_object_unref0 (_bonus_list);
#line 1304 "nibbles-game.c"
	}
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp51_ = self->priv->_boni;
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp52_ = _tmp51_->bonuses;
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp53_ = found;
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	gee_collection_remove_all ((GeeCollection*) _tmp52_, (GeeCollection*) _tmp53_);
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp54_ = gee_linked_list_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	dead_worms = _tmp54_;
#line 1318 "nibbles-game.c"
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp55_ = NULL;
		GeeLinkedList* _tmp56_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp57_ = NULL;
		gint _tmp58_ = 0;
		gint _tmp59_ = 0;
		gint _worm_index = 0;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp55_ = self->priv->_worms;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp56_ = _g_object_ref0 (_tmp55_);
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_list = _tmp56_;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp57_ = _worm_list;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp58_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp57_);
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp59_ = _tmp58_;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_size = _tmp59_;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_index = -1;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		while (TRUE) {
#line 1346 "nibbles-game.c"
			gint _tmp60_ = 0;
			gint _tmp61_ = 0;
			gint _tmp62_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp63_ = NULL;
			gint _tmp64_ = 0;
			gpointer _tmp65_ = NULL;
			Worm* _tmp66_ = NULL;
			gboolean _tmp67_ = FALSE;
			Worm* _tmp68_ = NULL;
			GeeLinkedList* _tmp69_ = NULL;
			GeeLinkedList* _tmp70_ = NULL;
			gboolean _tmp71_ = FALSE;
			gboolean _tmp72_ = FALSE;
			Worm* _tmp73_ = NULL;
			gboolean _tmp74_ = FALSE;
			Worm* _tmp109_ = NULL;
			gint* _tmp110_ = NULL;
			gint _tmp110__length1 = 0;
			gint _tmp110__length2 = 0;
			gint _tmp111_ = 0;
			gboolean _tmp112_ = FALSE;
			Worm* _tmp115_ = NULL;
			gint* _tmp116_ = NULL;
			gint _tmp116__length1 = 0;
			gint _tmp116__length2 = 0;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp60_ = _worm_index;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_worm_index = _tmp60_ + 1;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp61_ = _worm_index;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp62_ = _worm_size;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (!(_tmp61_ < _tmp62_)) {
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				break;
#line 1385 "nibbles-game.c"
			}
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp63_ = _worm_list;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp64_ = _worm_index;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp65_ = gee_abstract_list_get ((GeeAbstractList*) _tmp63_, _tmp64_);
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			worm = (Worm*) _tmp65_;
#line 270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp66_ = worm;
#line 270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp67_ = _tmp66_->is_stopped;
#line 270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp67_) {
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_g_object_unref0 (worm);
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				continue;
#line 1405 "nibbles-game.c"
			}
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp68_ = worm;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp69_ = worm_get_list (_tmp68_);
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp70_ = _tmp69_;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp71_ = gee_collection_get_is_empty ((GeeCollection*) _tmp70_);
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp72_ = _tmp71_;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp72_) {
#line 274 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_g_object_unref0 (worm);
#line 274 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				continue;
#line 1423 "nibbles-game.c"
			}
#line 276 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp73_ = worm;
#line 276 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp74_ = _tmp73_->is_human;
#line 276 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (!_tmp74_) {
#line 1431 "nibbles-game.c"
				Worm* _tmp75_ = NULL;
				gint* _tmp76_ = NULL;
				gint _tmp76__length1 = 0;
				gint _tmp76__length2 = 0;
				gint _tmp77_ = 0;
				GeeLinkedList* _tmp78_ = NULL;
#line 277 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp75_ = worm;
#line 277 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp76_ = self->board;
#line 277 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp76__length1 = self->board_length1;
#line 277 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp76__length2 = self->board_length2;
#line 277 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp77_ = self->priv->_numworms;
#line 277 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp78_ = self->priv->_worms;
#line 277 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				worm_ai_move (_tmp75_, _tmp76_, _tmp76__length1, _tmp76__length2, _tmp77_, _tmp78_);
#line 1452 "nibbles-game.c"
			}
			{
				GeeLinkedList* _other_worm_list = NULL;
				GeeLinkedList* _tmp79_ = NULL;
				GeeLinkedList* _tmp80_ = NULL;
				gint _other_worm_size = 0;
				GeeLinkedList* _tmp81_ = NULL;
				gint _tmp82_ = 0;
				gint _tmp83_ = 0;
				gint _other_worm_index = 0;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp79_ = self->priv->_worms;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp80_ = _g_object_ref0 (_tmp79_);
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_other_worm_list = _tmp80_;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp81_ = _other_worm_list;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp82_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp81_);
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp83_ = _tmp82_;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_other_worm_size = _tmp83_;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_other_worm_index = -1;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				while (TRUE) {
#line 1481 "nibbles-game.c"
					gint _tmp84_ = 0;
					gint _tmp85_ = 0;
					gint _tmp86_ = 0;
					Worm* other_worm = NULL;
					GeeLinkedList* _tmp87_ = NULL;
					gint _tmp88_ = 0;
					gpointer _tmp89_ = NULL;
					gboolean _tmp90_ = FALSE;
					gboolean _tmp91_ = FALSE;
					Worm* _tmp92_ = NULL;
					Worm* _tmp93_ = NULL;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp84_ = _other_worm_index;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_other_worm_index = _tmp84_ + 1;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp85_ = _other_worm_index;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp86_ = _other_worm_size;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					if (!(_tmp85_ < _tmp86_)) {
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						break;
#line 1505 "nibbles-game.c"
					}
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp87_ = _other_worm_list;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp88_ = _other_worm_index;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp89_ = gee_abstract_list_get ((GeeAbstractList*) _tmp87_, _tmp88_);
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					other_worm = (Worm*) _tmp89_;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp92_ = worm;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp93_ = other_worm;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					if (_tmp92_ != _tmp93_) {
#line 1521 "nibbles-game.c"
						Worm* _tmp94_ = NULL;
						gboolean _tmp95_ = FALSE;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp94_ = other_worm;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp95_ = _tmp94_->is_stopped;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp91_ = !_tmp95_;
#line 1530 "nibbles-game.c"
					} else {
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp91_ = FALSE;
#line 1534 "nibbles-game.c"
					}
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					if (_tmp91_) {
#line 1538 "nibbles-game.c"
						Worm* _tmp96_ = NULL;
						Worm* _tmp97_ = NULL;
						gboolean _tmp98_ = FALSE;
#line 283 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp96_ = worm;
#line 283 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp97_ = other_worm;
#line 283 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp98_ = worm_will_collide_with_head (_tmp96_, _tmp97_);
#line 283 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp90_ = _tmp98_;
#line 1550 "nibbles-game.c"
					} else {
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp90_ = FALSE;
#line 1554 "nibbles-game.c"
					}
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					if (_tmp90_) {
#line 1558 "nibbles-game.c"
						GeeLinkedList* _tmp99_ = NULL;
						Worm* _tmp100_ = NULL;
						gboolean _tmp101_ = FALSE;
						GeeLinkedList* _tmp104_ = NULL;
						Worm* _tmp105_ = NULL;
						gboolean _tmp106_ = FALSE;
#line 285 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp99_ = dead_worms;
#line 285 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp100_ = worm;
#line 285 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp101_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp99_, _tmp100_);
#line 285 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						if (!_tmp101_) {
#line 1573 "nibbles-game.c"
							GeeLinkedList* _tmp102_ = NULL;
							Worm* _tmp103_ = NULL;
#line 286 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
							_tmp102_ = dead_worms;
#line 286 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
							_tmp103_ = worm;
#line 286 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp102_, _tmp103_);
#line 1582 "nibbles-game.c"
						}
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp104_ = dead_worms;
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp105_ = other_worm;
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp106_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp104_, _tmp105_);
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						if (!_tmp106_) {
#line 1592 "nibbles-game.c"
							GeeLinkedList* _tmp107_ = NULL;
							Worm* _tmp108_ = NULL;
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
							_tmp107_ = dead_worms;
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
							_tmp108_ = other_worm;
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp107_, _tmp108_);
#line 1601 "nibbles-game.c"
						}
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_g_object_unref0 (other_worm);
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						continue;
#line 1607 "nibbles-game.c"
					}
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_g_object_unref0 (other_worm);
#line 1611 "nibbles-game.c"
				}
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_g_object_unref0 (_other_worm_list);
#line 1615 "nibbles-game.c"
			}
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp109_ = worm;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp110_ = self->board;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp110__length1 = self->board_length1;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp110__length2 = self->board_length2;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp111_ = self->priv->_numworms;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp112_ = worm_can_move_to (_tmp109_, _tmp110_, _tmp110__length1, _tmp110__length2, _tmp111_);
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (!_tmp112_) {
#line 1631 "nibbles-game.c"
				GeeLinkedList* _tmp113_ = NULL;
				Worm* _tmp114_ = NULL;
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp113_ = dead_worms;
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp114_ = worm;
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp113_, _tmp114_);
#line 296 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_g_object_unref0 (worm);
#line 296 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				continue;
#line 1644 "nibbles-game.c"
			}
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp115_ = worm;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp116_ = self->board;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp116__length1 = self->board_length1;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp116__length2 = self->board_length2;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			worm_move (_tmp115_, _tmp116_, _tmp116__length1, _tmp116__length2);
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_g_object_unref0 (worm);
#line 1658 "nibbles-game.c"
		}
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_g_object_unref0 (_worm_list);
#line 1662 "nibbles-game.c"
	}
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp117_ = NULL;
		GeeLinkedList* _tmp118_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp119_ = NULL;
		gint _tmp120_ = 0;
		gint _tmp121_ = 0;
		gint _worm_index = 0;
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp117_ = dead_worms;
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp118_ = _g_object_ref0 (_tmp117_);
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_list = _tmp118_;
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp119_ = _worm_list;
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp120_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp119_);
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp121_ = _tmp120_;
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_size = _tmp121_;
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_index = -1;
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		while (TRUE) {
#line 1691 "nibbles-game.c"
			gint _tmp122_ = 0;
			gint _tmp123_ = 0;
			gint _tmp124_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp125_ = NULL;
			gint _tmp126_ = 0;
			gpointer _tmp127_ = NULL;
			gint _tmp128_ = 0;
			Worm* _tmp133_ = NULL;
			gint _tmp134_ = 0;
			gint _tmp135_ = 0;
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp122_ = _worm_index;
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_worm_index = _tmp122_ + 1;
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp123_ = _worm_index;
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp124_ = _worm_size;
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (!(_tmp123_ < _tmp124_)) {
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				break;
#line 1715 "nibbles-game.c"
			}
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp125_ = _worm_list;
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp126_ = _worm_index;
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp127_ = gee_abstract_list_get ((GeeAbstractList*) _tmp125_, _tmp126_);
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			worm = (Worm*) _tmp127_;
#line 304 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp128_ = self->priv->_numworms;
#line 304 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp128_ > 1) {
#line 1729 "nibbles-game.c"
				Worm* _tmp129_ = NULL;
				Worm* _tmp130_ = NULL;
				gint _tmp131_ = 0;
				gint _tmp132_ = 0;
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp129_ = worm;
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp130_ = worm;
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp131_ = worm_get_score (_tmp130_);
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp132_ = _tmp131_;
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				worm_set_score (_tmp129_, (_tmp132_ * 7) / 10);
#line 1744 "nibbles-game.c"
			}
#line 307 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp133_ = worm;
#line 307 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp134_ = worm_get_lives (_tmp133_);
#line 307 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp135_ = _tmp134_;
#line 307 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp135_ > 0) {
#line 1754 "nibbles-game.c"
				Worm* _tmp136_ = NULL;
				gint* _tmp137_ = NULL;
				gint _tmp137__length1 = 0;
				gint _tmp137__length2 = 0;
#line 308 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp136_ = worm;
#line 308 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp137_ = self->board;
#line 308 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp137__length1 = self->board_length1;
#line 308 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp137__length2 = self->board_length2;
#line 308 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				worm_reset (_tmp136_, _tmp137_, _tmp137__length1, _tmp137__length2);
#line 1769 "nibbles-game.c"
			}
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_g_object_unref0 (worm);
#line 1773 "nibbles-game.c"
		}
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_g_object_unref0 (_worm_list);
#line 1777 "nibbles-game.c"
	}
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_g_object_unref0 (dead_worms);
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_g_object_unref0 (found);
#line 1783 "nibbles-game.c"
}


static void nibbles_game_reverse_worms (NibblesGame* self, Worm* worm) {
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (worm != NULL);
#line 1792 "nibbles-game.c"
	{
		GeeLinkedList* _other_worm_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _other_worm_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _other_worm_index = 0;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp0_ = self->priv->_worms;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_other_worm_list = _tmp1_;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp2_ = _other_worm_list;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp4_ = _tmp3_;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_other_worm_size = _tmp4_;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_other_worm_index = -1;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		while (TRUE) {
#line 1820 "nibbles-game.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Worm* other_worm = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			Worm* _tmp11_ = NULL;
			Worm* _tmp12_ = NULL;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp5_ = _other_worm_index;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_other_worm_index = _tmp5_ + 1;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp6_ = _other_worm_index;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp7_ = _other_worm_size;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				break;
#line 1842 "nibbles-game.c"
			}
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp8_ = _other_worm_list;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp9_ = _other_worm_index;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			other_worm = (Worm*) _tmp10_;
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp11_ = worm;
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp12_ = other_worm;
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp11_ != _tmp12_) {
#line 1858 "nibbles-game.c"
				Worm* _tmp13_ = NULL;
				gint* _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				gint _tmp14__length2 = 0;
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp13_ = other_worm;
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp14_ = self->board;
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp14__length1 = self->board_length1;
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp14__length2 = self->board_length2;
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				worm_reverse (_tmp13_, _tmp14_, _tmp14__length1, _tmp14__length2);
#line 1873 "nibbles-game.c"
			}
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_g_object_unref0 (other_worm);
#line 1877 "nibbles-game.c"
		}
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_g_object_unref0 (_other_worm_list);
#line 1881 "nibbles-game.c"
	}
}


void nibbles_game_add_bonus (NibblesGame* self, gboolean regular) {
	gboolean good = FALSE;
	gint x = 0;
	gint y = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp22_ = FALSE;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	good = FALSE;
#line 326 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	x = 0;
#line 326 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	y = 0;
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = regular;
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (!_tmp0_) {
#line 1904 "nibbles-game.c"
		gint32 _tmp1_ = 0;
#line 330 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp1_ = g_random_int_range ((gint32) 0, (gint32) 50);
#line 330 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		if (_tmp1_ != ((gint32) 0)) {
#line 331 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			return;
#line 1912 "nibbles-game.c"
		}
	}
	{
		gboolean _tmp2_ = FALSE;
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp2_ = TRUE;
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		while (TRUE) {
#line 1921 "nibbles-game.c"
			gint32 _tmp4_ = 0;
			gint32 _tmp5_ = 0;
			gint* _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			gint _tmp6__length2 = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint* _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			gint _tmp10__length2 = 0;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gint* _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			gint _tmp14__length2 = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			gint* _tmp18_ = NULL;
			gint _tmp18__length1 = 0;
			gint _tmp18__length2 = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (!_tmp2_) {
#line 1950 "nibbles-game.c"
				gboolean _tmp3_ = FALSE;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp3_ = good;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				if (!(!_tmp3_)) {
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					break;
#line 1958 "nibbles-game.c"
				}
			}
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp2_ = FALSE;
#line 336 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			good = TRUE;
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp4_ = g_random_int_range ((gint32) 0, (gint32) (NIBBLES_GAME_WIDTH - 1));
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			x = (gint) _tmp4_;
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp5_ = g_random_int_range ((gint32) 0, (gint32) (NIBBLES_GAME_HEIGHT - 1));
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			y = (gint) _tmp5_;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp6_ = self->board;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp6__length1 = self->board_length1;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp6__length2 = self->board_length2;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp7_ = x;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp8_ = y;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp9_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 341 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				good = FALSE;
#line 1989 "nibbles-game.c"
			}
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp10_ = self->board;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp10__length1 = self->board_length1;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp10__length2 = self->board_length2;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp11_ = x;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp12_ = y;
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp13_ = _tmp10_[((_tmp11_ + 1) * _tmp10__length2) + _tmp12_];
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp13_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				good = FALSE;
#line 2007 "nibbles-game.c"
			}
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp14_ = self->board;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp14__length1 = self->board_length1;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp14__length2 = self->board_length2;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp15_ = x;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp16_ = y;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + (_tmp16_ + 1)];
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp17_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				good = FALSE;
#line 2025 "nibbles-game.c"
			}
#line 346 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp18_ = self->board;
#line 346 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp18__length1 = self->board_length1;
#line 346 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp18__length2 = self->board_length2;
#line 346 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp19_ = x;
#line 346 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp20_ = y;
#line 346 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp21_ = _tmp18_[((_tmp19_ + 1) * _tmp18__length2) + (_tmp20_ + 1)];
#line 346 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp21_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 347 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				good = FALSE;
#line 2043 "nibbles-game.c"
			}
		}
	}
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp22_ = regular;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (_tmp22_) {
#line 2051 "nibbles-game.c"
		gboolean _tmp23_ = FALSE;
		gint32 _tmp24_ = 0;
		Boni* _tmp49_ = NULL;
		gint* _tmp50_ = NULL;
		gint _tmp50__length1 = 0;
		gint _tmp50__length2 = 0;
		gint _tmp51_ = 0;
		gint _tmp52_ = 0;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp24_ = g_random_int_range ((gint32) 0, (gint32) 7);
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		if (_tmp24_ == ((gint32) 0)) {
#line 2064 "nibbles-game.c"
			gboolean _tmp25_ = FALSE;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp25_ = self->priv->_fakes;
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp23_ = _tmp25_;
#line 2070 "nibbles-game.c"
		} else {
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp23_ = FALSE;
#line 2074 "nibbles-game.c"
		}
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		if (_tmp23_) {
#line 2078 "nibbles-game.c"
			Boni* _tmp26_ = NULL;
			gint* _tmp27_ = NULL;
			gint _tmp27__length1 = 0;
			gint _tmp27__length2 = 0;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp26_ = self->priv->_boni;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp27_ = self->board;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp27__length1 = self->board_length1;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp27__length2 = self->board_length2;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp28_ = x;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp29_ = y;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			boni_add_bonus (_tmp26_, _tmp27_, _tmp27__length1, _tmp27__length2, _tmp28_, _tmp29_, BONUS_TYPE_REGULAR, TRUE, 300);
#line 2099 "nibbles-game.c"
		}
#line 355 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		good = FALSE;
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		while (TRUE) {
#line 2105 "nibbles-game.c"
			gboolean _tmp30_ = FALSE;
			gint32 _tmp31_ = 0;
			gint32 _tmp32_ = 0;
			gint* _tmp33_ = NULL;
			gint _tmp33__length1 = 0;
			gint _tmp33__length2 = 0;
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			gint* _tmp37_ = NULL;
			gint _tmp37__length1 = 0;
			gint _tmp37__length2 = 0;
			gint _tmp38_ = 0;
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			gint* _tmp41_ = NULL;
			gint _tmp41__length1 = 0;
			gint _tmp41__length2 = 0;
			gint _tmp42_ = 0;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			gint* _tmp45_ = NULL;
			gint _tmp45__length1 = 0;
			gint _tmp45__length2 = 0;
			gint _tmp46_ = 0;
			gint _tmp47_ = 0;
			gint _tmp48_ = 0;
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp30_ = good;
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (!(!_tmp30_)) {
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				break;
#line 2139 "nibbles-game.c"
			}
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			good = TRUE;
#line 360 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp31_ = g_random_int_range ((gint32) 0, (gint32) (NIBBLES_GAME_WIDTH - 1));
#line 360 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			x = (gint) _tmp31_;
#line 361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp32_ = g_random_int_range ((gint32) 0, (gint32) (NIBBLES_GAME_HEIGHT - 1));
#line 361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			y = (gint) _tmp32_;
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp33_ = self->board;
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp33__length1 = self->board_length1;
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp33__length2 = self->board_length2;
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp34_ = x;
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp35_ = y;
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp36_ = _tmp33_[(_tmp34_ * _tmp33__length2) + _tmp35_];
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp36_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				good = FALSE;
#line 2167 "nibbles-game.c"
			}
#line 364 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp37_ = self->board;
#line 364 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp37__length1 = self->board_length1;
#line 364 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp37__length2 = self->board_length2;
#line 364 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp38_ = x;
#line 364 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp39_ = y;
#line 364 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp40_ = _tmp37_[((_tmp38_ + 1) * _tmp37__length2) + _tmp39_];
#line 364 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp40_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				good = FALSE;
#line 2185 "nibbles-game.c"
			}
#line 366 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp41_ = self->board;
#line 366 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp41__length1 = self->board_length1;
#line 366 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp41__length2 = self->board_length2;
#line 366 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp42_ = x;
#line 366 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp43_ = y;
#line 366 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp44_ = _tmp41_[(_tmp42_ * _tmp41__length2) + (_tmp43_ + 1)];
#line 366 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp44_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 367 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				good = FALSE;
#line 2203 "nibbles-game.c"
			}
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp45_ = self->board;
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp45__length1 = self->board_length1;
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp45__length2 = self->board_length2;
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp46_ = x;
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp47_ = y;
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp48_ = _tmp45_[((_tmp46_ + 1) * _tmp45__length2) + (_tmp47_ + 1)];
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp48_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 369 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				good = FALSE;
#line 2221 "nibbles-game.c"
			}
		}
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp49_ = self->priv->_boni;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp50_ = self->board;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp50__length1 = self->board_length1;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp50__length2 = self->board_length2;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp51_ = x;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp52_ = y;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		boni_add_bonus (_tmp49_, _tmp50_, _tmp50__length1, _tmp50__length2, _tmp51_, _tmp52_, BONUS_TYPE_REGULAR, FALSE, 300);
#line 2238 "nibbles-game.c"
	} else {
		Boni* _tmp53_ = NULL;
		gint _tmp54_ = 0;
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp53_ = self->priv->_boni;
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp54_ = _tmp53_->missed;
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		if (_tmp54_ <= BONI_MAX_MISSED) {
#line 2248 "nibbles-game.c"
			gint32 _tmp55_ = 0;
			gboolean _tmp56_ = FALSE;
			gboolean _tmp57_ = FALSE;
			gint32 _tmp59_ = 0;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp55_ = g_random_int_range ((gint32) 0, (gint32) 7);
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp55_ != ((gint32) 0)) {
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				good = FALSE;
#line 2259 "nibbles-game.c"
			} else {
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				good = TRUE;
#line 2263 "nibbles-game.c"
			}
#line 380 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp57_ = good;
#line 380 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp57_) {
#line 2269 "nibbles-game.c"
				gboolean _tmp58_ = FALSE;
#line 380 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp58_ = self->priv->_fakes;
#line 380 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp56_ = !_tmp58_;
#line 2275 "nibbles-game.c"
			} else {
#line 380 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp56_ = FALSE;
#line 2279 "nibbles-game.c"
			}
#line 380 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp56_) {
#line 381 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				return;
#line 2285 "nibbles-game.c"
			}
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp59_ = g_random_int_range ((gint32) 0, (gint32) 21);
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			switch (_tmp59_) {
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 0:
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 1:
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 2:
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 3:
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 4:
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 5:
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 6:
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 7:
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 8:
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 9:
#line 2311 "nibbles-game.c"
				{
					Boni* _tmp60_ = NULL;
					gint* _tmp61_ = NULL;
					gint _tmp61__length1 = 0;
					gint _tmp61__length2 = 0;
					gint _tmp62_ = 0;
					gint _tmp63_ = 0;
					gboolean _tmp64_ = FALSE;
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp60_ = self->priv->_boni;
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp61_ = self->board;
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp61__length1 = self->board_length1;
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp61__length2 = self->board_length2;
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp62_ = x;
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp63_ = y;
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp64_ = good;
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					boni_add_bonus (_tmp60_, _tmp61_, _tmp61__length1, _tmp61__length2, _tmp62_, _tmp63_, BONUS_TYPE_HALF, _tmp64_, 200);
#line 396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					break;
#line 2338 "nibbles-game.c"
				}
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 10:
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 11:
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 12:
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 13:
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 14:
#line 2350 "nibbles-game.c"
				{
					Boni* _tmp65_ = NULL;
					gint* _tmp66_ = NULL;
					gint _tmp66__length1 = 0;
					gint _tmp66__length2 = 0;
					gint _tmp67_ = 0;
					gint _tmp68_ = 0;
					gboolean _tmp69_ = FALSE;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp65_ = self->priv->_boni;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp66_ = self->board;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp66__length1 = self->board_length1;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp66__length2 = self->board_length2;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp67_ = x;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp68_ = y;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp69_ = good;
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					boni_add_bonus (_tmp65_, _tmp66_, _tmp66__length1, _tmp66__length2, _tmp67_, _tmp68_, BONUS_TYPE_DOUBLE, _tmp69_, 150);
#line 403 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					break;
#line 2377 "nibbles-game.c"
				}
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 15:
#line 2381 "nibbles-game.c"
				{
					Boni* _tmp70_ = NULL;
					gint* _tmp71_ = NULL;
					gint _tmp71__length1 = 0;
					gint _tmp71__length2 = 0;
					gint _tmp72_ = 0;
					gint _tmp73_ = 0;
					gboolean _tmp74_ = FALSE;
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp70_ = self->priv->_boni;
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp71_ = self->board;
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp71__length1 = self->board_length1;
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp71__length2 = self->board_length2;
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp72_ = x;
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp73_ = y;
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp74_ = good;
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					boni_add_bonus (_tmp70_, _tmp71_, _tmp71__length1, _tmp71__length2, _tmp72_, _tmp73_, BONUS_TYPE_LIFE, _tmp74_, 100);
#line 406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					break;
#line 2408 "nibbles-game.c"
				}
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 16:
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 17:
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 18:
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 19:
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				case 20:
#line 2420 "nibbles-game.c"
				{
					gint _tmp75_ = 0;
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp75_ = self->priv->_numworms;
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					if (_tmp75_ > 1) {
#line 2427 "nibbles-game.c"
						Boni* _tmp76_ = NULL;
						gint* _tmp77_ = NULL;
						gint _tmp77__length1 = 0;
						gint _tmp77__length2 = 0;
						gint _tmp78_ = 0;
						gint _tmp79_ = 0;
						gboolean _tmp80_ = FALSE;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp76_ = self->priv->_boni;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp77_ = self->board;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp77__length1 = self->board_length1;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp77__length2 = self->board_length2;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp78_ = x;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp79_ = y;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						_tmp80_ = good;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
						boni_add_bonus (_tmp76_, _tmp77_, _tmp77__length1, _tmp77__length2, _tmp78_, _tmp79_, BONUS_TYPE_REVERSE, _tmp80_, 150);
#line 2451 "nibbles-game.c"
					}
#line 414 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					break;
#line 2455 "nibbles-game.c"
				}
				default:
#line 383 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				break;
#line 2460 "nibbles-game.c"
			}
		}
	}
}


void nibbles_game_apply_bonus (NibblesGame* self, Bonus* bonus, Worm* worm) {
	Bonus* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gint* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	Worm* _tmp5_ = NULL;
	Position _tmp6_ = {0};
	Position _tmp7_ = {0};
	gint _tmp8_ = 0;
	Worm* _tmp9_ = NULL;
	Position _tmp10_ = {0};
	Position _tmp11_ = {0};
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (bonus != NULL);
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (worm != NULL);
#line 421 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = bonus;
#line 421 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp1_ = _tmp0_->fake;
#line 421 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (_tmp1_) {
#line 2494 "nibbles-game.c"
		Worm* _tmp2_ = NULL;
		gint* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		gint _tmp3__length2 = 0;
#line 423 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp2_ = worm;
#line 423 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp3_ = self->board;
#line 423 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp3__length1 = self->board_length1;
#line 423 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp3__length2 = self->board_length2;
#line 423 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		worm_reverse (_tmp2_, _tmp3_, _tmp3__length1, _tmp3__length2);
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		return;
#line 2511 "nibbles-game.c"
	}
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp4_ = self->board;
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp4__length1 = self->board_length1;
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp4__length2 = self->board_length2;
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp5_ = worm;
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	worm_get_head (_tmp5_, &_tmp6_);
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp7_ = _tmp6_;
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp8_ = _tmp7_.x;
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp9_ = worm;
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	worm_get_head (_tmp9_, &_tmp10_);
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp11_ = _tmp10_;
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp12_ = _tmp11_.y;
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp13_ = _tmp4_[(_tmp8_ * _tmp4__length2) + _tmp12_];
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	switch (_tmp13_ - 'A') {
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case BONUS_TYPE_REGULAR:
#line 2541 "nibbles-game.c"
		{
			Boni* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			Worm* _tmp16_ = NULL;
			Worm* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			Boni* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			Boni* _tmp21_ = NULL;
			gint _tmp22_ = 0;
			Worm* _tmp23_ = NULL;
			Worm* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			Boni* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			Boni* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp14_ = self->priv->_boni;
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp15_ = _tmp14_->numleft;
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp14_->numleft = _tmp15_ - 1;
#line 432 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp16_ = worm;
#line 432 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp17_ = worm;
#line 432 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp18_ = _tmp17_->change;
#line 432 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp19_ = self->priv->_boni;
#line 432 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp20_ = _tmp19_->numboni;
#line 432 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp21_ = self->priv->_boni;
#line 432 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp22_ = _tmp21_->numleft;
#line 432 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp17_->change = _tmp18_ + ((_tmp20_ - _tmp22_) * WORM_GROW_FACTOR);
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp23_ = worm;
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp24_ = worm;
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp25_ = worm_get_score (_tmp24_);
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp26_ = _tmp25_;
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp27_ = self->priv->_boni;
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp28_ = _tmp27_->numboni;
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp29_ = self->priv->_boni;
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp30_ = _tmp29_->numleft;
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp31_ = self->priv->_current_level;
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			worm_set_score (_tmp24_, _tmp26_ + ((_tmp28_ - _tmp30_) * _tmp31_));
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			break;
#line 2605 "nibbles-game.c"
		}
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case BONUS_TYPE_DOUBLE:
#line 2609 "nibbles-game.c"
		{
			Worm* _tmp32_ = NULL;
			Worm* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
			Worm* _tmp36_ = NULL;
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
			Worm* _tmp39_ = NULL;
			gint _tmp40_ = 0;
			gint _tmp41_ = 0;
			Worm* _tmp42_ = NULL;
			Worm* _tmp43_ = NULL;
			gint _tmp44_ = 0;
			Worm* _tmp45_ = NULL;
			gint _tmp46_ = 0;
			gint _tmp47_ = 0;
			Worm* _tmp48_ = NULL;
			gint _tmp49_ = 0;
#line 436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp32_ = worm;
#line 436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp33_ = worm;
#line 436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp34_ = worm_get_score (_tmp33_);
#line 436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp35_ = _tmp34_;
#line 436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp36_ = worm;
#line 436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp37_ = worm_get_length (_tmp36_);
#line 436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp38_ = _tmp37_;
#line 436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp39_ = worm;
#line 436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp40_ = _tmp39_->change;
#line 436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp41_ = self->priv->_current_level;
#line 436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			worm_set_score (_tmp33_, _tmp35_ + ((_tmp38_ + _tmp40_) * _tmp41_));
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp42_ = worm;
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp43_ = worm;
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp44_ = _tmp43_->change;
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp45_ = worm;
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp46_ = worm_get_length (_tmp45_);
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp47_ = _tmp46_;
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp48_ = worm;
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp49_ = _tmp48_->change;
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp43_->change = _tmp44_ + (_tmp47_ + _tmp49_);
#line 438 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			break;
#line 2671 "nibbles-game.c"
		}
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case BONUS_TYPE_HALF:
#line 2675 "nibbles-game.c"
		{
			Worm* _tmp50_ = NULL;
			gint _tmp51_ = 0;
			gint _tmp52_ = 0;
			Worm* _tmp53_ = NULL;
			gint _tmp54_ = 0;
#line 440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp50_ = worm;
#line 440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp51_ = worm_get_length (_tmp50_);
#line 440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp52_ = _tmp51_;
#line 440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp53_ = worm;
#line 440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp54_ = _tmp53_->change;
#line 440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if ((_tmp52_ + _tmp54_) > 2) {
#line 2694 "nibbles-game.c"
				Worm* _tmp55_ = NULL;
				Worm* _tmp56_ = NULL;
				gint _tmp57_ = 0;
				gint _tmp58_ = 0;
				Worm* _tmp59_ = NULL;
				gint _tmp60_ = 0;
				gint _tmp61_ = 0;
				Worm* _tmp62_ = NULL;
				gint _tmp63_ = 0;
				gint _tmp64_ = 0;
				Worm* _tmp65_ = NULL;
				gint* _tmp66_ = NULL;
				gint _tmp66__length1 = 0;
				gint _tmp66__length2 = 0;
				Worm* _tmp67_ = NULL;
				gint _tmp68_ = 0;
				gint _tmp69_ = 0;
				Worm* _tmp70_ = NULL;
				Worm* _tmp71_ = NULL;
				gint _tmp72_ = 0;
				Worm* _tmp73_ = NULL;
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
				Worm* _tmp76_ = NULL;
				gint _tmp77_ = 0;
#line 442 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp55_ = worm;
#line 442 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp56_ = worm;
#line 442 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp57_ = worm_get_score (_tmp56_);
#line 442 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp58_ = _tmp57_;
#line 442 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp59_ = worm;
#line 442 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp60_ = worm_get_length (_tmp59_);
#line 442 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp61_ = _tmp60_;
#line 442 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp62_ = worm;
#line 442 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp63_ = _tmp62_->change;
#line 442 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp64_ = self->priv->_current_level;
#line 442 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				worm_set_score (_tmp56_, _tmp58_ + ((_tmp61_ + (_tmp63_ / 2)) * _tmp64_));
#line 443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp65_ = worm;
#line 443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp66_ = self->board;
#line 443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp66__length1 = self->board_length1;
#line 443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp66__length2 = self->board_length2;
#line 443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp67_ = worm;
#line 443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp68_ = worm_get_length (_tmp67_);
#line 443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp69_ = _tmp68_;
#line 443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				worm_reduce_tail (_tmp65_, _tmp66_, _tmp66__length1, _tmp66__length2, _tmp69_ / 2);
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp70_ = worm;
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp71_ = worm;
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp72_ = _tmp71_->change;
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp73_ = worm;
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp74_ = worm_get_length (_tmp73_);
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp75_ = _tmp74_;
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp76_ = worm;
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp77_ = _tmp76_->change;
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp71_->change = _tmp72_ - ((_tmp75_ + _tmp77_) / 2);
#line 2776 "nibbles-game.c"
			}
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			break;
#line 2780 "nibbles-game.c"
		}
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case BONUS_TYPE_LIFE:
#line 2784 "nibbles-game.c"
		{
			Worm* _tmp78_ = NULL;
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp78_ = worm;
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			worm_add_life (_tmp78_);
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			break;
#line 2793 "nibbles-game.c"
		}
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case BONUS_TYPE_REVERSE:
#line 2797 "nibbles-game.c"
		{
			Worm* _tmp79_ = NULL;
#line 451 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp79_ = worm;
#line 451 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			nibbles_game_reverse_worms (self, _tmp79_);
#line 452 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			break;
#line 2806 "nibbles-game.c"
		}
		default:
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 2811 "nibbles-game.c"
	}
}


gboolean nibbles_game_add_bonus_cb (NibblesGame* self) {
	gboolean result = FALSE;
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 458 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_add_bonus (self, FALSE);
#line 460 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	result = G_SOURCE_CONTINUE;
#line 460 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 2826 "nibbles-game.c"
}


void nibbles_game_bonus_found_cb (NibblesGame* self, Worm* worm) {
	Bonus* bonus = NULL;
	Boni* _tmp0_ = NULL;
	gint* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp1__length2 = 0;
	Worm* _tmp2_ = NULL;
	Position _tmp3_ = {0};
	Position _tmp4_ = {0};
	gint _tmp5_ = 0;
	Worm* _tmp6_ = NULL;
	Position _tmp7_ = {0};
	Position _tmp8_ = {0};
	gint _tmp9_ = 0;
	Bonus* _tmp10_ = NULL;
	Bonus* _tmp11_ = NULL;
	Bonus* _tmp12_ = NULL;
	Worm* _tmp13_ = NULL;
	Bonus* _tmp14_ = NULL;
	Worm* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	gint* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gint _tmp17__length2 = 0;
	Worm* _tmp18_ = NULL;
	Position _tmp19_ = {0};
	Position _tmp20_ = {0};
	gint _tmp21_ = 0;
	Worm* _tmp22_ = NULL;
	Position _tmp23_ = {0};
	Position _tmp24_ = {0};
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
#line 463 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 463 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (worm != NULL);
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_boni;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp1_ = self->board;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp1__length1 = self->board_length1;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp1__length2 = self->board_length2;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp2_ = worm;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	worm_get_head (_tmp2_, &_tmp3_);
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp4_ = _tmp3_;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp5_ = _tmp4_.x;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp6_ = worm;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	worm_get_head (_tmp6_, &_tmp7_);
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp8_ = _tmp7_;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp9_ = _tmp8_.y;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp10_ = boni_get_bonus (_tmp0_, _tmp1_, _tmp1__length1, _tmp1__length2, _tmp5_, _tmp9_);
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	bonus = _tmp10_;
#line 466 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp11_ = bonus;
#line 466 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (_tmp11_ == NULL) {
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_g_object_unref0 (bonus);
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		return;
#line 2903 "nibbles-game.c"
	}
#line 468 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp12_ = bonus;
#line 468 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp13_ = worm;
#line 468 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_apply_bonus (self, _tmp12_, _tmp13_);
#line 469 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp14_ = bonus;
#line 469 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp15_ = worm;
#line 469 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_signal_emit_by_name (self, "bonus-applied", _tmp14_, _tmp15_);
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp17_ = self->board;
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp17__length1 = self->board_length1;
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp17__length2 = self->board_length2;
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp18_ = worm;
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	worm_get_head (_tmp18_, &_tmp19_);
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp20_ = _tmp19_;
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp21_ = _tmp20_.x;
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp22_ = worm;
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	worm_get_head (_tmp22_, &_tmp23_);
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp24_ = _tmp23_;
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp25_ = _tmp24_.y;
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp26_ = _tmp17_[(_tmp21_ * _tmp17__length2) + _tmp25_];
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (_tmp26_ == ((gint) (BONUS_TYPE_REGULAR + 'A'))) {
#line 2943 "nibbles-game.c"
		Bonus* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
#line 472 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp27_ = bonus;
#line 472 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp28_ = _tmp27_->fake;
#line 472 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp16_ = !_tmp28_;
#line 2952 "nibbles-game.c"
	} else {
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp16_ = FALSE;
#line 2956 "nibbles-game.c"
	}
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (_tmp16_) {
#line 2960 "nibbles-game.c"
		Boni* _tmp29_ = NULL;
		gint* _tmp30_ = NULL;
		gint _tmp30__length1 = 0;
		gint _tmp30__length2 = 0;
		Bonus* _tmp31_ = NULL;
		Boni* _tmp32_ = NULL;
		GeeLinkedList* _tmp33_ = NULL;
		Bonus* _tmp34_ = NULL;
		Boni* _tmp35_ = NULL;
		gint _tmp36_ = 0;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp29_ = self->priv->_boni;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp30_ = self->board;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp30__length1 = self->board_length1;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp30__length2 = self->board_length2;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp31_ = bonus;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		boni_remove_bonus (_tmp29_, _tmp30_, _tmp30__length1, _tmp30__length2, _tmp31_);
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp32_ = self->priv->_boni;
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp33_ = _tmp32_->bonuses;
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp34_ = bonus;
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp33_, _tmp34_);
#line 478 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp35_ = self->priv->_boni;
#line 478 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp36_ = _tmp35_->numleft;
#line 478 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		if (_tmp36_ != 0) {
#line 479 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			nibbles_game_add_bonus (self, TRUE);
#line 2999 "nibbles-game.c"
		}
	} else {
		Boni* _tmp37_ = NULL;
		gint* _tmp38_ = NULL;
		gint _tmp38__length1 = 0;
		gint _tmp38__length2 = 0;
		Bonus* _tmp39_ = NULL;
		Boni* _tmp40_ = NULL;
		GeeLinkedList* _tmp41_ = NULL;
		Bonus* _tmp42_ = NULL;
#line 484 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp37_ = self->priv->_boni;
#line 484 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp38_ = self->board;
#line 484 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp38__length1 = self->board_length1;
#line 484 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp38__length2 = self->board_length2;
#line 484 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp39_ = bonus;
#line 484 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		boni_remove_bonus (_tmp37_, _tmp38_, _tmp38__length1, _tmp38__length2, _tmp39_);
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp40_ = self->priv->_boni;
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp41_ = _tmp40_->bonuses;
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp42_ = bonus;
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp41_, _tmp42_);
#line 3030 "nibbles-game.c"
	}
#line 463 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_g_object_unref0 (bonus);
#line 3034 "nibbles-game.c"
}


void nibbles_game_warp_found_cb (NibblesGame* self, Worm* worm) {
	Warp* warp = NULL;
	WarpManager* _tmp0_ = NULL;
	Worm* _tmp1_ = NULL;
	Position _tmp2_ = {0};
	Position _tmp3_ = {0};
	gint _tmp4_ = 0;
	Worm* _tmp5_ = NULL;
	Position _tmp6_ = {0};
	Position _tmp7_ = {0};
	gint _tmp8_ = 0;
	Warp* _tmp9_ = NULL;
	Warp* _tmp10_ = NULL;
	Worm* _tmp11_ = NULL;
	Warp* _tmp12_ = NULL;
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (worm != NULL);
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_warp_manager;
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp1_ = worm;
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	worm_get_head (_tmp1_, &_tmp2_);
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp3_ = _tmp2_;
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp4_ = _tmp3_.x;
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp5_ = worm;
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	worm_get_head (_tmp5_, &_tmp6_);
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp7_ = _tmp6_;
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp8_ = _tmp7_.y;
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp9_ = warp_manager_get_warp (_tmp0_, _tmp4_, _tmp8_);
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	warp = _tmp9_;
#line 492 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp10_ = warp;
#line 492 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (_tmp10_ == NULL) {
#line 493 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_g_object_unref0 (warp);
#line 493 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		return;
#line 3087 "nibbles-game.c"
	}
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp11_ = worm;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp12_ = warp;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	worm_warp (_tmp11_, _tmp12_);
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_g_object_unref0 (warp);
#line 3097 "nibbles-game.c"
}


static GameStatus* _game_status_dup (GameStatus* self) {
	GameStatus* dup;
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	dup = g_new0 (GameStatus, 1);
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	memcpy (dup, self, sizeof (GameStatus));
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return dup;
#line 3109 "nibbles-game.c"
}


static gpointer __game_status_dup0 (gpointer self) {
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return self ? _game_status_dup (self) : NULL;
#line 3116 "nibbles-game.c"
}


GameStatus* nibbles_game_get_game_status (NibblesGame* self) {
	GameStatus* result = NULL;
	gint worms_left = 0;
	gboolean _tmp23_ = FALSE;
	gint _tmp24_ = 0;
	Boni* _tmp31_ = NULL;
	gint _tmp32_ = 0;
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	worms_left = 0;
#line 3131 "nibbles-game.c"
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _worm_index = 0;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp0_ = self->priv->_worms;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_list = _tmp1_;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp2_ = _worm_list;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp4_ = _tmp3_;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_size = _tmp4_;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_index = -1;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		while (TRUE) {
#line 3159 "nibbles-game.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			Worm* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp5_ = _worm_index;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_worm_index = _tmp5_ + 1;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp6_ = _worm_index;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp7_ = _worm_size;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				break;
#line 3182 "nibbles-game.c"
			}
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp8_ = _worm_list;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp9_ = _worm_index;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			worm = (Worm*) _tmp10_;
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp11_ = worm;
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp12_ = worm_get_lives (_tmp11_);
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp13_ = _tmp12_;
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp13_ > 0) {
#line 3200 "nibbles-game.c"
				gint _tmp14_ = 0;
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp14_ = worms_left;
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				worms_left = _tmp14_ + 1;
#line 3206 "nibbles-game.c"
			} else {
				gboolean _tmp15_ = FALSE;
				Worm* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
#line 505 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp16_ = worm;
#line 505 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp17_ = _tmp16_->is_human;
#line 505 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				if (_tmp17_) {
#line 3217 "nibbles-game.c"
					Worm* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
#line 505 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp18_ = worm;
#line 505 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp19_ = worm_get_lives (_tmp18_);
#line 505 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp20_ = _tmp19_;
#line 505 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp15_ = _tmp20_ <= 0;
#line 3229 "nibbles-game.c"
				} else {
#line 505 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp15_ = FALSE;
#line 3233 "nibbles-game.c"
				}
#line 505 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				if (_tmp15_) {
#line 3237 "nibbles-game.c"
					GameStatus _tmp21_ = 0;
					GameStatus* _tmp22_ = NULL;
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp21_ = GAME_STATUS_GAMEOVER;
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_tmp22_ = __game_status_dup0 (&_tmp21_);
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					result = _tmp22_;
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_g_object_unref0 (worm);
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_g_object_unref0 (_worm_list);
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					return result;
#line 3252 "nibbles-game.c"
				}
			}
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_g_object_unref0 (worm);
#line 3257 "nibbles-game.c"
		}
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_g_object_unref0 (_worm_list);
#line 3261 "nibbles-game.c"
	}
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp24_ = worms_left;
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (_tmp24_ == 1) {
#line 3267 "nibbles-game.c"
		gint _tmp25_ = 0;
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp25_ = self->priv->_numworms;
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp23_ = _tmp25_ > 1;
#line 3273 "nibbles-game.c"
	} else {
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp23_ = FALSE;
#line 3277 "nibbles-game.c"
	}
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (_tmp23_) {
#line 3281 "nibbles-game.c"
		GameStatus _tmp26_ = 0;
		GameStatus* _tmp27_ = NULL;
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp26_ = GAME_STATUS_VICTORY;
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp27_ = __game_status_dup0 (&_tmp26_);
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		result = _tmp27_;
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		return result;
#line 3292 "nibbles-game.c"
	} else {
		gint _tmp28_ = 0;
#line 514 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp28_ = worms_left;
#line 514 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		if (_tmp28_ == 0) {
#line 3299 "nibbles-game.c"
			GameStatus _tmp29_ = 0;
			GameStatus* _tmp30_ = NULL;
#line 517 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp29_ = GAME_STATUS_GAMEOVER;
#line 517 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp30_ = __game_status_dup0 (&_tmp29_);
#line 517 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			result = _tmp30_;
#line 517 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			return result;
#line 3310 "nibbles-game.c"
		}
	}
#line 520 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp31_ = self->priv->_boni;
#line 520 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp32_ = _tmp31_->numleft;
#line 520 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (_tmp32_ == 0) {
#line 3319 "nibbles-game.c"
		GameStatus _tmp33_ = 0;
		GameStatus* _tmp34_ = NULL;
#line 521 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp33_ = GAME_STATUS_NEWROUND;
#line 521 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp34_ = __game_status_dup0 (&_tmp33_);
#line 521 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		result = _tmp34_;
#line 521 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		return result;
#line 3330 "nibbles-game.c"
	}
#line 523 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	result = NULL;
#line 523 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 3336 "nibbles-game.c"
}


Worm* nibbles_game_get_winner (NibblesGame* self) {
	Worm* result = NULL;
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 3344 "nibbles-game.c"
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _worm_index = 0;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp0_ = self->priv->_worms;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_list = _tmp1_;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp2_ = _worm_list;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp4_ = _tmp3_;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_size = _tmp4_;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_index = -1;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		while (TRUE) {
#line 3372 "nibbles-game.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			Worm* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp5_ = _worm_index;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_worm_index = _tmp5_ + 1;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp6_ = _worm_index;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp7_ = _worm_size;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				break;
#line 3395 "nibbles-game.c"
			}
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp8_ = _worm_list;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp9_ = _worm_index;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			worm = (Worm*) _tmp10_;
#line 530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp11_ = worm;
#line 530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp12_ = worm_get_lives (_tmp11_);
#line 530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp13_ = _tmp12_;
#line 530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp13_ > 0) {
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				result = worm;
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_g_object_unref0 (_worm_list);
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				return result;
#line 3419 "nibbles-game.c"
			}
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_g_object_unref0 (worm);
#line 3423 "nibbles-game.c"
		}
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_g_object_unref0 (_worm_list);
#line 3427 "nibbles-game.c"
	}
#line 534 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	result = NULL;
#line 534 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 3433 "nibbles-game.c"
}


void nibbles_game_load_properties (NibblesGame* self, GSettings* settings) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GSettings* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 541 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 541 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (settings != NULL);
#line 543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = settings;
#line 543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp1_ = g_settings_get_int (_tmp0_, "tile-size");
#line 543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_set_tile_size (self, _tmp1_);
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp2_ = settings;
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp3_ = g_settings_get_int (_tmp2_, "start-level");
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_set_start_level (self, _tmp3_);
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp4_ = settings;
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp5_ = g_settings_get_int (_tmp4_, "speed");
#line 545 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_set_speed (self, _tmp5_);
#line 546 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp6_ = settings;
#line 546 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp7_ = g_settings_get_boolean (_tmp6_, "fakes");
#line 546 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_set_fakes (self, _tmp7_);
#line 3474 "nibbles-game.c"
}


void nibbles_game_save_properties (NibblesGame* self, GSettings* settings) {
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GSettings* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 549 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 549 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (settings != NULL);
#line 551 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = settings;
#line 551 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp1_ = self->priv->_tile_size;
#line 551 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_settings_set_int (_tmp0_, "tile-size", _tmp1_);
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp2_ = settings;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp3_ = self->priv->_start_level;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_settings_set_int (_tmp2_, "start-level", _tmp3_);
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp4_ = settings;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp5_ = self->priv->_speed;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_settings_set_int (_tmp4_, "speed", _tmp5_);
#line 554 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp6_ = settings;
#line 554 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp7_ = self->priv->_fakes;
#line 554 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_settings_set_boolean (_tmp6_, "fakes", _tmp7_);
#line 3515 "nibbles-game.c"
}


void nibbles_game_load_worm_properties (NibblesGame* self, GeeArrayList* worm_settings) {
	GeeHashMap* _tmp0_ = NULL;
#line 557 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 557 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (worm_settings != NULL);
#line 559 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_worm_props;
#line 559 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
#line 3529 "nibbles-game.c"
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		GeeLinkedList* _tmp2_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _worm_index = 0;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp1_ = self->priv->_worms;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_list = _tmp2_;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp3_ = _worm_list;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp5_ = _tmp4_;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_size = _tmp5_;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_index = -1;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		while (TRUE) {
#line 3557 "nibbles-game.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			WormProperties properties = {0};
			GeeArrayList* _tmp12_ = NULL;
			Worm* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gpointer _tmp16_ = NULL;
			GSettings* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			GeeArrayList* _tmp19_ = NULL;
			Worm* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
			gpointer _tmp23_ = NULL;
			GSettings* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			GeeArrayList* _tmp26_ = NULL;
			Worm* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gpointer _tmp30_ = NULL;
			GSettings* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			GeeArrayList* _tmp33_ = NULL;
			Worm* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			gpointer _tmp37_ = NULL;
			GSettings* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			GeeArrayList* _tmp40_ = NULL;
			Worm* _tmp41_ = NULL;
			gint _tmp42_ = 0;
			gint _tmp43_ = 0;
			gpointer _tmp44_ = NULL;
			GSettings* _tmp45_ = NULL;
			gint _tmp46_ = 0;
			GeeHashMap* _tmp47_ = NULL;
			Worm* _tmp48_ = NULL;
			WormProperties _tmp49_ = {0};
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp6_ = _worm_index;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_worm_index = _tmp6_ + 1;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp7_ = _worm_index;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp8_ = _worm_size;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				break;
#line 3616 "nibbles-game.c"
			}
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp9_ = _worm_list;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp10_ = _worm_index;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			worm = (Worm*) _tmp11_;
#line 562 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			memset (&properties, 0, sizeof (WormProperties));
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp12_ = worm_settings;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp13_ = worm;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp14_ = worm_get_id (_tmp13_);
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp15_ = _tmp14_;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp15_);
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp17_ = (GSettings*) _tmp16_;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp18_ = g_settings_get_enum (_tmp17_, "color");
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			properties.color = _tmp18_;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_g_object_unref0 (_tmp17_);
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp19_ = worm_settings;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp20_ = worm;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp21_ = worm_get_id (_tmp20_);
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp22_ = _tmp21_;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _tmp22_);
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp24_ = (GSettings*) _tmp23_;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp25_ = g_settings_get_int (_tmp24_, "key-up");
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			properties.up = (guint) _tmp25_;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_g_object_unref0 (_tmp24_);
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp26_ = worm_settings;
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp27_ = worm;
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp28_ = worm_get_id (_tmp27_);
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp29_ = _tmp28_;
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, _tmp29_);
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp31_ = (GSettings*) _tmp30_;
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp32_ = g_settings_get_int (_tmp31_, "key-down");
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			properties.down = (guint) _tmp32_;
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_g_object_unref0 (_tmp31_);
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp33_ = worm_settings;
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp34_ = worm;
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp35_ = worm_get_id (_tmp34_);
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp36_ = _tmp35_;
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, _tmp36_);
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp38_ = (GSettings*) _tmp37_;
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp39_ = g_settings_get_int (_tmp38_, "key-left");
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			properties.left = (guint) _tmp39_;
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_g_object_unref0 (_tmp38_);
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp40_ = worm_settings;
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp41_ = worm;
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp42_ = worm_get_id (_tmp41_);
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp43_ = _tmp42_;
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp44_ = gee_abstract_list_get ((GeeAbstractList*) _tmp40_, _tmp43_);
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp45_ = (GSettings*) _tmp44_;
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp46_ = g_settings_get_int (_tmp45_, "key-right");
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			properties.right = (guint) _tmp46_;
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_g_object_unref0 (_tmp45_);
#line 569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp47_ = self->priv->_worm_props;
#line 569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp48_ = worm;
#line 569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp49_ = properties;
#line 569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp47_, _tmp48_, &_tmp49_);
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_g_object_unref0 (worm);
#line 3728 "nibbles-game.c"
		}
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_g_object_unref0 (_worm_list);
#line 3732 "nibbles-game.c"
	}
}


gboolean nibbles_game_handle_keypress (NibblesGame* self, guint keyval) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 573 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 575 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_is_running;
#line 575 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (!_tmp0_) {
#line 576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		result = FALSE;
#line 576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		return result;
#line 3750 "nibbles-game.c"
	}
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		GeeLinkedList* _tmp2_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _worm_index = 0;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp1_ = self->priv->_worms;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_list = _tmp2_;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp3_ = _worm_list;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_tmp5_ = _tmp4_;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_size = _tmp5_;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_worm_index = -1;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		while (TRUE) {
#line 3779 "nibbles-game.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			Worm* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp6_ = _worm_index;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_worm_index = _tmp6_ + 1;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp7_ = _worm_index;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp8_ = _worm_size;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				break;
#line 3801 "nibbles-game.c"
			}
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp9_ = _worm_list;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp10_ = _worm_index;
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			worm = (Worm*) _tmp11_;
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp12_ = worm;
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_tmp13_ = _tmp12_->is_human;
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			if (_tmp13_) {
#line 3817 "nibbles-game.c"
				Worm* _tmp14_ = NULL;
				guint _tmp15_ = 0U;
				GeeHashMap* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
#line 582 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp14_ = worm;
#line 582 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp15_ = keyval;
#line 582 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp16_ = self->priv->_worm_props;
#line 582 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				_tmp17_ = worm_handle_keypress (_tmp14_, _tmp15_, _tmp16_);
#line 582 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
				if (_tmp17_) {
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					result = TRUE;
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_g_object_unref0 (worm);
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					_g_object_unref0 (_worm_list);
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
					return result;
#line 3840 "nibbles-game.c"
				}
			}
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
			_g_object_unref0 (worm);
#line 3845 "nibbles-game.c"
		}
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		_g_object_unref0 (_worm_list);
#line 3849 "nibbles-game.c"
	}
#line 587 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	result = FALSE;
#line 587 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 3855 "nibbles-game.c"
}


gint nibbles_game_get_start_level (NibblesGame* self) {
	gint result;
	gint _tmp0_ = 0;
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_start_level;
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	result = _tmp0_;
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 3870 "nibbles-game.c"
}


static void nibbles_game_set_start_level (NibblesGame* self, gint value) {
	gint _tmp0_ = 0;
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = value;
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv->_start_level = _tmp0_;
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_notify ((GObject *) self, "start-level");
#line 3884 "nibbles-game.c"
}


gint nibbles_game_get_current_level (NibblesGame* self) {
	gint result;
	gint _tmp0_ = 0;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_current_level;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	result = _tmp0_;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 3899 "nibbles-game.c"
}


static void nibbles_game_set_current_level (NibblesGame* self, gint value) {
	gint _tmp0_ = 0;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = value;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv->_current_level = _tmp0_;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_notify ((GObject *) self, "current-level");
#line 3913 "nibbles-game.c"
}


gint nibbles_game_get_speed (NibblesGame* self) {
	gint result;
	gint _tmp0_ = 0;
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_speed;
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	result = _tmp0_;
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 3928 "nibbles-game.c"
}


void nibbles_game_set_speed (NibblesGame* self, gint value) {
	gint _tmp0_ = 0;
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = value;
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv->_speed = _tmp0_;
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_notify ((GObject *) self, "speed");
#line 3942 "nibbles-game.c"
}


gint nibbles_game_get_tile_size (NibblesGame* self) {
	gint result;
	gint _tmp0_ = 0;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_tile_size;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	result = _tmp0_;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 3957 "nibbles-game.c"
}


void nibbles_game_set_tile_size (NibblesGame* self, gint value) {
	gint _tmp0_ = 0;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = value;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv->_tile_size = _tmp0_;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_notify ((GObject *) self, "tile-size");
#line 3971 "nibbles-game.c"
}


gint nibbles_game_get_numhumans (NibblesGame* self) {
	gint result;
	gint _tmp0_ = 0;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_numhumans;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	result = _tmp0_;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 3986 "nibbles-game.c"
}


void nibbles_game_set_numhumans (NibblesGame* self, gint value) {
	gint _tmp0_ = 0;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = value;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv->_numhumans = _tmp0_;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_notify ((GObject *) self, "numhumans");
#line 4000 "nibbles-game.c"
}


gint nibbles_game_get_numai (NibblesGame* self) {
	gint result;
	gint _tmp0_ = 0;
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_numai;
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	result = _tmp0_;
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 4015 "nibbles-game.c"
}


void nibbles_game_set_numai (NibblesGame* self, gint value) {
	gint _tmp0_ = 0;
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = value;
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv->_numai = _tmp0_;
#line 62 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_notify ((GObject *) self, "numai");
#line 4029 "nibbles-game.c"
}


gint nibbles_game_get_numworms (NibblesGame* self) {
	gint result;
	gint _tmp0_ = 0;
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_numworms;
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	result = _tmp0_;
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 4044 "nibbles-game.c"
}


static void nibbles_game_set_numworms (NibblesGame* self, gint value) {
	gint _tmp0_ = 0;
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = value;
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv->_numworms = _tmp0_;
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_notify ((GObject *) self, "numworms");
#line 4058 "nibbles-game.c"
}


GeeLinkedList* nibbles_game_get_worms (NibblesGame* self) {
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_ = NULL;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_worms;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	result = _tmp0_;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 4073 "nibbles-game.c"
}


static void nibbles_game_set_worms (NibblesGame* self, GeeLinkedList* value) {
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = value;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_g_object_unref0 (self->priv->_worms);
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv->_worms = _tmp1_;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_notify ((GObject *) self, "worms");
#line 4092 "nibbles-game.c"
}


Boni* nibbles_game_get_boni (NibblesGame* self) {
	Boni* result;
	Boni* _tmp0_ = NULL;
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_boni;
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	result = _tmp0_;
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 4107 "nibbles-game.c"
}


static void nibbles_game_set_boni (NibblesGame* self, Boni* value) {
	Boni* _tmp0_ = NULL;
	Boni* _tmp1_ = NULL;
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = value;
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_g_object_unref0 (self->priv->_boni);
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv->_boni = _tmp1_;
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_notify ((GObject *) self, "boni");
#line 4126 "nibbles-game.c"
}


WarpManager* nibbles_game_get_warp_manager (NibblesGame* self) {
	WarpManager* result;
	WarpManager* _tmp0_ = NULL;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_warp_manager;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	result = _tmp0_;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 4141 "nibbles-game.c"
}


static void nibbles_game_set_warp_manager (NibblesGame* self, WarpManager* value) {
	WarpManager* _tmp0_ = NULL;
	WarpManager* _tmp1_ = NULL;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = value;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_g_object_unref0 (self->priv->_warp_manager);
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv->_warp_manager = _tmp1_;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_notify ((GObject *) self, "warp-manager");
#line 4160 "nibbles-game.c"
}


GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self) {
	GeeHashMap* result;
	GeeHashMap* _tmp0_ = NULL;
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_worm_props;
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	result = _tmp0_;
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 4175 "nibbles-game.c"
}


static void nibbles_game_set_worm_props (NibblesGame* self, GeeHashMap* value) {
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = value;
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_g_object_unref0 (self->priv->_worm_props);
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv->_worm_props = _tmp1_;
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_notify ((GObject *) self, "worm-props");
#line 4194 "nibbles-game.c"
}


gboolean nibbles_game_get_is_running (NibblesGame* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_is_running;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	result = _tmp0_;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 4209 "nibbles-game.c"
}


static void nibbles_game_set_is_running (NibblesGame* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = value;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv->_is_running = _tmp0_;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_notify ((GObject *) self, "is-running");
#line 4223 "nibbles-game.c"
}


gboolean nibbles_game_get_is_paused (NibblesGame* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_is_paused;
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	result = _tmp0_;
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 4238 "nibbles-game.c"
}


static void nibbles_game_set_is_paused (NibblesGame* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = value;
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv->_is_paused = _tmp0_;
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_notify ((GObject *) self, "is-paused");
#line 4252 "nibbles-game.c"
}


gboolean nibbles_game_get_fakes (NibblesGame* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = self->priv->_fakes;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	result = _tmp0_;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	return result;
#line 4267 "nibbles-game.c"
}


void nibbles_game_set_fakes (NibblesGame* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_tmp0_ = value;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv->_fakes = _tmp0_;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_notify ((GObject *) self, "fakes");
#line 4281 "nibbles-game.c"
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (n_param_values == 3);
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		data1 = closure->data;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		data2 = param_values->data[0].v_pointer;
#line 4300 "nibbles-game.c"
	} else {
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		data1 = param_values->data[0].v_pointer;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		data2 = closure->data;
#line 4306 "nibbles-game.c"
	}
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
#line 4312 "nibbles-game.c"
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_return_if_fail (n_param_values == 3);
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		data1 = closure->data;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		data2 = param_values->data[0].v_pointer;
#line 4331 "nibbles-game.c"
	} else {
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		data1 = param_values->data[0].v_pointer;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		data2 = closure->data;
#line 4337 "nibbles-game.c"
	}
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
#line 4343 "nibbles-game.c"
}


static void nibbles_game_class_init (NibblesGameClass * klass) {
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	nibbles_game_parent_class = g_type_class_peek_parent (klass);
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_type_class_add_private (klass, sizeof (NibblesGamePrivate));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_nibbles_game_get_property;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_nibbles_game_set_property;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	G_OBJECT_CLASS (klass)->finalize = nibbles_game_finalize;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_START_LEVEL, g_param_spec_int ("start-level", "start-level", "start-level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_CURRENT_LEVEL, g_param_spec_int ("current-level", "current-level", "current-level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_SPEED, g_param_spec_int ("speed", "speed", "speed", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_TILE_SIZE, g_param_spec_int ("tile-size", "tile-size", "tile-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_NUMHUMANS, g_param_spec_int ("numhumans", "numhumans", "numhumans", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_NUMAI, g_param_spec_int ("numai", "numai", "numai", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_NUMWORMS, g_param_spec_int ("numworms", "numworms", "numworms", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_WORMS, g_param_spec_object ("worms", "worms", "worms", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_BONI, g_param_spec_object ("boni", "boni", "boni", TYPE_BONI, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_WARP_MANAGER, g_param_spec_object ("warp-manager", "warp-manager", "warp-manager", TYPE_WARP_MANAGER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_WORM_PROPS, g_param_spec_object ("worm-props", "worm-props", "worm-props", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_IS_RUNNING, g_param_spec_boolean ("is-running", "is-running", "is-running", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_IS_PAUSED, g_param_spec_boolean ("is-paused", "is-paused", "is-paused", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_FAKES, g_param_spec_boolean ("fakes", "fakes", "fakes", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_signal_new ("worm_moved", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_WORM);
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_signal_new ("bonus_applied", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, TYPE_BONUS, TYPE_WORM);
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_signal_new ("log_score", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_signal_new ("animate_end_game", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	g_signal_new ("level_completed", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 4396 "nibbles-game.c"
}


static void nibbles_game_instance_init (NibblesGame * self) {
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv = NIBBLES_GAME_GET_PRIVATE (self);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv->_is_running = FALSE;
#line 75 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv->main_id = (guint) 0;
#line 76 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->priv->add_bonus_id = (guint) 0;
#line 4409 "nibbles-game.c"
}


static void nibbles_game_finalize (GObject* obj) {
	NibblesGame * self;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES_GAME, NibblesGame);
#line 58 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	self->board = (g_free (self->board), NULL);
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_g_object_unref0 (self->priv->_worms);
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_g_object_unref0 (self->priv->_boni);
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_g_object_unref0 (self->priv->_warp_manager);
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	_g_object_unref0 (self->priv->_worm_props);
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	G_OBJECT_CLASS (nibbles_game_parent_class)->finalize (obj);
#line 4429 "nibbles-game.c"
}


GType nibbles_game_get_type (void) {
	static volatile gsize nibbles_game_type_id__volatile = 0;
	if (g_once_init_enter (&nibbles_game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NibblesGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesGame), 0, (GInstanceInitFunc) nibbles_game_instance_init, NULL };
		GType nibbles_game_type_id;
		nibbles_game_type_id = g_type_register_static (G_TYPE_OBJECT, "NibblesGame", &g_define_type_info, 0);
		g_once_init_leave (&nibbles_game_type_id__volatile, nibbles_game_type_id);
	}
	return nibbles_game_type_id__volatile;
}


static void _vala_nibbles_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NibblesGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_GAME, NibblesGame);
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	switch (property_id) {
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_START_LEVEL:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		g_value_set_int (value, nibbles_game_get_start_level (self));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_CURRENT_LEVEL:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		g_value_set_int (value, nibbles_game_get_current_level (self));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_SPEED:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		g_value_set_int (value, nibbles_game_get_speed (self));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_TILE_SIZE:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		g_value_set_int (value, nibbles_game_get_tile_size (self));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_NUMHUMANS:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		g_value_set_int (value, nibbles_game_get_numhumans (self));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_NUMAI:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		g_value_set_int (value, nibbles_game_get_numai (self));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_NUMWORMS:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		g_value_set_int (value, nibbles_game_get_numworms (self));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_WORMS:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		g_value_set_object (value, nibbles_game_get_worms (self));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_BONI:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		g_value_set_object (value, nibbles_game_get_boni (self));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_WARP_MANAGER:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		g_value_set_object (value, nibbles_game_get_warp_manager (self));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_WORM_PROPS:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		g_value_set_object (value, nibbles_game_get_worm_props (self));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_IS_RUNNING:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		g_value_set_boolean (value, nibbles_game_get_is_running (self));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_IS_PAUSED:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		g_value_set_boolean (value, nibbles_game_get_is_paused (self));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_FAKES:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		g_value_set_boolean (value, nibbles_game_get_fakes (self));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 4534 "nibbles-game.c"
		default:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 4540 "nibbles-game.c"
	}
}


static void _vala_nibbles_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NibblesGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_GAME, NibblesGame);
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
	switch (property_id) {
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_START_LEVEL:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		nibbles_game_set_start_level (self, g_value_get_int (value));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_CURRENT_LEVEL:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		nibbles_game_set_current_level (self, g_value_get_int (value));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_SPEED:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		nibbles_game_set_speed (self, g_value_get_int (value));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_TILE_SIZE:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		nibbles_game_set_tile_size (self, g_value_get_int (value));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_NUMHUMANS:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		nibbles_game_set_numhumans (self, g_value_get_int (value));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_NUMAI:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		nibbles_game_set_numai (self, g_value_get_int (value));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_NUMWORMS:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		nibbles_game_set_numworms (self, g_value_get_int (value));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_WORMS:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		nibbles_game_set_worms (self, g_value_get_object (value));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_BONI:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		nibbles_game_set_boni (self, g_value_get_object (value));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_WARP_MANAGER:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		nibbles_game_set_warp_manager (self, g_value_get_object (value));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_WORM_PROPS:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		nibbles_game_set_worm_props (self, g_value_get_object (value));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_IS_RUNNING:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		nibbles_game_set_is_running (self, g_value_get_boolean (value));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_IS_PAUSED:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		nibbles_game_set_is_paused (self, g_value_get_boolean (value));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		case NIBBLES_GAME_FAKES:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		nibbles_game_set_fakes (self, g_value_get_boolean (value));
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 4634 "nibbles-game.c"
		default:
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/nibbles-game.vala"
		break;
#line 4640 "nibbles-game.c"
	}
}



