/* gnome-nibbles.c generated by valac 0.31.1.4-3806, the Vala compiler
 * generated from gnome-nibbles.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <clutter-gtk/clutter-gtk.h>
#include <libgames-support.h>
#include <stdio.h>
#include <stdlib.h>
#include <gdk/gdk.h>
#include <string.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <pango/pango.h>


#define TYPE_NIBBLES (nibbles_get_type ())
#define NIBBLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES, Nibbles))
#define NIBBLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES, NibblesClass))
#define IS_NIBBLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES))
#define IS_NIBBLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES))
#define NIBBLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES, NibblesClass))

typedef struct _Nibbles Nibbles;
typedef struct _NibblesClass NibblesClass;
typedef struct _NibblesPrivate NibblesPrivate;

#define TYPE_SCOREBOARD (scoreboard_get_type ())
#define SCOREBOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCOREBOARD, Scoreboard))
#define SCOREBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCOREBOARD, ScoreboardClass))
#define IS_SCOREBOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCOREBOARD))
#define IS_SCOREBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCOREBOARD))
#define SCOREBOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCOREBOARD, ScoreboardClass))

typedef struct _Scoreboard Scoreboard;
typedef struct _ScoreboardClass ScoreboardClass;

#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;

#define TYPE_NIBBLES_VIEW (nibbles_view_get_type ())
#define NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_VIEW, NibblesView))
#define NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_VIEW, NibblesViewClass))
#define IS_NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_VIEW))
#define IS_NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_VIEW))
#define NIBBLES_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_VIEW, NibblesViewClass))

typedef struct _NibblesView NibblesView;
typedef struct _NibblesViewClass NibblesViewClass;

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _NibblesViewPrivate NibblesViewPrivate;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
typedef struct _WormProperties WormProperties;
#define _worm_properties_free0(var) ((var == NULL) ? NULL : (var = (worm_properties_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _WormPrivate WormPrivate;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())

#define TYPE_CONTROLS_GRID (controls_grid_get_type ())
#define CONTROLS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTROLS_GRID, ControlsGrid))
#define CONTROLS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTROLS_GRID, ControlsGridClass))
#define IS_CONTROLS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTROLS_GRID))
#define IS_CONTROLS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTROLS_GRID))
#define CONTROLS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTROLS_GRID, ControlsGridClass))

typedef struct _ControlsGrid ControlsGrid;
typedef struct _ControlsGridClass ControlsGridClass;
typedef struct _Block3Data Block3Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
typedef struct _ScoreboardPrivate ScoreboardPrivate;

#define TYPE_PLAYER_SCORE_BOX (player_score_box_get_type ())
#define PLAYER_SCORE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_SCORE_BOX, PlayerScoreBox))
#define PLAYER_SCORE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_SCORE_BOX, PlayerScoreBoxClass))
#define IS_PLAYER_SCORE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_SCORE_BOX))
#define IS_PLAYER_SCORE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_SCORE_BOX))
#define PLAYER_SCORE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_SCORE_BOX, PlayerScoreBoxClass))

typedef struct _PlayerScoreBox PlayerScoreBox;
typedef struct _PlayerScoreBoxClass PlayerScoreBoxClass;
typedef struct _PlayerScoreBoxPrivate PlayerScoreBoxPrivate;
typedef struct _ControlsGridPrivate ControlsGridPrivate;

struct _Nibbles {
	GtkApplication parent_instance;
	NibblesPrivate * priv;
};

struct _NibblesClass {
	GtkApplicationClass parent_class;
};

struct _NibblesPrivate {
	GSettings* settings;
	GeeArrayList* worm_settings;
	GtkApplicationWindow* window;
	gboolean is_maximized;
	gboolean is_tiled;
	gint window_width;
	gint window_height;
	GtkStack* main_stack;
	GtkOverlay* overlay;
	GtkHeaderBar* headerbar;
	GtkButton* new_game_button;
	GtkButton* pause_button;
	GeeLinkedList* number_of_players_buttons;
	GeeLinkedList* number_of_ai_buttons;
	GtkBox* grids_box;
	GdkPixbuf* arrow_pixbuf;
	GdkPixbuf* arrow_key_pixbuf;
	GtkStack* statusbar_stack;
	GtkLabel* countdown;
	Scoreboard* scoreboard;
	GdkPixbuf* scoreboard_life;
	PreferencesDialog* preferences_dialog;
	NibblesView* view;
	GtkBox* game_box;
	GamesGridFrame* frame;
	NibblesGame* game;
	GamesScoresContext* scores_context;
	GeeLinkedList* scorecats;
	GSimpleAction* new_game_action;
	GSimpleAction* pause_action;
	GSimpleAction* back_action;
	guint countdown_id;
};

struct _NibblesView {
	GtkClutterEmbed parent_instance;
	NibblesViewPrivate * priv;
	gboolean is_muted;
};

struct _NibblesViewClass {
	GtkClutterEmbedClass parent_class;
};

struct _WormProperties {
	gint color;
	guint up;
	guint down;
	guint left;
	guint right;
};

struct _Block1Data {
	int _ref_count_;
	Nibbles* self;
	gint seconds;
};

struct _Block2Data {
	int _ref_count_;
	Nibbles* self;
	GtkMessageDialog* dialog;
};

typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP
} WormDirection;

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gboolean is_stopped;
	gint change;
	WormDirection direction;
	WormDirection starting_direction;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _Block3Data {
	int _ref_count_;
	Nibbles* self;
	glong lowest_high_score;
	gint score;
	gint level_reached;
};

struct _Block4Data {
	int _ref_count_;
	Nibbles* self;
	GtkLabel* label;
	GtkButton* button;
};

struct _Block5Data {
	int _ref_count_;
	Nibbles* self;
	gboolean should_unpause;
};

struct _Block6Data {
	int _ref_count_;
	Nibbles* self;
	GtkLabel* game_over_label;
	GtkLabel* msg_label;
	GtkLabel* score_label;
	GtkLabel* points_left_label;
	GtkButton* button;
};

struct _Scoreboard {
	GtkBox parent_instance;
	ScoreboardPrivate * priv;
};

struct _ScoreboardClass {
	GtkBoxClass parent_class;
};

struct _ScoreboardPrivate {
	GeeHashMap* boxes;
};

struct _PlayerScoreBox {
	GtkBox parent_instance;
	PlayerScoreBoxPrivate * priv;
};

struct _PlayerScoreBoxClass {
	GtkBoxClass parent_class;
};

struct _PlayerScoreBoxPrivate {
	GtkLabel* name_label;
	GtkLabel* score_label;
	GtkGrid* lives_grid;
	GeeLinkedList* life_images;
};

struct _ControlsGrid {
	GtkGrid parent_instance;
	ControlsGridPrivate * priv;
};

struct _ControlsGridClass {
	GtkGridClass parent_class;
};

struct _ControlsGridPrivate {
	GtkLabel* name_label;
	GtkImage* arrow_up;
	GtkImage* arrow_down;
	GtkImage* arrow_left;
	GtkImage* arrow_right;
	GtkOverlay* move_up;
	GtkLabel* move_up_label;
	GtkOverlay* move_down;
	GtkLabel* move_down_label;
	GtkOverlay* move_left;
	GtkLabel* move_left_label;
	GtkOverlay* move_right;
	GtkLabel* move_right_label;
};


static gpointer nibbles_parent_class = NULL;
static gpointer scoreboard_parent_class = NULL;
static gpointer player_score_box_parent_class = NULL;
static gpointer controls_grid_parent_class = NULL;

GType nibbles_get_type (void) G_GNUC_CONST;
GType scoreboard_get_type (void) G_GNUC_CONST;
GType preferences_dialog_get_type (void) G_GNUC_CONST;
GType nibbles_view_get_type (void) G_GNUC_CONST;
GType nibbles_game_get_type (void) G_GNUC_CONST;
#define NIBBLES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NIBBLES, NibblesPrivate))
enum  {
	NIBBLES_DUMMY_PROPERTY
};
#define NIBBLES_COUNTDOWN_TIME 3
static void nibbles_start_game_cb (Nibbles* self);
static void _nibbles_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_new_game_cb (Nibbles* self);
static void _nibbles_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_pause_cb (Nibbles* self);
static void _nibbles_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_preferences_cb (Nibbles* self);
static void _nibbles_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_scores_cb (Nibbles* self);
static void _nibbles_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_about_cb (Nibbles* self);
static void _nibbles_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_show_new_game_screen_cb (Nibbles* self);
static void _nibbles_show_new_game_screen_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_show_controls_screen_cb (Nibbles* self);
static void _nibbles_show_controls_screen_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void nibbles_back_cb (Nibbles* self);
static void _nibbles_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Nibbles* nibbles_new (void);
Nibbles* nibbles_construct (GType object_type);
static gint nibbles_real_handle_local_options (GApplication* base, GVariantDict* options);
static void nibbles_real_startup (GApplication* base);
static void nibbles_settings_changed_cb (Nibbles* self, const gchar* key);
static void _nibbles_settings_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
#define NIBBLES_GAME_MAX_WORMS 6
static void nibbles_worm_settings_changed_cb (Nibbles* self, GSettings* changed_worm_settings, const gchar* key);
static void _nibbles_worm_settings_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void nibbles_size_allocate_cb (Nibbles* self, GtkAllocation* allocation);
static void _nibbles_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean nibbles_window_state_event_cb (Nibbles* self, GdkEventWindowState* event);
static gboolean _nibbles_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static gboolean nibbles_key_press_event_cb (Nibbles* self, GtkWidget* widget, GdkEventKey* event);
static gboolean _nibbles_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
#define NIBBLES_GAME_MAX_HUMANS 4
static void nibbles_change_number_of_players_cb (Nibbles* self, GtkToggleButton* button);
static void _nibbles_change_number_of_players_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
#define NIBBLES_GAME_MAX_AI 5
static void nibbles_change_number_of_ai_cb (Nibbles* self, GtkToggleButton* button);
static void _nibbles_change_number_of_ai_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
NibblesGame* nibbles_game_new (GSettings* settings);
NibblesGame* nibbles_game_construct (GType object_type, GSettings* settings);
static void nibbles_log_score_cb (Nibbles* self, gint score, gint level_reached);
static void _nibbles_log_score_cb_nibbles_game_log_score (NibblesGame* _sender, gint score, gint level_reached, gpointer self);
static void nibbles_level_completed_cb (Nibbles* self);
static void _nibbles_level_completed_cb_nibbles_game_level_completed (NibblesGame* _sender, gpointer self);
static void __lambda14_ (Nibbles* self);
gboolean nibbles_game_get_is_paused (NibblesGame* self);
static void ___lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
NibblesView* nibbles_view_new (NibblesGame* game);
NibblesView* nibbles_view_construct (GType object_type, NibblesGame* game);
static gboolean nibbles_configure_event_cb (Nibbles* self, GdkEventConfigure* event);
static gboolean _nibbles_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
#define NIBBLES_GAME_WIDTH 92
#define NIBBLES_GAME_HEIGHT 66
Scoreboard* scoreboard_new (void);
Scoreboard* scoreboard_construct (GType object_type);
GdkPixbuf* nibbles_view_load_pixmap_file (NibblesView* self, const gchar* pixmap, gint xsize, gint ysize);
gint nibbles_game_get_tile_size (NibblesGame* self);
void nibbles_game_set_numhumans (NibblesGame* self, gint value);
void nibbles_game_set_numai (NibblesGame* self, gint value);
static void nibbles_show_first_run_screen (Nibbles* self);
static void nibbles_create_scores (Nibbles* self);
static void nibbles_real_activate (GApplication* base);
static void nibbles_real_shutdown (GApplication* base);
void nibbles_game_save_properties (NibblesGame* self, GSettings* settings);
gboolean nibbles_game_handle_keypress (NibblesGame* self, guint keyval);
void nibbles_view_board_rescale (NibblesView* self, gint tile_size);
void nibbles_view_boni_rescale (NibblesView* self, gint tile_size);
void nibbles_view_warps_rescale (NibblesView* self, gint tile_size);
GType worm_get_type (void) G_GNUC_CONST;
GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
void nibbles_game_set_tile_size (NibblesGame* self, gint value);
void nibbles_game_reset (NibblesGame* self);
void nibbles_view_new_level (NibblesView* self, gint level);
gint nibbles_game_get_current_level (NibblesGame* self);
void nibbles_view_connect_worm_signals (NibblesView* self);
void scoreboard_clear (Scoreboard* self);
GType worm_properties_get_type (void) G_GNUC_CONST;
WormProperties* worm_properties_dup (const WormProperties* self);
void worm_properties_free (WormProperties* self);
GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
void scoreboard_register (Scoreboard* self, Worm* worm, const gchar* color_name, GdkPixbuf* life_pixbuf);
gchar* nibbles_view_colorval_name (gint colorval);
void scoreboard_update (Scoreboard* self);
static void _scoreboard_update_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void nibbles_game_add_worms (NibblesGame* self);
void nibbles_view_create_name_labels (NibblesView* self);
static void nibbles_show_game_view (Nibbles* self);
static void nibbles_start_game_with_countdown (Nibbles* self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
ClutterActor* nibbles_view_get_name_labels (NibblesView* self);
static gboolean __lambda7_ (Block1Data* _data1_);
void nibbles_game_add_bonus (NibblesGame* self, gboolean regular);
void nibbles_game_start (NibblesGame* self);
static gboolean ___lambda7__gsource_func (gpointer self);
static void nibbles_restart_game (Nibbles* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
gboolean nibbles_game_get_is_running (NibblesGame* self);
void nibbles_game_stop (NibblesGame* self);
static void __lambda8_ (Block2Data* _data2_, gint response_id);
static void ___lambda8__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void nibbles_game_pause (NibblesGame* self);
void nibbles_game_unpause (NibblesGame* self);
void nibbles_game_set_speed (NibblesGame* self, gint value);
void nibbles_game_set_fakes (NibblesGame* self, gboolean value);
gint nibbles_game_get_numworms (NibblesGame* self);
gint nibbles_view_colorval_from_name (const gchar* name);
gint nibbles_game_get_numhumans (NibblesGame* self);
gint nibbles_game_get_numai (NibblesGame* self);
void nibbles_game_create_worms (NibblesGame* self);
void nibbles_game_load_worm_properties (NibblesGame* self, GeeArrayList* worm_settings);
GType worm_direction_get_type (void) G_GNUC_CONST;
GType controls_grid_get_type (void) G_GNUC_CONST;
gint worm_get_id (Worm* self);
ControlsGrid* controls_grid_new (gint worm_id, WormProperties* worm_props, GdkPixbuf* arrow, GdkPixbuf* arrow_key);
ControlsGrid* controls_grid_construct (GType object_type, gint worm_id, WormProperties* worm_props, GdkPixbuf* arrow, GdkPixbuf* arrow_key);
static GamesScoresCategory* nibbles_category_request (Nibbles* self, const gchar* key);
static gchar* nibbles_get_new_scores_key (Nibbles* self, const gchar* old_key);
static GamesScoresCategory* _nibbles_category_request_games_scores_context_category_request_func (const gchar* category_key, gpointer self);
static gchar* _nibbles_get_new_scores_key_games_scores_directory_importer_category_convert_func (const gchar* old_key, gpointer self);
static GamesScoresCategory* nibbles_get_scores_category (Nibbles* self, gint speed, gboolean fakes);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
gint nibbles_game_get_speed (NibblesGame* self);
gboolean nibbles_game_get_fakes (NibblesGame* self);
static void nibbles_game_over (Nibbles* self, gint score, glong lowest_high_score, gint level_reached);
gint nibbles_game_get_start_level (NibblesGame* self);
static void __lambda11_ (Block3Data* _data3_, GObject* object, GAsyncResult* _result_);
static void ___lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
#define NIBBLES_GAME_MAX_LEVEL 26
static void __lambda12_ (Block4Data* _data4_);
static void ___lambda12__gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean __lambda13_ (Block4Data* _data4_);
static gboolean ___lambda13__gsource_func (gpointer self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
PreferencesDialog* preferences_dialog_new (GtkApplicationWindow* window, GSettings* settings, GeeArrayList* worm_settings);
PreferencesDialog* preferences_dialog_construct (GType object_type, GtkApplicationWindow* window, GSettings* settings, GeeArrayList* worm_settings);
static void __lambda9_ (Block5Data* _data5_);
static void ___lambda9__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda10_ (Block6Data* _data6_);
static void ___lambda10__gtk_button_clicked (GtkButton* _sender, gpointer self);
gint nibbles_main (gchar** args, int args_length1);
static void nibbles_finalize (GObject* obj);
GType player_score_box_get_type (void) G_GNUC_CONST;
#define SCOREBOARD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SCOREBOARD, ScoreboardPrivate))
enum  {
	SCOREBOARD_DUMMY_PROPERTY
};
gint worm_get_score (Worm* self);
gint worm_get_lives (Worm* self);
PlayerScoreBox* player_score_box_new (const gchar* name, PangoColor* color, gint score, gint lives_left, GdkPixbuf* life_pixbuf);
PlayerScoreBox* player_score_box_construct (GType object_type, const gchar* name, PangoColor* color, gint score, gint lives_left, GdkPixbuf* life_pixbuf);
void player_score_box_update (PlayerScoreBox* self, gint score, gint lives_left);
static void scoreboard_finalize (GObject* obj);
#define PLAYER_SCORE_BOX_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PLAYER_SCORE_BOX, PlayerScoreBoxPrivate))
enum  {
	PLAYER_SCORE_BOX_DUMMY_PROPERTY
};
#define WORM_MAX_LIVES 12
#define WORM_STARTING_LIVES 6
void player_score_box_update_score (PlayerScoreBox* self, gint score);
void player_score_box_update_lives (PlayerScoreBox* self, gint lives_left);
static void player_score_box_finalize (GObject* obj);
#define CONTROLS_GRID_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CONTROLS_GRID, ControlsGridPrivate))
enum  {
	CONTROLS_GRID_DUMMY_PROPERTY
};
static void controls_grid_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry NIBBLES_action_entries[7] = {{"start-game", _nibbles_start_game_cb_gsimple_action_activate_callback}, {"new-game", _nibbles_new_game_cb_gsimple_action_activate_callback}, {"pause", _nibbles_pause_cb_gsimple_action_activate_callback}, {"preferences", _nibbles_preferences_cb_gsimple_action_activate_callback}, {"scores", _nibbles_scores_cb_gsimple_action_activate_callback}, {"about", _nibbles_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};
static const GActionEntry NIBBLES_menu_entries[3] = {{"show-new-game-screen", _nibbles_show_new_game_screen_cb_gsimple_action_activate_callback}, {"show-controls-screen", _nibbles_show_controls_screen_cb_gsimple_action_activate_callback}, {"back", _nibbles_back_cb_gsimple_action_activate_callback}};
static const GOptionEntry NIBBLES_option_entries[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Show release version", NULL}, {NULL}};

static void _nibbles_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	nibbles_start_game_cb ((Nibbles*) self);
}


static void _nibbles_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	nibbles_new_game_cb ((Nibbles*) self);
}


static void _nibbles_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	nibbles_pause_cb ((Nibbles*) self);
}


static void _nibbles_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	nibbles_preferences_cb ((Nibbles*) self);
}


static void _nibbles_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	nibbles_scores_cb ((Nibbles*) self);
}


static void _nibbles_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	nibbles_about_cb ((Nibbles*) self);
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	g_application_quit ((GApplication*) self);
}


static void _nibbles_show_new_game_screen_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	nibbles_show_new_game_screen_cb ((Nibbles*) self);
}


static void _nibbles_show_controls_screen_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	nibbles_show_controls_screen_cb ((Nibbles*) self);
}


static void _nibbles_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	nibbles_back_cb ((Nibbles*) self);
}


Nibbles* nibbles_construct (GType object_type) {
	Nibbles * self = NULL;
	self = (Nibbles*) g_object_new (object_type, "application-id", "org.gnome.nibbles", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_set_prgname ("org.gnome.Nibbles");
	g_application_add_main_option_entries ((GApplication*) self, NIBBLES_option_entries);
	return self;
}


Nibbles* nibbles_new (void) {
	return nibbles_construct (TYPE_NIBBLES);
}


static gint nibbles_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Nibbles * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (Nibbles*) base;
	g_return_val_if_fail (options != NULL, 0);
	_tmp0_ = options;
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
	if (_tmp1_) {
		FILE* _tmp2_ = NULL;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "gnome-nibbles %s\n", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	result = -1;
	return result;
}


static void _nibbles_settings_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	nibbles_settings_changed_cb ((Nibbles*) self, key);
}


static void _nibbles_worm_settings_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	nibbles_worm_settings_changed_cb ((Nibbles*) self, _sender, key);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _nibbles_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	nibbles_size_allocate_cb ((Nibbles*) self, allocation);
}


static gboolean _nibbles_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = nibbles_window_state_event_cb ((Nibbles*) self, event);
	return result;
}


static gboolean _nibbles_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = nibbles_key_press_event_cb ((Nibbles*) self, _sender, event);
	return result;
}


static void _nibbles_change_number_of_players_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	nibbles_change_number_of_players_cb ((Nibbles*) self, _sender);
}


static void _nibbles_change_number_of_ai_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	nibbles_change_number_of_ai_cb ((Nibbles*) self, _sender);
}


static void _nibbles_log_score_cb_nibbles_game_log_score (NibblesGame* _sender, gint score, gint level_reached, gpointer self) {
	nibbles_log_score_cb ((Nibbles*) self, score, level_reached);
}


static void _nibbles_level_completed_cb_nibbles_game_level_completed (NibblesGame* _sender, gpointer self) {
	nibbles_level_completed_cb ((Nibbles*) self);
}


static void __lambda14_ (Nibbles* self) {
	NibblesGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_is_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkStack* _tmp3_ = NULL;
		_tmp3_ = self->priv->statusbar_stack;
		gtk_stack_set_visible_child_name (_tmp3_, "paused");
	} else {
		GtkStack* _tmp4_ = NULL;
		_tmp4_ = self->priv->statusbar_stack;
		gtk_stack_set_visible_child_name (_tmp4_, "scoreboard");
	}
}


static void ___lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda14_ ((Nibbles*) self);
}


static gboolean _nibbles_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = nibbles_configure_event_cb ((Nibbles*) self, event);
	return result;
}


static void nibbles_real_startup (GApplication* base) {
	Nibbles * self;
	GtkSettings* _tmp0_ = NULL;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp1_ = NULL;
	GtkCssProvider* _tmp2_ = NULL;
	GdkScreen* _tmp3_ = NULL;
	GtkCssProvider* _tmp4_ = NULL;
	GSettings* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	GeeArrayList* _tmp7_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	gchar* _tmp24_ = NULL;
	gchar** _tmp25_ = NULL;
	gchar** _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	GAction* _tmp27_ = NULL;
	GSimpleAction* _tmp28_ = NULL;
	GAction* _tmp29_ = NULL;
	GSimpleAction* _tmp30_ = NULL;
	GAction* _tmp31_ = NULL;
	GSimpleAction* _tmp32_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp33_ = NULL;
	GtkBuilder* _tmp34_ = NULL;
	GObject* _tmp35_ = NULL;
	GtkApplicationWindow* _tmp36_ = NULL;
	GtkApplicationWindow* _tmp37_ = NULL;
	GtkApplicationWindow* _tmp38_ = NULL;
	GtkApplicationWindow* _tmp39_ = NULL;
	GtkApplicationWindow* _tmp40_ = NULL;
	GSettings* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	GSettings* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	GSettings* _tmp45_ = NULL;
	gboolean _tmp46_ = FALSE;
	GtkBuilder* _tmp48_ = NULL;
	GObject* _tmp49_ = NULL;
	GtkHeaderBar* _tmp50_ = NULL;
	GtkBuilder* _tmp51_ = NULL;
	GObject* _tmp52_ = NULL;
	GtkOverlay* _tmp53_ = NULL;
	GtkBuilder* _tmp54_ = NULL;
	GObject* _tmp55_ = NULL;
	GtkButton* _tmp56_ = NULL;
	GtkBuilder* _tmp57_ = NULL;
	GObject* _tmp58_ = NULL;
	GtkButton* _tmp59_ = NULL;
	GtkBuilder* _tmp60_ = NULL;
	GObject* _tmp61_ = NULL;
	GtkStack* _tmp62_ = NULL;
	GtkBuilder* _tmp63_ = NULL;
	GObject* _tmp64_ = NULL;
	GtkBox* _tmp65_ = NULL;
	GtkBuilder* _tmp66_ = NULL;
	GObject* _tmp67_ = NULL;
	GtkStack* _tmp68_ = NULL;
	GtkBuilder* _tmp69_ = NULL;
	GObject* _tmp70_ = NULL;
	GtkLabel* _tmp71_ = NULL;
	GeeLinkedList* _tmp72_ = NULL;
	GeeLinkedList* _tmp86_ = NULL;
	GtkBuilder* _tmp100_ = NULL;
	GObject* _tmp101_ = NULL;
	GtkBox* _tmp102_ = NULL;
	GtkApplicationWindow* _tmp103_ = NULL;
	GtkHeaderBar* _tmp104_ = NULL;
	GtkApplicationWindow* _tmp105_ = NULL;
	GSettings* _tmp106_ = NULL;
	NibblesGame* _tmp107_ = NULL;
	NibblesGame* _tmp108_ = NULL;
	NibblesGame* _tmp109_ = NULL;
	NibblesGame* _tmp110_ = NULL;
	NibblesGame* _tmp111_ = NULL;
	NibblesView* _tmp112_ = NULL;
	NibblesView* _tmp113_ = NULL;
	NibblesView* _tmp114_ = NULL;
	GSettings* _tmp115_ = NULL;
	gboolean _tmp116_ = FALSE;
	NibblesView* _tmp117_ = NULL;
	GamesGridFrame* _tmp118_ = NULL;
	GtkBox* _tmp119_ = NULL;
	GamesGridFrame* _tmp120_ = NULL;
	Scoreboard* _tmp121_ = NULL;
	NibblesView* _tmp122_ = NULL;
	NibblesGame* _tmp123_ = NULL;
	gint _tmp124_ = 0;
	gint _tmp125_ = 0;
	NibblesGame* _tmp126_ = NULL;
	gint _tmp127_ = 0;
	gint _tmp128_ = 0;
	GdkPixbuf* _tmp129_ = NULL;
	Scoreboard* _tmp130_ = NULL;
	GtkStack* _tmp131_ = NULL;
	Scoreboard* _tmp132_ = NULL;
	GamesGridFrame* _tmp133_ = NULL;
	NibblesView* _tmp134_ = NULL;
	GamesGridFrame* _tmp135_ = NULL;
	NibblesGame* _tmp136_ = NULL;
	GSettings* _tmp137_ = NULL;
	gint _tmp138_ = 0;
	NibblesGame* _tmp139_ = NULL;
	GSettings* _tmp140_ = NULL;
	gint _tmp141_ = 0;
	NibblesView* _tmp142_ = NULL;
	NibblesGame* _tmp143_ = NULL;
	gint _tmp144_ = 0;
	gint _tmp145_ = 0;
	NibblesGame* _tmp146_ = NULL;
	gint _tmp147_ = 0;
	gint _tmp148_ = 0;
	GdkPixbuf* _tmp149_ = NULL;
	NibblesView* _tmp150_ = NULL;
	NibblesGame* _tmp151_ = NULL;
	gint _tmp152_ = 0;
	gint _tmp153_ = 0;
	NibblesGame* _tmp154_ = NULL;
	gint _tmp155_ = 0;
	gint _tmp156_ = 0;
	GdkPixbuf* _tmp157_ = NULL;
	gboolean first_run = FALSE;
	GSettings* _tmp158_ = NULL;
	gboolean _tmp159_ = FALSE;
	gboolean _tmp160_ = FALSE;
	GtkApplicationWindow* _tmp161_ = NULL;
	self = (Nibbles*) base;
	G_APPLICATION_CLASS (nibbles_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = gtk_settings_get_default ();
	g_object_set ((GObject*) _tmp0_, "gtk-application-prefer-dark-theme", TRUE, NULL);
	_tmp1_ = gtk_css_provider_new ();
	css_provider = _tmp1_;
	_tmp2_ = css_provider;
	gtk_css_provider_load_from_resource (_tmp2_, "/org/gnome/nibbles/ui/nibbles.css");
	_tmp3_ = gdk_screen_get_default ();
	_tmp4_ = css_provider;
	gtk_style_context_add_provider_for_screen (_tmp3_, (GtkStyleProvider*) _tmp4_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	g_action_map_add_action_entries ((GActionMap*) self, NIBBLES_action_entries, G_N_ELEMENTS (NIBBLES_action_entries), self);
	g_action_map_add_action_entries ((GActionMap*) self, NIBBLES_menu_entries, G_N_ELEMENTS (NIBBLES_menu_entries), self);
	_tmp5_ = g_settings_new ("org.gnome.nibbles");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp5_;
	_tmp6_ = self->priv->settings;
	g_signal_connect_object (_tmp6_, "changed", (GCallback) _nibbles_settings_changed_cb_g_settings_changed, self, 0);
	_tmp7_ = gee_array_list_new (G_TYPE_SETTINGS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->worm_settings);
	self->priv->worm_settings = _tmp7_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint _tmp10_ = 0;
				gchar* name = NULL;
				gint _tmp11_ = 0;
				gchar* _tmp12_ = NULL;
				GeeArrayList* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				GSettings* _tmp15_ = NULL;
				GSettings* _tmp16_ = NULL;
				GeeArrayList* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gpointer _tmp19_ = NULL;
				GSettings* _tmp20_ = NULL;
				if (!_tmp8_) {
					gint _tmp9_ = 0;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = i;
				if (!(_tmp10_ < NIBBLES_GAME_MAX_WORMS)) {
					break;
				}
				_tmp11_ = i;
				_tmp12_ = g_strdup_printf ("org.gnome.nibbles.worm%d", _tmp11_);
				name = _tmp12_;
				_tmp13_ = self->priv->worm_settings;
				_tmp14_ = name;
				_tmp15_ = g_settings_new (_tmp14_);
				_tmp16_ = _tmp15_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp16_);
				_g_object_unref0 (_tmp16_);
				_tmp17_ = self->priv->worm_settings;
				_tmp18_ = i;
				_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _tmp18_);
				_tmp20_ = (GSettings*) _tmp19_;
				g_signal_connect_object (_tmp20_, "changed", (GCallback) _nibbles_worm_settings_changed_cb_g_settings_changed, self, 0);
				_g_object_unref0 (_tmp20_);
				_g_free0 (name);
			}
		}
	}
	_tmp21_ = g_strdup ("<Primary>q");
	_tmp22_ = g_new0 (gchar*, 1 + 1);
	_tmp22_[0] = _tmp21_;
	_tmp23_ = _tmp22_;
	_tmp23__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp23_);
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
	_tmp24_ = g_strdup ("Escape");
	_tmp25_ = g_new0 (gchar*, 1 + 1);
	_tmp25_[0] = _tmp24_;
	_tmp26_ = _tmp25_;
	_tmp26__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.back", _tmp26_);
	_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
	_tmp27_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->new_game_action);
	self->priv->new_game_action = _tmp28_;
	_tmp29_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
	_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->pause_action);
	self->priv->pause_action = _tmp30_;
	_tmp31_ = g_action_map_lookup_action ((GActionMap*) self, "back");
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->back_action);
	self->priv->back_action = _tmp32_;
	_tmp33_ = gtk_builder_new_from_resource ("/org/gnome/nibbles/ui/nibbles.ui");
	builder = _tmp33_;
	_tmp34_ = builder;
	_tmp35_ = gtk_builder_get_object (_tmp34_, "nibbles-window");
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, gtk_application_window_get_type ()) ? ((GtkApplicationWindow*) _tmp35_) : NULL);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp36_;
	_tmp37_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp37_, "size-allocate", (GCallback) _nibbles_size_allocate_cb_gtk_widget_size_allocate, self, 0);
	_tmp38_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp38_, "window-state-event", (GCallback) _nibbles_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp39_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp39_, "key-press-event", (GCallback) _nibbles_key_press_event_cb_gtk_widget_key_press_event, self, 0);
	_tmp40_ = self->priv->window;
	_tmp41_ = self->priv->settings;
	_tmp42_ = g_settings_get_int (_tmp41_, "window-width");
	_tmp43_ = self->priv->settings;
	_tmp44_ = g_settings_get_int (_tmp43_, "window-height");
	gtk_window_set_default_size ((GtkWindow*) _tmp40_, _tmp42_, _tmp44_);
	_tmp45_ = self->priv->settings;
	_tmp46_ = g_settings_get_boolean (_tmp45_, "window-is-maximized");
	if (_tmp46_) {
		GtkApplicationWindow* _tmp47_ = NULL;
		_tmp47_ = self->priv->window;
		gtk_window_maximize ((GtkWindow*) _tmp47_);
	}
	_tmp48_ = builder;
	_tmp49_ = gtk_builder_get_object (_tmp48_, "headerbar");
	_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, gtk_header_bar_get_type (), GtkHeaderBar));
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp50_;
	_tmp51_ = builder;
	_tmp52_ = gtk_builder_get_object (_tmp51_, "main_overlay");
	_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_overlay_get_type (), GtkOverlay));
	_g_object_unref0 (self->priv->overlay);
	self->priv->overlay = _tmp53_;
	_tmp54_ = builder;
	_tmp55_ = gtk_builder_get_object (_tmp54_, "new_game_button");
	_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->new_game_button);
	self->priv->new_game_button = _tmp56_;
	_tmp57_ = builder;
	_tmp58_ = gtk_builder_get_object (_tmp57_, "pause_button");
	_tmp59_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->pause_button);
	self->priv->pause_button = _tmp59_;
	_tmp60_ = builder;
	_tmp61_ = gtk_builder_get_object (_tmp60_, "main_stack");
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, gtk_stack_get_type (), GtkStack));
	_g_object_unref0 (self->priv->main_stack);
	self->priv->main_stack = _tmp62_;
	_tmp63_ = builder;
	_tmp64_ = gtk_builder_get_object (_tmp63_, "game_box");
	_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->game_box);
	self->priv->game_box = _tmp65_;
	_tmp66_ = builder;
	_tmp67_ = gtk_builder_get_object (_tmp66_, "statusbar_stack");
	_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, gtk_stack_get_type (), GtkStack));
	_g_object_unref0 (self->priv->statusbar_stack);
	self->priv->statusbar_stack = _tmp68_;
	_tmp69_ = builder;
	_tmp70_ = gtk_builder_get_object (_tmp69_, "countdown");
	_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->countdown);
	self->priv->countdown = _tmp71_;
	_tmp72_ = gee_linked_list_new (gtk_toggle_button_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->number_of_players_buttons);
	self->priv->number_of_players_buttons = _tmp72_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp73_ = FALSE;
			_tmp73_ = TRUE;
			while (TRUE) {
				gint _tmp75_ = 0;
				GtkToggleButton* button = NULL;
				GtkBuilder* _tmp76_ = NULL;
				gint _tmp77_ = 0;
				gchar* _tmp78_ = NULL;
				gchar* _tmp79_ = NULL;
				GObject* _tmp80_ = NULL;
				GtkToggleButton* _tmp81_ = NULL;
				GtkToggleButton* _tmp82_ = NULL;
				GtkToggleButton* _tmp83_ = NULL;
				GeeLinkedList* _tmp84_ = NULL;
				GtkToggleButton* _tmp85_ = NULL;
				if (!_tmp73_) {
					gint _tmp74_ = 0;
					_tmp74_ = i;
					i = _tmp74_ + 1;
				}
				_tmp73_ = FALSE;
				_tmp75_ = i;
				if (!(_tmp75_ < NIBBLES_GAME_MAX_HUMANS)) {
					break;
				}
				_tmp76_ = builder;
				_tmp77_ = i;
				_tmp78_ = g_strdup_printf ("players%d", _tmp77_ + 1);
				_tmp79_ = _tmp78_;
				_tmp80_ = gtk_builder_get_object (_tmp76_, _tmp79_);
				_tmp81_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, gtk_toggle_button_get_type (), GtkToggleButton));
				_tmp82_ = _tmp81_;
				_g_free0 (_tmp79_);
				button = _tmp82_;
				_tmp83_ = button;
				g_signal_connect_object (_tmp83_, "toggled", (GCallback) _nibbles_change_number_of_players_cb_gtk_toggle_button_toggled, self, 0);
				_tmp84_ = self->priv->number_of_players_buttons;
				_tmp85_ = button;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp84_, _tmp85_);
				_g_object_unref0 (button);
			}
		}
	}
	_tmp86_ = gee_linked_list_new (gtk_toggle_button_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->number_of_ai_buttons);
	self->priv->number_of_ai_buttons = _tmp86_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp87_ = FALSE;
			_tmp87_ = TRUE;
			while (TRUE) {
				gint _tmp89_ = 0;
				GtkToggleButton* button = NULL;
				GtkBuilder* _tmp90_ = NULL;
				gint _tmp91_ = 0;
				gchar* _tmp92_ = NULL;
				gchar* _tmp93_ = NULL;
				GObject* _tmp94_ = NULL;
				GtkToggleButton* _tmp95_ = NULL;
				GtkToggleButton* _tmp96_ = NULL;
				GtkToggleButton* _tmp97_ = NULL;
				GeeLinkedList* _tmp98_ = NULL;
				GtkToggleButton* _tmp99_ = NULL;
				if (!_tmp87_) {
					gint _tmp88_ = 0;
					_tmp88_ = i;
					i = _tmp88_ + 1;
				}
				_tmp87_ = FALSE;
				_tmp89_ = i;
				if (!(_tmp89_ <= NIBBLES_GAME_MAX_AI)) {
					break;
				}
				_tmp90_ = builder;
				_tmp91_ = i;
				_tmp92_ = g_strdup_printf ("ai%d", _tmp91_);
				_tmp93_ = _tmp92_;
				_tmp94_ = gtk_builder_get_object (_tmp90_, _tmp93_);
				_tmp95_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, gtk_toggle_button_get_type (), GtkToggleButton));
				_tmp96_ = _tmp95_;
				_g_free0 (_tmp93_);
				button = _tmp96_;
				_tmp97_ = button;
				g_signal_connect_object (_tmp97_, "toggled", (GCallback) _nibbles_change_number_of_ai_cb_gtk_toggle_button_toggled, self, 0);
				_tmp98_ = self->priv->number_of_ai_buttons;
				_tmp99_ = button;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp98_, _tmp99_);
				_g_object_unref0 (button);
			}
		}
	}
	_tmp100_ = builder;
	_tmp101_ = gtk_builder_get_object (_tmp100_, "grids_box");
	_tmp102_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp101_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->grids_box);
	self->priv->grids_box = _tmp102_;
	_tmp103_ = self->priv->window;
	_tmp104_ = self->priv->headerbar;
	gtk_window_set_titlebar ((GtkWindow*) _tmp103_, (GtkWidget*) _tmp104_);
	_tmp105_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp105_);
	_tmp106_ = self->priv->settings;
	_tmp107_ = nibbles_game_new (_tmp106_);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp107_;
	_tmp108_ = self->priv->game;
	g_signal_connect_object (_tmp108_, "log-score", (GCallback) _nibbles_log_score_cb_nibbles_game_log_score, self, 0);
	_tmp109_ = self->priv->game;
	g_signal_connect_object (_tmp109_, "level-completed", (GCallback) _nibbles_level_completed_cb_nibbles_game_level_completed, self, 0);
	_tmp110_ = self->priv->game;
	g_signal_connect_object ((GObject*) _tmp110_, "notify::is-paused", (GCallback) ___lambda14__g_object_notify, self, 0);
	_tmp111_ = self->priv->game;
	_tmp112_ = nibbles_view_new (_tmp111_);
	g_object_ref_sink (_tmp112_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp112_;
	_tmp113_ = self->priv->view;
	g_signal_connect_object ((GtkWidget*) _tmp113_, "configure-event", (GCallback) _nibbles_configure_event_cb_gtk_widget_configure_event, self, 0);
	_tmp114_ = self->priv->view;
	_tmp115_ = self->priv->settings;
	_tmp116_ = g_settings_get_boolean (_tmp115_, "sound");
	_tmp114_->is_muted = !_tmp116_;
	_tmp117_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp117_);
	_tmp118_ = games_grid_frame_new (NIBBLES_GAME_WIDTH, NIBBLES_GAME_HEIGHT);
	g_object_ref_sink (_tmp118_);
	_g_object_unref0 (self->priv->frame);
	self->priv->frame = _tmp118_;
	_tmp119_ = self->priv->game_box;
	_tmp120_ = self->priv->frame;
	gtk_box_pack_start (_tmp119_, (GtkWidget*) _tmp120_, TRUE, TRUE, (guint) 0);
	_tmp121_ = scoreboard_new ();
	g_object_ref_sink (_tmp121_);
	_g_object_unref0 (self->priv->scoreboard);
	self->priv->scoreboard = _tmp121_;
	_tmp122_ = self->priv->view;
	_tmp123_ = self->priv->game;
	_tmp124_ = nibbles_game_get_tile_size (_tmp123_);
	_tmp125_ = _tmp124_;
	_tmp126_ = self->priv->game;
	_tmp127_ = nibbles_game_get_tile_size (_tmp126_);
	_tmp128_ = _tmp127_;
	_tmp129_ = nibbles_view_load_pixmap_file (_tmp122_, "scoreboard-life.svg", 2 * _tmp125_, 2 * _tmp128_);
	_g_object_unref0 (self->priv->scoreboard_life);
	self->priv->scoreboard_life = _tmp129_;
	_tmp130_ = self->priv->scoreboard;
	gtk_widget_show ((GtkWidget*) _tmp130_);
	_tmp131_ = self->priv->statusbar_stack;
	_tmp132_ = self->priv->scoreboard;
	gtk_stack_add_named (_tmp131_, (GtkWidget*) _tmp132_, "scoreboard");
	_tmp133_ = self->priv->frame;
	_tmp134_ = self->priv->view;
	gtk_container_add ((GtkContainer*) _tmp133_, (GtkWidget*) _tmp134_);
	_tmp135_ = self->priv->frame;
	gtk_widget_show ((GtkWidget*) _tmp135_);
	_tmp136_ = self->priv->game;
	_tmp137_ = self->priv->settings;
	_tmp138_ = g_settings_get_int (_tmp137_, "players");
	nibbles_game_set_numhumans (_tmp136_, _tmp138_);
	_tmp139_ = self->priv->game;
	_tmp140_ = self->priv->settings;
	_tmp141_ = g_settings_get_int (_tmp140_, "ai");
	nibbles_game_set_numai (_tmp139_, _tmp141_);
	_tmp142_ = self->priv->view;
	_tmp143_ = self->priv->game;
	_tmp144_ = nibbles_game_get_tile_size (_tmp143_);
	_tmp145_ = _tmp144_;
	_tmp146_ = self->priv->game;
	_tmp147_ = nibbles_game_get_tile_size (_tmp146_);
	_tmp148_ = _tmp147_;
	_tmp149_ = nibbles_view_load_pixmap_file (_tmp142_, "arrow.svg", 5 * _tmp145_, 5 * _tmp148_);
	_g_object_unref0 (self->priv->arrow_pixbuf);
	self->priv->arrow_pixbuf = _tmp149_;
	_tmp150_ = self->priv->view;
	_tmp151_ = self->priv->game;
	_tmp152_ = nibbles_game_get_tile_size (_tmp151_);
	_tmp153_ = _tmp152_;
	_tmp154_ = self->priv->game;
	_tmp155_ = nibbles_game_get_tile_size (_tmp154_);
	_tmp156_ = _tmp155_;
	_tmp157_ = nibbles_view_load_pixmap_file (_tmp150_, "arrow-key.svg", 5 * _tmp153_, 5 * _tmp156_);
	_g_object_unref0 (self->priv->arrow_key_pixbuf);
	self->priv->arrow_key_pixbuf = _tmp157_;
	_tmp158_ = self->priv->settings;
	_tmp159_ = g_settings_get_boolean (_tmp158_, "first-run");
	first_run = _tmp159_;
	_tmp160_ = first_run;
	if (_tmp160_) {
		nibbles_show_first_run_screen (self);
	} else {
		nibbles_show_new_game_screen_cb (self);
	}
	nibbles_create_scores (self);
	_tmp161_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp161_);
	_g_object_unref0 (builder);
	_g_object_unref0 (css_provider);
}


static void nibbles_real_activate (GApplication* base) {
	Nibbles * self;
	GtkApplicationWindow* _tmp0_ = NULL;
	self = (Nibbles*) base;
	G_APPLICATION_CLASS (nibbles_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp0_);
}


static void nibbles_real_shutdown (GApplication* base) {
	Nibbles * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	NibblesGame* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	self = (Nibbles*) base;
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->window_width;
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->window_height;
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
	_tmp6_ = self->priv->game;
	_tmp7_ = self->priv->settings;
	nibbles_game_save_properties (_tmp6_, _tmp7_);
	G_APPLICATION_CLASS (nibbles_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}


static gboolean nibbles_key_press_event_cb (Nibbles* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	NibblesGame* _tmp0_ = NULL;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->game;
	_tmp1_ = event;
	_tmp2_ = _tmp1_->keyval;
	_tmp3_ = nibbles_game_handle_keypress (_tmp0_, _tmp2_);
	result = _tmp3_;
	return result;
}


static void nibbles_size_allocate_cb (Nibbles* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkApplicationWindow* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp1_ = self->priv->is_maximized;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->priv->is_tiled;
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->window;
	gtk_window_get_size ((GtkWindow*) _tmp3_, &_tmp4_, &_tmp5_);
	self->priv->window_width = _tmp4_;
	self->priv->window_height = _tmp5_;
}


static gboolean nibbles_window_state_event_cb (Nibbles* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->new_window_state;
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	_tmp4_ = event;
	_tmp5_ = _tmp4_->changed_mask;
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
		_tmp6_ = event;
		_tmp7_ = _tmp6_->new_window_state;
		self->priv->is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
	}
	result = FALSE;
	return result;
}


static gboolean nibbles_configure_event_cb (Nibbles* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gint tile_size = 0;
	gint ts_x = 0;
	gint ts_y = 0;
	GdkEventConfigure* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GdkEventConfigure* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GdkEventConfigure* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp8_ = 0;
	GdkEventConfigure* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gboolean _tmp15_ = FALSE;
	gint _tmp16_ = 0;
	NibblesGame* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->width;
	ts_x = _tmp1_ / NIBBLES_GAME_WIDTH;
	_tmp2_ = event;
	_tmp3_ = _tmp2_->height;
	ts_y = _tmp3_ / NIBBLES_GAME_HEIGHT;
	_tmp4_ = ts_x;
	_tmp5_ = event;
	_tmp6_ = _tmp5_->width;
	if ((_tmp4_ * NIBBLES_GAME_WIDTH) > _tmp6_) {
		gint _tmp7_ = 0;
		_tmp7_ = ts_x;
		ts_x = _tmp7_ - 1;
	}
	_tmp8_ = ts_y;
	_tmp9_ = event;
	_tmp10_ = _tmp9_->height;
	if ((_tmp8_ * NIBBLES_GAME_HEIGHT) > _tmp10_) {
		gint _tmp11_ = 0;
		_tmp11_ = ts_y;
		ts_y = _tmp11_ - 1;
	}
	_tmp12_ = ts_x;
	_tmp13_ = ts_y;
	_tmp14_ = MIN (_tmp12_, _tmp13_);
	tile_size = _tmp14_;
	_tmp16_ = tile_size;
	if (_tmp16_ == 0) {
		_tmp15_ = TRUE;
	} else {
		NibblesGame* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		_tmp17_ = self->priv->game;
		_tmp18_ = nibbles_game_get_tile_size (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp15_ = _tmp19_ == 0;
	}
	if (_tmp15_) {
		result = TRUE;
		return result;
	}
	_tmp20_ = self->priv->game;
	_tmp21_ = nibbles_game_get_tile_size (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = tile_size;
	if (_tmp22_ != _tmp23_) {
		NibblesView* _tmp24_ = NULL;
		ClutterActor* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		NibblesView* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		NibblesView* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		NibblesView* _tmp32_ = NULL;
		gint _tmp33_ = 0;
		NibblesGame* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		_tmp24_ = self->priv->view;
		_tmp25_ = gtk_clutter_embed_get_stage ((GtkClutterEmbed*) _tmp24_);
		_tmp26_ = tile_size;
		_tmp27_ = tile_size;
		clutter_actor_set_size (_tmp25_, (gfloat) (_tmp26_ * NIBBLES_GAME_WIDTH), (gfloat) (_tmp27_ * NIBBLES_GAME_HEIGHT));
		_tmp28_ = self->priv->view;
		_tmp29_ = tile_size;
		nibbles_view_board_rescale (_tmp28_, _tmp29_);
		_tmp30_ = self->priv->view;
		_tmp31_ = tile_size;
		nibbles_view_boni_rescale (_tmp30_, _tmp31_);
		_tmp32_ = self->priv->view;
		_tmp33_ = tile_size;
		nibbles_view_warps_rescale (_tmp32_, _tmp33_);
		{
			GeeLinkedList* _worm_list = NULL;
			NibblesGame* _tmp34_ = NULL;
			GeeLinkedList* _tmp35_ = NULL;
			GeeLinkedList* _tmp36_ = NULL;
			GeeLinkedList* _tmp37_ = NULL;
			gint _worm_size = 0;
			GeeLinkedList* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			gint _worm_index = 0;
			_tmp34_ = self->priv->game;
			_tmp35_ = nibbles_game_get_worms (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = _g_object_ref0 (_tmp36_);
			_worm_list = _tmp37_;
			_tmp38_ = _worm_list;
			_tmp39_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp38_);
			_tmp40_ = _tmp39_;
			_worm_size = _tmp40_;
			_worm_index = -1;
			while (TRUE) {
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
				Worm* worm = NULL;
				GeeLinkedList* _tmp44_ = NULL;
				gint _tmp45_ = 0;
				gpointer _tmp46_ = NULL;
				Worm* _tmp47_ = NULL;
				gint _tmp48_ = 0;
				_tmp41_ = _worm_index;
				_worm_index = _tmp41_ + 1;
				_tmp42_ = _worm_index;
				_tmp43_ = _worm_size;
				if (!(_tmp42_ < _tmp43_)) {
					break;
				}
				_tmp44_ = _worm_list;
				_tmp45_ = _worm_index;
				_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp44_, _tmp45_);
				worm = (Worm*) _tmp46_;
				_tmp47_ = worm;
				_tmp48_ = tile_size;
				g_signal_emit_by_name (_tmp47_, "rescaled", _tmp48_);
				_g_object_unref0 (worm);
			}
			_g_object_unref0 (_worm_list);
		}
		_tmp49_ = self->priv->game;
		_tmp50_ = tile_size;
		nibbles_game_set_tile_size (_tmp49_, _tmp50_);
	}
	result = FALSE;
	return result;
}


static void _scoreboard_update_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	scoreboard_update ((Scoreboard*) self);
}


static void nibbles_start_game_cb (Nibbles* self) {
	GSettings* _tmp0_ = NULL;
	NibblesGame* _tmp1_ = NULL;
	NibblesView* _tmp2_ = NULL;
	NibblesGame* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	NibblesView* _tmp6_ = NULL;
	Scoreboard* _tmp7_ = NULL;
	NibblesGame* _tmp39_ = NULL;
	NibblesView* _tmp40_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_settings_set_boolean (_tmp0_, "first-run", FALSE);
	_tmp1_ = self->priv->game;
	nibbles_game_reset (_tmp1_);
	_tmp2_ = self->priv->view;
	_tmp3_ = self->priv->game;
	_tmp4_ = nibbles_game_get_current_level (_tmp3_);
	_tmp5_ = _tmp4_;
	nibbles_view_new_level (_tmp2_, _tmp5_);
	_tmp6_ = self->priv->view;
	nibbles_view_connect_worm_signals (_tmp6_);
	_tmp7_ = self->priv->scoreboard;
	scoreboard_clear (_tmp7_);
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		GeeLinkedList* _tmp10_ = NULL;
		GeeLinkedList* _tmp11_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _worm_index = 0;
		_tmp8_ = self->priv->game;
		_tmp9_ = nibbles_game_get_worms (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		_worm_list = _tmp11_;
		_tmp12_ = _worm_list;
		_tmp13_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_worm_size = _tmp14_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gpointer _tmp20_ = NULL;
			gint color = 0;
			NibblesGame* _tmp21_ = NULL;
			GeeHashMap* _tmp22_ = NULL;
			GeeHashMap* _tmp23_ = NULL;
			Worm* _tmp24_ = NULL;
			gpointer _tmp25_ = NULL;
			WormProperties* _tmp26_ = NULL;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			Scoreboard* _tmp29_ = NULL;
			Worm* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			GdkPixbuf* _tmp34_ = NULL;
			Worm* _tmp35_ = NULL;
			Scoreboard* _tmp36_ = NULL;
			Worm* _tmp37_ = NULL;
			Scoreboard* _tmp38_ = NULL;
			_tmp15_ = _worm_index;
			_worm_index = _tmp15_ + 1;
			_tmp16_ = _worm_index;
			_tmp17_ = _worm_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _worm_list;
			_tmp19_ = _worm_index;
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp19_);
			worm = (Worm*) _tmp20_;
			_tmp21_ = self->priv->game;
			_tmp22_ = nibbles_game_get_worm_props (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = worm;
			_tmp25_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp23_, _tmp24_);
			_tmp26_ = (WormProperties*) _tmp25_;
			_tmp27_ = (*_tmp26_).color;
			_tmp28_ = _tmp27_;
			_worm_properties_free0 (_tmp26_);
			color = _tmp28_;
			_tmp29_ = self->priv->scoreboard;
			_tmp30_ = worm;
			_tmp31_ = color;
			_tmp32_ = nibbles_view_colorval_name (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = self->priv->scoreboard_life;
			scoreboard_register (_tmp29_, _tmp30_, _tmp33_, _tmp34_);
			_g_free0 (_tmp33_);
			_tmp35_ = worm;
			_tmp36_ = self->priv->scoreboard;
			g_signal_connect_object ((GObject*) _tmp35_, "notify::lives", (GCallback) _scoreboard_update_g_object_notify, _tmp36_, 0);
			_tmp37_ = worm;
			_tmp38_ = self->priv->scoreboard;
			g_signal_connect_object ((GObject*) _tmp37_, "notify::score", (GCallback) _scoreboard_update_g_object_notify, _tmp38_, 0);
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	_tmp39_ = self->priv->game;
	nibbles_game_add_worms (_tmp39_);
	_tmp40_ = self->priv->view;
	nibbles_view_create_name_labels (_tmp40_);
	nibbles_show_game_view (self);
	nibbles_start_game_with_countdown (self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Nibbles* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean __lambda7_ (Block1Data* _data1_) {
	Nibbles* self;
	gboolean result = FALSE;
	GtkLabel* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint _tmp15_ = 0;
	self = _data1_->self;
	_tmp0_ = self->priv->countdown;
	_tmp1_ = g_strdup_printf ("%i", _data1_->seconds);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	if (_data1_->seconds == 0) {
		GtkStack* _tmp3_ = NULL;
		NibblesView* _tmp4_ = NULL;
		ClutterActor* _tmp5_ = NULL;
		ClutterActor* _tmp6_ = NULL;
		GtkLabel* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		NibblesGame* _tmp10_ = NULL;
		NibblesGame* _tmp11_ = NULL;
		GSimpleAction* _tmp12_ = NULL;
		GSimpleAction* _tmp13_ = NULL;
		GSimpleAction* _tmp14_ = NULL;
		_tmp3_ = self->priv->statusbar_stack;
		gtk_stack_set_visible_child_name (_tmp3_, "scoreboard");
		_tmp4_ = self->priv->view;
		_tmp5_ = nibbles_view_get_name_labels (_tmp4_);
		_tmp6_ = _tmp5_;
		clutter_actor_hide (_tmp6_);
		_tmp7_ = self->priv->countdown;
		_tmp8_ = g_strdup_printf ("%i", NIBBLES_COUNTDOWN_TIME);
		_tmp9_ = _tmp8_;
		gtk_label_set_label (_tmp7_, _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = self->priv->game;
		nibbles_game_add_bonus (_tmp10_, TRUE);
		_tmp11_ = self->priv->game;
		nibbles_game_start (_tmp11_);
		_tmp12_ = self->priv->new_game_action;
		g_simple_action_set_enabled (_tmp12_, TRUE);
		_tmp13_ = self->priv->pause_action;
		g_simple_action_set_enabled (_tmp13_, TRUE);
		_tmp14_ = self->priv->back_action;
		g_simple_action_set_enabled (_tmp14_, TRUE);
		self->priv->countdown_id = (guint) 0;
		result = G_SOURCE_REMOVE;
		return result;
	}
	_tmp15_ = _data1_->seconds;
	_data1_->seconds = _tmp15_ - 1;
	result = G_SOURCE_CONTINUE;
	return result;
}


static gboolean ___lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda7_ (self);
	return result;
}


static void nibbles_start_game_with_countdown (Nibbles* self) {
	Block1Data* _data1_;
	GtkStack* _tmp0_ = NULL;
	NibblesView* _tmp1_ = NULL;
	ClutterActor* _tmp2_ = NULL;
	ClutterActor* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = self->priv->statusbar_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "countdown");
	_data1_->seconds = NIBBLES_COUNTDOWN_TIME;
	_tmp1_ = self->priv->view;
	_tmp2_ = nibbles_view_get_name_labels (_tmp1_);
	_tmp3_ = _tmp2_;
	clutter_actor_show (_tmp3_);
	_tmp4_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, ___lambda7__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	self->priv->countdown_id = _tmp4_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void nibbles_restart_game (Nibbles* self) {
	NibblesView* _tmp0_ = NULL;
	NibblesGame* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	NibblesGame* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = self->priv->game;
	_tmp2_ = nibbles_game_get_current_level (_tmp1_);
	_tmp3_ = _tmp2_;
	nibbles_view_new_level (_tmp0_, _tmp3_);
	_tmp4_ = self->priv->game;
	nibbles_game_add_worms (_tmp4_);
	nibbles_start_game_with_countdown (self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		Nibbles* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda8_ (Block2Data* _data2_, gint response_id) {
	Nibbles* self;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	self = _data2_->self;
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
		nibbles_show_new_game_screen_cb (self);
	}
	_tmp3_ = response_id;
	if (_tmp3_ == ((gint) GTK_RESPONSE_CANCEL)) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp4_ = 0;
		_tmp4_ = response_id;
		_tmp2_ = _tmp4_ == ((gint) GTK_RESPONSE_DELETE_EVENT);
	}
	if (_tmp2_) {
		NibblesGame* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = self->priv->game;
		_tmp6_ = nibbles_game_get_is_paused (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = !_tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		NibblesGame* _tmp8_ = NULL;
		NibblesView* _tmp9_ = NULL;
		_tmp8_ = self->priv->game;
		nibbles_game_start (_tmp8_);
		_tmp9_ = self->priv->view;
		gtk_widget_grab_focus ((GtkWidget*) _tmp9_);
	}
	gtk_widget_destroy ((GtkWidget*) _data2_->dialog);
}


static void ___lambda8__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda8_ (self, response_id);
}


static void nibbles_new_game_cb (Nibbles* self) {
	Block2Data* _data2_;
	NibblesGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkApplicationWindow* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkMessageDialog* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkButton* button = NULL;
	GtkWidget* _tmp8_ = NULL;
	GtkButton* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		NibblesGame* _tmp3_ = NULL;
		_tmp3_ = self->priv->game;
		nibbles_game_stop (_tmp3_);
	}
	_tmp4_ = self->priv->window;
	_tmp5_ = _ ("Are you sure you want to start a new game?");
	_tmp6_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp4_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK_CANCEL, _tmp5_);
	g_object_ref_sink (_tmp6_);
	_data2_->dialog = _tmp6_;
	_tmp7_ = _ ("If you start a new game, the current one will be lost.");
	g_object_set (_data2_->dialog, "secondary-text", _tmp7_, NULL);
	_tmp8_ = gtk_dialog_get_widget_for_response ((GtkDialog*) _data2_->dialog, (gint) GTK_RESPONSE_OK);
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_button_get_type (), GtkButton));
	button = _tmp9_;
	_tmp10_ = _ ("_New Game");
	gtk_button_set_label (button, _tmp10_);
	g_signal_connect_data ((GtkDialog*) _data2_->dialog, "response", (GCallback) ___lambda8__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data2_->dialog);
	_g_object_unref0 (button);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void nibbles_pause_cb (Nibbles* self) {
	NibblesGame* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		NibblesGame* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = self->priv->game;
		_tmp2_ = nibbles_game_get_is_running (_tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			NibblesGame* _tmp4_ = NULL;
			GtkButton* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			_tmp4_ = self->priv->game;
			nibbles_game_pause (_tmp4_);
			_tmp5_ = self->priv->pause_button;
			_tmp6_ = _ ("_Resume");
			gtk_button_set_label (_tmp5_, _tmp6_);
		} else {
			NibblesGame* _tmp7_ = NULL;
			GtkButton* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			NibblesView* _tmp10_ = NULL;
			_tmp7_ = self->priv->game;
			nibbles_game_unpause (_tmp7_);
			_tmp8_ = self->priv->pause_button;
			_tmp9_ = _ ("_Pause");
			gtk_button_set_label (_tmp8_, _tmp9_);
			_tmp10_ = self->priv->view;
			gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
		}
	}
}


static void nibbles_settings_changed_cb (Nibbles* self, const gchar* key) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("speed")))) {
		switch (0) {
			default:
			{
				NibblesGame* _tmp4_ = NULL;
				GSettings* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				_tmp4_ = self->priv->game;
				_tmp5_ = self->priv->settings;
				_tmp6_ = key;
				_tmp7_ = g_settings_get_int (_tmp5_, _tmp6_);
				nibbles_game_set_speed (_tmp4_, _tmp7_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("sound")))) {
		switch (0) {
			default:
			{
				NibblesView* _tmp8_ = NULL;
				GSettings* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				_tmp8_ = self->priv->view;
				_tmp9_ = self->priv->settings;
				_tmp10_ = key;
				_tmp11_ = g_settings_get_boolean (_tmp9_, _tmp10_);
				_tmp8_->is_muted = !_tmp11_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("fakes")))) {
		switch (0) {
			default:
			{
				NibblesGame* _tmp12_ = NULL;
				GSettings* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
				_tmp12_ = self->priv->game;
				_tmp13_ = self->priv->settings;
				_tmp14_ = key;
				_tmp15_ = g_settings_get_boolean (_tmp13_, _tmp14_);
				nibbles_game_set_fakes (_tmp12_, _tmp15_);
				break;
			}
		}
	}
}


static void nibbles_worm_settings_changed_cb (Nibbles* self, GSettings* changed_worm_settings, const gchar* key) {
	NibblesGame* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint id = 0;
	GeeArrayList* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	NibblesGame* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	Worm* worm = NULL;
	NibblesGame* _tmp12_ = NULL;
	GeeLinkedList* _tmp13_ = NULL;
	GeeLinkedList* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gpointer _tmp16_ = NULL;
	WormProperties* properties = NULL;
	NibblesGame* _tmp17_ = NULL;
	GeeHashMap* _tmp18_ = NULL;
	GeeHashMap* _tmp19_ = NULL;
	Worm* _tmp20_ = NULL;
	gpointer _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GQuark _tmp25_ = 0U;
	static GQuark _tmp24_label0 = 0;
	static GQuark _tmp24_label1 = 0;
	static GQuark _tmp24_label2 = 0;
	static GQuark _tmp24_label3 = 0;
	static GQuark _tmp24_label4 = 0;
	NibblesGame* _tmp43_ = NULL;
	GeeHashMap* _tmp44_ = NULL;
	GeeHashMap* _tmp45_ = NULL;
	Worm* _tmp46_ = NULL;
	WormProperties* _tmp47_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (changed_worm_settings != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_worm_props (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_map_get_size ((GeeMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		return;
	}
	_tmp5_ = self->priv->worm_settings;
	_tmp6_ = changed_worm_settings;
	_tmp7_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp5_, _tmp6_);
	id = _tmp7_;
	_tmp8_ = id;
	_tmp9_ = self->priv->game;
	_tmp10_ = nibbles_game_get_numworms (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp8_ >= _tmp11_) {
		return;
	}
	_tmp12_ = self->priv->game;
	_tmp13_ = nibbles_game_get_worms (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = id;
	_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _tmp15_);
	worm = (Worm*) _tmp16_;
	_tmp17_ = self->priv->game;
	_tmp18_ = nibbles_game_get_worm_props (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = worm;
	_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp19_, _tmp20_);
	properties = (WormProperties*) _tmp21_;
	_tmp22_ = key;
	_tmp23_ = _tmp22_;
	_tmp25_ = (NULL == _tmp23_) ? 0 : g_quark_from_string (_tmp23_);
	if (_tmp25_ == ((0 != _tmp24_label0) ? _tmp24_label0 : (_tmp24_label0 = g_quark_from_static_string ("color")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp26_ = NULL;
				GSettings* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				_tmp26_ = properties;
				_tmp27_ = changed_worm_settings;
				_tmp28_ = g_settings_get_string (_tmp27_, "color");
				_tmp29_ = _tmp28_;
				_tmp30_ = nibbles_view_colorval_from_name (_tmp29_);
				(*_tmp26_).color = _tmp30_;
				_g_free0 (_tmp29_);
				break;
			}
		}
	} else if (_tmp25_ == ((0 != _tmp24_label1) ? _tmp24_label1 : (_tmp24_label1 = g_quark_from_static_string ("key-up")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp31_ = NULL;
				GSettings* _tmp32_ = NULL;
				gint _tmp33_ = 0;
				_tmp31_ = properties;
				_tmp32_ = changed_worm_settings;
				_tmp33_ = g_settings_get_int (_tmp32_, "key-up");
				(*_tmp31_).up = (guint) _tmp33_;
				break;
			}
		}
	} else if (_tmp25_ == ((0 != _tmp24_label2) ? _tmp24_label2 : (_tmp24_label2 = g_quark_from_static_string ("key-down")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp34_ = NULL;
				GSettings* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				_tmp34_ = properties;
				_tmp35_ = changed_worm_settings;
				_tmp36_ = g_settings_get_int (_tmp35_, "key-down");
				(*_tmp34_).down = (guint) _tmp36_;
				break;
			}
		}
	} else if (_tmp25_ == ((0 != _tmp24_label3) ? _tmp24_label3 : (_tmp24_label3 = g_quark_from_static_string ("key-left")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp37_ = NULL;
				GSettings* _tmp38_ = NULL;
				gint _tmp39_ = 0;
				_tmp37_ = properties;
				_tmp38_ = changed_worm_settings;
				_tmp39_ = g_settings_get_int (_tmp38_, "key-left");
				(*_tmp37_).left = (guint) _tmp39_;
				break;
			}
		}
	} else if (_tmp25_ == ((0 != _tmp24_label4) ? _tmp24_label4 : (_tmp24_label4 = g_quark_from_static_string ("key-right")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp40_ = NULL;
				GSettings* _tmp41_ = NULL;
				gint _tmp42_ = 0;
				_tmp40_ = properties;
				_tmp41_ = changed_worm_settings;
				_tmp42_ = g_settings_get_int (_tmp41_, "key-right");
				(*_tmp40_).right = (guint) _tmp42_;
				break;
			}
		}
	}
	_tmp43_ = self->priv->game;
	_tmp44_ = nibbles_game_get_worm_props (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = worm;
	_tmp47_ = properties;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp45_, _tmp46_, _tmp47_);
	_worm_properties_free0 (properties);
	_g_object_unref0 (worm);
}


static void nibbles_show_first_run_screen (Nibbles* self) {
	GtkStack* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "first_run");
}


static void nibbles_show_new_game_screen_cb (Nibbles* self) {
	guint _tmp0_ = 0U;
	NibblesGame* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GtkHeaderBar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GSimpleAction* _tmp8_ = NULL;
	GSimpleAction* _tmp9_ = NULL;
	GSimpleAction* _tmp10_ = NULL;
	GtkButton* _tmp11_ = NULL;
	GtkButton* _tmp12_ = NULL;
	GtkStackTransitionType type = 0;
	GtkStack* _tmp13_ = NULL;
	GtkStackTransitionType _tmp14_ = 0;
	GtkStack* _tmp15_ = NULL;
	GtkStack* _tmp16_ = NULL;
	GtkStack* _tmp17_ = NULL;
	GeeLinkedList* _tmp18_ = NULL;
	NibblesGame* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gpointer _tmp22_ = NULL;
	GtkToggleButton* _tmp23_ = NULL;
	GeeLinkedList* _tmp24_ = NULL;
	NibblesGame* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gpointer _tmp28_ = NULL;
	GtkToggleButton* _tmp29_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->countdown_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->countdown_id;
		g_source_remove (_tmp1_);
		self->priv->countdown_id = (guint) 0;
	}
	_tmp2_ = self->priv->game;
	_tmp3_ = nibbles_game_get_is_running (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		NibblesGame* _tmp5_ = NULL;
		_tmp5_ = self->priv->game;
		nibbles_game_stop (_tmp5_);
	}
	_tmp6_ = self->priv->headerbar;
	_tmp7_ = _ ("Nibbles");
	gtk_header_bar_set_title (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp8_, FALSE);
	_tmp9_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp9_, FALSE);
	_tmp10_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp10_, TRUE);
	_tmp11_ = self->priv->new_game_button;
	gtk_widget_hide ((GtkWidget*) _tmp11_);
	_tmp12_ = self->priv->pause_button;
	gtk_widget_hide ((GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->main_stack;
	_tmp14_ = gtk_stack_get_transition_type (_tmp13_);
	type = _tmp14_;
	_tmp15_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp15_, GTK_STACK_TRANSITION_TYPE_NONE);
	_tmp16_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp16_, "number_of_players");
	_tmp17_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp17_, type);
	_tmp18_ = self->priv->number_of_players_buttons;
	_tmp19_ = self->priv->game;
	_tmp20_ = nibbles_game_get_numhumans (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp21_ - 1);
	_tmp23_ = (GtkToggleButton*) _tmp22_;
	gtk_toggle_button_set_active (_tmp23_, TRUE);
	_g_object_unref0 (_tmp23_);
	_tmp24_ = self->priv->number_of_ai_buttons;
	_tmp25_ = self->priv->game;
	_tmp26_ = nibbles_game_get_numai (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, _tmp27_);
	_tmp29_ = (GtkToggleButton*) _tmp28_;
	gtk_toggle_button_set_active (_tmp29_, TRUE);
	_g_object_unref0 (_tmp29_);
}


static void nibbles_show_controls_screen_cb (Nibbles* self) {
	NibblesGame* _tmp42_ = NULL;
	NibblesGame* _tmp43_ = NULL;
	GeeArrayList* _tmp44_ = NULL;
	GtkBox* _tmp45_ = NULL;
	GList* _tmp46_ = NULL;
	GtkStack* _tmp79_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _button_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _button_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _button_index = 0;
		_tmp0_ = self->priv->number_of_players_buttons;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_button_list = _tmp1_;
		_tmp2_ = _button_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_button_size = _tmp4_;
		_button_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GtkToggleButton* button = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			GtkToggleButton* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			_tmp5_ = _button_index;
			_button_index = _tmp5_ + 1;
			_tmp6_ = _button_index;
			_tmp7_ = _button_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _button_list;
			_tmp9_ = _button_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			button = (GtkToggleButton*) _tmp10_;
			_tmp11_ = button;
			_tmp12_ = gtk_toggle_button_get_active (_tmp11_);
			if (_tmp12_) {
				gint numhumans = 0;
				GtkToggleButton* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				NibblesGame* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				GSettings* _tmp17_ = NULL;
				NibblesGame* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				numhumans = -1;
				_tmp13_ = button;
				_tmp14_ = gtk_button_get_label ((GtkButton*) _tmp13_);
				sscanf (_tmp14_, "_%d", &numhumans);
				_tmp15_ = self->priv->game;
				_tmp16_ = numhumans;
				nibbles_game_set_numhumans (_tmp15_, _tmp16_);
				_tmp17_ = self->priv->settings;
				_tmp18_ = self->priv->game;
				_tmp19_ = nibbles_game_get_numhumans (_tmp18_);
				_tmp20_ = _tmp19_;
				g_settings_set_int (_tmp17_, "players", _tmp20_);
				_g_object_unref0 (button);
				break;
			}
			_g_object_unref0 (button);
		}
		_g_object_unref0 (_button_list);
	}
	{
		GeeLinkedList* _button_list = NULL;
		GeeLinkedList* _tmp21_ = NULL;
		GeeLinkedList* _tmp22_ = NULL;
		gint _button_size = 0;
		GeeLinkedList* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gint _button_index = 0;
		_tmp21_ = self->priv->number_of_ai_buttons;
		_tmp22_ = _g_object_ref0 (_tmp21_);
		_button_list = _tmp22_;
		_tmp23_ = _button_list;
		_tmp24_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_button_size = _tmp25_;
		_button_index = -1;
		while (TRUE) {
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			GtkToggleButton* button = NULL;
			GeeLinkedList* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gpointer _tmp31_ = NULL;
			GtkToggleButton* _tmp32_ = NULL;
			gboolean _tmp33_ = FALSE;
			_tmp26_ = _button_index;
			_button_index = _tmp26_ + 1;
			_tmp27_ = _button_index;
			_tmp28_ = _button_size;
			if (!(_tmp27_ < _tmp28_)) {
				break;
			}
			_tmp29_ = _button_list;
			_tmp30_ = _button_index;
			_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, _tmp30_);
			button = (GtkToggleButton*) _tmp31_;
			_tmp32_ = button;
			_tmp33_ = gtk_toggle_button_get_active (_tmp32_);
			if (_tmp33_) {
				gint numai = 0;
				GtkToggleButton* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				NibblesGame* _tmp36_ = NULL;
				gint _tmp37_ = 0;
				GSettings* _tmp38_ = NULL;
				NibblesGame* _tmp39_ = NULL;
				gint _tmp40_ = 0;
				gint _tmp41_ = 0;
				numai = -1;
				_tmp34_ = button;
				_tmp35_ = gtk_button_get_label ((GtkButton*) _tmp34_);
				sscanf (_tmp35_, "_%d", &numai);
				_tmp36_ = self->priv->game;
				_tmp37_ = numai;
				nibbles_game_set_numai (_tmp36_, _tmp37_);
				_tmp38_ = self->priv->settings;
				_tmp39_ = self->priv->game;
				_tmp40_ = nibbles_game_get_numai (_tmp39_);
				_tmp41_ = _tmp40_;
				g_settings_set_int (_tmp38_, "ai", _tmp41_);
				_g_object_unref0 (button);
				break;
			}
			_g_object_unref0 (button);
		}
		_g_object_unref0 (_button_list);
	}
	_tmp42_ = self->priv->game;
	nibbles_game_create_worms (_tmp42_);
	_tmp43_ = self->priv->game;
	_tmp44_ = self->priv->worm_settings;
	nibbles_game_load_worm_properties (_tmp43_, _tmp44_);
	_tmp45_ = self->priv->grids_box;
	_tmp46_ = gtk_container_get_children ((GtkContainer*) _tmp45_);
	{
		GList* grid_collection = NULL;
		GList* grid_it = NULL;
		grid_collection = _tmp46_;
		for (grid_it = grid_collection; grid_it != NULL; grid_it = grid_it->next) {
			GtkWidget* grid = NULL;
			grid = (GtkWidget*) grid_it->data;
			{
				GtkWidget* _tmp47_ = NULL;
				_tmp47_ = grid;
				gtk_widget_destroy (_tmp47_);
			}
		}
		_g_list_free0 (grid_collection);
	}
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp48_ = NULL;
		GeeLinkedList* _tmp49_ = NULL;
		GeeLinkedList* _tmp50_ = NULL;
		GeeLinkedList* _tmp51_ = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp52_ = NULL;
		gint _tmp53_ = 0;
		gint _tmp54_ = 0;
		gint _worm_index = 0;
		_tmp48_ = self->priv->game;
		_tmp49_ = nibbles_game_get_worms (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = _g_object_ref0 (_tmp50_);
		_worm_list = _tmp51_;
		_tmp52_ = _worm_list;
		_tmp53_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp52_);
		_tmp54_ = _tmp53_;
		_worm_size = _tmp54_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp55_ = 0;
			gint _tmp56_ = 0;
			gint _tmp57_ = 0;
			Worm* worm = NULL;
			GeeLinkedList* _tmp58_ = NULL;
			gint _tmp59_ = 0;
			gpointer _tmp60_ = NULL;
			Worm* _tmp61_ = NULL;
			gboolean _tmp62_ = FALSE;
			_tmp55_ = _worm_index;
			_worm_index = _tmp55_ + 1;
			_tmp56_ = _worm_index;
			_tmp57_ = _worm_size;
			if (!(_tmp56_ < _tmp57_)) {
				break;
			}
			_tmp58_ = _worm_list;
			_tmp59_ = _worm_index;
			_tmp60_ = gee_abstract_list_get ((GeeAbstractList*) _tmp58_, _tmp59_);
			worm = (Worm*) _tmp60_;
			_tmp61_ = worm;
			_tmp62_ = _tmp61_->is_human;
			if (_tmp62_) {
				ControlsGrid* grid = NULL;
				Worm* _tmp63_ = NULL;
				gint _tmp64_ = 0;
				gint _tmp65_ = 0;
				NibblesGame* _tmp66_ = NULL;
				GeeHashMap* _tmp67_ = NULL;
				GeeHashMap* _tmp68_ = NULL;
				Worm* _tmp69_ = NULL;
				gpointer _tmp70_ = NULL;
				WormProperties* _tmp71_ = NULL;
				GdkPixbuf* _tmp72_ = NULL;
				GdkPixbuf* _tmp73_ = NULL;
				WormProperties _tmp74_ = {0};
				ControlsGrid* _tmp75_ = NULL;
				ControlsGrid* _tmp76_ = NULL;
				GtkBox* _tmp77_ = NULL;
				ControlsGrid* _tmp78_ = NULL;
				_tmp63_ = worm;
				_tmp64_ = worm_get_id (_tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = self->priv->game;
				_tmp67_ = nibbles_game_get_worm_props (_tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = worm;
				_tmp70_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp68_, _tmp69_);
				_tmp71_ = (WormProperties*) _tmp70_;
				_tmp72_ = self->priv->arrow_pixbuf;
				_tmp73_ = self->priv->arrow_key_pixbuf;
				_tmp74_ = *_tmp71_;
				_tmp75_ = controls_grid_new (_tmp65_, &_tmp74_, _tmp72_, _tmp73_);
				g_object_ref_sink (_tmp75_);
				_tmp76_ = _tmp75_;
				_worm_properties_free0 (_tmp71_);
				grid = _tmp76_;
				_tmp77_ = self->priv->grids_box;
				_tmp78_ = grid;
				gtk_container_add ((GtkContainer*) _tmp77_, (GtkWidget*) _tmp78_);
				_g_object_unref0 (grid);
			}
			_g_object_unref0 (worm);
		}
		_g_object_unref0 (_worm_list);
	}
	_tmp79_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp79_, "controls");
}


static void nibbles_show_game_view (Nibbles* self) {
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	GtkHeaderBar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	NibblesGame* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GtkStack* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->new_game_button;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->pause_button;
	gtk_widget_show ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	_tmp3_ = self->priv->headerbar;
	_tmp4_ = _ ("Level %d");
	_tmp5_ = self->priv->game;
	_tmp6_ = nibbles_game_get_current_level (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf (_tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	gtk_header_bar_set_title (_tmp3_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp10_, "game_box");
}


static void nibbles_back_cb (Nibbles* self) {
	GtkStack* _tmp0_ = NULL;
	gchar* child_name = NULL;
	GtkStack* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	static GQuark _tmp6_label3 = 0;
	GtkStack* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp0_, GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN);
	_tmp1_ = self->priv->main_stack;
	_tmp2_ = gtk_stack_get_visible_child_name (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	child_name = _tmp3_;
	_tmp4_ = child_name;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("first_run")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("number_of_players")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("controls")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp8_ = NULL;
				_tmp8_ = self->priv->main_stack;
				gtk_stack_set_visible_child_name (_tmp8_, "number_of_players");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("game_box")))) {
		switch (0) {
			default:
			{
				nibbles_new_game_cb (self);
				break;
			}
		}
	}
	_tmp9_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp9_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
	_g_free0 (child_name);
}


static void nibbles_change_number_of_players_cb (Nibbles* self, GtkToggleButton* button) {
	GtkToggleButton* _tmp18_ = NULL;
	gint numhumans = 0;
	GtkToggleButton* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gint min_ai = 0;
	gint _tmp21_ = 0;
	gint max_ai = 0;
	gint _tmp22_ = 0;
	gint _tmp51_ = 0;
	GeeLinkedList* _tmp55_ = NULL;
	gint _tmp56_ = 0;
	gpointer _tmp57_ = NULL;
	GtkToggleButton* _tmp58_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	{
		GeeLinkedList* _other_button_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _other_button_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _other_button_index = 0;
		_tmp0_ = self->priv->number_of_players_buttons;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_other_button_list = _tmp1_;
		_tmp2_ = _other_button_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_other_button_size = _tmp4_;
		_other_button_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GtkToggleButton* other_button = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			GtkToggleButton* _tmp11_ = NULL;
			GtkToggleButton* _tmp12_ = NULL;
			_tmp5_ = _other_button_index;
			_other_button_index = _tmp5_ + 1;
			_tmp6_ = _other_button_index;
			_tmp7_ = _other_button_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _other_button_list;
			_tmp9_ = _other_button_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			other_button = (GtkToggleButton*) _tmp10_;
			_tmp11_ = button;
			_tmp12_ = other_button;
			if (_tmp11_ != _tmp12_) {
				GtkToggleButton* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				_tmp13_ = other_button;
				_tmp14_ = gtk_toggle_button_get_active (_tmp13_);
				if (_tmp14_) {
					GtkToggleButton* _tmp15_ = NULL;
					GtkToggleButton* _tmp16_ = NULL;
					GtkToggleButton* _tmp17_ = NULL;
					_tmp15_ = other_button;
					g_signal_handlers_block_matched (_tmp15_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
					_tmp16_ = other_button;
					gtk_toggle_button_set_active (_tmp16_, FALSE);
					_tmp17_ = other_button;
					g_signal_handlers_unblock_matched (_tmp17_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
					_g_object_unref0 (other_button);
					break;
				}
			}
			_g_object_unref0 (other_button);
		}
		_g_object_unref0 (_other_button_list);
	}
	_tmp18_ = button;
	gtk_toggle_button_set_active (_tmp18_, TRUE);
	numhumans = -1;
	_tmp19_ = button;
	_tmp20_ = gtk_button_get_label ((GtkButton*) _tmp19_);
	sscanf (_tmp20_, "_%d", &numhumans);
	_tmp21_ = numhumans;
	min_ai = 4 - _tmp21_;
	_tmp22_ = numhumans;
	max_ai = NIBBLES_GAME_MAX_WORMS - _tmp22_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp23_ = FALSE;
			_tmp23_ = TRUE;
			while (TRUE) {
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				GeeLinkedList* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				gpointer _tmp29_ = NULL;
				GtkToggleButton* _tmp30_ = NULL;
				if (!_tmp23_) {
					gint _tmp24_ = 0;
					_tmp24_ = i;
					i = _tmp24_ + 1;
				}
				_tmp23_ = FALSE;
				_tmp25_ = i;
				_tmp26_ = min_ai;
				if (!(_tmp25_ < _tmp26_)) {
					break;
				}
				_tmp27_ = self->priv->number_of_ai_buttons;
				_tmp28_ = i;
				_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, _tmp28_);
				_tmp30_ = (GtkToggleButton*) _tmp29_;
				gtk_widget_hide ((GtkWidget*) _tmp30_);
				_g_object_unref0 (_tmp30_);
			}
		}
	}
	{
		gint i = 0;
		gint _tmp31_ = 0;
		_tmp31_ = min_ai;
		i = _tmp31_;
		{
			gboolean _tmp32_ = FALSE;
			_tmp32_ = TRUE;
			while (TRUE) {
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				GeeLinkedList* _tmp36_ = NULL;
				gint _tmp37_ = 0;
				gpointer _tmp38_ = NULL;
				GtkToggleButton* _tmp39_ = NULL;
				if (!_tmp32_) {
					gint _tmp33_ = 0;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				_tmp34_ = i;
				_tmp35_ = max_ai;
				if (!(_tmp34_ <= _tmp35_)) {
					break;
				}
				_tmp36_ = self->priv->number_of_ai_buttons;
				_tmp37_ = i;
				_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, _tmp37_);
				_tmp39_ = (GtkToggleButton*) _tmp38_;
				gtk_widget_show ((GtkWidget*) _tmp39_);
				_g_object_unref0 (_tmp39_);
			}
		}
	}
	{
		gint i = 0;
		gint _tmp40_ = 0;
		_tmp40_ = max_ai;
		i = _tmp40_ + 1;
		{
			gboolean _tmp41_ = FALSE;
			_tmp41_ = TRUE;
			while (TRUE) {
				gint _tmp43_ = 0;
				GeeLinkedList* _tmp44_ = NULL;
				gint _tmp45_ = 0;
				gint _tmp46_ = 0;
				GeeLinkedList* _tmp47_ = NULL;
				gint _tmp48_ = 0;
				gpointer _tmp49_ = NULL;
				GtkToggleButton* _tmp50_ = NULL;
				if (!_tmp41_) {
					gint _tmp42_ = 0;
					_tmp42_ = i;
					i = _tmp42_ + 1;
				}
				_tmp41_ = FALSE;
				_tmp43_ = i;
				_tmp44_ = self->priv->number_of_ai_buttons;
				_tmp45_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp44_);
				_tmp46_ = _tmp45_;
				if (!(_tmp43_ < _tmp46_)) {
					break;
				}
				_tmp47_ = self->priv->number_of_ai_buttons;
				_tmp48_ = i;
				_tmp49_ = gee_abstract_list_get ((GeeAbstractList*) _tmp47_, _tmp48_);
				_tmp50_ = (GtkToggleButton*) _tmp49_;
				gtk_widget_hide ((GtkWidget*) _tmp50_);
				_g_object_unref0 (_tmp50_);
			}
		}
	}
	_tmp51_ = numhumans;
	if (_tmp51_ == 4) {
		GeeLinkedList* _tmp52_ = NULL;
		gpointer _tmp53_ = NULL;
		GtkToggleButton* _tmp54_ = NULL;
		_tmp52_ = self->priv->number_of_ai_buttons;
		_tmp53_ = gee_abstract_list_get ((GeeAbstractList*) _tmp52_, 0);
		_tmp54_ = (GtkToggleButton*) _tmp53_;
		gtk_widget_show ((GtkWidget*) _tmp54_);
		_g_object_unref0 (_tmp54_);
	}
	_tmp55_ = self->priv->number_of_ai_buttons;
	_tmp56_ = min_ai;
	_tmp57_ = gee_abstract_list_get ((GeeAbstractList*) _tmp55_, _tmp56_);
	_tmp58_ = (GtkToggleButton*) _tmp57_;
	gtk_toggle_button_set_active (_tmp58_, TRUE);
	_g_object_unref0 (_tmp58_);
}


static void nibbles_change_number_of_ai_cb (Nibbles* self, GtkToggleButton* button) {
	GtkToggleButton* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	{
		GeeLinkedList* _other_button_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _other_button_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _other_button_index = 0;
		_tmp0_ = self->priv->number_of_ai_buttons;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_other_button_list = _tmp1_;
		_tmp2_ = _other_button_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_other_button_size = _tmp4_;
		_other_button_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GtkToggleButton* other_button = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			GtkToggleButton* _tmp11_ = NULL;
			GtkToggleButton* _tmp12_ = NULL;
			_tmp5_ = _other_button_index;
			_other_button_index = _tmp5_ + 1;
			_tmp6_ = _other_button_index;
			_tmp7_ = _other_button_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _other_button_list;
			_tmp9_ = _other_button_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			other_button = (GtkToggleButton*) _tmp10_;
			_tmp11_ = button;
			_tmp12_ = other_button;
			if (_tmp11_ != _tmp12_) {
				GtkToggleButton* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				_tmp13_ = other_button;
				_tmp14_ = gtk_toggle_button_get_active (_tmp13_);
				if (_tmp14_) {
					GtkToggleButton* _tmp15_ = NULL;
					GtkToggleButton* _tmp16_ = NULL;
					GtkToggleButton* _tmp17_ = NULL;
					_tmp15_ = other_button;
					g_signal_handlers_block_matched (_tmp15_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
					_tmp16_ = other_button;
					gtk_toggle_button_set_active (_tmp16_, FALSE);
					_tmp17_ = other_button;
					g_signal_handlers_unblock_matched (_tmp17_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
					_g_object_unref0 (other_button);
					break;
				}
			}
			_g_object_unref0 (other_button);
		}
		_g_object_unref0 (_other_button_list);
	}
	_tmp18_ = button;
	gtk_toggle_button_set_active (_tmp18_, TRUE);
}


static GamesScoresCategory* nibbles_category_request (Nibbles* self, const gchar* key) {
	GamesScoresCategory* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		GeeLinkedList* _cat_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _cat_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _cat_index = 0;
		_tmp0_ = self->priv->scorecats;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_cat_list = _tmp1_;
		_tmp2_ = _cat_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_cat_size = _tmp4_;
		_cat_index = -1;
		while (TRUE) {
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			GamesScoresCategory* cat = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			GamesScoresCategory* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			_tmp5_ = _cat_index;
			_cat_index = _tmp5_ + 1;
			_tmp6_ = _cat_index;
			_tmp7_ = _cat_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _cat_list;
			_tmp9_ = _cat_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			cat = (GamesScoresCategory*) _tmp10_;
			_tmp11_ = key;
			_tmp12_ = cat;
			_tmp13_ = games_scores_category_get_key (_tmp12_);
			_tmp14_ = _tmp13_;
			if (g_strcmp0 (_tmp11_, _tmp14_) == 0) {
				result = cat;
				_g_object_unref0 (_cat_list);
				return result;
			}
			_g_object_unref0 (cat);
		}
		_g_object_unref0 (_cat_list);
	}
	result = NULL;
	return result;
}


static gchar* nibbles_get_new_scores_key (Nibbles* self, const gchar* old_key) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old_key != NULL, NULL);
	_tmp0_ = old_key;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("1.0")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_ = NULL;
				_tmp4_ = g_strdup ("fast");
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("2.0")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_ = NULL;
				_tmp5_ = g_strdup ("medium");
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("3.0")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_ = NULL;
				_tmp6_ = g_strdup ("slow");
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("4.0")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_ = NULL;
				_tmp7_ = g_strdup ("beginner");
				result = _tmp7_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("1.1")))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_ = NULL;
				_tmp8_ = g_strdup ("fast-fakes");
				result = _tmp8_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("2.1")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_ = NULL;
				_tmp9_ = g_strdup ("medium-fakes");
				result = _tmp9_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("3.1")))) {
		switch (0) {
			default:
			{
				gchar* _tmp10_ = NULL;
				_tmp10_ = g_strdup ("slow-fakes");
				result = _tmp10_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("4.1")))) {
		switch (0) {
			default:
			{
				gchar* _tmp11_ = NULL;
				_tmp11_ = g_strdup ("beginner-fakes");
				result = _tmp11_;
				return result;
			}
		}
	}
	result = NULL;
	return result;
}


static GamesScoresCategory* _nibbles_category_request_games_scores_context_category_request_func (const gchar* category_key, gpointer self) {
	GamesScoresCategory* result;
	result = nibbles_category_request ((Nibbles*) self, category_key);
	return result;
}


static gchar* _nibbles_get_new_scores_key_games_scores_directory_importer_category_convert_func (const gchar* old_key, gpointer self) {
	gchar* result;
	result = nibbles_get_new_scores_key ((Nibbles*) self, old_key);
	return result;
}


static void nibbles_create_scores (Nibbles* self) {
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GamesScoresCategory* _tmp3_ = NULL;
	GamesScoresCategory* _tmp4_ = NULL;
	GeeLinkedList* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GamesScoresCategory* _tmp7_ = NULL;
	GamesScoresCategory* _tmp8_ = NULL;
	GeeLinkedList* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GamesScoresCategory* _tmp11_ = NULL;
	GamesScoresCategory* _tmp12_ = NULL;
	GeeLinkedList* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GamesScoresCategory* _tmp15_ = NULL;
	GamesScoresCategory* _tmp16_ = NULL;
	GeeLinkedList* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GamesScoresCategory* _tmp19_ = NULL;
	GamesScoresCategory* _tmp20_ = NULL;
	GeeLinkedList* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	GamesScoresCategory* _tmp23_ = NULL;
	GamesScoresCategory* _tmp24_ = NULL;
	GeeLinkedList* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	GamesScoresCategory* _tmp27_ = NULL;
	GamesScoresCategory* _tmp28_ = NULL;
	GeeLinkedList* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	GamesScoresCategory* _tmp31_ = NULL;
	GamesScoresCategory* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	GtkApplicationWindow* _tmp34_ = NULL;
	GamesScoresDirectoryImporter* _tmp35_ = NULL;
	GamesScoresDirectoryImporter* _tmp36_ = NULL;
	GamesScoresContext* _tmp37_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_linked_list_new (GAMES_SCORES_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->scorecats);
	self->priv->scorecats = _tmp0_;
	_tmp1_ = self->priv->scorecats;
	_tmp2_ = _ ("Beginner");
	_tmp3_ = games_scores_category_new ("beginner", _tmp2_);
	_tmp4_ = _tmp3_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->priv->scorecats;
	_tmp6_ = _ ("Slow");
	_tmp7_ = games_scores_category_new ("slow", _tmp6_);
	_tmp8_ = _tmp7_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = self->priv->scorecats;
	_tmp10_ = _ ("Medium");
	_tmp11_ = games_scores_category_new ("medium", _tmp10_);
	_tmp12_ = _tmp11_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = self->priv->scorecats;
	_tmp14_ = _ ("Fast");
	_tmp15_ = games_scores_category_new ("fast", _tmp14_);
	_tmp16_ = _tmp15_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp16_);
	_g_object_unref0 (_tmp16_);
	_tmp17_ = self->priv->scorecats;
	_tmp18_ = _ ("Beginner with Fakes");
	_tmp19_ = games_scores_category_new ("beginner-fakes", _tmp18_);
	_tmp20_ = _tmp19_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp20_);
	_g_object_unref0 (_tmp20_);
	_tmp21_ = self->priv->scorecats;
	_tmp22_ = _ ("Slow with Fakes");
	_tmp23_ = games_scores_category_new ("slow-fakes", _tmp22_);
	_tmp24_ = _tmp23_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp24_);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = self->priv->scorecats;
	_tmp26_ = _ ("Medium with Fakes");
	_tmp27_ = games_scores_category_new ("medium-fakes", _tmp26_);
	_tmp28_ = _tmp27_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp28_);
	_g_object_unref0 (_tmp28_);
	_tmp29_ = self->priv->scorecats;
	_tmp30_ = _ ("Fast with Fakes");
	_tmp31_ = games_scores_category_new ("fast-fakes", _tmp30_);
	_tmp32_ = _tmp31_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, _tmp32_);
	_g_object_unref0 (_tmp32_);
	_tmp33_ = _ ("Difficulty Level:");
	_tmp34_ = self->priv->window;
	_tmp35_ = games_scores_directory_importer_new_with_convert_func (_nibbles_get_new_scores_key_games_scores_directory_importer_category_convert_func, self);
	_tmp36_ = _tmp35_;
	_tmp37_ = games_scores_context_new_with_importer ("gnome-nibbles", _tmp33_, (GtkWindow*) _tmp34_, _nibbles_category_request_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, (GamesScoresImporter*) _tmp36_);
	_g_object_unref0 (self->priv->scores_context);
	self->priv->scores_context = _tmp37_;
	_g_object_unref0 (_tmp36_);
}


static GamesScoresCategory* nibbles_get_scores_category (Nibbles* self, gint speed, gboolean fakes) {
	GamesScoresCategory* result = NULL;
	gchar* key = NULL;
	gint _tmp0_ = 0;
	gboolean _tmp5_ = FALSE;
	GeeLinkedList* _tmp23_ = NULL;
	gpointer _tmp24_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	key = NULL;
	_tmp0_ = speed;
	switch (_tmp0_) {
		case 1:
		{
			gchar* _tmp1_ = NULL;
			_tmp1_ = g_strdup ("fast");
			_g_free0 (key);
			key = _tmp1_;
			break;
		}
		case 2:
		{
			gchar* _tmp2_ = NULL;
			_tmp2_ = g_strdup ("medium");
			_g_free0 (key);
			key = _tmp2_;
			break;
		}
		case 3:
		{
			gchar* _tmp3_ = NULL;
			_tmp3_ = g_strdup ("slow");
			_g_free0 (key);
			key = _tmp3_;
			break;
		}
		case 4:
		{
			gchar* _tmp4_ = NULL;
			_tmp4_ = g_strdup ("beginner");
			_g_free0 (key);
			key = _tmp4_;
			break;
		}
		default:
		break;
	}
	_tmp5_ = fakes;
	if (_tmp5_) {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp6_ = key;
		_tmp7_ = g_strconcat (_tmp6_, "-fakes", NULL);
		_g_free0 (key);
		key = _tmp7_;
	}
	{
		GeeLinkedList* _cat_list = NULL;
		GeeLinkedList* _tmp8_ = NULL;
		GeeLinkedList* _tmp9_ = NULL;
		gint _cat_size = 0;
		GeeLinkedList* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _cat_index = 0;
		_tmp8_ = self->priv->scorecats;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_cat_list = _tmp9_;
		_tmp10_ = _cat_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_cat_size = _tmp12_;
		_cat_index = -1;
		while (TRUE) {
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			GamesScoresCategory* cat = NULL;
			GeeLinkedList* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gpointer _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			GamesScoresCategory* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			_tmp13_ = _cat_index;
			_cat_index = _tmp13_ + 1;
			_tmp14_ = _cat_index;
			_tmp15_ = _cat_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _cat_list;
			_tmp17_ = _cat_index;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _tmp17_);
			cat = (GamesScoresCategory*) _tmp18_;
			_tmp19_ = key;
			_tmp20_ = cat;
			_tmp21_ = games_scores_category_get_key (_tmp20_);
			_tmp22_ = _tmp21_;
			if (g_strcmp0 (_tmp19_, _tmp22_) == 0) {
				result = cat;
				_g_object_unref0 (_cat_list);
				_g_free0 (key);
				return result;
			}
			_g_object_unref0 (cat);
		}
		_g_object_unref0 (_cat_list);
	}
	_tmp23_ = self->priv->scorecats;
	_tmp24_ = gee_linked_list_first (_tmp23_);
	result = (GamesScoresCategory*) _tmp24_;
	_g_free0 (key);
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		Nibbles* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda11_ (Block3Data* _data3_, GObject* object, GAsyncResult* _result_) {
	Nibbles* self;
	gint _tmp4_ = 0;
	glong _tmp5_ = 0L;
	gint _tmp6_ = 0;
	GError * _inner_error_ = NULL;
	self = _data3_->self;
	g_return_if_fail (_result_ != NULL);
	{
		GamesScoresContext* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = self->priv->scores_context;
		_tmp1_ = _result_;
		games_scores_context_add_score_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("gnome-nibbles.vala:809: Failed to add score: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = _data3_->score;
	_tmp5_ = _data3_->lowest_high_score;
	_tmp6_ = _data3_->level_reached;
	nibbles_game_over (self, _tmp4_, _tmp5_, _tmp6_);
}


static void ___lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda11_ (self, source_object, res);
	block3_data_unref (self);
}


static void nibbles_log_score_cb (Nibbles* self, gint score, gint level_reached) {
	Block3Data* _data3_;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GSimpleAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GeeList* scores = NULL;
	GamesScoresContext* _tmp4_ = NULL;
	NibblesGame* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	NibblesGame* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	GamesScoresCategory* _tmp11_ = NULL;
	GamesScoresCategory* _tmp12_ = NULL;
	GeeList* _tmp13_ = NULL;
	GeeList* _tmp14_ = NULL;
	glong _tmp15_ = 0L;
	GeeList* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	NibblesGame* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	NibblesGame* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	GamesScoresContext* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	NibblesGame* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	NibblesGame* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_ = FALSE;
	GamesScoresCategory* _tmp44_ = NULL;
	GamesScoresCategory* _tmp45_ = NULL;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = score;
	_data3_->score = _tmp0_;
	_tmp1_ = level_reached;
	_data3_->level_reached = _tmp1_;
	_tmp2_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	_tmp3_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp3_, FALSE);
	_tmp4_ = self->priv->scores_context;
	_tmp5_ = self->priv->game;
	_tmp6_ = nibbles_game_get_speed (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->game;
	_tmp9_ = nibbles_game_get_fakes (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = nibbles_get_scores_category (self, _tmp7_, _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = games_scores_context_get_high_scores (_tmp4_, _tmp12_, 10);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (_tmp12_);
	scores = _tmp14_;
	_tmp16_ = scores;
	_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_ == 10) {
		GeeList* _tmp19_ = NULL;
		gpointer _tmp20_ = NULL;
		GamesScoresScore* _tmp21_ = NULL;
		glong _tmp22_ = 0L;
		glong _tmp23_ = 0L;
		_tmp19_ = scores;
		_tmp20_ = gee_list_last (_tmp19_);
		_tmp21_ = (GamesScoresScore*) _tmp20_;
		_tmp22_ = games_scores_score_get_score (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp15_ = _tmp23_;
		_g_object_unref0 (_tmp21_);
	} else {
		_tmp15_ = (glong) -1;
	}
	_data3_->lowest_high_score = _tmp15_;
	_tmp24_ = self->priv->game;
	_tmp25_ = nibbles_game_get_numhumans (_tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ != 1) {
		gint _tmp27_ = 0;
		glong _tmp28_ = 0L;
		gint _tmp29_ = 0;
		_tmp27_ = _data3_->score;
		_tmp28_ = _data3_->lowest_high_score;
		_tmp29_ = _data3_->level_reached;
		nibbles_game_over (self, _tmp27_, _tmp28_, _tmp29_);
		_g_object_unref0 (scores);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_tmp30_ = self->priv->game;
	_tmp31_ = nibbles_game_get_start_level (_tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_ != 1) {
		gint _tmp33_ = 0;
		glong _tmp34_ = 0L;
		gint _tmp35_ = 0;
		_tmp33_ = _data3_->score;
		_tmp34_ = _data3_->lowest_high_score;
		_tmp35_ = _data3_->level_reached;
		nibbles_game_over (self, _tmp33_, _tmp34_, _tmp35_);
		_g_object_unref0 (scores);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_tmp36_ = self->priv->scores_context;
	_tmp37_ = _data3_->score;
	_tmp38_ = self->priv->game;
	_tmp39_ = nibbles_game_get_speed (_tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = self->priv->game;
	_tmp42_ = nibbles_game_get_fakes (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = nibbles_get_scores_category (self, _tmp40_, _tmp43_);
	_tmp45_ = _tmp44_;
	games_scores_context_add_score (_tmp36_, (glong) _tmp37_, _tmp45_, NULL, ___lambda11__gasync_ready_callback, block3_data_ref (_data3_));
	_g_object_unref0 (_tmp45_);
	_g_object_unref0 (scores);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void nibbles_scores_cb (Nibbles* self) {
	gboolean should_unpause = FALSE;
	NibblesGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GamesScoresContext* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	should_unpause = FALSE;
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSimpleAction* _tmp3_ = NULL;
		_tmp3_ = self->priv->pause_action;
		g_signal_emit_by_name (_tmp3_, "activate", NULL);
		should_unpause = TRUE;
	}
	_tmp4_ = self->priv->scores_context;
	games_scores_context_run_dialog (_tmp4_);
	_tmp5_ = should_unpause;
	if (_tmp5_) {
		GSimpleAction* _tmp6_ = NULL;
		_tmp6_ = self->priv->pause_action;
		g_signal_emit_by_name (_tmp6_, "activate", NULL);
	}
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		Nibbles* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->button);
		_g_object_unref0 (_data4_->label);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void __lambda12_ (Block4Data* _data4_) {
	Nibbles* self;
	GtkLabel* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GtkHeaderBar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	NibblesGame* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	self = _data4_->self;
	_tmp0_ = _data4_->label;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	_tmp1_ = _data4_->button;
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp2_, TRUE);
	_tmp3_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp3_, TRUE);
	_tmp4_ = self->priv->headerbar;
	_tmp5_ = _ ("Level %d");
	_tmp6_ = self->priv->game;
	_tmp7_ = nibbles_game_get_current_level (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf (_tmp5_, _tmp8_);
	_tmp10_ = _tmp9_;
	gtk_header_bar_set_title (_tmp4_, _tmp10_);
	_g_free0 (_tmp10_);
	nibbles_restart_game (self);
}


static void ___lambda12__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda12_ (self);
}


static gboolean __lambda13_ (Block4Data* _data4_) {
	Nibbles* self;
	gboolean result = FALSE;
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	self = _data4_->self;
	_tmp0_ = _data4_->button;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = _data4_->button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ___lambda13__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda13_ (self);
	return result;
}


static void nibbles_level_completed_cb (Nibbles* self) {
	Block4Data* _data4_;
	NibblesGame* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSimpleAction* _tmp3_ = NULL;
	GSimpleAction* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	NibblesGame* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkStyleContext* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GtkButton* _tmp20_ = NULL;
	GtkButton* _tmp21_ = NULL;
	GtkButton* _tmp22_ = NULL;
	GtkButton* _tmp23_ = NULL;
	GtkButton* _tmp24_ = NULL;
	GtkButton* _tmp25_ = NULL;
	GtkStyleContext* _tmp26_ = NULL;
	GtkButton* _tmp27_ = NULL;
	GtkOverlay* _tmp28_ = NULL;
	GtkLabel* _tmp29_ = NULL;
	GtkOverlay* _tmp30_ = NULL;
	GtkButton* _tmp31_ = NULL;
	GtkOverlay* _tmp32_ = NULL;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_current_level (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NIBBLES_GAME_MAX_LEVEL) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_tmp3_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp3_, FALSE);
	_tmp4_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp4_, FALSE);
	_tmp5_ = _ ("Level %d Completed!");
	_tmp6_ = self->priv->game;
	_tmp7_ = nibbles_game_get_current_level (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf (_tmp5_, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = (GtkLabel*) gtk_label_new (_tmp10_);
	g_object_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	_data4_->label = _tmp12_;
	_tmp13_ = _data4_->label;
	gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_CENTER);
	_tmp14_ = _data4_->label;
	gtk_widget_set_valign ((GtkWidget*) _tmp14_, GTK_ALIGN_START);
	_tmp15_ = _data4_->label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp15_, 150);
	_tmp16_ = _data4_->label;
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) _tmp16_);
	gtk_style_context_add_class (_tmp17_, "menu-title");
	_tmp18_ = _data4_->label;
	gtk_widget_show ((GtkWidget*) _tmp18_);
	_tmp19_ = _ ("_Next Level");
	_tmp20_ = (GtkButton*) gtk_button_new_with_label (_tmp19_);
	g_object_ref_sink (_tmp20_);
	_data4_->button = _tmp20_;
	_tmp21_ = _data4_->button;
	gtk_button_set_use_underline (_tmp21_, TRUE);
	_tmp22_ = _data4_->button;
	gtk_widget_set_halign ((GtkWidget*) _tmp22_, GTK_ALIGN_CENTER);
	_tmp23_ = _data4_->button;
	gtk_widget_set_valign ((GtkWidget*) _tmp23_, GTK_ALIGN_END);
	_tmp24_ = _data4_->button;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp24_, 100);
	_tmp25_ = _data4_->button;
	_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) _tmp25_);
	gtk_style_context_add_class (_tmp26_, "suggested-action");
	_tmp27_ = _data4_->button;
	g_signal_connect_data (_tmp27_, "clicked", (GCallback) ___lambda12__gtk_button_clicked, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp28_ = self->priv->overlay;
	_tmp29_ = _data4_->label;
	gtk_overlay_add_overlay (_tmp28_, (GtkWidget*) _tmp29_);
	_tmp30_ = self->priv->overlay;
	_tmp31_ = _data4_->button;
	gtk_overlay_add_overlay (_tmp30_, (GtkWidget*) _tmp31_);
	_tmp32_ = self->priv->overlay;
	gtk_widget_show ((GtkWidget*) _tmp32_);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda13__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		Nibbles* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void __lambda9_ (Block5Data* _data5_) {
	Nibbles* self;
	gboolean _tmp0_ = FALSE;
	self = _data5_->self;
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = NULL;
	_tmp0_ = _data5_->should_unpause;
	if (_tmp0_) {
		GSimpleAction* _tmp1_ = NULL;
		_tmp1_ = self->priv->pause_action;
		g_signal_emit_by_name (_tmp1_, "activate", NULL);
	}
}


static void ___lambda9__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	__lambda9_ (self);
}


static void nibbles_preferences_cb (Nibbles* self) {
	Block5Data* _data5_;
	NibblesGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	PreferencesDialog* _tmp4_ = NULL;
	GtkApplicationWindow* _tmp8_ = NULL;
	GSettings* _tmp9_ = NULL;
	GeeArrayList* _tmp10_ = NULL;
	PreferencesDialog* _tmp11_ = NULL;
	PreferencesDialog* _tmp12_ = NULL;
	PreferencesDialog* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->should_unpause = FALSE;
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSimpleAction* _tmp3_ = NULL;
		_tmp3_ = self->priv->pause_action;
		g_signal_emit_by_name (_tmp3_, "activate", NULL);
		_data5_->should_unpause = TRUE;
	}
	_tmp4_ = self->priv->preferences_dialog;
	if (_tmp4_ != NULL) {
		PreferencesDialog* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = self->priv->preferences_dialog;
		gtk_window_present ((GtkWindow*) _tmp5_);
		_tmp6_ = _data5_->should_unpause;
		if (_tmp6_) {
			GSimpleAction* _tmp7_ = NULL;
			_tmp7_ = self->priv->pause_action;
			g_signal_emit_by_name (_tmp7_, "activate", NULL);
		}
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_tmp8_ = self->priv->window;
	_tmp9_ = self->priv->settings;
	_tmp10_ = self->priv->worm_settings;
	_tmp11_ = preferences_dialog_new (_tmp8_, _tmp9_, _tmp10_);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = _tmp11_;
	_tmp12_ = self->priv->preferences_dialog;
	g_signal_connect_data ((GtkWidget*) _tmp12_, "destroy", (GCallback) ___lambda9__gtk_widget_destroy, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp13_ = self->priv->preferences_dialog;
	gtk_dialog_run ((GtkDialog*) _tmp13_);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		Nibbles* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->button);
		_g_object_unref0 (_data6_->points_left_label);
		_g_object_unref0 (_data6_->score_label);
		_g_object_unref0 (_data6_->msg_label);
		_g_object_unref0 (_data6_->game_over_label);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void __lambda10_ (Block6Data* _data6_) {
	Nibbles* self;
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_ = NULL;
	GtkButton* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GSimpleAction* _tmp5_ = NULL;
	GSimpleAction* _tmp6_ = NULL;
	self = _data6_->self;
	_tmp0_ = _data6_->game_over_label;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	_tmp1_ = _data6_->score_label;
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
	_tmp2_ = _data6_->points_left_label;
	gtk_widget_destroy ((GtkWidget*) _tmp2_);
	_tmp3_ = _data6_->button;
	gtk_widget_destroy ((GtkWidget*) _tmp3_);
	_tmp4_ = _data6_->msg_label;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp5_, TRUE);
	_tmp6_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp6_, TRUE);
	nibbles_show_new_game_screen_cb (self);
}


static void ___lambda10__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda10_ (self);
}


static void nibbles_game_over (Nibbles* self, gint score, glong lowest_high_score, gint level_reached) {
	Block6Data* _data6_;
	gboolean is_high_score = FALSE;
	gint _tmp0_ = 0;
	glong _tmp1_ = 0L;
	gboolean is_game_won = FALSE;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkStyleContext* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	GtkLabel* _tmp20_ = NULL;
	GtkStyleContext* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	gchar* score_string = NULL;
	gint _tmp23_ = 0;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	const gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	GtkLabel* _tmp37_ = NULL;
	GtkLabel* _tmp38_ = NULL;
	GtkLabel* _tmp39_ = NULL;
	GtkLabel* _tmp40_ = NULL;
	GtkLabel* _tmp41_ = NULL;
	GtkLabel* _tmp42_ = NULL;
	gint _tmp43_ = 0;
	GtkLabel* _tmp44_ = NULL;
	glong points_left = 0L;
	glong _tmp45_ = 0L;
	gint _tmp46_ = 0;
	const gchar* _tmp47_ = NULL;
	glong _tmp48_ = 0L;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	GtkLabel* _tmp51_ = NULL;
	GtkLabel* _tmp52_ = NULL;
	GtkLabel* _tmp53_ = NULL;
	GtkLabel* _tmp54_ = NULL;
	GtkLabel* _tmp55_ = NULL;
	gint _tmp56_ = 0;
	GtkLabel* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	GtkButton* _tmp59_ = NULL;
	GtkButton* _tmp60_ = NULL;
	GtkButton* _tmp61_ = NULL;
	GtkButton* _tmp62_ = NULL;
	GtkButton* _tmp63_ = NULL;
	GtkButton* _tmp64_ = NULL;
	GtkStyleContext* _tmp65_ = NULL;
	GtkButton* _tmp66_ = NULL;
	GtkButton* _tmp67_ = NULL;
	GtkOverlay* _tmp68_ = NULL;
	GtkLabel* _tmp69_ = NULL;
	gboolean _tmp70_ = FALSE;
	NibblesGame* _tmp73_ = NULL;
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	gboolean _tmp78_ = FALSE;
	NibblesGame* _tmp79_ = NULL;
	gint _tmp80_ = 0;
	gint _tmp81_ = 0;
	GtkOverlay* _tmp85_ = NULL;
	GtkButton* _tmp86_ = NULL;
	GtkButton* _tmp87_ = NULL;
	GtkOverlay* _tmp88_ = NULL;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = score;
	_tmp1_ = lowest_high_score;
	is_high_score = ((glong) _tmp0_) > _tmp1_;
	_tmp2_ = level_reached;
	is_game_won = _tmp2_ == (NIBBLES_GAME_MAX_LEVEL + 1);
	_tmp4_ = is_game_won;
	if (_tmp4_) {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = _ ("Congratulations!");
		_tmp3_ = _tmp5_;
	} else {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = _ ("Game Over!");
		_tmp3_ = _tmp6_;
	}
	_tmp7_ = (GtkLabel*) gtk_label_new (_tmp3_);
	g_object_ref_sink (_tmp7_);
	_data6_->game_over_label = _tmp7_;
	_tmp8_ = _data6_->game_over_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp8_, GTK_ALIGN_CENTER);
	_tmp9_ = _data6_->game_over_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp9_, GTK_ALIGN_START);
	_tmp10_ = _data6_->game_over_label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp10_, 150);
	_tmp11_ = _data6_->game_over_label;
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) _tmp11_);
	gtk_style_context_add_class (_tmp12_, "menu-title");
	_tmp13_ = _data6_->game_over_label;
	gtk_widget_show ((GtkWidget*) _tmp13_);
	_tmp14_ = _ ("You have completed the game.");
	_tmp15_ = (GtkLabel*) gtk_label_new (_tmp14_);
	g_object_ref_sink (_tmp15_);
	_data6_->msg_label = _tmp15_;
	_tmp16_ = _data6_->msg_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp16_, GTK_ALIGN_CENTER);
	_tmp17_ = _data6_->msg_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp17_, GTK_ALIGN_START);
	_tmp18_ = _data6_->msg_label;
	_tmp19_ = self->priv->window_height;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp18_, _tmp19_ / 3);
	_tmp20_ = _data6_->msg_label;
	_tmp21_ = gtk_widget_get_style_context ((GtkWidget*) _tmp20_);
	gtk_style_context_add_class (_tmp21_, "menu-title");
	_tmp22_ = _data6_->msg_label;
	gtk_widget_show ((GtkWidget*) _tmp22_);
	_tmp23_ = score;
	_tmp24_ = g_strdup_printf ("%d Point", _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = score;
	_tmp27_ = g_strdup_printf ("%d Points", _tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = score;
	_tmp30_ = ngettext (_tmp25_, _tmp28_, (gulong) _tmp29_);
	_tmp31_ = g_strdup (_tmp30_);
	_tmp32_ = _tmp31_;
	_g_free0 (_tmp28_);
	_g_free0 (_tmp25_);
	score_string = _tmp32_;
	_tmp33_ = score_string;
	_tmp34_ = string_to_string (_tmp33_);
	_tmp35_ = g_strconcat ("<b>", _tmp34_, "</b>", NULL);
	_tmp36_ = _tmp35_;
	_tmp37_ = (GtkLabel*) gtk_label_new (_tmp36_);
	g_object_ref_sink (_tmp37_);
	_tmp38_ = _tmp37_;
	_g_free0 (_tmp36_);
	_data6_->score_label = _tmp38_;
	_tmp39_ = _data6_->score_label;
	gtk_label_set_use_markup (_tmp39_, TRUE);
	_tmp40_ = _data6_->score_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp40_, GTK_ALIGN_CENTER);
	_tmp41_ = _data6_->score_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp41_, GTK_ALIGN_START);
	_tmp42_ = _data6_->score_label;
	_tmp43_ = self->priv->window_height;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp42_, (_tmp43_ / 3) + 80);
	_tmp44_ = _data6_->score_label;
	gtk_widget_show ((GtkWidget*) _tmp44_);
	_tmp45_ = lowest_high_score;
	_tmp46_ = score;
	points_left = _tmp45_ - _tmp46_;
	_tmp47_ = _ ("(%d more points to reach the leaderboard)");
	_tmp48_ = points_left;
	_tmp49_ = g_strdup_printf (_tmp47_, _tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = (GtkLabel*) gtk_label_new (_tmp50_);
	g_object_ref_sink (_tmp51_);
	_tmp52_ = _tmp51_;
	_g_free0 (_tmp50_);
	_data6_->points_left_label = _tmp52_;
	_tmp53_ = _data6_->points_left_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp53_, GTK_ALIGN_CENTER);
	_tmp54_ = _data6_->points_left_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp54_, GTK_ALIGN_START);
	_tmp55_ = _data6_->points_left_label;
	_tmp56_ = self->priv->window_height;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp55_, (_tmp56_ / 3) + 100);
	_tmp57_ = _data6_->points_left_label;
	gtk_widget_show ((GtkWidget*) _tmp57_);
	_tmp58_ = _ ("_Play Again");
	_tmp59_ = (GtkButton*) gtk_button_new_with_label (_tmp58_);
	g_object_ref_sink (_tmp59_);
	_data6_->button = _tmp59_;
	_tmp60_ = _data6_->button;
	gtk_button_set_use_underline (_tmp60_, TRUE);
	_tmp61_ = _data6_->button;
	gtk_widget_set_halign ((GtkWidget*) _tmp61_, GTK_ALIGN_CENTER);
	_tmp62_ = _data6_->button;
	gtk_widget_set_valign ((GtkWidget*) _tmp62_, GTK_ALIGN_END);
	_tmp63_ = _data6_->button;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp63_, 100);
	_tmp64_ = _data6_->button;
	_tmp65_ = gtk_widget_get_style_context ((GtkWidget*) _tmp64_);
	gtk_style_context_add_class (_tmp65_, "suggested-action");
	_tmp66_ = _data6_->button;
	g_signal_connect_data (_tmp66_, "clicked", (GCallback) ___lambda10__gtk_button_clicked, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp67_ = _data6_->button;
	gtk_widget_show ((GtkWidget*) _tmp67_);
	_tmp68_ = self->priv->overlay;
	_tmp69_ = _data6_->game_over_label;
	gtk_overlay_add_overlay (_tmp68_, (GtkWidget*) _tmp69_);
	_tmp70_ = is_game_won;
	if (_tmp70_) {
		GtkOverlay* _tmp71_ = NULL;
		GtkLabel* _tmp72_ = NULL;
		_tmp71_ = self->priv->overlay;
		_tmp72_ = _data6_->msg_label;
		gtk_overlay_add_overlay (_tmp71_, (GtkWidget*) _tmp72_);
	}
	_tmp73_ = self->priv->game;
	_tmp74_ = nibbles_game_get_numhumans (_tmp73_);
	_tmp75_ = _tmp74_;
	if (_tmp75_ == 1) {
		GtkOverlay* _tmp76_ = NULL;
		GtkLabel* _tmp77_ = NULL;
		_tmp76_ = self->priv->overlay;
		_tmp77_ = _data6_->score_label;
		gtk_overlay_add_overlay (_tmp76_, (GtkWidget*) _tmp77_);
	}
	_tmp79_ = self->priv->game;
	_tmp80_ = nibbles_game_get_numhumans (_tmp79_);
	_tmp81_ = _tmp80_;
	if (_tmp81_ == 1) {
		gboolean _tmp82_ = FALSE;
		_tmp82_ = is_high_score;
		_tmp78_ = !_tmp82_;
	} else {
		_tmp78_ = FALSE;
	}
	if (_tmp78_) {
		GtkOverlay* _tmp83_ = NULL;
		GtkLabel* _tmp84_ = NULL;
		_tmp83_ = self->priv->overlay;
		_tmp84_ = _data6_->points_left_label;
		gtk_overlay_add_overlay (_tmp83_, (GtkWidget*) _tmp84_);
	}
	_tmp85_ = self->priv->overlay;
	_tmp86_ = _data6_->button;
	gtk_overlay_add_overlay (_tmp85_, (GtkWidget*) _tmp86_);
	_tmp87_ = _data6_->button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp87_);
	_tmp88_ = self->priv->overlay;
	gtk_widget_show ((GtkWidget*) _tmp88_);
	_g_free0 (score_string);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}


static void nibbles_about_cb (Nibbles* self) {
	static const gchar* authors[] = {"Sean MacIsaac", "Ian Peters", "Andreas Røsdal", "Guillaume Beland", "Iulian-Gabriel Radu", NULL};
	static const gchar* documenters[] = {"Kevin Breit", NULL};
	static const gchar* artists[] = {"Allan Day", NULL};
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = _ ("Nibbles");
	_tmp2_ = _ ("A worm game for GNOME");
	_tmp3_ = _ ("translator-credits");
	gtk_show_about_dialog ((GtkWindow*) _tmp0_, "program-name", _tmp1_, "logo-icon-name", "gnome-nibbles", "version", VERSION, "comments", _tmp2_, "copyright", "Copyright © 1999–2008 Sean MacIsaac, Ian Peters, Andreas Røsdal\n" "Copyright © 2009 Guillaume Beland\n" "Copyright © 2015 Iulian-Gabriel Radu", "license-type", GTK_LICENSE_GPL_2_0, "authors", authors, "documenters", documenters, "artists", artists, "translator-credits", _tmp3_, "website", "https://wiki.gnome.org/Apps/Nibbles/", NULL);
}


gint nibbles_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionGroup* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionGroup* _tmp4_ = NULL;
	const gchar* _tmp9_ = NULL;
	Nibbles* _tmp19_ = NULL;
	Nibbles* _tmp20_ = NULL;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new ("");
	context = _tmp0_;
	_tmp1_ = context;
	_tmp2_ = gtk_get_option_group (FALSE);
	g_option_context_add_group (_tmp1_, _tmp2_);
	_tmp3_ = context;
	_tmp4_ = clutter_get_option_group_without_init ();
	g_option_context_add_group (_tmp3_, _tmp4_);
	{
		GOptionContext* _tmp5_ = NULL;
		_tmp5_ = context;
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = stderr;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp6_, "%s\n", _tmp8_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp9_ = _ ("Nibbles");
	g_set_application_name (_tmp9_);
	gtk_window_set_default_icon_name ("gnome-nibbles");
	{
		GOptionEntry* _tmp10_ = NULL;
		GOptionEntry* _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		_tmp10_ = g_new0 (GOptionEntry, 0);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = 0;
		gtk_clutter_init_with_args (&args_length1, &args, "", _tmp11_, NULL, &_inner_error_);
		_tmp11_ = (g_free (_tmp11_), NULL);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GtkMessageDialog* dialog = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GtkMessageDialog* _tmp14_ = NULL;
		GtkMessageDialog* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		GtkMessageDialog* _tmp17_ = NULL;
		GtkMessageDialog* _tmp18_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		_tmp14_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "Unable to initialize Clutter:\n%s", _tmp13_);
		g_object_ref_sink (_tmp14_);
		dialog = _tmp14_;
		_tmp15_ = dialog;
		_tmp16_ = g_get_application_name ();
		gtk_window_set_title ((GtkWindow*) _tmp15_, _tmp16_);
		_tmp17_ = dialog;
		gtk_dialog_run ((GtkDialog*) _tmp17_);
		_tmp18_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp18_);
		result = EXIT_FAILURE;
		_g_object_unref0 (dialog);
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp19_ = nibbles_new ();
	_tmp20_ = _tmp19_;
	_tmp21_ = args;
	_tmp21__length1 = args_length1;
	_tmp22_ = g_application_run ((GApplication*) _tmp20_, _tmp21__length1, _tmp21_);
	_tmp23_ = _tmp22_;
	_g_object_unref0 (_tmp20_);
	result = _tmp23_;
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return nibbles_main (argv, argc);
}


static void nibbles_class_init (NibblesClass * klass) {
	nibbles_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NibblesPrivate));
	((GApplicationClass *) klass)->handle_local_options = nibbles_real_handle_local_options;
	((GApplicationClass *) klass)->startup = nibbles_real_startup;
	((GApplicationClass *) klass)->activate = nibbles_real_activate;
	((GApplicationClass *) klass)->shutdown = nibbles_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = nibbles_finalize;
}


static void nibbles_instance_init (Nibbles * self) {
	self->priv = NIBBLES_GET_PRIVATE (self);
	self->priv->preferences_dialog = NULL;
	self->priv->game = NULL;
	self->priv->countdown_id = (guint) 0;
}


static void nibbles_finalize (GObject* obj) {
	Nibbles * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES, Nibbles);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->worm_settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->main_stack);
	_g_object_unref0 (self->priv->overlay);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->new_game_button);
	_g_object_unref0 (self->priv->pause_button);
	_g_object_unref0 (self->priv->number_of_players_buttons);
	_g_object_unref0 (self->priv->number_of_ai_buttons);
	_g_object_unref0 (self->priv->grids_box);
	_g_object_unref0 (self->priv->arrow_pixbuf);
	_g_object_unref0 (self->priv->arrow_key_pixbuf);
	_g_object_unref0 (self->priv->statusbar_stack);
	_g_object_unref0 (self->priv->countdown);
	_g_object_unref0 (self->priv->scoreboard);
	_g_object_unref0 (self->priv->scoreboard_life);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->game_box);
	_g_object_unref0 (self->priv->frame);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->scores_context);
	_g_object_unref0 (self->priv->scorecats);
	_g_object_unref0 (self->priv->new_game_action);
	_g_object_unref0 (self->priv->pause_action);
	_g_object_unref0 (self->priv->back_action);
	G_OBJECT_CLASS (nibbles_parent_class)->finalize (obj);
}


GType nibbles_get_type (void) {
	static volatile gsize nibbles_type_id__volatile = 0;
	if (g_once_init_enter (&nibbles_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NibblesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Nibbles), 0, (GInstanceInitFunc) nibbles_instance_init, NULL };
		GType nibbles_type_id;
		nibbles_type_id = g_type_register_static (gtk_application_get_type (), "Nibbles", &g_define_type_info, 0);
		g_once_init_leave (&nibbles_type_id__volatile, nibbles_type_id);
	}
	return nibbles_type_id__volatile;
}


Scoreboard* scoreboard_construct (GType object_type) {
	Scoreboard * self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	self = (Scoreboard*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (TYPE_PLAYER_SCORE_BOX, (GBoxedCopyFunc) g_object_ref, g_object_unref, TYPE_WORM, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->boxes);
	self->priv->boxes = _tmp0_;
	return self;
}


Scoreboard* scoreboard_new (void) {
	return scoreboard_construct (TYPE_SCOREBOARD);
}


void scoreboard_register (Scoreboard* self, Worm* worm, const gchar* color_name, GdkPixbuf* life_pixbuf) {
	PangoColor color = {0};
	const gchar* _tmp0_ = NULL;
	PlayerScoreBox* box = NULL;
	Worm* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	PangoColor _tmp8_ = {0};
	Worm* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	Worm* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	GdkPixbuf* _tmp15_ = NULL;
	PlayerScoreBox* _tmp16_ = NULL;
	PlayerScoreBox* _tmp17_ = NULL;
	GeeHashMap* _tmp18_ = NULL;
	Worm* _tmp19_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	g_return_if_fail (color_name != NULL);
	g_return_if_fail (life_pixbuf != NULL);
	memset (&color, 0, sizeof (PangoColor));
	_tmp0_ = color_name;
	pango_color_parse (&color, _tmp0_);
	_tmp1_ = worm;
	_tmp2_ = worm_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_ + 1);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("Worm ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = color;
	_tmp9_ = worm;
	_tmp10_ = worm_get_score (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = worm;
	_tmp13_ = worm_get_lives (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = life_pixbuf;
	_tmp16_ = player_score_box_new (_tmp7_, &_tmp8_, _tmp11_, _tmp14_, _tmp15_);
	g_object_ref_sink (_tmp16_);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	box = _tmp17_;
	_tmp18_ = self->priv->boxes;
	_tmp19_ = worm;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, box, _tmp19_);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) box);
	_g_object_unref0 (box);
}


void scoreboard_update (Scoreboard* self) {
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _entry_it = NULL;
		GeeHashMap* _tmp0_ = NULL;
		GeeSet* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		_tmp0_ = self->priv->boxes;
		_tmp1_ = gee_abstract_map_get_entries ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_entry_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			PlayerScoreBox* box = NULL;
			GeeMapEntry* _tmp10_ = NULL;
			gconstpointer _tmp11_ = NULL;
			PlayerScoreBox* _tmp12_ = NULL;
			PlayerScoreBox* _tmp13_ = NULL;
			Worm* worm = NULL;
			GeeMapEntry* _tmp14_ = NULL;
			gconstpointer _tmp15_ = NULL;
			Worm* _tmp16_ = NULL;
			Worm* _tmp17_ = NULL;
			PlayerScoreBox* _tmp18_ = NULL;
			Worm* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			Worm* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			_tmp6_ = _entry_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _entry_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			entry = (GeeMapEntry*) _tmp9_;
			_tmp10_ = entry;
			_tmp11_ = gee_map_entry_get_key (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _g_object_ref0 ((PlayerScoreBox*) _tmp12_);
			box = _tmp13_;
			_tmp14_ = entry;
			_tmp15_ = gee_map_entry_get_value (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = _g_object_ref0 ((Worm*) _tmp16_);
			worm = _tmp17_;
			_tmp18_ = box;
			_tmp19_ = worm;
			_tmp20_ = worm_get_score (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = worm;
			_tmp23_ = worm_get_lives (_tmp22_);
			_tmp24_ = _tmp23_;
			player_score_box_update (_tmp18_, _tmp21_, _tmp24_);
			_g_object_unref0 (worm);
			_g_object_unref0 (box);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
}


void scoreboard_clear (Scoreboard* self) {
	GeeHashMap* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _entry_it = NULL;
		GeeHashMap* _tmp0_ = NULL;
		GeeSet* _tmp1_ = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeSet* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		_tmp0_ = self->priv->boxes;
		_tmp1_ = gee_abstract_map_get_entries ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_entry_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			PlayerScoreBox* box = NULL;
			GeeMapEntry* _tmp10_ = NULL;
			gconstpointer _tmp11_ = NULL;
			PlayerScoreBox* _tmp12_ = NULL;
			PlayerScoreBox* _tmp13_ = NULL;
			PlayerScoreBox* _tmp14_ = NULL;
			_tmp6_ = _entry_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _entry_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			entry = (GeeMapEntry*) _tmp9_;
			_tmp10_ = entry;
			_tmp11_ = gee_map_entry_get_key (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _g_object_ref0 ((PlayerScoreBox*) _tmp12_);
			box = _tmp13_;
			_tmp14_ = box;
			gtk_widget_destroy ((GtkWidget*) _tmp14_);
			_g_object_unref0 (box);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
	_tmp15_ = self->priv->boxes;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp15_);
}


static void scoreboard_class_init (ScoreboardClass * klass) {
	gint Scoreboard_private_offset;
	scoreboard_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ScoreboardPrivate));
	G_OBJECT_CLASS (klass)->finalize = scoreboard_finalize;
	Scoreboard_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/scoreboard.ui");
}


static void scoreboard_instance_init (Scoreboard * self) {
	self->priv = SCOREBOARD_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void scoreboard_finalize (GObject* obj) {
	Scoreboard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCOREBOARD, Scoreboard);
	_g_object_unref0 (self->priv->boxes);
	G_OBJECT_CLASS (scoreboard_parent_class)->finalize (obj);
}


GType scoreboard_get_type (void) {
	static volatile gsize scoreboard_type_id__volatile = 0;
	if (g_once_init_enter (&scoreboard_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ScoreboardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scoreboard_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Scoreboard), 0, (GInstanceInitFunc) scoreboard_instance_init, NULL };
		GType scoreboard_type_id;
		scoreboard_type_id = g_type_register_static (gtk_box_get_type (), "Scoreboard", &g_define_type_info, 0);
		g_once_init_leave (&scoreboard_type_id__volatile, scoreboard_type_id);
	}
	return scoreboard_type_id__volatile;
}


PlayerScoreBox* player_score_box_construct (GType object_type, const gchar* name, PangoColor* color, gint score, gint lives_left, GdkPixbuf* life_pixbuf) {
	PlayerScoreBox * self = NULL;
	GtkLabel* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	GeeLinkedList* _tmp16_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (color != NULL, NULL);
	g_return_val_if_fail (life_pixbuf != NULL, NULL);
	self = (PlayerScoreBox*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->name_label;
	_tmp1_ = pango_color_to_string (color);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("<span color=\"", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\">", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = name;
	_tmp8_ = g_strconcat (_tmp6_, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "</span>", NULL);
	_tmp11_ = _tmp10_;
	gtk_label_set_markup (_tmp0_, _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp12_ = self->priv->score_label;
	_tmp13_ = score;
	_tmp14_ = g_strdup_printf ("%i", _tmp13_);
	_tmp15_ = _tmp14_;
	gtk_label_set_label (_tmp12_, _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = gee_linked_list_new (gtk_image_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->life_images);
	self->priv->life_images = _tmp16_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gint _tmp19_ = 0;
				GtkImage* life = NULL;
				GdkPixbuf* _tmp20_ = NULL;
				GtkImage* _tmp21_ = NULL;
				GtkImage* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				GeeLinkedList* _tmp25_ = NULL;
				GtkImage* _tmp26_ = NULL;
				GtkGrid* _tmp27_ = NULL;
				GtkImage* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				if (!_tmp17_) {
					gint _tmp18_ = 0;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp19_ = i;
				if (!(_tmp19_ < WORM_MAX_LIVES)) {
					break;
				}
				_tmp20_ = life_pixbuf;
				_tmp21_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp20_);
				g_object_ref_sink (_tmp21_);
				life = _tmp21_;
				_tmp22_ = life;
				gtk_widget_show ((GtkWidget*) _tmp22_);
				_tmp23_ = i;
				if (_tmp23_ >= WORM_STARTING_LIVES) {
					GtkImage* _tmp24_ = NULL;
					_tmp24_ = life;
					gtk_widget_set_opacity ((GtkWidget*) _tmp24_, (gdouble) 0);
				}
				_tmp25_ = self->priv->life_images;
				_tmp26_ = life;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp26_);
				_tmp27_ = self->priv->lives_grid;
				_tmp28_ = life;
				_tmp29_ = i;
				_tmp30_ = i;
				gtk_grid_attach (_tmp27_, (GtkWidget*) _tmp28_, _tmp29_ % 6, _tmp30_ / 6, 1, 1);
				_g_object_unref0 (life);
			}
		}
	}
	return self;
}


PlayerScoreBox* player_score_box_new (const gchar* name, PangoColor* color, gint score, gint lives_left, GdkPixbuf* life_pixbuf) {
	return player_score_box_construct (TYPE_PLAYER_SCORE_BOX, name, color, score, lives_left, life_pixbuf);
}


void player_score_box_update (PlayerScoreBox* self, gint score, gint lives_left) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = score;
	player_score_box_update_score (self, _tmp0_);
	_tmp1_ = lives_left;
	player_score_box_update_lives (self, _tmp1_);
}


void player_score_box_update_score (PlayerScoreBox* self, gint score) {
	GtkLabel* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->score_label;
	_tmp1_ = score;
	_tmp2_ = g_strdup_printf ("%i", _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
}


void player_score_box_update_lives (PlayerScoreBox* self, gint lives_left) {
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		GeeLinkedList* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		_tmp0_ = self->priv->life_images;
		_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		i = _tmp2_ - 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				GeeLinkedList* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gpointer _tmp9_ = NULL;
				GtkImage* _tmp10_ = NULL;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ - 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = lives_left;
				if (!(_tmp5_ >= _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->life_images;
				_tmp8_ = i;
				_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tmp8_);
				_tmp10_ = (GtkImage*) _tmp9_;
				gtk_widget_set_opacity ((GtkWidget*) _tmp10_, (gdouble) 0);
				_g_object_unref0 (_tmp10_);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				GeeLinkedList* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gpointer _tmp17_ = NULL;
				GtkImage* _tmp18_ = NULL;
				if (!_tmp11_) {
					gint _tmp12_ = 0;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = i;
				_tmp14_ = lives_left;
				if (!(_tmp13_ < _tmp14_)) {
					break;
				}
				_tmp15_ = self->priv->life_images;
				_tmp16_ = i;
				_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_);
				_tmp18_ = (GtkImage*) _tmp17_;
				gtk_widget_set_opacity ((GtkWidget*) _tmp18_, (gdouble) 1);
				_g_object_unref0 (_tmp18_);
			}
		}
	}
}


static void player_score_box_class_init (PlayerScoreBoxClass * klass) {
	gint PlayerScoreBox_private_offset;
	player_score_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PlayerScoreBoxPrivate));
	G_OBJECT_CLASS (klass)->finalize = player_score_box_finalize;
	PlayerScoreBox_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/player-score-box.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "score_label", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, score_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "lives_grid", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, lives_grid));
}


static void player_score_box_instance_init (PlayerScoreBox * self) {
	self->priv = PLAYER_SCORE_BOX_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void player_score_box_finalize (GObject* obj) {
	PlayerScoreBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PLAYER_SCORE_BOX, PlayerScoreBox);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->score_label);
	_g_object_unref0 (self->priv->lives_grid);
	_g_object_unref0 (self->priv->life_images);
	G_OBJECT_CLASS (player_score_box_parent_class)->finalize (obj);
}


GType player_score_box_get_type (void) {
	static volatile gsize player_score_box_type_id__volatile = 0;
	if (g_once_init_enter (&player_score_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PlayerScoreBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) player_score_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlayerScoreBox), 0, (GInstanceInitFunc) player_score_box_instance_init, NULL };
		GType player_score_box_type_id;
		player_score_box_type_id = g_type_register_static (gtk_box_get_type (), "PlayerScoreBox", &g_define_type_info, 0);
		g_once_init_leave (&player_score_box_type_id__volatile, player_score_box_type_id);
	}
	return player_score_box_type_id__volatile;
}


ControlsGrid* controls_grid_construct (GType object_type, gint worm_id, WormProperties* worm_props, GdkPixbuf* arrow, GdkPixbuf* arrow_key) {
	ControlsGrid * self = NULL;
	PangoColor color = {0};
	WormProperties _tmp0_ = {0};
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* player_id = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GtkImage* _tmp15_ = NULL;
	GdkPixbuf* _tmp16_ = NULL;
	GdkPixbuf* _tmp17_ = NULL;
	GdkPixbuf* _tmp18_ = NULL;
	GtkImage* _tmp19_ = NULL;
	GdkPixbuf* _tmp20_ = NULL;
	GdkPixbuf* _tmp21_ = NULL;
	GdkPixbuf* _tmp22_ = NULL;
	GtkImage* _tmp23_ = NULL;
	GdkPixbuf* _tmp24_ = NULL;
	GdkPixbuf* _tmp25_ = NULL;
	GdkPixbuf* _tmp26_ = NULL;
	GtkImage* _tmp27_ = NULL;
	GdkPixbuf* _tmp28_ = NULL;
	GdkPixbuf* _tmp29_ = NULL;
	GdkPixbuf* _tmp30_ = NULL;
	gchar* upper_key = NULL;
	WormProperties _tmp31_ = {0};
	guint _tmp32_ = 0U;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	WormProperties _tmp48_ = {0};
	guint _tmp49_ = 0U;
	const gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	const gchar* _tmp52_ = NULL;
	WormProperties _tmp65_ = {0};
	guint _tmp66_ = 0U;
	const gchar* _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
	const gchar* _tmp69_ = NULL;
	WormProperties _tmp82_ = {0};
	guint _tmp83_ = 0U;
	const gchar* _tmp84_ = NULL;
	gchar* _tmp85_ = NULL;
	const gchar* _tmp86_ = NULL;
	g_return_val_if_fail (worm_props != NULL, NULL);
	g_return_val_if_fail (arrow != NULL, NULL);
	g_return_val_if_fail (arrow_key != NULL, NULL);
	self = (ControlsGrid*) g_object_new (object_type, NULL);
	memset (&color, 0, sizeof (PangoColor));
	_tmp0_ = *worm_props;
	_tmp1_ = _tmp0_.color;
	_tmp2_ = nibbles_view_colorval_name (_tmp1_);
	_tmp3_ = _tmp2_;
	pango_color_parse (&color, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = _ ("Player %d");
	_tmp5_ = worm_id;
	_tmp6_ = g_strdup_printf (_tmp4_, _tmp5_ + 1);
	player_id = _tmp6_;
	_tmp7_ = self->priv->name_label;
	_tmp8_ = pango_color_to_string (&color);
	_tmp9_ = _tmp8_;
	_tmp10_ = string_to_string (_tmp9_);
	_tmp11_ = player_id;
	_tmp12_ = string_to_string (_tmp11_);
	_tmp13_ = g_strconcat ("<b><span font-family=\"Sans\" color=\"", _tmp10_, "\">", _tmp12_, "</span></b>", NULL);
	_tmp14_ = _tmp13_;
	gtk_label_set_markup (_tmp7_, _tmp14_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp9_);
	_tmp15_ = self->priv->arrow_up;
	_tmp16_ = arrow;
	_tmp17_ = gdk_pixbuf_rotate_simple (_tmp16_, GDK_PIXBUF_ROTATE_NONE);
	_tmp18_ = _tmp17_;
	gtk_image_set_from_pixbuf (_tmp15_, _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = self->priv->arrow_down;
	_tmp20_ = arrow;
	_tmp21_ = gdk_pixbuf_rotate_simple (_tmp20_, GDK_PIXBUF_ROTATE_UPSIDEDOWN);
	_tmp22_ = _tmp21_;
	gtk_image_set_from_pixbuf (_tmp19_, _tmp22_);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = self->priv->arrow_left;
	_tmp24_ = arrow;
	_tmp25_ = gdk_pixbuf_rotate_simple (_tmp24_, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
	_tmp26_ = _tmp25_;
	gtk_image_set_from_pixbuf (_tmp23_, _tmp26_);
	_g_object_unref0 (_tmp26_);
	_tmp27_ = self->priv->arrow_right;
	_tmp28_ = arrow;
	_tmp29_ = gdk_pixbuf_rotate_simple (_tmp28_, GDK_PIXBUF_ROTATE_CLOCKWISE);
	_tmp30_ = _tmp29_;
	gtk_image_set_from_pixbuf (_tmp27_, _tmp30_);
	_g_object_unref0 (_tmp30_);
	_tmp31_ = *worm_props;
	_tmp32_ = _tmp31_.up;
	_tmp33_ = gdk_keyval_name (_tmp32_);
	_tmp34_ = g_utf8_strup (_tmp33_, (gssize) -1);
	_g_free0 (upper_key);
	upper_key = _tmp34_;
	_tmp35_ = upper_key;
	if (g_strcmp0 (_tmp35_, "UP") == 0) {
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp36_ = NULL;
		GdkPixbuf* _tmp37_ = NULL;
		GtkOverlay* _tmp38_ = NULL;
		GdkPixbuf* _tmp39_ = NULL;
		GtkImage* _tmp40_ = NULL;
		GtkImage* _tmp41_ = NULL;
		GtkOverlay* _tmp42_ = NULL;
		_tmp36_ = arrow_key;
		_tmp37_ = gdk_pixbuf_rotate_simple (_tmp36_, GDK_PIXBUF_ROTATE_NONE);
		rotated_pixbuf = _tmp37_;
		_tmp38_ = self->priv->move_up;
		_tmp39_ = rotated_pixbuf;
		_tmp40_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp39_);
		g_object_ref_sink (_tmp40_);
		_tmp41_ = _tmp40_;
		gtk_overlay_add_overlay (_tmp38_, (GtkWidget*) _tmp41_);
		_g_object_unref0 (_tmp41_);
		_tmp42_ = self->priv->move_up;
		gtk_widget_show_all ((GtkWidget*) _tmp42_);
		_g_object_unref0 (rotated_pixbuf);
	} else {
		GtkLabel* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		_tmp43_ = self->priv->move_up_label;
		_tmp44_ = upper_key;
		_tmp45_ = string_to_string (_tmp44_);
		_tmp46_ = g_strconcat ("<b>", _tmp45_, "</b>", NULL);
		_tmp47_ = _tmp46_;
		gtk_label_set_markup (_tmp43_, _tmp47_);
		_g_free0 (_tmp47_);
	}
	_tmp48_ = *worm_props;
	_tmp49_ = _tmp48_.down;
	_tmp50_ = gdk_keyval_name (_tmp49_);
	_tmp51_ = g_utf8_strup (_tmp50_, (gssize) -1);
	_g_free0 (upper_key);
	upper_key = _tmp51_;
	_tmp52_ = upper_key;
	if (g_strcmp0 (_tmp52_, "DOWN") == 0) {
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp53_ = NULL;
		GdkPixbuf* _tmp54_ = NULL;
		GtkOverlay* _tmp55_ = NULL;
		GdkPixbuf* _tmp56_ = NULL;
		GtkImage* _tmp57_ = NULL;
		GtkImage* _tmp58_ = NULL;
		GtkOverlay* _tmp59_ = NULL;
		_tmp53_ = arrow_key;
		_tmp54_ = gdk_pixbuf_rotate_simple (_tmp53_, GDK_PIXBUF_ROTATE_UPSIDEDOWN);
		rotated_pixbuf = _tmp54_;
		_tmp55_ = self->priv->move_down;
		_tmp56_ = rotated_pixbuf;
		_tmp57_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp56_);
		g_object_ref_sink (_tmp57_);
		_tmp58_ = _tmp57_;
		gtk_overlay_add_overlay (_tmp55_, (GtkWidget*) _tmp58_);
		_g_object_unref0 (_tmp58_);
		_tmp59_ = self->priv->move_down;
		gtk_widget_show_all ((GtkWidget*) _tmp59_);
		_g_object_unref0 (rotated_pixbuf);
	} else {
		GtkLabel* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		const gchar* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
		_tmp60_ = self->priv->move_down_label;
		_tmp61_ = upper_key;
		_tmp62_ = string_to_string (_tmp61_);
		_tmp63_ = g_strconcat ("<b>", _tmp62_, "</b>", NULL);
		_tmp64_ = _tmp63_;
		gtk_label_set_markup (_tmp60_, _tmp64_);
		_g_free0 (_tmp64_);
	}
	_tmp65_ = *worm_props;
	_tmp66_ = _tmp65_.left;
	_tmp67_ = gdk_keyval_name (_tmp66_);
	_tmp68_ = g_utf8_strup (_tmp67_, (gssize) -1);
	_g_free0 (upper_key);
	upper_key = _tmp68_;
	_tmp69_ = upper_key;
	if (g_strcmp0 (_tmp69_, "LEFT") == 0) {
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp70_ = NULL;
		GdkPixbuf* _tmp71_ = NULL;
		GtkOverlay* _tmp72_ = NULL;
		GdkPixbuf* _tmp73_ = NULL;
		GtkImage* _tmp74_ = NULL;
		GtkImage* _tmp75_ = NULL;
		GtkOverlay* _tmp76_ = NULL;
		_tmp70_ = arrow_key;
		_tmp71_ = gdk_pixbuf_rotate_simple (_tmp70_, GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE);
		rotated_pixbuf = _tmp71_;
		_tmp72_ = self->priv->move_left;
		_tmp73_ = rotated_pixbuf;
		_tmp74_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp73_);
		g_object_ref_sink (_tmp74_);
		_tmp75_ = _tmp74_;
		gtk_overlay_add_overlay (_tmp72_, (GtkWidget*) _tmp75_);
		_g_object_unref0 (_tmp75_);
		_tmp76_ = self->priv->move_left;
		gtk_widget_show_all ((GtkWidget*) _tmp76_);
		_g_object_unref0 (rotated_pixbuf);
	} else {
		GtkLabel* _tmp77_ = NULL;
		const gchar* _tmp78_ = NULL;
		const gchar* _tmp79_ = NULL;
		gchar* _tmp80_ = NULL;
		gchar* _tmp81_ = NULL;
		_tmp77_ = self->priv->move_left_label;
		_tmp78_ = upper_key;
		_tmp79_ = string_to_string (_tmp78_);
		_tmp80_ = g_strconcat ("<b>", _tmp79_, "</b>", NULL);
		_tmp81_ = _tmp80_;
		gtk_label_set_markup (_tmp77_, _tmp81_);
		_g_free0 (_tmp81_);
	}
	_tmp82_ = *worm_props;
	_tmp83_ = _tmp82_.right;
	_tmp84_ = gdk_keyval_name (_tmp83_);
	_tmp85_ = g_utf8_strup (_tmp84_, (gssize) -1);
	_g_free0 (upper_key);
	upper_key = _tmp85_;
	_tmp86_ = upper_key;
	if (g_strcmp0 (_tmp86_, "RIGHT") == 0) {
		GdkPixbuf* rotated_pixbuf = NULL;
		GdkPixbuf* _tmp87_ = NULL;
		GdkPixbuf* _tmp88_ = NULL;
		GtkOverlay* _tmp89_ = NULL;
		GdkPixbuf* _tmp90_ = NULL;
		GtkImage* _tmp91_ = NULL;
		GtkImage* _tmp92_ = NULL;
		GtkOverlay* _tmp93_ = NULL;
		_tmp87_ = arrow_key;
		_tmp88_ = gdk_pixbuf_rotate_simple (_tmp87_, GDK_PIXBUF_ROTATE_CLOCKWISE);
		rotated_pixbuf = _tmp88_;
		_tmp89_ = self->priv->move_right;
		_tmp90_ = rotated_pixbuf;
		_tmp91_ = (GtkImage*) gtk_image_new_from_pixbuf (_tmp90_);
		g_object_ref_sink (_tmp91_);
		_tmp92_ = _tmp91_;
		gtk_overlay_add_overlay (_tmp89_, (GtkWidget*) _tmp92_);
		_g_object_unref0 (_tmp92_);
		_tmp93_ = self->priv->move_right;
		gtk_widget_show_all ((GtkWidget*) _tmp93_);
		_g_object_unref0 (rotated_pixbuf);
	} else {
		GtkLabel* _tmp94_ = NULL;
		const gchar* _tmp95_ = NULL;
		const gchar* _tmp96_ = NULL;
		gchar* _tmp97_ = NULL;
		gchar* _tmp98_ = NULL;
		_tmp94_ = self->priv->move_right_label;
		_tmp95_ = upper_key;
		_tmp96_ = string_to_string (_tmp95_);
		_tmp97_ = g_strconcat ("<b>", _tmp96_, "</b>", NULL);
		_tmp98_ = _tmp97_;
		gtk_label_set_markup (_tmp94_, _tmp98_);
		_g_free0 (_tmp98_);
	}
	_g_free0 (upper_key);
	_g_free0 (player_id);
	return self;
}


ControlsGrid* controls_grid_new (gint worm_id, WormProperties* worm_props, GdkPixbuf* arrow, GdkPixbuf* arrow_key) {
	return controls_grid_construct (TYPE_CONTROLS_GRID, worm_id, worm_props, arrow, arrow_key);
}


static void controls_grid_class_init (ControlsGridClass * klass) {
	gint ControlsGrid_private_offset;
	controls_grid_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ControlsGridPrivate));
	G_OBJECT_CLASS (klass)->finalize = controls_grid_finalize;
	ControlsGrid_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/nibbles/ui/controls-grid.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_up", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_up));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_down", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_down));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_left", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_left));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_right", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_right));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_up", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_up));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_up_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_up_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_down", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_down));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_down_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_down_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_left", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_left));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_left_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_left_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_right", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_right));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_right_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_right_label));
}


static void controls_grid_instance_init (ControlsGrid * self) {
	self->priv = CONTROLS_GRID_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void controls_grid_finalize (GObject* obj) {
	ControlsGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONTROLS_GRID, ControlsGrid);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->arrow_up);
	_g_object_unref0 (self->priv->arrow_down);
	_g_object_unref0 (self->priv->arrow_left);
	_g_object_unref0 (self->priv->arrow_right);
	_g_object_unref0 (self->priv->move_up);
	_g_object_unref0 (self->priv->move_up_label);
	_g_object_unref0 (self->priv->move_down);
	_g_object_unref0 (self->priv->move_down_label);
	_g_object_unref0 (self->priv->move_left);
	_g_object_unref0 (self->priv->move_left_label);
	_g_object_unref0 (self->priv->move_right);
	_g_object_unref0 (self->priv->move_right_label);
	G_OBJECT_CLASS (controls_grid_parent_class)->finalize (obj);
}


GType controls_grid_get_type (void) {
	static volatile gsize controls_grid_type_id__volatile = 0;
	if (g_once_init_enter (&controls_grid_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ControlsGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) controls_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ControlsGrid), 0, (GInstanceInitFunc) controls_grid_instance_init, NULL };
		GType controls_grid_type_id;
		controls_grid_type_id = g_type_register_static (gtk_grid_get_type (), "ControlsGrid", &g_define_type_info, 0);
		g_once_init_leave (&controls_grid_type_id__volatile, controls_grid_type_id);
	}
	return controls_grid_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



