/* GnomeTalk: Main module
 * (C) 1997 the Free Software Foundation
 *
 * Author: Federico Mena
 */

#ifndef GNOMELOCALEDIR
#define GNOMELOCALEDIR "/usr/share/locale"
#endif

#include <config.h>
#include <unistd.h>
#include "gnome.h"
#include "global.h"
#include "names.h"
#include "protocol.h"

/* Arguments we parsed out of the command line.  */
static char *user;
static char *tty;

const struct poptOption options [] = {
	{ NULL, '\0', 0, NULL, 0 }
};

int
main(int argc, char **argv)
{
	poptContext ctx;
	char **args;

	bindtextdomain(PACKAGE, GNOMELOCALEDIR);
	textdomain(PACKAGE);
	
	gnome_init_with_popt_table ("gnometalk", VERSION, argc, argv, options, 0, &ctx);
	args = poptGetArgs (ctx);
	while (args && *args){
		if (user){
			if (!tty)
				tty = *args;
		} else
			user = *args;
		args++;
	}
	poptFreeContext (ctx);
	
	init_protocol ();
	if (user == NULL)
		get_names_from_user ();
	else
		if (!init_names (user, tty))
			get_names_from_user ();

	gtk_main();
	return 0;
}
