/* gnome-ppp - The GNOME PPP Dialer
 * Copyright (C) 1997, 1998 Jay Painter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <unistd.h>
#include "gnome-ppp.h"
#include "global.h"


static gint connection_closed = 0;


static void list_accounts();
static void dial_account();
static void connect_message_cb(Account *account, 
			       PPPMessageType message, 
			       gchar *text);


void
command_line_dial(gchar *account_name)
{
  gnomelib_init("gnome_ppp", "0.1");
  gnomeppplib_init();

  account_load();
  dial_account(account_name);
}


void
command_line_list()
{
  gnomelib_init("gnome_ppp", "0.1");
  gnomeppplib_init();

  account_load();
  list_accounts();
}


static void
list_accounts()
{
  GList *list;
  Account *account;

  list = account_list();
  while (list)
    {
      account = (Account *) list->data;
      list = list->next;
      fprintf(stdout, "%s\n", account->name->str);
    }
}


static void
dial_account(gchar *account_name)
{
  GList *list;
  Account *account;

  list = account_list();
  while (list)
    {
      account = (Account *) list->data;
      if (strcmp(account_name, account->name->str) == 0)
	{
	  break;
	}
      list = list->next;
    }
  
  if (list && account)
    {
      fprintf(stdout, "dialing %s\n", account->name->str);
    }
  else
    {
      fprintf(stdout, "%s not found\n", account_name);
      exit(1);
    }

  /* dial/connect */
  connect_start(account, connect_message_cb, NULL);
  while (!connection_closed)
    {
      usleep(50000);
      connect_engine_iteration(account);
    }

  fprintf(stdout, "connection closed\n");
}


static void 
connect_message_cb(Account *account, 
		   PPPMessageType message, 
		   gchar *text)
{
  g_assert(account != NULL);

  /* map messages from the connect engine to internal
   * states of the dial window
   */
  switch (message)
    {
    case PPP_DISCONNECTED:
      connection_closed = 1;
      break;

    case PPP_IN_PROGRESS:
      break;

    case PPP_CONNECTED:
      break;
    }

  /* display a message if there is one */
  if (text)
    {
      fprintf(stdout, "%s\n", text);
    }
}

