/* gnome-mines.c generated by valac 0.25.4.4-19ea, the Vala compiler
 * generated from gnome-mines.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <stdio.h>


#define TYPE_MINES (mines_get_type ())
#define MINES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINES, Mines))
#define MINES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINES, MinesClass))
#define IS_MINES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINES))
#define IS_MINES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINES))
#define MINES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINES, MinesClass))

typedef struct _Mines Mines;
typedef struct _MinesClass MinesClass;
typedef struct _MinesPrivate MinesPrivate;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;

#define TYPE_MINEFIELD (minefield_get_type ())
#define MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD, Minefield))
#define MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD, MinefieldClass))
#define IS_MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD))
#define IS_MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD))
#define MINEFIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD, MinefieldClass))

typedef struct _Minefield Minefield;
typedef struct _MinefieldClass MinefieldClass;

#define TYPE_MINEFIELD_VIEW (minefield_view_get_type ())
#define MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD_VIEW, MinefieldView))
#define MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD_VIEW, MinefieldViewClass))
#define IS_MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD_VIEW))
#define IS_MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD_VIEW))
#define MINEFIELD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD_VIEW, MinefieldViewClass))

typedef struct _MinefieldView MinefieldView;
typedef struct _MinefieldViewClass MinefieldViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MinefieldPrivate MinefieldPrivate;

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;

#define TYPE_SCORE_DIALOG (score_dialog_get_type ())
#define SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_DIALOG, ScoreDialog))
#define SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_DIALOG, ScoreDialogClass))
#define IS_SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_DIALOG))
#define IS_SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_DIALOG))
#define SCORE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_DIALOG, ScoreDialogClass))

typedef struct _ScoreDialog ScoreDialog;
typedef struct _ScoreDialogClass ScoreDialogClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _Mines {
	GtkApplication parent_instance;
	MinesPrivate * priv;
};

struct _MinesClass {
	GtkApplicationClass parent_class;
};

struct _MinesPrivate {
	GSettings* settings;
	GtkWidget* main_screen;
	GtkButton* play_pause_button;
	GtkLabel* play_pause_label;
	GtkButton* replay_button;
	GtkButton* high_scores_button;
	GtkButton* new_game_button;
	GtkAspectFrame* minefield_aspect;
	GtkOverlay* minefield_overlay;
	GtkBox* paused_box;
	GtkScrolledWindow* scrolled;
	GtkLabel* clock_label;
	GMenu* app_main_menu;
	GtkWindow* window;
	gint window_width;
	gint window_height;
	gboolean is_maximized;
	gboolean pause_requested;
	gboolean window_skip_configure;
	History* history;
	Minefield* minefield;
	MinefieldView* minefield_view;
	GtkLabel* flag_label;
	GtkSpinButton* mines_spin;
	GSimpleAction* new_game_action;
	GSimpleAction* repeat_size_action;
	GSimpleAction* pause_action;
	GtkAspectFrame* new_game_screen;
	GtkAspectFrame* custom_game_screen;
	gboolean is_new_game_screen;
};

struct _Minefield {
	GObject parent_instance;
	MinefieldPrivate * priv;
	guint width;
	guint height;
	guint n_mines;
	gboolean exploded;
};

struct _MinefieldClass {
	GObjectClass parent_class;
};


static gpointer mines_parent_class = NULL;

GType mines_get_type (void) G_GNUC_CONST;
GType history_get_type (void) G_GNUC_CONST;
GType minefield_get_type (void) G_GNUC_CONST;
GType minefield_view_get_type (void) G_GNUC_CONST;
#define MINES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MINES, MinesPrivate))
enum  {
	MINES_DUMMY_PROPERTY
};
#define MINES_KEY_XSIZE "xsize"
#define MINES_XSIZE_MIN 4
#define MINES_XSIZE_MAX 100
#define MINES_KEY_YSIZE "ysize"
#define MINES_YSIZE_MIN 4
#define MINES_YSIZE_MAX 100
#define MINES_KEY_NMINES "nmines"
#define MINES_KEY_MODE "mode"
#define MINES_KEY_USE_QUESTION_MARKS "use-question-marks"
#define MINES_KEY_USE_OVERMINE_WARNING "use-overmine-warning"
#define MINES_KEY_USE_AUTOFLAG "use-autoflag"
static void mines_new_game_cb (Mines* self);
static void _mines_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_repeat_size_cb (Mines* self);
static void _mines_repeat_size_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_toggle_pause_cb (Mines* self);
static void _mines_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_scores_cb (Mines* self);
static void _mines_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_quit_cb (Mines* self);
static void _mines_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_help_cb (Mines* self);
static void _mines_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void mines_about_cb (Mines* self);
static void _mines_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Mines* mines_new (void);
Mines* mines_construct (GType object_type);
static void mines_real_startup (GApplication* base);
static gboolean mines_window_configure_event_cb (Mines* self, GdkEventConfigure* event);
static gboolean _mines_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean mines_window_state_event_cb (Mines* self, GdkEventWindowState* event);
static gboolean _mines_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static gboolean mines_window_focus_out_event_cb (Mines* self, GdkEventFocus* event);
static gboolean _mines_window_focus_out_event_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean mines_window_focus_in_event_cb (Mines* self, GdkEventFocus* event);
static gboolean _mines_window_focus_in_event_cb_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
MinefieldView* minefield_view_new (GSettings* settings);
MinefieldView* minefield_view_construct (GType object_type, GSettings* settings);
static gboolean mines_view_button_press_event (Mines* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _mines_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void mines_startup_new_game_screen (Mines* self, GtkBuilder* builder);
static void mines_startup_custom_game_screen (Mines* self, GtkBuilder* builder);
History* history_new (const gchar* filename);
History* history_construct (GType object_type, const gchar* filename);
void history_load (History* self);
static void mines_small_size_clicked_cb (Mines* self);
static void _mines_small_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gchar* mines_make_minefield_description (Mines* self, gint width, gint height, gint n_mines);
static void mines_medium_size_clicked_cb (Mines* self);
static void _mines_medium_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void mines_large_size_clicked_cb (Mines* self);
static void _mines_large_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void mines_show_custom_game_screen (Mines* self);
static void _mines_show_custom_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void mines_xsize_spin_cb (Mines* self, GtkSpinButton* spin);
static void _mines_xsize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void mines_ysize_spin_cb (Mines* self, GtkSpinButton* spin);
static void _mines_ysize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void mines_mines_spin_cb (Mines* self, GtkSpinButton* spin);
static void _mines_mines_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void mines_set_mines_limit (Mines* self);
static void mines_show_new_game_screen (Mines* self);
static void _mines_show_new_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void mines_custom_size_clicked_cb (Mines* self);
static void _mines_custom_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
gboolean minefield_is_clock_started (Minefield* self);
void minefield_set_paused (Minefield* self, gboolean value);
void mines_start (Mines* self);
static void mines_real_shutdown (GApplication* base);
static void mines_real_activate (GApplication* base);
gboolean minefield_get_paused (Minefield* self);
static void mines_update_flag_label (Mines* self);
guint minefield_get_n_flags (Minefield* self);
GType history_entry_get_type (void) G_GNUC_CONST;
static gint mines_show_scores (Mines* self, HistoryEntry* selected_entry, gboolean show_close);
GType score_dialog_get_type (void) G_GNUC_CONST;
ScoreDialog* score_dialog_new (History* history, HistoryEntry* selected_entry, gboolean show_close);
ScoreDialog* score_dialog_construct (GType object_type, History* history, HistoryEntry* selected_entry, gboolean show_close);
static gboolean mines_can_start_new_game (Mines* self);
guint minefield_get_n_cleared (Minefield* self);
gboolean minefield_get_is_complete (Minefield* self);
static void mines_start_game (Mines* self);
static void mines_tick_cb (Mines* self);
Minefield* minefield_new (guint width, guint height, guint n_mines);
Minefield* minefield_construct (GType object_type, guint width, guint height, guint n_mines);
static void mines_marks_changed_cb (Mines* self, Minefield* minefield);
static void _mines_marks_changed_cb_minefield_marks_changed (Minefield* _sender, gpointer self);
static void mines_explode_cb (Mines* self, Minefield* minefield);
static void _mines_explode_cb_minefield_explode (Minefield* _sender, gpointer self);
static void mines_cleared_cb (Mines* self, Minefield* minefield);
static void _mines_cleared_cb_minefield_cleared (Minefield* _sender, gpointer self);
static void _mines_tick_cb_minefield_tick (Minefield* _sender, gpointer self);
static void mines_paused_changed_cb (Mines* self);
static void _mines_paused_changed_cb_minefield_paused_changed (Minefield* _sender, gpointer self);
static void mines_clock_started_cb (Mines* self);
static void _mines_clock_started_cb_minefield_clock_started (Minefield* _sender, gpointer self);
void minefield_view_set_minefield (MinefieldView* self, Minefield* value);
static void mines_display_unpause_button (Mines* self);
gdouble minefield_get_elapsed (Minefield* self);
static void mines_display_pause_button (Mines* self);
HistoryEntry* history_entry_new (GDateTime* date, guint width, guint height, guint n_mines, guint duration);
HistoryEntry* history_entry_construct (GType object_type, GDateTime* date, guint width, guint height, guint n_mines, guint duration);
void history_add (History* self, HistoryEntry* entry);
void history_save (History* self);
static gfloat mines_percent_mines (Mines* self);
static void mines_set_mode (Mines* self, gint mode);
gint mines_main (gchar** args, int args_length1);
static void mines_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry MINES_action_entries[7] = {{"new-game", _mines_new_game_cb_gsimple_action_activate_callback}, {"repeat-size", _mines_repeat_size_cb_gsimple_action_activate_callback}, {"pause", _mines_toggle_pause_cb_gsimple_action_activate_callback}, {"scores", _mines_scores_cb_gsimple_action_activate_callback}, {"quit", _mines_quit_cb_gsimple_action_activate_callback}, {"help", _mines_help_cb_gsimple_action_activate_callback}, {"about", _mines_about_cb_gsimple_action_activate_callback}};

static void _mines_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_new_game_cb ((Mines*) self);
}


static void _mines_repeat_size_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_repeat_size_cb ((Mines*) self);
}


static void _mines_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_toggle_pause_cb ((Mines*) self);
}


static void _mines_scores_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_scores_cb ((Mines*) self);
}


static void _mines_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_quit_cb ((Mines*) self);
}


static void _mines_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_help_cb ((Mines*) self);
}


static void _mines_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	mines_about_cb ((Mines*) self);
}


Mines* mines_construct (GType object_type) {
	Mines * self = NULL;
	self = (Mines*) g_object_new (object_type, "application-id", "org.gnome.mines", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	return self;
}


Mines* mines_new (void) {
	return mines_construct (TYPE_MINES);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _mines_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = mines_window_configure_event_cb ((Mines*) self, event);
	return result;
}


static gboolean _mines_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = mines_window_state_event_cb ((Mines*) self, event);
	return result;
}


static gboolean _mines_window_focus_out_event_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = mines_window_focus_out_event_cb ((Mines*) self, event);
	return result;
}


static gboolean _mines_window_focus_in_event_cb_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = mines_window_focus_in_event_cb ((Mines*) self, event);
	return result;
}


static gboolean _mines_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = mines_view_button_press_event ((Mines*) self, _sender, event);
	return result;
}


static void mines_real_startup (GApplication* base) {
	Mines * self;
	const gchar* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp3_ = NULL;
	gchar* css_path = NULL;
	gchar* _tmp4_ = NULL;
	GdkScreen* _tmp7_ = NULL;
	GtkBuilder* ui_builder = NULL;
	GtkBuilder* _tmp8_ = NULL;
	GtkIconTheme* _tmp13_ = NULL;
	GAction* _tmp14_ = NULL;
	GSimpleAction* _tmp15_ = NULL;
	GSimpleAction* _tmp16_ = NULL;
	GAction* _tmp17_ = NULL;
	GSimpleAction* _tmp18_ = NULL;
	GSimpleAction* _tmp19_ = NULL;
	GAction* _tmp20_ = NULL;
	GSimpleAction* _tmp21_ = NULL;
	GSimpleAction* _tmp22_ = NULL;
	GSettings* _tmp23_ = NULL;
	GAction* _tmp24_ = NULL;
	GAction* _tmp25_ = NULL;
	GSettings* _tmp26_ = NULL;
	GAction* _tmp27_ = NULL;
	GAction* _tmp28_ = NULL;
	GObject* _tmp29_ = NULL;
	GtkWindow* _tmp30_ = NULL;
	GtkWindow* _tmp31_ = NULL;
	GtkWindow* _tmp32_ = NULL;
	GtkWindow* _tmp33_ = NULL;
	GtkWindow* _tmp34_ = NULL;
	GtkWindow* _tmp35_ = NULL;
	GSettings* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	GSettings* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	GSettings* _tmp40_ = NULL;
	gboolean _tmp41_ = FALSE;
	GtkWindow* _tmp43_ = NULL;
	gboolean shell_shows_menubar = FALSE;
	GtkSettings* _tmp44_ = NULL;
	gboolean _tmp45_ = FALSE;
	gchar* _tmp110_ = NULL;
	gchar** _tmp111_ = NULL;
	gchar** _tmp112_ = NULL;
	gint _tmp112__length1 = 0;
	gchar* _tmp113_ = NULL;
	gchar** _tmp114_ = NULL;
	gchar** _tmp115_ = NULL;
	gint _tmp115__length1 = 0;
	gchar* _tmp116_ = NULL;
	gchar** _tmp117_ = NULL;
	gchar** _tmp118_ = NULL;
	gint _tmp118__length1 = 0;
	gchar* _tmp119_ = NULL;
	gchar** _tmp120_ = NULL;
	gchar** _tmp121_ = NULL;
	gint _tmp121__length1 = 0;
	gchar* _tmp122_ = NULL;
	gchar* _tmp123_ = NULL;
	gchar** _tmp124_ = NULL;
	gchar** _tmp125_ = NULL;
	gint _tmp125__length1 = 0;
	GSettings* _tmp126_ = NULL;
	MinefieldView* _tmp127_ = NULL;
	MinefieldView* _tmp128_ = NULL;
	GtkScrolledWindow* _tmp129_ = NULL;
	GtkScrolledWindow* _tmp130_ = NULL;
	GtkScrolledWindow* _tmp131_ = NULL;
	MinefieldView* _tmp132_ = NULL;
	GObject* _tmp133_ = NULL;
	GtkOverlay* _tmp134_ = NULL;
	GtkOverlay* _tmp135_ = NULL;
	GtkScrolledWindow* _tmp136_ = NULL;
	GtkOverlay* _tmp137_ = NULL;
	GObject* _tmp138_ = NULL;
	GtkAspectFrame* _tmp139_ = NULL;
	GtkAspectFrame* _tmp140_ = NULL;
	GObject* _tmp141_ = NULL;
	GtkBox* _tmp142_ = NULL;
	GtkBox* _tmp143_ = NULL;
	GtkOverlay* _tmp144_ = NULL;
	GtkBox* _tmp145_ = NULL;
	GObject* _tmp146_ = NULL;
	GtkWidget* _tmp147_ = NULL;
	const gchar* _tmp148_ = NULL;
	gchar* _tmp149_ = NULL;
	gchar* _tmp150_ = NULL;
	History* _tmp151_ = NULL;
	History* _tmp152_ = NULL;
	GObject* _tmp153_ = NULL;
	GtkLabel* _tmp154_ = NULL;
	GObject* _tmp155_ = NULL;
	GtkLabel* _tmp156_ = NULL;
	GObject* _tmp157_ = NULL;
	GtkButton* _tmp158_ = NULL;
	GObject* _tmp159_ = NULL;
	GtkLabel* _tmp160_ = NULL;
	GObject* _tmp161_ = NULL;
	GtkButton* _tmp162_ = NULL;
	GObject* _tmp163_ = NULL;
	GtkButton* _tmp164_ = NULL;
	GObject* _tmp165_ = NULL;
	GtkButton* _tmp166_ = NULL;
	GError * _inner_error_ = NULL;
	self = (Mines*) base;
	G_APPLICATION_CLASS (mines_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = _ ("Mines");
	g_set_application_name (_tmp0_);
	_tmp1_ = g_settings_new ("org.gnome.mines");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_tmp2_ = self->priv->settings;
	g_settings_delay (_tmp2_);
	gtk_window_set_default_icon_name ("gnome-mines");
	_tmp3_ = gtk_css_provider_new ();
	css_provider = _tmp3_;
	_tmp4_ = g_build_filename (DATA_DIRECTORY, "gnome-mines.css", NULL);
	css_path = _tmp4_;
	{
		gtk_css_provider_load_from_path (css_provider, css_path, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("gnome-mines.vala:111: Error loading css styles from %s: %s", css_path, _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (css_path);
		_g_object_unref0 (css_provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = gdk_screen_get_default ();
	gtk_style_context_add_provider_for_screen (_tmp7_, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp8_ = gtk_builder_new ();
	ui_builder = _tmp8_;
	{
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp9_ = g_build_filename (DATA_DIRECTORY, "interface.ui", NULL, NULL);
		_tmp10_ = _tmp9_;
		gtk_builder_add_from_file (ui_builder, _tmp10_, &_inner_error_);
		_g_free0 (_tmp10_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("gnome-mines.vala:122: Could not load game UI: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (ui_builder);
		_g_free0 (css_path);
		_g_object_unref0 (css_provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = gtk_icon_theme_get_default ();
	gtk_icon_theme_append_search_path (_tmp13_, DATA_DIRECTORY);
	g_action_map_add_action_entries ((GActionMap*) self, MINES_action_entries, G_N_ELEMENTS (MINES_action_entries), self);
	_tmp14_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp14_) : NULL);
	_g_object_unref0 (self->priv->new_game_action);
	self->priv->new_game_action = _tmp15_;
	_tmp16_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp16_, FALSE);
	_tmp17_ = g_action_map_lookup_action ((GActionMap*) self, "repeat-size");
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp17_) : NULL);
	_g_object_unref0 (self->priv->repeat_size_action);
	self->priv->repeat_size_action = _tmp18_;
	_tmp19_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp19_, FALSE);
	_tmp20_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp20_) : NULL);
	_g_object_unref0 (self->priv->pause_action);
	self->priv->pause_action = _tmp21_;
	_tmp22_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp22_, FALSE);
	_tmp23_ = self->priv->settings;
	_tmp24_ = g_settings_create_action (_tmp23_, MINES_KEY_USE_OVERMINE_WARNING);
	_tmp25_ = _tmp24_;
	g_action_map_add_action ((GActionMap*) self, _tmp25_);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = self->priv->settings;
	_tmp27_ = g_settings_create_action (_tmp26_, MINES_KEY_USE_QUESTION_MARKS);
	_tmp28_ = _tmp27_;
	g_action_map_add_action ((GActionMap*) self, _tmp28_);
	_g_object_unref0 (_tmp28_);
	_tmp29_ = gtk_builder_get_object (ui_builder, "main_window");
	_tmp30_ = _g_object_ref0 ((GtkWindow*) G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_application_window_get_type (), GtkApplicationWindow));
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp30_;
	_tmp31_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp31_, "configure-event", (GCallback) _mines_window_configure_event_cb_gtk_widget_configure_event, self, 0);
	_tmp32_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp32_, "window-state-event", (GCallback) _mines_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp33_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp33_, "focus-out-event", (GCallback) _mines_window_focus_out_event_cb_gtk_widget_focus_out_event, self, 0);
	_tmp34_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp34_, "focus-in-event", (GCallback) _mines_window_focus_in_event_cb_gtk_widget_focus_in_event, self, 0);
	_tmp35_ = self->priv->window;
	_tmp36_ = self->priv->settings;
	_tmp37_ = g_settings_get_int (_tmp36_, "window-width");
	_tmp38_ = self->priv->settings;
	_tmp39_ = g_settings_get_int (_tmp38_, "window-height");
	gtk_window_set_default_size (_tmp35_, _tmp37_, _tmp39_);
	_tmp40_ = self->priv->settings;
	_tmp41_ = g_settings_get_boolean (_tmp40_, "window-is-maximized");
	if (_tmp41_) {
		GtkWindow* _tmp42_ = NULL;
		_tmp42_ = self->priv->window;
		gtk_window_maximize (_tmp42_);
	}
	_tmp43_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, _tmp43_);
	_tmp44_ = gtk_settings_get_default ();
	g_object_get ((GObject*) _tmp44_, "gtk-shell-shows-menubar", &shell_shows_menubar, NULL);
	_tmp45_ = shell_shows_menubar;
	if (!_tmp45_) {
		GtkHeaderBar* headerbar = NULL;
		GtkHeaderBar* _tmp46_ = NULL;
		GtkHeaderBar* _tmp47_ = NULL;
		GtkHeaderBar* _tmp48_ = NULL;
		const gchar* _tmp49_ = NULL;
		GtkHeaderBar* _tmp50_ = NULL;
		GtkWindow* _tmp51_ = NULL;
		GtkHeaderBar* _tmp52_ = NULL;
		GMenu* menu = NULL;
		GMenu* _tmp53_ = NULL;
		GMenu* _tmp54_ = NULL;
		GMenu* _tmp55_ = NULL;
		GMenu* _tmp56_ = NULL;
		GMenu* _tmp57_ = NULL;
		const gchar* _tmp58_ = NULL;
		GMenu* _tmp59_ = NULL;
		const gchar* _tmp60_ = NULL;
		GMenu* section = NULL;
		GMenu* _tmp61_ = NULL;
		GMenu* _tmp62_ = NULL;
		GMenu* _tmp63_ = NULL;
		GMenu* _tmp64_ = NULL;
		const gchar* _tmp65_ = NULL;
		gchar* _tmp66_ = NULL;
		gchar* _tmp67_ = NULL;
		GMenu* _tmp68_ = NULL;
		const gchar* _tmp69_ = NULL;
		gchar* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
		GMenu* _tmp72_ = NULL;
		GMenu* _tmp73_ = NULL;
		GMenu* _tmp74_ = NULL;
		GMenu* _tmp75_ = NULL;
		const gchar* _tmp76_ = NULL;
		GMenu* _tmp77_ = NULL;
		const gchar* _tmp78_ = NULL;
		GMenu* _tmp79_ = NULL;
		const gchar* _tmp80_ = NULL;
		GMenu* _tmp81_ = NULL;
		_tmp46_ = (GtkHeaderBar*) gtk_header_bar_new ();
		g_object_ref_sink (_tmp46_);
		headerbar = _tmp46_;
		_tmp47_ = headerbar;
		gtk_header_bar_set_show_close_button (_tmp47_, TRUE);
		_tmp48_ = headerbar;
		_tmp49_ = _ ("Mines");
		gtk_header_bar_set_title (_tmp48_, _tmp49_);
		_tmp50_ = headerbar;
		gtk_widget_show ((GtkWidget*) _tmp50_);
		_tmp51_ = self->priv->window;
		_tmp52_ = headerbar;
		gtk_window_set_titlebar (_tmp51_, (GtkWidget*) _tmp52_);
		_tmp53_ = g_menu_new ();
		menu = _tmp53_;
		_tmp54_ = g_menu_new ();
		_g_object_unref0 (self->priv->app_main_menu);
		self->priv->app_main_menu = _tmp54_;
		_tmp55_ = menu;
		_tmp56_ = self->priv->app_main_menu;
		g_menu_append_section (_tmp55_, NULL, (GMenuModel*) _tmp56_);
		_tmp57_ = self->priv->app_main_menu;
		_tmp58_ = _ ("_New Game");
		g_menu_append (_tmp57_, _tmp58_, "app.new-game");
		_tmp59_ = self->priv->app_main_menu;
		_tmp60_ = _ ("_Scores");
		g_menu_append (_tmp59_, _tmp60_, "app.scores");
		_tmp61_ = g_menu_new ();
		section = _tmp61_;
		_tmp62_ = menu;
		_tmp63_ = section;
		g_menu_append_section (_tmp62_, NULL, (GMenuModel*) _tmp63_);
		_tmp64_ = section;
		_tmp65_ = _ ("_Show Warnings");
		_tmp66_ = g_strdup_printf ("app.%s", MINES_KEY_USE_OVERMINE_WARNING);
		_tmp67_ = _tmp66_;
		g_menu_append (_tmp64_, _tmp65_, _tmp67_);
		_g_free0 (_tmp67_);
		_tmp68_ = section;
		_tmp69_ = _ ("_Use Question Flags");
		_tmp70_ = g_strdup_printf ("app.%s", MINES_KEY_USE_QUESTION_MARKS);
		_tmp71_ = _tmp70_;
		g_menu_append (_tmp68_, _tmp69_, _tmp71_);
		_g_free0 (_tmp71_);
		_tmp72_ = g_menu_new ();
		_g_object_unref0 (section);
		section = _tmp72_;
		_tmp73_ = menu;
		_tmp74_ = section;
		g_menu_append_section (_tmp73_, NULL, (GMenuModel*) _tmp74_);
		_tmp75_ = section;
		_tmp76_ = _ ("_Help");
		g_menu_append (_tmp75_, _tmp76_, "app.help");
		_tmp77_ = section;
		_tmp78_ = _ ("_About");
		g_menu_append (_tmp77_, _tmp78_, "app.about");
		_tmp79_ = section;
		_tmp80_ = _ ("_Quit");
		g_menu_append (_tmp79_, _tmp80_, "app.quit");
		_tmp81_ = menu;
		gtk_application_set_app_menu ((GtkApplication*) self, (GMenuModel*) _tmp81_);
		_g_object_unref0 (section);
		_g_object_unref0 (menu);
		_g_object_unref0 (headerbar);
	} else {
		GMenu* menu = NULL;
		GMenu* _tmp82_ = NULL;
		GMenu* mines_menu = NULL;
		GMenu* _tmp83_ = NULL;
		GMenu* _tmp84_ = NULL;
		const gchar* _tmp85_ = NULL;
		GMenu* _tmp86_ = NULL;
		GMenu* _tmp87_ = NULL;
		const gchar* _tmp88_ = NULL;
		GMenu* _tmp89_ = NULL;
		const gchar* _tmp90_ = NULL;
		GMenu* _tmp91_ = NULL;
		const gchar* _tmp92_ = NULL;
		gchar* _tmp93_ = NULL;
		gchar* _tmp94_ = NULL;
		GMenu* _tmp95_ = NULL;
		const gchar* _tmp96_ = NULL;
		gchar* _tmp97_ = NULL;
		gchar* _tmp98_ = NULL;
		GMenu* _tmp99_ = NULL;
		const gchar* _tmp100_ = NULL;
		GMenu* help_menu = NULL;
		GMenu* _tmp101_ = NULL;
		GMenu* _tmp102_ = NULL;
		const gchar* _tmp103_ = NULL;
		GMenu* _tmp104_ = NULL;
		GMenu* _tmp105_ = NULL;
		const gchar* _tmp106_ = NULL;
		GMenu* _tmp107_ = NULL;
		const gchar* _tmp108_ = NULL;
		GMenu* _tmp109_ = NULL;
		_tmp82_ = g_menu_new ();
		menu = _tmp82_;
		_tmp83_ = g_menu_new ();
		mines_menu = _tmp83_;
		_tmp84_ = menu;
		_tmp85_ = _ ("_Mines");
		_tmp86_ = mines_menu;
		g_menu_append_submenu (_tmp84_, _tmp85_, (GMenuModel*) _tmp86_);
		_tmp87_ = mines_menu;
		_tmp88_ = _ ("_New Game");
		g_menu_append (_tmp87_, _tmp88_, "app.new-game");
		_tmp89_ = mines_menu;
		_tmp90_ = _ ("_Scores");
		g_menu_append (_tmp89_, _tmp90_, "app.scores");
		_tmp91_ = mines_menu;
		_tmp92_ = _ ("_Show Warnings");
		_tmp93_ = g_strdup_printf ("app.%s", MINES_KEY_USE_OVERMINE_WARNING);
		_tmp94_ = _tmp93_;
		g_menu_append (_tmp91_, _tmp92_, _tmp94_);
		_g_free0 (_tmp94_);
		_tmp95_ = mines_menu;
		_tmp96_ = _ ("_Use Question Flags");
		_tmp97_ = g_strdup_printf ("app.%s", MINES_KEY_USE_QUESTION_MARKS);
		_tmp98_ = _tmp97_;
		g_menu_append (_tmp95_, _tmp96_, _tmp98_);
		_g_free0 (_tmp98_);
		_tmp99_ = mines_menu;
		_tmp100_ = _ ("_Quit");
		g_menu_append (_tmp99_, _tmp100_, "app.quit");
		_tmp101_ = g_menu_new ();
		help_menu = _tmp101_;
		_tmp102_ = menu;
		_tmp103_ = _ ("_Help");
		_tmp104_ = help_menu;
		g_menu_append_submenu (_tmp102_, _tmp103_, (GMenuModel*) _tmp104_);
		_tmp105_ = help_menu;
		_tmp106_ = _ ("_Contents");
		g_menu_append (_tmp105_, _tmp106_, "app.help");
		_tmp107_ = help_menu;
		_tmp108_ = _ ("_About");
		g_menu_append (_tmp107_, _tmp108_, "app.about");
		_tmp109_ = menu;
		gtk_application_set_menubar ((GtkApplication*) self, (GMenuModel*) _tmp109_);
		_g_object_unref0 (help_menu);
		_g_object_unref0 (mines_menu);
		_g_object_unref0 (menu);
	}
	_tmp110_ = g_strdup ("<Primary>n");
	_tmp111_ = g_new0 (gchar*, 1 + 1);
	_tmp111_[0] = _tmp110_;
	_tmp112_ = _tmp111_;
	_tmp112__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp112_);
	_tmp112_ = (_vala_array_free (_tmp112_, _tmp112__length1, (GDestroyNotify) g_free), NULL);
	_tmp113_ = g_strdup ("<Primary>r");
	_tmp114_ = g_new0 (gchar*, 1 + 1);
	_tmp114_[0] = _tmp113_;
	_tmp115_ = _tmp114_;
	_tmp115__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.repeat-size", _tmp115_);
	_tmp115_ = (_vala_array_free (_tmp115_, _tmp115__length1, (GDestroyNotify) g_free), NULL);
	_tmp116_ = g_strdup ("Pause");
	_tmp117_ = g_new0 (gchar*, 1 + 1);
	_tmp117_[0] = _tmp116_;
	_tmp118_ = _tmp117_;
	_tmp118__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.pause", _tmp118_);
	_tmp118_ = (_vala_array_free (_tmp118_, _tmp118__length1, (GDestroyNotify) g_free), NULL);
	_tmp119_ = g_strdup ("F1");
	_tmp120_ = g_new0 (gchar*, 1 + 1);
	_tmp120_[0] = _tmp119_;
	_tmp121_ = _tmp120_;
	_tmp121__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp121_);
	_tmp121_ = (_vala_array_free (_tmp121_, _tmp121__length1, (GDestroyNotify) g_free), NULL);
	_tmp122_ = g_strdup ("<Primary>q");
	_tmp123_ = g_strdup ("<Primary>w");
	_tmp124_ = g_new0 (gchar*, 2 + 1);
	_tmp124_[0] = _tmp122_;
	_tmp124_[1] = _tmp123_;
	_tmp125_ = _tmp124_;
	_tmp125__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp125_);
	_tmp125_ = (_vala_array_free (_tmp125_, _tmp125__length1, (GDestroyNotify) g_free), NULL);
	_tmp126_ = self->priv->settings;
	_tmp127_ = minefield_view_new (_tmp126_);
	g_object_ref_sink (_tmp127_);
	_g_object_unref0 (self->priv->minefield_view);
	self->priv->minefield_view = _tmp127_;
	_tmp128_ = self->priv->minefield_view;
	gtk_widget_show ((GtkWidget*) _tmp128_);
	_tmp129_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp129_);
	_g_object_unref0 (self->priv->scrolled);
	self->priv->scrolled = _tmp129_;
	_tmp130_ = self->priv->scrolled;
	gtk_widget_show ((GtkWidget*) _tmp130_);
	_tmp131_ = self->priv->scrolled;
	_tmp132_ = self->priv->minefield_view;
	gtk_container_add ((GtkContainer*) _tmp131_, (GtkWidget*) _tmp132_);
	_tmp133_ = gtk_builder_get_object (ui_builder, "minefield_overlay");
	_tmp134_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp133_, gtk_overlay_get_type (), GtkOverlay));
	_g_object_unref0 (self->priv->minefield_overlay);
	self->priv->minefield_overlay = _tmp134_;
	_tmp135_ = self->priv->minefield_overlay;
	_tmp136_ = self->priv->scrolled;
	gtk_container_add ((GtkContainer*) _tmp135_, (GtkWidget*) _tmp136_);
	_tmp137_ = self->priv->minefield_overlay;
	gtk_widget_show ((GtkWidget*) _tmp137_);
	_tmp138_ = gtk_builder_get_object (ui_builder, "minefield_aspect");
	_tmp139_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp138_, gtk_aspect_frame_get_type (), GtkAspectFrame));
	_g_object_unref0 (self->priv->minefield_aspect);
	self->priv->minefield_aspect = _tmp139_;
	_tmp140_ = self->priv->minefield_aspect;
	gtk_widget_show ((GtkWidget*) _tmp140_);
	_tmp141_ = gtk_builder_get_object (ui_builder, "paused_box");
	_tmp142_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp141_, gtk_box_get_type (), GtkBox));
	_g_object_unref0 (self->priv->paused_box);
	self->priv->paused_box = _tmp142_;
	_tmp143_ = self->priv->paused_box;
	g_signal_connect_object ((GtkWidget*) _tmp143_, "button-press-event", (GCallback) _mines_view_button_press_event_gtk_widget_button_press_event, self, 0);
	_tmp144_ = self->priv->minefield_overlay;
	_tmp145_ = self->priv->paused_box;
	gtk_overlay_add_overlay (_tmp144_, (GtkWidget*) _tmp145_);
	_tmp146_ = gtk_builder_get_object (ui_builder, "main_screen");
	_tmp147_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp146_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->main_screen);
	self->priv->main_screen = _tmp147_;
	mines_startup_new_game_screen (self, ui_builder);
	mines_startup_custom_game_screen (self, ui_builder);
	_tmp148_ = g_get_user_data_dir ();
	_tmp149_ = g_build_filename (_tmp148_, "gnome-mines", "history", NULL);
	_tmp150_ = _tmp149_;
	_tmp151_ = history_new (_tmp150_);
	_g_object_unref0 (self->priv->history);
	self->priv->history = _tmp151_;
	_g_free0 (_tmp150_);
	_tmp152_ = self->priv->history;
	history_load (_tmp152_);
	_tmp153_ = gtk_builder_get_object (ui_builder, "flag_label");
	_tmp154_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp153_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->flag_label);
	self->priv->flag_label = _tmp154_;
	_tmp155_ = gtk_builder_get_object (ui_builder, "clock_label");
	_tmp156_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp155_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->clock_label);
	self->priv->clock_label = _tmp156_;
	_tmp157_ = gtk_builder_get_object (ui_builder, "play_pause_button");
	_tmp158_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp157_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->play_pause_button);
	self->priv->play_pause_button = _tmp158_;
	_tmp159_ = gtk_builder_get_object (ui_builder, "play_pause_label");
	_tmp160_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp159_, gtk_label_get_type (), GtkLabel));
	_g_object_unref0 (self->priv->play_pause_label);
	self->priv->play_pause_label = _tmp160_;
	_tmp161_ = gtk_builder_get_object (ui_builder, "high_scores_button");
	_tmp162_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp161_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->high_scores_button);
	self->priv->high_scores_button = _tmp162_;
	_tmp163_ = gtk_builder_get_object (ui_builder, "replay_button");
	_tmp164_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->replay_button);
	self->priv->replay_button = _tmp164_;
	_tmp165_ = gtk_builder_get_object (ui_builder, "new_game_button");
	_tmp166_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp165_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->new_game_button);
	self->priv->new_game_button = _tmp166_;
	_g_object_unref0 (ui_builder);
	_g_free0 (css_path);
	_g_object_unref0 (css_provider);
}


static void _mines_small_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_small_size_clicked_cb ((Mines*) self);
}


static void _mines_medium_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_medium_size_clicked_cb ((Mines*) self);
}


static void _mines_large_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_large_size_clicked_cb ((Mines*) self);
}


static void _mines_show_custom_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_show_custom_game_screen ((Mines*) self);
}


static void mines_startup_new_game_screen (Mines* self, GtkBuilder* builder) {
	GtkBuilder* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkAspectFrame* _tmp2_ = NULL;
	GtkButton* button = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	GtkLabel* label = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkButton* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkBuilder* _tmp14_ = NULL;
	GObject* _tmp15_ = NULL;
	GtkButton* _tmp16_ = NULL;
	GtkButton* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkButton* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	GtkBuilder* _tmp25_ = NULL;
	GObject* _tmp26_ = NULL;
	GtkButton* _tmp27_ = NULL;
	GtkButton* _tmp28_ = NULL;
	GtkLabel* _tmp29_ = NULL;
	GtkLabel* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	GtkLabel* _tmp33_ = NULL;
	GtkButton* _tmp34_ = NULL;
	GtkLabel* _tmp35_ = NULL;
	GtkBuilder* _tmp36_ = NULL;
	GObject* _tmp37_ = NULL;
	GtkButton* _tmp38_ = NULL;
	GtkButton* _tmp39_ = NULL;
	GtkLabel* _tmp40_ = NULL;
	GtkLabel* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	GtkLabel* _tmp46_ = NULL;
	GtkButton* _tmp47_ = NULL;
	GtkLabel* _tmp48_ = NULL;
	GtkAspectFrame* _tmp49_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "new_game_screen");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_aspect_frame_get_type (), GtkAspectFrame));
	_g_object_unref0 (self->priv->new_game_screen);
	self->priv->new_game_screen = _tmp2_;
	_tmp3_ = builder;
	_tmp4_ = gtk_builder_get_object (_tmp3_, "small_size_btn");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_button_get_type (), GtkButton));
	button = _tmp5_;
	_tmp6_ = button;
	g_signal_connect_object (_tmp6_, "clicked", (GCallback) _mines_small_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp7_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp7_);
	label = _tmp7_;
	_tmp8_ = label;
	_tmp9_ = mines_make_minefield_description (self, 8, 8, 10);
	_tmp10_ = _tmp9_;
	gtk_label_set_markup (_tmp8_, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = label;
	gtk_label_set_justify (_tmp11_, GTK_JUSTIFY_CENTER);
	_tmp12_ = button;
	_tmp13_ = label;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = builder;
	_tmp15_ = gtk_builder_get_object (_tmp14_, "medium_size_btn");
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (button);
	button = _tmp16_;
	_tmp17_ = button;
	g_signal_connect_object (_tmp17_, "clicked", (GCallback) _mines_medium_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp18_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (label);
	label = _tmp18_;
	_tmp19_ = label;
	_tmp20_ = mines_make_minefield_description (self, 16, 16, 40);
	_tmp21_ = _tmp20_;
	gtk_label_set_markup (_tmp19_, _tmp21_);
	_g_free0 (_tmp21_);
	_tmp22_ = label;
	gtk_label_set_justify (_tmp22_, GTK_JUSTIFY_CENTER);
	_tmp23_ = button;
	_tmp24_ = label;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = builder;
	_tmp26_ = gtk_builder_get_object (_tmp25_, "large_size_btn");
	_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (button);
	button = _tmp27_;
	_tmp28_ = button;
	g_signal_connect_object (_tmp28_, "clicked", (GCallback) _mines_large_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp29_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (label);
	label = _tmp29_;
	_tmp30_ = label;
	_tmp31_ = mines_make_minefield_description (self, 30, 16, 99);
	_tmp32_ = _tmp31_;
	gtk_label_set_markup (_tmp30_, _tmp32_);
	_g_free0 (_tmp32_);
	_tmp33_ = label;
	gtk_label_set_justify (_tmp33_, GTK_JUSTIFY_CENTER);
	_tmp34_ = button;
	_tmp35_ = label;
	gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = builder;
	_tmp37_ = gtk_builder_get_object (_tmp36_, "custom_size_btn");
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (button);
	button = _tmp38_;
	_tmp39_ = button;
	g_signal_connect_object (_tmp39_, "clicked", (GCallback) _mines_show_custom_game_screen_gtk_button_clicked, self, 0);
	_tmp40_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (label);
	label = _tmp40_;
	_tmp41_ = label;
	_tmp42_ = _ ("Custom");
	_tmp43_ = g_dpgettext2 (NULL, "board size", _tmp42_);
	_tmp44_ = g_strconcat ("<span size='xx-large' weight='heavy'>?</span>\n", _tmp43_, NULL);
	_tmp45_ = _tmp44_;
	gtk_label_set_markup_with_mnemonic (_tmp41_, _tmp45_);
	_g_free0 (_tmp45_);
	_tmp46_ = label;
	gtk_label_set_justify (_tmp46_, GTK_JUSTIFY_CENTER);
	_tmp47_ = button;
	_tmp48_ = label;
	gtk_container_add ((GtkContainer*) _tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = self->priv->new_game_screen;
	gtk_widget_show_all ((GtkWidget*) _tmp49_);
	_g_object_unref0 (label);
	_g_object_unref0 (button);
}


static void _mines_xsize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	mines_xsize_spin_cb ((Mines*) self, _sender);
}


static void _mines_ysize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	mines_ysize_spin_cb ((Mines*) self, _sender);
}


static void _mines_mines_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	mines_mines_spin_cb ((Mines*) self, _sender);
}


static void _mines_show_new_game_screen_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_show_new_game_screen ((Mines*) self);
}


static void _mines_custom_size_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	mines_custom_size_clicked_cb ((Mines*) self);
}


static void mines_startup_custom_game_screen (Mines* self, GtkBuilder* builder) {
	GtkBuilder* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkAspectFrame* _tmp2_ = NULL;
	GtkSpinButton* field_width_entry = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GtkSpinButton* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GtkSpinButton* field_height_entry = NULL;
	GtkBuilder* _tmp8_ = NULL;
	GObject* _tmp9_ = NULL;
	GtkSpinButton* _tmp10_ = NULL;
	GSettings* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GtkBuilder* _tmp13_ = NULL;
	GObject* _tmp14_ = NULL;
	GtkSpinButton* _tmp15_ = NULL;
	GtkSpinButton* _tmp16_ = NULL;
	GtkSpinButton* _tmp17_ = NULL;
	GtkButton* button = NULL;
	GtkBuilder* _tmp18_ = NULL;
	GObject* _tmp19_ = NULL;
	GtkButton* _tmp20_ = NULL;
	GtkButton* _tmp21_ = NULL;
	GtkBuilder* _tmp22_ = NULL;
	GObject* _tmp23_ = NULL;
	GtkButton* _tmp24_ = NULL;
	GtkButton* _tmp25_ = NULL;
	GtkAspectFrame* _tmp26_ = NULL;
	GtkAspectFrame* _tmp27_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = builder;
	_tmp1_ = gtk_builder_get_object (_tmp0_, "custom_game_screen");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_aspect_frame_get_type (), GtkAspectFrame));
	_g_object_unref0 (self->priv->custom_game_screen);
	self->priv->custom_game_screen = _tmp2_;
	_tmp3_ = builder;
	_tmp4_ = gtk_builder_get_object (_tmp3_, "width_spin_btn");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_spin_button_get_type (), GtkSpinButton));
	field_width_entry = _tmp5_;
	gtk_spin_button_set_range (field_width_entry, (gdouble) MINES_XSIZE_MIN, (gdouble) MINES_XSIZE_MAX);
	g_signal_connect_object (field_width_entry, "value-changed", (GCallback) _mines_xsize_spin_cb_gtk_spin_button_value_changed, self, 0);
	_tmp6_ = self->priv->settings;
	_tmp7_ = g_settings_get_int (_tmp6_, MINES_KEY_XSIZE);
	gtk_spin_button_set_value (field_width_entry, (gdouble) _tmp7_);
	_tmp8_ = builder;
	_tmp9_ = gtk_builder_get_object (_tmp8_, "height_spin_btn");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_spin_button_get_type (), GtkSpinButton));
	field_height_entry = _tmp10_;
	gtk_spin_button_set_range (field_height_entry, (gdouble) MINES_YSIZE_MIN, (gdouble) MINES_YSIZE_MAX);
	g_signal_connect_object (field_height_entry, "value-changed", (GCallback) _mines_ysize_spin_cb_gtk_spin_button_value_changed, self, 0);
	_tmp11_ = self->priv->settings;
	_tmp12_ = g_settings_get_int (_tmp11_, MINES_KEY_YSIZE);
	gtk_spin_button_set_value (field_height_entry, (gdouble) _tmp12_);
	_tmp13_ = builder;
	_tmp14_ = gtk_builder_get_object (_tmp13_, "mines_spin_btn");
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_spin_button_get_type (), GtkSpinButton));
	_g_object_unref0 (self->priv->mines_spin);
	self->priv->mines_spin = _tmp15_;
	_tmp16_ = self->priv->mines_spin;
	gtk_spin_button_set_range (_tmp16_, (gdouble) 1, (gdouble) 100);
	_tmp17_ = self->priv->mines_spin;
	g_signal_connect_object (_tmp17_, "value-changed", (GCallback) _mines_mines_spin_cb_gtk_spin_button_value_changed, self, 0);
	mines_set_mines_limit (self);
	_tmp18_ = builder;
	_tmp19_ = gtk_builder_get_object (_tmp18_, "cancel_btn");
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_button_get_type (), GtkButton));
	button = _tmp20_;
	_tmp21_ = button;
	g_signal_connect_object (_tmp21_, "clicked", (GCallback) _mines_show_new_game_screen_gtk_button_clicked, self, 0);
	_tmp22_ = builder;
	_tmp23_ = gtk_builder_get_object (_tmp22_, "play_game_btn");
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (button);
	button = _tmp24_;
	_tmp25_ = button;
	g_signal_connect_object (_tmp25_, "clicked", (GCallback) _mines_custom_size_clicked_cb_gtk_button_clicked, self, 0);
	_tmp26_ = self->priv->custom_game_screen;
	gtk_widget_show_all ((GtkWidget*) _tmp26_);
	_tmp27_ = self->priv->custom_game_screen;
	gtk_widget_hide ((GtkWidget*) _tmp27_);
	_g_object_unref0 (button);
	_g_object_unref0 (field_height_entry);
	_g_object_unref0 (field_width_entry);
}


static gboolean mines_window_configure_event_cb (Mines* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->is_maximized;
	if (!_tmp1_) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->priv->window_skip_configure;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GdkEventConfigure* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		GdkEventConfigure* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp3_ = event;
		_tmp4_ = _tmp3_->width;
		self->priv->window_width = _tmp4_;
		_tmp5_ = event;
		_tmp6_ = _tmp5_->height;
		self->priv->window_height = _tmp6_;
	}
	self->priv->window_skip_configure = FALSE;
	result = FALSE;
	return result;
}


static gboolean mines_window_state_event_cb (Mines* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
		_tmp2_ = event;
		_tmp3_ = _tmp2_->new_window_state;
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	result = FALSE;
	return result;
}


static gboolean mines_window_focus_out_event_cb (Mines* self, GdkEventFocus* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->minefield;
	if (_tmp1_ != NULL) {
		Minefield* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->minefield;
		_tmp3_ = minefield_is_clock_started (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Minefield* _tmp4_ = NULL;
		_tmp4_ = self->priv->minefield;
		minefield_set_paused (_tmp4_, TRUE);
	}
	result = FALSE;
	return result;
}


static gboolean mines_window_focus_in_event_cb (Mines* self, GdkEventFocus* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->minefield;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->priv->pause_requested;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Minefield* _tmp3_ = NULL;
		_tmp3_ = self->priv->minefield;
		minefield_set_paused (_tmp3_, FALSE);
	}
	result = FALSE;
	return result;
}


static gchar* mines_make_minefield_description (Mines* self, gint width, gint height, gint n_mines) {
	gchar* result = NULL;
	gchar* size_label = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* mines_label = NULL;
	gint _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = width;
	_tmp1_ = height;
	_tmp2_ = g_strdup_printf ("%d × %d", _tmp0_, _tmp1_);
	size_label = _tmp2_;
	_tmp3_ = n_mines;
	_tmp4_ = ngettext ("<b>%d</b> mine", "<b>%d</b> mines", (gulong) _tmp3_);
	_tmp5_ = n_mines;
	_tmp6_ = g_strdup_printf (_tmp4_, _tmp5_);
	mines_label = _tmp6_;
	_tmp7_ = g_strdup_printf ("<span size='x-large' weight='ultrabold'>%s</span>\n%s", size_label, mines_label);
	result = _tmp7_;
	_g_free0 (mines_label);
	_g_free0 (size_label);
	return result;
}


void mines_start (Mines* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	mines_show_new_game_screen (self);
}


static void mines_real_shutdown (GApplication* base) {
	Mines * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GSettings* _tmp6_ = NULL;
	self = (Mines*) base;
	G_APPLICATION_CLASS (mines_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->window_width;
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->window_height;
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
	_tmp6_ = self->priv->settings;
	g_settings_apply (_tmp6_);
}


static void mines_real_activate (GApplication* base) {
	Mines * self;
	GtkWindow* _tmp0_ = NULL;
	self = (Mines*) base;
	_tmp0_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}


static gboolean mines_view_button_press_event (Mines* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	Minefield* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->minefield;
	_tmp1_ = minefield_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Minefield* _tmp3_ = NULL;
		_tmp3_ = self->priv->minefield;
		minefield_set_paused (_tmp3_, FALSE);
		self->priv->pause_requested = FALSE;
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void mines_quit_cb (Mines* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void mines_update_flag_label (Mines* self) {
	GtkLabel* _tmp0_ = NULL;
	Minefield* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	Minefield* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->flag_label;
	_tmp1_ = self->priv->minefield;
	_tmp2_ = minefield_get_n_flags (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->minefield;
	_tmp5_ = _tmp4_->n_mines;
	_tmp6_ = g_strdup_printf ("%u/%u", _tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_label_set_text (_tmp0_, _tmp7_);
	_g_free0 (_tmp7_);
}


static gint mines_show_scores (Mines* self, HistoryEntry* selected_entry, gboolean show_close) {
	gint result = 0;
	ScoreDialog* dialog = NULL;
	History* _tmp0_ = NULL;
	HistoryEntry* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	ScoreDialog* _tmp3_ = NULL;
	GtkWindow* _tmp4_ = NULL;
	gint _result_ = 0;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->history;
	_tmp1_ = selected_entry;
	_tmp2_ = show_close;
	_tmp3_ = score_dialog_new (_tmp0_, _tmp1_, _tmp2_);
	g_object_ref_sink (_tmp3_);
	dialog = _tmp3_;
	gtk_window_set_modal ((GtkWindow*) dialog, TRUE);
	_tmp4_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) dialog, _tmp4_);
	_tmp5_ = gtk_dialog_run ((GtkDialog*) dialog);
	_result_ = _tmp5_;
	gtk_widget_destroy ((GtkWidget*) dialog);
	result = _result_;
	_g_object_unref0 (dialog);
	return result;
}


static void mines_scores_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_show_scores (self, NULL, FALSE);
}


static void mines_show_custom_game_screen (Mines* self) {
	GtkAspectFrame* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkAspectFrame* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->is_new_game_screen = FALSE;
	_tmp0_ = self->priv->custom_game_screen;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->main_screen;
	gtk_widget_hide (_tmp1_);
	_tmp2_ = self->priv->new_game_screen;
	gtk_widget_hide ((GtkWidget*) _tmp2_);
}


static gboolean mines_can_start_new_game (Mines* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Minefield* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->minefield;
	if (_tmp3_ != NULL) {
		Minefield* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		guint _tmp6_ = 0U;
		_tmp4_ = self->priv->minefield;
		_tmp5_ = minefield_get_n_cleared (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ > ((guint) 0);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		Minefield* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = self->priv->minefield;
		_tmp8_ = _tmp7_->exploded;
		_tmp1_ = !_tmp8_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Minefield* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		_tmp9_ = self->priv->minefield;
		_tmp10_ = minefield_get_is_complete (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp0_ = !_tmp11_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean was_paused = FALSE;
		Minefield* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		Minefield* _tmp15_ = NULL;
		GtkMessageDialog* dialog = NULL;
		GtkWindow* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		GtkMessageDialog* _tmp18_ = NULL;
		GtkMessageDialog* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		GtkMessageDialog* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gint _result_ = 0;
		GtkMessageDialog* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		GtkMessageDialog* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		_tmp12_ = self->priv->minefield;
		_tmp13_ = minefield_get_paused (_tmp12_);
		_tmp14_ = _tmp13_;
		was_paused = _tmp14_;
		_tmp15_ = self->priv->minefield;
		minefield_set_paused (_tmp15_, TRUE);
		_tmp16_ = self->priv->window;
		_tmp17_ = _ ("Do you want to start a new game?");
		_tmp18_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp16_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp17_);
		g_object_ref_sink (_tmp18_);
		dialog = _tmp18_;
		_tmp19_ = dialog;
		_tmp20_ = _ ("If you start a new game, your current progress will be lost.");
		g_object_set (_tmp19_, "secondary-text", _tmp20_, NULL);
		_tmp21_ = dialog;
		_tmp22_ = _ ("Keep Current Game");
		_tmp23_ = _ ("Start New Game");
		gtk_dialog_add_buttons ((GtkDialog*) _tmp21_, _tmp22_, GTK_RESPONSE_DELETE_EVENT, _tmp23_, GTK_RESPONSE_ACCEPT, NULL, NULL);
		_tmp24_ = dialog;
		_tmp25_ = gtk_dialog_run ((GtkDialog*) _tmp24_);
		_result_ = _tmp25_;
		_tmp26_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp26_);
		_tmp27_ = _result_;
		if (_tmp27_ != ((gint) GTK_RESPONSE_ACCEPT)) {
			Minefield* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
			_tmp28_ = self->priv->minefield;
			_tmp29_ = was_paused;
			minefield_set_paused (_tmp28_, _tmp29_);
			result = FALSE;
			_g_object_unref0 (dialog);
			return result;
		}
		_g_object_unref0 (dialog);
	}
	result = TRUE;
	return result;
}


static void mines_show_new_game_screen (Mines* self) {
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_ = NULL;
	GtkAspectFrame* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkAspectFrame* _tmp6_ = NULL;
	GtkWindow* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GtkButton* _tmp10_ = NULL;
	GSimpleAction* _tmp11_ = NULL;
	GSimpleAction* _tmp12_ = NULL;
	GSimpleAction* _tmp13_ = NULL;
	GtkWidget* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_new_game_screen;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->minefield;
	if (_tmp1_ != NULL) {
		Minefield* _tmp2_ = NULL;
		Minefield* _tmp3_ = NULL;
		_tmp2_ = self->priv->minefield;
		minefield_set_paused (_tmp2_, FALSE);
		self->priv->pause_requested = FALSE;
		_tmp3_ = self->priv->minefield;
		g_signal_handlers_disconnect_by_func (_tmp3_, NULL, self);
	}
	_g_object_unref0 (self->priv->minefield);
	self->priv->minefield = NULL;
	self->priv->is_new_game_screen = TRUE;
	_tmp4_ = self->priv->custom_game_screen;
	gtk_widget_hide ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->main_screen;
	gtk_widget_hide (_tmp5_);
	_tmp6_ = self->priv->new_game_screen;
	gtk_widget_show ((GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->window;
	_tmp8_ = self->priv->window_width;
	_tmp9_ = self->priv->window_height;
	gtk_window_resize (_tmp7_, _tmp8_, _tmp9_);
	_tmp10_ = self->priv->new_game_button;
	gtk_widget_show ((GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp11_, FALSE);
	_tmp12_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp12_, FALSE);
	_tmp13_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp13_, FALSE);
	_tmp14_ = self->priv->main_screen;
	gtk_widget_hide (_tmp14_);
}


static void _mines_marks_changed_cb_minefield_marks_changed (Minefield* _sender, gpointer self) {
	mines_marks_changed_cb ((Mines*) self, _sender);
}


static void _mines_explode_cb_minefield_explode (Minefield* _sender, gpointer self) {
	mines_explode_cb ((Mines*) self, _sender);
}


static void _mines_cleared_cb_minefield_cleared (Minefield* _sender, gpointer self) {
	mines_cleared_cb ((Mines*) self, _sender);
}


static void _mines_tick_cb_minefield_tick (Minefield* _sender, gpointer self) {
	mines_tick_cb ((Mines*) self);
}


static void _mines_paused_changed_cb_minefield_paused_changed (Minefield* _sender, gpointer self) {
	mines_paused_changed_cb ((Mines*) self);
}


static void _mines_clock_started_cb_minefield_clock_started (Minefield* _sender, gpointer self) {
	mines_clock_started_cb ((Mines*) self);
}


static void mines_start_game (Mines* self) {
	GtkAspectFrame* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	MinefieldView* _tmp2_ = NULL;
	GtkAspectFrame* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	GtkWidget* _tmp8_ = NULL;
	gint x = 0;
	gint y = 0;
	gint n = 0;
	GSettings* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	Minefield* _tmp22_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	Minefield* _tmp27_ = NULL;
	Minefield* _tmp28_ = NULL;
	Minefield* _tmp29_ = NULL;
	Minefield* _tmp30_ = NULL;
	Minefield* _tmp31_ = NULL;
	Minefield* _tmp32_ = NULL;
	Minefield* _tmp33_ = NULL;
	GtkAspectFrame* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	MinefieldView* _tmp37_ = NULL;
	Minefield* _tmp38_ = NULL;
	gint request_x = 0;
	gint request_y = 0;
	GtkWindow* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	GtkScrolledWindow* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	GtkWindow* _tmp51_ = NULL;
	gint _tmp52_ = 0;
	GtkScrolledWindow* _tmp53_ = NULL;
	gint _tmp54_ = 0;
	gint _tmp55_ = 0;
	gint _tmp56_ = 0;
	GtkAspectFrame* _tmp63_ = NULL;
	gint _tmp64_ = 0;
	gint _tmp65_ = 0;
	GSimpleAction* _tmp66_ = NULL;
	GSimpleAction* _tmp67_ = NULL;
	GSimpleAction* _tmp68_ = NULL;
	Minefield* _tmp69_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->is_new_game_screen = FALSE;
	_tmp0_ = self->priv->custom_game_screen;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	self->priv->window_skip_configure = TRUE;
	_tmp1_ = self->priv->main_screen;
	gtk_widget_show (_tmp1_);
	_tmp2_ = self->priv->minefield_view;
	g_object_set ((GtkWidget*) _tmp2_, "has-focus", TRUE, NULL);
	_tmp3_ = self->priv->new_game_screen;
	gtk_widget_hide ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->play_pause_button;
	gtk_widget_hide ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->replay_button;
	gtk_widget_hide ((GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->new_game_button;
	gtk_widget_hide ((GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->high_scores_button;
	gtk_widget_hide ((GtkWidget*) _tmp7_);
	_tmp8_ = self->priv->main_screen;
	gtk_widget_show (_tmp8_);
	mines_tick_cb (self);
	_tmp9_ = self->priv->settings;
	_tmp10_ = g_settings_get_int (_tmp9_, MINES_KEY_MODE);
	switch (_tmp10_) {
		case 0:
		{
			x = 8;
			y = 8;
			n = 10;
			break;
		}
		case 1:
		{
			x = 16;
			y = 16;
			n = 40;
			break;
		}
		case 2:
		{
			x = 30;
			y = 16;
			n = 99;
			break;
		}
		default:
		case 3:
		{
			GSettings* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			GSettings* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			GSettings* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			_tmp11_ = self->priv->settings;
			_tmp12_ = g_settings_get_int (_tmp11_, MINES_KEY_XSIZE);
			_tmp13_ = CLAMP (_tmp12_, MINES_XSIZE_MIN, MINES_XSIZE_MAX);
			x = _tmp13_;
			_tmp14_ = self->priv->settings;
			_tmp15_ = g_settings_get_int (_tmp14_, MINES_KEY_YSIZE);
			_tmp16_ = CLAMP (_tmp15_, MINES_YSIZE_MIN, MINES_YSIZE_MAX);
			y = _tmp16_;
			_tmp17_ = self->priv->settings;
			_tmp18_ = g_settings_get_int (_tmp17_, MINES_KEY_NMINES);
			_tmp19_ = x;
			_tmp20_ = y;
			_tmp21_ = CLAMP (_tmp18_, 1, (_tmp19_ * _tmp20_) - 10);
			n = _tmp21_;
			break;
		}
	}
	_tmp22_ = self->priv->minefield;
	if (_tmp22_ != NULL) {
		Minefield* _tmp23_ = NULL;
		_tmp23_ = self->priv->minefield;
		g_signal_handlers_disconnect_by_func (_tmp23_, NULL, self);
	}
	_tmp24_ = x;
	_tmp25_ = y;
	_tmp26_ = n;
	_tmp27_ = minefield_new ((guint) _tmp24_, (guint) _tmp25_, (guint) _tmp26_);
	_g_object_unref0 (self->priv->minefield);
	self->priv->minefield = _tmp27_;
	_tmp28_ = self->priv->minefield;
	g_signal_connect_object (_tmp28_, "marks-changed", (GCallback) _mines_marks_changed_cb_minefield_marks_changed, self, 0);
	_tmp29_ = self->priv->minefield;
	g_signal_connect_object (_tmp29_, "explode", (GCallback) _mines_explode_cb_minefield_explode, self, 0);
	_tmp30_ = self->priv->minefield;
	g_signal_connect_object (_tmp30_, "cleared", (GCallback) _mines_cleared_cb_minefield_cleared, self, 0);
	_tmp31_ = self->priv->minefield;
	g_signal_connect_object (_tmp31_, "tick", (GCallback) _mines_tick_cb_minefield_tick, self, 0);
	_tmp32_ = self->priv->minefield;
	g_signal_connect_object (_tmp32_, "paused-changed", (GCallback) _mines_paused_changed_cb_minefield_paused_changed, self, 0);
	_tmp33_ = self->priv->minefield;
	g_signal_connect_object (_tmp33_, "clock-started", (GCallback) _mines_clock_started_cb_minefield_clock_started, self, 0);
	_tmp34_ = self->priv->minefield_aspect;
	_tmp35_ = x;
	_tmp36_ = y;
	g_object_set (_tmp34_, "ratio", ((gfloat) _tmp35_) / _tmp36_, NULL);
	_tmp37_ = self->priv->minefield_view;
	_tmp38_ = self->priv->minefield;
	minefield_view_set_minefield (_tmp37_, _tmp38_);
	request_x = -1;
	request_y = -1;
	_tmp39_ = self->priv->window;
	_tmp40_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp39_);
	_tmp41_ = self->priv->scrolled;
	_tmp42_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp41_);
	_tmp43_ = x;
	_tmp44_ = gdk_screen_width ();
	if (((_tmp40_ - _tmp42_) + (30 * _tmp43_)) < _tmp44_) {
		gint _tmp45_ = 0;
		_tmp45_ = x;
		request_x = 30 * _tmp45_;
	} else {
		gint _tmp46_ = 0;
		GtkWindow* _tmp47_ = NULL;
		gint _tmp48_ = 0;
		GtkScrolledWindow* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		_tmp46_ = gdk_screen_width ();
		_tmp47_ = self->priv->window;
		_tmp48_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp47_);
		_tmp49_ = self->priv->scrolled;
		_tmp50_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp49_);
		request_x = (_tmp46_ - _tmp48_) + _tmp50_;
	}
	_tmp51_ = self->priv->window;
	_tmp52_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp51_);
	_tmp53_ = self->priv->scrolled;
	_tmp54_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp53_);
	_tmp55_ = y;
	_tmp56_ = gdk_screen_height ();
	if (((_tmp52_ - _tmp54_) + (30 * _tmp55_)) < _tmp56_) {
		gint _tmp57_ = 0;
		_tmp57_ = y;
		request_y = 30 * _tmp57_;
	} else {
		gint _tmp58_ = 0;
		GtkWindow* _tmp59_ = NULL;
		gint _tmp60_ = 0;
		GtkScrolledWindow* _tmp61_ = NULL;
		gint _tmp62_ = 0;
		_tmp58_ = gdk_screen_height ();
		_tmp59_ = self->priv->window;
		_tmp60_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp59_);
		_tmp61_ = self->priv->scrolled;
		_tmp62_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp61_);
		request_y = (_tmp58_ - _tmp60_) + _tmp62_;
	}
	_tmp63_ = self->priv->minefield_aspect;
	_tmp64_ = request_x;
	_tmp65_ = request_y;
	gtk_widget_set_size_request ((GtkWidget*) _tmp63_, _tmp64_, _tmp65_);
	mines_update_flag_label (self);
	_tmp66_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp66_, TRUE);
	_tmp67_ = self->priv->repeat_size_action;
	g_simple_action_set_enabled (_tmp67_, TRUE);
	_tmp68_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp68_, TRUE);
	_tmp69_ = self->priv->minefield;
	minefield_set_paused (_tmp69_, FALSE);
	self->priv->pause_requested = FALSE;
}


static void mines_new_game_cb (Mines* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = mines_can_start_new_game (self);
	if (_tmp0_) {
		mines_show_new_game_screen (self);
	}
}


static void mines_repeat_size_cb (Mines* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = mines_can_start_new_game (self);
	if (_tmp0_) {
		mines_start_game (self);
	}
}


static void mines_toggle_pause_cb (Mines* self) {
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->minefield;
	_tmp2_ = minefield_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = self->priv->pause_requested;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->pause_requested = TRUE;
	} else {
		Minefield* _tmp5_ = NULL;
		Minefield* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		Minefield* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		_tmp5_ = self->priv->minefield;
		_tmp6_ = self->priv->minefield;
		_tmp7_ = minefield_get_paused (_tmp6_);
		_tmp8_ = _tmp7_;
		minefield_set_paused (_tmp5_, !_tmp8_);
		_tmp9_ = self->priv->minefield;
		_tmp10_ = minefield_get_paused (_tmp9_);
		_tmp11_ = _tmp10_;
		self->priv->pause_requested = _tmp11_;
	}
}


static void mines_paused_changed_cb (Mines* self) {
	Minefield* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkBox* _tmp6_ = NULL;
	Minefield* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->minefield;
	_tmp1_ = minefield_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		mines_display_unpause_button (self);
	} else {
		Minefield* _tmp3_ = NULL;
		gdouble _tmp4_ = 0.0;
		gdouble _tmp5_ = 0.0;
		_tmp3_ = self->priv->minefield;
		_tmp4_ = minefield_get_elapsed (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ > ((gdouble) 0)) {
			mines_display_pause_button (self);
		}
	}
	_tmp6_ = self->priv->paused_box;
	_tmp7_ = self->priv->minefield;
	_tmp8_ = minefield_get_paused (_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, _tmp9_);
}


static void mines_marks_changed_cb (Mines* self, Minefield* minefield) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	mines_update_flag_label (self);
}


static void mines_explode_cb (Mines* self, Minefield* minefield) {
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	_tmp0_ = self->priv->new_game_button;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->replay_button;
	gtk_widget_show ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->high_scores_button;
	gtk_widget_show ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp3_, FALSE);
	_tmp4_ = self->priv->play_pause_button;
	gtk_widget_hide ((GtkWidget*) _tmp4_);
}


static void mines_cleared_cb (Mines* self, Minefield* minefield) {
	GDateTime* date = NULL;
	GDateTime* _tmp0_ = NULL;
	guint duration = 0U;
	Minefield* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	HistoryEntry* entry = NULL;
	GDateTime* _tmp4_ = NULL;
	Minefield* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	Minefield* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	Minefield* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	HistoryEntry* _tmp12_ = NULL;
	History* _tmp13_ = NULL;
	HistoryEntry* _tmp14_ = NULL;
	History* _tmp15_ = NULL;
	HistoryEntry* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	_tmp0_ = g_date_time_new_now_local ();
	date = _tmp0_;
	_tmp1_ = minefield;
	_tmp2_ = minefield_get_elapsed (_tmp1_);
	_tmp3_ = _tmp2_;
	duration = (guint) (_tmp3_ + 0.5);
	_tmp4_ = date;
	_tmp5_ = minefield;
	_tmp6_ = _tmp5_->width;
	_tmp7_ = minefield;
	_tmp8_ = _tmp7_->height;
	_tmp9_ = minefield;
	_tmp10_ = _tmp9_->n_mines;
	_tmp11_ = duration;
	_tmp12_ = history_entry_new (_tmp4_, _tmp6_, _tmp8_, _tmp10_, _tmp11_);
	entry = _tmp12_;
	_tmp13_ = self->priv->history;
	_tmp14_ = entry;
	history_add (_tmp13_, _tmp14_);
	_tmp15_ = self->priv->history;
	history_save (_tmp15_);
	_tmp16_ = entry;
	_tmp17_ = mines_show_scores (self, _tmp16_, TRUE);
	if (_tmp17_ == ((gint) GTK_RESPONSE_OK)) {
		mines_show_new_game_screen (self);
	} else {
		GtkButton* _tmp18_ = NULL;
		GtkButton* _tmp19_ = NULL;
		GtkButton* _tmp20_ = NULL;
		GSimpleAction* _tmp21_ = NULL;
		GtkButton* _tmp22_ = NULL;
		_tmp18_ = self->priv->new_game_button;
		gtk_widget_show ((GtkWidget*) _tmp18_);
		_tmp19_ = self->priv->replay_button;
		gtk_widget_show ((GtkWidget*) _tmp19_);
		_tmp20_ = self->priv->high_scores_button;
		gtk_widget_show ((GtkWidget*) _tmp20_);
		_tmp21_ = self->priv->pause_action;
		g_simple_action_set_enabled (_tmp21_, FALSE);
		_tmp22_ = self->priv->play_pause_button;
		gtk_widget_hide ((GtkWidget*) _tmp22_);
	}
	_g_object_unref0 (entry);
	_g_date_time_unref0 (date);
}


static void mines_clock_started_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_display_pause_button (self);
}


static void mines_tick_cb (Mines* self) {
	gint elapsed = 0;
	Minefield* _tmp0_ = NULL;
	gint hours = 0;
	gint _tmp4_ = 0;
	gint minutes = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint seconds = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	g_return_if_fail (self != NULL);
	elapsed = 0;
	_tmp0_ = self->priv->minefield;
	if (_tmp0_ != NULL) {
		Minefield* _tmp1_ = NULL;
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		_tmp1_ = self->priv->minefield;
		_tmp2_ = minefield_get_elapsed (_tmp1_);
		_tmp3_ = _tmp2_;
		elapsed = (gint) (_tmp3_ + 0.5);
	}
	_tmp4_ = elapsed;
	hours = _tmp4_ / 3600;
	_tmp5_ = elapsed;
	_tmp6_ = hours;
	minutes = (_tmp5_ - (_tmp6_ * 3600)) / 60;
	_tmp7_ = elapsed;
	_tmp8_ = hours;
	_tmp9_ = minutes;
	seconds = (_tmp7_ - (_tmp8_ * 3600)) - (_tmp9_ * 60);
	_tmp10_ = hours;
	if (_tmp10_ > 0) {
		GtkLabel* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		_tmp11_ = self->priv->clock_label;
		_tmp12_ = hours;
		_tmp13_ = minutes;
		_tmp14_ = seconds;
		_tmp15_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d∶\xE2\x80\x8E%02d", _tmp12_, _tmp13_, _tmp14_);
		_tmp16_ = _tmp15_;
		gtk_label_set_text (_tmp11_, _tmp16_);
		_g_free0 (_tmp16_);
	} else {
		GtkLabel* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		_tmp17_ = self->priv->clock_label;
		_tmp18_ = minutes;
		_tmp19_ = seconds;
		_tmp20_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d", _tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		gtk_label_set_text (_tmp17_, _tmp21_);
		_g_free0 (_tmp21_);
	}
}


static void mines_about_cb (Mines* self) {
	gchar** authors = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** artists = NULL;
	gchar* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gint artists_length1 = 0;
	gint _artists_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	GtkWindow* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Main game:");
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_strdup ("Szekeres Istvan (Pista)");
	_tmp3_ = g_strdup ("Robert Ancell");
	_tmp4_ = g_strdup ("Robert Roth");
	_tmp5_ = g_strdup ("");
	_tmp6_ = _ ("Score:");
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = g_strdup ("Horacio J. Peña");
	_tmp9_ = g_strdup ("");
	_tmp10_ = _ ("Resizing and SVG support:");
	_tmp11_ = g_strdup (_tmp10_);
	_tmp12_ = g_strdup ("Steve Chaplin");
	_tmp13_ = g_strdup ("Callum McKenzie");
	_tmp14_ = g_new0 (gchar*, 12 + 1);
	_tmp14_[0] = _tmp1_;
	_tmp14_[1] = _tmp2_;
	_tmp14_[2] = _tmp3_;
	_tmp14_[3] = _tmp4_;
	_tmp14_[4] = _tmp5_;
	_tmp14_[5] = _tmp7_;
	_tmp14_[6] = _tmp8_;
	_tmp14_[7] = _tmp9_;
	_tmp14_[8] = _tmp11_;
	_tmp14_[9] = _tmp12_;
	_tmp14_[10] = _tmp13_;
	_tmp14_[11] = NULL;
	authors = _tmp14_;
	authors_length1 = 12;
	_authors_size_ = authors_length1;
	_tmp15_ = g_strdup ("Richard Hoelscher");
	_tmp16_ = g_new0 (gchar*, 2 + 1);
	_tmp16_[0] = _tmp15_;
	_tmp16_[1] = NULL;
	artists = _tmp16_;
	artists_length1 = 2;
	_artists_size_ = artists_length1;
	_tmp17_ = g_strdup ("Ekaterina Gerasimova");
	_tmp18_ = g_new0 (gchar*, 2 + 1);
	_tmp18_[0] = _tmp17_;
	_tmp18_[1] = NULL;
	documenters = _tmp18_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp19_ = self->priv->window;
	_tmp20_ = _ ("Mines");
	_tmp21_ = _ ("Clear explosive mines off the board\n" \
"\n" \
"Mines is a part of GNOME Games.");
	_tmp22_ = _ ("translator-credits");
	gtk_show_about_dialog (_tmp19_, "name", _tmp20_, "version", VERSION, "comments", _tmp21_, "copyright", "Copyright © 1997–2008 Free Software Foundation, Inc.", "license-type", GTK_LICENSE_GPL_2_0, "authors", authors, "artists", artists, "documenters", documenters, "translator-credits", _tmp22_, "logo-icon-name", "gnome-mines", "website", "https://wiki.gnome.org/Apps/Mines", NULL, NULL);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static gfloat mines_percent_mines (Mines* self) {
	gfloat result = 0.0F;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_int (_tmp0_, MINES_KEY_NMINES);
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_int (_tmp2_, MINES_KEY_XSIZE);
	_tmp4_ = self->priv->settings;
	_tmp5_ = g_settings_get_int (_tmp4_, MINES_KEY_YSIZE);
	result = (100.0f * ((gfloat) _tmp1_)) / (_tmp3_ * _tmp5_);
	return result;
}


static void mines_set_mines_limit (Mines* self) {
	gint size = 0;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint max_mines = 0;
	gdouble _tmp4_ = 0.0;
	gint min_mines = 0;
	gdouble _tmp5_ = 0.0;
	gint _tmp6_ = 0;
	GtkSpinButton* _tmp7_ = NULL;
	GtkSpinButton* _tmp8_ = NULL;
	gfloat _tmp9_ = 0.0F;
	gdouble _tmp10_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_int (_tmp0_, MINES_KEY_XSIZE);
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_int (_tmp2_, MINES_KEY_YSIZE);
	size = _tmp1_ * _tmp3_;
	_tmp4_ = round ((gdouble) ((100.0f * ((gfloat) (size - 10))) / size));
	max_mines = (gint) _tmp4_;
	_tmp5_ = round ((gdouble) (100.0f / size));
	_tmp6_ = MAX (1, (gint) _tmp5_);
	min_mines = _tmp6_;
	_tmp7_ = self->priv->mines_spin;
	gtk_spin_button_set_range (_tmp7_, (gdouble) min_mines, (gdouble) max_mines);
	_tmp8_ = self->priv->mines_spin;
	_tmp9_ = mines_percent_mines (self);
	_tmp10_ = round ((gdouble) _tmp9_);
	gtk_spin_button_set_value (_tmp8_, (gdouble) ((gint) _tmp10_));
}


static void mines_xsize_spin_cb (Mines* self, GtkSpinButton* spin) {
	gint xsize = 0;
	GtkSpinButton* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	_tmp0_ = spin;
	_tmp1_ = gtk_spin_button_get_value_as_int (_tmp0_);
	xsize = _tmp1_;
	_tmp2_ = xsize;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, MINES_KEY_XSIZE);
	if (_tmp2_ == _tmp4_) {
		return;
	}
	_tmp5_ = self->priv->settings;
	_tmp6_ = xsize;
	g_settings_set_int (_tmp5_, MINES_KEY_XSIZE, _tmp6_);
	mines_set_mines_limit (self);
}


static void mines_ysize_spin_cb (Mines* self, GtkSpinButton* spin) {
	gint ysize = 0;
	GtkSpinButton* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GSettings* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	_tmp0_ = spin;
	_tmp1_ = gtk_spin_button_get_value_as_int (_tmp0_);
	ysize = _tmp1_;
	_tmp2_ = ysize;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, MINES_KEY_YSIZE);
	if (_tmp2_ == _tmp4_) {
		return;
	}
	_tmp5_ = self->priv->settings;
	_tmp6_ = ysize;
	g_settings_set_int (_tmp5_, MINES_KEY_YSIZE, _tmp6_);
	mines_set_mines_limit (self);
}


static void mines_mines_spin_cb (Mines* self, GtkSpinButton* spin) {
	gfloat _tmp0_ = 0.0F;
	GtkSpinButton* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GSettings* _tmp4_ = NULL;
	GtkSpinButton* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	GSettings* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	GSettings* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gdouble _tmp11_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	_tmp0_ = mines_percent_mines (self);
	_tmp1_ = spin;
	_tmp2_ = gtk_spin_button_get_value (_tmp1_);
	_tmp3_ = fabs (_tmp0_ - _tmp2_);
	if (_tmp3_ <= ((gdouble) 0.5f)) {
		return;
	}
	_tmp4_ = self->priv->settings;
	_tmp5_ = spin;
	_tmp6_ = gtk_spin_button_get_value (_tmp5_);
	_tmp7_ = self->priv->settings;
	_tmp8_ = g_settings_get_int (_tmp7_, MINES_KEY_XSIZE);
	_tmp9_ = self->priv->settings;
	_tmp10_ = g_settings_get_int (_tmp9_, MINES_KEY_YSIZE);
	_tmp11_ = round ((_tmp6_ * (_tmp8_ * _tmp10_)) / 100.0f);
	g_settings_set_int (_tmp4_, MINES_KEY_NMINES, (gint) _tmp11_);
}


static void mines_set_mode (Mines* self, gint mode) {
	gint _tmp0_ = 0;
	GSettings* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = mode;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_int (_tmp1_, MINES_KEY_MODE);
	if (_tmp0_ != _tmp2_) {
		GSettings* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp3_ = self->priv->settings;
		_tmp4_ = mode;
		g_settings_set_int (_tmp3_, MINES_KEY_MODE, _tmp4_);
	}
	mines_start_game (self);
}


static void mines_small_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 0);
}


static void mines_medium_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 1);
}


static void mines_large_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 2);
}


static void mines_custom_size_clicked_cb (Mines* self) {
	g_return_if_fail (self != NULL);
	mines_set_mode (self, 3);
}


static void mines_help_cb (Mines* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-mines", _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("gnome-mines.vala:757: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void mines_display_pause_button (Mines* self) {
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->replay_button;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->new_game_button;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->play_pause_button;
	gtk_widget_show ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->play_pause_label;
	_tmp4_ = _ ("_Pause");
	gtk_label_set_label (_tmp3_, _tmp4_);
}


static void mines_display_unpause_button (Mines* self) {
	GtkButton* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->replay_button;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->new_game_button;
	gtk_widget_show ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->play_pause_button;
	gtk_widget_show ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->play_pause_label;
	_tmp4_ = _ ("_Resume");
	gtk_label_set_label (_tmp3_, _tmp4_);
}


gint mines_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionGroup* _tmp3_ = NULL;
	Mines* app = NULL;
	Mines* _tmp8_ = NULL;
	Mines* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new (NULL);
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_set_translation_domain (_tmp1_, GETTEXT_PACKAGE);
	_tmp2_ = context;
	_tmp3_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp2_, _tmp3_);
	{
		GOptionContext* _tmp4_ = NULL;
		_tmp4_ = context;
		g_option_context_parse (_tmp4_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp8_ = mines_new ();
	app = _tmp8_;
	_tmp9_ = app;
	_tmp10_ = g_application_run ((GApplication*) _tmp9_, 0, NULL);
	result = _tmp10_;
	_g_object_unref0 (app);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return mines_main (argv, argc);
}


static void mines_class_init (MinesClass * klass) {
	mines_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MinesPrivate));
	((GApplicationClass *) klass)->startup = mines_real_startup;
	((GApplicationClass *) klass)->shutdown = mines_real_shutdown;
	((GApplicationClass *) klass)->activate = mines_real_activate;
	G_OBJECT_CLASS (klass)->finalize = mines_finalize;
}


static void mines_instance_init (Mines * self) {
	self->priv = MINES_GET_PRIVATE (self);
}


static void mines_finalize (GObject* obj) {
	Mines * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINES, Mines);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->main_screen);
	_g_object_unref0 (self->priv->play_pause_button);
	_g_object_unref0 (self->priv->play_pause_label);
	_g_object_unref0 (self->priv->replay_button);
	_g_object_unref0 (self->priv->high_scores_button);
	_g_object_unref0 (self->priv->new_game_button);
	_g_object_unref0 (self->priv->minefield_aspect);
	_g_object_unref0 (self->priv->minefield_overlay);
	_g_object_unref0 (self->priv->paused_box);
	_g_object_unref0 (self->priv->scrolled);
	_g_object_unref0 (self->priv->clock_label);
	_g_object_unref0 (self->priv->app_main_menu);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->minefield);
	_g_object_unref0 (self->priv->minefield_view);
	_g_object_unref0 (self->priv->flag_label);
	_g_object_unref0 (self->priv->mines_spin);
	_g_object_unref0 (self->priv->new_game_action);
	_g_object_unref0 (self->priv->repeat_size_action);
	_g_object_unref0 (self->priv->pause_action);
	_g_object_unref0 (self->priv->new_game_screen);
	_g_object_unref0 (self->priv->custom_game_screen);
	G_OBJECT_CLASS (mines_parent_class)->finalize (obj);
}


GType mines_get_type (void) {
	static volatile gsize mines_type_id__volatile = 0;
	if (g_once_init_enter (&mines_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MinesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mines_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Mines), 0, (GInstanceInitFunc) mines_instance_init, NULL };
		GType mines_type_id;
		mines_type_id = g_type_register_static (gtk_application_get_type (), "Mines", &g_define_type_info, 0);
		g_once_init_leave (&mines_type_id__volatile, mines_type_id);
	}
	return mines_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



