/* projects.c generated by valac 0.56.7, the Vala compiler
 * generated from projects.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <latexila.h>
#include <gtk/gtk.h>
#include <tepl/tepl.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
typedef struct _ProjectsPrivate ProjectsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef void (*GMarkupParserStartElementFunc) (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer user_data, GError** error);
#define _g_markup_parse_context_unref0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _ParamSpecProjects ParamSpecProjects;

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Projects {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ProjectsPrivate * priv;
};

struct _ProjectsClass {
	GTypeClass parent_class;
	void (*finalize) (Projects *self);
};

struct _ProjectsPrivate {
	GeeLinkedList* projects;
	gboolean modified;
};

struct _ParamSpecProjects {
	GParamSpec parent_instance;
};

static gint Projects_private_offset;
static gpointer projects_parent_class = NULL;
static Projects* projects_instance;
static Projects* projects_instance = NULL;

VALA_EXTERN GType project_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Project* project_dup (const Project* self);
VALA_EXTERN void project_free (Project* self);
VALA_EXTERN void project_copy (const Project* self,
                   Project* dest);
VALA_EXTERN void project_destroy (Project* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (Project, project_destroy)
VALA_EXTERN gpointer projects_ref (gpointer instance);
VALA_EXTERN void projects_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_projects (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
VALA_EXTERN void value_set_projects (GValue* value,
                         gpointer v_object);
VALA_EXTERN void value_take_projects (GValue* value,
                          gpointer v_object);
VALA_EXTERN gpointer value_get_projects (const GValue* value);
VALA_EXTERN GType projects_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Projects, projects_unref)
static Projects* projects_new (void);
static Projects* projects_construct (GType object_type);
static GFile* projects_get_xml_file (Projects* self);
VALA_EXTERN gchar* utils_load_file (GFile* file);
static void projects_parser_start (Projects* self,
                            GMarkupParseContext* context,
                            const gchar* name,
                            gchar** attr_names,
                            gint attr_names_length1,
                            gchar** attr_values,
                            gint attr_values_length1,
                            GError** error);
static void _projects_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                               const gchar* element_name,
                                                               gchar** attribute_names,
                                                               gchar** attribute_values,
                                                               gpointer self,
                                                               GError** error);
static void projects_update_all_documents (Projects* self);
static void projects_update_all_menus (Projects* self);
VALA_EXTERN Projects* projects_get_default (void);
VALA_EXTERN Project* projects_get (Projects* self,
                       gint id);
VALA_EXTERN GeeIterator* projects_iterator (Projects* self);
VALA_EXTERN GType glatex_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GlatexApp, g_object_unref)
VALA_EXTERN GlatexApp* glatex_app_get_instance (void);
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN void main_window_update_config_project_sensitivity (MainWindow* self);
VALA_EXTERN gboolean projects_add (Projects* self,
                       Project* new_project,
                       GFile** conflict_file);
static gboolean projects_conflict (Projects* self,
                            GFile* dir1,
                            GFile* dir2);
VALA_EXTERN GType document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
VALA_EXTERN GeeList* glatex_app_get_documents (GlatexApp* self);
VALA_EXTERN gint document_get_project_id (Document* self);
VALA_EXTERN GFile* document_get_location (Document* self);
VALA_EXTERN void document_set_project_id (Document* self,
                              gint value);
VALA_EXTERN gboolean projects_change_main_file (Projects* self,
                                    gint num,
                                    GFile* new_main_file);
VALA_EXTERN void projects_delete (Projects* self,
                      gint num);
VALA_EXTERN void projects_clear_all (Projects* self);
VALA_EXTERN void projects_save (Projects* self);
VALA_EXTERN void utils_delete_file (GFile* file);
VALA_EXTERN gboolean utils_save_file (GFile* file,
                          const gchar* contents,
                          gboolean make_backup);
static void projects_finalize (Projects * obj);
static GType projects_get_type_once (void);
static gssize _vala_array_length (gpointer array);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
project_copy (const Project* self,
              Project* dest)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	_tmp0_ = (*self).directory;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).directory);
	(*dest).directory = _tmp1_;
	_tmp2_ = (*self).main_file;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).main_file);
	(*dest).main_file = _tmp3_;
}

void
project_destroy (Project* self)
{
	_g_object_unref0 ((*self).directory);
	_g_object_unref0 ((*self).main_file);
}

Project*
project_dup (const Project* self)
{
	Project* dup;
	dup = g_new0 (Project, 1);
	project_copy (self, dup);
	return dup;
}

void
project_free (Project* self)
{
	project_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
project_get_type_once (void)
{
	GType project_type_id;
	project_type_id = g_boxed_type_register_static ("Project", (GBoxedCopyFunc) project_dup, (GBoxedFreeFunc) project_free);
	return project_type_id;
}

GType
project_get_type (void)
{
	static gsize project_type_id__once = 0;
	if (g_once_init_enter (&project_type_id__once)) {
		GType project_type_id;
		project_type_id = project_get_type_once ();
		g_once_init_leave (&project_type_id__once, project_type_id);
	}
	return project_type_id__once;
}

static inline gpointer
projects_get_instance_private (Projects* self)
{
	return G_STRUCT_MEMBER_P (self, Projects_private_offset);
}

static void
_projects_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                          const gchar* element_name,
                                                          gchar** attribute_names,
                                                          gchar** attribute_values,
                                                          gpointer self,
                                                          GError** error)
{
	projects_parser_start ((Projects*) self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}

static Projects*
projects_construct (GType object_type)
{
	Projects* self = NULL;
	GeeLinkedList* _tmp0_;
	GFile* file = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* contents = NULL;
	GFile* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	self = (Projects*) g_type_create_instance (object_type);
	_tmp0_ = gee_linked_list_new (TYPE_PROJECT, (GBoxedCopyFunc) project_dup, (GDestroyNotify) project_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->projects);
	self->priv->projects = _tmp0_;
	_tmp1_ = projects_get_xml_file (self);
	file = _tmp1_;
	_tmp2_ = file;
	if (!g_file_query_exists (_tmp2_, NULL)) {
		_g_object_unref0 (file);
		return self;
	}
	_tmp3_ = file;
	_tmp4_ = utils_load_file (_tmp3_);
	contents = _tmp4_;
	_tmp5_ = contents;
	if (_tmp5_ == NULL) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		return self;
	}
	{
		GMarkupParser parser = {0};
		GMarkupParser _tmp6_ = {0};
		GMarkupParseContext* context = NULL;
		GMarkupParser _tmp7_;
		GMarkupParseContext* _tmp8_;
		GMarkupParseContext* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_.start_element = _projects_parser_start_gmarkup_parser_start_element_func;
		_tmp6_.end_element = NULL;
		_tmp6_.text = NULL;
		_tmp6_.passthrough = NULL;
		_tmp6_.error = NULL;
		parser = _tmp6_;
		_tmp7_ = parser;
		_tmp8_ = g_markup_parse_context_new (&_tmp7_, 0, self, NULL);
		context = _tmp8_;
		_tmp9_ = context;
		_tmp10_ = contents;
		g_markup_parse_context_parse (_tmp9_, _tmp10_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_markup_parse_context_unref0 (context);
			goto __catch0_g_error;
		}
		projects_update_all_documents (self);
		projects_update_all_menus (self);
		_g_markup_parse_context_unref0 (context);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("projects.vala:59: Impossible to load the projects: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_g_free0 (contents);
	_g_object_unref0 (file);
	return self;
}

static Projects*
projects_new (void)
{
	return projects_construct (TYPE_PROJECTS);
}

static gpointer
_projects_ref0 (gpointer self)
{
	return self ? projects_ref (self) : NULL;
}

Projects*
projects_get_default (void)
{
	Projects* _tmp0_;
	Projects* _tmp2_;
	Projects* _tmp3_;
	Projects* result;
	_tmp0_ = projects_instance;
	if (_tmp0_ == NULL) {
		Projects* _tmp1_;
		_tmp1_ = projects_new ();
		_projects_unref0 (projects_instance);
		projects_instance = _tmp1_;
	}
	_tmp2_ = projects_instance;
	_tmp3_ = _projects_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

Project*
projects_get (Projects* self,
              gint id)
{
	gboolean _tmp0_ = FALSE;
	GeeLinkedList* _tmp4_;
	gpointer _tmp5_;
	Project* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (id >= 0) {
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->projects;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = id < _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, NULL);
	_tmp4_ = self->priv->projects;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, id);
	result = (Project*) _tmp5_;
	return result;
}

GeeIterator*
projects_iterator (Projects* self)
{
	GeeLinkedList* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->projects;
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERATOR, GeeIterator);
	return result;
}

static void
projects_update_all_menus (Projects* self)
{
	GlatexApp* _tmp0_;
	GlatexApp* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = glatex_app_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_application_get_windows ((GtkApplication*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp3_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp4_;
			GtkWindow* window = NULL;
			_tmp4_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp4_;
			{
				GtkWindow* _tmp5_;
				_tmp5_ = window;
				if (IS_MAIN_WINDOW (_tmp5_)) {
					MainWindow* main_window = NULL;
					GtkWindow* _tmp6_;
					MainWindow* _tmp7_;
					MainWindow* _tmp8_;
					_tmp6_ = window;
					_tmp7_ = _g_object_ref0 (IS_MAIN_WINDOW (_tmp6_) ? ((MainWindow*) _tmp6_) : NULL);
					main_window = _tmp7_;
					_tmp8_ = main_window;
					main_window_update_config_project_sensitivity (_tmp8_);
					_g_object_unref0 (main_window);
				}
				_g_object_unref0 (window);
			}
		}
	}
}

gboolean
projects_add (Projects* self,
              Project* new_project,
              GFile** conflict_file)
{
	GFile* _vala_conflict_file = NULL;
	GeeLinkedList* _tmp19_;
	Project _tmp20_;
	GeeList* docs = NULL;
	GlatexApp* _tmp21_;
	GlatexApp* _tmp22_;
	GeeList* _tmp23_;
	GeeList* _tmp24_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_project != NULL, FALSE);
	_g_object_unref0 (_vala_conflict_file);
	_vala_conflict_file = NULL;
	{
		GeeLinkedList* _project_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _project_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _project_index = 0;
		_tmp0_ = self->priv->projects;
		_project_list = _tmp0_;
		_tmp1_ = _project_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_project_size = _tmp3_;
		_project_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Project project = {0};
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			Project* _tmp8_;
			Project _tmp9_;
			Project _tmp10_ = {0};
			Project _tmp11_;
			Project _tmp12_;
			GFile* _tmp13_;
			Project _tmp14_;
			GFile* _tmp15_;
			_project_index = _project_index + 1;
			_tmp4_ = _project_index;
			_tmp5_ = _project_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _project_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _project_index);
			_tmp8_ = (Project*) _tmp7_;
			_tmp9_ = *_tmp8_;
			project_copy (&_tmp9_, &_tmp10_);
			_tmp11_ = _tmp10_;
			_project_free0 (_tmp8_);
			project = _tmp11_;
			_tmp12_ = project;
			_tmp13_ = _tmp12_.directory;
			_tmp14_ = *new_project;
			_tmp15_ = _tmp14_.directory;
			if (projects_conflict (self, _tmp13_, _tmp15_)) {
				Project _tmp16_;
				GFile* _tmp17_;
				GFile* _tmp18_;
				_tmp16_ = project;
				_tmp17_ = _tmp16_.directory;
				_tmp18_ = _g_object_ref0 (_tmp17_);
				_g_object_unref0 (_vala_conflict_file);
				_vala_conflict_file = _tmp18_;
				result = FALSE;
				project_destroy (&project);
				if (conflict_file) {
					*conflict_file = _vala_conflict_file;
				} else {
					_g_object_unref0 (_vala_conflict_file);
				}
				return result;
			}
			project_destroy (&project);
		}
	}
	_tmp19_ = self->priv->projects;
	_tmp20_ = *new_project;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, &_tmp20_);
	self->priv->modified = TRUE;
	_tmp21_ = glatex_app_get_instance ();
	_tmp22_ = _tmp21_;
	_tmp23_ = glatex_app_get_documents (_tmp22_);
	_tmp24_ = _tmp23_;
	_g_object_unref0 (_tmp22_);
	docs = _tmp24_;
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp25_;
		gint _doc_size = 0;
		GeeList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _doc_index = 0;
		_tmp25_ = docs;
		_doc_list = _tmp25_;
		_tmp26_ = _doc_list;
		_tmp27_ = gee_collection_get_size ((GeeCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_doc_size = _tmp28_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp29_;
			gint _tmp30_;
			Document* doc = NULL;
			GeeList* _tmp31_;
			gpointer _tmp32_;
			gboolean _tmp33_ = FALSE;
			Document* _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			Document* _tmp40_;
			GFile* _tmp41_;
			GFile* _tmp42_;
			Project _tmp43_;
			GFile* _tmp44_;
			_doc_index = _doc_index + 1;
			_tmp29_ = _doc_index;
			_tmp30_ = _doc_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _doc_list;
			_tmp32_ = gee_list_get (_tmp31_, _doc_index);
			doc = (Document*) _tmp32_;
			_tmp34_ = doc;
			_tmp35_ = document_get_project_id (_tmp34_);
			_tmp36_ = _tmp35_;
			if (_tmp36_ != -1) {
				_tmp33_ = TRUE;
			} else {
				Document* _tmp37_;
				GFile* _tmp38_;
				GFile* _tmp39_;
				_tmp37_ = doc;
				_tmp38_ = document_get_location (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp33_ = _tmp39_ == NULL;
			}
			if (_tmp33_) {
				_g_object_unref0 (doc);
				continue;
			}
			_tmp40_ = doc;
			_tmp41_ = document_get_location (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = *new_project;
			_tmp44_ = _tmp43_.directory;
			if (g_file_has_prefix (_tmp42_, _tmp44_)) {
				Document* _tmp45_;
				GeeLinkedList* _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				_tmp45_ = doc;
				_tmp46_ = self->priv->projects;
				_tmp47_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp46_);
				_tmp48_ = _tmp47_;
				document_set_project_id (_tmp45_, _tmp48_ - 1);
			}
			_g_object_unref0 (doc);
		}
	}
	projects_update_all_menus (self);
	result = TRUE;
	_g_object_unref0 (docs);
	if (conflict_file) {
		*conflict_file = _vala_conflict_file;
	} else {
		_g_object_unref0 (_vala_conflict_file);
	}
	return result;
}

gboolean
projects_change_main_file (Projects* self,
                           gint num,
                           GFile* new_main_file)
{
	gboolean _tmp0_ = FALSE;
	Project project = {0};
	GeeLinkedList* _tmp4_;
	gpointer _tmp5_;
	Project* _tmp6_;
	Project _tmp7_;
	Project _tmp8_ = {0};
	Project _tmp9_;
	Project _tmp10_;
	GFile* _tmp11_;
	Project _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GeeLinkedList* _tmp15_;
	Project _tmp16_;
	GeeList* docs = NULL;
	GlatexApp* _tmp17_;
	GlatexApp* _tmp18_;
	GeeList* _tmp19_;
	GeeList* _tmp20_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_main_file != NULL, FALSE);
	if (num >= 0) {
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->projects;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = num < _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, FALSE);
	_tmp4_ = self->priv->projects;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, num);
	_tmp6_ = (Project*) _tmp5_;
	_tmp7_ = *_tmp6_;
	project_copy (&_tmp7_, &_tmp8_);
	_tmp9_ = _tmp8_;
	_project_free0 (_tmp6_);
	project = _tmp9_;
	_tmp10_ = project;
	_tmp11_ = _tmp10_.main_file;
	if (g_file_equal (new_main_file, _tmp11_)) {
		result = FALSE;
		project_destroy (&project);
		return result;
	}
	_tmp12_ = project;
	_tmp13_ = _tmp12_.directory;
	g_return_val_if_fail (g_file_has_prefix (new_main_file, _tmp13_), FALSE);
	_tmp14_ = _g_object_ref0 (new_main_file);
	_g_object_unref0 (project.main_file);
	project.main_file = _tmp14_;
	_tmp15_ = self->priv->projects;
	_tmp16_ = project;
	gee_abstract_list_set ((GeeAbstractList*) _tmp15_, num, &_tmp16_);
	self->priv->modified = TRUE;
	_tmp17_ = glatex_app_get_instance ();
	_tmp18_ = _tmp17_;
	_tmp19_ = glatex_app_get_documents (_tmp18_);
	_tmp20_ = _tmp19_;
	_g_object_unref0 (_tmp18_);
	docs = _tmp20_;
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp21_;
		gint _doc_size = 0;
		GeeList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _doc_index = 0;
		_tmp21_ = docs;
		_doc_list = _tmp21_;
		_tmp22_ = _doc_list;
		_tmp23_ = gee_collection_get_size ((GeeCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_doc_size = _tmp24_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			Document* doc = NULL;
			GeeList* _tmp27_;
			gpointer _tmp28_;
			Document* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			_doc_index = _doc_index + 1;
			_tmp25_ = _doc_index;
			_tmp26_ = _doc_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _doc_list;
			_tmp28_ = gee_list_get (_tmp27_, _doc_index);
			doc = (Document*) _tmp28_;
			_tmp29_ = doc;
			_tmp30_ = document_get_project_id (_tmp29_);
			_tmp31_ = _tmp30_;
			if (_tmp31_ == num) {
				Document* _tmp32_;
				_tmp32_ = doc;
				document_set_project_id (_tmp32_, num);
			}
			_g_object_unref0 (doc);
		}
	}
	result = TRUE;
	_g_object_unref0 (docs);
	project_destroy (&project);
	return result;
}

void
projects_delete (Projects* self,
                 gint num)
{
	gboolean _tmp0_ = FALSE;
	GeeLinkedList* _tmp4_;
	gpointer _tmp5_;
	Project* _tmp6_;
	GeeList* docs = NULL;
	GlatexApp* _tmp7_;
	GlatexApp* _tmp8_;
	GeeList* _tmp9_;
	GeeList* _tmp10_;
	g_return_if_fail (self != NULL);
	if (num >= 0) {
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->projects;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = num < _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_if_fail (_tmp0_);
	_tmp4_ = self->priv->projects;
	_tmp5_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp4_, num);
	_tmp6_ = (Project*) _tmp5_;
	_project_free0 (_tmp6_);
	self->priv->modified = TRUE;
	_tmp7_ = glatex_app_get_instance ();
	_tmp8_ = _tmp7_;
	_tmp9_ = glatex_app_get_documents (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	docs = _tmp10_;
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp11_;
		gint _doc_size = 0;
		GeeList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _doc_index = 0;
		_tmp11_ = docs;
		_doc_list = _tmp11_;
		_tmp12_ = _doc_list;
		_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_doc_size = _tmp14_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			Document* doc = NULL;
			GeeList* _tmp17_;
			gpointer _tmp18_;
			Document* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			_doc_index = _doc_index + 1;
			_tmp15_ = _doc_index;
			_tmp16_ = _doc_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _doc_list;
			_tmp18_ = gee_list_get (_tmp17_, _doc_index);
			doc = (Document*) _tmp18_;
			_tmp19_ = doc;
			_tmp20_ = document_get_project_id (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_ == num) {
				Document* _tmp22_;
				_tmp22_ = doc;
				document_set_project_id (_tmp22_, -1);
			} else {
				Document* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				_tmp23_ = doc;
				_tmp24_ = document_get_project_id (_tmp23_);
				_tmp25_ = _tmp24_;
				if (_tmp25_ > num) {
					Document* _tmp26_;
					gint _tmp27_;
					gint _tmp28_;
					_tmp26_ = doc;
					_tmp27_ = document_get_project_id (_tmp26_);
					_tmp28_ = _tmp27_;
					document_set_project_id (_tmp26_, _tmp28_ - 1);
				}
			}
			_g_object_unref0 (doc);
		}
	}
	projects_update_all_menus (self);
	_g_object_unref0 (docs);
}

void
projects_clear_all (Projects* self)
{
	GeeLinkedList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->projects;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	self->priv->modified = TRUE;
	projects_update_all_documents (self);
	projects_update_all_menus (self);
}

static void
projects_update_all_documents (Projects* self)
{
	GeeList* docs = NULL;
	GlatexApp* _tmp0_;
	GlatexApp* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = glatex_app_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = glatex_app_get_documents (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	docs = _tmp3_;
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp4_;
		gint _doc_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _doc_index = 0;
		_tmp4_ = docs;
		_doc_list = _tmp4_;
		_tmp5_ = _doc_list;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_doc_size = _tmp7_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			Document* doc = NULL;
			GeeList* _tmp10_;
			gpointer _tmp11_;
			Document* _tmp12_;
			Document* _tmp13_;
			GFile* _tmp14_;
			GFile* _tmp15_;
			_doc_index = _doc_index + 1;
			_tmp8_ = _doc_index;
			_tmp9_ = _doc_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _doc_list;
			_tmp11_ = gee_list_get (_tmp10_, _doc_index);
			doc = (Document*) _tmp11_;
			_tmp12_ = doc;
			document_set_project_id (_tmp12_, -1);
			_tmp13_ = doc;
			_tmp14_ = document_get_location (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ == NULL) {
				_g_object_unref0 (doc);
				continue;
			}
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp16_ = FALSE;
					_tmp16_ = TRUE;
					while (TRUE) {
						GeeLinkedList* _tmp18_;
						gint _tmp19_;
						gint _tmp20_;
						Document* _tmp21_;
						GFile* _tmp22_;
						GFile* _tmp23_;
						GeeLinkedList* _tmp24_;
						gpointer _tmp25_;
						Project* _tmp26_;
						GFile* _tmp27_;
						gboolean _tmp28_;
						if (!_tmp16_) {
							gint _tmp17_;
							_tmp17_ = i;
							i = _tmp17_ + 1;
						}
						_tmp16_ = FALSE;
						_tmp18_ = self->priv->projects;
						_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
						_tmp20_ = _tmp19_;
						if (!(i < _tmp20_)) {
							break;
						}
						_tmp21_ = doc;
						_tmp22_ = document_get_location (_tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = self->priv->projects;
						_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, i);
						_tmp26_ = (Project*) _tmp25_;
						_tmp27_ = (*_tmp26_).directory;
						_tmp28_ = g_file_has_prefix (_tmp23_, _tmp27_);
						_project_free0 (_tmp26_);
						if (_tmp28_) {
							Document* _tmp29_;
							_tmp29_ = doc;
							document_set_project_id (_tmp29_, i);
							break;
						}
					}
				}
			}
			_g_object_unref0 (doc);
		}
	}
	_g_object_unref0 (docs);
}

static void
projects_parser_start (Projects* self,
                       GMarkupParseContext* context,
                       const gchar* name,
                       gchar** attr_names,
                       gint attr_names_length1,
                       gchar** attr_values,
                       gint attr_values_length1,
                       GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("projects")))) {
		switch (0) {
			default:
			{
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("project")))) {
		switch (0) {
			default:
			{
				Project project = {0};
				GeeLinkedList* _tmp20_;
				Project _tmp21_;
				memset (&project, 0, sizeof (Project));
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							const gchar* _tmp5_;
							const gchar* _tmp6_;
							GQuark _tmp8_ = 0U;
							static GQuark _tmp7_label0 = 0;
							static GQuark _tmp7_label1 = 0;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = i;
								i = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							if (!(i < attr_names_length1)) {
								break;
							}
							_tmp5_ = attr_names[i];
							_tmp6_ = _tmp5_;
							_tmp8_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
							if (_tmp8_ == ((0 != _tmp7_label0) ? _tmp7_label0 : (_tmp7_label0 = g_quark_from_static_string ("directory")))) {
								switch (0) {
									default:
									{
										const gchar* _tmp9_;
										GFile* _tmp10_;
										_tmp9_ = attr_values[i];
										_tmp10_ = g_file_new_for_uri (_tmp9_);
										_g_object_unref0 (project.directory);
										project.directory = _tmp10_;
										break;
									}
								}
							} else if (_tmp8_ == ((0 != _tmp7_label1) ? _tmp7_label1 : (_tmp7_label1 = g_quark_from_static_string ("main_file")))) {
								switch (0) {
									default:
									{
										const gchar* _tmp11_;
										GFile* _tmp12_;
										_tmp11_ = attr_values[i];
										_tmp12_ = g_file_new_for_uri (_tmp11_);
										_g_object_unref0 (project.main_file);
										project.main_file = _tmp12_;
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										const gchar* _tmp13_;
										gchar* _tmp14_;
										gchar* _tmp15_;
										gchar* _tmp16_;
										gchar* _tmp17_;
										GError* _tmp18_;
										GError* _tmp19_;
										_tmp13_ = attr_names[i];
										_tmp14_ = g_strconcat ("unknown attribute \"", _tmp13_, NULL);
										_tmp15_ = _tmp14_;
										_tmp16_ = g_strconcat (_tmp15_, "\"", NULL);
										_tmp17_ = _tmp16_;
										_tmp18_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp17_);
										_tmp19_ = _tmp18_;
										_g_free0 (_tmp17_);
										_g_free0 (_tmp15_);
										_inner_error0_ = _tmp19_;
										if (_inner_error0_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error0_);
											project_destroy (&project);
											return;
										} else {
											project_destroy (&project);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
											g_clear_error (&_inner_error0_);
											return;
										}
									}
								}
							}
						}
					}
				}
				_tmp20_ = self->priv->projects;
				_tmp21_ = project;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, &_tmp21_);
				project_destroy (&project);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				GError* _tmp26_;
				GError* _tmp27_;
				_tmp22_ = g_strconcat ("unknown element \"", name, NULL);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strconcat (_tmp23_, "\"", NULL);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp25_);
				_tmp27_ = _tmp26_;
				_g_free0 (_tmp25_);
				_g_free0 (_tmp23_);
				_inner_error0_ = _tmp27_;
				if (_inner_error0_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	}
}

static GFile*
projects_get_xml_file (Projects* self)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-latex", "projects.xml", NULL, NULL);
	path = _tmp1_;
	_tmp2_ = g_file_new_for_path (path);
	result = _tmp2_;
	_g_free0 (path);
	return result;
}

void
projects_save (Projects* self)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* content = NULL;
	gchar* _tmp5_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	GFile* _tmp32_;
	const gchar* _tmp33_;
	g_return_if_fail (self != NULL);
	if (!self->priv->modified) {
		return;
	}
	_tmp0_ = projects_get_xml_file (self);
	file = _tmp0_;
	_tmp1_ = self->priv->projects;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		GFile* _tmp4_;
		_tmp4_ = file;
		utils_delete_file (_tmp4_);
		_g_object_unref0 (file);
		return;
	}
	_tmp5_ = g_strdup ("<projects>\n");
	content = _tmp5_;
	{
		GeeLinkedList* _project_list = NULL;
		GeeLinkedList* _tmp6_;
		gint _project_size = 0;
		GeeLinkedList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _project_index = 0;
		_tmp6_ = self->priv->projects;
		_project_list = _tmp6_;
		_tmp7_ = _project_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_project_size = _tmp9_;
		_project_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			Project project = {0};
			GeeLinkedList* _tmp12_;
			gpointer _tmp13_;
			Project* _tmp14_;
			Project _tmp15_;
			Project _tmp16_ = {0};
			Project _tmp17_;
			const gchar* _tmp18_;
			Project _tmp19_;
			GFile* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			Project _tmp23_;
			GFile* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			_project_index = _project_index + 1;
			_tmp10_ = _project_index;
			_tmp11_ = _project_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _project_list;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _project_index);
			_tmp14_ = (Project*) _tmp13_;
			_tmp15_ = *_tmp14_;
			project_copy (&_tmp15_, &_tmp16_);
			_tmp17_ = _tmp16_;
			_project_free0 (_tmp14_);
			project = _tmp17_;
			_tmp18_ = content;
			_tmp19_ = project;
			_tmp20_ = _tmp19_.directory;
			_tmp21_ = g_file_get_uri (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = project;
			_tmp24_ = _tmp23_.main_file;
			_tmp25_ = g_file_get_uri (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strdup_printf ("  <project directory=\"%s\" main_file=\"%s\" />\n", _tmp22_, _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strconcat (_tmp18_, _tmp28_, NULL);
			_g_free0 (content);
			content = _tmp29_;
			_g_free0 (_tmp28_);
			_g_free0 (_tmp26_);
			_g_free0 (_tmp22_);
			project_destroy (&project);
		}
	}
	_tmp30_ = content;
	_tmp31_ = g_strconcat (_tmp30_, "</projects>\n", NULL);
	_g_free0 (content);
	content = _tmp31_;
	_tmp32_ = file;
	_tmp33_ = content;
	utils_save_file (_tmp32_, _tmp33_, FALSE);
	_g_free0 (content);
	_g_object_unref0 (file);
}

static gboolean
projects_conflict (Projects* self,
                   GFile* dir1,
                   GFile* dir2)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dir1 != NULL, FALSE);
	g_return_val_if_fail (dir2 != NULL, FALSE);
	if (g_file_has_prefix (dir1, dir2)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_file_has_prefix (dir2, dir1);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_file_equal (dir1, dir2);
	}
	result = _tmp0_;
	return result;
}

static void
value_projects_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_projects_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		projects_unref (value->data[0].v_pointer);
	}
}

static void
value_projects_copy_value (const GValue* src_value,
                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = projects_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_projects_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_projects_collect_value (GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Projects * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = projects_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_projects_lcopy_value (const GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	Projects ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = projects_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_projects (const gchar* name,
                     const gchar* nick,
                     const gchar* blurb,
                     GType object_type,
                     GParamFlags flags)
{
	ParamSpecProjects* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PROJECTS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_projects (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECTS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_projects (GValue* value,
                    gpointer v_object)
{
	Projects * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PROJECTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		projects_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		projects_unref (old);
	}
}

void
value_take_projects (GValue* value,
                     gpointer v_object)
{
	Projects * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PROJECTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		projects_unref (old);
	}
}

static void
projects_class_init (ProjectsClass * klass,
                     gpointer klass_data)
{
	projects_parent_class = g_type_class_peek_parent (klass);
	((ProjectsClass *) klass)->finalize = projects_finalize;
	g_type_class_adjust_private_offset (klass, &Projects_private_offset);
}

static void
projects_instance_init (Projects * self,
                        gpointer klass)
{
	self->priv = projects_get_instance_private (self);
	self->priv->modified = FALSE;
	self->ref_count = 1;
}

static void
projects_finalize (Projects * obj)
{
	Projects * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROJECTS, Projects);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->projects);
}

 G_GNUC_NO_INLINE static GType
projects_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_projects_init, value_projects_free_value, value_projects_copy_value, value_projects_peek_pointer, "p", value_projects_collect_value, "p", value_projects_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ProjectsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) projects_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Projects), 0, (GInstanceInitFunc) projects_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType projects_type_id;
	projects_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Projects", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Projects_private_offset = g_type_add_instance_private (projects_type_id, sizeof (ProjectsPrivate));
	return projects_type_id;
}

GType
projects_get_type (void)
{
	static gsize projects_type_id__once = 0;
	if (g_once_init_enter (&projects_type_id__once)) {
		GType projects_type_id;
		projects_type_id = projects_get_type_once ();
		g_once_init_leave (&projects_type_id__once, projects_type_id);
	}
	return projects_type_id__once;
}

gpointer
projects_ref (gpointer instance)
{
	Projects * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
projects_unref (gpointer instance)
{
	Projects * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PROJECTS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

