/* main_window.c generated by valac 0.54.8, the Vala compiler
 * generated from main_window.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2020 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <tepl/tepl.h>
#include <glib/gi18n-lib.h>
#include <latexila.h>
#include <amtk/amtk.h>
#include <gdk/gdk.h>
#include "config.h"
#include <gio/gio.h>
#include <gee.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_DOCUMENTS_PANEL (documents_panel_get_type ())
#define DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanel))
#define DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))
#define IS_DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENTS_PANEL))
#define IS_DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENTS_PANEL))
#define DOCUMENTS_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))

typedef struct _DocumentsPanel DocumentsPanel;
typedef struct _DocumentsPanelClass DocumentsPanelClass;

#define TYPE_SEARCH_AND_REPLACE (search_and_replace_get_type ())
#define SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplace))
#define SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))
#define IS_SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_AND_REPLACE))
#define IS_SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_AND_REPLACE))
#define SEARCH_AND_REPLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))

typedef struct _SearchAndReplace SearchAndReplace;
typedef struct _SearchAndReplaceClass SearchAndReplaceClass;

#define TYPE_MAIN_WINDOW_FILE (main_window_file_get_type ())
#define MAIN_WINDOW_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_FILE, MainWindowFile))
#define MAIN_WINDOW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_FILE, MainWindowFileClass))
#define IS_MAIN_WINDOW_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_FILE))
#define IS_MAIN_WINDOW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_FILE))
#define MAIN_WINDOW_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_FILE, MainWindowFileClass))

typedef struct _MainWindowFile MainWindowFile;
typedef struct _MainWindowFileClass MainWindowFileClass;

#define TYPE_MAIN_WINDOW_EDIT (main_window_edit_get_type ())
#define MAIN_WINDOW_EDIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_EDIT, MainWindowEdit))
#define MAIN_WINDOW_EDIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_EDIT, MainWindowEditClass))
#define IS_MAIN_WINDOW_EDIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_EDIT))
#define IS_MAIN_WINDOW_EDIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_EDIT))
#define MAIN_WINDOW_EDIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_EDIT, MainWindowEditClass))

typedef struct _MainWindowEdit MainWindowEdit;
typedef struct _MainWindowEditClass MainWindowEditClass;

#define TYPE_MAIN_WINDOW_BUILD_TOOLS (main_window_build_tools_get_type ())
#define MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildTools))
#define MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))
#define IS_MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define IS_MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define MAIN_WINDOW_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))

typedef struct _MainWindowBuildTools MainWindowBuildTools;
typedef struct _MainWindowBuildToolsClass MainWindowBuildToolsClass;

#define TYPE_MAIN_WINDOW_STRUCTURE (main_window_structure_get_type ())
#define MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructure))
#define MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))
#define IS_MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_STRUCTURE))
#define IS_MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_STRUCTURE))
#define MAIN_WINDOW_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))

typedef struct _MainWindowStructure MainWindowStructure;
typedef struct _MainWindowStructureClass MainWindowStructureClass;

#define TYPE_MAIN_WINDOW_DOCUMENTS (main_window_documents_get_type ())
#define MAIN_WINDOW_DOCUMENTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocuments))
#define MAIN_WINDOW_DOCUMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocumentsClass))
#define IS_MAIN_WINDOW_DOCUMENTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_DOCUMENTS))
#define IS_MAIN_WINDOW_DOCUMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_DOCUMENTS))
#define MAIN_WINDOW_DOCUMENTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocumentsClass))

typedef struct _MainWindowDocuments MainWindowDocuments;
typedef struct _MainWindowDocumentsClass MainWindowDocumentsClass;

#define TYPE_MAIN_WINDOW_TOOLS (main_window_tools_get_type ())
#define MAIN_WINDOW_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_TOOLS, MainWindowTools))
#define MAIN_WINDOW_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_TOOLS, MainWindowToolsClass))
#define IS_MAIN_WINDOW_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_TOOLS))
#define IS_MAIN_WINDOW_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_TOOLS))
#define MAIN_WINDOW_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_TOOLS, MainWindowToolsClass))

typedef struct _MainWindowTools MainWindowTools;
typedef struct _MainWindowToolsClass MainWindowToolsClass;
enum  {
	MAIN_WINDOW_0_PROPERTY,
	MAIN_WINDOW_ACTIVE_TAB_PROPERTY,
	MAIN_WINDOW_ACTIVE_VIEW_PROPERTY,
	MAIN_WINDOW_ACTIVE_DOCUMENT_PROPERTY,
	MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* main_window_properties[MAIN_WINDOW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _main_window_file_unref0(var) ((var == NULL) ? NULL : (var = (main_window_file_unref (var), NULL)))
#define _main_window_edit_unref0(var) ((var == NULL) ? NULL : (var = (main_window_edit_unref (var), NULL)))
#define _main_window_build_tools_unref0(var) ((var == NULL) ? NULL : (var = (main_window_build_tools_unref (var), NULL)))
#define _main_window_structure_unref0(var) ((var == NULL) ? NULL : (var = (main_window_structure_unref (var), NULL)))
#define _main_window_documents_unref0(var) ((var == NULL) ? NULL : (var = (main_window_documents_unref (var), NULL)))
#define _main_window_tools_unref0(var) ((var == NULL) ? NULL : (var = (main_window_tools_unref (var), NULL)))

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;

#define TYPE_BOTTOM_PANEL (bottom_panel_get_type ())
#define BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOTTOM_PANEL, BottomPanel))
#define BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOTTOM_PANEL, BottomPanelClass))
#define IS_BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOTTOM_PANEL))
#define IS_BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOTTOM_PANEL))
#define BOTTOM_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOTTOM_PANEL, BottomPanelClass))

typedef struct _BottomPanel BottomPanel;
typedef struct _BottomPanelClass BottomPanelClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SYMBOLS_VIEW (symbols_view_get_type ())
#define SYMBOLS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYMBOLS_VIEW, SymbolsView))
#define SYMBOLS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYMBOLS_VIEW, SymbolsViewClass))
#define IS_SYMBOLS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYMBOLS_VIEW))
#define IS_SYMBOLS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYMBOLS_VIEW))
#define SYMBOLS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYMBOLS_VIEW, SymbolsViewClass))

typedef struct _SymbolsView SymbolsView;
typedef struct _SymbolsViewClass SymbolsViewClass;

#define TYPE_FILE_BROWSER (file_browser_get_type ())
#define FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_BROWSER, FileBrowser))
#define FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_BROWSER, FileBrowserClass))
#define IS_FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_BROWSER))
#define IS_FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_BROWSER))
#define FILE_BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_BROWSER, FileBrowserClass))

typedef struct _FileBrowser FileBrowser;
typedef struct _FileBrowserClass FileBrowserClass;

#define TYPE_STRUCTURE (structure_get_type ())
#define STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE, Structure))
#define STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE, StructureClass))
#define IS_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE))
#define IS_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE))
#define STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE, StructureClass))

typedef struct _Structure Structure;
typedef struct _StructureClass StructureClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _Block22Data Block22Data;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _Block23Data Block23Data;

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	gchar* default_location;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _MainWindowPrivate {
	DocumentsPanel* _documents_panel;
	TeplStatusbar* _statusbar;
	SearchAndReplace* _search_and_replace;
	TeplPanel* _side_panel;
	GtkPaned* _main_hpaned;
	GtkPaned* _vpaned;
	GtkUIManager* _ui_manager;
	GtkActionGroup* _action_group;
	MainWindowFile* _main_window_file;
	MainWindowEdit* _main_window_edit;
	MainWindowBuildTools* _main_window_build_tools;
	MainWindowStructure* _main_window_structure;
	MainWindowDocuments* _main_window_documents;
	MainWindowTools* _main_window_tools;
	guint _tip_message_cid;
};

struct _Block22Data {
	int _ref_count_;
	MainWindow* self;
	DocumentTab* tab;
	TeplInfoBar* infobar;
};

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

struct _Block23Data {
	int _ref_count_;
	MainWindow* self;
	DocumentTab* tab;
};

static gint MainWindow_private_offset;
static gpointer main_window_parent_class = NULL;

VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN GType documents_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentsPanel, g_object_unref)
VALA_EXTERN GType search_and_replace_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchAndReplace, g_object_unref)
VALA_EXTERN gpointer main_window_file_ref (gpointer instance);
VALA_EXTERN void main_window_file_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_main_window_file (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_main_window_file (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_main_window_file (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_main_window_file (const GValue* value);
VALA_EXTERN GType main_window_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowFile, main_window_file_unref)
VALA_EXTERN gpointer main_window_edit_ref (gpointer instance);
VALA_EXTERN void main_window_edit_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_main_window_edit (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_main_window_edit (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_main_window_edit (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_main_window_edit (const GValue* value);
VALA_EXTERN GType main_window_edit_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowEdit, main_window_edit_unref)
VALA_EXTERN gpointer main_window_build_tools_ref (gpointer instance);
VALA_EXTERN void main_window_build_tools_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_main_window_build_tools (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void value_set_main_window_build_tools (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void value_take_main_window_build_tools (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer value_get_main_window_build_tools (const GValue* value);
VALA_EXTERN GType main_window_build_tools_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowBuildTools, main_window_build_tools_unref)
VALA_EXTERN gpointer main_window_structure_ref (gpointer instance);
VALA_EXTERN void main_window_structure_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_main_window_structure (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void value_set_main_window_structure (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void value_take_main_window_structure (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer value_get_main_window_structure (const GValue* value);
VALA_EXTERN GType main_window_structure_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowStructure, main_window_structure_unref)
VALA_EXTERN gpointer main_window_documents_ref (gpointer instance);
VALA_EXTERN void main_window_documents_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_main_window_documents (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void value_set_main_window_documents (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void value_take_main_window_documents (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer value_get_main_window_documents (const GValue* value);
VALA_EXTERN GType main_window_documents_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowDocuments, main_window_documents_unref)
VALA_EXTERN gpointer main_window_tools_ref (gpointer instance);
VALA_EXTERN void main_window_tools_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_main_window_tools (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void value_set_main_window_tools (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void value_take_main_window_tools (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer value_get_main_window_tools (const GValue* value);
VALA_EXTERN GType main_window_tools_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowTools, main_window_tools_unref)
VALA_EXTERN void main_window_on_view_zoom_in (MainWindow* self);
static void _main_window_on_view_zoom_in_gcallback (GtkAction* action,
                                             gpointer self);
VALA_EXTERN void main_window_on_view_zoom_out (MainWindow* self);
static void _main_window_on_view_zoom_out_gcallback (GtkAction* action,
                                              gpointer self);
VALA_EXTERN void main_window_on_view_zoom_reset (MainWindow* self);
static void _main_window_on_view_zoom_reset_gcallback (GtkAction* action,
                                                gpointer self);
VALA_EXTERN void main_window_on_search_find (MainWindow* self);
static void _main_window_on_search_find_gcallback (GtkAction* action,
                                            gpointer self);
VALA_EXTERN void main_window_on_search_replace (MainWindow* self);
static void _main_window_on_search_replace_gcallback (GtkAction* action,
                                               gpointer self);
VALA_EXTERN void main_window_on_search_forward (MainWindow* self);
static void _main_window_on_search_forward_gcallback (GtkAction* action,
                                               gpointer self);
VALA_EXTERN void main_window_on_projects_new (MainWindow* self);
static void _main_window_on_projects_new_gcallback (GtkAction* action,
                                             gpointer self);
VALA_EXTERN void main_window_on_projects_config_current (MainWindow* self);
static void _main_window_on_projects_config_current_gcallback (GtkAction* action,
                                                        gpointer self);
VALA_EXTERN void main_window_on_projects_manage (MainWindow* self);
static void _main_window_on_projects_manage_gcallback (GtkAction* action,
                                                gpointer self);
VALA_EXTERN void main_window_on_help_latex_reference (MainWindow* self);
static void _main_window_on_help_latex_reference_gcallback (GtkAction* action,
                                                     gpointer self);
VALA_EXTERN GType glatex_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GlatexApp, g_object_unref)
VALA_EXTERN MainWindow* main_window_new (GlatexApp* app);
VALA_EXTERN MainWindow* main_window_construct (GType object_type,
                                   GlatexApp* app);
static void main_window_initialize_ui_manager (MainWindow* self);
VALA_EXTERN MainWindowFile* main_window_file_new (MainWindow* main_window,
                                      GtkUIManager* ui_manager);
VALA_EXTERN MainWindowFile* main_window_file_construct (GType object_type,
                                            MainWindow* main_window,
                                            GtkUIManager* ui_manager);
VALA_EXTERN MainWindowEdit* main_window_edit_new (MainWindow* main_window,
                                      GtkUIManager* ui_manager);
VALA_EXTERN MainWindowEdit* main_window_edit_construct (GType object_type,
                                            MainWindow* main_window,
                                            GtkUIManager* ui_manager);
VALA_EXTERN MainWindowBuildTools* main_window_build_tools_new (MainWindow* main_window,
                                                   GtkUIManager* ui_manager);
VALA_EXTERN MainWindowBuildTools* main_window_build_tools_construct (GType object_type,
                                                         MainWindow* main_window,
                                                         GtkUIManager* ui_manager);
VALA_EXTERN MainWindowDocuments* main_window_documents_new (MainWindow* main_window,
                                                GtkUIManager* ui_manager);
VALA_EXTERN MainWindowDocuments* main_window_documents_construct (GType object_type,
                                                      MainWindow* main_window,
                                                      GtkUIManager* ui_manager);
VALA_EXTERN MainWindowStructure* main_window_structure_new (GtkUIManager* ui_manager);
VALA_EXTERN MainWindowStructure* main_window_structure_construct (GType object_type,
                                                      GtkUIManager* ui_manager);
VALA_EXTERN MainWindowTools* main_window_tools_new (MainWindow* main_window,
                                        GtkUIManager* ui_manager);
VALA_EXTERN MainWindowTools* main_window_tools_construct (GType object_type,
                                              MainWindow* main_window,
                                              GtkUIManager* ui_manager);
static void main_window_show_images_in_menu (MainWindow* self);
static void main_window_update_file_actions_sensitivity (MainWindow* self);
static GtkToolbar* main_window_get_main_toolbar (MainWindow* self);
static GtkToolbar* main_window_get_edit_toolbar (MainWindow* self);
static TeplPanel* main_window_get_side_panel (MainWindow* self);
static void main_window_init_documents_panel (MainWindow* self);
VALA_EXTERN SearchAndReplace* search_and_replace_new (MainWindow* main_window);
VALA_EXTERN SearchAndReplace* search_and_replace_construct (GType object_type,
                                                MainWindow* main_window);
VALA_EXTERN GtkWidget* search_and_replace_get_widget (SearchAndReplace* self);
VALA_EXTERN GType bottom_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BottomPanel, g_object_unref)
static BottomPanel* main_window_get_bottom_panel (MainWindow* self);
VALA_EXTERN void main_window_build_tools_set_bottom_panel (MainWindowBuildTools* self,
                                               BottomPanel* bottom_panel);
static void __lambda101_ (MainWindow* self);
VALA_EXTERN void main_window_update_config_project_sensitivity (MainWindow* self);
VALA_EXTERN GType document_tab_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
VALA_EXTERN DocumentTab* main_window_get_active_tab (MainWindow* self);
VALA_EXTERN void search_and_replace_hide (SearchAndReplace* self);
static void ___lambda101__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void __lambda102_ (MainWindow* self);
static void ___lambda102__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void __lambda103_ (MainWindow* self);
static void ___lambda103__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void main_window_support_drag_and_drop (MainWindow* self);
static gboolean __lambda105_ (MainWindow* self);
VALA_EXTERN gboolean main_window_quit (MainWindow* self);
static gboolean ___lambda105__gtk_widget_delete_event (GtkWidget* _sender,
                                                GdkEventAny* event,
                                                gpointer self);
static void main_window_restore_state (MainWindow* self);
static void main_window_show_or_hide_widgets (MainWindow* self);
VALA_EXTERN GlatexApp* glatex_app_get_instance (void);
static void __lambda85_ (MainWindow* self,
                  GtkAction* action,
                  GtkWidget* p);
static void main_window_on_menu_item_select (MainWindow* self,
                                      GtkMenuItem* proxy);
static void _main_window_on_menu_item_select_gtk_menu_item_select (GtkMenuItem* _sender,
                                                            gpointer self);
static void main_window_on_menu_item_deselect (MainWindow* self,
                                        GtkMenuItem* proxy);
static void _main_window_on_menu_item_deselect_gtk_menu_item_deselect (GtkMenuItem* _sender,
                                                                gpointer self);
static void ___lambda85__gtk_ui_manager_connect_proxy (GtkUIManager* _sender,
                                                GtkAction* action,
                                                GtkWidget* proxy,
                                                gpointer self);
static void __lambda86_ (MainWindow* self,
                  GtkAction* action,
                  GtkWidget* p);
static void ___lambda86__gtk_ui_manager_disconnect_proxy (GtkUIManager* _sender,
                                                   GtkAction* action,
                                                   GtkWidget* proxy,
                                                   gpointer self);
VALA_EXTERN GtkToolItem* main_window_file_get_toolbar_open_button (MainWindowFile* self);
VALA_EXTERN GType symbols_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SymbolsView, g_object_unref)
VALA_EXTERN SymbolsView* symbols_view_new (MainWindow* main_window);
VALA_EXTERN SymbolsView* symbols_view_construct (GType object_type,
                                     MainWindow* main_window);
VALA_EXTERN GType file_browser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileBrowser, g_object_unref)
VALA_EXTERN FileBrowser* file_browser_new (MainWindow* main_window);
VALA_EXTERN FileBrowser* file_browser_construct (GType object_type,
                                     MainWindow* main_window);
VALA_EXTERN GType structure_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Structure, g_object_unref)
VALA_EXTERN Structure* structure_new (MainWindow* main_window);
VALA_EXTERN Structure* structure_construct (GType object_type,
                                MainWindow* main_window);
VALA_EXTERN void main_window_structure_set_structure (MainWindowStructure* self,
                                          Structure* structure);
VALA_EXTERN DocumentsPanel* documents_panel_new (MainWindow* main_window);
VALA_EXTERN DocumentsPanel* documents_panel_construct (GType object_type,
                                           MainWindow* main_window);
VALA_EXTERN void main_window_documents_set_documents_panel (MainWindowDocuments* self,
                                                DocumentsPanel* documents_panel);
static void __lambda100_ (MainWindow* self,
                   GdkEventButton* event);
static void ___lambda100__documents_panel_right_click (DocumentsPanel* _sender,
                                                GdkEventButton* event,
                                                gpointer self);
VALA_EXTERN void main_window_build_tools_set_build_view (MainWindowBuildTools* self,
                                             LatexilaBuildView* build_view);
VALA_EXTERN BottomPanel* bottom_panel_new (LatexilaBuildView* build_view,
                               GtkToolbar* toolbar);
VALA_EXTERN BottomPanel* bottom_panel_construct (GType object_type,
                                     LatexilaBuildView* build_view,
                                     GtkToolbar* toolbar);
static void __lambda104_ (MainWindow* self,
                   GdkDragContext* dc,
                   gint x,
                   gint y,
                   GtkSelectionData* selection_data,
                   guint info,
                   guint time);
static void _vala_array_add5 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
VALA_EXTERN void glatex_app_open_documents (GlatexApp* self,
                                GFile** files,
                                gint files_length1);
static void ___lambda104__gtk_widget_drag_data_received (GtkWidget* _sender,
                                                  GdkDragContext* context,
                                                  gint x,
                                                  gint y,
                                                  GtkSelectionData* selection_data,
                                                  guint info,
                                                  guint time_,
                                                  gpointer self);
VALA_EXTERN MainWindowStructure* main_window_get_main_window_structure (MainWindow* self);
VALA_EXTERN GType document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
VALA_EXTERN GeeList* main_window_get_documents (MainWindow* self);
VALA_EXTERN Document* document_tab_get_document (DocumentTab* self);
VALA_EXTERN GeeList* main_window_get_unsaved_documents (MainWindow* self);
VALA_EXTERN DocumentTab* main_window_open_document (MainWindow* self,
                                        GFile* location,
                                        gboolean jump_to);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
VALA_EXTERN GFile* document_get_location (Document* self);
VALA_EXTERN void main_window_set_active_tab (MainWindow* self,
                                 DocumentTab* value);
static DocumentTab* main_window_create_tab_from_location (MainWindow* self,
                                                   GFile* location,
                                                   gboolean jump_to);
VALA_EXTERN void document_set_readonly (Document* self,
                            gboolean value);
static void ______lambda63_ (Block22Data* _data22_,
                      gint response_id);
VALA_EXTERN TeplView* tepl_tab_get_view (TeplTab* self);
static void _______lambda63__gtk_info_bar_response (GtkInfoBar* _sender,
                                             gint response_id,
                                             gpointer self);
VALA_EXTERN DocumentTab* main_window_create_tab (MainWindow* self,
                                     gboolean jump_to);
VALA_EXTERN DocumentTab* document_tab_new (void);
VALA_EXTERN DocumentTab* document_tab_construct (GType object_type);
static DocumentTab* main_window_process_create_tab (MainWindow* self,
                                             DocumentTab* tab,
                                             gboolean jump_to);
VALA_EXTERN DocumentTab* document_tab_new_from_location (GFile* location);
VALA_EXTERN DocumentTab* document_tab_construct_from_location (GType object_type,
                                                   GFile* location);
VALA_EXTERN GType document_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
VALA_EXTERN void main_window_create_tab_with_view (MainWindow* self,
                                       DocumentView* view);
VALA_EXTERN DocumentTab* document_tab_new_with_view (DocumentView* document_view);
VALA_EXTERN DocumentTab* document_tab_construct_with_view (GType object_type,
                                               DocumentView* document_view);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static void __lambda37_ (Block23Data* _data23_);
VALA_EXTERN gboolean main_window_close_tab (MainWindow* self,
                                DocumentTab* tab,
                                gboolean force_close);
static void ___lambda37__tepl_tab_close_request (TeplTab* _sender,
                                          gpointer self);
static void __lambda40_ (Block23Data* _data23_);
static void main_window_sync_name (MainWindow* self,
                            DocumentTab* tab);
VALA_EXTERN void main_window_build_tools_update_sensitivity (MainWindowBuildTools* self);
static void ___lambda40__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda55_ (Block23Data* _data23_);
static void ___lambda55__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda56_ (MainWindow* self);
static void ___lambda56__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda57_ (Block23Data* _data23_);
static void ___lambda57__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender,
                                                    gpointer self);
static void __lambda58_ (Block23Data* _data23_);
static void ___lambda58__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN void documents_panel_add_tab (DocumentsPanel* self,
                              DocumentTab* tab,
                              gint position,
                              gboolean jump_to);
VALA_EXTERN void main_window_edit_update_sensitivity (MainWindowEdit* self);
VALA_EXTERN void main_window_tools_update_sensitivity (MainWindowTools* self);
VALA_EXTERN gboolean main_window_save_document (MainWindow* self,
                                    Document* doc,
                                    gboolean force_save_as);
VALA_EXTERN void documents_panel_remove_tab (DocumentsPanel* self,
                                 DocumentTab* tab);
VALA_EXTERN void main_window_documents_update_document_name (MainWindowDocuments* self,
                                                 DocumentTab* tab);
VALA_EXTERN void document_save (Document* self,
                    gboolean check_file_changed_on_disk,
                    gboolean force);
VALA_EXTERN Document* main_window_get_active_document (MainWindow* self);
VALA_EXTERN void main_window_structure_refresh (MainWindowStructure* self);
VALA_EXTERN void document_set_location (Document* self,
                            GFile* value);
VALA_EXTERN gboolean main_window_close_all_documents (MainWindow* self);
VALA_EXTERN void documents_panel_remove_all_tabs (DocumentsPanel* self);
VALA_EXTERN void dialogs_close_several_unsaved_documents (MainWindow* window,
                                              GeeList* unsaved_docs);
VALA_EXTERN void main_window_remove_all_tabs (MainWindow* self);
VALA_EXTERN void main_window_save_state (MainWindow* self);
VALA_EXTERN void main_window_structure_save_state (MainWindowStructure* self);
VALA_EXTERN void main_window_build_tools_save_state (MainWindowBuildTools* self);
VALA_EXTERN void main_window_jump_to_file_position (MainWindow* self,
                                        GFile* file,
                                        gint start_line,
                                        gint end_line);
VALA_EXTERN void utils_flush_queue (void);
VALA_EXTERN TeplTab* tepl_tab_group_get_active_tab (TeplTabGroup* self);
VALA_EXTERN void main_window_file_update_sensitivity (MainWindowFile* self);
VALA_EXTERN gint document_get_project_id (Document* self);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN DocumentView* main_window_get_active_view (MainWindow* self);
VALA_EXTERN void document_view_enlarge_font (DocumentView* self);
VALA_EXTERN void document_view_shrink_font (DocumentView* self);
VALA_EXTERN void document_view_set_font_from_settings (DocumentView* self);
VALA_EXTERN void search_and_replace_show_search (SearchAndReplace* self);
VALA_EXTERN void search_and_replace_show_search_and_replace (SearchAndReplace* self);
VALA_EXTERN GFile* document_get_main_file (Document* self);
VALA_EXTERN void project_dialogs_new_project (MainWindow* main_window);
VALA_EXTERN gboolean project_dialogs_configure_project (GtkWindow* main_window,
                                            gint project_id);
VALA_EXTERN void project_dialogs_manage_projects (MainWindow* main_window);
static void main_window_finalize (GObject * obj);
static GType main_window_get_type_once (void);
static void _vala_main_window_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_main_window_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GtkActionEntry MAIN_WINDOW__action_entries[19] = {{"FileQuit", "application-exit", N_ ("_Quit"), "<Control>Q", N_ ("Quit the program")}, {"View", NULL, N_ ("_View")}, {"ViewZoomIn", "zoom-in", N_ ("Zoom _In"), "<Control>plus", N_ ("Enlarge the font"), (GCallback) _main_window_on_view_zoom_in_gcallback}, {"ViewZoomOut", "zoom-out", N_ ("Zoom _Out"), "<Control>minus", N_ ("Shrink the font"), (GCallback) _main_window_on_view_zoom_out_gcallback}, {"ViewZoomReset", "zoom-original", N_ ("_Reset Zoom"), "<Control>0", N_ ("Reset the size of the font"), (GCallback) _main_window_on_view_zoom_reset_gcallback}, {"Search", NULL, N_ ("_Search")}, {"SearchFind", "edit-find", N_ ("_Find"), "<Control>F", N_ ("Search for text"), (GCallback) _main_window_on_search_find_gcallback}, {"SearchReplace", "edit-find-replace", N_ ("Find and _Replace"), "<Control>H", N_ ("Search for and replace text"), (GCallback) _main_window_on_search_replace_gcallback}, {"SearchForward", NULL, N_ ("_Jump to PDF"), "<Control><Alt>F", N_ ("Jump to the associated position in the PDF file. Another shortcut: Ctr" \
"l+click, which works in both directions."), (GCallback) _main_window_on_search_forward_gcallback}, {"Latex", NULL, "_LaTeX"}, {"Math", NULL, N_ ("_Math")}, {"Projects", NULL, N_ ("_Projects")}, {"ProjectsNew", "document-new", N_ ("_New Project"), "", N_ ("Create a new project"), (GCallback) _main_window_on_projects_new_gcallback}, {"ProjectsConfigCurrent", "document-properties", N_ ("_Configure Current Project"), NULL, N_ ("Change the main file of the current project"), (GCallback) _main_window_on_projects_config_current_gcallback}, {"ProjectsManage", "preferences-system", N_ ("_Manage Projects"), NULL, N_ ("Manage Projects"), (GCallback) _main_window_on_projects_manage_gcallback}, {"Help", NULL, N_ ("_Help")}, {"HelpContents", "help-browser", N_ ("_Contents"), "<Release>F1", N_ ("Open the GNOME LaTeX documentation")}, {"HelpLatexReference", NULL, N_ ("_LaTeX Reference"), NULL, N_ ("The Kile LaTeX Reference"), (GCallback) _main_window_on_help_latex_reference_gcallback}, {"HelpAbout", "help-about", N_ ("_About"), NULL, N_ ("About GNOME LaTeX")}};
static const GtkToggleActionEntry MAIN_WINDOW__toggle_action_entries[4] = {{"ViewMainToolbar", NULL, N_ ("_Main Toolbar"), NULL, N_ ("Show or hide the main toolbar"), (GCallback) NULL}, {"ViewEditToolbar", NULL, N_ ("_Edit Toolbar"), NULL, N_ ("Show or hide the edit toolbar"), (GCallback) NULL}, {"ViewSidePanel", NULL, N_ ("_Side panel"), "<Release>F12", N_ ("Show or hide the side panel"), (GCallback) NULL}, {"ViewBottomPanel", NULL, N_ ("_Bottom panel"), NULL, N_ ("Show or hide the bottom panel"), (GCallback) NULL}};

static inline gpointer
main_window_get_instance_private (MainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, MainWindow_private_offset);
}

static void
_main_window_on_view_zoom_in_gcallback (GtkAction* action,
                                        gpointer self)
{
	main_window_on_view_zoom_in ((MainWindow*) self);
}

static void
_main_window_on_view_zoom_out_gcallback (GtkAction* action,
                                         gpointer self)
{
	main_window_on_view_zoom_out ((MainWindow*) self);
}

static void
_main_window_on_view_zoom_reset_gcallback (GtkAction* action,
                                           gpointer self)
{
	main_window_on_view_zoom_reset ((MainWindow*) self);
}

static void
_main_window_on_search_find_gcallback (GtkAction* action,
                                       gpointer self)
{
	main_window_on_search_find ((MainWindow*) self);
}

static void
_main_window_on_search_replace_gcallback (GtkAction* action,
                                          gpointer self)
{
	main_window_on_search_replace ((MainWindow*) self);
}

static void
_main_window_on_search_forward_gcallback (GtkAction* action,
                                          gpointer self)
{
	main_window_on_search_forward ((MainWindow*) self);
}

static void
_main_window_on_projects_new_gcallback (GtkAction* action,
                                        gpointer self)
{
	main_window_on_projects_new ((MainWindow*) self);
}

static void
_main_window_on_projects_config_current_gcallback (GtkAction* action,
                                                   gpointer self)
{
	main_window_on_projects_config_current ((MainWindow*) self);
}

static void
_main_window_on_projects_manage_gcallback (GtkAction* action,
                                           gpointer self)
{
	main_window_on_projects_manage ((MainWindow*) self);
}

static void
_main_window_on_help_latex_reference_gcallback (GtkAction* action,
                                                gpointer self)
{
	main_window_on_help_latex_reference ((MainWindow*) self);
}

/*************************************************************************/
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda101_ (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	main_window_update_file_actions_sensitivity (self);
	main_window_update_config_project_sensitivity (self);
	_tmp0_ = main_window_get_active_tab (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		SearchAndReplace* _tmp2_;
		_tmp2_ = self->priv->_search_and_replace;
		search_and_replace_hide (_tmp2_);
	}
	g_object_notify ((GObject*) self, "active-tab");
}

static void
___lambda101__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda101_ ((MainWindow*) self);
}

static void
__lambda102_ (MainWindow* self)
{
	g_object_notify ((GObject*) self, "active-view");
}

static void
___lambda102__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda102_ ((MainWindow*) self);
}

static void
__lambda103_ (MainWindow* self)
{
	g_object_notify ((GObject*) self, "active-document");
}

static void
___lambda103__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda103_ ((MainWindow*) self);
}

static gboolean
__lambda105_ (MainWindow* self)
{
	gboolean result = FALSE;
	main_window_quit (self);
	result = TRUE;
	return result;
}

static gboolean
___lambda105__gtk_widget_delete_event (GtkWidget* _sender,
                                       GdkEventAny* event,
                                       gpointer self)
{
	gboolean result;
	result = __lambda105_ ((MainWindow*) self);
	return result;
}

MainWindow*
main_window_construct (GType object_type,
                       GlatexApp* app)
{
	MainWindow * self = NULL;
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	GtkUIManager* _tmp2_;
	MainWindowFile* _tmp3_;
	GtkUIManager* _tmp4_;
	MainWindowEdit* _tmp5_;
	GtkUIManager* _tmp6_;
	MainWindowBuildTools* _tmp7_;
	GtkUIManager* _tmp8_;
	MainWindowDocuments* _tmp9_;
	GtkUIManager* _tmp10_;
	MainWindowStructure* _tmp11_;
	GtkUIManager* _tmp12_;
	MainWindowTools* _tmp13_;
	GtkGrid* main_vgrid = NULL;
	GtkGrid* _tmp14_;
	GtkMenuBar* menubar = NULL;
	GtkUIManager* _tmp15_;
	GtkWidget* _tmp16_;
	GtkMenuBar* _tmp17_;
	GtkMenuItem* latex_menu_item = NULL;
	GtkUIManager* _tmp18_;
	GtkWidget* _tmp19_;
	GtkMenuItem* _tmp20_;
	GtkMenu* _tmp21_;
	GtkMenuItem* math_menu_item = NULL;
	GtkUIManager* _tmp22_;
	GtkWidget* _tmp23_;
	GtkMenuItem* _tmp24_;
	GtkMenu* _tmp25_;
	GtkWidget* _tmp26_;
	GtkToolbar* main_toolbar = NULL;
	GtkToolbar* _tmp27_;
	GtkToolbar* edit_toolbar = NULL;
	GtkToolbar* _tmp28_;
	GtkPaned* _tmp29_;
	GtkPaned* _tmp30_;
	GtkPaned* _tmp31_;
	TeplPanel* _tmp32_;
	GtkPaned* _tmp33_;
	TeplPanel* _tmp34_;
	GtkPaned* _tmp35_;
	GtkPaned* _tmp36_;
	GtkPaned* _tmp37_;
	GtkPaned* _tmp38_;
	GtkGrid* docs_vgrid = NULL;
	GtkGrid* _tmp39_;
	DocumentsPanel* _tmp40_;
	SearchAndReplace* _tmp41_;
	SearchAndReplace* _tmp42_;
	GtkWidget* _tmp43_;
	GtkWidget* _tmp44_;
	BottomPanel* bottom_panel = NULL;
	BottomPanel* _tmp45_;
	MainWindowBuildTools* _tmp46_;
	GtkPaned* _tmp47_;
	GtkPaned* _tmp48_;
	TeplStatusbar* _tmp49_;
	TeplLineColumnIndicator* line_col_indicator = NULL;
	TeplLineColumnIndicator* _tmp50_;
	DocumentsPanel* _tmp51_;
	TeplStatusbar* _tmp52_;
	TeplStatusbar* _tmp53_;
	TeplStatusbar* _tmp54_;
	AmtkApplicationWindow* amtk_window = NULL;
	AmtkApplicationWindow* _tmp55_;
	AmtkApplicationWindow* _tmp56_;
	TeplStatusbar* _tmp57_;
	TeplStatusbar* _tmp58_;
	DocumentsPanel* _tmp59_;
	g_return_val_if_fail (app != NULL, NULL);
	self = (MainWindow*) g_object_new (object_type, "application", app, NULL);
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	tepl_window = _tmp1_;
	latexila_latex_commands_add_actions ((GtkApplicationWindow*) self);
	main_window_initialize_ui_manager (self);
	_tmp2_ = self->priv->_ui_manager;
	_tmp3_ = main_window_file_new (self, _tmp2_);
	_main_window_file_unref0 (self->priv->_main_window_file);
	self->priv->_main_window_file = _tmp3_;
	_tmp4_ = self->priv->_ui_manager;
	_tmp5_ = main_window_edit_new (self, _tmp4_);
	_main_window_edit_unref0 (self->priv->_main_window_edit);
	self->priv->_main_window_edit = _tmp5_;
	_tmp6_ = self->priv->_ui_manager;
	_tmp7_ = main_window_build_tools_new (self, _tmp6_);
	_main_window_build_tools_unref0 (self->priv->_main_window_build_tools);
	self->priv->_main_window_build_tools = _tmp7_;
	_tmp8_ = self->priv->_ui_manager;
	_tmp9_ = main_window_documents_new (self, _tmp8_);
	_main_window_documents_unref0 (self->priv->_main_window_documents);
	self->priv->_main_window_documents = _tmp9_;
	_tmp10_ = self->priv->_ui_manager;
	_tmp11_ = main_window_structure_new (_tmp10_);
	_main_window_structure_unref0 (self->priv->_main_window_structure);
	self->priv->_main_window_structure = _tmp11_;
	_tmp12_ = self->priv->_ui_manager;
	_tmp13_ = main_window_tools_new (self, _tmp12_);
	_main_window_tools_unref0 (self->priv->_main_window_tools);
	self->priv->_main_window_tools = _tmp13_;
	main_window_show_images_in_menu (self);
	main_window_update_file_actions_sensitivity (self);
	_tmp14_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp14_);
	main_vgrid = _tmp14_;
	gtk_orientable_set_orientation ((GtkOrientable*) main_vgrid, GTK_ORIENTATION_VERTICAL);
	gtk_widget_show ((GtkWidget*) main_vgrid);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_vgrid);
	_tmp15_ = self->priv->_ui_manager;
	_tmp16_ = gtk_ui_manager_get_widget (_tmp15_, "/MainMenu");
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, gtk_menu_bar_get_type ()) ? ((GtkMenuBar*) _tmp16_) : NULL);
	menubar = _tmp17_;
	_tmp18_ = self->priv->_ui_manager;
	_tmp19_ = gtk_ui_manager_get_widget (_tmp18_, "/MainMenu/Latex");
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, gtk_menu_item_get_type ()) ? ((GtkMenuItem*) _tmp19_) : NULL);
	latex_menu_item = _tmp20_;
	_tmp21_ = latexila_latex_commands_create_latex_menu ((GtkApplicationWindow*) self);
	gtk_menu_item_set_submenu (latex_menu_item, _tmp21_);
	_tmp22_ = self->priv->_ui_manager;
	_tmp23_ = gtk_ui_manager_get_widget (_tmp22_, "/MainMenu/Math");
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, gtk_menu_item_get_type ()) ? ((GtkMenuItem*) _tmp23_) : NULL);
	math_menu_item = _tmp24_;
	_tmp25_ = latexila_latex_commands_create_math_menu ((GtkApplicationWindow*) self);
	gtk_menu_item_set_submenu (math_menu_item, _tmp25_);
	gtk_widget_show_all ((GtkWidget*) menubar);
	_tmp26_ = amtk_utils_get_shrinkable_menubar (menubar);
	gtk_container_add ((GtkContainer*) main_vgrid, _tmp26_);
	_tmp27_ = main_window_get_main_toolbar (self);
	main_toolbar = _tmp27_;
	_tmp28_ = main_window_get_edit_toolbar (self);
	edit_toolbar = _tmp28_;
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) main_toolbar);
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) edit_toolbar);
	_tmp29_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->_main_hpaned);
	self->priv->_main_hpaned = _tmp29_;
	_tmp30_ = self->priv->_main_hpaned;
	gtk_widget_show ((GtkWidget*) _tmp30_);
	_tmp31_ = self->priv->_main_hpaned;
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) _tmp31_);
	_tmp32_ = main_window_get_side_panel (self);
	_g_object_unref0 (self->priv->_side_panel);
	self->priv->_side_panel = _tmp32_;
	_tmp33_ = self->priv->_main_hpaned;
	_tmp34_ = self->priv->_side_panel;
	gtk_paned_pack1 (_tmp33_, (GtkWidget*) _tmp34_, FALSE, FALSE);
	_tmp35_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_VERTICAL);
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->priv->_vpaned);
	self->priv->_vpaned = _tmp35_;
	_tmp36_ = self->priv->_vpaned;
	gtk_widget_show ((GtkWidget*) _tmp36_);
	_tmp37_ = self->priv->_main_hpaned;
	_tmp38_ = self->priv->_vpaned;
	gtk_paned_add2 (_tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp39_);
	docs_vgrid = _tmp39_;
	gtk_orientable_set_orientation ((GtkOrientable*) docs_vgrid, GTK_ORIENTATION_VERTICAL);
	gtk_grid_set_row_spacing (docs_vgrid, (guint) 2);
	gtk_widget_show ((GtkWidget*) docs_vgrid);
	main_window_init_documents_panel (self);
	_tmp40_ = self->priv->_documents_panel;
	gtk_container_add ((GtkContainer*) docs_vgrid, (GtkWidget*) _tmp40_);
	_tmp41_ = search_and_replace_new (self);
	_g_object_unref0 (self->priv->_search_and_replace);
	self->priv->_search_and_replace = _tmp41_;
	_tmp42_ = self->priv->_search_and_replace;
	_tmp43_ = search_and_replace_get_widget (_tmp42_);
	_tmp44_ = _tmp43_;
	gtk_container_add ((GtkContainer*) docs_vgrid, _tmp44_);
	_g_object_unref0 (_tmp44_);
	_tmp45_ = main_window_get_bottom_panel (self);
	bottom_panel = _tmp45_;
	_tmp46_ = self->priv->_main_window_build_tools;
	main_window_build_tools_set_bottom_panel (_tmp46_, bottom_panel);
	_tmp47_ = self->priv->_vpaned;
	gtk_paned_pack1 (_tmp47_, (GtkWidget*) docs_vgrid, TRUE, TRUE);
	_tmp48_ = self->priv->_vpaned;
	gtk_paned_pack2 (_tmp48_, (GtkWidget*) bottom_panel, FALSE, FALSE);
	_tmp49_ = tepl_statusbar_new ();
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (self->priv->_statusbar);
	self->priv->_statusbar = _tmp49_;
	_tmp50_ = tepl_line_column_indicator_new ();
	g_object_ref_sink (_tmp50_);
	line_col_indicator = _tmp50_;
	gtk_widget_show ((GtkWidget*) line_col_indicator);
	_tmp51_ = self->priv->_documents_panel;
	tepl_line_column_indicator_set_tab_group (line_col_indicator, (TeplTabGroup*) _tmp51_);
	_tmp52_ = self->priv->_statusbar;
	gtk_box_pack_end ((GtkBox*) _tmp52_, (GtkWidget*) line_col_indicator, FALSE, FALSE, (guint) 0);
	_tmp53_ = self->priv->_statusbar;
	gtk_widget_show ((GtkWidget*) _tmp53_);
	_tmp54_ = self->priv->_statusbar;
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) _tmp54_);
	_tmp55_ = amtk_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
	_tmp56_ = _g_object_ref0 (_tmp55_);
	amtk_window = _tmp56_;
	_tmp57_ = self->priv->_statusbar;
	amtk_application_window_set_statusbar (amtk_window, (GtkStatusbar*) _tmp57_);
	_tmp58_ = self->priv->_statusbar;
	self->priv->_tip_message_cid = gtk_statusbar_get_context_id ((GtkStatusbar*) _tmp58_, "tip_message");
	g_signal_connect_object ((GObject*) tepl_window, "notify::active-tab", (GCallback) ___lambda101__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) tepl_window, "notify::active-view", (GCallback) ___lambda102__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) tepl_window, "notify::active-buffer", (GCallback) ___lambda103__g_object_notify, self, 0);
	_tmp59_ = self->priv->_documents_panel;
	tepl_application_window_set_tab_group (tepl_window, (TeplTabGroup*) _tmp59_);
	tepl_application_window_set_handle_title (tepl_window, TRUE);
	main_window_support_drag_and_drop (self);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) ___lambda105__gtk_widget_delete_event, self, 0);
	main_window_restore_state (self);
	main_window_show_or_hide_widgets (self);
	gtk_widget_show ((GtkWidget*) self);
	_g_object_unref0 (amtk_window);
	_g_object_unref0 (line_col_indicator);
	_g_object_unref0 (bottom_panel);
	_g_object_unref0 (docs_vgrid);
	_g_object_unref0 (edit_toolbar);
	_g_object_unref0 (main_toolbar);
	_g_object_unref0 (math_menu_item);
	_g_object_unref0 (latex_menu_item);
	_g_object_unref0 (menubar);
	_g_object_unref0 (main_vgrid);
	_g_object_unref0 (tepl_window);
	return self;
}

MainWindow*
main_window_new (GlatexApp* app)
{
	return main_window_construct (TYPE_MAIN_WINDOW, app);
}

static void
main_window_show_images_in_menu (MainWindow* self)
{
	GtkUIManager* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_ui_manager;
	_tmp1_ = gtk_ui_manager_get_action_groups (_tmp0_);
	{
		GList* action_group_collection = NULL;
		GList* action_group_it = NULL;
		action_group_collection = _tmp1_;
		for (action_group_it = action_group_collection; action_group_it != NULL; action_group_it = action_group_it->next) {
			GtkActionGroup* _tmp2_;
			GtkActionGroup* action_group = NULL;
			_tmp2_ = _g_object_ref0 ((GtkActionGroup*) action_group_it->data);
			action_group = _tmp2_;
			{
				GtkActionGroup* _tmp3_;
				GList* _tmp4_;
				_tmp3_ = action_group;
				_tmp4_ = gtk_action_group_list_actions (_tmp3_);
				{
					GList* action_collection = NULL;
					GList* action_it = NULL;
					action_collection = _tmp4_;
					for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
						GtkAction* _tmp5_;
						GtkAction* action = NULL;
						_tmp5_ = _g_object_ref0 ((GtkAction*) action_it->data);
						action = _tmp5_;
						{
							GtkAction* _tmp6_;
							_tmp6_ = action;
							gtk_action_set_always_show_image (_tmp6_, TRUE);
							_g_object_unref0 (action);
						}
					}
					(action_collection == NULL) ? NULL : (action_collection = (g_list_free (action_collection), NULL));
				}
				_g_object_unref0 (action_group);
			}
		}
	}
}

static void
_main_window_on_menu_item_select_gtk_menu_item_select (GtkMenuItem* _sender,
                                                       gpointer self)
{
	main_window_on_menu_item_select ((MainWindow*) self, _sender);
}

static void
_main_window_on_menu_item_deselect_gtk_menu_item_deselect (GtkMenuItem* _sender,
                                                           gpointer self)
{
	main_window_on_menu_item_deselect ((MainWindow*) self, _sender);
}

static void
__lambda85_ (MainWindow* self,
             GtkAction* action,
             GtkWidget* p)
{
	g_return_if_fail (action != NULL);
	g_return_if_fail (p != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (p, gtk_menu_item_get_type ())) {
		GtkMenuItem* proxy = NULL;
		GtkMenuItem* _tmp0_;
		GtkMenuItem* _tmp1_;
		GtkMenuItem* _tmp2_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (p, gtk_menu_item_get_type ()) ? ((GtkMenuItem*) p) : NULL);
		proxy = _tmp0_;
		_tmp1_ = proxy;
		g_signal_connect_object (_tmp1_, "select", (GCallback) _main_window_on_menu_item_select_gtk_menu_item_select, self, 0);
		_tmp2_ = proxy;
		g_signal_connect_object (_tmp2_, "deselect", (GCallback) _main_window_on_menu_item_deselect_gtk_menu_item_deselect, self, 0);
		_g_object_unref0 (proxy);
	}
}

static void
___lambda85__gtk_ui_manager_connect_proxy (GtkUIManager* _sender,
                                           GtkAction* action,
                                           GtkWidget* proxy,
                                           gpointer self)
{
	__lambda85_ ((MainWindow*) self, action, proxy);
}

static void
__lambda86_ (MainWindow* self,
             GtkAction* action,
             GtkWidget* p)
{
	g_return_if_fail (action != NULL);
	g_return_if_fail (p != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (p, gtk_menu_item_get_type ())) {
		GtkMenuItem* proxy = NULL;
		GtkMenuItem* _tmp0_;
		GtkMenuItem* _tmp1_;
		guint _tmp2_;
		GtkMenuItem* _tmp3_;
		guint _tmp4_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (p, gtk_menu_item_get_type ()) ? ((GtkMenuItem*) p) : NULL);
		proxy = _tmp0_;
		_tmp1_ = proxy;
		g_signal_parse_name ("select", gtk_menu_item_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _main_window_on_menu_item_select_gtk_menu_item_select, self);
		_tmp3_ = proxy;
		g_signal_parse_name ("deselect", gtk_menu_item_get_type (), &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _main_window_on_menu_item_deselect_gtk_menu_item_deselect, self);
		_g_object_unref0 (proxy);
	}
}

static void
___lambda86__gtk_ui_manager_disconnect_proxy (GtkUIManager* _sender,
                                              GtkAction* action,
                                              GtkWidget* proxy,
                                              gpointer self)
{
	__lambda86_ ((MainWindow*) self, action, proxy);
}

static void
main_window_initialize_ui_manager (MainWindow* self)
{
	GtkActionGroup* _tmp0_;
	GtkActionGroup* _tmp1_;
	GtkActionGroup* _tmp2_;
	GtkActionGroup* _tmp3_;
	GtkActionGroup* _tmp4_;
	GtkUIManager* _tmp5_;
	GtkUIManager* _tmp6_;
	GtkActionGroup* _tmp7_;
	GtkUIManager* _tmp12_;
	GtkAccelGroup* _tmp13_;
	GlatexApp* app = NULL;
	GlatexApp* _tmp14_;
	GtkActionGroup* _tmp15_;
	GtkActionGroup* _tmp16_;
	GtkActionGroup* _tmp17_;
	GtkUIManager* _tmp18_;
	GtkUIManager* _tmp19_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_action_group_new ("ActionGroup");
	_g_object_unref0 (self->priv->_action_group);
	self->priv->_action_group = _tmp0_;
	_tmp1_ = self->priv->_action_group;
	gtk_action_group_set_translation_domain (_tmp1_, GETTEXT_PACKAGE);
	_tmp2_ = self->priv->_action_group;
	gtk_action_group_add_actions (_tmp2_, MAIN_WINDOW__action_entries, (guint) G_N_ELEMENTS (MAIN_WINDOW__action_entries), self);
	_tmp3_ = self->priv->_action_group;
	gtk_action_group_add_toggle_actions (_tmp3_, MAIN_WINDOW__toggle_action_entries, (guint) G_N_ELEMENTS (MAIN_WINDOW__toggle_action_entries), self);
	_tmp4_ = self->priv->_action_group;
	amtk_utils_create_gtk_action ((GActionMap*) self, "win.tepl-goto-line", _tmp4_, "SearchGoToLine");
	_tmp5_ = gtk_ui_manager_new ();
	_g_object_unref0 (self->priv->_ui_manager);
	self->priv->_ui_manager = _tmp5_;
	_tmp6_ = self->priv->_ui_manager;
	_tmp7_ = self->priv->_action_group;
	gtk_ui_manager_insert_action_group (_tmp6_, _tmp7_, 0);
	{
		gchar* path = NULL;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		GtkUIManager* _tmp10_;
		_tmp8_ = latexila_dirs_get_app_data_dir ();
		_tmp9_ = g_build_filename (_tmp8_, "ui", "ui.xml", NULL);
		path = _tmp9_;
		_tmp10_ = self->priv->_ui_manager;
		gtk_ui_manager_add_ui_from_file (_tmp10_, path, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (path);
			goto __catch0_g_error;
		}
		_g_free0 (path);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp11_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = err->message;
		g_error ("main_window.vala:344: %s", _tmp11_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp12_ = self->priv->_ui_manager;
	_tmp13_ = gtk_ui_manager_get_accel_group (_tmp12_);
	gtk_window_add_accel_group ((GtkWindow*) self, _tmp13_);
	_tmp14_ = glatex_app_get_instance ();
	app = _tmp14_;
	_tmp15_ = self->priv->_action_group;
	amtk_utils_bind_g_action_to_gtk_action ((GActionMap*) app, "quit", _tmp15_, "FileQuit");
	_tmp16_ = self->priv->_action_group;
	amtk_utils_bind_g_action_to_gtk_action ((GActionMap*) app, "help", _tmp16_, "HelpContents");
	_tmp17_ = self->priv->_action_group;
	amtk_utils_bind_g_action_to_gtk_action ((GActionMap*) app, "about", _tmp17_, "HelpAbout");
	_tmp18_ = self->priv->_ui_manager;
	g_signal_connect_object (_tmp18_, "connect-proxy", (GCallback) ___lambda85__gtk_ui_manager_connect_proxy, self, 0);
	_tmp19_ = self->priv->_ui_manager;
	g_signal_connect_object (_tmp19_, "disconnect-proxy", (GCallback) ___lambda86__gtk_ui_manager_disconnect_proxy, self, 0);
	_g_object_unref0 (app);
}

static void
main_window_on_menu_item_select (MainWindow* self,
                                 GtkMenuItem* proxy)
{
	GtkAction* action = NULL;
	GtkAction* _tmp0_;
	GtkAction* _tmp1_;
	GtkAction* _tmp2_;
	GtkAction* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proxy != NULL);
	_tmp0_ = gtk_activatable_get_related_action ((GtkActivatable*) proxy);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	action = _tmp1_;
	_tmp2_ = action;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = action;
	_tmp4_ = gtk_action_get_tooltip (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		TeplStatusbar* _tmp6_;
		GtkAction* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = self->priv->_statusbar;
		_tmp7_ = action;
		_tmp8_ = gtk_action_get_tooltip (_tmp7_);
		_tmp9_ = _tmp8_;
		gtk_statusbar_push ((GtkStatusbar*) _tmp6_, self->priv->_tip_message_cid, _tmp9_);
	}
	_g_object_unref0 (action);
}

static void
main_window_on_menu_item_deselect (MainWindow* self,
                                   GtkMenuItem* proxy)
{
	TeplStatusbar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proxy != NULL);
	_tmp0_ = self->priv->_statusbar;
	gtk_statusbar_pop ((GtkStatusbar*) _tmp0_, self->priv->_tip_message_cid);
}

static GtkToolbar*
main_window_get_main_toolbar (MainWindow* self)
{
	GtkToolbar* main_toolbar = NULL;
	GtkUIManager* _tmp0_;
	GtkWidget* _tmp1_;
	GtkToolbar* _tmp2_;
	GtkToolItem* open_button = NULL;
	MainWindowFile* _tmp3_;
	GtkToolItem* _tmp4_;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp7_;
	GtkAction* _tmp8_;
	GtkToggleAction* _tmp9_;
	GtkToolbar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ui_manager;
	_tmp1_ = gtk_ui_manager_get_widget (_tmp0_, "/MainToolbar");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_toolbar_get_type ()) ? ((GtkToolbar*) _tmp1_) : NULL);
	main_toolbar = _tmp2_;
	_tmp3_ = self->priv->_main_window_file;
	_tmp4_ = main_window_file_get_toolbar_open_button (_tmp3_);
	open_button = _tmp4_;
	gtk_toolbar_insert (main_toolbar, open_button, 1);
	gtk_toolbar_set_style (main_toolbar, GTK_TOOLBAR_ICONS);
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) main_toolbar);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	context = _tmp6_;
	gtk_style_context_add_class (context, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
	gtk_widget_show_all ((GtkWidget*) main_toolbar);
	_tmp7_ = self->priv->_action_group;
	_tmp8_ = gtk_action_group_get_action (_tmp7_, "ViewMainToolbar");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp8_) : NULL);
	action = _tmp9_;
	gtk_toggle_action_set_active (action, TRUE);
	g_object_bind_property_with_closures ((GObject*) main_toolbar, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	result = main_toolbar;
	_g_object_unref0 (action);
	_g_object_unref0 (context);
	_g_object_unref0 (open_button);
	return result;
}

static GtkToolbar*
main_window_get_edit_toolbar (MainWindow* self)
{
	GtkToolbar* edit_toolbar = NULL;
	GtkToolbar* _tmp0_;
	GtkToolbar* _tmp1_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp2_;
	GtkAction* _tmp3_;
	GtkToggleAction* _tmp4_;
	GtkToolbar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = latexila_latex_commands_create_edit_toolbar ((GtkApplicationWindow*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	edit_toolbar = _tmp1_;
	_tmp2_ = self->priv->_action_group;
	_tmp3_ = gtk_action_group_get_action (_tmp2_, "ViewEditToolbar");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp3_) : NULL);
	action = _tmp4_;
	gtk_toggle_action_set_active (action, TRUE);
	g_object_bind_property_with_closures ((GObject*) edit_toolbar, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	result = edit_toolbar;
	_g_object_unref0 (action);
	return result;
}

static TeplPanel*
main_window_get_side_panel (MainWindow* self)
{
	TeplPanel* side_panel = NULL;
	TeplPanel* _tmp0_;
	SymbolsView* symbols = NULL;
	SymbolsView* _tmp1_;
	FileBrowser* file_browser = NULL;
	FileBrowser* _tmp2_;
	Structure* structure = NULL;
	Structure* _tmp3_;
	MainWindowStructure* _tmp4_;
	GSettings* settings = NULL;
	GSettings* _tmp5_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp6_;
	GtkAction* _tmp7_;
	GtkToggleAction* _tmp8_;
	TeplPanel* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tepl_panel_new_for_left_side_panel ();
	g_object_ref_sink (_tmp0_);
	side_panel = _tmp0_;
	_tmp1_ = symbols_view_new (self);
	g_object_ref_sink (_tmp1_);
	symbols = _tmp1_;
	tepl_panel_add_component (side_panel, (GtkWidget*) symbols, "symbols", _ ("Symbols"), "symbol_greek");
	_tmp2_ = file_browser_new (self);
	g_object_ref_sink (_tmp2_);
	file_browser = _tmp2_;
	tepl_panel_add_component (side_panel, (GtkWidget*) file_browser, "file-browser", _ ("File Browser"), "document-open");
	_tmp3_ = structure_new (self);
	g_object_ref_sink (_tmp3_);
	structure = _tmp3_;
	_tmp4_ = self->priv->_main_window_structure;
	main_window_structure_set_structure (_tmp4_, structure);
	tepl_panel_add_component (side_panel, (GtkWidget*) structure, "structure", _ ("Structure"), GTK_STOCK_INDEX);
	_tmp5_ = g_settings_new ("org.gnome.gnome-latex.preferences.ui");
	settings = _tmp5_;
	tepl_panel_provide_active_component_gsetting (side_panel, settings, "side-panel-component");
	tepl_panel_restore_state_from_gsettings (side_panel);
	_tmp6_ = self->priv->_action_group;
	_tmp7_ = gtk_action_group_get_action (_tmp6_, "ViewSidePanel");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp7_) : NULL);
	action = _tmp8_;
	gtk_toggle_action_set_active (action, TRUE);
	g_object_bind_property_with_closures ((GObject*) side_panel, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	result = side_panel;
	_g_object_unref0 (action);
	_g_object_unref0 (settings);
	_g_object_unref0 (structure);
	_g_object_unref0 (file_browser);
	_g_object_unref0 (symbols);
	return result;
}

static void
__lambda100_ (MainWindow* self,
              GdkEventButton* event)
{
	GtkMenu* popup_menu = NULL;
	GtkUIManager* _tmp0_;
	GtkWidget* _tmp1_;
	GtkMenu* _tmp2_;
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->_ui_manager;
	_tmp1_ = gtk_ui_manager_get_widget (_tmp0_, "/NotebookPopup");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_menu_get_type ()) ? ((GtkMenu*) _tmp1_) : NULL);
	popup_menu = _tmp2_;
	gtk_menu_popup_at_pointer (popup_menu, (GdkEvent*) event);
	_g_object_unref0 (popup_menu);
}

static void
___lambda100__documents_panel_right_click (DocumentsPanel* _sender,
                                           GdkEventButton* event,
                                           gpointer self)
{
	__lambda100_ ((MainWindow*) self, event);
}

static void
main_window_init_documents_panel (MainWindow* self)
{
	DocumentsPanel* _tmp0_;
	DocumentsPanel* _tmp1_;
	MainWindowDocuments* _tmp2_;
	DocumentsPanel* _tmp3_;
	DocumentsPanel* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = documents_panel_new (self);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_documents_panel);
	self->priv->_documents_panel = _tmp0_;
	_tmp1_ = self->priv->_documents_panel;
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->_main_window_documents;
	_tmp3_ = self->priv->_documents_panel;
	main_window_documents_set_documents_panel (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->_documents_panel;
	g_signal_connect_object (_tmp4_, "right-click", (GCallback) ___lambda100__documents_panel_right_click, self, 0);
}

static BottomPanel*
main_window_get_bottom_panel (MainWindow* self)
{
	LatexilaBuildView* build_view = NULL;
	LatexilaBuildView* _tmp0_;
	MainWindowBuildTools* _tmp1_;
	GtkToolbar* build_toolbar = NULL;
	GtkUIManager* _tmp2_;
	GtkWidget* _tmp3_;
	GtkToolbar* _tmp4_;
	BottomPanel* bottom_panel = NULL;
	BottomPanel* _tmp5_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp6_;
	GtkAction* _tmp7_;
	GtkToggleAction* _tmp8_;
	BottomPanel* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = latexila_build_view_new ();
	g_object_ref_sink (_tmp0_);
	build_view = _tmp0_;
	_tmp1_ = self->priv->_main_window_build_tools;
	main_window_build_tools_set_build_view (_tmp1_, build_view);
	_tmp2_ = self->priv->_ui_manager;
	_tmp3_ = gtk_ui_manager_get_widget (_tmp2_, "/BuildToolbar");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_toolbar_get_type ()) ? ((GtkToolbar*) _tmp3_) : NULL);
	build_toolbar = _tmp4_;
	gtk_toolbar_set_style (build_toolbar, GTK_TOOLBAR_ICONS);
	gtk_toolbar_set_icon_size (build_toolbar, GTK_ICON_SIZE_MENU);
	gtk_orientable_set_orientation ((GtkOrientable*) build_toolbar, GTK_ORIENTATION_VERTICAL);
	_tmp5_ = bottom_panel_new (build_view, build_toolbar);
	g_object_ref_sink (_tmp5_);
	bottom_panel = _tmp5_;
	_tmp6_ = self->priv->_action_group;
	_tmp7_ = gtk_action_group_get_action (_tmp6_, "ViewBottomPanel");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp7_) : NULL);
	action = _tmp8_;
	gtk_toggle_action_set_active (action, FALSE);
	g_object_bind_property_with_closures ((GObject*) bottom_panel, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	result = bottom_panel;
	_g_object_unref0 (action);
	_g_object_unref0 (build_toolbar);
	_g_object_unref0 (build_view);
	return result;
}

static void
main_window_restore_state (MainWindow* self)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	gint width = 0;
	gint height = 0;
	GSettings* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GdkWindowState state = 0U;
	GSettings* _tmp4_;
	GtkPaned* _tmp5_;
	GSettings* _tmp6_;
	GtkPaned* _tmp7_;
	GSettings* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.state.window");
	settings = _tmp0_;
	_tmp1_ = settings;
	g_settings_get (_tmp1_, "size", "(ii)", &_tmp2_, &_tmp3_);
	width = _tmp2_;
	height = _tmp3_;
	gtk_window_set_default_size ((GtkWindow*) self, width, height);
	_tmp4_ = settings;
	state = (GdkWindowState) g_settings_get_int (_tmp4_, "state");
	if ((state & GDK_WINDOW_STATE_MAXIMIZED) == GDK_WINDOW_STATE_MAXIMIZED) {
		gtk_window_maximize ((GtkWindow*) self);
	} else {
		gtk_window_unmaximize ((GtkWindow*) self);
	}
	if ((state & GDK_WINDOW_STATE_STICKY) == GDK_WINDOW_STATE_STICKY) {
		gtk_window_stick ((GtkWindow*) self);
	} else {
		gtk_window_unstick ((GtkWindow*) self);
	}
	_tmp5_ = self->priv->_main_hpaned;
	_tmp6_ = settings;
	gtk_paned_set_position (_tmp5_, g_settings_get_int (_tmp6_, "side-panel-size"));
	_tmp7_ = self->priv->_vpaned;
	_tmp8_ = settings;
	gtk_paned_set_position (_tmp7_, g_settings_get_int (_tmp8_, "vertical-paned-position"));
	_g_object_unref0 (settings);
}

static void
_vala_array_add5 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda104_ (MainWindow* self,
              GdkDragContext* dc,
              gint x,
              gint y,
              GtkSelectionData* selection_data,
              guint info,
              guint time)
{
	GlatexApp* app = NULL;
	GlatexApp* _tmp0_;
	GFile** files = NULL;
	GFile** _tmp1_;
	gint files_length1;
	gint _files_size_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	GlatexApp* _tmp10_;
	GFile** _tmp11_;
	gint _tmp11__length1;
	g_return_if_fail (dc != NULL);
	g_return_if_fail (selection_data != NULL);
	_tmp0_ = glatex_app_get_instance ();
	app = _tmp0_;
	_tmp1_ = g_new0 (GFile*, 0 + 1);
	files = _tmp1_;
	files_length1 = 0;
	_files_size_ = files_length1;
	_tmp3_ = _tmp2_ = gtk_selection_data_get_uris (selection_data);
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = _tmp3_;
		uri_collection_length1 = _vala_array_length (_tmp2_);
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			gchar* _tmp4_;
			gchar* uri = NULL;
			_tmp4_ = g_strdup (uri_collection[uri_it]);
			uri = _tmp4_;
			{
				const gchar* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				_tmp5_ = uri;
				_tmp6_ = strlen (_tmp5_);
				_tmp7_ = _tmp6_;
				if (0 < _tmp7_) {
					const gchar* _tmp8_;
					GFile* _tmp9_;
					_tmp8_ = uri;
					_tmp9_ = g_file_new_for_uri (_tmp8_);
					_vala_array_add5 (&files, &files_length1, &_files_size_, _tmp9_);
				}
				_g_free0 (uri);
			}
		}
		uri_collection = (_vala_array_free (uri_collection, uri_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp10_ = app;
	_tmp11_ = files;
	_tmp11__length1 = files_length1;
	glatex_app_open_documents (_tmp10_, _tmp11_, (gint) _tmp11__length1);
	gtk_drag_finish (dc, TRUE, TRUE, (guint32) time);
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (app);
}

static void
___lambda104__gtk_widget_drag_data_received (GtkWidget* _sender,
                                             GdkDragContext* context,
                                             gint x,
                                             gint y,
                                             GtkSelectionData* selection_data,
                                             guint info,
                                             guint time_,
                                             gpointer self)
{
	__lambda104_ ((MainWindow*) self, context, x, y, selection_data, info, time_);
}

static void
main_window_support_drag_and_drop (MainWindow* self)
{
	GtkTargetEntry* _tmp0_;
	GtkTargetEntry* _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (GtkTargetEntry, 0);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 0;
	gtk_drag_dest_set ((GtkWidget*) self, GTK_DEST_DEFAULT_ALL, _tmp1_, (gint) 0, GDK_ACTION_COPY);
	_tmp1_ = (g_free (_tmp1_), NULL);
	gtk_drag_dest_add_uri_targets ((GtkWidget*) self);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-received", (GCallback) ___lambda104__gtk_widget_drag_data_received, self, 0);
}

static void
main_window_show_or_hide_widgets (MainWindow* self)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp1_;
	GtkAction* _tmp2_;
	GtkToggleAction* _tmp3_;
	GtkToggleAction* _tmp4_;
	GtkActionGroup* _tmp5_;
	GtkAction* _tmp6_;
	GtkToggleAction* _tmp7_;
	GtkToggleAction* _tmp8_;
	GtkActionGroup* _tmp9_;
	GtkAction* _tmp10_;
	GtkToggleAction* _tmp11_;
	GtkToggleAction* _tmp12_;
	GtkActionGroup* _tmp13_;
	GtkAction* _tmp14_;
	GtkToggleAction* _tmp15_;
	GtkToggleAction* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.ui");
	settings = _tmp0_;
	_tmp1_ = self->priv->_action_group;
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "ViewMainToolbar");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp2_) : NULL);
	action = _tmp3_;
	_tmp4_ = action;
	gtk_toggle_action_set_active (_tmp4_, g_settings_get_boolean (settings, "main-toolbar-visible"));
	_tmp5_ = self->priv->_action_group;
	_tmp6_ = gtk_action_group_get_action (_tmp5_, "ViewEditToolbar");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp6_) : NULL);
	_g_object_unref0 (action);
	action = _tmp7_;
	_tmp8_ = action;
	gtk_toggle_action_set_active (_tmp8_, g_settings_get_boolean (settings, "edit-toolbar-visible"));
	_tmp9_ = self->priv->_action_group;
	_tmp10_ = gtk_action_group_get_action (_tmp9_, "ViewSidePanel");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp10_) : NULL);
	_g_object_unref0 (action);
	action = _tmp11_;
	_tmp12_ = action;
	gtk_toggle_action_set_active (_tmp12_, g_settings_get_boolean (settings, "side-panel-visible"));
	_tmp13_ = self->priv->_action_group;
	_tmp14_ = gtk_action_group_get_action (_tmp13_, "ViewBottomPanel");
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp14_) : NULL);
	_g_object_unref0 (action);
	action = _tmp15_;
	_tmp16_ = action;
	gtk_toggle_action_set_active (_tmp16_, g_settings_get_boolean (settings, "bottom-panel-visible"));
	_g_object_unref0 (action);
	_g_object_unref0 (settings);
}

/*************************************************************************/
static gpointer
_main_window_structure_ref0 (gpointer self)
{
	return self ? main_window_structure_ref (self) : NULL;
}

MainWindowStructure*
main_window_get_main_window_structure (MainWindow* self)
{
	MainWindowStructure* _tmp0_;
	MainWindowStructure* _tmp1_;
	MainWindowStructure* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_main_window_structure;
	_tmp1_ = _main_window_structure_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/*************************************************************************/
GeeList*
main_window_get_documents (MainWindow* self)
{
	GeeList* all_documents = NULL;
	GeeLinkedList* _tmp0_;
	gint nb_documents = 0;
	DocumentsPanel* _tmp1_;
	GeeList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	all_documents = (GeeList*) _tmp0_;
	_tmp1_ = self->priv->_documents_panel;
	nb_documents = gtk_notebook_get_n_pages ((GtkNotebook*) _tmp1_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				DocumentTab* tab = NULL;
				DocumentsPanel* _tmp4_;
				GtkWidget* _tmp5_;
				DocumentTab* _tmp6_;
				GeeList* _tmp7_;
				DocumentTab* _tmp8_;
				Document* _tmp9_;
				Document* _tmp10_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < nb_documents)) {
					break;
				}
				_tmp4_ = self->priv->_documents_panel;
				_tmp5_ = gtk_notebook_get_nth_page ((GtkNotebook*) _tmp4_, i);
				_tmp6_ = _g_object_ref0 (IS_DOCUMENT_TAB (_tmp5_) ? ((DocumentTab*) _tmp5_) : NULL);
				tab = _tmp6_;
				_tmp7_ = all_documents;
				_tmp8_ = tab;
				_tmp9_ = document_tab_get_document (_tmp8_);
				_tmp10_ = _tmp9_;
				gee_collection_add ((GeeCollection*) _tmp7_, _tmp10_);
				_g_object_unref0 (tab);
			}
		}
	}
	result = all_documents;
	return result;
}

GeeList*
main_window_get_unsaved_documents (MainWindow* self)
{
	GeeList* unsaved_documents = NULL;
	GeeLinkedList* _tmp0_;
	GeeList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	unsaved_documents = (GeeList*) _tmp0_;
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp1_;
		gint _doc_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _doc_index = 0;
		_tmp1_ = main_window_get_documents (self);
		_doc_list = _tmp1_;
		_tmp2_ = _doc_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_doc_size = _tmp4_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			Document* doc = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			Document* _tmp9_;
			_doc_index = _doc_index + 1;
			_tmp5_ = _doc_index;
			_tmp6_ = _doc_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _doc_list;
			_tmp8_ = gee_list_get (_tmp7_, _doc_index);
			doc = (Document*) _tmp8_;
			_tmp9_ = doc;
			if (gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp9_)) {
				GeeList* _tmp10_;
				Document* _tmp11_;
				_tmp10_ = unsaved_documents;
				_tmp11_ = doc;
				gee_collection_add ((GeeCollection*) _tmp10_, _tmp11_);
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	result = unsaved_documents;
	return result;
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		MainWindow* self;
		self = _data22_->self;
		_g_object_unref0 (_data22_->infobar);
		_g_object_unref0 (_data22_->tab);
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}

static void
______lambda63_ (Block22Data* _data22_,
                 gint response_id)
{
	MainWindow* self;
	TeplInfoBar* _tmp3_;
	DocumentTab* _tmp4_;
	TeplView* _tmp5_;
	TeplView* _tmp6_;
	self = _data22_->self;
	if (response_id == ((gint) GTK_RESPONSE_YES)) {
		DocumentTab* _tmp0_;
		Document* _tmp1_;
		Document* _tmp2_;
		_tmp0_ = _data22_->tab;
		_tmp1_ = document_tab_get_document (_tmp0_);
		_tmp2_ = _tmp1_;
		document_set_readonly (_tmp2_, FALSE);
	}
	_tmp3_ = _data22_->infobar;
	gtk_widget_destroy ((GtkWidget*) _tmp3_);
	_tmp4_ = _data22_->tab;
	_tmp5_ = tepl_tab_get_view ((TeplTab*) _tmp4_);
	_tmp6_ = _tmp5_;
	gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
}

static void
_______lambda63__gtk_info_bar_response (GtkInfoBar* _sender,
                                        gint response_id,
                                        gpointer self)
{
	______lambda63_ (self, response_id);
}

DocumentTab*
main_window_open_document (MainWindow* self,
                           GFile* location,
                           gboolean jump_to)
{
	GlatexApp* _tmp0_;
	GlatexApp* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	DocumentTab* _tmp42_;
	DocumentTab* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (location != NULL, NULL);
	_tmp0_ = glatex_app_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_application_get_windows ((GtkApplication*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp3_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp4_;
			GtkWindow* window = NULL;
			_tmp4_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp4_;
			{
				GtkWindow* _tmp5_;
				MainWindow* w = NULL;
				GtkWindow* _tmp6_;
				MainWindow* _tmp7_;
				_tmp5_ = window;
				if (!IS_MAIN_WINDOW (_tmp5_)) {
					_g_object_unref0 (window);
					continue;
				}
				_tmp6_ = window;
				_tmp7_ = _g_object_ref0 (IS_MAIN_WINDOW (_tmp6_) ? ((MainWindow*) _tmp6_) : NULL);
				w = _tmp7_;
				{
					GeeList* _doc_list = NULL;
					MainWindow* _tmp8_;
					GeeList* _tmp9_;
					gint _doc_size = 0;
					GeeList* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					gint _doc_index = 0;
					_tmp8_ = w;
					_tmp9_ = main_window_get_documents (_tmp8_);
					_doc_list = _tmp9_;
					_tmp10_ = _doc_list;
					_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
					_tmp12_ = _tmp11_;
					_doc_size = _tmp12_;
					_doc_index = -1;
					while (TRUE) {
						Block22Data* _data22_;
						gint _tmp13_;
						gint _tmp14_;
						Document* doc = NULL;
						GeeList* _tmp15_;
						gpointer _tmp16_;
						gboolean _tmp17_ = FALSE;
						Document* _tmp18_;
						GFile* _tmp19_;
						GFile* _tmp20_;
						MainWindow* _tmp24_;
						DocumentTab* _tmp30_;
						DocumentTab* _tmp31_;
						Document* _tmp32_;
						Document* _tmp33_;
						TeplInfoBar* _tmp34_;
						TeplInfoBar* _tmp35_;
						DocumentTab* _tmp36_;
						TeplInfoBar* _tmp37_;
						TeplInfoBar* _tmp38_;
						TeplInfoBar* _tmp39_;
						DocumentTab* _tmp40_;
						DocumentTab* _tmp41_;
						_data22_ = g_slice_new0 (Block22Data);
						_data22_->_ref_count_ = 1;
						_data22_->self = g_object_ref (self);
						_doc_index = _doc_index + 1;
						_tmp13_ = _doc_index;
						_tmp14_ = _doc_size;
						if (!(_tmp13_ < _tmp14_)) {
							block22_data_unref (_data22_);
							_data22_ = NULL;
							break;
						}
						_tmp15_ = _doc_list;
						_tmp16_ = gee_list_get (_tmp15_, _doc_index);
						doc = (Document*) _tmp16_;
						_tmp18_ = doc;
						_tmp19_ = document_get_location (_tmp18_);
						_tmp20_ = _tmp19_;
						if (_tmp20_ == NULL) {
							_tmp17_ = TRUE;
						} else {
							Document* _tmp21_;
							GFile* _tmp22_;
							GFile* _tmp23_;
							_tmp21_ = doc;
							_tmp22_ = document_get_location (_tmp21_);
							_tmp23_ = _tmp22_;
							_tmp17_ = !g_file_equal (location, _tmp23_);
						}
						if (_tmp17_) {
							_g_object_unref0 (doc);
							block22_data_unref (_data22_);
							_data22_ = NULL;
							continue;
						}
						_tmp24_ = w;
						if (self == _tmp24_) {
							Document* _tmp27_;
							DocumentTab* _tmp28_;
							DocumentTab* _tmp29_;
							if (jump_to) {
								Document* _tmp25_;
								DocumentTab* _tmp26_;
								_tmp25_ = doc;
								_tmp26_ = _tmp25_->tab;
								main_window_set_active_tab (self, _tmp26_);
							}
							_tmp27_ = doc;
							_tmp28_ = _tmp27_->tab;
							_tmp29_ = _g_object_ref0 (_tmp28_);
							result = _tmp29_;
							_g_object_unref0 (doc);
							block22_data_unref (_data22_);
							_data22_ = NULL;
							_g_object_unref0 (_doc_list);
							_g_object_unref0 (w);
							_g_object_unref0 (window);
							return result;
						}
						_tmp30_ = main_window_create_tab_from_location (self, location, jump_to);
						_data22_->tab = _tmp30_;
						_tmp31_ = _data22_->tab;
						_tmp32_ = document_tab_get_document (_tmp31_);
						_tmp33_ = _tmp32_;
						document_set_readonly (_tmp33_, TRUE);
						_tmp34_ = tepl_io_error_info_bar_file_already_open (location);
						_tmp35_ = _g_object_ref0 (_tmp34_);
						_data22_->infobar = _tmp35_;
						_tmp36_ = _data22_->tab;
						_tmp37_ = _data22_->infobar;
						tepl_tab_add_info_bar ((TeplTab*) _tmp36_, (GtkInfoBar*) _tmp37_);
						_tmp38_ = _data22_->infobar;
						gtk_widget_show ((GtkWidget*) _tmp38_);
						_tmp39_ = _data22_->infobar;
						g_signal_connect_data ((GtkInfoBar*) _tmp39_, "response", (GCallback) _______lambda63__gtk_info_bar_response, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
						_tmp40_ = _data22_->tab;
						_tmp41_ = _g_object_ref0 (_tmp40_);
						result = _tmp41_;
						_g_object_unref0 (doc);
						block22_data_unref (_data22_);
						_data22_ = NULL;
						_g_object_unref0 (_doc_list);
						_g_object_unref0 (w);
						_g_object_unref0 (window);
						return result;
					}
					_g_object_unref0 (_doc_list);
				}
				_g_object_unref0 (w);
				_g_object_unref0 (window);
			}
		}
	}
	_tmp42_ = main_window_create_tab_from_location (self, location, jump_to);
	result = _tmp42_;
	return result;
}

DocumentTab*
main_window_create_tab (MainWindow* self,
                        gboolean jump_to)
{
	DocumentTab* tab = NULL;
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = document_tab_new ();
	g_object_ref_sink (_tmp0_);
	tab = _tmp0_;
	_tmp1_ = main_window_process_create_tab (self, tab, jump_to);
	result = _tmp1_;
	_g_object_unref0 (tab);
	return result;
}

static DocumentTab*
main_window_create_tab_from_location (MainWindow* self,
                                      GFile* location,
                                      gboolean jump_to)
{
	DocumentTab* tab = NULL;
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (location != NULL, NULL);
	_tmp0_ = document_tab_new_from_location (location);
	g_object_ref_sink (_tmp0_);
	tab = _tmp0_;
	_tmp1_ = main_window_process_create_tab (self, tab, jump_to);
	result = _tmp1_;
	_g_object_unref0 (tab);
	return result;
}

void
main_window_create_tab_with_view (MainWindow* self,
                                  DocumentView* view)
{
	DocumentTab* tab = NULL;
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_tmp0_ = document_tab_new_with_view (view);
	g_object_ref_sink (_tmp0_);
	tab = _tmp0_;
	_tmp1_ = main_window_process_create_tab (self, tab, TRUE);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (tab);
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		MainWindow* self;
		self = _data23_->self;
		_g_object_unref0 (_data23_->tab);
		_g_object_unref0 (self);
		g_slice_free (Block23Data, _data23_);
	}
}

static void
__lambda37_ (Block23Data* _data23_)
{
	MainWindow* self;
	self = _data23_->self;
	main_window_close_tab (self, _data23_->tab, FALSE);
	g_signal_stop_emission_by_name (_data23_->tab, "close-request");
}

static void
___lambda37__tepl_tab_close_request (TeplTab* _sender,
                                     gpointer self)
{
	__lambda37_ (self);
}

static void
__lambda40_ (Block23Data* _data23_)
{
	MainWindow* self;
	MainWindowBuildTools* _tmp0_;
	self = _data23_->self;
	main_window_sync_name (self, _data23_->tab);
	_tmp0_ = self->priv->_main_window_build_tools;
	main_window_build_tools_update_sensitivity (_tmp0_);
}

static void
___lambda40__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda40_ (self);
}

static void
__lambda55_ (Block23Data* _data23_)
{
	MainWindow* self;
	self = _data23_->self;
	main_window_sync_name (self, _data23_->tab);
}

static void
___lambda55__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda55_ (self);
}

static void
__lambda56_ (MainWindow* self)
{
	MainWindowBuildTools* _tmp0_;
	_tmp0_ = self->priv->_main_window_build_tools;
	main_window_build_tools_update_sensitivity (_tmp0_);
}

static void
___lambda56__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda56_ ((MainWindow*) self);
}

static void
__lambda57_ (Block23Data* _data23_)
{
	MainWindow* self;
	self = _data23_->self;
	main_window_sync_name (self, _data23_->tab);
}

static void
___lambda57__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender,
                                               gpointer self)
{
	__lambda57_ (self);
}

static void
__lambda58_ (Block23Data* _data23_)
{
	MainWindow* self;
	self = _data23_->self;
	main_window_sync_name (self, _data23_->tab);
}

static void
___lambda58__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda58_ (self);
}

static DocumentTab*
main_window_process_create_tab (MainWindow* self,
                                DocumentTab* tab,
                                gboolean jump_to)
{
	Block23Data* _data23_;
	DocumentTab* _tmp0_;
	Document* doc = NULL;
	Document* _tmp1_;
	Document* _tmp2_;
	Document* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	Document* _tmp8_;
	DocumentsPanel* _tmp9_;
	MainWindowEdit* _tmp10_;
	MainWindowTools* _tmp11_;
	DocumentTab* _tmp12_;
	DocumentTab* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data23_ = g_slice_new0 (Block23Data);
	_data23_->_ref_count_ = 1;
	_data23_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (tab);
	_g_object_unref0 (_data23_->tab);
	_data23_->tab = _tmp0_;
	if (_data23_->tab == NULL) {
		result = NULL;
		block23_data_unref (_data23_);
		_data23_ = NULL;
		return result;
	}
	g_signal_connect_data ((TeplTab*) _data23_->tab, "close-request", (GCallback) ___lambda37__tepl_tab_close_request, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
	_tmp1_ = document_tab_get_document (_data23_->tab);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	doc = _tmp3_;
	_tmp4_ = doc;
	g_signal_connect_data ((GObject*) _tmp4_, "notify::location", (GCallback) ___lambda40__g_object_notify, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
	_tmp5_ = doc;
	g_signal_connect_data ((GObject*) _tmp5_, "notify::tepl-short-title", (GCallback) ___lambda55__g_object_notify, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
	_tmp6_ = doc;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::project-id", (GCallback) ___lambda56__g_object_notify, self, 0);
	_tmp7_ = doc;
	g_signal_connect_data ((GtkTextBuffer*) _tmp7_, "modified-changed", (GCallback) ___lambda57__gtk_text_buffer_modified_changed, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
	_tmp8_ = doc;
	g_signal_connect_data ((GObject*) _tmp8_, "notify::readonly", (GCallback) ___lambda58__g_object_notify, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data23_->tab);
	_tmp9_ = self->priv->_documents_panel;
	documents_panel_add_tab (_tmp9_, _data23_->tab, -1, jump_to);
	_tmp10_ = self->priv->_main_window_edit;
	main_window_edit_update_sensitivity (_tmp10_);
	_tmp11_ = self->priv->_main_window_tools;
	main_window_tools_update_sensitivity (_tmp11_);
	if (!gtk_widget_get_visible ((GtkWidget*) self)) {
		gtk_window_present ((GtkWindow*) self);
	}
	_tmp12_ = _g_object_ref0 (_data23_->tab);
	result = _tmp12_;
	_g_object_unref0 (doc);
	block23_data_unref (_data23_);
	_data23_ = NULL;
	return result;
}

gboolean
main_window_close_tab (MainWindow* self,
                       DocumentTab* tab,
                       gboolean force_close)
{
	gboolean _tmp0_ = FALSE;
	DocumentsPanel* _tmp20_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tab != NULL, FALSE);
	if (!force_close) {
		TeplBuffer* _tmp1_;
		_tmp1_ = tepl_tab_get_buffer ((TeplTab*) tab);
		_tmp0_ = gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp1_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkDialog* dialog = NULL;
		TeplBuffer* _tmp2_;
		TeplFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GtkMessageDialog* _tmp6_;
		GtkDialog* _tmp7_;
		GtkDialog* _tmp8_;
		Document* _tmp9_;
		Document* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		GtkDialog* _tmp19_;
		_tmp2_ = tepl_tab_get_buffer ((TeplTab*) tab);
		_tmp3_ = tepl_buffer_get_file (_tmp2_);
		_tmp4_ = tepl_file_get_short_name (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _ ("Save changes to document “%s” before closing?"), _tmp5_);
		g_object_ref_sink (_tmp6_);
		_tmp7_ = (GtkDialog*) _tmp6_;
		_g_free0 (_tmp5_);
		dialog = _tmp7_;
		_tmp8_ = dialog;
		gtk_dialog_add_buttons (_tmp8_, _ ("Close _without Saving"), GTK_RESPONSE_CLOSE, _ ("_Cancel"), GTK_RESPONSE_CANCEL, NULL);
		_tmp9_ = document_tab_get_document (tab);
		_tmp10_ = _tmp9_;
		_tmp11_ = document_get_location (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == NULL) {
			GtkDialog* _tmp13_;
			_tmp13_ = dialog;
			gtk_dialog_add_button (_tmp13_, _ ("Save _As"), (gint) GTK_RESPONSE_ACCEPT);
		} else {
			GtkDialog* _tmp14_;
			_tmp14_ = dialog;
			gtk_dialog_add_button (_tmp14_, _ ("_Save"), (gint) GTK_RESPONSE_ACCEPT);
		}
		while (TRUE) {
			gint res = 0;
			GtkDialog* _tmp15_;
			_tmp15_ = dialog;
			res = gtk_dialog_run (_tmp15_);
			if (res == ((gint) GTK_RESPONSE_CLOSE)) {
				break;
			} else {
				if (res == ((gint) GTK_RESPONSE_ACCEPT)) {
					Document* _tmp16_;
					Document* _tmp17_;
					_tmp16_ = document_tab_get_document (tab);
					_tmp17_ = _tmp16_;
					if (main_window_save_document (self, _tmp17_, FALSE)) {
						break;
					}
					continue;
				} else {
					GtkDialog* _tmp18_;
					_tmp18_ = dialog;
					gtk_widget_destroy ((GtkWidget*) _tmp18_);
					result = FALSE;
					_g_object_unref0 (dialog);
					return result;
				}
			}
		}
		_tmp19_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp19_);
		_g_object_unref0 (dialog);
	}
	_tmp20_ = self->priv->_documents_panel;
	documents_panel_remove_tab (_tmp20_, tab);
	result = TRUE;
	return result;
}

static void
main_window_sync_name (MainWindow* self,
                       DocumentTab* tab)
{
	MainWindowDocuments* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	_tmp0_ = self->priv->_main_window_documents;
	main_window_documents_update_document_name (_tmp0_, tab);
}

gboolean
main_window_save_document (MainWindow* self,
                           Document* doc,
                           gboolean force_save_as)
{
	gboolean _tmp0_ = FALSE;
	GtkFileChooserDialog* file_chooser = NULL;
	GtkFileChooserDialog* _tmp6_;
	GtkFileChooserDialog* _tmp7_;
	GtkFileChooserDialog* _tmp8_;
	gchar* short_name = NULL;
	TeplFile* _tmp9_;
	gchar* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	const gchar* _tmp19_;
	GFile* _tmp22_;
	GFile* _tmp23_;
	gint response = 0;
	GtkFileChooserDialog* _tmp28_;
	GtkFileChooserDialog* _tmp32_;
	gchar* _tmp33_;
	GtkFileChooserDialog* _tmp34_;
	GFile* _tmp35_;
	GFile* _tmp36_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (doc != NULL, FALSE);
	if (!force_save_as) {
		GFile* _tmp1_;
		GFile* _tmp2_;
		_tmp1_ = document_get_location (doc);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Document* _tmp3_;
		Document* _tmp4_;
		document_save (doc, TRUE, FALSE);
		_tmp3_ = main_window_get_active_document (self);
		_tmp4_ = _tmp3_;
		if (doc == _tmp4_) {
			MainWindowStructure* _tmp5_;
			_tmp5_ = self->priv->_main_window_structure;
			main_window_structure_refresh (_tmp5_);
		}
		result = TRUE;
		return result;
	}
	_tmp6_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Save File"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Save"), GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp6_);
	file_chooser = _tmp6_;
	_tmp7_ = file_chooser;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp7_, TRUE);
	_tmp8_ = file_chooser;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp8_, FALSE);
	_tmp9_ = tepl_buffer_get_file ((TeplBuffer*) doc);
	_tmp10_ = tepl_file_get_short_name (_tmp9_);
	short_name = _tmp10_;
	_tmp11_ = document_get_location (doc);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == NULL) {
		GtkFileChooserDialog* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp13_ = file_chooser;
		_tmp14_ = short_name;
		_tmp15_ = g_strconcat (_tmp14_, ".tex", NULL);
		_tmp16_ = _tmp15_;
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp13_, _tmp16_);
		_g_free0 (_tmp16_);
	} else {
		GtkFileChooserDialog* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = file_chooser;
		_tmp18_ = short_name;
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp17_, _tmp18_);
	}
	_tmp19_ = self->default_location;
	if (_tmp19_ != NULL) {
		GtkFileChooserDialog* _tmp20_;
		const gchar* _tmp21_;
		_tmp20_ = file_chooser;
		_tmp21_ = self->default_location;
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp20_, _tmp21_);
	}
	_tmp22_ = document_get_location (doc);
	_tmp23_ = _tmp22_;
	if (_tmp23_ != NULL) {
		{
			GtkFileChooserDialog* _tmp24_;
			GFile* _tmp25_;
			GFile* _tmp26_;
			_tmp24_ = file_chooser;
			_tmp25_ = document_get_location (doc);
			_tmp26_ = _tmp25_;
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp24_, _tmp26_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp27_ = FALSE;
			_g_free0 (short_name);
			_g_object_unref0 (file_chooser);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp27_;
		}
	}
	_tmp28_ = file_chooser;
	response = gtk_dialog_run ((GtkDialog*) _tmp28_);
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserDialog* _tmp29_;
		GFile* _tmp30_;
		GFile* _tmp31_;
		_tmp29_ = file_chooser;
		_tmp30_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp29_);
		_tmp31_ = _tmp30_;
		document_set_location (doc, _tmp31_);
		_g_object_unref0 (_tmp31_);
	}
	_tmp32_ = file_chooser;
	_tmp33_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp32_);
	_g_free0 (self->default_location);
	self->default_location = _tmp33_;
	_tmp34_ = file_chooser;
	gtk_widget_destroy ((GtkWidget*) _tmp34_);
	_tmp35_ = document_get_location (doc);
	_tmp36_ = _tmp35_;
	if (_tmp36_ != NULL) {
		Document* _tmp37_;
		Document* _tmp38_;
		document_save (doc, FALSE, TRUE);
		_tmp37_ = main_window_get_active_document (self);
		_tmp38_ = _tmp37_;
		if (doc == _tmp38_) {
			MainWindowStructure* _tmp39_;
			_tmp39_ = self->priv->_main_window_structure;
			main_window_structure_refresh (_tmp39_);
		}
		result = TRUE;
		_g_free0 (short_name);
		_g_object_unref0 (file_chooser);
		return result;
	}
	result = FALSE;
	_g_free0 (short_name);
	_g_object_unref0 (file_chooser);
	return result;
}

gboolean
main_window_close_all_documents (MainWindow* self)
{
	GeeList* unsaved_documents = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = main_window_get_unsaved_documents (self);
	unsaved_documents = _tmp0_;
	_tmp1_ = unsaved_documents;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		DocumentsPanel* _tmp4_;
		_tmp4_ = self->priv->_documents_panel;
		documents_panel_remove_all_tabs (_tmp4_);
		result = TRUE;
		_g_object_unref0 (unsaved_documents);
		return result;
	} else {
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = unsaved_documents;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == 1) {
			Document* doc = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			Document* _tmp10_;
			DocumentTab* _tmp11_;
			Document* _tmp12_;
			DocumentTab* _tmp13_;
			_tmp8_ = unsaved_documents;
			_tmp9_ = gee_list_first (_tmp8_);
			doc = (Document*) _tmp9_;
			_tmp10_ = doc;
			_tmp11_ = _tmp10_->tab;
			main_window_set_active_tab (self, _tmp11_);
			_tmp12_ = doc;
			_tmp13_ = _tmp12_->tab;
			if (main_window_close_tab (self, _tmp13_, FALSE)) {
				DocumentsPanel* _tmp14_;
				_tmp14_ = self->priv->_documents_panel;
				documents_panel_remove_all_tabs (_tmp14_);
				result = TRUE;
				_g_object_unref0 (doc);
				_g_object_unref0 (unsaved_documents);
				return result;
			}
			_g_object_unref0 (doc);
		} else {
			GeeList* _tmp15_;
			DocumentsPanel* _tmp16_;
			_tmp15_ = unsaved_documents;
			dialogs_close_several_unsaved_documents (self, _tmp15_);
			_tmp16_ = self->priv->_documents_panel;
			if (gtk_notebook_get_n_pages ((GtkNotebook*) _tmp16_) == 0) {
				result = TRUE;
				_g_object_unref0 (unsaved_documents);
				return result;
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (unsaved_documents);
	return result;
}

void
main_window_remove_all_tabs (MainWindow* self)
{
	DocumentsPanel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_documents_panel;
	documents_panel_remove_all_tabs (_tmp0_);
}

void
main_window_save_state (MainWindow* self)
{
	GSettings* settings_window = NULL;
	GSettings* _tmp0_;
	GdkWindowState state = 0U;
	GdkWindow* _tmp1_;
	gint width = 0;
	gint height = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GtkPaned* _tmp4_;
	GtkPaned* _tmp5_;
	MainWindowStructure* _tmp6_;
	GSettings* settings_ui = NULL;
	GSettings* _tmp7_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp8_;
	GtkAction* _tmp9_;
	GtkToggleAction* _tmp10_;
	GtkToggleAction* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GtkActionGroup* _tmp14_;
	GtkAction* _tmp15_;
	GtkToggleAction* _tmp16_;
	GtkToggleAction* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	GtkActionGroup* _tmp20_;
	GtkAction* _tmp21_;
	GtkToggleAction* _tmp22_;
	GtkToggleAction* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	GtkActionGroup* _tmp26_;
	GtkAction* _tmp27_;
	GtkToggleAction* _tmp28_;
	GtkToggleAction* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	MainWindowBuildTools* _tmp32_;
	TeplPanel* _tmp33_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.state.window");
	settings_window = _tmp0_;
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
	state = gdk_window_get_state (_tmp1_);
	g_settings_set_int (settings_window, "state", (gint) state);
	gtk_window_get_size ((GtkWindow*) self, &_tmp2_, &_tmp3_);
	width = _tmp2_;
	height = _tmp3_;
	g_settings_set (settings_window, "size", "(ii)", width, height);
	_tmp4_ = self->priv->_main_hpaned;
	g_settings_set_int (settings_window, "side-panel-size", gtk_paned_get_position (_tmp4_));
	_tmp5_ = self->priv->_vpaned;
	g_settings_set_int (settings_window, "vertical-paned-position", gtk_paned_get_position (_tmp5_));
	_tmp6_ = self->priv->_main_window_structure;
	main_window_structure_save_state (_tmp6_);
	_tmp7_ = g_settings_new ("org.gnome.gnome-latex.preferences.ui");
	settings_ui = _tmp7_;
	_tmp8_ = self->priv->_action_group;
	_tmp9_ = gtk_action_group_get_action (_tmp8_, "ViewMainToolbar");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_toggle_action_get_type (), GtkToggleAction));
	action = _tmp10_;
	_tmp11_ = action;
	_tmp12_ = gtk_toggle_action_get_active (_tmp11_);
	_tmp13_ = _tmp12_;
	g_settings_set_boolean (settings_ui, "main-toolbar-visible", _tmp13_);
	_tmp14_ = self->priv->_action_group;
	_tmp15_ = gtk_action_group_get_action (_tmp14_, "ViewEditToolbar");
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_toggle_action_get_type (), GtkToggleAction));
	_g_object_unref0 (action);
	action = _tmp16_;
	_tmp17_ = action;
	_tmp18_ = gtk_toggle_action_get_active (_tmp17_);
	_tmp19_ = _tmp18_;
	g_settings_set_boolean (settings_ui, "edit-toolbar-visible", _tmp19_);
	_tmp20_ = self->priv->_action_group;
	_tmp21_ = gtk_action_group_get_action (_tmp20_, "ViewSidePanel");
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_toggle_action_get_type (), GtkToggleAction));
	_g_object_unref0 (action);
	action = _tmp22_;
	_tmp23_ = action;
	_tmp24_ = gtk_toggle_action_get_active (_tmp23_);
	_tmp25_ = _tmp24_;
	g_settings_set_boolean (settings_ui, "side-panel-visible", _tmp25_);
	_tmp26_ = self->priv->_action_group;
	_tmp27_ = gtk_action_group_get_action (_tmp26_, "ViewBottomPanel");
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_toggle_action_get_type (), GtkToggleAction));
	_g_object_unref0 (action);
	action = _tmp28_;
	_tmp29_ = action;
	_tmp30_ = gtk_toggle_action_get_active (_tmp29_);
	_tmp31_ = _tmp30_;
	g_settings_set_boolean (settings_ui, "bottom-panel-visible", _tmp31_);
	_tmp32_ = self->priv->_main_window_build_tools;
	main_window_build_tools_save_state (_tmp32_);
	_tmp33_ = self->priv->_side_panel;
	tepl_panel_save_state_to_gsettings (_tmp33_);
	_g_object_unref0 (action);
	_g_object_unref0 (settings_ui);
	_g_object_unref0 (settings_window);
}

void
main_window_jump_to_file_position (MainWindow* self,
                                   GFile* file,
                                   gint start_line,
                                   gint end_line)
{
	gboolean _tmp0_ = FALSE;
	DocumentTab* tab = NULL;
	DocumentTab* _tmp1_;
	TeplView* _tmp2_;
	TeplView* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	if (start_line >= 0) {
		_tmp0_ = end_line >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_if_fail (_tmp0_);
	_tmp1_ = main_window_open_document (self, file, TRUE);
	tab = _tmp1_;
	utils_flush_queue ();
	_tmp2_ = tepl_tab_get_view ((TeplTab*) tab);
	_tmp3_ = _tmp2_;
	tepl_view_select_lines (_tmp3_, start_line, end_line);
	_g_object_unref0 (tab);
}

/*************************************************************************/
static void
main_window_update_file_actions_sensitivity (MainWindow* self)
{
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	gboolean sensitive = FALSE;
	TeplApplicationWindow* _tmp2_;
	TeplTab* _tmp3_;
	TeplTab* _tmp4_;
	gchar** file_actions = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gint file_actions_length1;
	gint _file_actions_size_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	MainWindowFile* _tmp22_;
	MainWindowEdit* _tmp23_;
	MainWindowBuildTools* _tmp24_;
	MainWindowTools* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	tepl_window = _tmp1_;
	_tmp2_ = tepl_window;
	_tmp3_ = tepl_tab_group_get_active_tab ((TeplTabGroup*) _tmp2_);
	_tmp4_ = _tmp3_;
	sensitive = _tmp4_ != NULL;
	_tmp5_ = g_strdup ("ViewZoomIn");
	_tmp6_ = g_strdup ("ViewZoomOut");
	_tmp7_ = g_strdup ("ViewZoomReset");
	_tmp8_ = g_strdup ("SearchFind");
	_tmp9_ = g_strdup ("SearchReplace");
	_tmp10_ = g_strdup ("SearchForward");
	_tmp11_ = g_strdup ("ProjectsConfigCurrent");
	_tmp12_ = g_strdup ("Latex");
	_tmp13_ = g_strdup ("Math");
	_tmp14_ = g_new0 (gchar*, 9 + 1);
	_tmp14_[0] = _tmp5_;
	_tmp14_[1] = _tmp6_;
	_tmp14_[2] = _tmp7_;
	_tmp14_[3] = _tmp8_;
	_tmp14_[4] = _tmp9_;
	_tmp14_[5] = _tmp10_;
	_tmp14_[6] = _tmp11_;
	_tmp14_[7] = _tmp12_;
	_tmp14_[8] = _tmp13_;
	file_actions = _tmp14_;
	file_actions_length1 = 9;
	_file_actions_size_ = file_actions_length1;
	_tmp15_ = file_actions;
	_tmp15__length1 = file_actions_length1;
	{
		gchar** file_action_collection = NULL;
		gint file_action_collection_length1 = 0;
		gint _file_action_collection_size_ = 0;
		gint file_action_it = 0;
		file_action_collection = _tmp15_;
		file_action_collection_length1 = _tmp15__length1;
		for (file_action_it = 0; file_action_it < file_action_collection_length1; file_action_it = file_action_it + 1) {
			gchar* _tmp16_;
			gchar* file_action = NULL;
			_tmp16_ = g_strdup (file_action_collection[file_action_it]);
			file_action = _tmp16_;
			{
				GtkAction* action = NULL;
				GtkActionGroup* _tmp17_;
				const gchar* _tmp18_;
				GtkAction* _tmp19_;
				GtkAction* _tmp20_;
				GtkAction* _tmp21_;
				_tmp17_ = self->priv->_action_group;
				_tmp18_ = file_action;
				_tmp19_ = gtk_action_group_get_action (_tmp17_, _tmp18_);
				_tmp20_ = _g_object_ref0 (_tmp19_);
				action = _tmp20_;
				_tmp21_ = action;
				gtk_action_set_sensitive (_tmp21_, sensitive);
				_g_object_unref0 (action);
				_g_free0 (file_action);
			}
		}
	}
	_tmp22_ = self->priv->_main_window_file;
	main_window_file_update_sensitivity (_tmp22_);
	_tmp23_ = self->priv->_main_window_edit;
	main_window_edit_update_sensitivity (_tmp23_);
	_tmp24_ = self->priv->_main_window_build_tools;
	main_window_build_tools_update_sensitivity (_tmp24_);
	_tmp25_ = self->priv->_main_window_tools;
	main_window_tools_update_sensitivity (_tmp25_);
	file_actions = (_vala_array_free (file_actions, file_actions_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (tepl_window);
}

void
main_window_update_config_project_sensitivity (MainWindow* self)
{
	GtkAction* action = NULL;
	GtkActionGroup* _tmp0_;
	GtkAction* _tmp1_;
	GtkAction* _tmp2_;
	gboolean _tmp3_ = FALSE;
	DocumentTab* _tmp4_;
	DocumentTab* _tmp5_;
	GtkAction* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_action_group;
	_tmp1_ = gtk_action_group_get_action (_tmp0_, "ProjectsConfigCurrent");
	_tmp2_ = _g_object_ref0 (_tmp1_);
	action = _tmp2_;
	_tmp4_ = main_window_get_active_tab (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		Document* _tmp6_;
		Document* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp6_ = main_window_get_active_document (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = document_get_project_id (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = _tmp9_ != -1;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp10_ = action;
	gtk_action_set_sensitive (_tmp10_, _tmp3_);
	_g_object_unref0 (action);
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gboolean
main_window_quit (MainWindow* self)
{
	gchar** list_uris = NULL;
	gchar** _tmp0_;
	gint list_uris_length1;
	gint _list_uris_size_;
	GSettings* settings = NULL;
	GSettings* _tmp16_;
	GSettings* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	list_uris = _tmp0_;
	list_uris_length1 = 0;
	_list_uris_size_ = list_uris_length1;
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp1_;
		gint _doc_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _doc_index = 0;
		_tmp1_ = main_window_get_documents (self);
		_doc_list = _tmp1_;
		_tmp2_ = _doc_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_doc_size = _tmp4_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			Document* doc = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			Document* _tmp9_;
			GFile* _tmp10_;
			GFile* _tmp11_;
			_doc_index = _doc_index + 1;
			_tmp5_ = _doc_index;
			_tmp6_ = _doc_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _doc_list;
			_tmp8_ = gee_list_get (_tmp7_, _doc_index);
			doc = (Document*) _tmp8_;
			_tmp9_ = doc;
			_tmp10_ = document_get_location (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				Document* _tmp12_;
				GFile* _tmp13_;
				GFile* _tmp14_;
				gchar* _tmp15_;
				_tmp12_ = doc;
				_tmp13_ = document_get_location (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_file_get_uri (_tmp14_);
				_vala_array_add6 (&list_uris, &list_uris_length1, &_list_uris_size_, _tmp15_);
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	_tmp16_ = g_settings_new ("org.gnome.gnome-latex.state.window");
	settings = _tmp16_;
	_tmp17_ = settings;
	_tmp18_ = list_uris;
	_tmp18__length1 = list_uris_length1;
	g_settings_set_strv (_tmp17_, "documents", _tmp18_);
	if (main_window_close_all_documents (self)) {
		main_window_save_state (self);
		gtk_widget_destroy ((GtkWidget*) self);
		result = TRUE;
		_g_object_unref0 (settings);
		list_uris = (_vala_array_free (list_uris, list_uris_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (settings);
	list_uris = (_vala_array_free (list_uris, list_uris_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

/*************************************************************************/
void
main_window_on_view_zoom_in (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentView* _tmp2_;
	DocumentView* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = main_window_get_active_view (self);
	_tmp3_ = _tmp2_;
	document_view_enlarge_font (_tmp3_);
}

void
main_window_on_view_zoom_out (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentView* _tmp2_;
	DocumentView* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = main_window_get_active_view (self);
	_tmp3_ = _tmp2_;
	document_view_shrink_font (_tmp3_);
}

void
main_window_on_view_zoom_reset (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentView* _tmp2_;
	DocumentView* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = main_window_get_active_view (self);
	_tmp3_ = _tmp2_;
	document_view_set_font_from_settings (_tmp3_);
}

void
main_window_on_search_find (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	SearchAndReplace* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = self->priv->_search_and_replace;
	search_and_replace_show_search (_tmp2_);
}

void
main_window_on_search_replace (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	SearchAndReplace* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = self->priv->_search_and_replace;
	search_and_replace_show_search_and_replace (_tmp2_);
}

void
main_window_on_search_forward (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	LatexilaSynctex* synctex = NULL;
	LatexilaSynctex* _tmp2_;
	LatexilaSynctex* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	Document* _tmp10_;
	Document* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = latexila_synctex_get_instance ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	synctex = _tmp3_;
	_tmp4_ = main_window_get_active_document (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = main_window_get_active_document (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = document_get_location (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = main_window_get_active_document (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = document_get_main_file (_tmp11_);
	_tmp13_ = _tmp12_;
	latexila_synctex_forward_search (synctex, (GtkTextBuffer*) _tmp5_, _tmp9_, _tmp13_, (guint) GDK_CURRENT_TIME);
	_g_object_unref0 (_tmp13_);
	_g_object_unref0 (synctex);
}

void
main_window_on_projects_new (MainWindow* self)
{
	g_return_if_fail (self != NULL);
	project_dialogs_new_project (self);
}

void
main_window_on_projects_config_current (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	Document* _tmp2_;
	Document* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_window_get_active_tab (self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = main_window_get_active_document (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = document_get_project_id (_tmp3_);
	_tmp5_ = _tmp4_;
	g_return_if_fail (_tmp5_ != -1);
	_tmp6_ = main_window_get_active_document (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = document_get_project_id (_tmp7_);
	_tmp9_ = _tmp8_;
	project_dialogs_configure_project ((GtkWindow*) self, _tmp9_);
}

void
main_window_on_projects_manage (MainWindow* self)
{
	g_return_if_fail (self != NULL);
	project_dialogs_manage_projects (self);
}

void
main_window_on_help_latex_reference (MainWindow* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* uri = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp0_ = latexila_dirs_get_app_data_dir ();
		_tmp1_ = g_build_filename (_tmp0_, "latexhelp.html", NULL, NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_filename_to_uri (_tmp2_, NULL, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		uri = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = uri;
		latexila_utils_show_uri ((GtkWidget*) self, _tmp5_, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (uri);
			goto __catch0_g_error;
		}
		_g_free0 (uri);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("main_window.vala:1069: Impossible to open the LaTeX reference: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

DocumentTab*
main_window_get_active_tab (MainWindow* self)
{
	DocumentTab* result;
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	TeplTab* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	tepl_window = _tmp1_;
	_tmp2_ = tepl_tab_group_get_active_tab ((TeplTabGroup*) tepl_window);
	result = IS_DOCUMENT_TAB (_tmp2_) ? ((DocumentTab*) _tmp2_) : NULL;
	_g_object_unref0 (tepl_window);
	return result;
}

void
main_window_set_active_tab (MainWindow* self,
                            DocumentTab* value)
{
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	tepl_window = _tmp1_;
	tepl_tab_group_set_active_tab ((TeplTabGroup*) tepl_window, (TeplTab*) value);
	_g_object_unref0 (tepl_window);
	g_object_notify_by_pspec ((GObject *) self, main_window_properties[MAIN_WINDOW_ACTIVE_TAB_PROPERTY]);
}

DocumentView*
main_window_get_active_view (MainWindow* self)
{
	DocumentView* result;
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	TeplView* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	tepl_window = _tmp1_;
	_tmp2_ = tepl_tab_group_get_active_view ((TeplTabGroup*) tepl_window);
	result = IS_DOCUMENT_VIEW (_tmp2_) ? ((DocumentView*) _tmp2_) : NULL;
	_g_object_unref0 (tepl_window);
	return result;
}

Document*
main_window_get_active_document (MainWindow* self)
{
	Document* result;
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	TeplBuffer* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	tepl_window = _tmp1_;
	_tmp2_ = tepl_tab_group_get_active_buffer ((TeplTabGroup*) tepl_window);
	result = IS_DOCUMENT (_tmp2_) ? ((Document*) _tmp2_) : NULL;
	_g_object_unref0 (tepl_window);
	return result;
}

static void
main_window_class_init (MainWindowClass * klass,
                        gpointer klass_data)
{
	main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MainWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_main_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_main_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = main_window_finalize;
	/*************************************************************************/
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_TAB_PROPERTY, main_window_properties[MAIN_WINDOW_ACTIVE_TAB_PROPERTY] = g_param_spec_object ("active-tab", "active-tab", "active-tab", TYPE_DOCUMENT_TAB, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_VIEW_PROPERTY, main_window_properties[MAIN_WINDOW_ACTIVE_VIEW_PROPERTY] = g_param_spec_object ("active-view", "active-view", "active-view", TYPE_DOCUMENT_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_DOCUMENT_PROPERTY, main_window_properties[MAIN_WINDOW_ACTIVE_DOCUMENT_PROPERTY] = g_param_spec_object ("active-document", "active-document", "active-document", TYPE_DOCUMENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
main_window_instance_init (MainWindow * self,
                           gpointer klass)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = main_window_get_instance_private (self);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	self->default_location = _tmp1_;
}

static void
main_window_finalize (GObject * obj)
{
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW, MainWindow);
	_g_free0 (self->default_location);
	_g_object_unref0 (self->priv->_documents_panel);
	_g_object_unref0 (self->priv->_statusbar);
	_g_object_unref0 (self->priv->_search_and_replace);
	_g_object_unref0 (self->priv->_side_panel);
	_g_object_unref0 (self->priv->_main_hpaned);
	_g_object_unref0 (self->priv->_vpaned);
	_g_object_unref0 (self->priv->_ui_manager);
	_g_object_unref0 (self->priv->_action_group);
	_main_window_file_unref0 (self->priv->_main_window_file);
	_main_window_edit_unref0 (self->priv->_main_window_edit);
	_main_window_build_tools_unref0 (self->priv->_main_window_build_tools);
	_main_window_structure_unref0 (self->priv->_main_window_structure);
	_main_window_documents_unref0 (self->priv->_main_window_documents);
	_main_window_tools_unref0 (self->priv->_main_window_tools);
	G_OBJECT_CLASS (main_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindow), 0, (GInstanceInitFunc) main_window_instance_init, NULL };
	GType main_window_type_id;
	main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "MainWindow", &g_define_type_info, 0);
	MainWindow_private_offset = g_type_add_instance_private (main_window_type_id, sizeof (MainWindowPrivate));
	return main_window_type_id;
}

GType
main_window_get_type (void)
{
	static gsize main_window_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_type_id__volatile)) {
		GType main_window_type_id;
		main_window_type_id = main_window_get_type_once ();
		g_once_init_leave (&main_window_type_id__volatile, main_window_type_id);
	}
	return main_window_type_id__volatile;
}

static void
_vala_main_window_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAIN_WINDOW, MainWindow);
	switch (property_id) {
		case MAIN_WINDOW_ACTIVE_TAB_PROPERTY:
		g_value_set_object (value, main_window_get_active_tab (self));
		break;
		case MAIN_WINDOW_ACTIVE_VIEW_PROPERTY:
		g_value_set_object (value, main_window_get_active_view (self));
		break;
		case MAIN_WINDOW_ACTIVE_DOCUMENT_PROPERTY:
		g_value_set_object (value, main_window_get_active_document (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_main_window_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAIN_WINDOW, MainWindow);
	switch (property_id) {
		case MAIN_WINDOW_ACTIVE_TAB_PROPERTY:
		main_window_set_active_tab (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

