/* document_structure.c generated by valac 0.54.6, the Vala compiler
 * generated from document_structure.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2011-2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <tepl/tepl.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtksourceview/gtksource.h>
#include <gdk/gdk.h>

#define DOCUMENT_STRUCTURE_MARK_NAME_PREFIX "struct_item_"
#define DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH 60
#define DOCUMENT_STRUCTURE_MAX_NB_LINES_TO_PARSE 2000
#define DOCUMENT_STRUCTURE__measure_parsing_time FALSE
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;
typedef struct _DocumentStructurePrivate DocumentStructurePrivate;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_STRUCTURE_MODEL (structure_model_get_type ())
#define STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE_MODEL, StructureModel))
#define STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE_MODEL, StructureModelClass))
#define IS_STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE_MODEL))
#define IS_STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE_MODEL))
#define STRUCTURE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE_MODEL, StructureModelClass))

typedef struct _StructureModel StructureModel;
typedef struct _StructureModelClass StructureModelClass;

#define DOCUMENT_STRUCTURE_TYPE_ENV_DATA (document_structure_env_data_get_type ())
typedef struct _DocumentStructureEnvData DocumentStructureEnvData;
typedef enum  {
	STRUCT_TYPE_BEGIN_COMMON_TYPES,
	STRUCT_TYPE_PART,
	STRUCT_TYPE_CHAPTER,
	STRUCT_TYPE_SECTION,
	STRUCT_TYPE_SUBSECTION,
	STRUCT_TYPE_SUBSUBSECTION,
	STRUCT_TYPE_PARAGRAPH,
	STRUCT_TYPE_SUBPARAGRAPH,
	STRUCT_TYPE_LABEL,
	STRUCT_TYPE_INCLUDE,
	STRUCT_TYPE_IMAGE,
	STRUCT_TYPE_TODO,
	STRUCT_TYPE_FIXME,
	STRUCT_TYPE_END_COMMON_TYPES,
	STRUCT_TYPE_BEGIN_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_FIGURE,
	STRUCT_TYPE_END_FIGURE,
	STRUCT_TYPE_BEGIN_TABLE,
	STRUCT_TYPE_END_TABLE,
	STRUCT_TYPE_BEGIN_VERBATIM,
	STRUCT_TYPE_END_VERBATIM,
	STRUCT_TYPE_END_DOCUMENT,
	STRUCT_TYPE_CAPTION,
	STRUCT_TYPE_END_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_TABLE,
	STRUCT_TYPE_FIGURE,
	STRUCT_TYPE_END_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_NB_TYPES
} StructType;

#define TYPE_STRUCT_TYPE (struct_type_get_type ())
enum  {
	DOCUMENT_STRUCTURE_0_PROPERTY,
	DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY,
	DOCUMENT_STRUCTURE_NUM_PROPERTIES
};
static GParamSpec* document_structure_properties[DOCUMENT_STRUCTURE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _document_structure_env_data_free0(var) ((var == NULL) ? NULL : (var = (document_structure_env_data_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define __vala_GtkTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeIter_free (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

#define TYPE_STRUCT_DATA (struct_data_get_type ())
typedef struct _StructData StructData;
typedef enum  {
	STRUCT_ACTION_CUT,
	STRUCT_ACTION_COPY,
	STRUCT_ACTION_DELETE,
	STRUCT_ACTION_SELECT,
	STRUCT_ACTION_COMMENT,
	STRUCT_ACTION_SHIFT_LEFT,
	STRUCT_ACTION_SHIFT_RIGHT,
	STRUCT_ACTION_OPEN_FILE,
	STRUCT_ACTION_NB_ACTIONS
} StructAction;

#define TYPE_STRUCT_ACTION (struct_action_get_type ())
typedef enum  {
	STRUCT_COLUMN_PIXBUF,
	STRUCT_COLUMN_TEXT,
	STRUCT_COLUMN_TOOLTIP,
	STRUCT_COLUMN_START_MARK,
	STRUCT_COLUMN_END_MARK,
	STRUCT_COLUMN_TYPE,
	STRUCT_COLUMN_N_COLUMNS
} StructColumn;

#define TYPE_STRUCT_COLUMN (struct_column_get_type ())

struct _DocumentStructure {
	GObject parent_instance;
	DocumentStructurePrivate * priv;
};

struct _DocumentStructureClass {
	GObjectClass parent_class;
};

struct _DocumentStructureEnvData {
	GtkTreePath* path;
	StructType type;
	gchar* first_caption;
};

struct _DocumentStructurePrivate {
	Document* _doc;
	gint _nb_marks;
	GtkTextMark* _end_document_mark;
	StructureModel* _model;
	gboolean _in_verbatim_env;
	DocumentStructureEnvData* _last_env_data;
	gint _start_parsing_line;
	GTimer* _timer;
	guint _idle_id;
	gboolean _parsing_done;
};

struct _StructData {
	StructType type;
	gchar* text;
	GtkTextMark* start_mark;
	GtkTextMark* end_mark;
};

typedef enum  {
	STRUCT_ERROR_GENERAL,
	STRUCT_ERROR_DATA_OUTDATED
} StructError;
#define STRUCT_ERROR struct_error_quark ()

static gint DocumentStructure_private_offset;
static gpointer document_structure_parent_class = NULL;
static GRegex* document_structure__chars_regex;
static GRegex* document_structure__chars_regex = NULL;
static GRegex* document_structure__comment_regex;
static GRegex* document_structure__comment_regex = NULL;
static GRegex* document_structure__command_name_regex;
static GRegex* document_structure__command_name_regex = NULL;
static gchar** document_structure__section_names;
static gint document_structure__section_names_length1;
static gchar** document_structure__section_names = NULL;
static gint document_structure__section_names_length1 = 0;
static gint _document_structure__section_names_size_ = 0;

VALA_EXTERN GType document_structure_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentStructure, g_object_unref)
VALA_EXTERN GType document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
VALA_EXTERN GType structure_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (StructureModel, g_object_unref)
static GType document_structure_env_data_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN GType struct_type_get_type (void) G_GNUC_CONST ;
static DocumentStructureEnvData* document_structure_env_data_dup (const DocumentStructureEnvData* self);
static void document_structure_env_data_free (DocumentStructureEnvData* self);
static void document_structure_env_data_copy (const DocumentStructureEnvData* self,
                                       DocumentStructureEnvData* dest);
static void document_structure_env_data_destroy (DocumentStructureEnvData* self);
VALA_EXTERN DocumentStructure* document_structure_new (Document* doc);
VALA_EXTERN DocumentStructure* document_structure_construct (GType object_type,
                                                 Document* doc);
VALA_EXTERN void document_structure_parse (DocumentStructure* self);
static void document_structure_set_parsing_done (DocumentStructure* self,
                                          gboolean value);
VALA_EXTERN StructureModel* structure_model_new (void);
VALA_EXTERN StructureModel* structure_model_construct (GType object_type);
static void document_structure_clear_all_structure_marks (DocumentStructure* self);
static gboolean __lambda28_ (DocumentStructure* self);
static gboolean document_structure_parse_impl (DocumentStructure* self);
static gboolean ___lambda28__gsource_func (gpointer self);
VALA_EXTERN StructureModel* document_structure_get_model (DocumentStructure* self);
static gchar* document_structure_get_line_contents_at_iter (DocumentStructure* self,
                                                     GtkTextIter* iter);
static gboolean document_structure_search_low_level_item (DocumentStructure* self,
                                                   const gchar* line,
                                                   gint start_index,
                                                   StructType** type,
                                                   gchar** contents,
                                                   gint** start_match_index,
                                                   gint** end_match_index);
static void document_structure_handle_item (DocumentStructure* self,
                                     StructType type,
                                     const gchar* contents,
                                     GtkTextIter* iter);
static gint* _int_dup (gint* self);
VALA_EXTERN gboolean utils_char_is_escaped (const gchar* text,
                                glong char_index);
static gboolean document_structure_search_markup (DocumentStructure* self,
                                           const gchar* line,
                                           gint after_backslash_index,
                                           StructType** type,
                                           gchar** contents,
                                           gint** end_match_index);
static gboolean document_structure_search_comment (DocumentStructure* self,
                                            const gchar* line,
                                            gint after_percent_index,
                                            StructType** type,
                                            gchar** contents,
                                            gint** end_match_index);
static gchar* document_structure_get_markup_name (DocumentStructure* self,
                                           const gchar* line,
                                           gint after_backslash_index,
                                           gint** begin_contents_index);
static gboolean document_structure_search_env (DocumentStructure* self,
                                        const gchar* line,
                                        gint begin_contents_index,
                                        gboolean is_begin_env,
                                        StructType** type,
                                        gint** end_match_index);
static StructType* document_structure_get_markup_type (DocumentStructure* self,
                                                const gchar* markup_name);
static gchar* document_structure_get_markup_contents (DocumentStructure* self,
                                               const gchar* line,
                                               gint begin_contents_index,
                                               gint** end_match_index);
static StructType* _struct_type_dup (StructType* self);
static gboolean document_structure_search_firt_non_optional_arg (DocumentStructure* self,
                                                          const gchar* line,
                                                          gint start_index,
                                                          gint* begin_contents_index);
static gchar* document_structure_truncate (DocumentStructure* self,
                                    const gchar* text);
static GtkTreeIter* document_structure_add_item (DocumentStructure* self,
                                          StructType type,
                                          const gchar* text,
                                          GtkTextIter* start_iter);
static void _vala_GtkTreeIter_free (GtkTreeIter* self);
VALA_EXTERN gboolean structure_is_common_type (StructType type);
static void document_structure_create_new_environment (DocumentStructure* self,
                                                StructType type,
                                                GtkTextIter* start_iter);
static gboolean document_structure_verify_end_environment_type (DocumentStructure* self,
                                                         StructType type);
static GtkTextMark* document_structure_create_text_mark_from_iter (DocumentStructure* self,
                                                            GtkTextIter* iter);
VALA_EXTERN void structure_model_modify_data (StructureModel* self,
                                  GtkTreePath* path,
                                  const gchar* text,
                                  GtkTextMark* end_mark);
static void _vala_GtkTreePath_free (GtkTreePath* self);
VALA_EXTERN GType struct_data_get_type (void) G_GNUC_CONST ;
VALA_EXTERN StructData* struct_data_dup (const StructData* self);
VALA_EXTERN void struct_data_free (StructData* self);
VALA_EXTERN void struct_data_copy (const StructData* self,
                       StructData* dest);
VALA_EXTERN void struct_data_destroy (StructData* self);
static GtkTreeIter* document_structure_add_item_data (DocumentStructure* self,
                                               StructData* data);
VALA_EXTERN GtkTreeIter* structure_model_add_item_at_end (StructureModel* self,
                                              StructData* item);
VALA_EXTERN GType struct_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GQuark struct_error_quark (void);
VALA_EXTERN void document_structure_do_action (DocumentStructure* self,
                                   StructAction action_type,
                                   GtkTreeIter* tree_iter,
                                   gboolean* refresh_simple_list,
                                   GError** error);
static gboolean document_structure_comment_item (DocumentStructure* self,
                                          GtkTreeIter* tree_iter);
VALA_EXTERN void structure_model_delete (StructureModel* self,
                             GtkTreeIter* iter);
VALA_EXTERN gboolean structure_model_item_contains_subparagraph (StructureModel* self,
                                                     GtkTreeIter* iter);
static gboolean document_structure_shift_item (DocumentStructure* self,
                                        GtkTreeIter* tree_iter,
                                        gboolean shift_right,
                                        gboolean* doc_modified);
VALA_EXTERN void structure_model_shift_right (StructureModel* self,
                                  GtkTreeIter* iter);
VALA_EXTERN void structure_model_shift_left (StructureModel* self,
                                 GtkTreeIter* iter);
static gboolean document_structure_get_exact_item_bounds (DocumentStructure* self,
                                                   GtkTreeIter* tree_iter,
                                                   GtkTextIter* start_iter,
                                                   GtkTextIter* end_iter);
static void document_structure_backward_indentation (DocumentStructure* self,
                                              GtkTextIter* iter);
VALA_EXTERN GType struct_column_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean structure_is_section (StructType type);
VALA_EXTERN void document_comment_between (Document* self,
                               GtkTextIter* start_iter,
                               GtkTextIter* end_iter,
                               gboolean end_iter_set);
VALA_EXTERN GtkTreeIter* structure_model_get_next_sibling_or_parent (StructureModel* self,
                                                         GtkTreeIter* section_iter,
                                                         GError** error);
static void document_structure_get_end_document_iter (DocumentStructure* self,
                                               gboolean* end_of_file,
                                               GtkTextIter* result);
static gboolean document_structure_get_low_level_item_bounds (DocumentStructure* self,
                                                       StructType item_type,
                                                       const gchar* item_contents,
                                                       GtkTextIter* start_match_iter,
                                                       gboolean is_start,
                                                       GtkTextIter* end_match_iter);
static gboolean _int_equal (const gint * s1,
                     const gint * s2);
static gboolean document_structure_same_items (DocumentStructure* self,
                                        StructType item_type,
                                        const gchar* item_contents,
                                        StructType item_found_type,
                                        const gchar* item_found_contents,
                                        gboolean start);
static gchar* document_structure_get_section_name_from_type (DocumentStructure* self,
                                                      StructType type);
VALA_EXTERN void document_insert (Document* self,
                      GtkTextIter* iter,
                      const gchar* text,
                      gint len);
VALA_EXTERN gboolean document_structure_get_parsing_done (DocumentStructure* self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void document_structure_finalize (GObject * obj);
static GType document_structure_get_type_once (void);
static void _vala_document_structure_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_document_structure_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
document_structure_get_instance_private (DocumentStructure* self)
{
	return G_STRUCT_MEMBER_P (self, DocumentStructure_private_offset);
}

DocumentStructure*
document_structure_construct (GType object_type,
                              Document* doc)
{
	DocumentStructure * self = NULL;
	GRegex* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (doc != NULL, NULL);
	self = (DocumentStructure*) g_object_new (object_type, NULL);
	self->priv->_doc = doc;
	_tmp0_ = document_structure__chars_regex;
	if (_tmp0_ != NULL) {
		return self;
	}
	{
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_ = NULL;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		GRegex* _tmp7_ = NULL;
		GRegex* _tmp8_;
		GRegex* _tmp9_;
		_tmp2_ = g_regex_new ("\\\\|%", 0, 0, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_regex_unref0 (document_structure__chars_regex);
		document_structure__chars_regex = _tmp3_;
		_tmp5_ = g_regex_new ("^(?P<type>TODO|FIXME)\\s*:?\\s*(?P<text>.*)$", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp1_);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp6_ = _tmp4_;
		_tmp4_ = NULL;
		_g_regex_unref0 (document_structure__comment_regex);
		document_structure__comment_regex = _tmp6_;
		_tmp8_ = g_regex_new ("^(?P<name>[a-z]+\\*?)\\s*(\\[|{)", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp9_ = _tmp7_;
		_tmp7_ = NULL;
		_g_regex_unref0 (document_structure__command_name_regex);
		document_structure__command_name_regex = _tmp9_;
		_g_regex_unref0 (_tmp7_);
		_g_regex_unref0 (_tmp4_);
		_g_regex_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("document_structure.vala:88: Structure: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

DocumentStructure*
document_structure_new (Document* doc)
{
	return document_structure_construct (TYPE_DOCUMENT_STRUCTURE, doc);
}

static gboolean
__lambda28_ (DocumentStructure* self)
{
	gboolean ret = FALSE;
	gboolean result = FALSE;
	ret = document_structure_parse_impl (self);
	if (!ret) {
		self->priv->_idle_id = (guint) 0;
	}
	result = ret;
	return result;
}

static gboolean
___lambda28__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda28_ ((DocumentStructure*) self);
	return result;
}

void
document_structure_parse (DocumentStructure* self)
{
	StructureModel* _tmp0_;
	g_return_if_fail (self != NULL);
	document_structure_set_parsing_done (self, FALSE);
	_tmp0_ = structure_model_new ();
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = _tmp0_;
	_document_structure_env_data_free0 (self->priv->_last_env_data);
	self->priv->_last_env_data = NULL;
	self->priv->_start_parsing_line = 0;
	_g_object_unref0 (self->priv->_end_document_mark);
	self->priv->_end_document_mark = NULL;
	document_structure_clear_all_structure_marks (self);
	if (self->priv->_idle_id != ((guint) 0)) {
		g_source_remove (self->priv->_idle_id);
	}
	self->priv->_idle_id = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda28__gsource_func, g_object_ref (self), g_object_unref);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

StructureModel*
document_structure_get_model (DocumentStructure* self)
{
	StructureModel* _tmp0_;
	StructureModel* _tmp1_;
	StructureModel* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/*************************************************************************/
static gboolean
document_structure_parse_impl (DocumentStructure* self)
{
	Document* _tmp0_;
	GtkTextIter line_iter = {0};
	Document* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	gint nb_lines_parsed = 0;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_doc;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	if (DOCUMENT_STRUCTURE__measure_parsing_time) {
		GTimer* _tmp1_;
		_tmp1_ = self->priv->_timer;
		if (_tmp1_ == NULL) {
			GTimer* _tmp2_;
			_tmp2_ = g_timer_new ();
			_g_timer_destroy0 (self->priv->_timer);
			self->priv->_timer = _tmp2_;
		} else {
			GTimer* _tmp3_;
			_tmp3_ = self->priv->_timer;
			g_timer_continue (_tmp3_);
		}
	}
	_tmp4_ = self->priv->_doc;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) _tmp4_, &_tmp5_, self->priv->_start_parsing_line);
	line_iter = _tmp5_;
	nb_lines_parsed = 0;
	{
		gboolean _tmp6_ = FALSE;
		_tmp6_ = TRUE;
		while (TRUE) {
			gchar* line_text = NULL;
			GtkTextIter _tmp8_;
			gchar* _tmp9_;
			gint start_index = 0;
			gint line_length = 0;
			const gchar* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp25_;
			if (!_tmp6_) {
				if (!gtk_text_iter_forward_line (&line_iter)) {
					break;
				}
			}
			_tmp6_ = FALSE;
			if (nb_lines_parsed == DOCUMENT_STRUCTURE_MAX_NB_LINES_TO_PARSE) {
				self->priv->_start_parsing_line = self->priv->_start_parsing_line + DOCUMENT_STRUCTURE_MAX_NB_LINES_TO_PARSE;
				if (DOCUMENT_STRUCTURE__measure_parsing_time) {
					GTimer* _tmp7_;
					_tmp7_ = self->priv->_timer;
					g_timer_stop (_tmp7_);
				}
				result = TRUE;
				return result;
			}
			_tmp8_ = line_iter;
			_tmp9_ = document_structure_get_line_contents_at_iter (self, &_tmp8_);
			line_text = _tmp9_;
			start_index = 0;
			_tmp10_ = line_text;
			_tmp11_ = strlen (_tmp10_);
			_tmp12_ = _tmp11_;
			line_length = _tmp12_;
			while (TRUE) {
				StructType* type = NULL;
				gchar* contents = NULL;
				gint* start_match_index = NULL;
				gint* end_match_index = NULL;
				gboolean item_found = FALSE;
				const gchar* _tmp13_;
				StructType* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gint* _tmp16_ = NULL;
				gint* _tmp17_ = NULL;
				gboolean _tmp18_;
				GtkTextIter iter = {0};
				GtkTextIter _tmp19_;
				gint* _tmp20_;
				StructType* _tmp21_;
				const gchar* _tmp22_;
				GtkTextIter _tmp23_;
				gint* _tmp24_;
				if (!(start_index < line_length)) {
					break;
				}
				_tmp13_ = line_text;
				_tmp18_ = document_structure_search_low_level_item (self, _tmp13_, start_index, &_tmp14_, &_tmp15_, &_tmp16_, &_tmp17_);
				_g_free0 (type);
				type = _tmp14_;
				_g_free0 (contents);
				contents = _tmp15_;
				_g_free0 (start_match_index);
				start_match_index = _tmp16_;
				_g_free0 (end_match_index);
				end_match_index = _tmp17_;
				item_found = _tmp18_;
				if (!item_found) {
					_g_free0 (end_match_index);
					_g_free0 (start_match_index);
					_g_free0 (contents);
					_g_free0 (type);
					break;
				}
				_tmp19_ = line_iter;
				iter = _tmp19_;
				_tmp20_ = start_match_index;
				gtk_text_iter_set_line_index (&iter, *_tmp20_);
				_tmp21_ = type;
				_tmp22_ = contents;
				_tmp23_ = iter;
				document_structure_handle_item (self, *_tmp21_, _tmp22_, &_tmp23_);
				_tmp24_ = end_match_index;
				start_index = *_tmp24_;
				_g_free0 (end_match_index);
				_g_free0 (start_match_index);
				_g_free0 (contents);
				_g_free0 (type);
			}
			_tmp25_ = nb_lines_parsed;
			nb_lines_parsed = _tmp25_ + 1;
			_g_free0 (line_text);
		}
	}
	if (DOCUMENT_STRUCTURE__measure_parsing_time) {
		GTimer* _tmp26_;
		GTimer* _tmp27_;
		GTimer* _tmp28_;
		_tmp26_ = self->priv->_timer;
		g_timer_stop (_tmp26_);
		_tmp27_ = self->priv->_timer;
		g_message ("document_structure.vala:201: Structure parsing took %f seconds", g_timer_elapsed (_tmp27_, NULL));
		_tmp28_ = self->priv->_timer;
		g_timer_reset (_tmp28_);
	}
	document_structure_set_parsing_done (self, TRUE);
	result = FALSE;
	return result;
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static gboolean
document_structure_search_low_level_item (DocumentStructure* self,
                                          const gchar* line,
                                          gint start_index,
                                          StructType** type,
                                          gchar** contents,
                                          gint** start_match_index,
                                          gint** end_match_index)
{
	StructType* _vala_type = NULL;
	gchar* _vala_contents = NULL;
	gint* _vala_start_match_index = NULL;
	gint* _vala_end_match_index = NULL;
	GMatchInfo* match_info = NULL;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_g_free0 (_vala_type);
	_vala_type = NULL;
	_g_free0 (_vala_contents);
	_vala_contents = NULL;
	_g_free0 (_vala_start_match_index);
	_vala_start_match_index = NULL;
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = NULL;
	{
		GRegex* _tmp0_;
		GMatchInfo* _tmp1_ = NULL;
		_tmp0_ = document_structure__chars_regex;
		g_regex_match_full (_tmp0_, line, (gssize) -1, start_index, 0, &_tmp1_, &_inner_error0_);
		_g_match_info_unref0 (match_info);
		match_info = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("document_structure.vala:233: Structure parsing: chars regex: %s", _tmp3_);
		result = FALSE;
		_g_error_free0 (e);
		_g_match_info_unref0 (match_info);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (start_match_index) {
			*start_match_index = _vala_start_match_index;
		} else {
			_g_free0 (_vala_start_match_index);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		_g_match_info_unref0 (match_info);
		_g_free0 (_vala_type);
		_g_free0 (_vala_contents);
		_g_free0 (_vala_start_match_index);
		_g_free0 (_vala_end_match_index);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
	while (TRUE) {
		GMatchInfo* _tmp5_;
		gint after_char_index = 0;
		GMatchInfo* _tmp6_;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gboolean _tmp9_;
		gint _tmp10_;
		gint* _tmp11_;
		gint* _tmp12_;
		_tmp5_ = match_info;
		if (!g_match_info_matches (_tmp5_)) {
			break;
		}
		_tmp6_ = match_info;
		_tmp9_ = g_match_info_fetch_pos (_tmp6_, 0, &_tmp7_, &_tmp8_);
		_g_free0 (_vala_start_match_index);
		_tmp10_ = _tmp7_;
		_tmp11_ = __int_dup0 (&_tmp10_);
		_vala_start_match_index = _tmp11_;
		after_char_index = _tmp8_;
		if (!_tmp9_) {
			g_warning ("document_structure.vala:242: Structure parsing: position can not be fe" \
"tched");
			result = FALSE;
			_g_match_info_unref0 (match_info);
			if (type) {
				*type = _vala_type;
			} else {
				_g_free0 (_vala_type);
			}
			if (contents) {
				*contents = _vala_contents;
			} else {
				_g_free0 (_vala_contents);
			}
			if (start_match_index) {
				*start_match_index = _vala_start_match_index;
			} else {
				_g_free0 (_vala_start_match_index);
			}
			if (end_match_index) {
				*end_match_index = _vala_end_match_index;
			} else {
				_g_free0 (_vala_end_match_index);
			}
			return result;
		}
		_tmp12_ = _vala_start_match_index;
		if (!utils_char_is_escaped (line, *_tmp12_)) {
			gchar* char_matched = NULL;
			GMatchInfo* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp13_ = match_info;
			_tmp14_ = g_match_info_fetch (_tmp13_, 0);
			char_matched = _tmp14_;
			_tmp15_ = char_matched;
			if (g_strcmp0 (_tmp15_, "\\") == 0) {
				gboolean markup_found = FALSE;
				StructType* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				gint* _tmp18_ = NULL;
				gboolean _tmp19_;
				_tmp19_ = document_structure_search_markup (self, line, after_char_index, &_tmp16_, &_tmp17_, &_tmp18_);
				_g_free0 (_vala_type);
				_vala_type = _tmp16_;
				_g_free0 (_vala_contents);
				_vala_contents = _tmp17_;
				_g_free0 (_vala_end_match_index);
				_vala_end_match_index = _tmp18_;
				markup_found = _tmp19_;
				if (markup_found) {
					result = TRUE;
					_g_free0 (char_matched);
					_g_match_info_unref0 (match_info);
					if (type) {
						*type = _vala_type;
					} else {
						_g_free0 (_vala_type);
					}
					if (contents) {
						*contents = _vala_contents;
					} else {
						_g_free0 (_vala_contents);
					}
					if (start_match_index) {
						*start_match_index = _vala_start_match_index;
					} else {
						_g_free0 (_vala_start_match_index);
					}
					if (end_match_index) {
						*end_match_index = _vala_end_match_index;
					} else {
						_g_free0 (_vala_end_match_index);
					}
					return result;
				}
			} else {
				StructType* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				gint* _tmp22_ = NULL;
				gboolean _tmp23_;
				_tmp23_ = document_structure_search_comment (self, line, after_char_index, &_tmp20_, &_tmp21_, &_tmp22_);
				_g_free0 (_vala_type);
				_vala_type = _tmp20_;
				_g_free0 (_vala_contents);
				_vala_contents = _tmp21_;
				_g_free0 (_vala_end_match_index);
				_vala_end_match_index = _tmp22_;
				result = _tmp23_;
				_g_free0 (char_matched);
				_g_match_info_unref0 (match_info);
				if (type) {
					*type = _vala_type;
				} else {
					_g_free0 (_vala_type);
				}
				if (contents) {
					*contents = _vala_contents;
				} else {
					_g_free0 (_vala_contents);
				}
				if (start_match_index) {
					*start_match_index = _vala_start_match_index;
				} else {
					_g_free0 (_vala_start_match_index);
				}
				if (end_match_index) {
					*end_match_index = _vala_end_match_index;
				} else {
					_g_free0 (_vala_end_match_index);
				}
				return result;
			}
			_g_free0 (char_matched);
		}
		{
			GMatchInfo* _tmp24_;
			_tmp24_ = match_info;
			g_match_info_next (_tmp24_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp25_ = FALSE;
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch1_g_regex_error;
				}
				_g_match_info_unref0 (match_info);
				_g_free0 (_vala_type);
				_g_free0 (_vala_contents);
				_g_free0 (_vala_start_match_index);
				_g_free0 (_vala_end_match_index);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp25_;
			}
		}
		goto __finally1;
		__catch1_g_regex_error:
		{
			GError* e = NULL;
			GError* _tmp26_;
			const gchar* _tmp27_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp26_ = e;
			_tmp27_ = _tmp26_->message;
			g_warning ("document_structure.vala:278: Structure parsing: %s", _tmp27_);
			_g_error_free0 (e);
			break;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp28_ = FALSE;
			_g_match_info_unref0 (match_info);
			_g_free0 (_vala_type);
			_g_free0 (_vala_contents);
			_g_free0 (_vala_start_match_index);
			_g_free0 (_vala_end_match_index);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp28_;
		}
	}
	result = FALSE;
	_g_match_info_unref0 (match_info);
	if (type) {
		*type = _vala_type;
	} else {
		_g_free0 (_vala_type);
	}
	if (contents) {
		*contents = _vala_contents;
	} else {
		_g_free0 (_vala_contents);
	}
	if (start_match_index) {
		*start_match_index = _vala_start_match_index;
	} else {
		_g_free0 (_vala_start_match_index);
	}
	if (end_match_index) {
		*end_match_index = _vala_end_match_index;
	} else {
		_g_free0 (_vala_end_match_index);
	}
	return result;
}

static gboolean
document_structure_search_markup (DocumentStructure* self,
                                  const gchar* line,
                                  gint after_backslash_index,
                                  StructType** type,
                                  gchar** contents,
                                  gint** end_match_index)
{
	StructType* _vala_type = NULL;
	gchar* _vala_contents = NULL;
	gint* _vala_end_match_index = NULL;
	gint* begin_contents_index = NULL;
	gchar* name = NULL;
	gint* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean is_begin_env = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp10_;
	StructType* _tmp11_;
	StructType* _tmp12_;
	gint* _tmp13_;
	gint* _tmp14_ = NULL;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_g_free0 (_vala_type);
	_vala_type = NULL;
	_g_free0 (_vala_contents);
	_vala_contents = NULL;
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = NULL;
	_tmp1_ = document_structure_get_markup_name (self, line, after_backslash_index, &_tmp0_);
	_g_free0 (begin_contents_index);
	begin_contents_index = _tmp0_;
	name = _tmp1_;
	_tmp2_ = name;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_free0 (name);
		_g_free0 (begin_contents_index);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp3_ = name;
	is_begin_env = g_strcmp0 (_tmp3_, "begin") == 0;
	if (is_begin_env) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = name;
		_tmp4_ = g_strcmp0 (_tmp5_, "end") == 0;
	}
	if (_tmp4_) {
		gint* _tmp6_;
		StructType* _tmp7_ = NULL;
		gint* _tmp8_ = NULL;
		gboolean _tmp9_;
		_g_free0 (_vala_contents);
		_vala_contents = NULL;
		_tmp6_ = begin_contents_index;
		_tmp9_ = document_structure_search_env (self, line, *_tmp6_, is_begin_env, &_tmp7_, &_tmp8_);
		_g_free0 (_vala_type);
		_vala_type = _tmp7_;
		_g_free0 (_vala_end_match_index);
		_vala_end_match_index = _tmp8_;
		result = _tmp9_;
		_g_free0 (name);
		_g_free0 (begin_contents_index);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp10_ = name;
	_tmp11_ = document_structure_get_markup_type (self, _tmp10_);
	_g_free0 (_vala_type);
	_vala_type = _tmp11_;
	_tmp12_ = _vala_type;
	if (_tmp12_ == NULL) {
		result = FALSE;
		_g_free0 (name);
		_g_free0 (begin_contents_index);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp13_ = begin_contents_index;
	_tmp15_ = document_structure_get_markup_contents (self, line, *_tmp13_, &_tmp14_);
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = _tmp14_;
	_g_free0 (_vala_contents);
	_vala_contents = _tmp15_;
	_tmp16_ = _vala_contents;
	result = _tmp16_ != NULL;
	_g_free0 (name);
	_g_free0 (begin_contents_index);
	if (type) {
		*type = _vala_type;
	} else {
		_g_free0 (_vala_type);
	}
	if (contents) {
		*contents = _vala_contents;
	} else {
		_g_free0 (_vala_contents);
	}
	if (end_match_index) {
		*end_match_index = _vala_end_match_index;
	} else {
		_g_free0 (_vala_end_match_index);
	}
	return result;
}

static StructType*
_struct_type_dup (StructType* self)
{
	StructType* dup;
	dup = g_new0 (StructType, 1);
	memcpy (dup, self, sizeof (StructType));
	return dup;
}

static gpointer
__struct_type_dup0 (gpointer self)
{
	return self ? _struct_type_dup (self) : NULL;
}

static gboolean
document_structure_search_env (DocumentStructure* self,
                               const gchar* line,
                               gint begin_contents_index,
                               gboolean is_begin_env,
                               StructType** type,
                               gint** end_match_index)
{
	StructType* _vala_type = NULL;
	gint* _vala_end_match_index = NULL;
	gchar* contents = NULL;
	gint* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	const gchar* _tmp8_;
	const gchar* _tmp11_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_g_free0 (_vala_type);
	_vala_type = NULL;
	_tmp1_ = document_structure_get_markup_contents (self, line, begin_contents_index, &_tmp0_);
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = _tmp0_;
	contents = _tmp1_;
	_tmp2_ = contents;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp4_ = contents;
	if (g_strcmp0 (_tmp4_, "verbatim") == 0) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = contents;
		_tmp3_ = g_strcmp0 (_tmp5_, "verbatim*") == 0;
	}
	if (_tmp3_) {
		StructType _tmp6_ = 0;
		StructType* _tmp7_;
		if (is_begin_env) {
			_tmp6_ = STRUCT_TYPE_BEGIN_VERBATIM;
		} else {
			_tmp6_ = STRUCT_TYPE_END_VERBATIM;
		}
		_tmp7_ = __struct_type_dup0 (&_tmp6_);
		_g_free0 (_vala_type);
		_vala_type = _tmp7_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp8_ = contents;
	if (g_strcmp0 (_tmp8_, "figure") == 0) {
		StructType _tmp9_ = 0;
		StructType* _tmp10_;
		if (is_begin_env) {
			_tmp9_ = STRUCT_TYPE_BEGIN_FIGURE;
		} else {
			_tmp9_ = STRUCT_TYPE_END_FIGURE;
		}
		_tmp10_ = __struct_type_dup0 (&_tmp9_);
		_g_free0 (_vala_type);
		_vala_type = _tmp10_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp11_ = contents;
	if (g_strcmp0 (_tmp11_, "table") == 0) {
		StructType _tmp12_ = 0;
		StructType* _tmp13_;
		if (is_begin_env) {
			_tmp12_ = STRUCT_TYPE_BEGIN_TABLE;
		} else {
			_tmp12_ = STRUCT_TYPE_END_TABLE;
		}
		_tmp13_ = __struct_type_dup0 (&_tmp12_);
		_g_free0 (_vala_type);
		_vala_type = _tmp13_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp15_ = contents;
	if (g_strcmp0 (_tmp15_, "document") == 0) {
		_tmp14_ = !is_begin_env;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		StructType _tmp16_;
		StructType* _tmp17_;
		_tmp16_ = STRUCT_TYPE_END_DOCUMENT;
		_tmp17_ = __struct_type_dup0 (&_tmp16_);
		_g_free0 (_vala_type);
		_vala_type = _tmp17_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	result = FALSE;
	_g_free0 (contents);
	if (type) {
		*type = _vala_type;
	} else {
		_g_free0 (_vala_type);
	}
	if (end_match_index) {
		*end_match_index = _vala_end_match_index;
	} else {
		_g_free0 (_vala_end_match_index);
	}
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
document_structure_get_markup_name (DocumentStructure* self,
                                    const gchar* line,
                                    gint after_backslash_index,
                                    gint** begin_contents_index)
{
	gint* _vala_begin_contents_index = NULL;
	gchar* after_backslash_text = NULL;
	gchar* _tmp0_;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp1_;
	const gchar* _tmp2_;
	GMatchInfo* _tmp3_ = NULL;
	gboolean _tmp4_;
	gint pos = 0;
	GMatchInfo* _tmp5_;
	gint _tmp6_ = 0;
	gint begin_first_arg_index = 0;
	gchar* markup_name = NULL;
	GMatchInfo* _tmp7_;
	gchar* _tmp8_;
	gint _tmp9_ = 0;
	gboolean _tmp10_;
	gint _tmp11_;
	gint* _tmp12_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_g_free0 (_vala_begin_contents_index);
	_vala_begin_contents_index = NULL;
	_tmp0_ = string_substring (line, (glong) after_backslash_index, (glong) -1);
	after_backslash_text = _tmp0_;
	_tmp1_ = document_structure__command_name_regex;
	_tmp2_ = after_backslash_text;
	_tmp4_ = g_regex_match (_tmp1_, _tmp2_, 0, &_tmp3_);
	_g_match_info_unref0 (match_info);
	match_info = _tmp3_;
	if (!_tmp4_) {
		result = NULL;
		_g_match_info_unref0 (match_info);
		_g_free0 (after_backslash_text);
		if (begin_contents_index) {
			*begin_contents_index = _vala_begin_contents_index;
		} else {
			_g_free0 (_vala_begin_contents_index);
		}
		return result;
	}
	_tmp5_ = match_info;
	g_match_info_fetch_pos (_tmp5_, 0, NULL, &_tmp6_);
	pos = _tmp6_;
	begin_first_arg_index = after_backslash_index + pos;
	_tmp7_ = match_info;
	_tmp8_ = g_match_info_fetch_named (_tmp7_, "name");
	markup_name = _tmp8_;
	_tmp10_ = document_structure_search_firt_non_optional_arg (self, line, begin_first_arg_index - 1, &_tmp9_);
	_g_free0 (_vala_begin_contents_index);
	_tmp11_ = _tmp9_;
	_tmp12_ = __int_dup0 (&_tmp11_);
	_vala_begin_contents_index = _tmp12_;
	if (_tmp10_) {
		result = markup_name;
		_g_match_info_unref0 (match_info);
		_g_free0 (after_backslash_text);
		if (begin_contents_index) {
			*begin_contents_index = _vala_begin_contents_index;
		} else {
			_g_free0 (_vala_begin_contents_index);
		}
		return result;
	}
	result = NULL;
	_g_free0 (markup_name);
	_g_match_info_unref0 (match_info);
	_g_free0 (after_backslash_text);
	if (begin_contents_index) {
		*begin_contents_index = _vala_begin_contents_index;
	} else {
		_g_free0 (_vala_begin_contents_index);
	}
	return result;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gboolean
document_structure_search_firt_non_optional_arg (DocumentStructure* self,
                                                 const gchar* line,
                                                 gint start_index,
                                                 gint* begin_contents_index)
{
	gint _vala_begin_contents_index = 0;
	gint cur_index = 0;
	gboolean in_optional_arg = FALSE;
	gint additional_bracket_level = 0;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_vala_begin_contents_index = 0;
	cur_index = start_index;
	in_optional_arg = FALSE;
	additional_bracket_level = 0;
	while (TRUE) {
		gint next_index = 0;
		gunichar cur_char = 0U;
		gboolean end = FALSE;
		gunichar _tmp0_ = 0U;
		gboolean _tmp1_;
		next_index = cur_index;
		_tmp1_ = string_get_next_char (line, &next_index, &_tmp0_);
		cur_char = _tmp0_;
		end = !_tmp1_;
		if (in_optional_arg) {
			switch (cur_char) {
				case ']':
				{
					if (!utils_char_is_escaped (line, (glong) cur_index)) {
						if (0 < additional_bracket_level) {
							gint _tmp2_;
							_tmp2_ = additional_bracket_level;
							additional_bracket_level = _tmp2_ - 1;
						} else {
							in_optional_arg = FALSE;
						}
					}
					break;
				}
				case '[':
				{
					if (!utils_char_is_escaped (line, (glong) cur_index)) {
						gint _tmp3_;
						_tmp3_ = additional_bracket_level;
						additional_bracket_level = _tmp3_ + 1;
					}
					break;
				}
				default:
				break;
			}
		} else {
			switch (cur_char) {
				case '{':
				{
					_vala_begin_contents_index = next_index;
					result = TRUE;
					if (begin_contents_index) {
						*begin_contents_index = _vala_begin_contents_index;
					}
					return result;
				}
				case '[':
				{
					in_optional_arg = TRUE;
					break;
				}
				case ' ':
				case '\t':
				{
					break;
				}
				default:
				{
					result = FALSE;
					if (begin_contents_index) {
						*begin_contents_index = _vala_begin_contents_index;
					}
					return result;
				}
			}
		}
		if (end) {
			result = FALSE;
			if (begin_contents_index) {
				*begin_contents_index = _vala_begin_contents_index;
			}
			return result;
		}
		cur_index = next_index;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
document_structure_get_markup_contents (DocumentStructure* self,
                                        const gchar* line,
                                        gint begin_contents_index,
                                        gint** end_match_index)
{
	gint* _vala_end_match_index = NULL;
	gint brace_level = 0;
	gint cur_index = 0;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = NULL;
	brace_level = 0;
	cur_index = begin_contents_index;
	while (TRUE) {
		gint next_index = 0;
		gunichar cur_char = 0U;
		gboolean end = FALSE;
		gunichar _tmp0_ = 0U;
		gboolean _tmp1_;
		gboolean _tmp2_ = FALSE;
		next_index = cur_index;
		_tmp1_ = string_get_next_char (line, &next_index, &_tmp0_);
		cur_char = _tmp0_;
		end = !_tmp1_;
		if (cur_char == ((gunichar) '{')) {
			_tmp2_ = !utils_char_is_escaped (line, (glong) cur_index);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gint _tmp3_;
			_tmp3_ = brace_level;
			brace_level = _tmp3_ + 1;
		} else {
			gboolean _tmp4_ = FALSE;
			if (cur_char == ((gunichar) '}')) {
				_tmp4_ = !utils_char_is_escaped (line, (glong) cur_index);
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				if (brace_level > 0) {
					gint _tmp5_;
					_tmp5_ = brace_level;
					brace_level = _tmp5_ - 1;
				} else {
					gchar* contents = NULL;
					gchar* _tmp6_;
					const gchar* _tmp7_;
					gint* _tmp8_;
					_tmp6_ = string_slice (line, (glong) begin_contents_index, (glong) cur_index);
					contents = _tmp6_;
					_tmp7_ = contents;
					if (g_strcmp0 (_tmp7_, "") == 0) {
						result = NULL;
						_g_free0 (contents);
						if (end_match_index) {
							*end_match_index = _vala_end_match_index;
						} else {
							_g_free0 (_vala_end_match_index);
						}
						return result;
					}
					_tmp8_ = __int_dup0 (&next_index);
					_g_free0 (_vala_end_match_index);
					_vala_end_match_index = _tmp8_;
					result = contents;
					if (end_match_index) {
						*end_match_index = _vala_end_match_index;
					} else {
						_g_free0 (_vala_end_match_index);
					}
					return result;
				}
			}
		}
		if (end) {
			result = NULL;
			if (end_match_index) {
				*end_match_index = _vala_end_match_index;
			} else {
				_g_free0 (_vala_end_match_index);
			}
			return result;
		}
		cur_index = next_index;
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
document_structure_search_comment (DocumentStructure* self,
                                   const gchar* line,
                                   gint after_percent_index,
                                   StructType** type,
                                   gchar** contents,
                                   gint** end_match_index)
{
	StructType* _vala_type = NULL;
	gchar* _vala_contents = NULL;
	gint* _vala_end_match_index = NULL;
	gchar* text_after = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp4_;
	const gchar* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_;
	gchar* type_str = NULL;
	GMatchInfo* _tmp8_;
	gchar* _tmp9_;
	StructType _tmp10_ = 0;
	const gchar* _tmp11_;
	StructType* _tmp12_;
	GMatchInfo* _tmp13_;
	gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint* _tmp17_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_g_free0 (_vala_type);
	_vala_type = NULL;
	_g_free0 (_vala_contents);
	_vala_contents = NULL;
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = NULL;
	_tmp0_ = string_substring (line, (glong) after_percent_index, (glong) -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_strip (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	text_after = _tmp3_;
	_tmp4_ = document_structure__comment_regex;
	_tmp5_ = text_after;
	_tmp7_ = g_regex_match (_tmp4_, _tmp5_, 0, &_tmp6_);
	_g_match_info_unref0 (match_info);
	match_info = _tmp6_;
	if (!_tmp7_) {
		result = FALSE;
		_g_match_info_unref0 (match_info);
		_g_free0 (text_after);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp8_ = match_info;
	_tmp9_ = g_match_info_fetch_named (_tmp8_, "type");
	type_str = _tmp9_;
	_tmp11_ = type_str;
	if (g_strcmp0 (_tmp11_, "TODO") == 0) {
		_tmp10_ = STRUCT_TYPE_TODO;
	} else {
		_tmp10_ = STRUCT_TYPE_FIXME;
	}
	_tmp12_ = __struct_type_dup0 (&_tmp10_);
	_g_free0 (_vala_type);
	_vala_type = _tmp12_;
	_tmp13_ = match_info;
	_tmp14_ = g_match_info_fetch_named (_tmp13_, "text");
	_g_free0 (_vala_contents);
	_vala_contents = _tmp14_;
	_tmp15_ = strlen (line);
	_tmp16_ = _tmp15_;
	_tmp17_ = __int_dup0 (&_tmp16_);
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = _tmp17_;
	result = TRUE;
	_g_free0 (type_str);
	_g_match_info_unref0 (match_info);
	_g_free0 (text_after);
	if (type) {
		*type = _vala_type;
	} else {
		_g_free0 (_vala_type);
	}
	if (contents) {
		*contents = _vala_contents;
	} else {
		_g_free0 (_vala_contents);
	}
	if (end_match_index) {
		*end_match_index = _vala_end_match_index;
	} else {
		_g_free0 (_vala_end_match_index);
	}
	return result;
}

static void
_vala_GtkTreeIter_free (GtkTreeIter* self)
{
	g_boxed_free (gtk_tree_iter_get_type (), self);
}

static void
document_structure_handle_item (DocumentStructure* self,
                                StructType type,
                                const gchar* contents,
                                GtkTextIter* iter)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	if (self->priv->_in_verbatim_env) {
		if (type == STRUCT_TYPE_END_VERBATIM) {
			self->priv->_in_verbatim_env = FALSE;
		}
		return;
	}
	if (type == STRUCT_TYPE_TODO) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = type == STRUCT_TYPE_FIXME;
	}
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GtkTextIter _tmp4_;
		GtkTreeIter* _tmp5_;
		GtkTreeIter* _tmp6_;
		_tmp2_ = document_structure_truncate (self, contents);
		_tmp1_ = _tmp2_;
		if (_tmp1_ == NULL) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup (contents);
			_g_free0 (_tmp1_);
			_tmp1_ = _tmp3_;
		}
		_tmp4_ = *iter;
		_tmp5_ = document_structure_add_item (self, type, _tmp1_, &_tmp4_);
		_tmp6_ = _tmp5_;
		__vala_GtkTreeIter_free0 (_tmp6_);
		_g_free0 (_tmp1_);
	} else {
		if (structure_is_common_type (type)) {
			GtkTextIter _tmp7_;
			GtkTreeIter* _tmp8_;
			GtkTreeIter* _tmp9_;
			_tmp7_ = *iter;
			_tmp8_ = document_structure_add_item (self, type, contents, &_tmp7_);
			_tmp9_ = _tmp8_;
			__vala_GtkTreeIter_free0 (_tmp9_);
		} else {
			if (type == STRUCT_TYPE_BEGIN_VERBATIM) {
				self->priv->_in_verbatim_env = TRUE;
			} else {
				gboolean _tmp10_ = FALSE;
				if (type == STRUCT_TYPE_BEGIN_FIGURE) {
					_tmp10_ = TRUE;
				} else {
					_tmp10_ = type == STRUCT_TYPE_BEGIN_TABLE;
				}
				if (_tmp10_) {
					GtkTextIter _tmp11_;
					_tmp11_ = *iter;
					document_structure_create_new_environment (self, type, &_tmp11_);
				} else {
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
					if (type == STRUCT_TYPE_CAPTION) {
						DocumentStructureEnvData* _tmp14_;
						_tmp14_ = self->priv->_last_env_data;
						_tmp13_ = _tmp14_ != NULL;
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						DocumentStructureEnvData* _tmp15_;
						const gchar* _tmp16_;
						_tmp15_ = self->priv->_last_env_data;
						_tmp16_ = (*_tmp15_).first_caption;
						_tmp12_ = _tmp16_ == NULL;
					} else {
						_tmp12_ = FALSE;
					}
					if (_tmp12_) {
						gchar* _tmp17_ = NULL;
						gchar* _tmp18_;
						DocumentStructureEnvData* _tmp20_;
						gchar* _tmp21_;
						_tmp18_ = document_structure_truncate (self, contents);
						_tmp17_ = _tmp18_;
						if (_tmp17_ == NULL) {
							gchar* _tmp19_;
							_tmp19_ = g_strdup (contents);
							_g_free0 (_tmp17_);
							_tmp17_ = _tmp19_;
						}
						_tmp20_ = self->priv->_last_env_data;
						_tmp21_ = _tmp17_;
						_tmp17_ = NULL;
						_g_free0 ((*_tmp20_).first_caption);
						(*_tmp20_).first_caption = _tmp21_;
						_g_free0 (_tmp17_);
					} else {
						if (document_structure_verify_end_environment_type (self, type)) {
							GtkTextMark* end_mark = NULL;
							GtkTextIter _tmp22_;
							GtkTextMark* _tmp23_;
							StructureModel* _tmp24_;
							DocumentStructureEnvData* _tmp25_;
							GtkTreePath* _tmp26_;
							DocumentStructureEnvData* _tmp27_;
							const gchar* _tmp28_;
							GtkTextMark* _tmp29_;
							_tmp22_ = *iter;
							_tmp23_ = document_structure_create_text_mark_from_iter (self, &_tmp22_);
							end_mark = _tmp23_;
							_tmp24_ = self->priv->_model;
							_tmp25_ = self->priv->_last_env_data;
							_tmp26_ = (*_tmp25_).path;
							_tmp27_ = self->priv->_last_env_data;
							_tmp28_ = (*_tmp27_).first_caption;
							_tmp29_ = end_mark;
							structure_model_modify_data (_tmp24_, _tmp26_, _tmp28_, _tmp29_);
							_document_structure_env_data_free0 (self->priv->_last_env_data);
							self->priv->_last_env_data = NULL;
							_g_object_unref0 (end_mark);
						} else {
							if (type == STRUCT_TYPE_END_DOCUMENT) {
								GtkTextIter _tmp30_;
								GtkTextMark* _tmp31_;
								_tmp30_ = *iter;
								_tmp31_ = document_structure_create_text_mark_from_iter (self, &_tmp30_);
								_g_object_unref0 (self->priv->_end_document_mark);
								self->priv->_end_document_mark = _tmp31_;
							}
						}
					}
				}
			}
		}
	}
}

static gpointer
_document_structure_env_data_dup0 (gpointer self)
{
	return self ? document_structure_env_data_dup (self) : NULL;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
document_structure_create_new_environment (DocumentStructure* self,
                                           StructType type,
                                           GtkTextIter* start_iter)
{
	gboolean _tmp0_ = FALSE;
	DocumentStructureEnvData _tmp1_ = {0};
	DocumentStructureEnvData _tmp2_;
	DocumentStructureEnvData* _tmp3_;
	DocumentStructureEnvData* _tmp4_;
	GtkTreeIter tree_iter = {0};
	DocumentStructureEnvData* _tmp7_;
	GtkTextIter _tmp8_;
	GtkTreeIter* _tmp9_;
	GtkTreeIter* _tmp10_;
	GtkTreeIter _tmp11_;
	DocumentStructureEnvData* _tmp12_;
	StructureModel* _tmp13_;
	GtkTreeIter _tmp14_;
	GtkTreePath* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start_iter != NULL);
	if (type == STRUCT_TYPE_BEGIN_FIGURE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = type == STRUCT_TYPE_BEGIN_TABLE;
	}
	g_return_if_fail (_tmp0_);
	memset (&_tmp1_, 0, sizeof (DocumentStructureEnvData));
	_tmp2_ = _tmp1_;
	_tmp3_ = _document_structure_env_data_dup0 (&_tmp2_);
	_document_structure_env_data_free0 (self->priv->_last_env_data);
	self->priv->_last_env_data = _tmp3_;
	document_structure_env_data_destroy (&_tmp2_);
	_tmp4_ = self->priv->_last_env_data;
	_g_free0 ((*_tmp4_).first_caption);
	(*_tmp4_).first_caption = NULL;
	if (type == STRUCT_TYPE_BEGIN_TABLE) {
		DocumentStructureEnvData* _tmp5_;
		_tmp5_ = self->priv->_last_env_data;
		(*_tmp5_).type = STRUCT_TYPE_TABLE;
	} else {
		DocumentStructureEnvData* _tmp6_;
		_tmp6_ = self->priv->_last_env_data;
		(*_tmp6_).type = STRUCT_TYPE_FIGURE;
	}
	_tmp7_ = self->priv->_last_env_data;
	_tmp8_ = *start_iter;
	_tmp9_ = document_structure_add_item (self, (*_tmp7_).type, NULL, &_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = *_tmp10_;
	__vala_GtkTreeIter_free0 (_tmp10_);
	tree_iter = _tmp11_;
	_tmp12_ = self->priv->_last_env_data;
	_tmp13_ = self->priv->_model;
	_tmp14_ = tree_iter;
	_tmp15_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp13_, &_tmp14_);
	__vala_GtkTreePath_free0 ((*_tmp12_).path);
	(*_tmp12_).path = _tmp15_;
}

static gboolean
document_structure_verify_end_environment_type (DocumentStructure* self,
                                                StructType type)
{
	DocumentStructureEnvData* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_last_env_data;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	if (type == STRUCT_TYPE_END_TABLE) {
		DocumentStructureEnvData* _tmp1_;
		_tmp1_ = self->priv->_last_env_data;
		result = (*_tmp1_).type == STRUCT_TYPE_TABLE;
		return result;
	}
	if (type == STRUCT_TYPE_END_FIGURE) {
		DocumentStructureEnvData* _tmp2_;
		_tmp2_ = self->priv->_last_env_data;
		result = (*_tmp2_).type == STRUCT_TYPE_FIGURE;
		return result;
	}
	result = FALSE;
	return result;
}

static GtkTreeIter*
document_structure_add_item (DocumentStructure* self,
                             StructType type,
                             const gchar* text,
                             GtkTextIter* start_iter)
{
	StructData data = {0};
	StructData _tmp0_ = {0};
	gchar* _tmp1_;
	GtkTextIter _tmp2_;
	GtkTextMark* _tmp3_;
	StructData _tmp4_;
	GtkTreeIter* _tmp5_;
	GtkTreeIter* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (start_iter != NULL, NULL);
	data = _tmp0_;
	data.type = type;
	_tmp1_ = g_strdup (text);
	_g_free0 (data.text);
	data.text = _tmp1_;
	_tmp2_ = *start_iter;
	_tmp3_ = document_structure_create_text_mark_from_iter (self, &_tmp2_);
	_g_object_unref0 (data.start_mark);
	data.start_mark = _tmp3_;
	_g_object_unref0 (data.end_mark);
	data.end_mark = NULL;
	_tmp4_ = data;
	_tmp5_ = document_structure_add_item_data (self, &_tmp4_);
	result = _tmp5_;
	struct_data_destroy (&data);
	return result;
}

static GtkTreeIter*
document_structure_add_item_data (DocumentStructure* self,
                                  StructData* data)
{
	StructData _tmp0_;
	const gchar* _tmp1_;
	StructureModel* _tmp3_;
	StructData _tmp4_;
	GtkTreeIter* _tmp5_;
	GtkTreeIter* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.text;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		_g_free0 ((*data).text);
		(*data).text = _tmp2_;
	}
	_tmp3_ = self->priv->_model;
	_tmp4_ = *data;
	_tmp5_ = structure_model_add_item_at_end (_tmp3_, &_tmp4_);
	result = _tmp5_;
	return result;
}

static GtkTextMark*
document_structure_create_text_mark_from_iter (DocumentStructure* self,
                                               GtkTextIter* iter)
{
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	gchar* name = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkTextMark* mark = NULL;
	GtkTextIter _tmp6_;
	GtkTextMark* _tmp7_;
	GtkTextMark* _tmp8_;
	gint _tmp9_;
	GtkTextMark* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = gtk_text_iter_get_buffer (iter);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	doc = _tmp1_;
	_tmp2_ = g_strdup_printf ("%i", self->priv->_nb_marks);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (DOCUMENT_STRUCTURE_MARK_NAME_PREFIX, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	name = _tmp5_;
	_tmp6_ = *iter;
	_tmp7_ = gtk_text_buffer_create_mark (doc, name, &_tmp6_, FALSE);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	mark = _tmp8_;
	_tmp9_ = self->priv->_nb_marks;
	self->priv->_nb_marks = _tmp9_ + 1;
	result = mark;
	_g_free0 (name);
	_g_object_unref0 (doc);
	return result;
}

static void
document_structure_clear_all_structure_marks (DocumentStructure* self)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gchar* mark_name = NULL;
				gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				GtkTextMark* mark = NULL;
				Document* _tmp6_;
				const gchar* _tmp7_;
				GtkTextMark* _tmp8_;
				GtkTextMark* _tmp9_;
				GtkTextMark* _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < self->priv->_nb_marks)) {
					break;
				}
				_tmp2_ = g_strdup_printf ("%i", i);
				_tmp3_ = _tmp2_;
				_tmp4_ = g_strconcat (DOCUMENT_STRUCTURE_MARK_NAME_PREFIX, _tmp3_, NULL);
				_tmp5_ = _tmp4_;
				_g_free0 (_tmp3_);
				mark_name = _tmp5_;
				_tmp6_ = self->priv->_doc;
				_tmp7_ = mark_name;
				_tmp8_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) _tmp6_, _tmp7_);
				_tmp9_ = _g_object_ref0 (_tmp8_);
				mark = _tmp9_;
				_tmp10_ = mark;
				if (_tmp10_ != NULL) {
					Document* _tmp11_;
					GtkTextMark* _tmp12_;
					_tmp11_ = self->priv->_doc;
					_tmp12_ = mark;
					gtk_text_buffer_delete_mark ((GtkTextBuffer*) _tmp11_, _tmp12_);
				}
				_g_object_unref0 (mark);
				_g_free0 (mark_name);
			}
		}
	}
	self->priv->_nb_marks = 0;
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

static gchar*
document_structure_truncate (DocumentStructure* self,
                             const gchar* text)
{
	gint index = 0;
	gchar* _tmp0_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (text == NULL) {
		result = NULL;
		return result;
	}
	if (g_utf8_strlen (text, (gssize) -1) <= DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH) {
		result = NULL;
		return result;
	}
	index = string_index_of_nth_char (text, (glong) DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH);
	_tmp0_ = string_substring (text, (glong) 0, (glong) index);
	result = _tmp0_;
	return result;
}

static StructType*
document_structure_get_markup_type (DocumentStructure* self,
                                    const gchar* markup_name)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	static GQuark _tmp1_label8 = 0;
	static GQuark _tmp1_label9 = 0;
	static GQuark _tmp1_label10 = 0;
	static GQuark _tmp1_label11 = 0;
	static GQuark _tmp1_label12 = 0;
	static GQuark _tmp1_label13 = 0;
	static GQuark _tmp1_label14 = 0;
	static GQuark _tmp1_label15 = 0;
	static GQuark _tmp1_label16 = 0;
	static GQuark _tmp1_label17 = 0;
	static GQuark _tmp1_label18 = 0;
	StructType* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (markup_name != NULL, NULL);
	_tmp0_ = markup_name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if ((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("part")))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("part*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp3_;
				StructType* _tmp4_;
				_tmp3_ = STRUCT_TYPE_PART;
				_tmp4_ = __struct_type_dup0 (&_tmp3_);
				result = _tmp4_;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("chapter")))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("chapter*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp5_;
				StructType* _tmp6_;
				_tmp5_ = STRUCT_TYPE_CHAPTER;
				_tmp6_ = __struct_type_dup0 (&_tmp5_);
				result = _tmp6_;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("section")))) || (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("section*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp7_;
				StructType* _tmp8_;
				_tmp7_ = STRUCT_TYPE_SECTION;
				_tmp8_ = __struct_type_dup0 (&_tmp7_);
				result = _tmp8_;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("subsection")))) || (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("subsection*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp9_;
				StructType* _tmp10_;
				_tmp9_ = STRUCT_TYPE_SUBSECTION;
				_tmp10_ = __struct_type_dup0 (&_tmp9_);
				result = _tmp10_;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("subsubsection")))) || (_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string ("subsubsection*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp11_;
				StructType* _tmp12_;
				_tmp11_ = STRUCT_TYPE_SUBSUBSECTION;
				_tmp12_ = __struct_type_dup0 (&_tmp11_);
				result = _tmp12_;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string ("paragraph")))) || (_tmp2_ == ((0 != _tmp1_label11) ? _tmp1_label11 : (_tmp1_label11 = g_quark_from_static_string ("paragraph*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp13_;
				StructType* _tmp14_;
				_tmp13_ = STRUCT_TYPE_PARAGRAPH;
				_tmp14_ = __struct_type_dup0 (&_tmp13_);
				result = _tmp14_;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label12) ? _tmp1_label12 : (_tmp1_label12 = g_quark_from_static_string ("subparagraph")))) || (_tmp2_ == ((0 != _tmp1_label13) ? _tmp1_label13 : (_tmp1_label13 = g_quark_from_static_string ("subparagraph*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp15_;
				StructType* _tmp16_;
				_tmp15_ = STRUCT_TYPE_SUBPARAGRAPH;
				_tmp16_ = __struct_type_dup0 (&_tmp15_);
				result = _tmp16_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label14) ? _tmp1_label14 : (_tmp1_label14 = g_quark_from_static_string ("label")))) {
		switch (0) {
			default:
			{
				StructType _tmp17_;
				StructType* _tmp18_;
				_tmp17_ = STRUCT_TYPE_LABEL;
				_tmp18_ = __struct_type_dup0 (&_tmp17_);
				result = _tmp18_;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label15) ? _tmp1_label15 : (_tmp1_label15 = g_quark_from_static_string ("input")))) || (_tmp2_ == ((0 != _tmp1_label16) ? _tmp1_label16 : (_tmp1_label16 = g_quark_from_static_string ("include"))))) {
		switch (0) {
			default:
			{
				StructType _tmp19_;
				StructType* _tmp20_;
				_tmp19_ = STRUCT_TYPE_INCLUDE;
				_tmp20_ = __struct_type_dup0 (&_tmp19_);
				result = _tmp20_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label17) ? _tmp1_label17 : (_tmp1_label17 = g_quark_from_static_string ("includegraphics")))) {
		switch (0) {
			default:
			{
				StructType _tmp21_;
				StructType* _tmp22_;
				_tmp21_ = STRUCT_TYPE_IMAGE;
				_tmp22_ = __struct_type_dup0 (&_tmp21_);
				result = _tmp22_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label18) ? _tmp1_label18 : (_tmp1_label18 = g_quark_from_static_string ("caption")))) {
		switch (0) {
			default:
			{
				StructType _tmp23_;
				StructType* _tmp24_;
				_tmp23_ = STRUCT_TYPE_CAPTION;
				_tmp24_ = __struct_type_dup0 (&_tmp23_);
				result = _tmp24_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = NULL;
				return result;
			}
		}
	}
}

static gchar*
document_structure_get_line_contents_at_iter (DocumentStructure* self,
                                              GtkTextIter* iter)
{
	GtkTextIter begin_line = {0};
	GtkTextIter _tmp0_;
	GtkTextIter end_line = {0};
	GtkTextIter _tmp1_;
	GtkTextBuffer* buffer = NULL;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextIter _tmp4_;
	GtkTextIter _tmp5_;
	gchar* _tmp6_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	begin_line = _tmp0_;
	gtk_text_iter_set_line_offset (&begin_line, 0);
	_tmp1_ = *iter;
	end_line = _tmp1_;
	if (!gtk_text_iter_ends_line (iter)) {
		gtk_text_iter_forward_to_line_end (&end_line);
	}
	_tmp2_ = gtk_text_iter_get_buffer (iter);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	buffer = _tmp3_;
	_tmp4_ = begin_line;
	_tmp5_ = end_line;
	_tmp6_ = gtk_text_buffer_get_text (buffer, &_tmp4_, &_tmp5_, FALSE);
	result = _tmp6_;
	_g_object_unref0 (buffer);
	return result;
}

/*************************************************************************/
void
document_structure_do_action (DocumentStructure* self,
                              StructAction action_type,
                              GtkTreeIter* tree_iter,
                              gboolean* refresh_simple_list,
                              GError** error)
{
	gboolean _vala_refresh_simple_list = FALSE;
	Document* _tmp0_;
	gboolean shift_right = FALSE;
	gboolean _tmp5_ = FALSE;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	gboolean found = FALSE;
	GtkTreeIter _tmp21_;
	GtkTextIter _tmp22_ = {0};
	GtkTextIter _tmp23_ = {0};
	gboolean _tmp24_;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp38_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree_iter != NULL);
	_vala_refresh_simple_list = FALSE;
	_tmp0_ = self->priv->_doc;
	if (_tmp0_ == NULL) {
		if (refresh_simple_list) {
			*refresh_simple_list = _vala_refresh_simple_list;
		}
		return;
	}
	if (action_type == STRUCT_ACTION_COMMENT) {
		GtkTreeIter _tmp1_;
		StructureModel* _tmp3_;
		GtkTreeIter _tmp4_;
		_tmp1_ = *tree_iter;
		if (!document_structure_comment_item (self, &_tmp1_)) {
			GError* _tmp2_;
			_tmp2_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
			_inner_error0_ = _tmp2_;
			if (_inner_error0_->domain == STRUCT_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp3_ = self->priv->_model;
		_tmp4_ = *tree_iter;
		structure_model_delete (_tmp3_, &_tmp4_);
		_vala_refresh_simple_list = TRUE;
		if (refresh_simple_list) {
			*refresh_simple_list = _vala_refresh_simple_list;
		}
		return;
	}
	shift_right = action_type == STRUCT_ACTION_SHIFT_RIGHT;
	if (shift_right) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = action_type == STRUCT_ACTION_SHIFT_LEFT;
	}
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		Document* _tmp10_;
		gboolean doc_modified = FALSE;
		gboolean success = FALSE;
		GtkTreeIter _tmp11_;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_;
		Document* _tmp14_;
		if (shift_right) {
			StructureModel* _tmp7_;
			GtkTreeIter _tmp8_;
			_tmp7_ = self->priv->_model;
			_tmp8_ = *tree_iter;
			_tmp6_ = structure_model_item_contains_subparagraph (_tmp7_, &_tmp8_);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GError* _tmp9_;
			_tmp9_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_GENERAL, _ ("The structure item already contains a sub-paragraph."));
			_inner_error0_ = _tmp9_;
			if (_inner_error0_->domain == STRUCT_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp10_ = self->priv->_doc;
		gtk_text_buffer_begin_user_action ((GtkTextBuffer*) _tmp10_);
		_tmp11_ = *tree_iter;
		_tmp13_ = document_structure_shift_item (self, &_tmp11_, shift_right, &_tmp12_);
		doc_modified = _tmp12_;
		success = _tmp13_;
		_tmp14_ = self->priv->_doc;
		gtk_text_buffer_end_user_action ((GtkTextBuffer*) _tmp14_);
		if (!success) {
			GError* _tmp16_;
			if (doc_modified) {
				Document* _tmp15_;
				_tmp15_ = self->priv->_doc;
				gtk_source_buffer_undo ((GtkSourceBuffer*) _tmp15_);
			}
			_tmp16_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
			_inner_error0_ = _tmp16_;
			if (_inner_error0_->domain == STRUCT_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		if (shift_right) {
			StructureModel* _tmp17_;
			GtkTreeIter _tmp18_;
			_tmp17_ = self->priv->_model;
			_tmp18_ = *tree_iter;
			structure_model_shift_right (_tmp17_, &_tmp18_);
		} else {
			StructureModel* _tmp19_;
			GtkTreeIter _tmp20_;
			_tmp19_ = self->priv->_model;
			_tmp20_ = *tree_iter;
			structure_model_shift_left (_tmp19_, &_tmp20_);
		}
		if (refresh_simple_list) {
			*refresh_simple_list = _vala_refresh_simple_list;
		}
		return;
	}
	_tmp21_ = *tree_iter;
	_tmp24_ = document_structure_get_exact_item_bounds (self, &_tmp21_, &_tmp22_, &_tmp23_);
	start_iter = _tmp22_;
	end_iter = _tmp23_;
	found = _tmp24_;
	if (!found) {
		GError* _tmp25_;
		_tmp25_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
		_inner_error0_ = _tmp25_;
		if (_inner_error0_->domain == STRUCT_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (gtk_text_iter_get_line (&start_iter) != gtk_text_iter_get_line (&end_iter)) {
		document_structure_backward_indentation (self, &start_iter);
		document_structure_backward_indentation (self, &end_iter);
	}
	if (action_type == STRUCT_ACTION_SELECT) {
		Document* _tmp26_;
		GtkTextIter _tmp27_;
		GtkTextIter _tmp28_;
		_tmp26_ = self->priv->_doc;
		_tmp27_ = start_iter;
		_tmp28_ = end_iter;
		gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp26_, &_tmp27_, &_tmp28_);
		if (refresh_simple_list) {
			*refresh_simple_list = _vala_refresh_simple_list;
		}
		return;
	}
	if (action_type == STRUCT_ACTION_COPY) {
		_tmp29_ = TRUE;
	} else {
		_tmp29_ = action_type == STRUCT_ACTION_CUT;
	}
	if (_tmp29_) {
		gchar* data = NULL;
		Document* _tmp30_;
		GtkTextIter _tmp31_;
		GtkTextIter _tmp32_;
		gchar* _tmp33_;
		GtkClipboard* clipboard = NULL;
		GtkClipboard* _tmp34_;
		GtkClipboard* _tmp35_;
		GtkClipboard* _tmp36_;
		const gchar* _tmp37_;
		_tmp30_ = self->priv->_doc;
		_tmp31_ = start_iter;
		_tmp32_ = end_iter;
		_tmp33_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp30_, &_tmp31_, &_tmp32_, FALSE);
		data = _tmp33_;
		_tmp34_ = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
		_tmp35_ = _g_object_ref0 (_tmp34_);
		clipboard = _tmp35_;
		_tmp36_ = clipboard;
		_tmp37_ = data;
		gtk_clipboard_set_text (_tmp36_, _tmp37_, -1);
		_g_object_unref0 (clipboard);
		_g_free0 (data);
	}
	if (action_type == STRUCT_ACTION_DELETE) {
		_tmp38_ = TRUE;
	} else {
		_tmp38_ = action_type == STRUCT_ACTION_CUT;
	}
	if (_tmp38_) {
		Document* _tmp39_;
		Document* _tmp40_;
		Document* _tmp41_;
		StructureModel* _tmp42_;
		GtkTreeIter _tmp43_;
		_tmp39_ = self->priv->_doc;
		gtk_text_buffer_begin_user_action ((GtkTextBuffer*) _tmp39_);
		_tmp40_ = self->priv->_doc;
		gtk_text_buffer_delete ((GtkTextBuffer*) _tmp40_, &start_iter, &end_iter);
		_tmp41_ = self->priv->_doc;
		gtk_text_buffer_end_user_action ((GtkTextBuffer*) _tmp41_);
		_tmp42_ = self->priv->_model;
		_tmp43_ = *tree_iter;
		structure_model_delete (_tmp42_, &_tmp43_);
		_vala_refresh_simple_list = TRUE;
	}
	if (refresh_simple_list) {
		*refresh_simple_list = _vala_refresh_simple_list;
	}
}

static gboolean
document_structure_comment_item (DocumentStructure* self,
                                 GtkTreeIter* tree_iter)
{
	StructType type = 0;
	GtkTextMark* start_mark = NULL;
	GtkTextMark* end_mark = NULL;
	StructureModel* _tmp0_;
	GtkTreeIter _tmp1_;
	StructType _tmp2_ = 0;
	GtkTextMark* _tmp3_ = NULL;
	GtkTextMark* _tmp4_ = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextIter _tmp5_ = {0};
	gboolean end_iter_set = FALSE;
	Document* _tmp6_;
	GtkTextMark* _tmp7_;
	GtkTextIter _tmp8_ = {0};
	GtkTextMark* _tmp9_;
	GtkTreeIter* next_section_iter = NULL;
	gboolean go_one_line_backward = FALSE;
	GtkTreeIter* _tmp25_;
	Document* _tmp35_;
	GtkTextIter _tmp36_;
	GtkTextIter _tmp37_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tree_iter != NULL, FALSE);
	start_mark = NULL;
	end_mark = NULL;
	_tmp0_ = self->priv->_model;
	_tmp1_ = *tree_iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, STRUCT_COLUMN_TYPE, &_tmp2_, STRUCT_COLUMN_START_MARK, &_tmp3_, STRUCT_COLUMN_END_MARK, &_tmp4_, -1, -1);
	type = _tmp2_;
	_g_object_unref0 (start_mark);
	start_mark = _tmp3_;
	_g_object_unref0 (end_mark);
	end_mark = _tmp4_;
	end_iter = _tmp5_;
	end_iter_set = FALSE;
	_tmp6_ = self->priv->_doc;
	_tmp7_ = start_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp6_, &_tmp8_, _tmp7_);
	start_iter = _tmp8_;
	_tmp9_ = end_mark;
	if (_tmp9_ != NULL) {
		Document* _tmp10_;
		GtkTextMark* _tmp11_;
		GtkTextIter _tmp12_ = {0};
		_tmp10_ = self->priv->_doc;
		_tmp11_ = end_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp10_, &_tmp12_, _tmp11_);
		end_iter = _tmp12_;
		end_iter_set = TRUE;
	}
	if (!structure_is_section (type)) {
		Document* _tmp13_;
		GtkTextIter _tmp14_;
		GtkTextIter _tmp15_;
		_tmp13_ = self->priv->_doc;
		_tmp14_ = start_iter;
		_tmp15_ = end_iter;
		document_comment_between (_tmp13_, &_tmp14_, &_tmp15_, end_iter_set);
		result = TRUE;
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		return result;
	}
	next_section_iter = NULL;
	{
		GtkTreeIter* _tmp16_ = NULL;
		StructureModel* _tmp17_;
		GtkTreeIter _tmp18_;
		GtkTreeIter* _tmp19_;
		GtkTreeIter* _tmp21_;
		_tmp17_ = self->priv->_model;
		_tmp18_ = *tree_iter;
		_tmp19_ = structure_model_get_next_sibling_or_parent (_tmp17_, &_tmp18_, &_inner_error0_);
		_tmp16_ = _tmp19_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp20_ = FALSE;
			if (_inner_error0_->domain == STRUCT_ERROR) {
				goto __catch0_struct_error;
			}
			__vala_GtkTreeIter_free0 (next_section_iter);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp20_;
		}
		_tmp21_ = _tmp16_;
		_tmp16_ = NULL;
		__vala_GtkTreeIter_free0 (next_section_iter);
		next_section_iter = _tmp21_;
		__vala_GtkTreeIter_free0 (_tmp16_);
	}
	goto __finally0;
	__catch0_struct_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		const gchar* _tmp23_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		g_warning ("document_structure.vala:848: Structure: get next sibling or parent: %s", _tmp23_);
		result = FALSE;
		_g_error_free0 (e);
		__vala_GtkTreeIter_free0 (next_section_iter);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp24_ = FALSE;
		__vala_GtkTreeIter_free0 (next_section_iter);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp24_;
	}
	go_one_line_backward = TRUE;
	_tmp25_ = next_section_iter;
	if (_tmp25_ == NULL) {
		gboolean end_of_file = FALSE;
		gboolean _tmp26_ = FALSE;
		GtkTextIter _tmp27_ = {0};
		document_structure_get_end_document_iter (self, &_tmp26_, &_tmp27_);
		end_of_file = _tmp26_;
		end_iter = _tmp27_;
		end_iter_set = TRUE;
		go_one_line_backward = !end_of_file;
	} else {
		StructureModel* _tmp28_;
		GtkTreeIter* _tmp29_;
		GtkTreeIter _tmp30_;
		GtkTextMark* _tmp31_ = NULL;
		Document* _tmp32_;
		GtkTextMark* _tmp33_;
		GtkTextIter _tmp34_ = {0};
		_tmp28_ = self->priv->_model;
		_tmp29_ = next_section_iter;
		_tmp30_ = *_tmp29_;
		gtk_tree_model_get ((GtkTreeModel*) _tmp28_, &_tmp30_, STRUCT_COLUMN_START_MARK, &_tmp31_, -1, -1);
		_g_object_unref0 (end_mark);
		end_mark = _tmp31_;
		_tmp32_ = self->priv->_doc;
		_tmp33_ = end_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp32_, &_tmp34_, _tmp33_);
		end_iter = _tmp34_;
		end_iter_set = TRUE;
	}
	if (go_one_line_backward) {
		if (!gtk_text_iter_backward_line (&end_iter)) {
			end_iter_set = FALSE;
		}
	}
	_tmp35_ = self->priv->_doc;
	_tmp36_ = start_iter;
	_tmp37_ = end_iter;
	document_comment_between (_tmp35_, &_tmp36_, &_tmp37_, end_iter_set);
	result = TRUE;
	__vala_GtkTreeIter_free0 (next_section_iter);
	_g_object_unref0 (end_mark);
	_g_object_unref0 (start_mark);
	return result;
}

static gboolean
document_structure_get_exact_item_bounds (DocumentStructure* self,
                                          GtkTreeIter* tree_iter,
                                          GtkTextIter* start_iter,
                                          GtkTextIter* end_iter)
{
	GtkTextIter _vala_start_iter = {0};
	GtkTextIter _vala_end_iter = {0};
	StructType item_type = 0;
	GtkTextMark* start_mark = NULL;
	GtkTextMark* end_mark = NULL;
	gchar* item_contents = NULL;
	StructureModel* _tmp0_;
	GtkTreeIter _tmp1_;
	StructType _tmp2_ = 0;
	GtkTextMark* _tmp3_ = NULL;
	GtkTextMark* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	Document* _tmp6_;
	GtkTextMark* _tmp7_;
	GtkTextIter _tmp8_ = {0};
	gboolean found = FALSE;
	const gchar* _tmp9_;
	GtkTextIter _tmp10_;
	GtkTextIter _tmp11_ = {0};
	gboolean _tmp12_;
	GtkTextMark* _tmp35_;
	GtkTextIter end_env_iter = {0};
	Document* _tmp36_;
	GtkTextMark* _tmp37_;
	GtkTextIter _tmp38_ = {0};
	const gchar* _tmp39_;
	GtkTextIter _tmp40_;
	GtkTextIter _tmp41_ = {0};
	gboolean _tmp42_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tree_iter != NULL, FALSE);
	start_mark = NULL;
	end_mark = NULL;
	item_contents = NULL;
	_tmp0_ = self->priv->_model;
	_tmp1_ = *tree_iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, STRUCT_COLUMN_TYPE, &_tmp2_, STRUCT_COLUMN_START_MARK, &_tmp3_, STRUCT_COLUMN_END_MARK, &_tmp4_, STRUCT_COLUMN_TEXT, &_tmp5_, -1, -1);
	item_type = _tmp2_;
	_g_object_unref0 (start_mark);
	start_mark = _tmp3_;
	_g_object_unref0 (end_mark);
	end_mark = _tmp4_;
	_g_free0 (item_contents);
	item_contents = _tmp5_;
	_tmp6_ = self->priv->_doc;
	_tmp7_ = start_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp6_, &_tmp8_, _tmp7_);
	_vala_start_iter = _tmp8_;
	_tmp9_ = item_contents;
	_tmp10_ = _vala_start_iter;
	_tmp12_ = document_structure_get_low_level_item_bounds (self, item_type, _tmp9_, &_tmp10_, TRUE, &_tmp11_);
	_vala_end_iter = _tmp11_;
	found = _tmp12_;
	if (!found) {
		result = FALSE;
		_g_free0 (item_contents);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		if (start_iter) {
			*start_iter = _vala_start_iter;
		}
		if (end_iter) {
			*end_iter = _vala_end_iter;
		}
		return result;
	}
	if (structure_is_section (item_type)) {
		GtkTreeIter* next_section_iter = NULL;
		GtkTreeIter* _tmp22_;
		StructureModel* _tmp24_;
		GtkTreeIter* _tmp25_;
		GtkTreeIter _tmp26_;
		StructType _tmp27_ = 0;
		GtkTextMark* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		Document* _tmp30_;
		GtkTextMark* _tmp31_;
		GtkTextIter _tmp32_ = {0};
		const gchar* _tmp33_;
		GtkTextIter _tmp34_;
		next_section_iter = NULL;
		{
			GtkTreeIter* _tmp13_ = NULL;
			StructureModel* _tmp14_;
			GtkTreeIter _tmp15_;
			GtkTreeIter* _tmp16_;
			GtkTreeIter* _tmp18_;
			_tmp14_ = self->priv->_model;
			_tmp15_ = *tree_iter;
			_tmp16_ = structure_model_get_next_sibling_or_parent (_tmp14_, &_tmp15_, &_inner_error0_);
			_tmp13_ = _tmp16_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp17_ = FALSE;
				if (_inner_error0_->domain == STRUCT_ERROR) {
					goto __catch0_struct_error;
				}
				__vala_GtkTreeIter_free0 (next_section_iter);
				_g_free0 (item_contents);
				_g_object_unref0 (end_mark);
				_g_object_unref0 (start_mark);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp17_;
			}
			_tmp18_ = _tmp13_;
			_tmp13_ = NULL;
			__vala_GtkTreeIter_free0 (next_section_iter);
			next_section_iter = _tmp18_;
			__vala_GtkTreeIter_free0 (_tmp13_);
		}
		goto __finally0;
		__catch0_struct_error:
		{
			GError* e = NULL;
			GError* _tmp19_;
			const gchar* _tmp20_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp19_ = e;
			_tmp20_ = _tmp19_->message;
			g_warning ("document_structure.vala:923: Structure: get next sibling or parent: %s", _tmp20_);
			result = FALSE;
			_g_error_free0 (e);
			__vala_GtkTreeIter_free0 (next_section_iter);
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			if (start_iter) {
				*start_iter = _vala_start_iter;
			}
			if (end_iter) {
				*end_iter = _vala_end_iter;
			}
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp21_ = FALSE;
			__vala_GtkTreeIter_free0 (next_section_iter);
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp21_;
		}
		_tmp22_ = next_section_iter;
		if (_tmp22_ == NULL) {
			GtkTextIter _tmp23_ = {0};
			document_structure_get_end_document_iter (self, NULL, &_tmp23_);
			_vala_end_iter = _tmp23_;
			result = TRUE;
			__vala_GtkTreeIter_free0 (next_section_iter);
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			if (start_iter) {
				*start_iter = _vala_start_iter;
			}
			if (end_iter) {
				*end_iter = _vala_end_iter;
			}
			return result;
		}
		_tmp24_ = self->priv->_model;
		_tmp25_ = next_section_iter;
		_tmp26_ = *_tmp25_;
		gtk_tree_model_get ((GtkTreeModel*) _tmp24_, &_tmp26_, STRUCT_COLUMN_TYPE, &_tmp27_, STRUCT_COLUMN_START_MARK, &_tmp28_, STRUCT_COLUMN_TEXT, &_tmp29_, -1, -1);
		item_type = _tmp27_;
		_g_object_unref0 (start_mark);
		start_mark = _tmp28_;
		_g_free0 (item_contents);
		item_contents = _tmp29_;
		_tmp30_ = self->priv->_doc;
		_tmp31_ = start_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp30_, &_tmp32_, _tmp31_);
		_vala_end_iter = _tmp32_;
		_tmp33_ = item_contents;
		_tmp34_ = _vala_end_iter;
		result = document_structure_get_low_level_item_bounds (self, item_type, _tmp33_, &_tmp34_, TRUE, NULL);
		__vala_GtkTreeIter_free0 (next_section_iter);
		_g_free0 (item_contents);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		if (start_iter) {
			*start_iter = _vala_start_iter;
		}
		if (end_iter) {
			*end_iter = _vala_end_iter;
		}
		return result;
	} else {
		if (structure_is_common_type (item_type)) {
			result = TRUE;
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			if (start_iter) {
				*start_iter = _vala_start_iter;
			}
			if (end_iter) {
				*end_iter = _vala_end_iter;
			}
			return result;
		}
	}
	_tmp35_ = end_mark;
	if (_tmp35_ == NULL) {
		result = FALSE;
		_g_free0 (item_contents);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		if (start_iter) {
			*start_iter = _vala_start_iter;
		}
		if (end_iter) {
			*end_iter = _vala_end_iter;
		}
		return result;
	}
	_tmp36_ = self->priv->_doc;
	_tmp37_ = end_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp36_, &_tmp38_, _tmp37_);
	end_env_iter = _tmp38_;
	_tmp39_ = item_contents;
	_tmp40_ = end_env_iter;
	_tmp42_ = document_structure_get_low_level_item_bounds (self, item_type, _tmp39_, &_tmp40_, FALSE, &_tmp41_);
	_vala_end_iter = _tmp41_;
	result = _tmp42_;
	_g_free0 (item_contents);
	_g_object_unref0 (end_mark);
	_g_object_unref0 (start_mark);
	if (start_iter) {
		*start_iter = _vala_start_iter;
	}
	if (end_iter) {
		*end_iter = _vala_end_iter;
	}
	return result;
}

static gboolean
_int_equal (const gint * s1,
            const gint * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static gboolean
document_structure_get_low_level_item_bounds (DocumentStructure* self,
                                              StructType item_type,
                                              const gchar* item_contents,
                                              GtkTextIter* start_match_iter,
                                              gboolean is_start,
                                              GtkTextIter* end_match_iter)
{
	GtkTextIter _vala_end_match_iter = {0};
	GtkTextIter _tmp0_ = {0};
	gchar* line = NULL;
	GtkTextIter _tmp1_;
	gchar* _tmp2_;
	gint start_index = 0;
	StructType* low_level_type = NULL;
	gchar* contents = NULL;
	gint* start_match_index = NULL;
	gint* end_match_index = NULL;
	gboolean found = FALSE;
	const gchar* _tmp3_;
	StructType* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint* _tmp6_ = NULL;
	gint* _tmp7_ = NULL;
	gboolean _tmp8_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp11_;
	StructType* _tmp13_;
	const gchar* _tmp14_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item_contents != NULL, FALSE);
	g_return_val_if_fail (start_match_iter != NULL, FALSE);
	_vala_end_match_iter = _tmp0_;
	_tmp1_ = *start_match_iter;
	_tmp2_ = document_structure_get_line_contents_at_iter (self, &_tmp1_);
	line = _tmp2_;
	start_index = gtk_text_iter_get_line_index (start_match_iter);
	_tmp3_ = line;
	_tmp8_ = document_structure_search_low_level_item (self, _tmp3_, start_index, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
	_g_free0 (low_level_type);
	low_level_type = _tmp4_;
	_g_free0 (contents);
	contents = _tmp5_;
	_g_free0 (start_match_index);
	start_match_index = _tmp6_;
	_g_free0 (end_match_index);
	end_match_index = _tmp7_;
	found = _tmp8_;
	if (!found) {
		_tmp9_ = TRUE;
	} else {
		gint* _tmp10_;
		_tmp10_ = start_match_index;
		_tmp9_ = _int_equal (&start_index, _tmp10_) != TRUE;
	}
	if (_tmp9_) {
		result = FALSE;
		_g_free0 (end_match_index);
		_g_free0 (start_match_index);
		_g_free0 (contents);
		_g_free0 (low_level_type);
		_g_free0 (line);
		if (end_match_iter) {
			*end_match_iter = _vala_end_match_iter;
		}
		return result;
	}
	_tmp11_ = contents;
	if (_tmp11_ == NULL) {
		gchar* _tmp12_;
		_tmp12_ = g_strdup ("");
		_g_free0 (contents);
		contents = _tmp12_;
	}
	_tmp13_ = low_level_type;
	_tmp14_ = contents;
	if (document_structure_same_items (self, item_type, item_contents, *_tmp13_, _tmp14_, is_start)) {
		GtkTextIter _tmp15_;
		gint* _tmp16_;
		_tmp15_ = *start_match_iter;
		_vala_end_match_iter = _tmp15_;
		_tmp16_ = end_match_index;
		gtk_text_iter_set_line_index (&_vala_end_match_iter, *_tmp16_);
		result = TRUE;
		_g_free0 (end_match_index);
		_g_free0 (start_match_index);
		_g_free0 (contents);
		_g_free0 (low_level_type);
		_g_free0 (line);
		if (end_match_iter) {
			*end_match_iter = _vala_end_match_iter;
		}
		return result;
	}
	result = FALSE;
	_g_free0 (end_match_index);
	_g_free0 (start_match_index);
	_g_free0 (contents);
	_g_free0 (low_level_type);
	_g_free0 (line);
	if (end_match_iter) {
		*end_match_iter = _vala_end_match_iter;
	}
	return result;
}

static gboolean
document_structure_same_items (DocumentStructure* self,
                               StructType item_type,
                               const gchar* item_contents,
                               StructType item_found_type,
                               const gchar* item_found_contents,
                               gboolean start)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item_contents != NULL, FALSE);
	g_return_val_if_fail (item_found_contents != NULL, FALSE);
	if (structure_is_common_type (item_found_type)) {
		gboolean same_type = FALSE;
		gboolean same_contents = FALSE;
		gboolean _tmp0_ = FALSE;
		same_type = item_type == item_found_type;
		same_contents = g_strcmp0 (item_contents, item_found_contents) == 0;
		if (same_type) {
			_tmp0_ = same_contents;
		} else {
			_tmp0_ = FALSE;
		}
		result = _tmp0_;
		return result;
	}
	if (item_type == STRUCT_TYPE_FIGURE) {
		if (start) {
			result = item_found_type == STRUCT_TYPE_BEGIN_FIGURE;
			return result;
		} else {
			result = item_found_type == STRUCT_TYPE_END_FIGURE;
			return result;
		}
	}
	if (item_type == STRUCT_TYPE_TABLE) {
		if (start) {
			result = item_found_type == STRUCT_TYPE_BEGIN_TABLE;
			return result;
		} else {
			result = item_found_type == STRUCT_TYPE_END_TABLE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

static void
document_structure_get_end_document_iter (DocumentStructure* self,
                                          gboolean* end_of_file,
                                          GtkTextIter* result)
{
	gboolean _vala_end_of_file = FALSE;
	GtkTextMark* _tmp0_;
	GtkTextIter eof_iter = {0};
	Document* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_end_document_mark;
	if (_tmp0_ != NULL) {
		GtkTextIter end_document_iter = {0};
		Document* _tmp1_;
		GtkTextMark* _tmp2_;
		GtkTextIter _tmp3_ = {0};
		_vala_end_of_file = FALSE;
		_tmp1_ = self->priv->_doc;
		_tmp2_ = self->priv->_end_document_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp1_, &_tmp3_, _tmp2_);
		end_document_iter = _tmp3_;
		*result = end_document_iter;
		if (end_of_file) {
			*end_of_file = _vala_end_of_file;
		}
		return;
	}
	_vala_end_of_file = TRUE;
	_tmp4_ = self->priv->_doc;
	gtk_text_buffer_get_end_iter ((GtkTextBuffer*) _tmp4_, &_tmp5_);
	eof_iter = _tmp5_;
	*result = eof_iter;
	if (end_of_file) {
		*end_of_file = _vala_end_of_file;
	}
	return;
}

static void
document_structure_backward_indentation (DocumentStructure* self,
                                         GtkTextIter* iter)
{
	gint line_num = 0;
	GtkTextIter begin_line_iter = {0};
	Document* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	gchar* text_between = NULL;
	Document* _tmp2_;
	GtkTextIter _tmp3_;
	GtkTextIter _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	if (gtk_text_iter_starts_line (iter)) {
		return;
	}
	line_num = gtk_text_iter_get_line (iter);
	_tmp0_ = self->priv->_doc;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) _tmp0_, &_tmp1_, line_num);
	begin_line_iter = _tmp1_;
	_tmp2_ = self->priv->_doc;
	_tmp3_ = begin_line_iter;
	_tmp4_ = *iter;
	_tmp5_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp2_, &_tmp3_, &_tmp4_, FALSE);
	text_between = _tmp5_;
	_tmp6_ = text_between;
	_tmp7_ = string_strip (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strcmp0 (_tmp8_, "") == 0;
	_g_free0 (_tmp8_);
	if (_tmp9_) {
		GtkTextIter _tmp10_;
		_tmp10_ = begin_line_iter;
		*iter = _tmp10_;
	}
	_g_free0 (text_between);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
document_structure_shift_item (DocumentStructure* self,
                               GtkTreeIter* tree_iter,
                               gboolean shift_right,
                               gboolean* doc_modified)
{
	gboolean _vala_doc_modified = FALSE;
	StructType type = 0;
	GtkTextMark* mark = NULL;
	StructureModel* _tmp0_;
	GtkTreeIter _tmp1_;
	StructType _tmp2_ = 0;
	GtkTextMark* _tmp3_ = NULL;
	GtkTextIter text_iter = {0};
	Document* _tmp4_;
	GtkTextMark* _tmp5_;
	GtkTextIter _tmp6_ = {0};
	gchar* line = NULL;
	GtkTextIter _tmp7_;
	gchar* _tmp8_;
	gint backslash_index = 0;
	const gchar* _tmp9_;
	gint after_backslash_index = 0;
	gchar* markup_name = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	StructType* markup_type = NULL;
	const gchar* _tmp13_;
	StructType* _tmp14_;
	StructType* _tmp15_;
	StructType markup_type_hack = 0;
	StructType* _tmp16_;
	gboolean with_star = FALSE;
	const gchar* _tmp17_;
	StructType new_type = 0;
	gchar* new_markup_name = NULL;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	GtkTextIter begin_markup_name_iter = {0};
	GtkTextIter _tmp22_;
	GtkTextIter end_markup_name_iter = {0};
	GtkTextIter _tmp23_;
	const gchar* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	Document* _tmp27_;
	Document* _tmp28_;
	const gchar* _tmp29_;
	gint nb_children = 0;
	StructureModel* _tmp30_;
	GtkTreeIter _tmp31_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tree_iter != NULL, FALSE);
	_vala_doc_modified = FALSE;
	_tmp0_ = self->priv->_model;
	_tmp1_ = *tree_iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, STRUCT_COLUMN_TYPE, &_tmp2_, STRUCT_COLUMN_START_MARK, &_tmp3_, -1);
	type = _tmp2_;
	_g_object_unref0 (mark);
	mark = _tmp3_;
	if (shift_right) {
		g_return_val_if_fail (type != STRUCT_TYPE_SUBPARAGRAPH, FALSE);
	} else {
		g_return_val_if_fail (type != STRUCT_TYPE_PART, FALSE);
	}
	if (!structure_is_section (type)) {
		result = TRUE;
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	_tmp4_ = self->priv->_doc;
	_tmp5_ = mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp4_, &_tmp6_, _tmp5_);
	text_iter = _tmp6_;
	_tmp7_ = text_iter;
	_tmp8_ = document_structure_get_line_contents_at_iter (self, &_tmp7_);
	line = _tmp8_;
	backslash_index = gtk_text_iter_get_line_index (&text_iter);
	_tmp9_ = line;
	if (string_get (_tmp9_, (glong) backslash_index) != '\\') {
		result = FALSE;
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	after_backslash_index = backslash_index + 1;
	_tmp10_ = line;
	_tmp11_ = document_structure_get_markup_name (self, _tmp10_, after_backslash_index, NULL);
	markup_name = _tmp11_;
	_tmp12_ = markup_name;
	if (_tmp12_ == NULL) {
		result = FALSE;
		_g_free0 (markup_name);
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	_tmp13_ = markup_name;
	_tmp14_ = document_structure_get_markup_type (self, _tmp13_);
	markup_type = _tmp14_;
	_tmp15_ = markup_type;
	if (_tmp15_ == NULL) {
		result = FALSE;
		_g_free0 (markup_type);
		_g_free0 (markup_name);
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	_tmp16_ = markup_type;
	markup_type_hack = *_tmp16_;
	if (((gint) type) != ((gint) markup_type_hack)) {
		result = FALSE;
		_g_free0 (markup_type);
		_g_free0 (markup_name);
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	_tmp17_ = markup_name;
	with_star = g_str_has_suffix (_tmp17_, "*");
	if (shift_right) {
		new_type = type + 1;
	} else {
		new_type = type - 1;
	}
	_tmp18_ = document_structure_get_section_name_from_type (self, new_type);
	new_markup_name = _tmp18_;
	_tmp19_ = new_markup_name;
	g_return_val_if_fail (_tmp19_ != NULL, FALSE);
	if (with_star) {
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp20_ = new_markup_name;
		_tmp21_ = g_strconcat (_tmp20_, "*", NULL);
		_g_free0 (new_markup_name);
		new_markup_name = _tmp21_;
	}
	_tmp22_ = text_iter;
	begin_markup_name_iter = _tmp22_;
	gtk_text_iter_set_line_index (&begin_markup_name_iter, after_backslash_index);
	_tmp23_ = text_iter;
	end_markup_name_iter = _tmp23_;
	_tmp24_ = markup_name;
	_tmp25_ = strlen (_tmp24_);
	_tmp26_ = _tmp25_;
	gtk_text_iter_set_line_index (&end_markup_name_iter, after_backslash_index + _tmp26_);
	_tmp27_ = self->priv->_doc;
	gtk_text_buffer_delete ((GtkTextBuffer*) _tmp27_, &begin_markup_name_iter, &end_markup_name_iter);
	_tmp28_ = self->priv->_doc;
	_tmp29_ = new_markup_name;
	document_insert (_tmp28_, &begin_markup_name_iter, _tmp29_, -1);
	_vala_doc_modified = TRUE;
	_tmp30_ = self->priv->_model;
	_tmp31_ = *tree_iter;
	nb_children = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp30_, &_tmp31_);
	{
		gint child_num = 0;
		child_num = 0;
		{
			gboolean _tmp32_ = FALSE;
			_tmp32_ = TRUE;
			while (TRUE) {
				GtkTreeIter child_iter = {0};
				gboolean child_iter_set = FALSE;
				StructureModel* _tmp34_;
				GtkTreeIter _tmp35_;
				GtkTreeIter _tmp36_ = {0};
				gboolean _tmp37_;
				GtkTreeIter _tmp38_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = child_num;
					child_num = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				if (!(child_num < nb_children)) {
					break;
				}
				_tmp34_ = self->priv->_model;
				_tmp35_ = *tree_iter;
				_tmp37_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp34_, &_tmp36_, &_tmp35_, child_num);
				child_iter = _tmp36_;
				child_iter_set = _tmp37_;
				g_return_val_if_fail (child_iter_set, FALSE);
				_tmp38_ = child_iter;
				if (!document_structure_shift_item (self, &_tmp38_, shift_right, NULL)) {
					result = FALSE;
					_g_free0 (new_markup_name);
					_g_free0 (markup_type);
					_g_free0 (markup_name);
					_g_free0 (line);
					_g_object_unref0 (mark);
					if (doc_modified) {
						*doc_modified = _vala_doc_modified;
					}
					return result;
				}
			}
		}
	}
	result = TRUE;
	_g_free0 (new_markup_name);
	_g_free0 (markup_type);
	_g_free0 (markup_name);
	_g_free0 (line);
	_g_object_unref0 (mark);
	if (doc_modified) {
		*doc_modified = _vala_doc_modified;
	}
	return result;
}

static gchar*
document_structure_get_section_name_from_type (DocumentStructure* self,
                                               StructType type)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = document_structure__section_names;
	_tmp0__length1 = document_structure__section_names_length1;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar* _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		gchar* _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		gchar* _tmp11_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar* _tmp15_;
		_tmp1_ = g_new0 (gchar*, 7 + 1);
		document_structure__section_names = (_vala_array_free (document_structure__section_names, document_structure__section_names_length1, (GDestroyNotify) g_free), NULL);
		document_structure__section_names = _tmp1_;
		document_structure__section_names_length1 = 7;
		_document_structure__section_names_size_ = document_structure__section_names_length1;
		_tmp2_ = document_structure__section_names;
		_tmp2__length1 = document_structure__section_names_length1;
		_tmp3_ = g_strdup ("part");
		_g_free0 (_tmp2_[STRUCT_TYPE_PART]);
		_tmp2_[STRUCT_TYPE_PART] = _tmp3_;
		_tmp4_ = document_structure__section_names;
		_tmp4__length1 = document_structure__section_names_length1;
		_tmp5_ = g_strdup ("chapter");
		_g_free0 (_tmp4_[STRUCT_TYPE_CHAPTER]);
		_tmp4_[STRUCT_TYPE_CHAPTER] = _tmp5_;
		_tmp6_ = document_structure__section_names;
		_tmp6__length1 = document_structure__section_names_length1;
		_tmp7_ = g_strdup ("section");
		_g_free0 (_tmp6_[STRUCT_TYPE_SECTION]);
		_tmp6_[STRUCT_TYPE_SECTION] = _tmp7_;
		_tmp8_ = document_structure__section_names;
		_tmp8__length1 = document_structure__section_names_length1;
		_tmp9_ = g_strdup ("subsection");
		_g_free0 (_tmp8_[STRUCT_TYPE_SUBSECTION]);
		_tmp8_[STRUCT_TYPE_SUBSECTION] = _tmp9_;
		_tmp10_ = document_structure__section_names;
		_tmp10__length1 = document_structure__section_names_length1;
		_tmp11_ = g_strdup ("subsubsection");
		_g_free0 (_tmp10_[STRUCT_TYPE_SUBSUBSECTION]);
		_tmp10_[STRUCT_TYPE_SUBSUBSECTION] = _tmp11_;
		_tmp12_ = document_structure__section_names;
		_tmp12__length1 = document_structure__section_names_length1;
		_tmp13_ = g_strdup ("paragraph");
		_g_free0 (_tmp12_[STRUCT_TYPE_PARAGRAPH]);
		_tmp12_[STRUCT_TYPE_PARAGRAPH] = _tmp13_;
		_tmp14_ = document_structure__section_names;
		_tmp14__length1 = document_structure__section_names_length1;
		_tmp15_ = g_strdup ("subparagraph");
		_g_free0 (_tmp14_[STRUCT_TYPE_SUBPARAGRAPH]);
		_tmp14_[STRUCT_TYPE_SUBPARAGRAPH] = _tmp15_;
	}
	g_return_val_if_fail (structure_is_section (type), NULL);
	_tmp16_ = document_structure__section_names;
	_tmp16__length1 = document_structure__section_names_length1;
	_tmp17_ = _tmp16_[type];
	_tmp18_ = g_strdup (_tmp17_);
	result = _tmp18_;
	return result;
}

gboolean
document_structure_get_parsing_done (DocumentStructure* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_parsing_done;
	return result;
}

static void
document_structure_set_parsing_done (DocumentStructure* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = document_structure_get_parsing_done (self);
	if (old_value != value) {
		self->priv->_parsing_done = value;
		g_object_notify_by_pspec ((GObject *) self, document_structure_properties[DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY]);
	}
}

static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
	return g_boxed_copy (gtk_tree_path_get_type (), self);
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
	return self ? _vala_GtkTreePath_copy (self) : NULL;
}

static void
document_structure_env_data_copy (const DocumentStructureEnvData* self,
                                  DocumentStructureEnvData* dest)
{
	GtkTreePath* _tmp0_;
	GtkTreePath* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).path;
	_tmp1_ = __vala_GtkTreePath_copy0 (_tmp0_);
	__vala_GtkTreePath_free0 ((*dest).path);
	(*dest).path = _tmp1_;
	(*dest).type = (*self).type;
	_tmp2_ = (*self).first_caption;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).first_caption);
	(*dest).first_caption = _tmp3_;
}

static void
document_structure_env_data_destroy (DocumentStructureEnvData* self)
{
	__vala_GtkTreePath_free0 ((*self).path);
	_g_free0 ((*self).first_caption);
}

static DocumentStructureEnvData*
document_structure_env_data_dup (const DocumentStructureEnvData* self)
{
	DocumentStructureEnvData* dup;
	dup = g_new0 (DocumentStructureEnvData, 1);
	document_structure_env_data_copy (self, dup);
	return dup;
}

static void
document_structure_env_data_free (DocumentStructureEnvData* self)
{
	document_structure_env_data_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
document_structure_env_data_get_type_once (void)
{
	GType document_structure_env_data_type_id;
	document_structure_env_data_type_id = g_boxed_type_register_static ("DocumentStructureEnvData", (GBoxedCopyFunc) document_structure_env_data_dup, (GBoxedFreeFunc) document_structure_env_data_free);
	return document_structure_env_data_type_id;
}

static GType
document_structure_env_data_get_type (void)
{
	static volatile gsize document_structure_env_data_type_id__volatile = 0;
	if (g_once_init_enter (&document_structure_env_data_type_id__volatile)) {
		GType document_structure_env_data_type_id;
		document_structure_env_data_type_id = document_structure_env_data_get_type_once ();
		g_once_init_leave (&document_structure_env_data_type_id__volatile, document_structure_env_data_type_id);
	}
	return document_structure_env_data_type_id__volatile;
}

static void
document_structure_class_init (DocumentStructureClass * klass,
                               gpointer klass_data)
{
	document_structure_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DocumentStructure_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_document_structure_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_document_structure_set_property;
	G_OBJECT_CLASS (klass)->finalize = document_structure_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY, document_structure_properties[DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY] = g_param_spec_boolean ("parsing-done", "parsing-done", "parsing-done", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
document_structure_instance_init (DocumentStructure * self,
                                  gpointer klass)
{
	self->priv = document_structure_get_instance_private (self);
	self->priv->_doc = NULL;
	self->priv->_nb_marks = 0;
	self->priv->_end_document_mark = NULL;
	self->priv->_model = NULL;
	self->priv->_in_verbatim_env = FALSE;
	self->priv->_last_env_data = NULL;
	self->priv->_start_parsing_line = 0;
	self->priv->_timer = NULL;
	self->priv->_idle_id = (guint) 0;
	self->priv->_parsing_done = FALSE;
}

static void
document_structure_finalize (GObject * obj)
{
	DocumentStructure * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT_STRUCTURE, DocumentStructure);
	if (self->priv->_idle_id != ((guint) 0)) {
		g_source_remove (self->priv->_idle_id);
		self->priv->_idle_id = (guint) 0;
	}
	_g_object_unref0 (self->priv->_end_document_mark);
	_g_object_unref0 (self->priv->_model);
	_document_structure_env_data_free0 (self->priv->_last_env_data);
	_g_timer_destroy0 (self->priv->_timer);
	G_OBJECT_CLASS (document_structure_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
document_structure_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DocumentStructureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_structure_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentStructure), 0, (GInstanceInitFunc) document_structure_instance_init, NULL };
	GType document_structure_type_id;
	document_structure_type_id = g_type_register_static (G_TYPE_OBJECT, "DocumentStructure", &g_define_type_info, 0);
	DocumentStructure_private_offset = g_type_add_instance_private (document_structure_type_id, sizeof (DocumentStructurePrivate));
	return document_structure_type_id;
}

GType
document_structure_get_type (void)
{
	static volatile gsize document_structure_type_id__volatile = 0;
	if (g_once_init_enter (&document_structure_type_id__volatile)) {
		GType document_structure_type_id;
		document_structure_type_id = document_structure_get_type_once ();
		g_once_init_leave (&document_structure_type_id__volatile, document_structure_type_id);
	}
	return document_structure_type_id__volatile;
}

static void
_vala_document_structure_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	DocumentStructure * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT_STRUCTURE, DocumentStructure);
	switch (property_id) {
		case DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY:
		g_value_set_boolean (value, document_structure_get_parsing_done (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_document_structure_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	DocumentStructure * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT_STRUCTURE, DocumentStructure);
	switch (property_id) {
		case DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY:
		document_structure_set_parsing_done (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

