/* document.c generated by valac 0.54.6, the Vala compiler
 * generated from document.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2020 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tepl/tepl.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksource.h>
#include <gtk/gtk.h>
#include <latexila.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <glib/gstdio.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;
enum  {
	DOCUMENT_0_PROPERTY,
	DOCUMENT_LOCATION_PROPERTY,
	DOCUMENT_READONLY_PROPERTY,
	DOCUMENT_PROJECT_ID_PROPERTY,
	DOCUMENT_NUM_PROPERTIES
};
static GParamSpec* document_properties[DOCUMENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block15Data Block15Data;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block16Data Block16Data;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))
typedef struct _Block17Data Block17Data;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

struct _DocumentPrivate {
	GFile* _location;
	gboolean _readonly;
	gint _project_id;
	gboolean backup_made;
	gchar* _etag;
	gchar* encoding;
	gboolean new_file;
	DocumentStructure* _structure;
};

struct _Block15Data {
	int _ref_count_;
	Document* self;
	GtkSourceCompletion* completion;
};

struct _Block16Data {
	int _ref_count_;
	Document* self;
	TeplInfoBar* infobar;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Block17Data {
	int _ref_count_;
	Document* self;
	TeplInfoBar* infobar;
};

static gint Document_private_offset;
static gpointer document_parent_class = NULL;

VALA_EXTERN GType document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
VALA_EXTERN GType document_tab_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
VALA_EXTERN GType document_structure_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentStructure, g_object_unref)
VALA_EXTERN Document* document_new (void);
VALA_EXTERN Document* document_construct (GType object_type);
static void __lambda65_ (Document* self);
static void document_update_syntax_highlighting (Document* self);
static void document_update_project_id (Document* self);
static void ___lambda65__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda66_ (Document* self);
static void ___lambda66__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                           gpointer self);
static void __lambda67_ (Document* self);
static void ___lambda67__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN void document_insert (Document* self,
                      GtkTextIter* iter,
                      const gchar* text,
                      gint len);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
VALA_EXTERN GType document_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
VALA_EXTERN DocumentView* document_tab_get_document_view (DocumentTab* self);
VALA_EXTERN GtkSourceCompletion* gtk_source_view_get_completion (GtkSourceView* self);
static gboolean __lambda59_ (Block15Data* _data15_);
static gboolean ___lambda59__gsource_func (gpointer self);
VALA_EXTERN void document_load (Document* self,
                    GFile* location);
VALA_EXTERN void document_set_location (Document* self,
                            GFile* value);
VALA_EXTERN void document_set_contents (Document* self,
                            const gchar* contents);
static gchar* document_to_utf8 (Document* self,
                         const gchar* text,
                         GError** error);
VALA_EXTERN void document_save (Document* self,
                    gboolean check_file_changed_on_disk,
                    gboolean force);
VALA_EXTERN GFile* document_get_location (Document* self);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void ____lambda38_ (Block16Data* _data16_,
                    gint response_id);
static void _____lambda38__gtk_info_bar_response (GtkInfoBar* _sender,
                                           gint response_id,
                                           gpointer self);
VALA_EXTERN GType project_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Project* project_dup (const Project* self);
VALA_EXTERN void project_free (Project* self);
VALA_EXTERN void project_copy (const Project* self,
                   Project* dest);
VALA_EXTERN void project_destroy (Project* self);
VALA_EXTERN gpointer projects_ref (gpointer instance);
VALA_EXTERN void projects_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_projects (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
VALA_EXTERN void value_set_projects (GValue* value,
                         gpointer v_object);
VALA_EXTERN void value_take_projects (GValue* value,
                          gpointer v_object);
VALA_EXTERN gpointer value_get_projects (const GValue* value);
VALA_EXTERN GType projects_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Projects, projects_unref)
VALA_EXTERN Projects* projects_get_default (void);
VALA_EXTERN GeeIterator* projects_iterator (Projects* self);
VALA_EXTERN void document_set_project_id (Document* self,
                              gint value);
VALA_EXTERN gchar* document_get_uri_for_display (Document* self);
VALA_EXTERN gboolean document_is_externally_modified (Document* self);
VALA_EXTERN void document_comment_selected_lines (Document* self);
VALA_EXTERN void document_comment_between (Document* self,
                               GtkTextIter* start_iter,
                               GtkTextIter* end_iter,
                               gboolean end_iter_set);
VALA_EXTERN void document_uncomment_selected_lines (Document* self);
VALA_EXTERN Project* document_get_project (Document* self);
VALA_EXTERN gint document_get_project_id (Document* self);
VALA_EXTERN Project* projects_get (Projects* self,
                       gint id);
VALA_EXTERN GFile* document_get_main_file (Document* self);
VALA_EXTERN gboolean document_is_main_file_a_tex_file (Document* self);
VALA_EXTERN DocumentStructure* document_get_structure (Document* self);
VALA_EXTERN DocumentStructure* document_structure_new (Document* doc);
VALA_EXTERN DocumentStructure* document_structure_construct (GType object_type,
                                                 Document* doc);
VALA_EXTERN void document_structure_parse (DocumentStructure* self);
VALA_EXTERN gboolean document_set_tmp_location (Document* self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void __lambda48_ (Block17Data* _data17_,
                  gint response_id);
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN GtkWindow* utils_get_toplevel_window (GtkWidget* widget);
VALA_EXTERN gboolean main_window_save_document (MainWindow* self,
                                    Document* doc,
                                    gboolean force_save_as);
static void ___lambda48__gtk_info_bar_response (GtkInfoBar* _sender,
                                         gint response_id,
                                         gpointer self);
VALA_EXTERN void document_set_metadata (Document* self,
                            const gchar* key,
                            const gchar* val);
VALA_EXTERN gboolean document_get_readonly (Document* self);
VALA_EXTERN void document_set_readonly (Document* self,
                            gboolean value);
static void document_finalize (GObject * obj);
static GType document_get_type_once (void);
static void _vala_document_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void _vala_document_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec);

VALA_EXTERN const gchar* ENCODINGS_CHARSETS[60];

static inline gpointer
document_get_instance_private (Document* self)
{
	return G_STRUCT_MEMBER_P (self, Document_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda65_ (Document* self)
{
	document_update_syntax_highlighting (self);
	document_update_project_id (self);
}

static void
___lambda65__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda65_ ((Document*) self);
}

static void
__lambda66_ (Document* self)
{
	self->priv->new_file = FALSE;
}

static void
___lambda66__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                      gpointer self)
{
	__lambda66_ ((Document*) self);
}

static void
__lambda67_ (Document* self)
{
	tepl_buffer_load_metadata_from_metadata_manager ((TeplBuffer*) self);
}

static void
___lambda67__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda67_ ((Document*) self);
}

Document*
document_construct (GType object_type)
{
	Document * self = NULL;
	GtkSourceLanguageManager* lm = NULL;
	GtkSourceLanguageManager* _tmp0_;
	GtkSourceLanguageManager* _tmp1_;
	GtkSourceLanguage* _tmp2_;
	TeplFile* _tmp3_;
	TeplFile* _tmp4_;
	self = (Document*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_source_language_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	lm = _tmp1_;
	_tmp2_ = gtk_source_language_manager_get_language (lm, "latex");
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, _tmp2_);
	g_signal_connect_object ((GObject*) self, "notify::location", (GCallback) ___lambda65__g_object_notify, self, 0);
	g_signal_connect_object ((GtkTextBuffer*) self, "changed", (GCallback) ___lambda66__gtk_text_buffer_changed, self, 0);
	latexila_buffer_setup ((TeplBuffer*) self);
	_tmp3_ = tepl_buffer_get_file ((TeplBuffer*) self);
	g_object_bind_property_with_closures ((GObject*) self, "location", (GObject*) _tmp3_, "location", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp4_ = tepl_buffer_get_file ((TeplBuffer*) self);
	g_signal_connect_object ((GObject*) _tmp4_, "notify::location", (GCallback) ___lambda67__g_object_notify, self, 0);
	_g_object_unref0 (lm);
	return self;
}

Document*
document_new (void)
{
	return document_construct (TYPE_DOCUMENT);
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		Document* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->completion);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static gboolean
__lambda59_ (Block15Data* _data15_)
{
	Document* self;
	GtkSourceCompletion* _tmp0_;
	gboolean result = FALSE;
	self = _data15_->self;
	_tmp0_ = _data15_->completion;
	if (_tmp0_ != NULL) {
		GtkSourceCompletion* _tmp1_;
		_tmp1_ = _data15_->completion;
		gtk_source_completion_unblock_interactive (_tmp1_);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda59__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda59_ (self);
	return result;
}

void
document_insert (Document* self,
                 GtkTextIter* iter,
                 const gchar* text,
                 gint len)
{
	Block15Data* _data15_;
	DocumentTab* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (text != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_data15_->completion = NULL;
	_tmp0_ = self->tab;
	if (_tmp0_ != NULL) {
		DocumentTab* _tmp1_;
		DocumentView* _tmp2_;
		DocumentView* _tmp3_;
		GtkSourceCompletion* _tmp4_;
		GtkSourceCompletion* _tmp5_;
		GtkSourceCompletion* _tmp6_;
		GtkSourceCompletion* _tmp7_;
		_tmp1_ = self->tab;
		_tmp2_ = document_tab_get_document_view (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (_data15_->completion);
		_data15_->completion = _tmp6_;
		_tmp7_ = _data15_->completion;
		gtk_source_completion_block_interactive (_tmp7_);
	}
	gtk_text_buffer_insert ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, tepl_buffer_get_type (), TeplBuffer), iter, text, len);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda59__gsource_func, block15_data_ref (_data15_), block15_data_unref);
	block15_data_unref (_data15_);
	_data15_ = NULL;
}

void
document_load (Document* self,
               GFile* location)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	document_set_location (self, location);
	{
		guint8* chars = NULL;
		gint chars_length1 = 0;
		gint _chars_size_ = 0;
		guint8* _tmp0_ = NULL;
		gsize _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gchar* text = NULL;
		guint8* _tmp3_;
		gint _tmp3__length1;
		const gchar* _tmp4_;
		GtkRecentManager* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		g_file_load_contents (location, NULL, &_tmp0_, &_tmp1_, &_tmp2_, &_inner_error0_);
		chars = (g_free (chars), NULL);
		chars = _tmp0_;
		chars_length1 = _tmp1_;
		_chars_size_ = chars_length1;
		_g_free0 (self->priv->_etag);
		self->priv->_etag = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			chars = (g_free (chars), NULL);
			goto __catch0_g_error;
		}
		_tmp3_ = chars;
		_tmp3__length1 = chars_length1;
		chars = NULL;
		chars_length1 = 0;
		text = (gchar*) _tmp3_;
		_tmp4_ = text;
		if (g_utf8_validate (_tmp4_, (gssize) -1, NULL)) {
			const gchar* _tmp5_;
			_tmp5_ = text;
			document_set_contents (self, _tmp5_);
		} else {
			gchar* utf8_text = NULL;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp6_ = text;
			_tmp7_ = document_to_utf8 (self, _tmp6_, &_inner_error0_);
			utf8_text = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (text);
				chars = (g_free (chars), NULL);
				goto __catch0_g_error;
			}
			_tmp8_ = utf8_text;
			document_set_contents (self, _tmp8_);
			_g_free0 (utf8_text);
		}
		document_update_syntax_highlighting (self);
		_tmp9_ = gtk_recent_manager_get_default ();
		_tmp10_ = g_file_get_uri (location);
		_tmp11_ = _tmp10_;
		gtk_recent_manager_add_item (_tmp9_, _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (text);
		chars = (g_free (chars), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		DocumentTab* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("document.vala:113: %s", _tmp13_);
		_tmp14_ = self->tab;
		if (_tmp14_ != NULL) {
			gchar* primary_msg = NULL;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			TeplInfoBar* infobar = NULL;
			const gchar* _tmp19_;
			GError* _tmp20_;
			const gchar* _tmp21_;
			TeplInfoBar* _tmp22_;
			DocumentTab* _tmp23_;
			TeplInfoBar* _tmp24_;
			TeplInfoBar* _tmp25_;
			_tmp15_ = g_file_get_parse_name (location);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strdup_printf (_ ("Impossible to load the file “%s”."), _tmp16_);
			_tmp18_ = _tmp17_;
			_g_free0 (_tmp16_);
			primary_msg = _tmp18_;
			_tmp19_ = primary_msg;
			_tmp20_ = e;
			_tmp21_ = _tmp20_->message;
			_tmp22_ = tepl_info_bar_new_simple (GTK_MESSAGE_ERROR, _tmp19_, _tmp21_);
			g_object_ref_sink (_tmp22_);
			infobar = _tmp22_;
			_tmp23_ = self->tab;
			_tmp24_ = infobar;
			tepl_tab_add_info_bar ((TeplTab*) _tmp23_, (GtkInfoBar*) _tmp24_);
			_tmp25_ = infobar;
			gtk_widget_show ((GtkWidget*) _tmp25_);
			_g_object_unref0 (infobar);
			_g_free0 (primary_msg);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

void
document_set_contents (Document* self,
                       const gchar* contents)
{
	gchar* contents2 = NULL;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	GtkTextIter iter = {0};
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contents != NULL);
	contents2 = NULL;
	_tmp0_ = strlen (contents);
	_tmp1_ = _tmp0_;
	if (string_get (contents, (glong) (_tmp1_ - 1)) == '\n') {
		gchar* _tmp2_;
		_tmp2_ = string_slice (contents, (glong) 0, (glong) -1);
		_g_free0 (contents2);
		contents2 = _tmp2_;
	}
	gtk_source_buffer_begin_not_undoable_action ((GtkSourceBuffer*) self);
	_tmp4_ = contents2;
	_tmp3_ = _tmp4_;
	if (_tmp3_ == NULL) {
		_tmp3_ = contents;
	}
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp3_, -1);
	self->priv->new_file = TRUE;
	gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
	gtk_source_buffer_end_not_undoable_action ((GtkSourceBuffer*) self);
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp5_);
	iter = _tmp5_;
	_tmp6_ = iter;
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &_tmp6_);
	_g_free0 (contents2);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		Document* self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->infobar);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static void
____lambda38_ (Block16Data* _data16_,
               gint response_id)
{
	Document* self;
	TeplInfoBar* _tmp0_;
	self = _data16_->self;
	if (response_id == ((gint) GTK_RESPONSE_YES)) {
		document_save (self, FALSE, FALSE);
	}
	_tmp0_ = _data16_->infobar;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}

static void
_____lambda38__gtk_info_bar_response (GtkInfoBar* _sender,
                                      gint response_id,
                                      gpointer self)
{
	____lambda38_ (self, response_id);
}

void
document_save (Document* self,
               gboolean check_file_changed_on_disk,
               gboolean force)
{
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	gchar* text = NULL;
	GtkTextIter _tmp5_;
	GtkTextIter _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_location;
	g_return_if_fail (_tmp0_ != NULL);
	if (!force) {
		_tmp2_ = !self->priv->new_file;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = !gtk_text_buffer_get_modified ((GtkTextBuffer*) self);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		return;
	}
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp3_, &_tmp4_);
	start = _tmp3_;
	end = _tmp4_;
	_tmp5_ = start;
	_tmp6_ = end;
	_tmp7_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp5_, &_tmp6_, FALSE);
	text = _tmp7_;
	_tmp8_ = text;
	_tmp9_ = text;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	if (string_get (_tmp8_, (glong) (_tmp11_ - 1)) != '\n') {
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp12_ = text;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat (_tmp13_, "\n", NULL);
		_g_free0 (text);
		text = _tmp14_;
	}
	{
		GSettings* settings = NULL;
		GSettings* _tmp15_;
		gboolean _tmp16_ = FALSE;
		gboolean make_backup = FALSE;
		const gchar* _tmp18_ = NULL;
		gchar* etag = NULL;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		GFile* parent = NULL;
		GFile* _tmp37_;
		GFile* _tmp38_;
		gboolean _tmp39_ = FALSE;
		GFile* _tmp40_;
		GFile* _tmp43_;
		const gchar* _tmp44_;
		guint8* _tmp45_;
		gint _tmp45__length1;
		gint _tmp46_ = 0;
		guint8* _tmp47_;
		gint _tmp47__length1;
		const gchar* _tmp48_;
		gchar* _tmp49_ = NULL;
		GtkRecentManager* _tmp50_;
		GFile* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		_tmp15_ = g_settings_new ("org.gnome.gnome-latex.preferences.editor");
		settings = _tmp15_;
		if (!self->priv->backup_made) {
			GSettings* _tmp17_;
			_tmp17_ = settings;
			_tmp16_ = g_settings_get_boolean (_tmp17_, "create-backup-copy");
		} else {
			_tmp16_ = FALSE;
		}
		make_backup = _tmp16_;
		if (check_file_changed_on_disk) {
			const gchar* _tmp19_;
			_tmp19_ = self->priv->_etag;
			_tmp18_ = _tmp19_;
		} else {
			_tmp18_ = NULL;
		}
		_tmp20_ = g_strdup (_tmp18_);
		etag = _tmp20_;
		_tmp21_ = self->priv->encoding;
		if (_tmp21_ != NULL) {
			gchar* _tmp22_ = NULL;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp23_ = text;
			_tmp24_ = text;
			_tmp25_ = strlen (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = self->priv->encoding;
			_tmp28_ = g_convert (_tmp23_, (gssize) _tmp26_, _tmp27_, "UTF-8", NULL, NULL, &_inner_error0_);
			_tmp22_ = _tmp28_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (etag);
				_g_object_unref0 (settings);
				goto __catch0_g_error;
			}
			_tmp29_ = _tmp22_;
			_tmp22_ = NULL;
			_g_free0 (text);
			text = _tmp29_;
			_g_free0 (_tmp22_);
		} else {
			gchar* _tmp30_ = NULL;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			_tmp31_ = text;
			_tmp32_ = text;
			_tmp33_ = strlen (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_filename_from_utf8 (_tmp31_, (gssize) _tmp34_, NULL, NULL, &_inner_error0_);
			_tmp30_ = _tmp35_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (etag);
				_g_object_unref0 (settings);
				goto __catch0_g_error;
			}
			_tmp36_ = _tmp30_;
			_tmp30_ = NULL;
			_g_free0 (text);
			text = _tmp36_;
			_g_free0 (_tmp30_);
		}
		_tmp37_ = self->priv->_location;
		_tmp38_ = g_file_get_parent (_tmp37_);
		parent = _tmp38_;
		_tmp40_ = parent;
		if (_tmp40_ != NULL) {
			GFile* _tmp41_;
			_tmp41_ = parent;
			_tmp39_ = !g_file_query_exists (_tmp41_, NULL);
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			GFile* _tmp42_;
			_tmp42_ = parent;
			g_file_make_directory_with_parents (_tmp42_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (parent);
				_g_free0 (etag);
				_g_object_unref0 (settings);
				goto __catch0_g_error;
			}
		}
		_tmp43_ = self->priv->_location;
		_tmp44_ = text;
		_tmp45_ = string_get_data (_tmp44_, &_tmp46_);
		_tmp45__length1 = _tmp46_;
		_tmp47_ = _tmp45_;
		_tmp47__length1 = _tmp45__length1;
		_tmp48_ = etag;
		g_file_replace_contents (_tmp43_, _tmp47_, (gsize) _tmp47__length1, _tmp48_, make_backup, G_FILE_CREATE_NONE, &_tmp49_, NULL, &_inner_error0_);
		_g_free0 (self->priv->_etag);
		self->priv->_etag = _tmp49_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (parent);
			_g_free0 (etag);
			_g_object_unref0 (settings);
			goto __catch0_g_error;
		}
		gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
		_tmp50_ = gtk_recent_manager_get_default ();
		_tmp51_ = self->priv->_location;
		_tmp52_ = g_file_get_uri (_tmp51_);
		_tmp53_ = _tmp52_;
		gtk_recent_manager_add_item (_tmp50_, _tmp53_);
		_g_free0 (_tmp53_);
		self->priv->backup_made = TRUE;
		tepl_buffer_save_metadata_into_metadata_manager ((TeplBuffer*) self);
		_g_object_unref0 (parent);
		_g_free0 (etag);
		_g_object_unref0 (settings);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gboolean _tmp54_ = FALSE;
		GError* _tmp55_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp55_ = e;
		if (g_error_matches (_tmp55_, G_IO_ERROR, G_IO_ERROR_WRONG_ETAG)) {
			DocumentTab* _tmp56_;
			_tmp56_ = self->tab;
			_tmp54_ = _tmp56_ != NULL;
		} else {
			_tmp54_ = FALSE;
		}
		if (_tmp54_) {
			Block16Data* _data16_;
			gchar* primary_msg = NULL;
			GFile* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* secondary_msg = NULL;
			gchar* _tmp62_;
			const gchar* _tmp63_;
			const gchar* _tmp64_;
			TeplInfoBar* _tmp65_;
			TeplInfoBar* _tmp66_;
			TeplInfoBar* _tmp67_;
			DocumentTab* _tmp68_;
			TeplInfoBar* _tmp69_;
			TeplInfoBar* _tmp70_;
			TeplInfoBar* _tmp71_;
			_data16_ = g_slice_new0 (Block16Data);
			_data16_->_ref_count_ = 1;
			_data16_->self = g_object_ref (self);
			_tmp57_ = self->priv->_location;
			_tmp58_ = g_file_get_parse_name (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = g_strdup_printf (_ ("The file %s has been modified since reading it."), _tmp59_);
			_tmp61_ = _tmp60_;
			_g_free0 (_tmp59_);
			primary_msg = _tmp61_;
			_tmp62_ = g_strdup (_ ("If you save it, all the external changes could be lost. Save it anyway" \
"?"));
			secondary_msg = _tmp62_;
			_tmp63_ = primary_msg;
			_tmp64_ = secondary_msg;
			_tmp65_ = tepl_info_bar_new_simple (GTK_MESSAGE_WARNING, _tmp63_, _tmp64_);
			g_object_ref_sink (_tmp65_);
			_data16_->infobar = _tmp65_;
			_tmp66_ = _data16_->infobar;
			gtk_info_bar_add_button ((GtkInfoBar*) _tmp66_, _ ("_Save Anyway"), (gint) GTK_RESPONSE_YES);
			_tmp67_ = _data16_->infobar;
			gtk_info_bar_add_button ((GtkInfoBar*) _tmp67_, _ ("_Don’t Save"), (gint) GTK_RESPONSE_CANCEL);
			_tmp68_ = self->tab;
			_tmp69_ = _data16_->infobar;
			tepl_tab_add_info_bar ((TeplTab*) _tmp68_, (GtkInfoBar*) _tmp69_);
			_tmp70_ = _data16_->infobar;
			gtk_widget_show ((GtkWidget*) _tmp70_);
			_tmp71_ = _data16_->infobar;
			g_signal_connect_data ((GtkInfoBar*) _tmp71_, "response", (GCallback) _____lambda38__gtk_info_bar_response, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
			_g_free0 (secondary_msg);
			_g_free0 (primary_msg);
			block16_data_unref (_data16_);
			_data16_ = NULL;
		} else {
			GError* _tmp72_;
			const gchar* _tmp73_;
			DocumentTab* _tmp74_;
			_tmp72_ = e;
			_tmp73_ = _tmp72_->message;
			g_warning ("document.vala:220: %s", _tmp73_);
			_tmp74_ = self->tab;
			if (_tmp74_ != NULL) {
				gchar* primary_msg = NULL;
				gchar* _tmp75_;
				TeplInfoBar* infobar = NULL;
				const gchar* _tmp76_;
				GError* _tmp77_;
				const gchar* _tmp78_;
				TeplInfoBar* _tmp79_;
				TeplInfoBar* _tmp80_;
				DocumentTab* _tmp81_;
				TeplInfoBar* _tmp82_;
				TeplInfoBar* _tmp83_;
				_tmp75_ = g_strdup (_ ("Impossible to save the file."));
				primary_msg = _tmp75_;
				_tmp76_ = primary_msg;
				_tmp77_ = e;
				_tmp78_ = _tmp77_->message;
				_tmp79_ = tepl_info_bar_new_simple (GTK_MESSAGE_ERROR, _tmp76_, _tmp78_);
				g_object_ref_sink (_tmp79_);
				infobar = _tmp79_;
				_tmp80_ = infobar;
				tepl_info_bar_setup_close_button (_tmp80_);
				_tmp81_ = self->tab;
				_tmp82_ = infobar;
				tepl_tab_add_info_bar ((TeplTab*) _tmp81_, (GtkInfoBar*) _tmp82_);
				_tmp83_ = infobar;
				gtk_widget_show ((GtkWidget*) _tmp83_);
				_g_object_unref0 (infobar);
				_g_free0 (primary_msg);
			}
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (text);
}

static gchar*
document_to_utf8 (Document* self,
                  const gchar* text,
                  GError** error)
{
	GError* _tmp7_;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	{
		const gchar** charset_collection = NULL;
		gint charset_collection_length1 = 0;
		gint _charset_collection_size_ = 0;
		gint charset_it = 0;
		charset_collection = ENCODINGS_CHARSETS;
		charset_collection_length1 = G_N_ELEMENTS (ENCODINGS_CHARSETS);
		for (charset_it = 0; charset_it < charset_collection_length1; charset_it = charset_it + 1) {
			gchar* _tmp0_;
			gchar* charset = NULL;
			_tmp0_ = g_strdup (charset_collection[charset_it]);
			charset = _tmp0_;
			{
				{
					gchar* utf8_text = NULL;
					gint _tmp1_;
					gint _tmp2_;
					const gchar* _tmp3_;
					gchar* _tmp4_;
					const gchar* _tmp5_;
					gchar* _tmp6_;
					_tmp1_ = strlen (text);
					_tmp2_ = _tmp1_;
					_tmp3_ = charset;
					_tmp4_ = g_convert (text, (gssize) _tmp2_, "UTF-8", _tmp3_, NULL, NULL, &_inner_error0_);
					utf8_text = _tmp4_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_CONVERT_ERROR) {
							goto __catch0_g_convert_error;
						}
						_g_free0 (charset);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
					_tmp5_ = charset;
					_tmp6_ = g_strdup (_tmp5_);
					_g_free0 (self->priv->encoding);
					self->priv->encoding = _tmp6_;
					result = utf8_text;
					_g_free0 (charset);
					return result;
				}
				goto __finally0;
				__catch0_g_convert_error:
				{
					g_clear_error (&_inner_error0_);
					_g_free0 (charset);
					continue;
				}
				__finally0:
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (charset);
					return NULL;
				} else {
					_g_free0 (charset);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_g_free0 (charset);
			}
		}
	}
	_tmp7_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_FAILED, _ ("Error trying to convert the document to UTF-8"));
	_inner_error0_ = _tmp7_;
	if (_inner_error0_->domain == G_CONVERT_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static void
document_update_syntax_highlighting (Document* self)
{
	GtkSourceLanguageManager* lm = NULL;
	GtkSourceLanguageManager* _tmp0_;
	GtkSourceLanguageManager* _tmp1_;
	gchar* content_type = NULL;
	GtkSourceLanguage* lang = NULL;
	GFile* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	GtkSourceLanguage* _tmp10_;
	GtkSourceLanguage* _tmp11_;
	GtkSourceLanguage* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_source_language_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	lm = _tmp1_;
	content_type = NULL;
	{
		GFileInfo* info = NULL;
		GFile* _tmp2_;
		GFileInfo* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = self->priv->_location;
		_tmp3_ = g_file_query_info (_tmp2_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = g_file_info_get_content_type (info);
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (content_type);
		content_type = _tmp5_;
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (content_type);
		_g_object_unref0 (lm);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp6_ = self->priv->_location;
	_tmp7_ = g_file_get_parse_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = content_type;
	_tmp10_ = gtk_source_language_manager_guess_language (lm, _tmp8_, _tmp9_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp8_);
	lang = _tmp12_;
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, lang);
	_g_object_unref0 (lang);
	_g_free0 (content_type);
	_g_object_unref0 (lm);
}

static void
document_update_project_id (Document* self)
{
	gint i = 0;
	g_return_if_fail (self != NULL);
	i = 0;
	{
		GeeIterator* _project_it = NULL;
		Projects* _tmp0_;
		Projects* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = projects_get_default ();
		_tmp1_ = _tmp0_;
		_tmp2_ = projects_iterator (_tmp1_);
		_tmp3_ = _tmp2_;
		_projects_unref0 (_tmp1_);
		_project_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			Project project = {0};
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			Project* _tmp7_;
			Project _tmp8_;
			Project _tmp9_ = {0};
			Project _tmp10_;
			GFile* _tmp11_;
			Project _tmp12_;
			GFile* _tmp13_;
			gint _tmp14_;
			_tmp4_ = _project_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _project_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			_tmp7_ = (Project*) _tmp6_;
			_tmp8_ = *_tmp7_;
			project_copy (&_tmp8_, &_tmp9_);
			_tmp10_ = _tmp9_;
			_project_free0 (_tmp7_);
			project = _tmp10_;
			_tmp11_ = self->priv->_location;
			_tmp12_ = project;
			_tmp13_ = _tmp12_.directory;
			if (g_file_has_prefix (_tmp11_, _tmp13_)) {
				document_set_project_id (self, i);
				project_destroy (&project);
				_g_object_unref0 (_project_it);
				return;
			}
			_tmp14_ = i;
			i = _tmp14_ + 1;
			project_destroy (&project);
		}
		_g_object_unref0 (_project_it);
	}
	document_set_project_id (self, -1);
}

gchar*
document_get_uri_for_display (Document* self)
{
	GFile* _tmp0_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ == NULL) {
		TeplFile* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = tepl_buffer_get_file ((TeplBuffer*) self);
		_tmp2_ = tepl_file_get_short_name (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->priv->_location;
	_tmp4_ = g_file_get_parse_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = tepl_utils_replace_home_dir_with_tilde (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	result = _tmp7_;
	return result;
}

gboolean
document_is_externally_modified (Document* self)
{
	GFile* _tmp0_;
	gchar* current_etag = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	current_etag = NULL;
	{
		GFileInfo* file_info = NULL;
		GFile* _tmp1_;
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = self->priv->_location;
		_tmp2_ = g_file_query_info (_tmp1_, G_FILE_ATTRIBUTE_ETAG_VALUE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		file_info = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = file_info;
		_tmp4_ = g_file_info_get_etag (_tmp3_);
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (current_etag);
		current_etag = _tmp5_;
		_g_object_unref0 (file_info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		_g_free0 (current_etag);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		_g_free0 (current_etag);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	_tmp8_ = current_etag;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = current_etag;
		_tmp10_ = self->priv->_etag;
		_tmp7_ = g_strcmp0 (_tmp9_, _tmp10_) != 0;
	} else {
		_tmp7_ = FALSE;
	}
	result = _tmp7_;
	_g_free0 (current_etag);
	return result;
}

void
document_comment_selected_lines (Document* self)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_;
	GtkTextIter _tmp3_;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	_tmp2_ = start;
	_tmp3_ = end;
	document_comment_between (self, &_tmp2_, &_tmp3_, TRUE);
}

void
document_comment_between (Document* self,
                          GtkTextIter* start_iter,
                          GtkTextIter* end_iter,
                          gboolean end_iter_set)
{
	gint start_line = 0;
	gint end_line = 0;
	GtkTextIter cur_iter = {0};
	GtkTextIter _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (start_iter != NULL);
	g_return_if_fail (end_iter != NULL);
	start_line = gtk_text_iter_get_line (start_iter);
	end_line = start_line;
	if (end_iter_set) {
		end_line = gtk_text_iter_get_line (end_iter);
	}
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp0_, start_line);
	cur_iter = _tmp0_;
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
	{
		gint line_num = 0;
		line_num = start_line;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = line_num;
					line_num = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(line_num <= end_line)) {
					break;
				}
				if (gtk_text_iter_ends_line (&cur_iter)) {
					document_insert (self, &cur_iter, "%", -1);
				} else {
					document_insert (self, &cur_iter, "% ", -1);
				}
				gtk_text_iter_forward_line (&cur_iter);
			}
		}
	}
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
}

void
document_uncomment_selected_lines (Document* self)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gint start_line = 0;
	gint end_line = 0;
	gint line_count = 0;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	start_line = gtk_text_iter_get_line (&start);
	end_line = gtk_text_iter_get_line (&end);
	line_count = gtk_text_buffer_get_line_count ((GtkTextBuffer*) self);
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
	{
		gint i = 0;
		i = start_line;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GtkTextIter _tmp4_ = {0};
				gchar* line = NULL;
				GtkTextIter _tmp7_;
				GtkTextIter _tmp8_;
				gchar* _tmp9_;
				gint j = 0;
				gint start_delete = 0;
				gint stop_delete = 0;
				GtkTextIter _tmp18_ = {0};
				GtkTextIter _tmp19_ = {0};
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i <= end_line)) {
					break;
				}
				gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp4_, i);
				start = _tmp4_;
				if (i == (line_count - 1)) {
					GtkTextIter _tmp5_ = {0};
					gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp5_);
					end = _tmp5_;
				} else {
					GtkTextIter _tmp6_ = {0};
					gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp6_, i + 1);
					end = _tmp6_;
				}
				_tmp7_ = start;
				_tmp8_ = end;
				_tmp9_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp7_, &_tmp8_, FALSE);
				line = _tmp9_;
				j = 0;
				start_delete = -1;
				stop_delete = -1;
				while (TRUE) {
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					gint _tmp17_;
					_tmp10_ = line;
					if (!(string_get (_tmp10_, (glong) j) != '\0')) {
						break;
					}
					_tmp11_ = line;
					if (string_get (_tmp11_, (glong) j) == '%') {
						const gchar* _tmp12_;
						start_delete = j;
						stop_delete = j + 1;
						_tmp12_ = line;
						if (string_get (_tmp12_, (glong) (j + 1)) == ' ') {
							gint _tmp13_;
							_tmp13_ = stop_delete;
							stop_delete = _tmp13_ + 1;
						}
						break;
					} else {
						gboolean _tmp14_ = FALSE;
						const gchar* _tmp15_;
						_tmp15_ = line;
						if (string_get (_tmp15_, (glong) j) != ' ') {
							const gchar* _tmp16_;
							_tmp16_ = line;
							_tmp14_ = string_get (_tmp16_, (glong) j) != '\t';
						} else {
							_tmp14_ = FALSE;
						}
						if (_tmp14_) {
							break;
						}
					}
					_tmp17_ = j;
					j = _tmp17_ + 1;
				}
				if (start_delete == -1) {
					_g_free0 (line);
					continue;
				}
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &_tmp18_, i, start_delete);
				start = _tmp18_;
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &_tmp19_, i, stop_delete);
				end = _tmp19_;
				gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
				_g_free0 (line);
			}
		}
	}
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
}

Project*
document_get_project (Document* self)
{
	gint _tmp0_;
	Projects* _tmp1_;
	Projects* _tmp2_;
	gint _tmp3_;
	Project* _tmp4_;
	Project* _tmp5_;
	Project* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_project_id;
	if (_tmp0_ == -1) {
		result = NULL;
		return result;
	}
	_tmp1_ = projects_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_project_id;
	_tmp4_ = projects_get (_tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	_projects_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}

GFile*
document_get_main_file (Document* self)
{
	GFile* _tmp0_;
	Project* project = NULL;
	Project* _tmp1_;
	Project* _tmp2_;
	Project* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = document_get_project (self);
	project = _tmp1_;
	_tmp2_ = project;
	if (_tmp2_ == NULL) {
		GFile* _tmp3_;
		GFile* _tmp4_;
		_tmp3_ = self->priv->_location;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		result = _tmp4_;
		_project_free0 (project);
		return result;
	}
	_tmp5_ = project;
	_tmp6_ = (*_tmp5_).main_file;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	_project_free0 (project);
	return result;
}

gboolean
document_is_main_file_a_tex_file (Document* self)
{
	GFile* main_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* path = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = document_get_main_file (self);
	main_file = _tmp0_;
	_tmp1_ = main_file;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (main_file);
		return result;
	}
	_tmp2_ = main_file;
	_tmp3_ = g_file_get_parse_name (_tmp2_);
	path = _tmp3_;
	_tmp4_ = path;
	result = g_str_has_suffix (_tmp4_, ".tex");
	_g_free0 (path);
	_g_object_unref0 (main_file);
	return result;
}

DocumentStructure*
document_get_structure (Document* self)
{
	DocumentStructure* _tmp0_;
	DocumentStructure* _tmp3_;
	DocumentStructure* _tmp4_;
	DocumentStructure* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_structure;
	if (_tmp0_ == NULL) {
		DocumentStructure* _tmp1_;
		DocumentStructure* _tmp2_;
		_tmp1_ = document_structure_new (self);
		_g_object_unref0 (self->priv->_structure);
		self->priv->_structure = _tmp1_;
		_tmp2_ = self->priv->_structure;
		document_structure_parse (_tmp2_);
	}
	_tmp3_ = self->priv->_structure;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	return result;
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		Document* self;
		self = _data17_->self;
		_g_object_unref0 (_data17_->infobar);
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}

static void
__lambda48_ (Block17Data* _data17_,
             gint response_id)
{
	Document* self;
	TeplInfoBar* _tmp4_;
	self = _data17_->self;
	if (response_id == ((gint) GTK_RESPONSE_YES)) {
		MainWindow* main_window = NULL;
		DocumentTab* _tmp0_;
		GtkWindow* _tmp1_;
		MainWindow* _tmp2_;
		_tmp0_ = self->tab;
		_tmp1_ = utils_get_toplevel_window ((GtkWidget*) _tmp0_);
		main_window = IS_MAIN_WINDOW (_tmp1_) ? ((MainWindow*) _tmp1_) : NULL;
		_tmp2_ = main_window;
		if (_tmp2_ != NULL) {
			MainWindow* _tmp3_;
			_tmp3_ = main_window;
			main_window_save_document (_tmp3_, self, TRUE);
		}
	}
	_tmp4_ = _data17_->infobar;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
}

static void
___lambda48__gtk_info_bar_response (GtkInfoBar* _sender,
                                    gint response_id,
                                    gpointer self)
{
	__lambda48_ (self, response_id);
}

gboolean
document_set_tmp_location (Document* self)
{
	Block17Data* _data17_;
	gchar* template = NULL;
	gchar* _tmp0_;
	gchar* tmp_dir = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	DocumentTab* _tmp14_;
	TeplInfoBar* _tmp15_;
	TeplInfoBar* _tmp16_;
	TeplInfoBar* _tmp17_;
	DocumentTab* _tmp18_;
	TeplInfoBar* _tmp19_;
	TeplInfoBar* _tmp20_;
	TeplInfoBar* _tmp21_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	_tmp0_ = g_strdup ("latexila-XXXXXX");
	template = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp5_;
		_tmp2_ = template;
		_tmp3_ = g_dir_make_tmp (_tmp2_, &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (tmp_dir);
			_g_free0 (template);
			block17_data_unref (_data17_);
			_data17_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		_tmp5_ = _tmp1_;
		_tmp1_ = NULL;
		_g_free0 (tmp_dir);
		tmp_dir = _tmp5_;
		_g_free0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("document.vala:460: Impossible to create temporary directory: %s", _tmp7_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (tmp_dir);
		_g_free0 (template);
		block17_data_unref (_data17_);
		_data17_ = NULL;
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp8_ = FALSE;
		_g_free0 (tmp_dir);
		_g_free0 (template);
		block17_data_unref (_data17_);
		_data17_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
	_tmp9_ = tmp_dir;
	_tmp10_ = g_build_filename (_tmp9_, "tmp.tex", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_file_new_for_path (_tmp11_);
	_tmp13_ = _tmp12_;
	document_set_location (self, _tmp13_);
	_g_object_unref0 (_tmp13_);
	_g_free0 (_tmp11_);
	_tmp14_ = self->tab;
	if (_tmp14_ == NULL) {
		result = TRUE;
		_g_free0 (tmp_dir);
		_g_free0 (template);
		block17_data_unref (_data17_);
		_data17_ = NULL;
		return result;
	}
	_tmp15_ = tepl_info_bar_new_simple (GTK_MESSAGE_WARNING, _ ("The file has a temporary location. The data can be lost after rebootin" \
"g your computer."), _ ("Do you want to save the file in a safer place?"));
	g_object_ref_sink (_tmp15_);
	_data17_->infobar = _tmp15_;
	_tmp16_ = _data17_->infobar;
	gtk_info_bar_add_button ((GtkInfoBar*) _tmp16_, _ ("Save _As"), (gint) GTK_RESPONSE_YES);
	_tmp17_ = _data17_->infobar;
	gtk_info_bar_add_button ((GtkInfoBar*) _tmp17_, _ ("Cancel"), (gint) GTK_RESPONSE_NO);
	_tmp18_ = self->tab;
	_tmp19_ = _data17_->infobar;
	tepl_tab_add_info_bar ((TeplTab*) _tmp18_, (GtkInfoBar*) _tmp19_);
	_tmp20_ = _data17_->infobar;
	gtk_widget_show ((GtkWidget*) _tmp20_);
	_tmp21_ = _data17_->infobar;
	g_signal_connect_data ((GtkInfoBar*) _tmp21_, "response", (GCallback) ___lambda48__gtk_info_bar_response, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
	result = TRUE;
	_g_free0 (tmp_dir);
	_g_free0 (template);
	block17_data_unref (_data17_);
	_data17_ = NULL;
	return result;
}

void
document_set_metadata (Document* self,
                       const gchar* key,
                       const gchar* val)
{
	TeplMetadata* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = tepl_buffer_get_metadata ((TeplBuffer*) self);
	tepl_metadata_set (_tmp0_, key, val);
	tepl_buffer_save_metadata_into_metadata_manager ((TeplBuffer*) self);
}

GFile*
document_get_location (Document* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}

void
document_set_location (Document* self,
                       GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = document_get_location (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_location);
		self->priv->_location = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, document_properties[DOCUMENT_LOCATION_PROPERTY]);
	}
}

gboolean
document_get_readonly (Document* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_readonly;
	return result;
}

void
document_set_readonly (Document* self,
                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = document_get_readonly (self);
	if (old_value != value) {
		self->priv->_readonly = value;
		g_object_notify_by_pspec ((GObject *) self, document_properties[DOCUMENT_READONLY_PROPERTY]);
	}
}

gint
document_get_project_id (Document* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_project_id;
	return result;
}

void
document_set_project_id (Document* self,
                         gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = document_get_project_id (self);
	if (old_value != value) {
		self->priv->_project_id = value;
		g_object_notify_by_pspec ((GObject *) self, document_properties[DOCUMENT_PROJECT_ID_PROPERTY]);
	}
}

static void
document_class_init (DocumentClass * klass,
                     gpointer klass_data)
{
	document_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Document_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_document_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_document_set_property;
	G_OBJECT_CLASS (klass)->finalize = document_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_LOCATION_PROPERTY, document_properties[DOCUMENT_LOCATION_PROPERTY] = g_param_spec_object ("location", "location", "location", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_READONLY_PROPERTY, document_properties[DOCUMENT_READONLY_PROPERTY] = g_param_spec_boolean ("readonly", "readonly", "readonly", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_PROJECT_ID_PROPERTY, document_properties[DOCUMENT_PROJECT_ID_PROPERTY] = g_param_spec_int ("project-id", "project-id", "project-id", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
document_instance_init (Document * self,
                        gpointer klass)
{
	self->priv = document_get_instance_private (self);
	self->priv->_readonly = FALSE;
	self->priv->_project_id = -1;
	self->priv->backup_made = FALSE;
	self->priv->encoding = NULL;
	self->priv->new_file = TRUE;
	self->priv->_structure = NULL;
}

static void
document_finalize (GObject * obj)
{
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT, Document);
	_g_object_unref0 (self->priv->_location);
	_g_free0 (self->priv->_etag);
	_g_free0 (self->priv->encoding);
	_g_object_unref0 (self->priv->_structure);
	G_OBJECT_CLASS (document_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
document_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Document), 0, (GInstanceInitFunc) document_instance_init, NULL };
	GType document_type_id;
	document_type_id = g_type_register_static (tepl_buffer_get_type (), "Document", &g_define_type_info, 0);
	Document_private_offset = g_type_add_instance_private (document_type_id, sizeof (DocumentPrivate));
	return document_type_id;
}

GType
document_get_type (void)
{
	static volatile gsize document_type_id__volatile = 0;
	if (g_once_init_enter (&document_type_id__volatile)) {
		GType document_type_id;
		document_type_id = document_get_type_once ();
		g_once_init_leave (&document_type_id__volatile, document_type_id);
	}
	return document_type_id__volatile;
}

static void
_vala_document_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT, Document);
	switch (property_id) {
		case DOCUMENT_LOCATION_PROPERTY:
		g_value_set_object (value, document_get_location (self));
		break;
		case DOCUMENT_READONLY_PROPERTY:
		g_value_set_boolean (value, document_get_readonly (self));
		break;
		case DOCUMENT_PROJECT_ID_PROPERTY:
		g_value_set_int (value, document_get_project_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_document_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec)
{
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT, Document);
	switch (property_id) {
		case DOCUMENT_LOCATION_PROPERTY:
		document_set_location (self, g_value_get_object (value));
		break;
		case DOCUMENT_READONLY_PROPERTY:
		document_set_readonly (self, g_value_get_boolean (value));
		break;
		case DOCUMENT_PROJECT_ID_PROPERTY:
		document_set_project_id (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

