/* build_tools_preferences.c generated by valac 0.54.6, the Vala compiler
 * generated from build_tools_preferences.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2012-2015 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */
/* The preferences of the default and personal build tools.*/
/* For the configuration of a single build tool, see build_tool_dialog.vala.*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <latexila.h>
#include <tepl/tepl.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BUILD_TOOLS_PREFERENCES (build_tools_preferences_get_type ())
#define BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferences))
#define BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))
#define IS_BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS_PREFERENCES))
#define IS_BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS_PREFERENCES))
#define BUILD_TOOLS_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))

typedef struct _BuildToolsPreferences BuildToolsPreferences;
typedef struct _BuildToolsPreferencesClass BuildToolsPreferencesClass;
typedef struct _BuildToolsPreferencesPrivate BuildToolsPreferencesPrivate;
enum  {
	BUILD_TOOLS_PREFERENCES_0_PROPERTY,
	BUILD_TOOLS_PREFERENCES_NUM_PROPERTIES
};
static GParamSpec* build_tools_preferences_properties[BUILD_TOOLS_PREFERENCES_NUM_PROPERTIES];
typedef enum  {
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS
} BuildToolsPreferencesBuildToolColumn;

#define BUILD_TOOLS_PREFERENCES_TYPE_BUILD_TOOL_COLUMN (build_tools_preferences_build_tool_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BUILD_TOOL_DIALOG (build_tool_dialog_get_type ())
#define BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialog))
#define BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))
#define IS_BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_DIALOG))
#define IS_BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_DIALOG))
#define BUILD_TOOL_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))

typedef struct _BuildToolDialog BuildToolDialog;
typedef struct _BuildToolDialogClass BuildToolDialogClass;
typedef struct _Block8Data Block8Data;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;

struct _BuildToolsPreferences {
	GObject parent_instance;
	BuildToolsPreferencesPrivate * priv;
};

struct _BuildToolsPreferencesClass {
	GObjectClass parent_class;
};

struct _BuildToolsPreferencesPrivate {
	GtkDialog* _dialog;
	GtkListStore* _default_store;
	GtkListStore* _personal_store;
	GtkTreeView* _default_view;
	GtkTreeView* _personal_view;
};

struct _Block4Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeSelection* default_select;
	GtkTreeSelection* personal_select;
};

struct _Block5Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeViewColumn* label_column;
	GtkListStore* store;
	LatexilaBuildTools* build_tools;
};

struct _Block6Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeView* view;
	LatexilaBuildTools* build_tools;
};

struct _Block7Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeView* view;
	LatexilaBuildTools* build_tools;
};

struct _Block8Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkToolButton* up_button;
	GtkTreeSelection* select;
};

struct _Block9Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkToolButton* down_button;
	GtkTreeSelection* select;
};

struct _Block10Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeSelection* select;
	GtkWidget* widget;
};

static gint BuildToolsPreferences_private_offset;
static gpointer build_tools_preferences_parent_class = NULL;

VALA_EXTERN GType build_tools_preferences_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BuildToolsPreferences, g_object_unref)
static GType build_tools_preferences_build_tool_column_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN BuildToolsPreferences* build_tools_preferences_new (GtkWindow* parent_window);
VALA_EXTERN BuildToolsPreferences* build_tools_preferences_construct (GType object_type,
                                                          GtkWindow* parent_window);
static GtkListStore* build_tools_preferences_get_new_store (BuildToolsPreferences* self);
static void build_tools_preferences_update_default_store (BuildToolsPreferences* self);
static void build_tools_preferences_update_personal_store (BuildToolsPreferences* self);
static void build_tools_preferences_init_views (BuildToolsPreferences* self);
static GtkWidget* build_tools_preferences_get_default_grid (BuildToolsPreferences* self);
static GtkWidget* build_tools_preferences_get_personal_grid (BuildToolsPreferences* self);
static GtkLabel* build_tools_preferences_get_note_label (BuildToolsPreferences* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static GtkTreeView* build_tools_preferences_get_new_view (BuildToolsPreferences* self,
                                                   GtkListStore* store,
                                                   LatexilaBuildTools* build_tools);
static void __lambda16_ (Block4Data* _data4_);
static void build_tools_preferences_on_view_selection_changed (BuildToolsPreferences* self,
                                                        GtkTreeSelection* select,
                                                        GtkTreeSelection* other_select);
static void ___lambda16__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                              gpointer self);
static void __lambda17_ (Block4Data* _data4_);
static void ___lambda17__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                              gpointer self);
static GtkToolButton* build_tools_preferences_get_properties_button (BuildToolsPreferences* self,
                                                              GtkTreeView* view,
                                                              LatexilaBuildTools* build_tools,
                                                              gboolean read_only);
static GtkToolButton* build_tools_preferences_get_copy_button (BuildToolsPreferences* self,
                                                        GtkTreeView* view,
                                                        LatexilaBuildTools* build_tools);
static GtkWidget* build_tools_preferences_join_view_and_toolbar (BuildToolsPreferences* self,
                                                          GtkTreeView* view,
                                                          GtkToolbar* toolbar);
static GtkToolButton* build_tools_preferences_get_add_button (BuildToolsPreferences* self);
static GtkToolButton* build_tools_preferences_get_remove_button (BuildToolsPreferences* self);
static GtkToolButton* build_tools_preferences_get_up_button (BuildToolsPreferences* self);
static GtkToolButton* build_tools_preferences_get_down_button (BuildToolsPreferences* self);
VALA_EXTERN GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda14_ (Block5Data* _data5_,
                  const gchar* path_string);
static void ___lambda14__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender,
                                                    const gchar* path,
                                                    gpointer self);
static void __lambda15_ (Block5Data* _data5_,
                  GtkTreePath* path,
                  GtkTreeViewColumn* column);
static void build_tools_preferences_open_build_tool (BuildToolsPreferences* self,
                                              LatexilaBuildTools* build_tools,
                                              gint build_tool_num);
static void ___lambda15__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                               GtkTreePath* path,
                                               GtkTreeViewColumn* column,
                                               gpointer self);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void build_tools_preferences_set_sensitivity_on_selection (BuildToolsPreferences* self,
                                                           GtkTreeView* view,
                                                           GtkWidget* widget);
static void __lambda19_ (Block6Data* _data6_);
VALA_EXTERN gint utils_get_selected_row (GtkTreeView* view,
                             GtkTreeIter* iter);
static void ___lambda19__gtk_tool_button_clicked (GtkToolButton* _sender,
                                           gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda20_ (Block7Data* _data7_);
VALA_EXTERN gchar* latexila_build_tool_get_label (LatexilaBuildTool* self);
static void ___lambda20__gtk_tool_button_clicked (GtkToolButton* _sender,
                                           gpointer self);
static void __lambda21_ (BuildToolsPreferences* self);
VALA_EXTERN GType build_tool_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BuildToolDialog, g_object_unref)
VALA_EXTERN BuildToolDialog* build_tool_dialog_new (GtkWindow* parent,
                                        gboolean editable);
VALA_EXTERN BuildToolDialog* build_tool_dialog_construct (GType object_type,
                                              GtkWindow* parent,
                                              gboolean editable);
VALA_EXTERN gboolean build_tool_dialog_create_personal_build_tool (BuildToolDialog* self);
static void ___lambda21__gtk_tool_button_clicked (GtkToolButton* _sender,
                                           gpointer self);
static void __lambda22_ (BuildToolsPreferences* self);
static void ___lambda22__gtk_tool_button_clicked (GtkToolButton* _sender,
                                           gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda23_ (Block8Data* _data8_);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void ___lambda23__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                              gpointer self);
static void __lambda24_ (Block8Data* _data8_);
static void ___lambda24__gtk_tool_button_clicked (GtkToolButton* _sender,
                                           gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda25_ (Block9Data* _data9_);
static void ___lambda25__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                              gpointer self);
static void __lambda26_ (Block9Data* _data9_);
static void ___lambda26__gtk_tool_button_clicked (GtkToolButton* _sender,
                                           gpointer self);
static void build_tools_preferences_update_store (BuildToolsPreferences* self,
                                           GtkListStore* store,
                                           LatexilaBuildTools* build_tools);
VALA_EXTERN gboolean latexila_build_tool_get_enabled (LatexilaBuildTool* self);
VALA_EXTERN gchar* latexila_build_tool_get_icon (LatexilaBuildTool* self);
VALA_EXTERN gboolean build_tool_dialog_open_build_tool (BuildToolDialog* self,
                                            LatexilaBuildTools* build_tools,
                                            gint build_tool_num);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda18_ (Block10Data* _data10_);
static void ___lambda18__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                              gpointer self);
static void build_tools_preferences_finalize (GObject * obj);
static GType build_tools_preferences_get_type_once (void);

static inline gpointer
build_tools_preferences_get_instance_private (BuildToolsPreferences* self)
{
	return G_STRUCT_MEMBER_P (self, BuildToolsPreferences_private_offset);
}

 G_GNUC_NO_INLINE static GType
build_tools_preferences_build_tool_column_get_type_once (void)
{
	static const GEnumValue values[] = {{BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED", "enabled"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF", "pixbuf"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL", "label"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION", "description"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType build_tools_preferences_build_tool_column_type_id;
	build_tools_preferences_build_tool_column_type_id = g_enum_register_static ("BuildToolsPreferencesBuildToolColumn", values);
	return build_tools_preferences_build_tool_column_type_id;
}

static GType
build_tools_preferences_build_tool_column_get_type (void)
{
	static volatile gsize build_tools_preferences_build_tool_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tools_preferences_build_tool_column_type_id__volatile)) {
		GType build_tools_preferences_build_tool_column_type_id;
		build_tools_preferences_build_tool_column_type_id = build_tools_preferences_build_tool_column_get_type_once ();
		g_once_init_leave (&build_tools_preferences_build_tool_column_type_id__volatile, build_tools_preferences_build_tool_column_type_id);
	}
	return build_tools_preferences_build_tool_column_type_id__volatile;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BuildToolsPreferences*
build_tools_preferences_construct (GType object_type,
                                   GtkWindow* parent_window)
{
	BuildToolsPreferences * self = NULL;
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	GObject* _tmp2_;
	GObject* _tmp3_;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GtkDialog* _tmp6_;
	GtkDialog* _tmp7_;
	GtkGrid* vgrid = NULL;
	GtkGrid* _tmp8_;
	GtkGrid* hgrid = NULL;
	GtkGrid* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* _tmp12_;
	GtkWidget* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp16_;
	GtkBox* _tmp17_;
	GtkBox* _tmp18_;
	GtkDialog* _tmp19_;
	GtkDialog* _tmp20_;
	LatexilaBuildToolsPersonal* _tmp21_;
	g_return_val_if_fail (parent_window != NULL, NULL);
	self = (BuildToolsPreferences*) g_object_new (object_type, NULL);
	_tmp0_ = build_tools_preferences_get_new_store (self);
	_g_object_unref0 (self->priv->_default_store);
	self->priv->_default_store = _tmp0_;
	_tmp1_ = build_tools_preferences_get_new_store (self);
	_g_object_unref0 (self->priv->_personal_store);
	self->priv->_personal_store = _tmp1_;
	build_tools_preferences_update_default_store (self);
	build_tools_preferences_update_personal_store (self);
	build_tools_preferences_init_views (self);
	_tmp2_ = g_object_new (gtk_dialog_get_type (), "use-header-bar", TRUE, NULL, NULL);
	_tmp3_ = G_IS_INITIALLY_UNOWNED (_tmp2_) ? g_object_ref_sink (_tmp2_) : _tmp2_;
	_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp3_) : NULL;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (_tmp3_);
	}
	_g_object_unref0 (self->priv->_dialog);
	self->priv->_dialog = _tmp4_;
	_tmp5_ = self->priv->_dialog;
	gtk_window_set_transient_for ((GtkWindow*) _tmp5_, parent_window);
	_tmp6_ = self->priv->_dialog;
	gtk_window_set_destroy_with_parent ((GtkWindow*) _tmp6_, TRUE);
	_tmp7_ = self->priv->_dialog;
	gtk_window_set_title ((GtkWindow*) _tmp7_, _ ("Build Tools"));
	_tmp8_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp8_);
	vgrid = _tmp8_;
	gtk_orientable_set_orientation ((GtkOrientable*) vgrid, GTK_ORIENTATION_VERTICAL);
	gtk_grid_set_row_spacing (vgrid, (guint) 6);
	_tmp9_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp9_);
	hgrid = _tmp9_;
	gtk_orientable_set_orientation ((GtkOrientable*) hgrid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (hgrid, (guint) 10);
	_tmp10_ = build_tools_preferences_get_default_grid (self);
	_tmp11_ = _tmp10_;
	gtk_container_add ((GtkContainer*) hgrid, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = build_tools_preferences_get_personal_grid (self);
	_tmp13_ = _tmp12_;
	gtk_container_add ((GtkContainer*) hgrid, _tmp13_);
	_g_object_unref0 (_tmp13_);
	gtk_container_add ((GtkContainer*) vgrid, (GtkWidget*) hgrid);
	_tmp14_ = build_tools_preferences_get_note_label (self);
	_tmp15_ = _tmp14_;
	gtk_container_add ((GtkContainer*) vgrid, (GtkWidget*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = self->priv->_dialog;
	_tmp17_ = gtk_dialog_get_content_area (_tmp16_);
	_tmp18_ = _g_object_ref0 (_tmp17_);
	content_area = _tmp18_;
	gtk_box_pack_start (content_area, (GtkWidget*) vgrid, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) content_area);
	_tmp19_ = self->priv->_dialog;
	gtk_dialog_run (_tmp19_);
	_tmp20_ = self->priv->_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp20_);
	_tmp21_ = latexila_build_tools_personal_get_instance ();
	latexila_build_tools_personal_save (_tmp21_);
	_g_object_unref0 (content_area);
	_g_object_unref0 (hgrid);
	_g_object_unref0 (vgrid);
	return self;
}

BuildToolsPreferences*
build_tools_preferences_new (GtkWindow* parent_window)
{
	return build_tools_preferences_construct (TYPE_BUILD_TOOLS_PREFERENCES, parent_window);
}

static GtkLabel*
build_tools_preferences_get_note_label (BuildToolsPreferences* self)
{
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tepl_info_bar_create_label ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	label = _tmp1_;
	g_object_set ((GtkWidget*) label, "margin", 6, NULL);
	gtk_label_set_text (label, _ ("Note: it is recommended to restart the application after customizing t" \
"he build tools."));
	result = label;
	return result;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->personal_select);
		_g_object_unref0 (_data4_->default_select);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda16_ (Block4Data* _data4_)
{
	BuildToolsPreferences* self;
	self = _data4_->self;
	build_tools_preferences_on_view_selection_changed (self, _data4_->default_select, _data4_->personal_select);
}

static void
___lambda16__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                         gpointer self)
{
	__lambda16_ (self);
}

static void
__lambda17_ (Block4Data* _data4_)
{
	BuildToolsPreferences* self;
	self = _data4_->self;
	build_tools_preferences_on_view_selection_changed (self, _data4_->personal_select, _data4_->default_select);
}

static void
___lambda17__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                         gpointer self)
{
	__lambda17_ (self);
}

static void
build_tools_preferences_init_views (BuildToolsPreferences* self)
{
	Block4Data* _data4_;
	GtkListStore* _tmp0_;
	LatexilaBuildToolsDefault* _tmp1_;
	GtkTreeView* _tmp2_;
	GtkListStore* _tmp3_;
	LatexilaBuildToolsPersonal* _tmp4_;
	GtkTreeView* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeSelection* _tmp7_;
	GtkTreeSelection* _tmp8_;
	GtkTreeView* _tmp9_;
	GtkTreeSelection* _tmp10_;
	GtkTreeSelection* _tmp11_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = self->priv->_default_store;
	_tmp1_ = latexila_build_tools_default_get_instance ();
	_tmp2_ = build_tools_preferences_get_new_view (self, _tmp0_, (LatexilaBuildTools*) _tmp1_);
	_g_object_unref0 (self->priv->_default_view);
	self->priv->_default_view = _tmp2_;
	_tmp3_ = self->priv->_personal_store;
	_tmp4_ = latexila_build_tools_personal_get_instance ();
	_tmp5_ = build_tools_preferences_get_new_view (self, _tmp3_, (LatexilaBuildTools*) _tmp4_);
	_g_object_unref0 (self->priv->_personal_view);
	self->priv->_personal_view = _tmp5_;
	_tmp6_ = self->priv->_default_view;
	_tmp7_ = gtk_tree_view_get_selection (_tmp6_);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_data4_->default_select = _tmp8_;
	_tmp9_ = self->priv->_personal_view;
	_tmp10_ = gtk_tree_view_get_selection (_tmp9_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_data4_->personal_select = _tmp11_;
	g_signal_connect_data (_data4_->default_select, "changed", (GCallback) ___lambda16__gtk_tree_selection_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	g_signal_connect_data (_data4_->personal_select, "changed", (GCallback) ___lambda17__gtk_tree_selection_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static GtkWidget*
build_tools_preferences_get_default_grid (BuildToolsPreferences* self)
{
	LatexilaBuildTools* default_build_tools = NULL;
	LatexilaBuildToolsDefault* _tmp0_;
	LatexilaBuildTools* _tmp1_;
	GtkToolButton* properties_button = NULL;
	GtkTreeView* _tmp2_;
	GtkToolButton* _tmp3_;
	GtkToolButton* copy_button = NULL;
	GtkTreeView* _tmp4_;
	GtkToolButton* _tmp5_;
	GtkToolbar* toolbar = NULL;
	GtkToolbar* _tmp6_;
	GtkWidget* join = NULL;
	GtkTreeView* _tmp7_;
	GtkWidget* _tmp8_;
	GtkWidget* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = latexila_build_tools_default_get_instance ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp0_) : NULL);
	default_build_tools = _tmp1_;
	_tmp2_ = self->priv->_default_view;
	_tmp3_ = build_tools_preferences_get_properties_button (self, _tmp2_, default_build_tools, TRUE);
	properties_button = _tmp3_;
	_tmp4_ = self->priv->_default_view;
	_tmp5_ = build_tools_preferences_get_copy_button (self, _tmp4_, default_build_tools);
	copy_button = _tmp5_;
	_tmp6_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp6_);
	toolbar = _tmp6_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) properties_button, -1);
	gtk_toolbar_insert (toolbar, (GtkToolItem*) copy_button, -1);
	_tmp7_ = self->priv->_default_view;
	_tmp8_ = build_tools_preferences_join_view_and_toolbar (self, _tmp7_, toolbar);
	join = _tmp8_;
	_tmp9_ = latexila_utils_get_dialog_component (_ ("Default Build Tools"), join);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	result = _tmp10_;
	_g_object_unref0 (join);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (copy_button);
	_g_object_unref0 (properties_button);
	_g_object_unref0 (default_build_tools);
	return result;
}

static GtkWidget*
build_tools_preferences_get_personal_grid (BuildToolsPreferences* self)
{
	LatexilaBuildTools* personal_build_tools = NULL;
	LatexilaBuildToolsPersonal* _tmp0_;
	LatexilaBuildTools* _tmp1_;
	GtkToolButton* properties_button = NULL;
	GtkTreeView* _tmp2_;
	GtkToolButton* _tmp3_;
	GtkToolButton* copy_button = NULL;
	GtkTreeView* _tmp4_;
	GtkToolButton* _tmp5_;
	GtkToolbar* toolbar = NULL;
	GtkToolbar* _tmp6_;
	GtkToolButton* _tmp7_;
	GtkToolButton* _tmp8_;
	GtkToolButton* _tmp9_;
	GtkToolButton* _tmp10_;
	GtkToolButton* _tmp11_;
	GtkToolButton* _tmp12_;
	GtkToolButton* _tmp13_;
	GtkToolButton* _tmp14_;
	GtkWidget* join = NULL;
	GtkTreeView* _tmp15_;
	GtkWidget* _tmp16_;
	GtkWidget* _tmp17_;
	GtkWidget* _tmp18_;
	GtkWidget* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = latexila_build_tools_personal_get_instance ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp0_) : NULL);
	personal_build_tools = _tmp1_;
	_tmp2_ = self->priv->_personal_view;
	_tmp3_ = build_tools_preferences_get_properties_button (self, _tmp2_, personal_build_tools, FALSE);
	properties_button = _tmp3_;
	_tmp4_ = self->priv->_personal_view;
	_tmp5_ = build_tools_preferences_get_copy_button (self, _tmp4_, personal_build_tools);
	copy_button = _tmp5_;
	_tmp6_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp6_);
	toolbar = _tmp6_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) properties_button, -1);
	gtk_toolbar_insert (toolbar, (GtkToolItem*) copy_button, -1);
	_tmp7_ = build_tools_preferences_get_add_button (self);
	_tmp8_ = _tmp7_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp8_, -1);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = build_tools_preferences_get_remove_button (self);
	_tmp10_ = _tmp9_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp10_, -1);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = build_tools_preferences_get_up_button (self);
	_tmp12_ = _tmp11_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp12_, -1);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = build_tools_preferences_get_down_button (self);
	_tmp14_ = _tmp13_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp14_, -1);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = self->priv->_personal_view;
	_tmp16_ = build_tools_preferences_join_view_and_toolbar (self, _tmp15_, toolbar);
	join = _tmp16_;
	_tmp17_ = latexila_utils_get_dialog_component (_ ("Personal Build Tools"), join);
	_tmp18_ = _g_object_ref0 (_tmp17_);
	result = _tmp18_;
	_g_object_unref0 (join);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (copy_button);
	_g_object_unref0 (properties_button);
	_g_object_unref0 (personal_build_tools);
	return result;
}

static GtkWidget*
build_tools_preferences_join_view_and_toolbar (BuildToolsPreferences* self,
                                               GtkTreeView* view,
                                               GtkToolbar* toolbar)
{
	GtkScrolledWindow* scrolled_window = NULL;
	GtkScrolledWindow* _tmp0_;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkGrid* vgrid = NULL;
	GtkGrid* _tmp3_;
	GtkWidget* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	g_return_val_if_fail (toolbar != NULL, NULL);
	g_object_set ((GtkWidget*) view, "expand", TRUE, NULL);
	_tmp0_ = utils_add_scrollbar ((GtkWidget*) view);
	scrolled_window = _tmp0_;
	gtk_scrolled_window_set_shadow_type (scrolled_window, GTK_SHADOW_IN);
	gtk_widget_set_size_request ((GtkWidget*) scrolled_window, 350, 200);
	gtk_toolbar_set_icon_size (toolbar, GTK_ICON_SIZE_MENU);
	gtk_toolbar_set_style (toolbar, GTK_TOOLBAR_ICONS);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) toolbar);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	context = _tmp2_;
	gtk_style_context_add_class (context, GTK_STYLE_CLASS_INLINE_TOOLBAR);
	_tmp3_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp3_);
	vgrid = _tmp3_;
	gtk_orientable_set_orientation ((GtkOrientable*) vgrid, GTK_ORIENTATION_VERTICAL);
	gtk_container_add ((GtkContainer*) vgrid, (GtkWidget*) scrolled_window);
	gtk_container_add ((GtkContainer*) vgrid, (GtkWidget*) toolbar);
	result = (GtkWidget*) vgrid;
	_g_object_unref0 (context);
	_g_object_unref0 (scrolled_window);
	return result;
}

static GtkListStore*
build_tools_preferences_get_new_store (BuildToolsPreferences* self)
{
	GtkListStore* _tmp0_;
	GtkListStore* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_list_store_new ((gint) BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, -1);
	result = _tmp0_;
	return result;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->label_column);
		_g_object_unref0 (_data5_->store);
		_g_object_unref0 (_data5_->build_tools);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda14_ (Block5Data* _data5_,
             const gchar* path_string)
{
	BuildToolsPreferences* self;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean enabled = FALSE;
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp1_;
	GtkTreeIter _tmp2_;
	gboolean _tmp3_ = FALSE;
	GtkTreeIter _tmp4_;
	gint num = 0;
	self = _data5_->self;
	g_return_if_fail (path_string != NULL);
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _data5_->store, &_tmp0_, path_string);
	iter = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data5_->store, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _data5_->store) : NULL);
	model = _tmp1_;
	_tmp2_ = iter;
	gtk_tree_model_get (model, &_tmp2_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, &_tmp3_, -1);
	enabled = _tmp3_;
	enabled = !enabled;
	_tmp4_ = iter;
	gtk_list_store_set (_data5_->store, &_tmp4_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, enabled, -1);
	num = atoi (path_string);
	latexila_build_tools_set_enabled (_data5_->build_tools, (guint) num, enabled);
	_g_object_unref0 (model);
}

static void
___lambda14__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender,
                                               const gchar* path,
                                               gpointer self)
{
	__lambda14_ (self, path);
}

static void
__lambda15_ (Block5Data* _data5_,
             GtkTreePath* path,
             GtkTreeViewColumn* column)
{
	BuildToolsPreferences* self;
	self = _data5_->self;
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	if (column == _data5_->label_column) {
		gint build_tool_num = 0;
		gint _tmp0_ = 0;
		gint* _tmp1_;
		gint _tmp2_;
		_tmp1_ = gtk_tree_path_get_indices_with_depth (path, &_tmp0_);
		_tmp2_ = _tmp1_[0];
		build_tool_num = _tmp2_;
		build_tools_preferences_open_build_tool (self, _data5_->build_tools, build_tool_num);
	}
}

static void
___lambda15__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                          GtkTreePath* path,
                                          GtkTreeViewColumn* column,
                                          gpointer self)
{
	__lambda15_ (self, path, column);
}

static GtkTreeView*
build_tools_preferences_get_new_view (BuildToolsPreferences* self,
                                      GtkListStore* store,
                                      LatexilaBuildTools* build_tools)
{
	Block5Data* _data5_;
	GtkListStore* _tmp0_;
	LatexilaBuildTools* _tmp1_;
	GtkTreeView* view = NULL;
	GtkTreeView* _tmp2_;
	GtkTreeViewColumn* enabled_column = NULL;
	GtkTreeViewColumn* _tmp3_;
	GtkCellRendererToggle* toggle_renderer = NULL;
	GtkCellRendererToggle* _tmp4_;
	GtkTreeViewColumn* _tmp5_;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp6_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp7_;
	GtkTreeSelection* select = NULL;
	GtkTreeSelection* _tmp8_;
	GtkTreeSelection* _tmp9_;
	GtkTreeView* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (build_tools != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (store);
	_g_object_unref0 (_data5_->store);
	_data5_->store = _tmp0_;
	_tmp1_ = _g_object_ref0 (build_tools);
	_g_object_unref0 (_data5_->build_tools);
	_data5_->build_tools = _tmp1_;
	_tmp2_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _data5_->store);
	g_object_ref_sink (_tmp2_);
	view = _tmp2_;
	_tmp3_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp3_);
	enabled_column = _tmp3_;
	gtk_tree_view_column_set_title (enabled_column, _ ("Enabled"));
	gtk_tree_view_append_column (view, enabled_column);
	_tmp4_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	g_object_ref_sink (_tmp4_);
	toggle_renderer = _tmp4_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) enabled_column, (GtkCellRenderer*) toggle_renderer, FALSE);
	gtk_tree_view_column_set_attributes (enabled_column, (GtkCellRenderer*) toggle_renderer, "active", BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, NULL);
	_tmp5_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp5_);
	_data5_->label_column = _tmp5_;
	gtk_tree_view_column_set_title (_data5_->label_column, _ ("Label"));
	gtk_tree_view_append_column (view, _data5_->label_column);
	_tmp6_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp6_);
	pixbuf_renderer = _tmp6_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _data5_->label_column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_tree_view_column_set_attributes (_data5_->label_column, (GtkCellRenderer*) pixbuf_renderer, "icon-name", BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF, NULL);
	_tmp7_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp7_);
	text_renderer = _tmp7_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _data5_->label_column, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_tree_view_column_set_attributes (_data5_->label_column, (GtkCellRenderer*) text_renderer, "text", BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, NULL);
	gtk_tree_view_set_tooltip_column (view, (gint) BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION);
	_tmp8_ = gtk_tree_view_get_selection (view);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	select = _tmp9_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	g_signal_connect_data (toggle_renderer, "toggled", (GCallback) ___lambda14__gtk_cell_renderer_toggle_toggled, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	g_signal_connect_data (view, "row-activated", (GCallback) ___lambda15__gtk_tree_view_row_activated, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	result = view;
	_g_object_unref0 (select);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (toggle_renderer);
	_g_object_unref0 (enabled_column);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
__vala_GtkTreePath_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
}

static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
}

static void
build_tools_preferences_on_view_selection_changed (BuildToolsPreferences* self,
                                                   GtkTreeSelection* select,
                                                   GtkTreeSelection* other_select)
{
	GList* selected_items = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (select != NULL);
	g_return_if_fail (other_select != NULL);
	_tmp0_ = gtk_tree_selection_get_selected_rows (select, NULL);
	selected_items = _tmp0_;
	_tmp1_ = selected_items;
	if (g_list_length (_tmp1_) > ((guint) 0)) {
		gtk_tree_selection_unselect_all (other_select);
	}
	(selected_items == NULL) ? NULL : (selected_items = (_g_list_free___vala_GtkTreePath_free0_ (selected_items), NULL));
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->view);
		_g_object_unref0 (_data6_->build_tools);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda19_ (Block6Data* _data6_)
{
	BuildToolsPreferences* self;
	gint build_tool_num = 0;
	self = _data6_->self;
	build_tool_num = utils_get_selected_row (_data6_->view, NULL);
	if (0 <= build_tool_num) {
		build_tools_preferences_open_build_tool (self, _data6_->build_tools, build_tool_num);
	}
}

static void
___lambda19__gtk_tool_button_clicked (GtkToolButton* _sender,
                                      gpointer self)
{
	__lambda19_ (self);
}

static GtkToolButton*
build_tools_preferences_get_properties_button (BuildToolsPreferences* self,
                                               GtkTreeView* view,
                                               LatexilaBuildTools* build_tools,
                                               gboolean read_only)
{
	Block6Data* _data6_;
	GtkTreeView* _tmp0_;
	LatexilaBuildTools* _tmp1_;
	GtkToolButton* properties_button = NULL;
	GtkToolButton* _tmp2_;
	GtkToolButton* _tmp7_;
	GtkToolButton* _tmp8_;
	GtkToolButton* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	g_return_val_if_fail (build_tools != NULL, NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (view);
	_g_object_unref0 (_data6_->view);
	_data6_->view = _tmp0_;
	_tmp1_ = _g_object_ref0 (build_tools);
	_g_object_unref0 (_data6_->build_tools);
	_data6_->build_tools = _tmp1_;
	_tmp2_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp2_);
	properties_button = _tmp2_;
	if (read_only) {
		GtkToolButton* _tmp3_;
		GtkToolButton* _tmp4_;
		_tmp3_ = properties_button;
		gtk_tool_button_set_icon_name (_tmp3_, "edit-find-symbolic");
		_tmp4_ = properties_button;
		gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp4_, _ ("View the properties (read-only)"));
	} else {
		GtkToolButton* _tmp5_;
		GtkToolButton* _tmp6_;
		_tmp5_ = properties_button;
		gtk_tool_button_set_icon_name (_tmp5_, "document-properties-symbolic");
		_tmp6_ = properties_button;
		gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp6_, _ ("Edit the properties"));
	}
	_tmp7_ = properties_button;
	build_tools_preferences_set_sensitivity_on_selection (self, _data6_->view, (GtkWidget*) _tmp7_);
	_tmp8_ = properties_button;
	g_signal_connect_data (_tmp8_, "clicked", (GCallback) ___lambda19__gtk_tool_button_clicked, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	result = properties_button;
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return result;
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->view);
		_g_object_unref0 (_data7_->build_tools);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda20_ (Block7Data* _data7_)
{
	BuildToolsPreferences* self;
	gint selected_row = 0;
	LatexilaBuildTool* tool = NULL;
	LatexilaBuildTool* _tmp0_;
	LatexilaBuildTool* _tmp1_;
	LatexilaBuildTool* _tmp2_;
	LatexilaBuildTool* _tmp3_;
	LatexilaBuildTool* _tmp4_;
	LatexilaBuildTool* _tmp5_;
	LatexilaBuildTool* _tmp6_;
	LatexilaBuildTool* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	LatexilaBuildToolsPersonal* personal_build_tools = NULL;
	LatexilaBuildToolsPersonal* _tmp13_;
	LatexilaBuildToolsPersonal* _tmp14_;
	LatexilaBuildToolsPersonal* _tmp15_;
	LatexilaBuildTool* _tmp16_;
	self = _data7_->self;
	selected_row = utils_get_selected_row (_data7_->view, NULL);
	if (selected_row < 0) {
		return;
	}
	_tmp0_ = latexila_build_tools_nth (_data7_->build_tools, (guint) selected_row);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	tool = _tmp1_;
	_tmp2_ = tool;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = tool;
	_tmp4_ = latexila_build_tool_clone (_tmp3_);
	_g_object_unref0 (tool);
	tool = _tmp4_;
	_tmp5_ = tool;
	g_object_set (_tmp5_, "enabled", FALSE, NULL);
	_tmp6_ = tool;
	_tmp7_ = tool;
	g_object_get (_tmp7_, "label", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf (_ ("%s [copy]"), _tmp10_);
	_tmp12_ = _tmp11_;
	g_object_set (_tmp6_, "label", _tmp12_, NULL);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = latexila_build_tools_personal_get_instance ();
	_tmp14_ = _g_object_ref0 (_tmp13_);
	personal_build_tools = _tmp14_;
	_tmp15_ = personal_build_tools;
	_tmp16_ = tool;
	latexila_build_tools_personal_add (_tmp15_, _tmp16_);
	build_tools_preferences_update_personal_store (self);
	_g_object_unref0 (personal_build_tools);
	_g_object_unref0 (tool);
}

static void
___lambda20__gtk_tool_button_clicked (GtkToolButton* _sender,
                                      gpointer self)
{
	__lambda20_ (self);
}

static GtkToolButton*
build_tools_preferences_get_copy_button (BuildToolsPreferences* self,
                                         GtkTreeView* view,
                                         LatexilaBuildTools* build_tools)
{
	Block7Data* _data7_;
	GtkTreeView* _tmp0_;
	LatexilaBuildTools* _tmp1_;
	GtkToolButton* copy_button = NULL;
	GtkToolButton* _tmp2_;
	GtkToolButton* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	g_return_val_if_fail (build_tools != NULL, NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (view);
	_g_object_unref0 (_data7_->view);
	_data7_->view = _tmp0_;
	_tmp1_ = _g_object_ref0 (build_tools);
	_g_object_unref0 (_data7_->build_tools);
	_data7_->build_tools = _tmp1_;
	_tmp2_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp2_);
	copy_button = _tmp2_;
	gtk_tool_button_set_icon_name (copy_button, "edit-copy-symbolic");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) copy_button, _ ("Create a copy"));
	build_tools_preferences_set_sensitivity_on_selection (self, _data7_->view, (GtkWidget*) copy_button);
	g_signal_connect_data (copy_button, "clicked", (GCallback) ___lambda20__gtk_tool_button_clicked, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	result = copy_button;
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return result;
}

static void
__lambda21_ (BuildToolsPreferences* self)
{
	BuildToolDialog* dialog = NULL;
	GtkDialog* _tmp0_;
	BuildToolDialog* _tmp1_;
	BuildToolDialog* _tmp2_;
	_tmp0_ = self->priv->_dialog;
	_tmp1_ = build_tool_dialog_new ((GtkWindow*) _tmp0_, TRUE);
	dialog = _tmp1_;
	_tmp2_ = dialog;
	if (build_tool_dialog_create_personal_build_tool (_tmp2_)) {
		build_tools_preferences_update_personal_store (self);
	}
	_g_object_unref0 (dialog);
}

static void
___lambda21__gtk_tool_button_clicked (GtkToolButton* _sender,
                                      gpointer self)
{
	__lambda21_ ((BuildToolsPreferences*) self);
}

static GtkToolButton*
build_tools_preferences_get_add_button (BuildToolsPreferences* self)
{
	GtkToolButton* add_button = NULL;
	GtkToolButton* _tmp0_;
	GtkToolButton* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	add_button = _tmp0_;
	gtk_tool_button_set_icon_name (add_button, "list-add-symbolic");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) add_button, _ ("Add…"));
	g_signal_connect_object (add_button, "clicked", (GCallback) ___lambda21__gtk_tool_button_clicked, self, 0);
	result = add_button;
	return result;
}

static void
__lambda22_ (BuildToolsPreferences* self)
{
	GtkTreeIter iter = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_;
	gchar* label = NULL;
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	gchar* _tmp7_ = NULL;
	GtkDialog* dialog = NULL;
	GtkDialog* _tmp8_;
	const gchar* _tmp9_;
	GtkMessageDialog* _tmp10_;
	GtkDialog* _tmp11_;
	GtkDialog* _tmp12_;
	GtkDialog* _tmp15_;
	_tmp0_ = self->priv->_personal_view;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	selected_row = _tmp2_;
	if (selected_row == -1) {
		return;
	}
	_tmp3_ = self->priv->_personal_store;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp3_) : NULL);
	model = _tmp4_;
	_tmp5_ = model;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, &_tmp7_, -1);
	_g_free0 (label);
	label = _tmp7_;
	_tmp8_ = self->priv->_dialog;
	_tmp9_ = label;
	_tmp10_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp8_, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _ ("Do you really want to delete the build tool “%s”?"), _tmp9_);
	g_object_ref_sink (_tmp10_);
	dialog = (GtkDialog*) _tmp10_;
	_tmp11_ = dialog;
	gtk_dialog_add_buttons (_tmp11_, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Delete"), GTK_RESPONSE_YES, NULL);
	_tmp12_ = dialog;
	if (gtk_dialog_run (_tmp12_) == ((gint) GTK_RESPONSE_YES)) {
		GtkListStore* _tmp13_;
		LatexilaBuildToolsPersonal* _tmp14_;
		_tmp13_ = self->priv->_personal_store;
		gtk_list_store_remove (_tmp13_, &iter);
		_tmp14_ = latexila_build_tools_personal_get_instance ();
		latexila_build_tools_personal_delete (_tmp14_, (guint) selected_row);
	}
	_tmp15_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp15_);
	_g_object_unref0 (dialog);
	_g_object_unref0 (model);
	_g_free0 (label);
}

static void
___lambda22__gtk_tool_button_clicked (GtkToolButton* _sender,
                                      gpointer self)
{
	__lambda22_ ((BuildToolsPreferences*) self);
}

static GtkToolButton*
build_tools_preferences_get_remove_button (BuildToolsPreferences* self)
{
	GtkToolButton* remove_button = NULL;
	GtkToolButton* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkToolButton* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	remove_button = _tmp0_;
	gtk_tool_button_set_icon_name (remove_button, "list-remove-symbolic");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) remove_button, _ ("Remove"));
	_tmp1_ = self->priv->_personal_view;
	build_tools_preferences_set_sensitivity_on_selection (self, _tmp1_, (GtkWidget*) remove_button);
	g_signal_connect_object (remove_button, "clicked", (GCallback) ___lambda22__gtk_tool_button_clicked, self, 0);
	result = remove_button;
	return result;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->up_button);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
	return g_boxed_copy (gtk_tree_path_get_type (), self);
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
	return self ? _vala_GtkTreePath_copy (self) : NULL;
}

static void
__lambda23_ (Block8Data* _data8_)
{
	BuildToolsPreferences* self;
	GList* selected_rows = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GtkTreePath* path_selected = NULL;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	GtkTreePath* _tmp4_;
	gint row_num = 0;
	GtkTreePath* _tmp5_;
	gint _tmp6_ = 0;
	gint* _tmp7_;
	gint _tmp8_;
	self = _data8_->self;
	_tmp0_ = gtk_tree_selection_get_selected_rows (_data8_->select, NULL);
	selected_rows = _tmp0_;
	_tmp1_ = selected_rows;
	if (g_list_length (_tmp1_) == ((guint) 0)) {
		gtk_widget_set_sensitive ((GtkWidget*) _data8_->up_button, FALSE);
		(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
		return;
	}
	_tmp2_ = selected_rows;
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
	_tmp4_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp3_);
	path_selected = _tmp4_;
	_tmp5_ = path_selected;
	_tmp7_ = gtk_tree_path_get_indices_with_depth (_tmp5_, &_tmp6_);
	_tmp8_ = _tmp7_[0];
	row_num = _tmp8_;
	gtk_widget_set_sensitive ((GtkWidget*) _data8_->up_button, row_num > 0);
	__vala_GtkTreePath_free0 (path_selected);
	(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
}

static void
___lambda23__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                         gpointer self)
{
	__lambda23_ (self);
}

static void
__lambda24_ (Block8Data* _data8_)
{
	BuildToolsPreferences* self;
	GtkTreeIter iter_selected = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_;
	self = _data8_->self;
	_tmp0_ = self->priv->_personal_view;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter_selected = _tmp1_;
	selected_row = _tmp2_;
	if (selected_row > 0) {
		GtkTreeIter iter_up = {0};
		GtkTreeIter _tmp3_;
		GtkListStore* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = iter_selected;
		iter_up = _tmp3_;
		_tmp4_ = self->priv->_personal_store;
		_tmp5_ = gtk_tree_model_iter_previous ((GtkTreeModel*) _tmp4_, &iter_up);
		if (_tmp5_) {
			GtkListStore* _tmp6_;
			GtkTreeIter _tmp7_;
			GtkTreeIter _tmp8_;
			LatexilaBuildToolsPersonal* _tmp9_;
			_tmp6_ = self->priv->_personal_store;
			_tmp7_ = iter_selected;
			_tmp8_ = iter_up;
			gtk_list_store_swap (_tmp6_, &_tmp7_, &_tmp8_);
			_tmp9_ = latexila_build_tools_personal_get_instance ();
			latexila_build_tools_personal_move_up (_tmp9_, (guint) selected_row);
			g_signal_emit_by_name (_data8_->select, "changed");
		}
	}
}

static void
___lambda24__gtk_tool_button_clicked (GtkToolButton* _sender,
                                      gpointer self)
{
	__lambda24_ (self);
}

static GtkToolButton*
build_tools_preferences_get_up_button (BuildToolsPreferences* self)
{
	Block8Data* _data8_;
	GtkToolButton* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkToolButton* _tmp3_;
	GtkToolButton* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_data8_->up_button = _tmp0_;
	gtk_tool_button_set_icon_name (_data8_->up_button, "go-up-symbolic");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _data8_->up_button, _ ("Move up"));
	gtk_widget_set_sensitive ((GtkWidget*) _data8_->up_button, FALSE);
	_tmp1_ = self->priv->_personal_view;
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
	_data8_->select = _tmp2_;
	g_signal_connect_data (_data8_->select, "changed", (GCallback) ___lambda23__gtk_tree_selection_changed, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	g_signal_connect_data (_data8_->up_button, "clicked", (GCallback) ___lambda24__gtk_tool_button_clicked, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	_tmp3_ = _g_object_ref0 (_data8_->up_button);
	result = _tmp3_;
	block8_data_unref (_data8_);
	_data8_ = NULL;
	return result;
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->down_button);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda25_ (Block9Data* _data9_)
{
	BuildToolsPreferences* self;
	GList* selected_rows = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GtkTreePath* path_selected = NULL;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	GtkTreePath* _tmp4_;
	gint row_num = 0;
	GtkTreePath* _tmp5_;
	gint _tmp6_ = 0;
	gint* _tmp7_;
	gint _tmp8_;
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp9_;
	GtkTreeModel* _tmp10_;
	gint nb_rows = 0;
	GtkTreeModel* _tmp11_;
	self = _data9_->self;
	_tmp0_ = gtk_tree_selection_get_selected_rows (_data9_->select, NULL);
	selected_rows = _tmp0_;
	_tmp1_ = selected_rows;
	if (g_list_length (_tmp1_) == ((guint) 0)) {
		gtk_widget_set_sensitive ((GtkWidget*) _data9_->down_button, FALSE);
		(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
		return;
	}
	_tmp2_ = selected_rows;
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
	_tmp4_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp3_);
	path_selected = _tmp4_;
	_tmp5_ = path_selected;
	_tmp7_ = gtk_tree_path_get_indices_with_depth (_tmp5_, &_tmp6_);
	_tmp8_ = _tmp7_[0];
	row_num = _tmp8_;
	_tmp9_ = self->priv->_personal_store;
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp9_) : NULL);
	model = _tmp10_;
	_tmp11_ = model;
	nb_rows = gtk_tree_model_iter_n_children (_tmp11_, NULL);
	gtk_widget_set_sensitive ((GtkWidget*) _data9_->down_button, row_num < (nb_rows - 1));
	_g_object_unref0 (model);
	__vala_GtkTreePath_free0 (path_selected);
	(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
}

static void
___lambda25__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                         gpointer self)
{
	__lambda25_ (self);
}

static void
__lambda26_ (Block9Data* _data9_)
{
	BuildToolsPreferences* self;
	GtkTreeIter iter_selected = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_;
	self = _data9_->self;
	_tmp0_ = self->priv->_personal_view;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter_selected = _tmp1_;
	selected_row = _tmp2_;
	if (selected_row >= 0) {
		GtkTreeIter iter_down = {0};
		GtkTreeIter _tmp3_;
		GtkListStore* _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = iter_selected;
		iter_down = _tmp3_;
		_tmp4_ = self->priv->_personal_store;
		_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &iter_down);
		if (_tmp5_) {
			GtkListStore* _tmp6_;
			GtkTreeIter _tmp7_;
			GtkTreeIter _tmp8_;
			LatexilaBuildToolsPersonal* _tmp9_;
			_tmp6_ = self->priv->_personal_store;
			_tmp7_ = iter_selected;
			_tmp8_ = iter_down;
			gtk_list_store_swap (_tmp6_, &_tmp7_, &_tmp8_);
			_tmp9_ = latexila_build_tools_personal_get_instance ();
			latexila_build_tools_personal_move_down (_tmp9_, (guint) selected_row);
			g_signal_emit_by_name (_data9_->select, "changed");
		}
	}
}

static void
___lambda26__gtk_tool_button_clicked (GtkToolButton* _sender,
                                      gpointer self)
{
	__lambda26_ (self);
}

static GtkToolButton*
build_tools_preferences_get_down_button (BuildToolsPreferences* self)
{
	Block9Data* _data9_;
	GtkToolButton* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkToolButton* _tmp3_;
	GtkToolButton* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_data9_->down_button = _tmp0_;
	gtk_tool_button_set_icon_name (_data9_->down_button, "go-down-symbolic");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _data9_->down_button, _ ("Move down"));
	gtk_widget_set_sensitive ((GtkWidget*) _data9_->down_button, FALSE);
	_tmp1_ = self->priv->_personal_view;
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
	_data9_->select = _tmp2_;
	g_signal_connect_data (_data9_->select, "changed", (GCallback) ___lambda25__gtk_tree_selection_changed, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	g_signal_connect_data (_data9_->down_button, "clicked", (GCallback) ___lambda26__gtk_tool_button_clicked, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	_tmp3_ = _g_object_ref0 (_data9_->down_button);
	result = _tmp3_;
	block9_data_unref (_data9_);
	_data9_ = NULL;
	return result;
}

static void
build_tools_preferences_update_default_store (BuildToolsPreferences* self)
{
	GtkListStore* _tmp0_;
	LatexilaBuildToolsDefault* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_default_store;
	_tmp1_ = latexila_build_tools_default_get_instance ();
	build_tools_preferences_update_store (self, _tmp0_, (LatexilaBuildTools*) _tmp1_);
}

static void
build_tools_preferences_update_personal_store (BuildToolsPreferences* self)
{
	GtkListStore* _tmp0_;
	LatexilaBuildToolsPersonal* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_personal_store;
	_tmp1_ = latexila_build_tools_personal_get_instance ();
	build_tools_preferences_update_store (self, _tmp0_, (LatexilaBuildTools*) _tmp1_);
}

static void
build_tools_preferences_update_store (BuildToolsPreferences* self,
                                      GtkListStore* store,
                                      LatexilaBuildTools* build_tools)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (build_tools != NULL);
	gtk_list_store_clear (store);
	_tmp0_ = build_tools->build_tools;
	{
		GList* tool_collection = NULL;
		GList* tool_it = NULL;
		tool_collection = _tmp0_;
		for (tool_it = tool_collection; tool_it != NULL; tool_it = tool_it->next) {
			LatexilaBuildTool* _tmp1_;
			LatexilaBuildTool* tool = NULL;
			_tmp1_ = _g_object_ref0 ((LatexilaBuildTool*) tool_it->data);
			tool = _tmp1_;
			{
				gchar* description = NULL;
				LatexilaBuildTool* _tmp2_;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp5_ = {0};
				GtkTreeIter _tmp6_;
				LatexilaBuildTool* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				LatexilaBuildTool* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				LatexilaBuildTool* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp2_ = tool;
				_tmp3_ = latexila_build_tool_get_description (_tmp2_);
				_tmp4_ = g_markup_escape_text (_tmp3_, (gssize) -1);
				description = _tmp4_;
				gtk_list_store_append (store, &_tmp5_);
				iter = _tmp5_;
				_tmp6_ = iter;
				_tmp7_ = tool;
				g_object_get (_tmp7_, "enabled", &_tmp8_, NULL);
				_tmp9_ = _tmp8_;
				_tmp10_ = tool;
				g_object_get (_tmp10_, "icon", &_tmp11_, NULL);
				_tmp12_ = _tmp11_;
				_tmp13_ = _tmp12_;
				_tmp14_ = tool;
				g_object_get (_tmp14_, "label", &_tmp15_, NULL);
				_tmp16_ = _tmp15_;
				_tmp17_ = _tmp16_;
				_tmp18_ = description;
				gtk_list_store_set (store, &_tmp6_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, _tmp9_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF, _tmp13_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, _tmp17_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION, _tmp18_, -1);
				_g_free0 (_tmp17_);
				_g_free0 (_tmp13_);
				_g_free0 (description);
				_g_object_unref0 (tool);
			}
		}
	}
}

static void
build_tools_preferences_open_build_tool (BuildToolsPreferences* self,
                                         LatexilaBuildTools* build_tools,
                                         gint build_tool_num)
{
	gboolean editable = FALSE;
	BuildToolDialog* dialog = NULL;
	GtkDialog* _tmp0_;
	BuildToolDialog* _tmp1_;
	gboolean edited = FALSE;
	BuildToolDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (build_tools != NULL);
	editable = G_TYPE_CHECK_INSTANCE_TYPE (build_tools, latexila_build_tools_personal_get_type ());
	_tmp0_ = self->priv->_dialog;
	_tmp1_ = build_tool_dialog_new ((GtkWindow*) _tmp0_, editable);
	dialog = _tmp1_;
	_tmp2_ = dialog;
	edited = build_tool_dialog_open_build_tool (_tmp2_, build_tools, build_tool_num);
	if (edited) {
		build_tools_preferences_update_personal_store (self);
	}
	_g_object_unref0 (dialog);
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		BuildToolsPreferences* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->widget);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
__lambda18_ (Block10Data* _data10_)
{
	BuildToolsPreferences* self;
	gboolean row_selected = FALSE;
	self = _data10_->self;
	row_selected = gtk_tree_selection_count_selected_rows (_data10_->select) > 0;
	gtk_widget_set_sensitive (_data10_->widget, row_selected);
}

static void
___lambda18__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                         gpointer self)
{
	__lambda18_ (self);
}

static void
build_tools_preferences_set_sensitivity_on_selection (BuildToolsPreferences* self,
                                                      GtkTreeView* view,
                                                      GtkWidget* widget)
{
	Block10Data* _data10_;
	GtkWidget* _tmp0_;
	GtkTreeSelection* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (widget != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (widget);
	_g_object_unref0 (_data10_->widget);
	_data10_->widget = _tmp0_;
	gtk_widget_set_sensitive (_data10_->widget, FALSE);
	_tmp1_ = gtk_tree_view_get_selection (view);
	_data10_->select = _tmp1_;
	g_signal_connect_data (_data10_->select, "changed", (GCallback) ___lambda18__gtk_tree_selection_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static void
build_tools_preferences_class_init (BuildToolsPreferencesClass * klass,
                                    gpointer klass_data)
{
	build_tools_preferences_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BuildToolsPreferences_private_offset);
	G_OBJECT_CLASS (klass)->finalize = build_tools_preferences_finalize;
}

static void
build_tools_preferences_instance_init (BuildToolsPreferences * self,
                                       gpointer klass)
{
	self->priv = build_tools_preferences_get_instance_private (self);
}

static void
build_tools_preferences_finalize (GObject * obj)
{
	BuildToolsPreferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferences);
	_g_object_unref0 (self->priv->_dialog);
	_g_object_unref0 (self->priv->_default_store);
	_g_object_unref0 (self->priv->_personal_store);
	_g_object_unref0 (self->priv->_default_view);
	_g_object_unref0 (self->priv->_personal_view);
	G_OBJECT_CLASS (build_tools_preferences_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
build_tools_preferences_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BuildToolsPreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tools_preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildToolsPreferences), 0, (GInstanceInitFunc) build_tools_preferences_instance_init, NULL };
	GType build_tools_preferences_type_id;
	build_tools_preferences_type_id = g_type_register_static (G_TYPE_OBJECT, "BuildToolsPreferences", &g_define_type_info, 0);
	BuildToolsPreferences_private_offset = g_type_add_instance_private (build_tools_preferences_type_id, sizeof (BuildToolsPreferencesPrivate));
	return build_tools_preferences_type_id;
}

GType
build_tools_preferences_get_type (void)
{
	static volatile gsize build_tools_preferences_type_id__volatile = 0;
	if (g_once_init_enter (&build_tools_preferences_type_id__volatile)) {
		GType build_tools_preferences_type_id;
		build_tools_preferences_type_id = build_tools_preferences_get_type_once ();
		g_once_init_leave (&build_tools_preferences_type_id__volatile, build_tools_preferences_type_id);
	}
	return build_tools_preferences_type_id__volatile;
}

