/* main_window_file.c generated by valac 0.48.10, the Vala compiler
 * generated from main_window_file.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2012, 2017 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <latexila.h>
#include <amtk/amtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <tepl/tepl.h>
#include <gobject/gvaluecollector.h>

#define TYPE_MAIN_WINDOW_FILE (main_window_file_get_type ())
#define MAIN_WINDOW_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_FILE, MainWindowFile))
#define MAIN_WINDOW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_FILE, MainWindowFileClass))
#define IS_MAIN_WINDOW_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_FILE))
#define IS_MAIN_WINDOW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_FILE))
#define MAIN_WINDOW_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_FILE, MainWindowFileClass))

typedef struct _MainWindowFile MainWindowFile;
typedef struct _MainWindowFileClass MainWindowFileClass;
typedef struct _MainWindowFilePrivate MainWindowFilePrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _MainWindowPrivate MainWindowPrivate;
typedef struct _ParamSpecMainWindowFile ParamSpecMainWindowFile;

struct _MainWindowFile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MainWindowFilePrivate * priv;
};

struct _MainWindowFileClass {
	GTypeClass parent_class;
	void (*finalize) (MainWindowFile *self);
};

struct _MainWindowFilePrivate {
	MainWindow* _main_window;
	GtkActionGroup* _action_group;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	gchar* default_location;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _ParamSpecMainWindowFile {
	GParamSpec parent_instance;
};

static gint MainWindowFile_private_offset;
static gpointer main_window_file_parent_class = NULL;

gpointer main_window_file_ref (gpointer instance);
void main_window_file_unref (gpointer instance);
GParamSpec* param_spec_main_window_file (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void value_set_main_window_file (GValue* value,
                                 gpointer v_object);
void value_take_main_window_file (GValue* value,
                                  gpointer v_object);
gpointer value_get_main_window_file (const GValue* value);
GType main_window_file_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowFile, main_window_file_unref)
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
void main_window_file_on_file_new (MainWindowFile* self);
static void _main_window_file_on_file_new_gtk_action_callback (GtkAction* action,
                                                        gpointer self);
void main_window_file_on_file_open (MainWindowFile* self);
static void _main_window_file_on_file_open_gtk_action_callback (GtkAction* action,
                                                         gpointer self);
void main_window_file_on_file_save (MainWindowFile* self);
static void _main_window_file_on_file_save_gtk_action_callback (GtkAction* action,
                                                         gpointer self);
void main_window_file_on_file_save_as (MainWindowFile* self);
static void _main_window_file_on_file_save_as_gtk_action_callback (GtkAction* action,
                                                            gpointer self);
void main_window_file_on_create_template (MainWindowFile* self);
static void _main_window_file_on_create_template_gtk_action_callback (GtkAction* action,
                                                               gpointer self);
void main_window_file_on_manage_templates (MainWindowFile* self);
static void _main_window_file_on_manage_templates_gtk_action_callback (GtkAction* action,
                                                                gpointer self);
void main_window_file_on_file_close (MainWindowFile* self);
static void _main_window_file_on_file_close_gtk_action_callback (GtkAction* action,
                                                          gpointer self);
MainWindowFile* main_window_file_new (MainWindow* main_window,
                                      GtkUIManager* ui_manager);
MainWindowFile* main_window_file_construct (GType object_type,
                                            MainWindow* main_window,
                                            GtkUIManager* ui_manager);
static void main_window_file_configure_recent_chooser (MainWindowFile* self,
                                                GtkRecentChooser* recent_chooser);
GType glatex_app_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GlatexApp, g_object_unref)
GlatexApp* glatex_app_get_instance (void);
GtkToolItem* main_window_file_get_toolbar_open_button (MainWindowFile* self);
static void __lambda86_ (MainWindowFile* self,
                  GtkRecentChooser* chooser);
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
DocumentTab* main_window_open_document (MainWindow* self,
                                        GFile* location,
                                        gboolean jump_to);
static void ___lambda86__gtk_recent_chooser_item_activated (GtkRecentChooser* _sender,
                                                     gpointer self);
void main_window_file_update_sensitivity (MainWindowFile* self);
TeplTab* tepl_tab_group_get_active_tab (TeplTabGroup* self);
DocumentTab* main_window_create_tab (MainWindow* self,
                                     gboolean jump_to);
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
Document* document_tab_get_document (DocumentTab* self);
void document_set_contents (Document* self,
                            const gchar* contents);
Document* main_window_get_active_document (MainWindow* self);
GFile* document_get_location (Document* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
DocumentTab* main_window_get_active_tab (MainWindow* self);
gboolean main_window_save_document (MainWindow* self,
                                    Document* doc,
                                    gboolean force_save_as);
gboolean main_window_close_tab (MainWindow* self,
                                DocumentTab* tab,
                                gboolean force_close);
static void main_window_file_finalize (MainWindowFile * obj);
static GType main_window_file_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const GtkActionEntry MAIN_WINDOW_FILE__action_entries[9] = {{"File", NULL, N_ ("_File")}, {"FileNew", "document-new", N_ ("_New"), "<Control>N", N_ ("New file"), (GCallback) _main_window_file_on_file_new_gtk_action_callback}, {"FileNewWindow", NULL, N_ ("New _Window"), NULL, N_ ("Create a new window")}, {"FileOpen", "document-open", N_ ("_Open"), "<Control>O", N_ ("Open a file"), (GCallback) _main_window_file_on_file_open_gtk_action_callback}, {"FileSave", "document-save", N_ ("_Save"), "<Control>S", N_ ("Save the current file"), (GCallback) _main_window_file_on_file_save_gtk_action_callback}, {"FileSaveAs", "document-save-as", N_ ("Save _As"), "<Shift><Control>S", N_ ("Save the current file with a different name"), (GCallback) _main_window_file_on_file_save_as_gtk_action_callback}, {"FileCreateTemplate", NULL, N_ ("Create _Template From Document…"), NULL, N_ ("Create a new template from the current document"), (GCallback) _main_window_file_on_create_template_gtk_action_callback}, {"FileManageTemplates", NULL, N_ ("_Manage Personal Templates…"), NULL, N_ ("Manage personal templates"), (GCallback) _main_window_file_on_manage_templates_gtk_action_callback}, {"FileClose", "window-close", N_ ("_Close"), "<Control>W", N_ ("Close the current file"), (GCallback) _main_window_file_on_file_close_gtk_action_callback}};

static inline gpointer
main_window_file_get_instance_private (MainWindowFile* self)
{
	return G_STRUCT_MEMBER_P (self, MainWindowFile_private_offset);
}

static void
_main_window_file_on_file_new_gtk_action_callback (GtkAction* action,
                                                   gpointer self)
{
	main_window_file_on_file_new ((MainWindowFile*) self);
}

static void
_main_window_file_on_file_open_gtk_action_callback (GtkAction* action,
                                                    gpointer self)
{
	main_window_file_on_file_open ((MainWindowFile*) self);
}

static void
_main_window_file_on_file_save_gtk_action_callback (GtkAction* action,
                                                    gpointer self)
{
	main_window_file_on_file_save ((MainWindowFile*) self);
}

static void
_main_window_file_on_file_save_as_gtk_action_callback (GtkAction* action,
                                                       gpointer self)
{
	main_window_file_on_file_save_as ((MainWindowFile*) self);
}

static void
_main_window_file_on_create_template_gtk_action_callback (GtkAction* action,
                                                          gpointer self)
{
	main_window_file_on_create_template ((MainWindowFile*) self);
}

static void
_main_window_file_on_manage_templates_gtk_action_callback (GtkAction* action,
                                                           gpointer self)
{
	main_window_file_on_manage_templates ((MainWindowFile*) self);
}

static void
_main_window_file_on_file_close_gtk_action_callback (GtkAction* action,
                                                     gpointer self)
{
	main_window_file_on_file_close ((MainWindowFile*) self);
}

MainWindowFile*
main_window_file_construct (GType object_type,
                            MainWindow* main_window,
                            GtkUIManager* ui_manager)
{
	MainWindowFile* self = NULL;
	GtkActionGroup* _tmp0_;
	GtkActionGroup* _tmp1_;
	GtkActionGroup* _tmp2_;
	GtkAction* recent_action = NULL;
	GtkRecentAction* _tmp3_;
	GtkActionGroup* _tmp4_;
	GtkActionGroup* _tmp5_;
	GlatexApp* app = NULL;
	GlatexApp* _tmp6_;
	GtkActionGroup* _tmp7_;
	g_return_val_if_fail (main_window != NULL, NULL);
	g_return_val_if_fail (ui_manager != NULL, NULL);
	self = (MainWindowFile*) g_type_create_instance (object_type);
	self->priv->_main_window = main_window;
	_tmp0_ = gtk_action_group_new ("FileMenuActionGroup");
	_g_object_unref0 (self->priv->_action_group);
	self->priv->_action_group = _tmp0_;
	_tmp1_ = self->priv->_action_group;
	gtk_action_group_set_translation_domain (_tmp1_, GETTEXT_PACKAGE);
	_tmp2_ = self->priv->_action_group;
	gtk_action_group_add_actions (_tmp2_, MAIN_WINDOW_FILE__action_entries, (guint) G_N_ELEMENTS (MAIN_WINDOW_FILE__action_entries), self);
	_tmp3_ = (GtkRecentAction*) gtk_recent_action_new ("FileOpenRecent", _ ("Open _Recent"), _ ("Open recently used files"), "");
	recent_action = (GtkAction*) _tmp3_;
	main_window_file_configure_recent_chooser (self, G_TYPE_CHECK_INSTANCE_TYPE (recent_action, gtk_recent_chooser_get_type ()) ? ((GtkRecentChooser*) recent_action) : NULL);
	_tmp4_ = self->priv->_action_group;
	gtk_action_group_add_action (_tmp4_, recent_action);
	_tmp5_ = self->priv->_action_group;
	gtk_ui_manager_insert_action_group (ui_manager, _tmp5_, 0);
	_tmp6_ = glatex_app_get_instance ();
	app = _tmp6_;
	_tmp7_ = self->priv->_action_group;
	amtk_utils_bind_g_action_to_gtk_action ((GActionMap*) app, "tepl-new-window", _tmp7_, "FileNewWindow");
	_g_object_unref0 (app);
	_g_object_unref0 (recent_action);
	return self;
}

MainWindowFile*
main_window_file_new (MainWindow* main_window,
                      GtkUIManager* ui_manager)
{
	return main_window_file_construct (TYPE_MAIN_WINDOW_FILE, main_window, ui_manager);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GtkToolItem*
main_window_file_get_toolbar_open_button (MainWindowFile* self)
{
	GtkRecentManager* recent_manager = NULL;
	GtkRecentManager* _tmp0_;
	GtkRecentManager* _tmp1_;
	GtkWidget* recent_menu = NULL;
	GtkRecentChooserMenu* _tmp2_;
	GtkMenuToolButton* open_button = NULL;
	GtkMenuToolButton* _tmp3_;
	GtkAction* action = NULL;
	GtkActionGroup* _tmp4_;
	GtkAction* _tmp5_;
	GtkAction* _tmp6_;
	GtkToolItem* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_recent_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	recent_manager = _tmp1_;
	_tmp2_ = (GtkRecentChooserMenu*) gtk_recent_chooser_menu_new_for_manager (recent_manager);
	g_object_ref_sink (_tmp2_);
	recent_menu = (GtkWidget*) _tmp2_;
	main_window_file_configure_recent_chooser (self, G_TYPE_CHECK_INSTANCE_TYPE (recent_menu, gtk_recent_chooser_get_type ()) ? ((GtkRecentChooser*) recent_menu) : NULL);
	_tmp3_ = (GtkMenuToolButton*) gtk_menu_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp3_);
	open_button = _tmp3_;
	gtk_tool_button_set_icon_name ((GtkToolButton*) open_button, "document-open");
	gtk_menu_tool_button_set_menu (open_button, recent_menu);
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) open_button, _ ("Open a file"));
	gtk_menu_tool_button_set_arrow_tooltip_text (open_button, _ ("Open a recently used file"));
	_tmp4_ = self->priv->_action_group;
	_tmp5_ = gtk_action_group_get_action (_tmp4_, "FileOpen");
	_tmp6_ = _g_object_ref0 (_tmp5_);
	action = _tmp6_;
	gtk_activatable_set_related_action ((GtkActivatable*) open_button, action);
	result = (GtkToolItem*) open_button;
	_g_object_unref0 (action);
	_g_object_unref0 (recent_menu);
	_g_object_unref0 (recent_manager);
	return result;
}

static void
__lambda86_ (MainWindowFile* self,
             GtkRecentChooser* chooser)
{
	gchar* uri = NULL;
	gchar* _tmp0_;
	MainWindow* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	DocumentTab* _tmp4_;
	DocumentTab* _tmp5_;
	g_return_if_fail (chooser != NULL);
	_tmp0_ = gtk_recent_chooser_get_current_uri (chooser);
	uri = _tmp0_;
	_tmp1_ = self->priv->_main_window;
	_tmp2_ = g_file_new_for_uri (uri);
	_tmp3_ = _tmp2_;
	_tmp4_ = main_window_open_document (_tmp1_, _tmp3_, TRUE);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	_g_free0 (uri);
}

static void
___lambda86__gtk_recent_chooser_item_activated (GtkRecentChooser* _sender,
                                                gpointer self)
{
	__lambda86_ ((MainWindowFile*) self, _sender);
}

static void
main_window_file_configure_recent_chooser (MainWindowFile* self,
                                           GtkRecentChooser* recent_chooser)
{
	GtkRecentFilter* filter = NULL;
	GtkRecentFilter* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (recent_chooser != NULL);
	gtk_recent_chooser_set_local_only (recent_chooser, FALSE);
	gtk_recent_chooser_set_show_tips (recent_chooser, TRUE);
	gtk_recent_chooser_set_sort_type (recent_chooser, GTK_RECENT_SORT_MRU);
	_tmp0_ = gtk_recent_filter_new ();
	g_object_ref_sink (_tmp0_);
	filter = _tmp0_;
	gtk_recent_filter_add_application (filter, PACKAGE_NAME);
	gtk_recent_chooser_set_filter (recent_chooser, filter);
	g_signal_connect (recent_chooser, "item-activated", (GCallback) ___lambda86__gtk_recent_chooser_item_activated, self);
	_g_object_unref0 (filter);
}

void
main_window_file_update_sensitivity (MainWindowFile* self)
{
	TeplApplicationWindow* tepl_window = NULL;
	MainWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	TeplApplicationWindow* _tmp2_;
	gboolean sensitive = FALSE;
	TeplApplicationWindow* _tmp3_;
	TeplTab* _tmp4_;
	TeplTab* _tmp5_;
	gchar** action_names = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint action_names_length1;
	gint _action_names_size_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	tepl_window = _tmp2_;
	_tmp3_ = tepl_window;
	_tmp4_ = tepl_tab_group_get_active_tab ((TeplTabGroup*) _tmp3_);
	_tmp5_ = _tmp4_;
	sensitive = _tmp5_ != NULL;
	_tmp6_ = g_strdup ("FileSave");
	_tmp7_ = g_strdup ("FileSaveAs");
	_tmp8_ = g_strdup ("FileClose");
	_tmp9_ = g_strdup ("FileCreateTemplate");
	_tmp10_ = g_new0 (gchar*, 4 + 1);
	_tmp10_[0] = _tmp6_;
	_tmp10_[1] = _tmp7_;
	_tmp10_[2] = _tmp8_;
	_tmp10_[3] = _tmp9_;
	action_names = _tmp10_;
	action_names_length1 = 4;
	_action_names_size_ = action_names_length1;
	_tmp11_ = action_names;
	_tmp11__length1 = action_names_length1;
	{
		gchar** action_name_collection = NULL;
		gint action_name_collection_length1 = 0;
		gint _action_name_collection_size_ = 0;
		gint action_name_it = 0;
		action_name_collection = _tmp11_;
		action_name_collection_length1 = _tmp11__length1;
		for (action_name_it = 0; action_name_it < action_name_collection_length1; action_name_it = action_name_it + 1) {
			gchar* _tmp12_;
			gchar* action_name = NULL;
			_tmp12_ = g_strdup (action_name_collection[action_name_it]);
			action_name = _tmp12_;
			{
				GtkAction* action = NULL;
				GtkActionGroup* _tmp13_;
				const gchar* _tmp14_;
				GtkAction* _tmp15_;
				GtkAction* _tmp16_;
				GtkAction* _tmp17_;
				_tmp13_ = self->priv->_action_group;
				_tmp14_ = action_name;
				_tmp15_ = gtk_action_group_get_action (_tmp13_, _tmp14_);
				_tmp16_ = _g_object_ref0 (_tmp15_);
				action = _tmp16_;
				_tmp17_ = action;
				gtk_action_set_sensitive (_tmp17_, sensitive);
				_g_object_unref0 (action);
				_g_free0 (action_name);
			}
		}
	}
	action_names = (_vala_array_free (action_names, action_names_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (tepl_window);
}

void
main_window_file_on_file_new (MainWindowFile* self)
{
	gchar* contents = NULL;
	MainWindow* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = latexila_templates_dialogs_open ((GtkWindow*) _tmp0_);
	contents = _tmp1_;
	_tmp2_ = contents;
	if (_tmp2_ != NULL) {
		DocumentTab* tab = NULL;
		MainWindow* _tmp3_;
		DocumentTab* _tmp4_;
		DocumentTab* _tmp5_;
		Document* _tmp6_;
		Document* _tmp7_;
		const gchar* _tmp8_;
		_tmp3_ = self->priv->_main_window;
		_tmp4_ = main_window_create_tab (_tmp3_, TRUE);
		tab = _tmp4_;
		_tmp5_ = tab;
		_tmp6_ = document_tab_get_document (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = contents;
		document_set_contents (_tmp7_, _tmp8_);
		_g_object_unref0 (tab);
	}
	_g_free0 (contents);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
main_window_file_on_file_open (MainWindowFile* self)
{
	GtkFileChooserDialog* file_chooser = NULL;
	MainWindow* _tmp0_;
	GtkFileChooserDialog* _tmp1_;
	gboolean _tmp2_ = FALSE;
	MainWindow* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	GtkFileChooserDialog* _tmp29_;
	GtkFileChooserDialog* _tmp30_;
	GtkFileFilter* latex_filter = NULL;
	GtkFileFilter* _tmp31_;
	GtkFileFilter* _tmp32_;
	GtkFileFilter* _tmp33_;
	GtkFileFilter* _tmp34_;
	GtkFileChooserDialog* _tmp35_;
	GtkFileFilter* _tmp36_;
	GtkFileFilter* _tmp37_;
	GtkFileFilter* all_files_filter = NULL;
	GtkFileFilter* _tmp38_;
	GtkFileFilter* _tmp39_;
	GtkFileFilter* _tmp40_;
	GtkFileChooserDialog* _tmp41_;
	GtkFileFilter* _tmp42_;
	GtkFileFilter* _tmp43_;
	GSList* files_to_open = NULL;
	GtkFileChooserDialog* _tmp44_;
	MainWindow* _tmp47_;
	GtkFileChooserDialog* _tmp48_;
	gchar* _tmp49_;
	GtkFileChooserDialog* _tmp50_;
	gboolean jump_to = FALSE;
	GSList* _tmp51_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Open Files"), (GtkWindow*) _tmp0_, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Open"), GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp1_);
	file_chooser = _tmp1_;
	_tmp3_ = self->priv->_main_window;
	_tmp4_ = main_window_get_active_document (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		MainWindow* _tmp6_;
		Document* _tmp7_;
		Document* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		_tmp6_ = self->priv->_main_window;
		_tmp7_ = main_window_get_active_document (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = document_get_location (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp2_ = _tmp10_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GFile* location = NULL;
		MainWindow* _tmp11_;
		Document* _tmp12_;
		Document* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
		GFile* _tmp16_;
		gchar* dirname = NULL;
		GFile* _tmp17_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GtkFileChooserDialog* _tmp22_;
		const gchar* _tmp23_;
		_tmp11_ = self->priv->_main_window;
		_tmp12_ = main_window_get_active_document (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = document_get_location (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		location = _tmp16_;
		_tmp17_ = location;
		_tmp18_ = g_file_get_parent (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_file_get_path (_tmp19_);
		_tmp21_ = _tmp20_;
		_g_object_unref0 (_tmp19_);
		dirname = _tmp21_;
		_tmp22_ = file_chooser;
		_tmp23_ = dirname;
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp22_, _tmp23_);
		_g_free0 (dirname);
		_g_object_unref0 (location);
	} else {
		MainWindow* _tmp24_;
		const gchar* _tmp25_;
		_tmp24_ = self->priv->_main_window;
		_tmp25_ = _tmp24_->default_location;
		if (_tmp25_ != NULL) {
			GtkFileChooserDialog* _tmp26_;
			MainWindow* _tmp27_;
			const gchar* _tmp28_;
			_tmp26_ = file_chooser;
			_tmp27_ = self->priv->_main_window;
			_tmp28_ = _tmp27_->default_location;
			gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp26_, _tmp28_);
		}
	}
	_tmp29_ = file_chooser;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp29_, FALSE);
	_tmp30_ = file_chooser;
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) _tmp30_, TRUE);
	_tmp31_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp31_);
	latex_filter = _tmp31_;
	_tmp32_ = latex_filter;
	gtk_file_filter_set_name (_tmp32_, _ ("All LaTeX Files"));
	_tmp33_ = latex_filter;
	gtk_file_filter_add_pattern (_tmp33_, "*.tex");
	_tmp34_ = latex_filter;
	gtk_file_filter_add_pattern (_tmp34_, "*.bib");
	_tmp35_ = file_chooser;
	_tmp36_ = latex_filter;
	_tmp37_ = _g_object_ref0 (_tmp36_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp35_, _tmp37_);
	_tmp38_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp38_);
	all_files_filter = _tmp38_;
	_tmp39_ = all_files_filter;
	gtk_file_filter_set_name (_tmp39_, _ ("All Files"));
	_tmp40_ = all_files_filter;
	gtk_file_filter_add_pattern (_tmp40_, "*");
	_tmp41_ = file_chooser;
	_tmp42_ = all_files_filter;
	_tmp43_ = _g_object_ref0 (_tmp42_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp41_, _tmp43_);
	files_to_open = NULL;
	_tmp44_ = file_chooser;
	if (gtk_dialog_run ((GtkDialog*) _tmp44_) == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserDialog* _tmp45_;
		GSList* _tmp46_;
		_tmp45_ = file_chooser;
		_tmp46_ = gtk_file_chooser_get_files ((GtkFileChooser*) _tmp45_);
		(files_to_open == NULL) ? NULL : (files_to_open = (_g_slist_free__g_object_unref0_ (files_to_open), NULL));
		files_to_open = _tmp46_;
	}
	_tmp47_ = self->priv->_main_window;
	_tmp48_ = file_chooser;
	_tmp49_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp48_);
	_g_free0 (_tmp47_->default_location);
	_tmp47_->default_location = _tmp49_;
	_tmp50_ = file_chooser;
	gtk_widget_destroy ((GtkWidget*) _tmp50_);
	jump_to = TRUE;
	_tmp51_ = files_to_open;
	{
		GSList* file_collection = NULL;
		GSList* file_it = NULL;
		file_collection = _tmp51_;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			GFile* _tmp52_;
			GFile* file = NULL;
			_tmp52_ = _g_object_ref0 ((GFile*) file_it->data);
			file = _tmp52_;
			{
				MainWindow* _tmp53_;
				GFile* _tmp54_;
				DocumentTab* _tmp55_;
				DocumentTab* _tmp56_;
				_tmp53_ = self->priv->_main_window;
				_tmp54_ = file;
				_tmp55_ = main_window_open_document (_tmp53_, _tmp54_, jump_to);
				_tmp56_ = _tmp55_;
				_g_object_unref0 (_tmp56_);
				jump_to = FALSE;
				_g_object_unref0 (file);
			}
		}
	}
	(files_to_open == NULL) ? NULL : (files_to_open = (_g_slist_free__g_object_unref0_ (files_to_open), NULL));
	_g_object_unref0 (all_files_filter);
	_g_object_unref0 (latex_filter);
	_g_object_unref0 (file_chooser);
}

void
main_window_file_on_file_save (MainWindowFile* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	MainWindow* _tmp3_;
	MainWindow* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_window;
	_tmp4_ = self->priv->_main_window;
	_tmp5_ = main_window_get_active_document (_tmp4_);
	_tmp6_ = _tmp5_;
	main_window_save_document (_tmp3_, _tmp6_, FALSE);
}

void
main_window_file_on_file_save_as (MainWindowFile* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	MainWindow* _tmp3_;
	MainWindow* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_window;
	_tmp4_ = self->priv->_main_window;
	_tmp5_ = main_window_get_active_document (_tmp4_);
	_tmp6_ = _tmp5_;
	main_window_save_document (_tmp3_, _tmp6_, TRUE);
}

void
main_window_file_on_create_template (MainWindowFile* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	Document* doc = NULL;
	MainWindow* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter _tmp8_ = {0};
	gchar* template_contents = NULL;
	GtkTextIter _tmp9_;
	GtkTextIter _tmp10_;
	gchar* _tmp11_;
	MainWindow* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_window;
	_tmp4_ = main_window_get_active_document (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	doc = _tmp6_;
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) doc, &_tmp7_, &_tmp8_);
	start = _tmp7_;
	end = _tmp8_;
	_tmp9_ = start;
	_tmp10_ = end;
	_tmp11_ = gtk_text_buffer_get_text ((GtkTextBuffer*) doc, &_tmp9_, &_tmp10_, FALSE);
	template_contents = _tmp11_;
	_tmp12_ = self->priv->_main_window;
	latexila_templates_dialogs_create_template ((GtkWindow*) _tmp12_, template_contents);
	_g_free0 (template_contents);
	_g_object_unref0 (doc);
}

void
main_window_file_on_manage_templates (MainWindowFile* self)
{
	GtkDialog* dialog = NULL;
	MainWindow* _tmp0_;
	LatexilaTemplatesManageDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = (LatexilaTemplatesManageDialog*) latexila_templates_manage_dialog_new ((GtkWindow*) _tmp0_);
	g_object_ref_sink (_tmp1_);
	dialog = (GtkDialog*) _tmp1_;
	gtk_dialog_run (dialog);
	gtk_widget_destroy ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}

void
main_window_file_on_file_close (MainWindowFile* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	MainWindow* _tmp3_;
	MainWindow* _tmp4_;
	DocumentTab* _tmp5_;
	DocumentTab* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_window;
	_tmp4_ = self->priv->_main_window;
	_tmp5_ = main_window_get_active_tab (_tmp4_);
	_tmp6_ = _tmp5_;
	main_window_close_tab (_tmp3_, _tmp6_, FALSE);
}

static void
value_main_window_file_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_main_window_file_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		main_window_file_unref (value->data[0].v_pointer);
	}
}

static void
value_main_window_file_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = main_window_file_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_main_window_file_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_main_window_file_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		MainWindowFile * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = main_window_file_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_main_window_file_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	MainWindowFile ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = main_window_file_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_main_window_file (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ParamSpecMainWindowFile* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MAIN_WINDOW_FILE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_main_window_file (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_FILE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_main_window_file (GValue* value,
                            gpointer v_object)
{
	MainWindowFile * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		main_window_file_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_window_file_unref (old);
	}
}

void
value_take_main_window_file (GValue* value,
                             gpointer v_object)
{
	MainWindowFile * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_window_file_unref (old);
	}
}

static void
main_window_file_class_init (MainWindowFileClass * klass,
                             gpointer klass_data)
{
	main_window_file_parent_class = g_type_class_peek_parent (klass);
	((MainWindowFileClass *) klass)->finalize = main_window_file_finalize;
	g_type_class_adjust_private_offset (klass, &MainWindowFile_private_offset);
}

static void
main_window_file_instance_init (MainWindowFile * self,
                                gpointer klass)
{
	self->priv = main_window_file_get_instance_private (self);
	self->ref_count = 1;
}

static void
main_window_file_finalize (MainWindowFile * obj)
{
	MainWindowFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW_FILE, MainWindowFile);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_action_group);
}

G_GNUC_NO_INLINE static GType
main_window_file_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_main_window_file_init, value_main_window_file_free_value, value_main_window_file_copy_value, value_main_window_file_peek_pointer, "p", value_main_window_file_collect_value, "p", value_main_window_file_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (MainWindowFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindowFile), 0, (GInstanceInitFunc) main_window_file_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType main_window_file_type_id;
	main_window_file_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MainWindowFile", &g_define_type_info, &g_define_type_fundamental_info, 0);
	MainWindowFile_private_offset = g_type_add_instance_private (main_window_file_type_id, sizeof (MainWindowFilePrivate));
	return main_window_file_type_id;
}

GType
main_window_file_get_type (void)
{
	static volatile gsize main_window_file_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_file_type_id__volatile)) {
		GType main_window_file_type_id;
		main_window_file_type_id = main_window_file_get_type_once ();
		g_once_init_leave (&main_window_file_type_id__volatile, main_window_file_type_id);
	}
	return main_window_file_type_id__volatile;
}

gpointer
main_window_file_ref (gpointer instance)
{
	MainWindowFile * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
main_window_file_unref (gpointer instance)
{
	MainWindowFile * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MAIN_WINDOW_FILE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

