/* tab_label.c generated by valac 0.48.10, the Vala compiler
 * generated from tab_label.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2017 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tepl/tepl.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define TYPE_TAB_LABEL (tab_label_get_type ())
#define TAB_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_LABEL, TabLabel))
#define TAB_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_LABEL, TabLabelClass))
#define IS_TAB_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_LABEL))
#define IS_TAB_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_LABEL))
#define TAB_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_LABEL, TabLabelClass))

typedef struct _TabLabel TabLabel;
typedef struct _TabLabelClass TabLabelClass;
typedef struct _TabLabelPrivate TabLabelPrivate;
enum  {
	TAB_LABEL_0_PROPERTY,
	TAB_LABEL_NUM_PROPERTIES
};
static GParamSpec* tab_label_properties[TAB_LABEL_NUM_PROPERTIES];

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _TabLabel {
	TeplTabLabel parent_instance;
	TabLabelPrivate * priv;
};

struct _TabLabelClass {
	TeplTabLabelClass parent_class;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

static gpointer tab_label_parent_class = NULL;

GType tab_label_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TabLabel, g_object_unref)
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
TabLabel* tab_label_new (DocumentTab* tab);
TabLabel* tab_label_construct (GType object_type,
                               DocumentTab* tab);
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
static void _tepl_tab_label_update_tooltip_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self);
static gchar* tab_label_real_get_tooltip_markup (TeplTabLabel* base);
TeplTab* tepl_tab_label_get_tab (TeplTabLabel* self);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self,
                   Project* dest);
void project_destroy (Project* self);
Project* document_get_project (Document* self);
static gchar* tab_label_get_main_file_relative_path (TabLabel* self);
gchar* utils_get_relative_path (GFile* origin,
                                GFile* target,
                                GFile* common_dir);
static GType tab_label_get_type_once (void);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_tepl_tab_label_update_tooltip_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self)
{
	tepl_tab_label_update_tooltip ((TeplTabLabel*) self);
}

TabLabel*
tab_label_construct (GType object_type,
                     DocumentTab* tab)
{
	TabLabel * self = NULL;
	Document* doc = NULL;
	TeplBuffer* _tmp0_;
	Document* _tmp1_;
	g_return_val_if_fail (tab != NULL, NULL);
	self = (TabLabel*) g_object_new (object_type, "tab", tab, NULL);
	_tmp0_ = tepl_tab_get_buffer ((TeplTab*) tab);
	_tmp1_ = _g_object_ref0 (IS_DOCUMENT (_tmp0_) ? ((Document*) _tmp0_) : NULL);
	doc = _tmp1_;
	g_signal_connect_object ((GObject*) doc, "notify::project-id", (GCallback) _tepl_tab_label_update_tooltip_g_object_notify, (TeplTabLabel*) self, 0);
	_g_object_unref0 (doc);
	return self;
}

TabLabel*
tab_label_new (DocumentTab* tab)
{
	return tab_label_construct (TYPE_TAB_LABEL, tab);
}

static gchar*
tab_label_real_get_tooltip_markup (TeplTabLabel* base)
{
	TabLabel * self;
	gchar* base_tooltip = NULL;
	gchar* _tmp0_;
	Document* doc = NULL;
	TeplTab* _tmp1_;
	TeplTab* _tmp2_;
	TeplBuffer* _tmp3_;
	Document* _tmp4_;
	GFile* location = NULL;
	Document* _tmp5_;
	TeplFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	Project* project = NULL;
	Document* _tmp10_;
	Project* _tmp11_;
	Project* _tmp12_;
	const gchar* _tmp13_;
	Project* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* result = NULL;
	self = (TabLabel*) base;
	_tmp0_ = TEPL_TAB_LABEL_CLASS (tab_label_parent_class)->get_tooltip_markup (G_TYPE_CHECK_INSTANCE_CAST (self, tepl_tab_label_get_type (), TeplTabLabel));
	base_tooltip = _tmp0_;
	_tmp1_ = tepl_tab_label_get_tab ((TeplTabLabel*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = tepl_tab_get_buffer (_tmp2_);
	_tmp4_ = _g_object_ref0 (IS_DOCUMENT (_tmp3_) ? ((Document*) _tmp3_) : NULL);
	doc = _tmp4_;
	_tmp5_ = doc;
	_tmp6_ = tepl_buffer_get_file ((TeplBuffer*) _tmp5_);
	_tmp7_ = tepl_file_get_location (_tmp6_);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	location = _tmp8_;
	_tmp9_ = location;
	if (_tmp9_ == NULL) {
		result = base_tooltip;
		_g_object_unref0 (location);
		_g_object_unref0 (doc);
		return result;
	}
	_tmp10_ = doc;
	_tmp11_ = document_get_project (_tmp10_);
	project = _tmp11_;
	_tmp12_ = project;
	if (_tmp12_ == NULL) {
		result = base_tooltip;
		_project_free0 (project);
		_g_object_unref0 (location);
		_g_object_unref0 (doc);
		return result;
	}
	_tmp13_ = base_tooltip;
	if (_tmp13_ == NULL) {
		gchar* _tmp14_;
		_tmp14_ = g_strdup ("");
		_g_free0 (base_tooltip);
		base_tooltip = _tmp14_;
	}
	_tmp15_ = project;
	_tmp16_ = (*_tmp15_).main_file;
	_tmp17_ = location;
	if (g_file_equal (_tmp16_, _tmp17_)) {
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp18_ = base_tooltip;
		_tmp19_ = g_markup_printf_escaped ("\n<b>%s</b>", _ ("Project main file"));
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp18_, _tmp20_, NULL);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp20_);
		result = _tmp22_;
		_project_free0 (project);
		_g_object_unref0 (location);
		_g_object_unref0 (doc);
		_g_free0 (base_tooltip);
		return result;
	}
	_tmp23_ = base_tooltip;
	_tmp24_ = tab_label_get_main_file_relative_path (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_markup_printf_escaped ("\n<b>%s</b> %s", _ ("Project main file:"), _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strconcat (_tmp23_, _tmp27_, NULL);
	_tmp29_ = _tmp28_;
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	result = _tmp29_;
	_project_free0 (project);
	_g_object_unref0 (location);
	_g_object_unref0 (doc);
	_g_free0 (base_tooltip);
	return result;
}

static gchar*
tab_label_get_main_file_relative_path (TabLabel* self)
{
	Document* doc = NULL;
	TeplTab* _tmp0_;
	TeplTab* _tmp1_;
	TeplBuffer* _tmp2_;
	Document* _tmp3_;
	Project* project = NULL;
	Document* _tmp4_;
	Project* _tmp5_;
	Project* _tmp6_;
	GFile* origin = NULL;
	Document* _tmp8_;
	TeplFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* target = NULL;
	Project* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile* common_dir = NULL;
	Project* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	GFile* _tmp18_;
	GFile* _tmp19_;
	GFile* _tmp20_;
	gchar* _tmp21_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tepl_tab_label_get_tab ((TeplTabLabel*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = tepl_tab_get_buffer (_tmp1_);
	_tmp3_ = _g_object_ref0 (IS_DOCUMENT (_tmp2_) ? ((Document*) _tmp2_) : NULL);
	doc = _tmp3_;
	_tmp4_ = doc;
	_tmp5_ = document_get_project (_tmp4_);
	project = _tmp5_;
	_tmp6_ = project;
	if (_tmp6_ == NULL) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup ("");
		result = _tmp7_;
		_project_free0 (project);
		_g_object_unref0 (doc);
		return result;
	}
	_tmp8_ = doc;
	_tmp9_ = tepl_buffer_get_file ((TeplBuffer*) _tmp8_);
	_tmp10_ = tepl_file_get_location (_tmp9_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	origin = _tmp11_;
	_tmp12_ = project;
	_tmp13_ = (*_tmp12_).main_file;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	target = _tmp14_;
	_tmp15_ = project;
	_tmp16_ = (*_tmp15_).directory;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	common_dir = _tmp17_;
	_tmp18_ = origin;
	_tmp19_ = target;
	_tmp20_ = common_dir;
	_tmp21_ = utils_get_relative_path (_tmp18_, _tmp19_, _tmp20_);
	result = _tmp21_;
	_g_object_unref0 (common_dir);
	_g_object_unref0 (target);
	_g_object_unref0 (origin);
	_project_free0 (project);
	_g_object_unref0 (doc);
	return result;
}

static void
tab_label_class_init (TabLabelClass * klass,
                      gpointer klass_data)
{
	tab_label_parent_class = g_type_class_peek_parent (klass);
	((TeplTabLabelClass *) klass)->get_tooltip_markup = (gchar* (*) (TeplTabLabel*)) tab_label_real_get_tooltip_markup;
}

static void
tab_label_instance_init (TabLabel * self,
                         gpointer klass)
{
}

static GType
tab_label_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TabLabelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tab_label_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TabLabel), 0, (GInstanceInitFunc) tab_label_instance_init, NULL };
	GType tab_label_type_id;
	tab_label_type_id = g_type_register_static (tepl_tab_label_get_type (), "TabLabel", &g_define_type_info, 0);
	return tab_label_type_id;
}

GType
tab_label_get_type (void)
{
	static volatile gsize tab_label_type_id__volatile = 0;
	if (g_once_init_enter (&tab_label_type_id__volatile)) {
		GType tab_label_type_id;
		tab_label_type_id = tab_label_get_type_once ();
		g_once_init_leave (&tab_label_type_id__volatile, tab_label_type_id);
	}
	return tab_label_type_id__volatile;
}

