/* structure_model.c generated by valac 0.48.10, the Vala compiler
 * generated from structure_model.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2011-2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gee.h>

#define TYPE_STRUCT_DATA (struct_data_get_type ())
typedef struct _StructData StructData;
typedef enum  {
	STRUCT_TYPE_BEGIN_COMMON_TYPES,
	STRUCT_TYPE_PART,
	STRUCT_TYPE_CHAPTER,
	STRUCT_TYPE_SECTION,
	STRUCT_TYPE_SUBSECTION,
	STRUCT_TYPE_SUBSUBSECTION,
	STRUCT_TYPE_PARAGRAPH,
	STRUCT_TYPE_SUBPARAGRAPH,
	STRUCT_TYPE_LABEL,
	STRUCT_TYPE_INCLUDE,
	STRUCT_TYPE_IMAGE,
	STRUCT_TYPE_TODO,
	STRUCT_TYPE_FIXME,
	STRUCT_TYPE_END_COMMON_TYPES,
	STRUCT_TYPE_BEGIN_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_FIGURE,
	STRUCT_TYPE_END_FIGURE,
	STRUCT_TYPE_BEGIN_TABLE,
	STRUCT_TYPE_END_TABLE,
	STRUCT_TYPE_BEGIN_VERBATIM,
	STRUCT_TYPE_END_VERBATIM,
	STRUCT_TYPE_END_DOCUMENT,
	STRUCT_TYPE_CAPTION,
	STRUCT_TYPE_END_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_TABLE,
	STRUCT_TYPE_FIGURE,
	STRUCT_TYPE_END_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_NB_TYPES
} StructType;

#define TYPE_STRUCT_TYPE (struct_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	STRUCT_COLUMN_PIXBUF,
	STRUCT_COLUMN_TEXT,
	STRUCT_COLUMN_TOOLTIP,
	STRUCT_COLUMN_START_MARK,
	STRUCT_COLUMN_END_MARK,
	STRUCT_COLUMN_TYPE,
	STRUCT_COLUMN_N_COLUMNS
} StructColumn;

#define TYPE_STRUCT_COLUMN (struct_column_get_type ())
typedef enum  {
	STRUCT_LIST_COLUMN_PIXBUF,
	STRUCT_LIST_COLUMN_TEXT,
	STRUCT_LIST_COLUMN_TOOLTIP,
	STRUCT_LIST_COLUMN_N_COLUMNS
} StructListColumn;

#define TYPE_STRUCT_LIST_COLUMN (struct_list_column_get_type ())

#define TYPE_STRUCTURE_MODEL (structure_model_get_type ())
#define STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE_MODEL, StructureModel))
#define STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE_MODEL, StructureModelClass))
#define IS_STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE_MODEL))
#define IS_STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE_MODEL))
#define STRUCTURE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE_MODEL, StructureModelClass))

typedef struct _StructureModel StructureModel;
typedef struct _StructureModelClass StructureModelClass;
typedef struct _StructureModelPrivate StructureModelPrivate;
enum  {
	STRUCTURE_MODEL_0_PROPERTY,
	STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY,
	STRUCTURE_MODEL_NUM_PROPERTIES
};
static GParamSpec* structure_model_properties[STRUCTURE_MODEL_NUM_PROPERTIES];
#define __vala_GtkTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeIter_free (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

struct _StructData {
	StructType type;
	gchar* text;
	GtkTextMark* start_mark;
	GtkTextMark* end_mark;
};

typedef enum  {
	STRUCT_ERROR_GENERAL,
	STRUCT_ERROR_DATA_OUTDATED
} StructError;
#define STRUCT_ERROR struct_error_quark ()
struct _StructureModel {
	GObject parent_instance;
	StructureModelPrivate * priv;
};

struct _StructureModelClass {
	GObjectClass parent_class;
};

struct _StructureModelPrivate {
	gboolean _emit_signals;
	GType* _column_types;
	gint _column_types_length1;
	gint __column_types_size_;
	GNode* _tree;
	gint _stamp;
	guint _nb_nodes;
	GNode* _end_node;
	GeeArrayList* _list_labels;
	GeeArrayList* _list_includes;
	GeeArrayList* _list_tables;
	GeeArrayList* _list_figures;
	GeeArrayList* _list_todos_and_fixmes;
};

static gint StructureModel_private_offset;
static gpointer structure_model_parent_class = NULL;
static GtkTreeModelIface * structure_model_gtk_tree_model_parent_iface = NULL;

GType struct_data_get_type (void) G_GNUC_CONST;
GType struct_type_get_type (void) G_GNUC_CONST;
StructData* struct_data_dup (const StructData* self);
void struct_data_free (StructData* self);
void struct_data_copy (const StructData* self,
                       StructData* dest);
void struct_data_destroy (StructData* self);
GType struct_column_get_type (void) G_GNUC_CONST;
GType struct_list_column_get_type (void) G_GNUC_CONST;
GQuark struct_error_quark (void);
GType structure_model_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (StructureModel, g_object_unref)
static void _struct_data_free0_ (gpointer var);
static gboolean _g_node_free_all_node (GNode* node,
                                GDestroyNotify free_func);
static void _g_node_free_all (GNode* self,
                       GDestroyNotify free_func);
static inline void _g_node_destroy__struct_data_free0_ (GNode* self);
StructureModel* structure_model_new (void);
StructureModel* structure_model_construct (GType object_type);
static void structure_model_new_stamp (StructureModel* self);
static void structure_model_reset_simple_lists (StructureModel* self);
static GtkTreeIter* structure_model_create_iter_at_node (StructureModel* self,
                                                  GNode* node);
static GtkTreeIter* _vala_GtkTreeIter_copy (GtkTreeIter* self);
static gboolean structure_model_iter_is_valid (StructureModel* self,
                                        GtkTreeIter* iter);
static GNode* structure_model_get_node_from_iter (StructureModel* self,
                                           GtkTreeIter* iter);
static gboolean structure_model_column_is_valid (StructureModel* self,
                                          gint index);
static GType structure_model_real_get_column_type (GtkTreeModel* base,
                                            gint index);
static gint structure_model_real_get_n_columns (GtkTreeModel* base);
static GtkTreeModelFlags structure_model_real_get_flags (GtkTreeModel* base);
static gboolean structure_model_real_iter_has_child (GtkTreeModel* base,
                                              GtkTreeIter* iter);
static gint structure_model_real_iter_n_children (GtkTreeModel* base,
                                           GtkTreeIter* iter);
static void structure_model_real_get_value (GtkTreeModel* base,
                                     GtkTreeIter* iter,
                                     gint column,
                                     GValue* val);
gchar* structure_get_icon_from_type (StructType type);
gchar* structure_get_type_name (StructType type);
static gboolean structure_model_real_iter_children (GtkTreeModel* base,
                                             GtkTreeIter* iter,
                                             GtkTreeIter* parent);
static void _vala_GtkTreeIter_free (GtkTreeIter* self);
static gboolean structure_model_real_iter_next (GtkTreeModel* base,
                                         GtkTreeIter* iter);
static gboolean structure_model_real_iter_nth_child (GtkTreeModel* base,
                                              GtkTreeIter* iter,
                                              GtkTreeIter* parent,
                                              gint n);
static gboolean structure_model_real_iter_parent (GtkTreeModel* base,
                                           GtkTreeIter* iter,
                                           GtkTreeIter* child);
static gboolean structure_model_real_get_iter (GtkTreeModel* base,
                                        GtkTreeIter* iter,
                                        GtkTreePath* path);
static GtkTreePath* structure_model_real_get_path (GtkTreeModel* base,
                                            GtkTreeIter* iter);
guint structure_model_get_nb_items (StructureModel* self);
GtkTreeIter* structure_model_add_item_at_end (StructureModel* self,
                                              StructData* item);
static void structure_model_search_end_node (StructureModel* self);
gboolean structure_is_section (StructType type);
static GtkTreeIter* structure_model_insert_item_after (StructureModel* self,
                                                GNode* parent,
                                                GNode* sibling,
                                                StructData* item);
GtkTreeIter* structure_model_get_next_sibling_or_parent (StructureModel* self,
                                                         GtkTreeIter* section_iter,
                                                         GError** error);
void structure_model_delete (StructureModel* self,
                             GtkTreeIter* iter);
static GNode* structure_model_delete_node (StructureModel* self,
                                    GNode* node);
static void structure_model_regenerate_simple_lists (StructureModel* self);
void structure_model_modify_data (StructureModel* self,
                                  GtkTreePath* path,
                                  const gchar* text,
                                  GtkTextMark* end_mark);
gboolean structure_model_get_emit_signals (StructureModel* self);
static void structure_model_make_children_between_marks (StructureModel* self,
                                                  GNode* node);
void structure_model_shift_right (StructureModel* self,
                                  GtkTreeIter* iter);
static void structure_model_shift_node (StructureModel* self,
                                 GNode* node,
                                 gboolean shift_right);
static void structure_model_reinsert_node (StructureModel* self,
                                    GNode* node,
                                    gboolean force_first_child);
void structure_model_shift_left (StructureModel* self,
                                 GtkTreeIter* iter);
gboolean structure_model_item_contains_subparagraph (StructureModel* self,
                                                     GtkTreeIter* iter);
static gboolean structure_model_node_contains_subparagraph (StructureModel* self,
                                                     GNode* node);
static void structure_model_insert_node (StructureModel* self,
                                  GNode* node,
                                  gboolean force_first_child);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void structure_model_insert_node_in_list (StructureModel* self,
                                          GNode* node);
static gint structure_model_compare_nodes (GtkTextMark* mark1,
                                    GtkTextMark* mark2);
void structure_model_populate_list (StructureModel* self,
                                    GtkListStore* store,
                                    StructType type);
static GeeArrayList* structure_model_get_list (StructureModel* self,
                                        StructType type);
GtkTreePath* structure_model_get_tree_path_from_list_num (StructureModel* self,
                                                          StructType list_type,
                                                          gint num);
gint structure_model_get_list_num_from_tree_iter (StructureModel* self,
                                                  GtkTreeIter* tree_iter);
static gboolean __lambda42_ (StructureModel* self,
                      GNode* node);
static gboolean ___lambda42__gnode_traverse_func (GNode* node,
                                           gpointer self);
void structure_model_set_emit_signals (StructureModel* self,
                                       gboolean value);
static void structure_model_finalize (GObject * obj);
static GType structure_model_get_type_once (void);
static void _vala_structure_model_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_structure_model_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
struct_data_copy (const StructData* self,
                  StructData* dest)
{
	StructType _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GtkTextMark* _tmp3_;
	GtkTextMark* _tmp4_;
	GtkTextMark* _tmp5_;
	GtkTextMark* _tmp6_;
	_tmp0_ = (*self).type;
	(*dest).type = _tmp0_;
	_tmp1_ = (*self).text;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).text);
	(*dest).text = _tmp2_;
	_tmp3_ = (*self).start_mark;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 ((*dest).start_mark);
	(*dest).start_mark = _tmp4_;
	_tmp5_ = (*self).end_mark;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 ((*dest).end_mark);
	(*dest).end_mark = _tmp6_;
}

void
struct_data_destroy (StructData* self)
{
	_g_free0 ((*self).text);
	_g_object_unref0 ((*self).start_mark);
	_g_object_unref0 ((*self).end_mark);
}

StructData*
struct_data_dup (const StructData* self)
{
	StructData* dup;
	dup = g_new0 (StructData, 1);
	struct_data_copy (self, dup);
	return dup;
}

void
struct_data_free (StructData* self)
{
	struct_data_destroy (self);
	g_free (self);
}

static GType
struct_data_get_type_once (void)
{
	GType struct_data_type_id;
	struct_data_type_id = g_boxed_type_register_static ("StructData", (GBoxedCopyFunc) struct_data_dup, (GBoxedFreeFunc) struct_data_free);
	return struct_data_type_id;
}

GType
struct_data_get_type (void)
{
	static volatile gsize struct_data_type_id__volatile = 0;
	if (g_once_init_enter (&struct_data_type_id__volatile)) {
		GType struct_data_type_id;
		struct_data_type_id = struct_data_get_type_once ();
		g_once_init_leave (&struct_data_type_id__volatile, struct_data_type_id);
	}
	return struct_data_type_id__volatile;
}

static GType
struct_column_get_type_once (void)
{
	static const GEnumValue values[] = {{STRUCT_COLUMN_PIXBUF, "STRUCT_COLUMN_PIXBUF", "pixbuf"}, {STRUCT_COLUMN_TEXT, "STRUCT_COLUMN_TEXT", "text"}, {STRUCT_COLUMN_TOOLTIP, "STRUCT_COLUMN_TOOLTIP", "tooltip"}, {STRUCT_COLUMN_START_MARK, "STRUCT_COLUMN_START_MARK", "start-mark"}, {STRUCT_COLUMN_END_MARK, "STRUCT_COLUMN_END_MARK", "end-mark"}, {STRUCT_COLUMN_TYPE, "STRUCT_COLUMN_TYPE", "type"}, {STRUCT_COLUMN_N_COLUMNS, "STRUCT_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType struct_column_type_id;
	struct_column_type_id = g_enum_register_static ("StructColumn", values);
	return struct_column_type_id;
}

GType
struct_column_get_type (void)
{
	static volatile gsize struct_column_type_id__volatile = 0;
	if (g_once_init_enter (&struct_column_type_id__volatile)) {
		GType struct_column_type_id;
		struct_column_type_id = struct_column_get_type_once ();
		g_once_init_leave (&struct_column_type_id__volatile, struct_column_type_id);
	}
	return struct_column_type_id__volatile;
}

static GType
struct_list_column_get_type_once (void)
{
	static const GEnumValue values[] = {{STRUCT_LIST_COLUMN_PIXBUF, "STRUCT_LIST_COLUMN_PIXBUF", "pixbuf"}, {STRUCT_LIST_COLUMN_TEXT, "STRUCT_LIST_COLUMN_TEXT", "text"}, {STRUCT_LIST_COLUMN_TOOLTIP, "STRUCT_LIST_COLUMN_TOOLTIP", "tooltip"}, {STRUCT_LIST_COLUMN_N_COLUMNS, "STRUCT_LIST_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType struct_list_column_type_id;
	struct_list_column_type_id = g_enum_register_static ("StructListColumn", values);
	return struct_list_column_type_id;
}

GType
struct_list_column_get_type (void)
{
	static volatile gsize struct_list_column_type_id__volatile = 0;
	if (g_once_init_enter (&struct_list_column_type_id__volatile)) {
		GType struct_list_column_type_id;
		struct_list_column_type_id = struct_list_column_get_type_once ();
		g_once_init_leave (&struct_list_column_type_id__volatile, struct_list_column_type_id);
	}
	return struct_list_column_type_id__volatile;
}

GQuark
struct_error_quark (void)
{
	return g_quark_from_static_string ("struct-error-quark");
}

static inline gpointer
structure_model_get_instance_private (StructureModel* self)
{
	return G_STRUCT_MEMBER_P (self, StructureModel_private_offset);
}

static void
_struct_data_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (struct_data_free (var), NULL));
}

static gboolean
_g_node_free_all_node (GNode* node,
                       GDestroyNotify free_func)
{
	(node->data == NULL) ? NULL : free_func (node->data);
	return FALSE;
}

static void
_g_node_free_all (GNode* self,
                  GDestroyNotify free_func)
{
	(free_func == NULL) ? NULL : g_node_traverse (self, G_POST_ORDER, G_TRAVERSE_ALL, -1, (GNodeTraverseFunc) _g_node_free_all_node, free_func);
	g_node_destroy (self);
}

static inline void
_g_node_destroy__struct_data_free0_ (GNode* self)
{
	_g_node_free_all (self, (GDestroyNotify) _struct_data_free0_);
}

static gpointer
_struct_data_dup0 (gpointer self)
{
	return self ? struct_data_dup (self) : NULL;
}

StructureModel*
structure_model_construct (GType object_type)
{
	StructureModel * self = NULL;
	GType* _tmp0_;
	GType* _tmp1_;
	gint _tmp1__length1;
	GType* _tmp2_;
	gint _tmp2__length1;
	GType* _tmp3_;
	gint _tmp3__length1;
	GType* _tmp4_;
	gint _tmp4__length1;
	GType* _tmp5_;
	gint _tmp5__length1;
	GType* _tmp6_;
	gint _tmp6__length1;
	StructData empty_data = {0};
	StructData _tmp7_ = {0};
	StructData _tmp8_;
	StructData _tmp9_;
	StructData* _tmp10_;
	GNode* _tmp11_;
	self = (StructureModel*) g_object_new (object_type, NULL);
	_tmp0_ = g_new0 (GType, STRUCT_COLUMN_N_COLUMNS);
	self->priv->_column_types = (g_free (self->priv->_column_types), NULL);
	self->priv->_column_types = _tmp0_;
	self->priv->_column_types_length1 = STRUCT_COLUMN_N_COLUMNS;
	self->priv->__column_types_size_ = self->priv->_column_types_length1;
	_tmp1_ = self->priv->_column_types;
	_tmp1__length1 = self->priv->_column_types_length1;
	_tmp1_[STRUCT_COLUMN_PIXBUF] = G_TYPE_STRING;
	_tmp2_ = self->priv->_column_types;
	_tmp2__length1 = self->priv->_column_types_length1;
	_tmp2_[STRUCT_COLUMN_TEXT] = G_TYPE_STRING;
	_tmp3_ = self->priv->_column_types;
	_tmp3__length1 = self->priv->_column_types_length1;
	_tmp3_[STRUCT_COLUMN_TOOLTIP] = G_TYPE_STRING;
	_tmp4_ = self->priv->_column_types;
	_tmp4__length1 = self->priv->_column_types_length1;
	_tmp4_[STRUCT_COLUMN_START_MARK] = gtk_text_mark_get_type ();
	_tmp5_ = self->priv->_column_types;
	_tmp5__length1 = self->priv->_column_types_length1;
	_tmp5_[STRUCT_COLUMN_END_MARK] = gtk_text_mark_get_type ();
	_tmp6_ = self->priv->_column_types;
	_tmp6__length1 = self->priv->_column_types_length1;
	_tmp6_[STRUCT_COLUMN_TYPE] = TYPE_STRUCT_TYPE;
	empty_data = _tmp7_;
	_tmp8_ = empty_data;
	_tmp9_ = _tmp8_;
	_tmp10_ = _struct_data_dup0 (&_tmp9_);
	_tmp11_ = g_node_new (_tmp10_);
	(self->priv->_tree == NULL) ? NULL : (self->priv->_tree = (_g_node_destroy__struct_data_free0_ (self->priv->_tree), NULL));
	self->priv->_tree = _tmp11_;
	structure_model_new_stamp (self);
	structure_model_reset_simple_lists (self);
	struct_data_destroy (&empty_data);
	return self;
}

StructureModel*
structure_model_new (void)
{
	return structure_model_construct (TYPE_STRUCTURE_MODEL);
}

static void
structure_model_new_stamp (StructureModel* self)
{
	g_return_if_fail (self != NULL);
	self->priv->_stamp = (gint) g_random_int ();
}

static GtkTreeIter*
_vala_GtkTreeIter_copy (GtkTreeIter* self)
{
	return g_boxed_copy (gtk_tree_iter_get_type (), self);
}

static gpointer
__vala_GtkTreeIter_copy0 (gpointer self)
{
	return self ? _vala_GtkTreeIter_copy (self) : NULL;
}

static GtkTreeIter*
structure_model_create_iter_at_node (StructureModel* self,
                                     GNode* node)
{
	GNode* _tmp0_;
	GtkTreeIter new_iter = {0};
	GtkTreeIter* _tmp1_;
	GtkTreeIter* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = self->priv->_tree;
	g_return_val_if_fail (node != _tmp0_, NULL);
	memset (&new_iter, 0, sizeof (GtkTreeIter));
	new_iter.stamp = self->priv->_stamp;
	new_iter.user_data = node;
	_tmp1_ = __vala_GtkTreeIter_copy0 (&new_iter);
	result = _tmp1_;
	return result;
}

static gboolean
structure_model_iter_is_valid (StructureModel* self,
                               GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GtkTreeIter _tmp1_;
	void* _tmp2_;
	GNode* node = NULL;
	GtkTreeIter _tmp3_;
	GNode* _tmp4_;
	GNode* _tmp5_;
	gconstpointer _tmp6_;
	StructData data = {0};
	GNode* _tmp7_;
	gconstpointer _tmp8_;
	StructData _tmp9_;
	StructData _tmp10_ = {0};
	StructData _tmp11_;
	const gchar* _tmp12_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	if (_tmp0_.stamp != self->priv->_stamp) {
		result = FALSE;
		return result;
	}
	_tmp1_ = *iter;
	_tmp2_ = _tmp1_.user_data;
	if (_tmp2_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp3_ = *iter;
	_tmp4_ = structure_model_get_node_from_iter (self, &_tmp3_);
	node = _tmp4_;
	_tmp5_ = node;
	_tmp6_ = _tmp5_->data;
	if (((StructData*) _tmp6_) == NULL) {
		result = FALSE;
		return result;
	}
	_tmp7_ = node;
	_tmp8_ = _tmp7_->data;
	_tmp9_ = *((StructData*) _tmp8_);
	struct_data_copy (&_tmp9_, &_tmp10_);
	data = _tmp10_;
	_tmp11_ = data;
	_tmp12_ = _tmp11_.text;
	if (_tmp12_ == NULL) {
		result = FALSE;
		struct_data_destroy (&data);
		return result;
	}
	result = TRUE;
	struct_data_destroy (&data);
	return result;
}

static gboolean
structure_model_column_is_valid (StructureModel* self,
                                 gint index)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (0 <= index) {
		_tmp0_ = index < ((gint) STRUCT_COLUMN_N_COLUMNS);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static GNode*
structure_model_get_node_from_iter (StructureModel* self,
                                    GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	void* _tmp1_;
	GNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	_tmp1_ = _tmp0_.user_data;
	result = (GNode*) _tmp1_;
	return result;
}

/*************************************************************************/
static GType
structure_model_real_get_column_type (GtkTreeModel* base,
                                      gint index)
{
	StructureModel * self;
	GType* _tmp0_;
	gint _tmp0__length1;
	GType _tmp1_;
	GType result = 0UL;
	self = (StructureModel*) base;
	g_return_val_if_fail (structure_model_column_is_valid (self, index), G_TYPE_INVALID);
	_tmp0_ = self->priv->_column_types;
	_tmp0__length1 = self->priv->_column_types_length1;
	_tmp1_ = _tmp0_[index];
	result = _tmp1_;
	return result;
}

static gint
structure_model_real_get_n_columns (GtkTreeModel* base)
{
	StructureModel * self;
	gint result = 0;
	self = (StructureModel*) base;
	result = (gint) STRUCT_COLUMN_N_COLUMNS;
	return result;
}

static GtkTreeModelFlags
structure_model_real_get_flags (GtkTreeModel* base)
{
	StructureModel * self;
	GtkTreeModelFlags result = 0U;
	self = (StructureModel*) base;
	result = 0;
	return result;
}

static gboolean
structure_model_real_iter_has_child (GtkTreeModel* base,
                                     GtkTreeIter* iter)
{
	StructureModel * self;
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	gboolean result = FALSE;
	self = (StructureModel*) base;
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp0_), FALSE);
	_tmp1_ = *iter;
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
	node = _tmp2_;
	result = !G_NODE_IS_LEAF (node);
	return result;
}

static gint
structure_model_real_iter_n_children (GtkTreeModel* base,
                                      GtkTreeIter* iter)
{
	StructureModel * self;
	GNode* node = NULL;
	GNode* _tmp4_;
	gint result = 0;
	self = (StructureModel*) base;
	if (iter == NULL) {
		GNode* _tmp0_;
		_tmp0_ = self->priv->_tree;
		node = _tmp0_;
	} else {
		GtkTreeIter _tmp1_;
		GtkTreeIter _tmp2_;
		GNode* _tmp3_;
		_tmp1_ = *iter;
		g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp1_), -1);
		_tmp2_ = *iter;
		_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
		node = _tmp3_;
	}
	_tmp4_ = node;
	result = (gint) g_node_n_children (_tmp4_);
	return result;
}

static void
structure_model_real_get_value (GtkTreeModel* base,
                                GtkTreeIter* iter,
                                gint column,
                                GValue* val)
{
	StructureModel * self;
	GValue _vala_val = {0};
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	StructData data = {0};
	GNode* _tmp3_;
	gconstpointer _tmp4_;
	StructData _tmp5_;
	StructData _tmp6_ = {0};
	self = (StructureModel*) base;
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	g_return_if_fail (structure_model_iter_is_valid (self, &_tmp0_));
	g_return_if_fail (structure_model_column_is_valid (self, column));
	_tmp1_ = *iter;
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
	node = _tmp2_;
	_tmp3_ = node;
	_tmp4_ = _tmp3_->data;
	_tmp5_ = *((StructData*) _tmp4_);
	struct_data_copy (&_tmp5_, &_tmp6_);
	data = _tmp6_;
	switch (column) {
		case STRUCT_COLUMN_TEXT:
		{
			StructData _tmp7_;
			const gchar* _tmp8_;
			GValue _tmp9_ = {0};
			_tmp7_ = data;
			_tmp8_ = _tmp7_.text;
			g_value_init (&_tmp9_, G_TYPE_STRING);
			g_value_set_string (&_tmp9_, _tmp8_);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp9_;
			break;
		}
		case STRUCT_COLUMN_START_MARK:
		{
			StructData _tmp10_;
			GtkTextMark* _tmp11_;
			GValue _tmp12_ = {0};
			_tmp10_ = data;
			_tmp11_ = _tmp10_.start_mark;
			g_value_init (&_tmp12_, gtk_text_mark_get_type ());
			g_value_set_object (&_tmp12_, _tmp11_);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp12_;
			break;
		}
		case STRUCT_COLUMN_END_MARK:
		{
			StructData _tmp13_;
			GtkTextMark* _tmp14_;
			GValue _tmp15_ = {0};
			_tmp13_ = data;
			_tmp14_ = _tmp13_.end_mark;
			g_value_init (&_tmp15_, gtk_text_mark_get_type ());
			g_value_set_object (&_tmp15_, _tmp14_);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp15_;
			break;
		}
		case STRUCT_COLUMN_TYPE:
		{
			StructData _tmp16_;
			StructType _tmp17_;
			GValue _tmp18_ = {0};
			_tmp16_ = data;
			_tmp17_ = _tmp16_.type;
			g_value_init (&_tmp18_, TYPE_STRUCT_TYPE);
			g_value_set_enum (&_tmp18_, _tmp17_);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp18_;
			break;
		}
		case STRUCT_COLUMN_PIXBUF:
		{
			StructData _tmp19_;
			StructType _tmp20_;
			gchar* _tmp21_;
			GValue _tmp22_ = {0};
			_tmp19_ = data;
			_tmp20_ = _tmp19_.type;
			_tmp21_ = structure_get_icon_from_type (_tmp20_);
			g_value_init (&_tmp22_, G_TYPE_STRING);
			g_value_take_string (&_tmp22_, _tmp21_);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp22_;
			break;
		}
		case STRUCT_COLUMN_TOOLTIP:
		{
			StructData _tmp23_;
			StructType _tmp24_;
			gchar* _tmp25_;
			GValue _tmp26_ = {0};
			_tmp23_ = data;
			_tmp24_ = _tmp23_.type;
			_tmp25_ = structure_get_type_name (_tmp24_);
			g_value_init (&_tmp26_, G_TYPE_STRING);
			g_value_take_string (&_tmp26_, _tmp25_);
			G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
			_vala_val = _tmp26_;
			break;
		}
		default:
		{
			g_return_if_reached ();
		}
	}
	struct_data_destroy (&data);
	if (val) {
		*val = _vala_val;
	} else {
		G_IS_VALUE (&_vala_val) ? (g_value_unset (&_vala_val), NULL) : NULL;
	}
}

static void
_vala_GtkTreeIter_free (GtkTreeIter* self)
{
	g_boxed_free (gtk_tree_iter_get_type (), self);
}

static gboolean
structure_model_real_iter_children (GtkTreeModel* base,
                                    GtkTreeIter* iter,
                                    GtkTreeIter* parent)
{
	StructureModel * self;
	GtkTreeIter _vala_iter = {0};
	GNode* node = NULL;
	GNode* _tmp4_;
	GNode* _tmp5_;
	GNode* _tmp6_;
	GtkTreeIter* _tmp7_;
	GtkTreeIter* _tmp8_;
	gboolean result = FALSE;
	self = (StructureModel*) base;
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
	if (parent == NULL) {
		GNode* _tmp0_;
		_tmp0_ = self->priv->_tree;
		node = _tmp0_;
	} else {
		GtkTreeIter _tmp1_;
		GtkTreeIter _tmp2_;
		GNode* _tmp3_;
		_tmp1_ = *parent;
		g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp1_), FALSE);
		_tmp2_ = *parent;
		_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
		node = _tmp3_;
	}
	_tmp4_ = node;
	if (G_NODE_IS_LEAF (_tmp4_)) {
		result = FALSE;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp5_ = node;
	_tmp6_ = g_node_first_child (_tmp5_);
	_tmp7_ = structure_model_create_iter_at_node (self, _tmp6_);
	_tmp8_ = _tmp7_;
	_vala_iter = *_tmp8_;
	__vala_GtkTreeIter_free0 (_tmp8_);
	result = TRUE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static gboolean
structure_model_real_iter_next (GtkTreeModel* base,
                                GtkTreeIter* iter)
{
	StructureModel * self;
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	GNode* next_node = NULL;
	GNode* _tmp3_;
	GNode* _tmp4_;
	GNode* _tmp5_;
	GNode* _tmp6_;
	GtkTreeIter* _tmp7_;
	GtkTreeIter* _tmp8_;
	gboolean result = FALSE;
	self = (StructureModel*) base;
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp0_), FALSE);
	_tmp1_ = *iter;
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
	node = _tmp2_;
	_tmp3_ = node;
	_tmp4_ = g_node_next_sibling (_tmp3_);
	next_node = _tmp4_;
	_tmp5_ = next_node;
	if (_tmp5_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp6_ = next_node;
	_tmp7_ = structure_model_create_iter_at_node (self, _tmp6_);
	_tmp8_ = _tmp7_;
	*iter = *_tmp8_;
	__vala_GtkTreeIter_free0 (_tmp8_);
	result = TRUE;
	return result;
}

static gboolean
structure_model_real_iter_nth_child (GtkTreeModel* base,
                                     GtkTreeIter* iter,
                                     GtkTreeIter* parent,
                                     gint n)
{
	StructureModel * self;
	GtkTreeIter _vala_iter = {0};
	GNode* node = NULL;
	GNode* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GNode* _tmp7_;
	GNode* _tmp8_;
	GtkTreeIter* _tmp9_;
	GtkTreeIter* _tmp10_;
	gboolean result = FALSE;
	self = (StructureModel*) base;
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
	if (parent == NULL) {
		GNode* _tmp0_;
		_tmp0_ = self->priv->_tree;
		node = _tmp0_;
	} else {
		GtkTreeIter _tmp1_;
		GtkTreeIter _tmp2_;
		GNode* _tmp3_;
		_tmp1_ = *parent;
		g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp1_), FALSE);
		_tmp2_ = *parent;
		_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
		node = _tmp3_;
	}
	_tmp4_ = node;
	if (G_NODE_IS_LEAF (_tmp4_)) {
		result = FALSE;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	if (n < 0) {
		_tmp5_ = TRUE;
	} else {
		GNode* _tmp6_;
		_tmp6_ = node;
		_tmp5_ = g_node_n_children (_tmp6_) <= ((guint) n);
	}
	if (_tmp5_) {
		result = FALSE;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp7_ = node;
	_tmp8_ = g_node_nth_child (_tmp7_, (guint) n);
	_tmp9_ = structure_model_create_iter_at_node (self, _tmp8_);
	_tmp10_ = _tmp9_;
	_vala_iter = *_tmp10_;
	__vala_GtkTreeIter_free0 (_tmp10_);
	result = TRUE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static gboolean
structure_model_real_iter_parent (GtkTreeModel* base,
                                  GtkTreeIter* iter,
                                  GtkTreeIter* child)
{
	StructureModel * self;
	GtkTreeIter _vala_iter = {0};
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	GNode* parent_node = NULL;
	GNode* _tmp3_;
	GNode* _tmp4_;
	GNode* _tmp5_;
	GNode* _tmp6_;
	GNode* _tmp7_;
	GNode* _tmp8_;
	GtkTreeIter* _tmp9_;
	GtkTreeIter* _tmp10_;
	gboolean result = FALSE;
	self = (StructureModel*) base;
	g_return_val_if_fail (child != NULL, FALSE);
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
	_tmp0_ = *child;
	g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp0_), FALSE);
	_tmp1_ = *child;
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
	node = _tmp2_;
	_tmp3_ = node;
	_tmp4_ = _tmp3_->parent;
	parent_node = _tmp4_;
	_tmp5_ = parent_node;
	g_return_val_if_fail (_tmp5_ != NULL, FALSE);
	_tmp6_ = parent_node;
	_tmp7_ = self->priv->_tree;
	if (_tmp6_ == _tmp7_) {
		result = FALSE;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp8_ = parent_node;
	_tmp9_ = structure_model_create_iter_at_node (self, _tmp8_);
	_tmp10_ = _tmp9_;
	_vala_iter = *_tmp10_;
	__vala_GtkTreeIter_free0 (_tmp10_);
	result = TRUE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static gboolean
structure_model_real_get_iter (GtkTreeModel* base,
                               GtkTreeIter* iter,
                               GtkTreePath* path)
{
	StructureModel * self;
	GtkTreeIter _vala_iter = {0};
	gint depth = 0;
	gint* indices = NULL;
	gint _tmp0_ = 0;
	gint* _tmp1_;
	gint indices_length1;
	gint _indices_size_;
	GNode* node = NULL;
	GNode* _tmp2_;
	GNode* _tmp11_;
	GtkTreeIter* _tmp12_;
	GtkTreeIter* _tmp13_;
	gboolean result = FALSE;
	self = (StructureModel*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
	depth = gtk_tree_path_get_depth (path);
	g_return_val_if_fail (1 <= depth, FALSE);
	_tmp1_ = gtk_tree_path_get_indices_with_depth (path, &_tmp0_);
	indices = _tmp1_;
	indices_length1 = _tmp0_;
	_indices_size_ = indices_length1;
	_tmp2_ = self->priv->_tree;
	node = _tmp2_;
	{
		gint cur_depth = 0;
		cur_depth = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint indice = 0;
				gint* _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				gboolean _tmp7_ = FALSE;
				GNode* _tmp9_;
				GNode* _tmp10_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = cur_depth;
					cur_depth = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(cur_depth < depth)) {
					break;
				}
				_tmp5_ = indices;
				_tmp5__length1 = indices_length1;
				_tmp6_ = _tmp5_[cur_depth];
				indice = _tmp6_;
				if (indice < 0) {
					_tmp7_ = TRUE;
				} else {
					GNode* _tmp8_;
					_tmp8_ = node;
					_tmp7_ = g_node_n_children (_tmp8_) <= ((guint) indice);
				}
				if (_tmp7_) {
					result = FALSE;
					if (iter) {
						*iter = _vala_iter;
					}
					return result;
				}
				_tmp9_ = node;
				_tmp10_ = g_node_nth_child (_tmp9_, (guint) indice);
				node = _tmp10_;
			}
		}
	}
	_tmp11_ = node;
	_tmp12_ = structure_model_create_iter_at_node (self, _tmp11_);
	_tmp13_ = _tmp12_;
	_vala_iter = *_tmp13_;
	__vala_GtkTreeIter_free0 (_tmp13_);
	result = TRUE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static GtkTreePath*
structure_model_real_get_path (GtkTreeModel* base,
                               GtkTreeIter* iter)
{
	StructureModel * self;
	GtkTreeIter _tmp0_;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp1_;
	GNode* node = NULL;
	GtkTreeIter _tmp2_;
	GNode* _tmp3_;
	GtkTreePath* result = NULL;
	self = (StructureModel*) base;
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp0_), NULL);
	_tmp1_ = gtk_tree_path_new ();
	path = _tmp1_;
	_tmp2_ = *iter;
	_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
	node = _tmp3_;
	while (TRUE) {
		GNode* _tmp4_;
		gint pos = 0;
		GNode* _tmp5_;
		GNode* _tmp6_;
		GNode* _tmp7_;
		GtkTreePath* _tmp8_;
		GNode* _tmp9_;
		GNode* _tmp10_;
		_tmp4_ = node;
		if (!(!G_NODE_IS_ROOT (_tmp4_))) {
			break;
		}
		_tmp5_ = node;
		_tmp6_ = _tmp5_->parent;
		_tmp7_ = node;
		pos = g_node_child_position (_tmp6_, _tmp7_);
		_tmp8_ = path;
		gtk_tree_path_prepend_index (_tmp8_, pos);
		_tmp9_ = node;
		_tmp10_ = _tmp9_->parent;
		node = _tmp10_;
	}
	result = path;
	return result;
}

/*************************************************************************/
guint
structure_model_get_nb_items (StructureModel* self)
{
	guint result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_nb_nodes;
	return result;
}

GtkTreeIter*
structure_model_add_item_at_end (StructureModel* self,
                                 StructData* item)
{
	GNode* _tmp0_;
	StructType item_depth = 0;
	StructData _tmp1_;
	StructType _tmp2_;
	GNode* parent = NULL;
	GNode* _tmp3_;
	GNode* prev_sibling = NULL;
	GtkTreeIter* end_iter = NULL;
	GNode* _tmp16_;
	GNode* _tmp17_;
	StructData _tmp18_;
	GtkTreeIter* _tmp19_;
	GtkTreeIter* _tmp20_;
	GtkTreeIter* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = self->priv->_end_node;
	if (_tmp0_ == NULL) {
		structure_model_search_end_node (self);
	}
	_tmp1_ = *item;
	_tmp2_ = _tmp1_.type;
	item_depth = _tmp2_;
	_tmp3_ = self->priv->_end_node;
	parent = _tmp3_;
	prev_sibling = NULL;
	while (TRUE) {
		GNode* _tmp4_;
		GNode* _tmp5_;
		StructType cur_depth = 0;
		GNode* _tmp6_;
		gconstpointer _tmp7_;
		StructType _tmp8_;
		gboolean _tmp9_ = FALSE;
		StructType _tmp10_;
		GNode* _tmp13_;
		GNode* _tmp14_;
		GNode* _tmp15_;
		_tmp4_ = parent;
		_tmp5_ = self->priv->_tree;
		if (_tmp4_ == _tmp5_) {
			break;
		}
		_tmp6_ = parent;
		_tmp7_ = _tmp6_->data;
		_tmp8_ = (*((StructData*) _tmp7_)).type;
		cur_depth = _tmp8_;
		_tmp10_ = cur_depth;
		if (structure_is_section (_tmp10_)) {
			StructType _tmp11_;
			StructType _tmp12_;
			_tmp11_ = cur_depth;
			_tmp12_ = item_depth;
			_tmp9_ = _tmp11_ < _tmp12_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			break;
		}
		_tmp13_ = parent;
		prev_sibling = _tmp13_;
		_tmp14_ = parent;
		_tmp15_ = _tmp14_->parent;
		parent = _tmp15_;
	}
	_tmp16_ = parent;
	_tmp17_ = prev_sibling;
	_tmp18_ = *item;
	_tmp19_ = structure_model_insert_item_after (self, _tmp16_, _tmp17_, &_tmp18_);
	end_iter = _tmp19_;
	_tmp20_ = end_iter;
	if (_tmp20_ != NULL) {
		GtkTreeIter* _tmp21_;
		GtkTreeIter _tmp22_;
		GNode* _tmp23_;
		_tmp21_ = end_iter;
		_tmp22_ = *_tmp21_;
		_tmp23_ = structure_model_get_node_from_iter (self, &_tmp22_);
		self->priv->_end_node = _tmp23_;
	}
	result = end_iter;
	return result;
}

GtkTreeIter*
structure_model_get_next_sibling_or_parent (StructureModel* self,
                                            GtkTreeIter* section_iter,
                                            GError** error)
{
	GtkTreeIter _tmp0_;
	GNode* cur_node = NULL;
	GtkTreeIter _tmp2_;
	GNode* _tmp3_;
	GNode* _tmp4_;
	gconstpointer _tmp5_;
	StructType _tmp6_;
	GError* _inner_error0_ = NULL;
	GtkTreeIter* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (section_iter != NULL, NULL);
	_tmp0_ = *section_iter;
	if (!structure_model_iter_is_valid (self, &_tmp0_)) {
		GError* _tmp1_;
		_tmp1_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_GENERAL, "iter is not valid.");
		_inner_error0_ = _tmp1_;
		if (_inner_error0_->domain == STRUCT_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = *section_iter;
	_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
	cur_node = _tmp3_;
	_tmp4_ = cur_node;
	_tmp5_ = _tmp4_->data;
	_tmp6_ = (*((StructData*) _tmp5_)).type;
	if (!structure_is_section (_tmp6_)) {
		GError* _tmp7_;
		_tmp7_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_GENERAL, "iter is not a section.");
		_inner_error0_ = _tmp7_;
		if (_inner_error0_->domain == STRUCT_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	while (TRUE) {
		gboolean _tmp8_ = FALSE;
		GNode* _tmp9_;
		GNode* next_sibling_node = NULL;
		GNode* _tmp12_;
		GNode* _tmp13_;
		GNode* _tmp14_;
		GNode* _tmp17_;
		GNode* _tmp18_;
		_tmp9_ = cur_node;
		if (_tmp9_ != NULL) {
			GNode* _tmp10_;
			GNode* _tmp11_;
			_tmp10_ = cur_node;
			_tmp11_ = self->priv->_tree;
			_tmp8_ = _tmp10_ != _tmp11_;
		} else {
			_tmp8_ = FALSE;
		}
		if (!_tmp8_) {
			break;
		}
		_tmp12_ = cur_node;
		_tmp13_ = g_node_next_sibling (_tmp12_);
		next_sibling_node = _tmp13_;
		_tmp14_ = next_sibling_node;
		if (_tmp14_ != NULL) {
			GNode* _tmp15_;
			GtkTreeIter* _tmp16_;
			_tmp15_ = next_sibling_node;
			_tmp16_ = structure_model_create_iter_at_node (self, _tmp15_);
			result = _tmp16_;
			return result;
		}
		_tmp17_ = cur_node;
		_tmp18_ = _tmp17_->parent;
		cur_node = _tmp18_;
	}
	result = NULL;
	return result;
}

void
structure_model_delete (StructureModel* self,
                        GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	GNode* _tmp3_;
	GNode* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	g_return_if_fail (structure_model_iter_is_valid (self, &_tmp0_));
	_tmp1_ = *iter;
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
	node = _tmp2_;
	_tmp3_ = structure_model_delete_node (self, node);
	_tmp4_ = _tmp3_;
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (_g_node_destroy__struct_data_free0_ (_tmp4_), NULL));
	self->priv->_end_node = NULL;
	structure_model_regenerate_simple_lists (self);
}

void
structure_model_modify_data (StructureModel* self,
                             GtkTreePath* path,
                             const gchar* text,
                             GtkTextMark* end_mark)
{
	GtkTreeIter iter = {0};
	gboolean iter_is_valid = FALSE;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GNode* node = NULL;
	GtkTreeIter _tmp2_;
	GNode* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GNode* _tmp5_;
	gconstpointer _tmp6_;
	gchar* _tmp7_;
	GNode* _tmp8_;
	gconstpointer _tmp9_;
	GtkTextMark* _tmp10_;
	gboolean _tmp11_;
	GNode* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (end_mark != NULL);
	_tmp1_ = gtk_tree_model_get_iter ((GtkTreeModel*) self, &_tmp0_, path);
	iter = _tmp0_;
	iter_is_valid = _tmp1_;
	g_return_if_fail (iter_is_valid);
	_tmp2_ = iter;
	_tmp3_ = structure_model_get_node_from_iter (self, &_tmp2_);
	node = _tmp3_;
	structure_model_new_stamp (self);
	_tmp4_ = text;
	if (_tmp4_ == NULL) {
		_tmp4_ = "";
	}
	_tmp5_ = node;
	_tmp6_ = _tmp5_->data;
	_tmp7_ = g_strdup (_tmp4_);
	_g_free0 ((*((StructData*) _tmp6_)).text);
	(*((StructData*) _tmp6_)).text = _tmp7_;
	_tmp8_ = node;
	_tmp9_ = _tmp8_->data;
	_tmp10_ = _g_object_ref0 (end_mark);
	_g_object_unref0 ((*((StructData*) _tmp9_)).end_mark);
	(*((StructData*) _tmp9_)).end_mark = _tmp10_;
	_tmp11_ = self->priv->_emit_signals;
	if (_tmp11_) {
		GtkTreeIter _tmp12_;
		_tmp12_ = iter;
		gtk_tree_model_row_changed ((GtkTreeModel*) self, path, &_tmp12_);
	}
	_tmp13_ = node;
	structure_model_make_children_between_marks (self, _tmp13_);
}

void
structure_model_shift_right (StructureModel* self,
                             GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	StructType type = 0;
	GNode* _tmp3_;
	gconstpointer _tmp4_;
	StructType _tmp5_;
	gboolean _tmp6_ = FALSE;
	StructType _tmp7_;
	StructType new_type = 0;
	StructType _tmp9_;
	GNode* new_parent = NULL;
	GNode* _tmp10_;
	GNode* _tmp11_;
	gint new_pos = 0;
	gboolean _tmp12_ = FALSE;
	GNode* _tmp13_;
	GNode* node_unlinked = NULL;
	GNode* _tmp22_;
	GNode* _tmp23_;
	GNode* _tmp24_;
	GNode* _tmp25_;
	GNode* _tmp26_;
	GNode* _tmp27_;
	GNode* _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	g_return_if_fail (structure_model_iter_is_valid (self, &_tmp0_));
	_tmp1_ = *iter;
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
	node = _tmp2_;
	_tmp3_ = node;
	_tmp4_ = _tmp3_->data;
	_tmp5_ = (*((StructData*) _tmp4_)).type;
	type = _tmp5_;
	_tmp7_ = type;
	if (structure_is_section (_tmp7_)) {
		StructType _tmp8_;
		_tmp8_ = type;
		_tmp6_ = _tmp8_ != STRUCT_TYPE_SUBPARAGRAPH;
	} else {
		_tmp6_ = FALSE;
	}
	g_return_if_fail (_tmp6_);
	_tmp9_ = type;
	new_type = _tmp9_ + 1;
	_tmp10_ = node;
	_tmp11_ = g_node_prev_sibling (_tmp10_);
	new_parent = _tmp11_;
	_tmp13_ = new_parent;
	if (_tmp13_ == NULL) {
		_tmp12_ = TRUE;
	} else {
		StructType _tmp14_;
		GNode* _tmp15_;
		gconstpointer _tmp16_;
		StructType _tmp17_;
		_tmp14_ = new_type;
		_tmp15_ = new_parent;
		_tmp16_ = _tmp15_->data;
		_tmp17_ = (*((StructData*) _tmp16_)).type;
		_tmp12_ = _tmp14_ <= _tmp17_;
	}
	if (_tmp12_) {
		GNode* _tmp18_;
		GNode* _tmp19_;
		GNode* _tmp20_;
		GNode* _tmp21_;
		_tmp18_ = node;
		_tmp19_ = _tmp18_->parent;
		new_parent = _tmp19_;
		_tmp20_ = new_parent;
		_tmp21_ = node;
		new_pos = g_node_child_position (_tmp20_, _tmp21_);
	} else {
		new_pos = -1;
	}
	_tmp22_ = node;
	_tmp23_ = structure_model_delete_node (self, _tmp22_);
	node_unlinked = _tmp23_;
	_tmp24_ = node_unlinked;
	structure_model_shift_node (self, _tmp24_, TRUE);
	_tmp25_ = new_parent;
	_tmp26_ = node_unlinked;
	node_unlinked = NULL;
	_tmp27_ = g_node_insert (_tmp25_, new_pos, _tmp26_);
	node = _tmp27_;
	_tmp28_ = node;
	structure_model_reinsert_node (self, _tmp28_, FALSE);
	(node_unlinked == NULL) ? NULL : (node_unlinked = (_g_node_destroy__struct_data_free0_ (node_unlinked), NULL));
}

void
structure_model_shift_left (StructureModel* self,
                            GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	StructType type = 0;
	GNode* _tmp3_;
	gconstpointer _tmp4_;
	StructType _tmp5_;
	gboolean _tmp6_ = FALSE;
	StructType _tmp7_;
	StructType new_type = 0;
	StructType _tmp9_;
	GNode* new_parent = NULL;
	gint new_pos = 0;
	GNode* parent = NULL;
	GNode* _tmp10_;
	GNode* _tmp11_;
	gboolean _tmp12_ = FALSE;
	GNode* _tmp13_;
	GNode* _tmp14_;
	GNode* sibling = NULL;
	GNode* _tmp26_;
	GNode* _tmp27_;
	GNode* node_unlinked = NULL;
	GNode* _tmp28_;
	GNode* _tmp29_;
	GNode* _tmp30_;
	GNode* _tmp43_;
	GNode* _tmp44_;
	GNode* _tmp45_;
	GNode* _tmp46_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	g_return_if_fail (structure_model_iter_is_valid (self, &_tmp0_));
	_tmp1_ = *iter;
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
	node = _tmp2_;
	_tmp3_ = node;
	_tmp4_ = _tmp3_->data;
	_tmp5_ = (*((StructData*) _tmp4_)).type;
	type = _tmp5_;
	_tmp7_ = type;
	if (STRUCT_TYPE_PART < _tmp7_) {
		StructType _tmp8_;
		_tmp8_ = type;
		_tmp6_ = _tmp8_ <= STRUCT_TYPE_SUBPARAGRAPH;
	} else {
		_tmp6_ = FALSE;
	}
	g_return_if_fail (_tmp6_);
	_tmp9_ = type;
	new_type = _tmp9_ - 1;
	_tmp10_ = node;
	_tmp11_ = _tmp10_->parent;
	parent = _tmp11_;
	_tmp13_ = parent;
	_tmp14_ = self->priv->_tree;
	if (_tmp13_ == _tmp14_) {
		_tmp12_ = TRUE;
	} else {
		GNode* _tmp15_;
		gconstpointer _tmp16_;
		StructType _tmp17_;
		StructType _tmp18_;
		_tmp15_ = parent;
		_tmp16_ = _tmp15_->data;
		_tmp17_ = (*((StructData*) _tmp16_)).type;
		_tmp18_ = new_type;
		_tmp12_ = _tmp17_ < _tmp18_;
	}
	if (_tmp12_) {
		GNode* _tmp19_;
		GNode* _tmp20_;
		GNode* _tmp21_;
		_tmp19_ = parent;
		new_parent = _tmp19_;
		_tmp20_ = parent;
		_tmp21_ = node;
		new_pos = g_node_child_position (_tmp20_, _tmp21_);
	} else {
		GNode* _tmp22_;
		GNode* _tmp23_;
		GNode* _tmp24_;
		GNode* _tmp25_;
		_tmp22_ = parent;
		_tmp23_ = _tmp22_->parent;
		new_parent = _tmp23_;
		_tmp24_ = new_parent;
		_tmp25_ = parent;
		new_pos = g_node_child_position (_tmp24_, _tmp25_) + 1;
	}
	_tmp26_ = node;
	_tmp27_ = g_node_next_sibling (_tmp26_);
	sibling = _tmp27_;
	_tmp28_ = node;
	_tmp29_ = structure_model_delete_node (self, _tmp28_);
	node_unlinked = _tmp29_;
	_tmp30_ = node_unlinked;
	structure_model_shift_node (self, _tmp30_, FALSE);
	while (TRUE) {
		GNode* _tmp31_;
		GNode* _tmp32_;
		gconstpointer _tmp33_;
		StructType _tmp34_;
		StructType _tmp35_;
		GNode* next_sibling = NULL;
		GNode* _tmp36_;
		GNode* _tmp37_;
		GNode* new_child = NULL;
		GNode* _tmp38_;
		GNode* _tmp39_;
		GNode* _tmp40_;
		GNode* _tmp41_;
		GNode* _tmp42_;
		_tmp31_ = sibling;
		if (!(_tmp31_ != NULL)) {
			break;
		}
		_tmp32_ = sibling;
		_tmp33_ = _tmp32_->data;
		_tmp34_ = (*((StructData*) _tmp33_)).type;
		_tmp35_ = new_type;
		if (_tmp34_ <= _tmp35_) {
			break;
		}
		_tmp36_ = sibling;
		_tmp37_ = g_node_next_sibling (_tmp36_);
		next_sibling = _tmp37_;
		_tmp38_ = sibling;
		_tmp39_ = structure_model_delete_node (self, _tmp38_);
		new_child = _tmp39_;
		_tmp40_ = node_unlinked;
		_tmp41_ = new_child;
		new_child = NULL;
		g_node_append (_tmp40_, _tmp41_);
		_tmp42_ = next_sibling;
		sibling = _tmp42_;
		(new_child == NULL) ? NULL : (new_child = (_g_node_destroy__struct_data_free0_ (new_child), NULL));
	}
	_tmp43_ = new_parent;
	_tmp44_ = node_unlinked;
	node_unlinked = NULL;
	_tmp45_ = g_node_insert (_tmp43_, new_pos, _tmp44_);
	node = _tmp45_;
	_tmp46_ = node;
	structure_model_reinsert_node (self, _tmp46_, FALSE);
	(node_unlinked == NULL) ? NULL : (node_unlinked = (_g_node_destroy__struct_data_free0_ (node_unlinked), NULL));
}

gboolean
structure_model_item_contains_subparagraph (StructureModel* self,
                                            GtkTreeIter* iter)
{
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp0_), FALSE);
	_tmp1_ = *iter;
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
	node = _tmp2_;
	result = structure_model_node_contains_subparagraph (self, node);
	return result;
}

static gboolean
structure_model_node_contains_subparagraph (StructureModel* self,
                                            GNode* node)
{
	StructType type = 0;
	gconstpointer _tmp0_;
	StructType _tmp1_;
	StructType _tmp2_;
	StructType _tmp3_;
	GNode* child = NULL;
	GNode* _tmp4_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = node->data;
	_tmp1_ = (*((StructData*) _tmp0_)).type;
	type = _tmp1_;
	_tmp2_ = type;
	if (_tmp2_ == STRUCT_TYPE_SUBPARAGRAPH) {
		result = TRUE;
		return result;
	}
	_tmp3_ = type;
	if (!structure_is_section (_tmp3_)) {
		result = FALSE;
		return result;
	}
	_tmp4_ = g_node_first_child (node);
	child = _tmp4_;
	while (TRUE) {
		GNode* _tmp5_;
		GNode* _tmp6_;
		GNode* _tmp7_;
		GNode* _tmp8_;
		_tmp5_ = child;
		if (!(_tmp5_ != NULL)) {
			break;
		}
		_tmp6_ = child;
		if (structure_model_node_contains_subparagraph (self, _tmp6_)) {
			result = TRUE;
			return result;
		}
		_tmp7_ = child;
		_tmp8_ = g_node_next_sibling (_tmp7_);
		child = _tmp8_;
	}
	result = FALSE;
	return result;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
structure_model_insert_node (StructureModel* self,
                             GNode* node,
                             gboolean force_first_child)
{
	guint _tmp0_;
	gboolean _tmp1_;
	GtkTreeIter item_iter = {0};
	GtkTreeIter* _tmp2_;
	GtkTreeIter* _tmp3_;
	GtkTreeIter _tmp4_;
	GtkTreePath* item_path = NULL;
	GtkTreeIter _tmp5_;
	GtkTreePath* _tmp6_;
	GtkTreePath* _tmp7_;
	GtkTreeIter _tmp8_;
	GNode* parent = NULL;
	GNode* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GNode* _tmp11_;
	GNode* _tmp12_;
	gboolean first_child = FALSE;
	gboolean _tmp15_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	structure_model_new_stamp (self);
	_tmp0_ = self->priv->_nb_nodes;
	self->priv->_nb_nodes = _tmp0_ + 1;
	_tmp1_ = self->priv->_emit_signals;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = structure_model_create_iter_at_node (self, node);
	_tmp3_ = _tmp2_;
	_tmp4_ = *_tmp3_;
	__vala_GtkTreeIter_free0 (_tmp3_);
	item_iter = _tmp4_;
	_tmp5_ = item_iter;
	_tmp6_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp5_);
	item_path = _tmp6_;
	_tmp7_ = item_path;
	_tmp8_ = item_iter;
	gtk_tree_model_row_inserted ((GtkTreeModel*) self, _tmp7_, &_tmp8_);
	_tmp9_ = node->parent;
	parent = _tmp9_;
	_tmp11_ = parent;
	_tmp12_ = self->priv->_tree;
	if (_tmp11_ != _tmp12_) {
		GNode* _tmp13_;
		GNode* _tmp14_;
		_tmp13_ = parent;
		_tmp14_ = _tmp13_->children;
		_tmp10_ = _tmp14_ == node;
	} else {
		_tmp10_ = FALSE;
	}
	first_child = _tmp10_;
	if (force_first_child) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = first_child;
	}
	if (_tmp15_) {
		GtkTreeIter parent_iter = {0};
		GNode* _tmp16_;
		GtkTreeIter* _tmp17_;
		GtkTreeIter* _tmp18_;
		GtkTreeIter _tmp19_;
		GtkTreePath* parent_path = NULL;
		GtkTreeIter _tmp20_;
		GtkTreePath* _tmp21_;
		GtkTreePath* _tmp22_;
		GtkTreeIter _tmp23_;
		_tmp16_ = parent;
		_tmp17_ = structure_model_create_iter_at_node (self, _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = *_tmp18_;
		__vala_GtkTreeIter_free0 (_tmp18_);
		parent_iter = _tmp19_;
		_tmp20_ = parent_iter;
		_tmp21_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp20_);
		parent_path = _tmp21_;
		_tmp22_ = parent_path;
		_tmp23_ = parent_iter;
		gtk_tree_model_row_has_child_toggled ((GtkTreeModel*) self, _tmp22_, &_tmp23_);
		__vala_GtkTreePath_free0 (parent_path);
	}
	__vala_GtkTreePath_free0 (item_path);
}

static GNode*
g_node_unlink_vala (GNode* self)
{
	void* ptr = NULL;
	void* _tmp0_;
	GNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	ptr = self;
	g_node_unlink (self);
	_tmp0_ = ptr;
	ptr = NULL;
	result = (GNode*) _tmp0_;
	return result;
}

static GNode*
structure_model_delete_node (StructureModel* self,
                             GNode* node)
{
	GtkTreePath* path = NULL;
	GNode* parent = NULL;
	gboolean _tmp0_;
	GNode* node_unlinked = NULL;
	GNode* _tmp7_;
	GNode* _tmp8_;
	gboolean _tmp9_;
	GNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	structure_model_new_stamp (self);
	path = NULL;
	parent = NULL;
	_tmp0_ = self->priv->_emit_signals;
	if (_tmp0_) {
		GtkTreeIter* iter = NULL;
		GtkTreeIter* _tmp1_;
		GtkTreeIter* _tmp2_;
		GtkTreeIter* _tmp3_;
		GtkTreeIter _tmp4_;
		GtkTreePath* _tmp5_;
		GNode* _tmp6_;
		_tmp1_ = structure_model_create_iter_at_node (self, node);
		iter = _tmp1_;
		_tmp2_ = iter;
		g_return_val_if_fail (_tmp2_ != NULL, NULL);
		_tmp3_ = iter;
		_tmp4_ = *_tmp3_;
		_tmp5_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp4_);
		__vala_GtkTreePath_free0 (path);
		path = _tmp5_;
		_tmp6_ = node->parent;
		parent = _tmp6_;
		__vala_GtkTreeIter_free0 (iter);
	}
	_tmp7_ = g_node_unlink_vala (node);
	node_unlinked = _tmp7_;
	_tmp8_ = node_unlinked;
	self->priv->_nb_nodes = self->priv->_nb_nodes - g_node_n_nodes (_tmp8_, G_TRAVERSE_ALL);
	_tmp9_ = self->priv->_emit_signals;
	if (_tmp9_) {
		GtkTreePath* _tmp10_;
		gboolean _tmp11_ = FALSE;
		GNode* _tmp12_;
		GNode* _tmp13_;
		_tmp10_ = path;
		gtk_tree_model_row_deleted ((GtkTreeModel*) self, _tmp10_);
		_tmp12_ = parent;
		_tmp13_ = self->priv->_tree;
		if (_tmp12_ != _tmp13_) {
			GNode* _tmp14_;
			GNode* _tmp15_;
			_tmp14_ = parent;
			_tmp15_ = _tmp14_->children;
			_tmp11_ = _tmp15_ == NULL;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			GtkTreeIter parent_iter = {0};
			GNode* _tmp16_;
			GtkTreeIter* _tmp17_;
			GtkTreeIter* _tmp18_;
			GtkTreeIter _tmp19_;
			GtkTreePath* parent_path = NULL;
			GtkTreeIter _tmp20_;
			GtkTreePath* _tmp21_;
			GtkTreePath* _tmp22_;
			GtkTreeIter _tmp23_;
			_tmp16_ = parent;
			_tmp17_ = structure_model_create_iter_at_node (self, _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = *_tmp18_;
			__vala_GtkTreeIter_free0 (_tmp18_);
			parent_iter = _tmp19_;
			_tmp20_ = parent_iter;
			_tmp21_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp20_);
			parent_path = _tmp21_;
			_tmp22_ = parent_path;
			_tmp23_ = parent_iter;
			gtk_tree_model_row_has_child_toggled ((GtkTreeModel*) self, _tmp22_, &_tmp23_);
			__vala_GtkTreePath_free0 (parent_path);
		}
	}
	result = node_unlinked;
	__vala_GtkTreePath_free0 (path);
	return result;
}

static void
structure_model_shift_node (StructureModel* self,
                            GNode* node,
                            gboolean shift_right)
{
	gconstpointer _tmp0_;
	StructType _tmp1_;
	GNode* child = NULL;
	GNode* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node->data;
	_tmp1_ = (*((StructData*) _tmp0_)).type;
	if (!structure_is_section (_tmp1_)) {
		return;
	}
	if (shift_right) {
		gconstpointer _tmp2_;
		StructType _tmp3_;
		_tmp2_ = node->data;
		_tmp3_ = (*((StructData*) _tmp2_)).type;
		if (_tmp3_ != STRUCT_TYPE_SUBPARAGRAPH) {
			gconstpointer _tmp4_;
			gconstpointer _tmp5_;
			StructType _tmp6_;
			_tmp4_ = node->data;
			_tmp5_ = node->data;
			_tmp6_ = (*((StructData*) _tmp5_)).type;
			(*((StructData*) _tmp5_)).type = _tmp6_ + 1;
		}
	} else {
		gconstpointer _tmp7_;
		StructType _tmp8_;
		_tmp7_ = node->data;
		_tmp8_ = (*((StructData*) _tmp7_)).type;
		if (_tmp8_ != STRUCT_TYPE_PART) {
			gconstpointer _tmp9_;
			gconstpointer _tmp10_;
			StructType _tmp11_;
			_tmp9_ = node->data;
			_tmp10_ = node->data;
			_tmp11_ = (*((StructData*) _tmp10_)).type;
			(*((StructData*) _tmp10_)).type = _tmp11_ - 1;
		}
	}
	_tmp12_ = g_node_first_child (node);
	child = _tmp12_;
	while (TRUE) {
		GNode* _tmp13_;
		GNode* _tmp14_;
		GNode* _tmp15_;
		GNode* _tmp16_;
		_tmp13_ = child;
		if (!(_tmp13_ != NULL)) {
			break;
		}
		_tmp14_ = child;
		structure_model_shift_node (self, _tmp14_, shift_right);
		_tmp15_ = child;
		_tmp16_ = g_node_next_sibling (_tmp15_);
		child = _tmp16_;
	}
}

static void
structure_model_reinsert_node (StructureModel* self,
                               GNode* node,
                               gboolean force_first_child)
{
	GNode* child = NULL;
	GNode* _tmp0_;
	gboolean first_child = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	structure_model_insert_node (self, node, force_first_child);
	_tmp0_ = g_node_first_child (node);
	child = _tmp0_;
	first_child = TRUE;
	while (TRUE) {
		GNode* _tmp1_;
		GNode* _tmp2_;
		GNode* _tmp3_;
		GNode* _tmp4_;
		_tmp1_ = child;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = child;
		structure_model_reinsert_node (self, _tmp2_, first_child);
		_tmp3_ = child;
		_tmp4_ = g_node_next_sibling (_tmp3_);
		child = _tmp4_;
		first_child = FALSE;
	}
}

static GtkTreeIter*
structure_model_insert_item_after (StructureModel* self,
                                   GNode* parent,
                                   GNode* sibling,
                                   StructData* item)
{
	StructData _tmp0_;
	const gchar* _tmp1_;
	GNode* new_node = NULL;
	StructData _tmp2_;
	StructData _tmp3_;
	StructData* _tmp4_;
	GNode* _tmp5_;
	GNode* _tmp6_;
	GtkTreeIter* _tmp7_;
	GtkTreeIter* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = *item;
	_tmp1_ = _tmp0_.text;
	g_return_val_if_fail (_tmp1_ != NULL, NULL);
	_tmp2_ = *item;
	_tmp3_ = _tmp2_;
	_tmp4_ = _struct_data_dup0 (&_tmp3_);
	_tmp5_ = g_node_new (_tmp4_);
	_tmp6_ = g_node_insert_after (parent, sibling, _tmp5_);
	new_node = _tmp6_;
	structure_model_insert_node (self, new_node, FALSE);
	structure_model_insert_node_in_list (self, new_node);
	_tmp7_ = structure_model_create_iter_at_node (self, new_node);
	result = _tmp7_;
	return result;
}

static void
structure_model_make_children_between_marks (StructureModel* self,
                                             GNode* node)
{
	StructData data = {0};
	gconstpointer _tmp0_;
	StructData _tmp1_;
	StructData _tmp2_ = {0};
	StructData _tmp3_;
	GtkTextMark* _tmp4_;
	GNode* sibling = NULL;
	GNode* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node->data;
	_tmp1_ = *((StructData*) _tmp0_);
	struct_data_copy (&_tmp1_, &_tmp2_);
	data = _tmp2_;
	_tmp3_ = data;
	_tmp4_ = _tmp3_.end_mark;
	if (_tmp4_ == NULL) {
		struct_data_destroy (&data);
		return;
	}
	_tmp5_ = g_node_next_sibling (node);
	sibling = _tmp5_;
	while (TRUE) {
		GNode* _tmp6_;
		StructData sibling_data = {0};
		GNode* _tmp7_;
		gconstpointer _tmp8_;
		StructData _tmp9_;
		StructData _tmp10_ = {0};
		StructData _tmp11_;
		StructType _tmp12_;
		StructData _tmp13_;
		GtkTextMark* _tmp14_;
		StructData _tmp15_;
		GtkTextMark* _tmp16_;
		GNode* sibling_unlinked = NULL;
		GNode* _tmp17_;
		GNode* _tmp18_;
		GNode* new_child = NULL;
		GNode* _tmp19_;
		GNode* _tmp20_;
		GNode* _tmp21_;
		GNode* _tmp22_;
		_tmp6_ = sibling;
		if (!(_tmp6_ != NULL)) {
			break;
		}
		_tmp7_ = sibling;
		_tmp8_ = _tmp7_->data;
		_tmp9_ = *((StructData*) _tmp8_);
		struct_data_copy (&_tmp9_, &_tmp10_);
		sibling_data = _tmp10_;
		_tmp11_ = sibling_data;
		_tmp12_ = _tmp11_.type;
		if (structure_is_section (_tmp12_)) {
			struct_data_destroy (&sibling_data);
			break;
		}
		_tmp13_ = data;
		_tmp14_ = _tmp13_.end_mark;
		_tmp15_ = sibling_data;
		_tmp16_ = _tmp15_.start_mark;
		if (structure_model_compare_nodes (_tmp14_, _tmp16_) <= 0) {
			struct_data_destroy (&sibling_data);
			break;
		}
		_tmp17_ = sibling;
		_tmp18_ = structure_model_delete_node (self, _tmp17_);
		sibling_unlinked = _tmp18_;
		_tmp19_ = sibling_unlinked;
		sibling_unlinked = NULL;
		_tmp20_ = g_node_append (node, _tmp19_);
		new_child = _tmp20_;
		_tmp21_ = new_child;
		structure_model_insert_node (self, _tmp21_, FALSE);
		_tmp22_ = g_node_next_sibling (node);
		sibling = _tmp22_;
		(sibling_unlinked == NULL) ? NULL : (sibling_unlinked = (_g_node_destroy__struct_data_free0_ (sibling_unlinked), NULL));
		struct_data_destroy (&sibling_data);
	}
	struct_data_destroy (&data);
}

static void
structure_model_search_end_node (StructureModel* self)
{
	GNode* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_tree;
	self->priv->_end_node = _tmp0_;
	while (TRUE) {
		GNode* _tmp1_;
		GNode* _tmp2_;
		GNode* _tmp3_;
		_tmp1_ = self->priv->_end_node;
		if (!(!G_NODE_IS_LEAF (_tmp1_))) {
			break;
		}
		_tmp2_ = self->priv->_end_node;
		_tmp3_ = g_node_last_child (_tmp2_);
		self->priv->_end_node = _tmp3_;
	}
}

static gint
structure_model_compare_nodes (GtkTextMark* mark1,
                               GtkTextMark* mark2)
{
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextIter iter1 = {0};
	GtkTextIter iter2 = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_;
	gint result = 0;
	g_return_val_if_fail (mark1 != NULL, 0);
	g_return_val_if_fail (mark2 != NULL, 0);
	_tmp0_ = gtk_text_mark_get_buffer (mark1);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	doc = _tmp1_;
	_tmp2_ = gtk_text_mark_get_buffer (mark2);
	g_return_val_if_fail (doc == _tmp2_, 0);
	gtk_text_buffer_get_iter_at_mark (doc, &_tmp3_, mark1);
	iter1 = _tmp3_;
	gtk_text_buffer_get_iter_at_mark (doc, &_tmp4_, mark2);
	iter2 = _tmp4_;
	_tmp5_ = iter2;
	result = gtk_text_iter_compare (&iter1, &_tmp5_);
	_g_object_unref0 (doc);
	return result;
}

/*************************************************************************/
void
structure_model_populate_list (StructureModel* self,
                               GtkListStore* store,
                               StructType type)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = structure_model_get_list (self, type);
	list = _tmp0_;
	_tmp1_ = list;
	g_return_if_fail (_tmp1_ != NULL);
	{
		GeeArrayList* _node_list = NULL;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _node_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _node_index = 0;
		_tmp2_ = list;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_node_list = _tmp3_;
		_tmp4_ = _node_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_node_size = _tmp6_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			GNode* node = NULL;
			GeeArrayList* _tmp9_;
			gpointer _tmp10_;
			StructData data = {0};
			GNode* _tmp11_;
			gconstpointer _tmp12_;
			StructData _tmp13_;
			StructData _tmp14_ = {0};
			GtkTreeIter iter = {0};
			GtkTreeIter _tmp15_ = {0};
			GtkTreeIter _tmp16_;
			StructData _tmp17_;
			StructType _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			StructData _tmp21_;
			const gchar* _tmp22_;
			StructData _tmp23_;
			StructType _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_node_index = _node_index + 1;
			_tmp7_ = _node_index;
			_tmp8_ = _node_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _node_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _node_index);
			node = (GNode*) _tmp10_;
			_tmp11_ = node;
			_tmp12_ = _tmp11_->data;
			_tmp13_ = *((StructData*) _tmp12_);
			struct_data_copy (&_tmp13_, &_tmp14_);
			data = _tmp14_;
			gtk_list_store_append (store, &_tmp15_);
			iter = _tmp15_;
			_tmp16_ = iter;
			_tmp17_ = data;
			_tmp18_ = _tmp17_.type;
			_tmp19_ = structure_get_icon_from_type (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = data;
			_tmp22_ = _tmp21_.text;
			_tmp23_ = data;
			_tmp24_ = _tmp23_.type;
			_tmp25_ = structure_get_type_name (_tmp24_);
			_tmp26_ = _tmp25_;
			gtk_list_store_set (store, &_tmp16_, STRUCT_LIST_COLUMN_PIXBUF, _tmp20_, STRUCT_LIST_COLUMN_TEXT, _tmp22_, STRUCT_LIST_COLUMN_TOOLTIP, _tmp26_, -1);
			_g_free0 (_tmp26_);
			_g_free0 (_tmp20_);
			struct_data_destroy (&data);
		}
		_g_object_unref0 (_node_list);
	}
	_g_object_unref0 (list);
}

GtkTreePath*
structure_model_get_tree_path_from_list_num (StructureModel* self,
                                             StructType list_type,
                                             gint num)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeArrayList* _tmp6_;
	gpointer _tmp7_;
	GtkTreeIter* _tmp8_;
	GtkTreeIter* _tmp9_;
	GtkTreeIter _tmp10_;
	GtkTreePath* _tmp11_;
	GtkTreePath* _tmp12_;
	GtkTreePath* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = structure_model_get_list (self, list_type);
	list = _tmp0_;
	_tmp1_ = list;
	g_return_val_if_fail (_tmp1_ != NULL, NULL);
	if (0 <= num) {
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp2_ = num < _tmp5_;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	_tmp6_ = list;
	_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, num);
	_tmp8_ = structure_model_create_iter_at_node (self, (GNode*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = *_tmp9_;
	_tmp11_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp10_);
	_tmp12_ = _tmp11_;
	__vala_GtkTreeIter_free0 (_tmp9_);
	result = _tmp12_;
	_g_object_unref0 (list);
	return result;
}

gint
structure_model_get_list_num_from_tree_iter (StructureModel* self,
                                             GtkTreeIter* tree_iter)
{
	GtkTreeIter _tmp0_;
	GNode* node = NULL;
	GtkTreeIter _tmp1_;
	GNode* _tmp2_;
	GeeArrayList* list = NULL;
	GNode* _tmp3_;
	gconstpointer _tmp4_;
	StructType _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (tree_iter != NULL, 0);
	_tmp0_ = *tree_iter;
	g_return_val_if_fail (structure_model_iter_is_valid (self, &_tmp0_), -1);
	_tmp1_ = *tree_iter;
	_tmp2_ = structure_model_get_node_from_iter (self, &_tmp1_);
	node = _tmp2_;
	_tmp3_ = node;
	_tmp4_ = _tmp3_->data;
	_tmp5_ = (*((StructData*) _tmp4_)).type;
	_tmp6_ = structure_model_get_list (self, _tmp5_);
	list = _tmp6_;
	_tmp7_ = list;
	g_return_val_if_fail (_tmp7_ != NULL, -1);
	{
		gint num = 0;
		num = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				GeeArrayList* _tmp13_;
				gpointer _tmp14_;
				GNode* _tmp15_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = num;
					num = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = list;
				_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
				_tmp12_ = _tmp11_;
				if (!(num < _tmp12_)) {
					break;
				}
				_tmp13_ = list;
				_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, num);
				_tmp15_ = node;
				if (((GNode*) _tmp14_) == _tmp15_) {
					result = num;
					_g_object_unref0 (list);
					return result;
				}
			}
		}
	}
	g_return_val_if_reached (-1);
	_g_object_unref0 (list);
}

static void
structure_model_insert_node_in_list (StructureModel* self,
                                     GNode* node)
{
	StructData item = {0};
	gconstpointer _tmp0_;
	StructData _tmp1_;
	StructData _tmp2_ = {0};
	GeeArrayList* list = NULL;
	StructData _tmp3_;
	StructType _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node->data;
	_tmp1_ = *((StructData*) _tmp0_);
	struct_data_copy (&_tmp1_, &_tmp2_);
	item = _tmp2_;
	_tmp3_ = item;
	_tmp4_ = _tmp3_.type;
	_tmp5_ = structure_model_get_list (self, _tmp4_);
	list = _tmp5_;
	_tmp6_ = list;
	if (_tmp6_ != NULL) {
		GeeArrayList* _tmp7_;
		_tmp7_ = list;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, node);
	}
	_g_object_unref0 (list);
	struct_data_destroy (&item);
}

static gboolean
__lambda42_ (StructureModel* self,
             GNode* node)
{
	gboolean result = FALSE;
	g_return_val_if_fail (node != NULL, FALSE);
	structure_model_insert_node_in_list (self, node);
	result = FALSE;
	return result;
}

static gboolean
___lambda42__gnode_traverse_func (GNode* node,
                                  gpointer self)
{
	gboolean result;
	result = __lambda42_ ((StructureModel*) self, node);
	return result;
}

static void
structure_model_regenerate_simple_lists (StructureModel* self)
{
	GNode* _tmp0_;
	g_return_if_fail (self != NULL);
	structure_model_reset_simple_lists (self);
	_tmp0_ = self->priv->_tree;
	g_node_traverse (_tmp0_, G_PRE_ORDER, G_TRAVERSE_ALL, -1, ___lambda42__gnode_traverse_func, self);
}

static void
structure_model_reset_simple_lists (StructureModel* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_labels);
	self->priv->_list_labels = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_includes);
	self->priv->_list_includes = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_tables);
	self->priv->_list_tables = _tmp2_;
	_tmp3_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_figures);
	self->priv->_list_figures = _tmp3_;
	_tmp4_ = gee_array_list_new (G_TYPE_POINTER, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_list_todos_and_fixmes);
	self->priv->_list_todos_and_fixmes = _tmp4_;
}

static GeeArrayList*
structure_model_get_list (StructureModel* self,
                          StructType type)
{
	GeeArrayList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (structure_is_section (type)) {
		result = NULL;
		return result;
	}
	switch (type) {
		case STRUCT_TYPE_LABEL:
		{
			GeeArrayList* _tmp0_;
			GeeArrayList* _tmp1_;
			_tmp0_ = self->priv->_list_labels;
			_tmp1_ = _g_object_ref0 (_tmp0_);
			result = _tmp1_;
			return result;
		}
		case STRUCT_TYPE_INCLUDE:
		{
			GeeArrayList* _tmp2_;
			GeeArrayList* _tmp3_;
			_tmp2_ = self->priv->_list_includes;
			_tmp3_ = _g_object_ref0 (_tmp2_);
			result = _tmp3_;
			return result;
		}
		case STRUCT_TYPE_TABLE:
		{
			GeeArrayList* _tmp4_;
			GeeArrayList* _tmp5_;
			_tmp4_ = self->priv->_list_tables;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			result = _tmp5_;
			return result;
		}
		case STRUCT_TYPE_FIGURE:
		case STRUCT_TYPE_IMAGE:
		{
			GeeArrayList* _tmp6_;
			GeeArrayList* _tmp7_;
			_tmp6_ = self->priv->_list_figures;
			_tmp7_ = _g_object_ref0 (_tmp6_);
			result = _tmp7_;
			return result;
		}
		case STRUCT_TYPE_TODO:
		case STRUCT_TYPE_FIXME:
		{
			GeeArrayList* _tmp8_;
			GeeArrayList* _tmp9_;
			_tmp8_ = self->priv->_list_todos_and_fixmes;
			_tmp9_ = _g_object_ref0 (_tmp8_);
			result = _tmp9_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}

gboolean
structure_model_get_emit_signals (StructureModel* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_emit_signals;
	return result;
}

void
structure_model_set_emit_signals (StructureModel* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	if (structure_model_get_emit_signals (self) != value) {
		self->priv->_emit_signals = value;
		g_object_notify_by_pspec ((GObject *) self, structure_model_properties[STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY]);
	}
}

static void
structure_model_class_init (StructureModelClass * klass,
                            gpointer klass_data)
{
	structure_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &StructureModel_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_structure_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_structure_model_set_property;
	G_OBJECT_CLASS (klass)->finalize = structure_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY, structure_model_properties[STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY] = g_param_spec_boolean ("emit-signals", "emit-signals", "emit-signals", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
structure_model_gtk_tree_model_interface_init (GtkTreeModelIface * iface,
                                               gpointer iface_data)
{
	structure_model_gtk_tree_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_column_type = (GType (*) (GtkTreeModel*, gint)) structure_model_real_get_column_type;
	iface->get_n_columns = (gint (*) (GtkTreeModel*)) structure_model_real_get_n_columns;
	iface->get_flags = (GtkTreeModelFlags (*) (GtkTreeModel*)) structure_model_real_get_flags;
	iface->iter_has_child = (gboolean (*) (GtkTreeModel*, GtkTreeIter*)) structure_model_real_iter_has_child;
	iface->iter_n_children = (gint (*) (GtkTreeModel*, GtkTreeIter*)) structure_model_real_iter_n_children;
	iface->get_value = (void (*) (GtkTreeModel*, GtkTreeIter*, gint, GValue*)) structure_model_real_get_value;
	iface->iter_children = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) structure_model_real_iter_children;
	iface->iter_next = (gboolean (*) (GtkTreeModel*, GtkTreeIter*)) structure_model_real_iter_next;
	iface->iter_nth_child = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreeIter*, gint)) structure_model_real_iter_nth_child;
	iface->iter_parent = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) structure_model_real_iter_parent;
	iface->get_iter = (gboolean (*) (GtkTreeModel*, GtkTreeIter*, GtkTreePath*)) structure_model_real_get_iter;
	iface->get_path = (GtkTreePath* (*) (GtkTreeModel*, GtkTreeIter*)) structure_model_real_get_path;
}

static void
structure_model_instance_init (StructureModel * self,
                               gpointer klass)
{
	self->priv = structure_model_get_instance_private (self);
	self->priv->_emit_signals = FALSE;
	self->priv->_nb_nodes = (guint) 0;
	self->priv->_end_node = NULL;
}

static void
structure_model_finalize (GObject * obj)
{
	StructureModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STRUCTURE_MODEL, StructureModel);
	self->priv->_column_types = (g_free (self->priv->_column_types), NULL);
	(self->priv->_tree == NULL) ? NULL : (self->priv->_tree = (_g_node_destroy__struct_data_free0_ (self->priv->_tree), NULL));
	_g_object_unref0 (self->priv->_list_labels);
	_g_object_unref0 (self->priv->_list_includes);
	_g_object_unref0 (self->priv->_list_tables);
	_g_object_unref0 (self->priv->_list_figures);
	_g_object_unref0 (self->priv->_list_todos_and_fixmes);
	G_OBJECT_CLASS (structure_model_parent_class)->finalize (obj);
}

static GType
structure_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (StructureModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) structure_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StructureModel), 0, (GInstanceInitFunc) structure_model_instance_init, NULL };
	static const GInterfaceInfo gtk_tree_model_info = { (GInterfaceInitFunc) structure_model_gtk_tree_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType structure_model_type_id;
	structure_model_type_id = g_type_register_static (G_TYPE_OBJECT, "StructureModel", &g_define_type_info, 0);
	g_type_add_interface_static (structure_model_type_id, gtk_tree_model_get_type (), &gtk_tree_model_info);
	StructureModel_private_offset = g_type_add_instance_private (structure_model_type_id, sizeof (StructureModelPrivate));
	return structure_model_type_id;
}

GType
structure_model_get_type (void)
{
	static volatile gsize structure_model_type_id__volatile = 0;
	if (g_once_init_enter (&structure_model_type_id__volatile)) {
		GType structure_model_type_id;
		structure_model_type_id = structure_model_get_type_once ();
		g_once_init_leave (&structure_model_type_id__volatile, structure_model_type_id);
	}
	return structure_model_type_id__volatile;
}

static void
_vala_structure_model_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	StructureModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_STRUCTURE_MODEL, StructureModel);
	switch (property_id) {
		case STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY:
		g_value_set_boolean (value, structure_model_get_emit_signals (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_structure_model_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	StructureModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_STRUCTURE_MODEL, StructureModel);
	switch (property_id) {
		case STRUCTURE_MODEL_EMIT_SIGNALS_PROPERTY:
		structure_model_set_emit_signals (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

