/* factory.c generated by valac 0.48.10, the Vala compiler
 * generated from factory.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2017-2020 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <latexila.h>
#include <glib-object.h>
#include <tepl/tepl.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#define TYPE_FACTORY (factory_get_type ())
#define FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACTORY, Factory))
#define FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACTORY, FactoryClass))
#define IS_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACTORY))
#define IS_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACTORY))
#define FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACTORY, FactoryClass))

typedef struct _Factory Factory;
typedef struct _FactoryClass FactoryClass;
typedef struct _FactoryPrivate FactoryPrivate;
enum  {
	FACTORY_0_PROPERTY,
	FACTORY_NUM_PROPERTIES
};
static GParamSpec* factory_properties[FACTORY_NUM_PROPERTIES];

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Factory {
	LatexilaFactory parent_instance;
	FactoryPrivate * priv;
};

struct _FactoryClass {
	LatexilaFactoryClass parent_class;
};

static gpointer factory_parent_class = NULL;

GType factory_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Factory, g_object_unref)
Factory* factory_new (void);
Factory* factory_construct (GType object_type);
static GtkApplicationWindow* factory_real_create_main_window (TeplAbstractFactory* base,
                                                       GtkApplication* gtk_app);
GType glatex_app_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GlatexApp, g_object_unref)
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
MainWindow* glatex_app_get_active_main_window (GlatexApp* self);
void main_window_save_state (MainWindow* self);
MainWindow* main_window_new (GlatexApp* app);
MainWindow* main_window_construct (GType object_type,
                                   GlatexApp* app);
static void factory_reopen_files (Factory* self,
                           GlatexApp* app);
static void _vala_array_add4 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
void glatex_app_open_documents (GlatexApp* self,
                                GFile** files,
                                gint files_length1);
static GType factory_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

Factory*
factory_construct (GType object_type)
{
	Factory * self = NULL;
	self = (Factory*) g_object_new (object_type, NULL);
	return self;
}

Factory*
factory_new (void)
{
	return factory_construct (TYPE_FACTORY);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkApplicationWindow*
factory_real_create_main_window (TeplAbstractFactory* base,
                                 GtkApplication* gtk_app)
{
	Factory * self;
	GlatexApp* app = NULL;
	GlatexApp* _tmp0_;
	MainWindow* active_main_window = NULL;
	GlatexApp* _tmp1_;
	MainWindow* _tmp2_;
	MainWindow* _tmp3_;
	gboolean first_window = FALSE;
	MainWindow* _tmp5_;
	MainWindow* new_window = NULL;
	GlatexApp* _tmp6_;
	MainWindow* _tmp7_;
	MainWindow* _tmp9_;
	GObject* _tmp10_;
	GtkApplicationWindow* result = NULL;
	self = (Factory*) base;
	g_return_val_if_fail (gtk_app != NULL, NULL);
	g_return_val_if_fail (IS_GLATEX_APP (gtk_app), NULL);
	_tmp0_ = _g_object_ref0 (IS_GLATEX_APP (gtk_app) ? ((GlatexApp*) gtk_app) : NULL);
	app = _tmp0_;
	_tmp1_ = app;
	_tmp2_ = glatex_app_get_active_main_window (_tmp1_);
	active_main_window = _tmp2_;
	_tmp3_ = active_main_window;
	if (_tmp3_ != NULL) {
		MainWindow* _tmp4_;
		_tmp4_ = active_main_window;
		main_window_save_state (_tmp4_);
	}
	_tmp5_ = active_main_window;
	first_window = _tmp5_ == NULL;
	_tmp6_ = app;
	_tmp7_ = main_window_new (_tmp6_);
	g_object_ref_sink (_tmp7_);
	new_window = _tmp7_;
	if (first_window) {
		GlatexApp* _tmp8_;
		_tmp8_ = app;
		factory_reopen_files (self, _tmp8_);
	}
	_tmp9_ = new_window;
	_tmp10_ = g_object_ref ((GObject*) _tmp9_);
	result = (GtkApplicationWindow*) (IS_MAIN_WINDOW (_tmp10_) ? ((MainWindow*) _tmp10_) : NULL);
	_g_object_unref0 (new_window);
	_g_object_unref0 (active_main_window);
	_g_object_unref0 (app);
	return result;
}

static void
_vala_array_add4 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
factory_reopen_files (Factory* self,
                      GlatexApp* app)
{
	GSettings* editor_settings = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.editor");
	editor_settings = _tmp0_;
	_tmp1_ = editor_settings;
	if (g_settings_get_boolean (_tmp1_, "reopen-files")) {
		GSettings* window_settings = NULL;
		GSettings* _tmp2_;
		gchar** uris = NULL;
		GSettings* _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_;
		gint uris_length1;
		gint _uris_size_;
		GFile** files = NULL;
		GFile** _tmp6_;
		gint files_length1;
		gint _files_size_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		GFile** _tmp14_;
		gint _tmp14__length1;
		_tmp2_ = g_settings_new ("org.gnome.gnome-latex.state.window");
		window_settings = _tmp2_;
		_tmp3_ = window_settings;
		_tmp5_ = _tmp4_ = g_settings_get_strv (_tmp3_, "documents");
		uris = _tmp5_;
		uris_length1 = _vala_array_length (_tmp4_);
		_uris_size_ = uris_length1;
		_tmp6_ = g_new0 (GFile*, 0 + 1);
		files = _tmp6_;
		files_length1 = 0;
		_files_size_ = files_length1;
		_tmp7_ = uris;
		_tmp7__length1 = uris_length1;
		{
			gchar** uri_collection = NULL;
			gint uri_collection_length1 = 0;
			gint _uri_collection_size_ = 0;
			gint uri_it = 0;
			uri_collection = _tmp7_;
			uri_collection_length1 = _tmp7__length1;
			for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
				gchar* _tmp8_;
				gchar* uri = NULL;
				_tmp8_ = g_strdup (uri_collection[uri_it]);
				uri = _tmp8_;
				{
					const gchar* _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
					_tmp9_ = uri;
					_tmp10_ = strlen (_tmp9_);
					_tmp11_ = _tmp10_;
					if (0 < _tmp11_) {
						const gchar* _tmp12_;
						GFile* _tmp13_;
						_tmp12_ = uri;
						_tmp13_ = g_file_new_for_uri (_tmp12_);
						_vala_array_add4 (&files, &files_length1, &_files_size_, _tmp13_);
					}
					_g_free0 (uri);
				}
			}
		}
		_tmp14_ = files;
		_tmp14__length1 = files_length1;
		glatex_app_open_documents (app, _tmp14_, (gint) _tmp14__length1);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (window_settings);
	}
	_g_object_unref0 (editor_settings);
}

static void
factory_class_init (FactoryClass * klass,
                    gpointer klass_data)
{
	factory_parent_class = g_type_class_peek_parent (klass);
	((TeplAbstractFactoryClass *) klass)->create_main_window = (GtkApplicationWindow* (*) (TeplAbstractFactory*, GtkApplication*)) factory_real_create_main_window;
}

static void
factory_instance_init (Factory * self,
                       gpointer klass)
{
}

static GType
factory_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Factory), 0, (GInstanceInitFunc) factory_instance_init, NULL };
	GType factory_type_id;
	factory_type_id = g_type_register_static (latexila_factory_get_type (), "Factory", &g_define_type_info, 0);
	return factory_type_id;
}

GType
factory_get_type (void)
{
	static volatile gsize factory_type_id__volatile = 0;
	if (g_once_init_enter (&factory_type_id__volatile)) {
		GType factory_type_id;
		factory_type_id = factory_get_type_once ();
		g_once_init_leave (&factory_type_id__volatile, factory_type_id);
	}
	return factory_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

