/* utils.c generated by valac 0.48.10, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2020 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <tepl/tepl.h>
#include <gtk/gtk.h>

#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

gboolean utils_char_is_escaped (const gchar* text,
                                glong char_index);
const gchar* utils_get_string_from_resource (const gchar* resource_path);
void utils_delete_file (GFile* file);
gboolean utils_save_file (GFile* file,
                          const gchar* contents,
                          gboolean make_backup);
gchar* utils_load_file (GFile* file);
gchar* utils_get_relative_path (GFile* origin,
                                GFile* target,
                                GFile* common_dir);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model,
                                     GtkTreeIter* iter);
static void _vala_GtkTreePath_free (GtkTreePath* self);
gint utils_get_selected_row (GtkTreeView* view,
                             GtkTreeIter* iter);
GtkWindow* utils_get_toplevel_window (GtkWidget* widget);
void utils_flush_queue (void);

/*************************************************************************/
static gboolean
string_get_prev_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (0 < (*index)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_prev_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}

gboolean
utils_char_is_escaped (const gchar* text,
                       glong char_index)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean escaped = FALSE;
	gint index = 0;
	gunichar cur_char = 0U;
	gboolean result = FALSE;
	g_return_val_if_fail (text != NULL, FALSE);
	_tmp0_ = strlen (text);
	_tmp1_ = _tmp0_;
	g_return_val_if_fail (char_index < ((glong) _tmp1_), FALSE);
	escaped = FALSE;
	index = (gint) char_index;
	while (TRUE) {
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_;
		_tmp3_ = string_get_prev_char (text, &index, &_tmp2_);
		cur_char = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		if (cur_char != ((gunichar) '\\')) {
			break;
		}
		escaped = !escaped;
	}
	result = escaped;
	return result;
}

const gchar*
utils_get_string_from_resource (const gchar* resource_path)
{
	GError* _inner_error0_ = NULL;
	const gchar* result = NULL;
	g_return_val_if_fail (resource_path != NULL, NULL);
	{
		GBytes* bytes = NULL;
		GBytes* _tmp0_;
		gsize _tmp1_ = 0;
		guint8* _tmp2_;
		_tmp0_ = g_resources_lookup_data (resource_path, 0, &_inner_error0_);
		bytes = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = g_bytes_get_data (bytes, &_tmp1_);
		result = (const gchar*) _tmp2_;
		_g_bytes_unref0 (bytes);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("utils.vala:54: Failed to load data from resource '%s': %s", resource_path, _tmp4_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

/*************************************************************************/
void
utils_delete_file (GFile* file)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file != NULL);
	if (!g_file_query_exists (file, NULL)) {
		return;
	}
	{
		g_file_delete (file, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = g_file_get_parse_name (file);
		_tmp1_ = _tmp0_;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("utils.vala:75: Delete file '%s' failed: %s", _tmp1_, _tmp3_);
		_g_free0 (_tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

gboolean
utils_save_file (GFile* file,
                 const gchar* contents,
                 gboolean make_backup)
{
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (contents != NULL, FALSE);
	{
		guint8* _tmp0_;
		gint _tmp0__length1;
		gint _tmp1_ = 0;
		guint8* _tmp2_;
		gint _tmp2__length1;
		tepl_utils_create_parent_directories (file, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp0_ = string_get_data (contents, &_tmp1_);
		_tmp0__length1 = _tmp1_;
		_tmp2_ = _tmp0_;
		_tmp2__length1 = _tmp0__length1;
		g_file_replace_contents (file, _tmp2_, (gsize) _tmp2__length1, NULL, make_backup, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = g_file_get_parse_name (file);
		_tmp4_ = _tmp3_;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("utils.vala:90: Failed to save the file '%s': %s", _tmp4_, _tmp6_);
		_g_free0 (_tmp4_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	result = TRUE;
	return result;
}

gchar*
utils_load_file (GFile* file)
{
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	{
		guint8* chars = NULL;
		gint chars_length1 = 0;
		gint _chars_size_ = 0;
		guint8* _tmp0_ = NULL;
		gsize _tmp1_ = 0;
		guint8* _tmp2_;
		gint _tmp2__length1;
		g_file_load_contents (file, NULL, &_tmp0_, &_tmp1_, NULL, &_inner_error0_);
		chars = (g_free (chars), NULL);
		chars = _tmp0_;
		chars_length1 = _tmp1_;
		_chars_size_ = chars_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			chars = (g_free (chars), NULL);
			goto __catch0_g_error;
		}
		_tmp2_ = chars;
		_tmp2__length1 = chars_length1;
		chars = NULL;
		chars_length1 = 0;
		result = (gchar*) _tmp2_;
		chars = (g_free (chars), NULL);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = g_file_get_parse_name (file);
		_tmp4_ = _tmp3_;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("utils.vala:109: Failed to load the file '%s': %s", _tmp4_, _tmp6_);
		_g_free0 (_tmp4_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

gchar*
utils_get_relative_path (GFile* origin,
                         GFile* target,
                         GFile* common_dir)
{
	GFile* origin_dir = NULL;
	GFile* target_parent = NULL;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GList* target_dirs = NULL;
	GList* origin_dirs = NULL;
	guint dir_index = 0U;
	guint nb_common_dirs = 0U;
	gchar* relative_path = NULL;
	gchar* _tmp34_;
	guint nb_remaining_origin_dirs = 0U;
	GList* _tmp35_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* result = NULL;
	g_return_val_if_fail (origin != NULL, NULL);
	g_return_val_if_fail (target != NULL, NULL);
	g_return_val_if_fail (common_dir != NULL, NULL);
	if (g_file_equal (origin, common_dir)) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (origin);
		_g_object_unref0 (origin_dir);
		origin_dir = _tmp0_;
	} else {
		GFile* _tmp1_;
		_tmp1_ = g_file_get_parent (origin);
		_g_object_unref0 (origin_dir);
		origin_dir = _tmp1_;
	}
	_tmp2_ = g_file_get_parent (target);
	target_parent = _tmp2_;
	_tmp3_ = origin_dir;
	g_return_val_if_fail (_tmp3_ != NULL, NULL);
	_tmp4_ = target_parent;
	g_return_val_if_fail (_tmp4_ != NULL, NULL);
	_tmp5_ = target_parent;
	_tmp6_ = origin_dir;
	if (g_file_equal (_tmp5_, _tmp6_)) {
		gchar* _tmp7_;
		_tmp7_ = g_file_get_basename (target);
		result = _tmp7_;
		_g_object_unref0 (target_parent);
		_g_object_unref0 (origin_dir);
		return result;
	}
	target_dirs = NULL;
	origin_dirs = NULL;
	while (TRUE) {
		gboolean _tmp8_ = FALSE;
		GFile* _tmp9_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		GFile* _tmp14_;
		_tmp9_ = target_parent;
		if (_tmp9_ != NULL) {
			GFile* _tmp10_;
			_tmp10_ = target_parent;
			_tmp8_ = !g_file_equal (_tmp10_, common_dir);
		} else {
			_tmp8_ = FALSE;
		}
		if (!_tmp8_) {
			break;
		}
		_tmp11_ = target_parent;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		target_dirs = g_list_prepend (target_dirs, _tmp12_);
		_tmp13_ = target_parent;
		_tmp14_ = g_file_get_parent (_tmp13_);
		_g_object_unref0 (target_parent);
		target_parent = _tmp14_;
	}
	while (TRUE) {
		gboolean _tmp15_ = FALSE;
		GFile* _tmp16_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		GFile* _tmp20_;
		GFile* _tmp21_;
		_tmp16_ = origin_dir;
		if (_tmp16_ != NULL) {
			GFile* _tmp17_;
			_tmp17_ = origin_dir;
			_tmp15_ = !g_file_equal (_tmp17_, common_dir);
		} else {
			_tmp15_ = FALSE;
		}
		if (!_tmp15_) {
			break;
		}
		_tmp18_ = origin_dir;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		origin_dirs = g_list_prepend (origin_dirs, _tmp19_);
		_tmp20_ = origin_dir;
		_tmp21_ = g_file_get_parent (_tmp20_);
		_g_object_unref0 (origin_dir);
		origin_dir = _tmp21_;
	}
	dir_index = (guint) 0;
	while (TRUE) {
		gboolean _tmp22_ = FALSE;
		GList* _tmp23_;
		GFile* cur_target_dir = NULL;
		GList* _tmp25_;
		gconstpointer _tmp26_;
		GFile* _tmp27_;
		GFile* cur_origin_dir = NULL;
		GList* _tmp28_;
		gconstpointer _tmp29_;
		GFile* _tmp30_;
		GFile* _tmp31_;
		GFile* _tmp32_;
		guint _tmp33_;
		_tmp23_ = target_dirs;
		if (dir_index < g_list_length (_tmp23_)) {
			GList* _tmp24_;
			_tmp24_ = origin_dirs;
			_tmp22_ = dir_index < g_list_length (_tmp24_);
		} else {
			_tmp22_ = FALSE;
		}
		if (!_tmp22_) {
			break;
		}
		_tmp25_ = target_dirs;
		_tmp26_ = g_list_nth_data (_tmp25_, dir_index);
		_tmp27_ = _g_object_ref0 ((GFile*) _tmp26_);
		cur_target_dir = _tmp27_;
		_tmp28_ = origin_dirs;
		_tmp29_ = g_list_nth_data (_tmp28_, dir_index);
		_tmp30_ = _g_object_ref0 ((GFile*) _tmp29_);
		cur_origin_dir = _tmp30_;
		_tmp31_ = cur_target_dir;
		_tmp32_ = cur_origin_dir;
		if (!g_file_equal (_tmp31_, _tmp32_)) {
			_g_object_unref0 (cur_origin_dir);
			_g_object_unref0 (cur_target_dir);
			break;
		}
		_tmp33_ = dir_index;
		dir_index = _tmp33_ + 1;
		_g_object_unref0 (cur_origin_dir);
		_g_object_unref0 (cur_target_dir);
	}
	nb_common_dirs = dir_index;
	_tmp34_ = g_strdup ("");
	relative_path = _tmp34_;
	_tmp35_ = origin_dirs;
	nb_remaining_origin_dirs = g_list_length (_tmp35_) - nb_common_dirs;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp36_ = FALSE;
			_tmp36_ = TRUE;
			while (TRUE) {
				const gchar* _tmp38_;
				gchar* _tmp39_;
				if (!_tmp36_) {
					guint _tmp37_;
					_tmp37_ = i;
					i = _tmp37_ + 1;
				}
				_tmp36_ = FALSE;
				if (!(i < nb_remaining_origin_dirs)) {
					break;
				}
				_tmp38_ = relative_path;
				_tmp39_ = g_strconcat (_tmp38_, "../", NULL);
				_g_free0 (relative_path);
				relative_path = _tmp39_;
			}
		}
	}
	{
		guint i = 0U;
		i = nb_common_dirs;
		{
			gboolean _tmp40_ = FALSE;
			_tmp40_ = TRUE;
			while (TRUE) {
				GList* _tmp42_;
				GFile* cur_target_dir = NULL;
				GList* _tmp43_;
				gconstpointer _tmp44_;
				GFile* _tmp45_;
				const gchar* _tmp46_;
				GFile* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				if (!_tmp40_) {
					guint _tmp41_;
					_tmp41_ = i;
					i = _tmp41_ + 1;
				}
				_tmp40_ = FALSE;
				_tmp42_ = target_dirs;
				if (!(i < g_list_length (_tmp42_))) {
					break;
				}
				_tmp43_ = target_dirs;
				_tmp44_ = g_list_nth_data (_tmp43_, i);
				_tmp45_ = _g_object_ref0 ((GFile*) _tmp44_);
				cur_target_dir = _tmp45_;
				_tmp46_ = relative_path;
				_tmp47_ = cur_target_dir;
				_tmp48_ = g_file_get_basename (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = g_strconcat (_tmp49_, "/", NULL);
				_tmp51_ = _tmp50_;
				_tmp52_ = g_strconcat (_tmp46_, _tmp51_, NULL);
				_g_free0 (relative_path);
				relative_path = _tmp52_;
				_g_free0 (_tmp51_);
				_g_free0 (_tmp49_);
				_g_object_unref0 (cur_target_dir);
			}
		}
	}
	_tmp53_ = relative_path;
	_tmp54_ = g_file_get_basename (target);
	_tmp55_ = _tmp54_;
	_tmp56_ = g_strconcat (_tmp53_, _tmp55_, NULL);
	_g_free0 (relative_path);
	relative_path = _tmp56_;
	_g_free0 (_tmp55_);
	result = relative_path;
	(origin_dirs == NULL) ? NULL : (origin_dirs = (_g_list_free__g_object_unref0_ (origin_dirs), NULL));
	(target_dirs == NULL) ? NULL : (target_dirs = (_g_list_free__g_object_unref0_ (target_dirs), NULL));
	_g_object_unref0 (target_parent);
	_g_object_unref0 (origin_dir);
	return result;
}

/*************************************************************************/
GtkScrolledWindow*
utils_add_scrollbar (GtkWidget* child)
{
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp0_;
	GtkScrolledWindow* result = NULL;
	g_return_val_if_fail (child != NULL, NULL);
	_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	sw = _tmp0_;
	gtk_container_add ((GtkContainer*) sw, child);
	result = sw;
	return result;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

gboolean
utils_tree_model_iter_prev (GtkTreeModel* model,
                            GtkTreeIter* iter)
{
	GtkTreePath* path = NULL;
	GtkTreeIter _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	_tmp1_ = gtk_tree_model_get_path (model, &_tmp0_);
	path = _tmp1_;
	_tmp2_ = path;
	if (gtk_tree_path_prev (_tmp2_)) {
		gboolean ret = FALSE;
		GtkTreePath* _tmp3_;
		GtkTreeIter _tmp4_ = {0};
		gboolean _tmp5_;
		_tmp3_ = path;
		_tmp5_ = gtk_tree_model_get_iter (model, &_tmp4_, _tmp3_);
		*iter = _tmp4_;
		ret = _tmp5_;
		result = ret;
		__vala_GtkTreePath_free0 (path);
		return result;
	}
	result = FALSE;
	__vala_GtkTreePath_free0 (path);
	return result;
}

gint
utils_get_selected_row (GtkTreeView* view,
                        GtkTreeIter* iter)
{
	GtkTreeIter _vala_iter = {0};
	GtkTreeSelection* select = NULL;
	GtkTreeSelection* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	gint result = 0;
	g_return_val_if_fail (view != NULL, 0);
	_tmp0_ = gtk_tree_view_get_selection (view);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	select = _tmp1_;
	_tmp2_ = select;
	_tmp4_ = gtk_tree_selection_get_selected (_tmp2_, NULL, &_tmp3_);
	_vala_iter = _tmp3_;
	if (_tmp4_) {
		GtkTreeModel* model = NULL;
		GtkTreeModel* _tmp5_;
		GtkTreeModel* _tmp6_;
		GtkTreePath* path = NULL;
		GtkTreeModel* _tmp7_;
		GtkTreeIter _tmp8_;
		GtkTreePath* _tmp9_;
		GtkTreePath* _tmp10_;
		gint _tmp11_ = 0;
		gint* _tmp12_;
		gint _tmp13_;
		_tmp5_ = gtk_tree_view_get_model (view);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		model = _tmp6_;
		_tmp7_ = model;
		_tmp8_ = _vala_iter;
		_tmp9_ = gtk_tree_model_get_path (_tmp7_, &_tmp8_);
		path = _tmp9_;
		_tmp10_ = path;
		_tmp12_ = gtk_tree_path_get_indices_with_depth (_tmp10_, &_tmp11_);
		_tmp13_ = _tmp12_[0];
		result = _tmp13_;
		__vala_GtkTreePath_free0 (path);
		_g_object_unref0 (model);
		_g_object_unref0 (select);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	result = -1;
	_g_object_unref0 (select);
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

GtkWindow*
utils_get_toplevel_window (GtkWidget* widget)
{
	GtkWidget* toplevel = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWindow* result = NULL;
	g_return_val_if_fail (widget != NULL, NULL);
	_tmp0_ = gtk_widget_get_toplevel (widget);
	toplevel = _tmp0_;
	_tmp1_ = toplevel;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ())) {
		GtkWidget* _tmp2_;
		_tmp2_ = toplevel;
		result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp2_) : NULL;
		return result;
	}
	result = NULL;
	return result;
}

/*************************************************************************/
void
utils_flush_queue (void)
{
	while (TRUE) {
		if (!gtk_events_pending ()) {
			break;
		}
		gtk_main_iteration ();
	}
}

