/* preferences_dialog.c generated by valac 0.48.10, the Vala compiler
 * generated from preferences_dialog.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <latexila.h>
#include <tepl/tepl.h>
#include <gspell/gspell.h>
#include <float.h>
#include <math.h>

#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;
typedef struct _PreferencesDialogPrivate PreferencesDialogPrivate;
enum  {
	PREFERENCES_DIALOG_0_PROPERTY,
	PREFERENCES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* preferences_dialog_properties[PREFERENCES_DIALOG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef const gchar* (*PreferencesDialogPlural) (gulong n, gpointer user_data);
typedef struct _Block24Data Block24Data;

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
typedef struct _Block25Data Block25Data;
#define _g_settings_schema_key_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_key_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))

struct _PreferencesDialog {
	GtkDialog parent_instance;
	PreferencesDialogPrivate * priv;
};

struct _PreferencesDialogClass {
	GtkDialogClass parent_class;
};

struct _Block24Data {
	int _ref_count_;
	PreferencesDialog* self;
	GtkButton* default_font_checkbutton;
};

struct _Block25Data {
	int _ref_count_;
	PreferencesDialog* self;
	GtkLabel* label;
	PreferencesDialogPlural plural;
	gpointer plural_target;
};

static gpointer preferences_dialog_parent_class = NULL;
static PreferencesDialog* preferences_dialog__instance;
static PreferencesDialog* preferences_dialog__instance = NULL;

GType preferences_dialog_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PreferencesDialog, g_object_unref)
static PreferencesDialog* preferences_dialog_new (void);
static PreferencesDialog* preferences_dialog_construct (GType object_type);
static void __lambda84_ (PreferencesDialog* self);
static void preferences_dialog_reset_all (PreferencesDialog* self);
static void ___lambda84__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void preferences_dialog_init_editor_tab (PreferencesDialog* self,
                                         GtkBuilder* builder);
static void preferences_dialog_init_font_and_colors_tab (PreferencesDialog* self,
                                                  GtkBuilder* builder);
static void preferences_dialog_init_interactive_completion_setting (PreferencesDialog* self,
                                                             GtkBuilder* builder);
static void preferences_dialog_init_spell_checking_settings (PreferencesDialog* self,
                                                      GtkBuilder* builder);
static void preferences_dialog_init_other_tab (PreferencesDialog* self,
                                        GtkBuilder* builder);
void preferences_dialog_show_me (GtkWindow* parent);
static gboolean ___lambda89_ (void);
static gboolean ____lambda89__gtk_widget_delete_event (GtkWidget* _sender,
                                                GdkEventAny* event,
                                                gpointer self);
static void ___lambda90_ (void);
static void ____lambda90__gtk_widget_destroy (GtkWidget* _sender,
                                       gpointer self);
static void preferences_dialog_set_spin_button_range (PreferencesDialog* self,
                                               GtkSpinButton* spin_button,
                                               GSettings* settings,
                                               const gchar* key);
static void preferences_dialog_set_plural (PreferencesDialog* self,
                                    GtkLabel* label,
                                    GSettings* settings,
                                    const gchar* key,
                                    PreferencesDialogPlural plural,
                                    gpointer plural_target);
static const gchar* __lambda86_ (PreferencesDialog* self,
                          gulong n);
static const gchar* ___lambda86__preferences_dialog_plural (gulong n,
                                                     gpointer self);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static void preferences_dialog_set_system_font_label (PreferencesDialog* self,
                                               GtkButton* button);
GType app_settings_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppSettings, g_object_unref)
AppSettings* app_settings_get_default (void);
static void __lambda87_ (Block24Data* _data24_);
static void ___lambda87__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static const gchar* __lambda88_ (PreferencesDialog* self,
                          gulong n);
static const gchar* ___lambda88__preferences_dialog_plural (gulong n,
                                                     gpointer self);
const gchar* app_settings_get_system_font (AppSettings* self);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static void __lambda85_ (Block25Data* _data25_,
                  GSettings* setting,
                  const gchar* k);
static void ___lambda85__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void preferences_dialog_finalize (GObject * obj);
static GType preferences_dialog_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda84_ (PreferencesDialog* self)
{
	preferences_dialog_reset_all (self);
}

static void
___lambda84__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda84_ ((PreferencesDialog*) self);
}

static PreferencesDialog*
preferences_dialog_construct (GType object_type)
{
	PreferencesDialog * self = NULL;
	GtkHeaderBar* headerbar = NULL;
	GtkHeaderBar* _tmp0_;
	GtkHeaderBar* _tmp1_;
	GtkHeaderBar* _tmp2_;
	GtkButton* reset_button = NULL;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkHeaderBar* _tmp7_;
	GtkButton* _tmp8_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp9_;
	GtkBuilder* _tmp25_;
	GtkBuilder* _tmp26_;
	GtkBuilder* _tmp27_;
	GtkBuilder* _tmp28_;
	GtkBuilder* _tmp29_;
	GtkNotebook* notebook = NULL;
	GtkBuilder* _tmp30_;
	GObject* _tmp31_;
	GtkNotebook* _tmp32_;
	GtkNotebook* _tmp33_;
	GtkBox* content_area = NULL;
	GtkBox* _tmp34_;
	GtkBox* _tmp35_;
	GtkBox* _tmp36_;
	GtkNotebook* _tmp37_;
	GError* _inner_error0_ = NULL;
	self = (PreferencesDialog*) g_object_new (object_type, "use-header-bar", 1, NULL);
	gtk_window_set_title ((GtkWindow*) self, _ ("Preferences"));
	gtk_window_set_destroy_with_parent ((GtkWindow*) self, TRUE);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 5);
	_tmp0_ = gtk_dialog_get_header_bar ((GtkDialog*) self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_header_bar_get_type ()) ? ((GtkHeaderBar*) _tmp0_) : NULL);
	headerbar = _tmp1_;
	_tmp2_ = headerbar;
	gtk_header_bar_set_show_close_button (_tmp2_, TRUE);
	_tmp3_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Reset All"));
	g_object_ref_sink (_tmp3_);
	reset_button = _tmp3_;
	_tmp4_ = reset_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp4_, _ ("Reset all preferences"));
	_tmp5_ = reset_button;
	gtk_widget_show_all ((GtkWidget*) _tmp5_);
	_tmp6_ = reset_button;
	g_signal_connect_object (_tmp6_, "clicked", (GCallback) ___lambda84__gtk_button_clicked, self, 0);
	_tmp7_ = headerbar;
	_tmp8_ = reset_button;
	gtk_header_bar_pack_start (_tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = gtk_builder_new ();
	builder = _tmp9_;
	{
		gchar* ui_path = NULL;
		gchar* _tmp10_;
		GtkBuilder* _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = g_build_filename (DATA_DIR, "ui", "preferences_dialog.ui", NULL);
		ui_path = _tmp10_;
		_tmp11_ = builder;
		_tmp12_ = ui_path;
		gtk_builder_add_from_file (_tmp11_, _tmp12_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (ui_path);
			goto __catch0_g_error;
		}
		_g_free0 (ui_path);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* message = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		GtkLabel* label_error = NULL;
		const gchar* _tmp17_;
		GtkLabel* _tmp18_;
		GtkLabel* _tmp19_;
		GtkBox* content_area = NULL;
		GtkBox* _tmp20_;
		GtkBox* _tmp21_;
		GtkBox* _tmp22_;
		GtkLabel* _tmp23_;
		GtkBox* _tmp24_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		_tmp15_ = g_strdup_printf ("Error: %s", _tmp14_);
		message = _tmp15_;
		_tmp16_ = message;
		g_warning ("preferences_dialog.vala:61: %s", _tmp16_);
		_tmp17_ = message;
		_tmp18_ = (GtkLabel*) gtk_label_new (_tmp17_);
		g_object_ref_sink (_tmp18_);
		label_error = _tmp18_;
		_tmp19_ = label_error;
		gtk_label_set_line_wrap (_tmp19_, TRUE);
		_tmp20_ = gtk_dialog_get_content_area ((GtkDialog*) self);
		_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_box_get_type (), GtkBox));
		content_area = _tmp21_;
		_tmp22_ = content_area;
		_tmp23_ = label_error;
		gtk_box_pack_start (_tmp22_, (GtkWidget*) _tmp23_, TRUE, TRUE, (guint) 0);
		_tmp24_ = content_area;
		gtk_widget_show_all ((GtkWidget*) _tmp24_);
		_g_object_unref0 (content_area);
		_g_object_unref0 (label_error);
		_g_free0 (message);
		_g_error_free0 (e);
		_g_object_unref0 (builder);
		_g_object_unref0 (reset_button);
		_g_object_unref0 (headerbar);
		return self;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (builder);
		_g_object_unref0 (reset_button);
		_g_object_unref0 (headerbar);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp25_ = builder;
	preferences_dialog_init_editor_tab (self, _tmp25_);
	_tmp26_ = builder;
	preferences_dialog_init_font_and_colors_tab (self, _tmp26_);
	_tmp27_ = builder;
	preferences_dialog_init_interactive_completion_setting (self, _tmp27_);
	_tmp28_ = builder;
	preferences_dialog_init_spell_checking_settings (self, _tmp28_);
	_tmp29_ = builder;
	preferences_dialog_init_other_tab (self, _tmp29_);
	_tmp30_ = builder;
	_tmp31_ = gtk_builder_get_object (_tmp30_, "notebook");
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, gtk_notebook_get_type ()) ? ((GtkNotebook*) _tmp31_) : NULL);
	notebook = _tmp32_;
	_tmp33_ = notebook;
	gtk_widget_unparent ((GtkWidget*) _tmp33_);
	_tmp34_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_box_get_type (), GtkBox));
	content_area = _tmp35_;
	_tmp36_ = content_area;
	_tmp37_ = notebook;
	gtk_box_pack_start (_tmp36_, (GtkWidget*) _tmp37_, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (content_area);
	_g_object_unref0 (notebook);
	_g_object_unref0 (builder);
	_g_object_unref0 (reset_button);
	_g_object_unref0 (headerbar);
	return self;
}

static PreferencesDialog*
preferences_dialog_new (void)
{
	return preferences_dialog_construct (TYPE_PREFERENCES_DIALOG);
}

static gboolean
___lambda89_ (void)
{
	PreferencesDialog* _tmp0_;
	gboolean result = FALSE;
	_tmp0_ = preferences_dialog__instance;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	result = TRUE;
	return result;
}

static gboolean
____lambda89__gtk_widget_delete_event (GtkWidget* _sender,
                                       GdkEventAny* event,
                                       gpointer self)
{
	gboolean result;
	result = ___lambda89_ ();
	return result;
}

static void
___lambda90_ (void)
{
	_g_object_unref0 (preferences_dialog__instance);
	preferences_dialog__instance = NULL;
}

static void
____lambda90__gtk_widget_destroy (GtkWidget* _sender,
                                  gpointer self)
{
	___lambda90_ ();
}

void
preferences_dialog_show_me (GtkWindow* parent)
{
	PreferencesDialog* _tmp0_;
	PreferencesDialog* _tmp4_;
	GtkWindow* _tmp5_;
	PreferencesDialog* _tmp7_;
	g_return_if_fail (parent != NULL);
	_tmp0_ = preferences_dialog__instance;
	if (_tmp0_ == NULL) {
		PreferencesDialog* _tmp1_;
		PreferencesDialog* _tmp2_;
		PreferencesDialog* _tmp3_;
		_tmp1_ = preferences_dialog_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (preferences_dialog__instance);
		preferences_dialog__instance = _tmp1_;
		_tmp2_ = preferences_dialog__instance;
		g_signal_connect ((GtkWidget*) _tmp2_, "delete-event", (GCallback) ____lambda89__gtk_widget_delete_event, NULL);
		_tmp3_ = preferences_dialog__instance;
		g_signal_connect ((GtkWidget*) _tmp3_, "destroy", (GCallback) ____lambda90__gtk_widget_destroy, NULL);
	}
	_tmp4_ = preferences_dialog__instance;
	_tmp5_ = gtk_window_get_transient_for ((GtkWindow*) _tmp4_);
	if (parent != _tmp5_) {
		PreferencesDialog* _tmp6_;
		_tmp6_ = preferences_dialog__instance;
		gtk_window_set_transient_for ((GtkWindow*) _tmp6_, parent);
	}
	_tmp7_ = preferences_dialog__instance;
	gtk_window_present ((GtkWindow*) _tmp7_);
}

static void
preferences_dialog_reset_all (PreferencesDialog* self)
{
	GtkDialog* dialog = NULL;
	GtkMessageDialog* _tmp0_;
	GtkDialog* _tmp1_;
	GtkDialog* _tmp2_;
	gint resp = 0;
	GtkDialog* _tmp3_;
	GtkDialog* _tmp4_;
	gchar** settings_str = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint settings_str_length1;
	gint _settings_str_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _ ("Do you really want to reset all preferences?"));
	g_object_ref_sink (_tmp0_);
	dialog = (GtkDialog*) _tmp0_;
	_tmp1_ = dialog;
	gtk_dialog_add_button (_tmp1_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp2_ = dialog;
	gtk_dialog_add_button (_tmp2_, _ ("_Reset All"), (gint) GTK_RESPONSE_YES);
	_tmp3_ = dialog;
	resp = gtk_dialog_run (_tmp3_);
	_tmp4_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	if (resp != ((gint) GTK_RESPONSE_YES)) {
		_g_object_unref0 (dialog);
		return;
	}
	_tmp5_ = g_strdup ("org.gnome.gnome-latex.preferences.editor");
	_tmp6_ = g_strdup ("org.gnome.gnome-latex.preferences.latex");
	_tmp7_ = g_new0 (gchar*, 2 + 1);
	_tmp7_[0] = _tmp5_;
	_tmp7_[1] = _tmp6_;
	settings_str = _tmp7_;
	settings_str_length1 = 2;
	_settings_str_size_ = settings_str_length1;
	_tmp8_ = settings_str;
	_tmp8__length1 = settings_str_length1;
	{
		gchar** setting_str_collection = NULL;
		gint setting_str_collection_length1 = 0;
		gint _setting_str_collection_size_ = 0;
		gint setting_str_it = 0;
		setting_str_collection = _tmp8_;
		setting_str_collection_length1 = _tmp8__length1;
		for (setting_str_it = 0; setting_str_it < setting_str_collection_length1; setting_str_it = setting_str_it + 1) {
			gchar* _tmp9_;
			gchar* setting_str = NULL;
			_tmp9_ = g_strdup (setting_str_collection[setting_str_it]);
			setting_str = _tmp9_;
			{
				GSettings* settings = NULL;
				const gchar* _tmp10_;
				GSettings* _tmp11_;
				gchar** keys = NULL;
				GSettings* _tmp12_;
				gchar** _tmp13_;
				gchar** _tmp14_;
				gint keys_length1;
				gint _keys_size_;
				gchar** _tmp15_;
				gint _tmp15__length1;
				_tmp10_ = setting_str;
				_tmp11_ = g_settings_new (_tmp10_);
				settings = _tmp11_;
				_tmp12_ = settings;
				_tmp14_ = _tmp13_ = g_settings_list_keys (_tmp12_);
				keys = _tmp14_;
				keys_length1 = _vala_array_length (_tmp13_);
				_keys_size_ = keys_length1;
				_tmp15_ = keys;
				_tmp15__length1 = keys_length1;
				{
					gchar** key_collection = NULL;
					gint key_collection_length1 = 0;
					gint _key_collection_size_ = 0;
					gint key_it = 0;
					key_collection = _tmp15_;
					key_collection_length1 = _tmp15__length1;
					for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
						gchar* _tmp16_;
						gchar* key = NULL;
						_tmp16_ = g_strdup (key_collection[key_it]);
						key = _tmp16_;
						{
							GSettings* _tmp17_;
							const gchar* _tmp18_;
							_tmp17_ = settings;
							_tmp18_ = key;
							g_settings_reset (_tmp17_, _tmp18_);
							_g_free0 (key);
						}
					}
				}
				keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (settings);
				_g_free0 (setting_str);
			}
		}
	}
	settings_str = (_vala_array_free (settings_str, settings_str_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (dialog);
}

static const gchar*
__lambda86_ (PreferencesDialog* self,
             gulong n)
{
	const gchar* result = NULL;
	result = ngettext ("minute", "minutes", n);
	return result;
}

static const gchar*
___lambda86__preferences_dialog_plural (gulong n,
                                        gpointer self)
{
	const gchar* result;
	result = __lambda86_ ((PreferencesDialog*) self, n);
	return result;
}

static void
preferences_dialog_init_editor_tab (PreferencesDialog* self,
                                    GtkBuilder* builder)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GObject* display_line_nb_checkbutton = NULL;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GtkSpinButton* tab_width_spinbutton = NULL;
	GObject* _tmp3_;
	GtkSpinButton* _tmp4_;
	GObject* insert_spaces_checkbutton = NULL;
	GObject* _tmp5_;
	GObject* _tmp6_;
	GtkWidget* forget_no_tabs = NULL;
	GObject* _tmp7_;
	GtkWidget* _tmp8_;
	GObject* hl_current_line_checkbutton = NULL;
	GObject* _tmp9_;
	GObject* _tmp10_;
	GObject* bracket_matching_checkbutton = NULL;
	GObject* _tmp11_;
	GObject* _tmp12_;
	GObject* backup_checkbutton = NULL;
	GObject* _tmp13_;
	GObject* _tmp14_;
	GObject* autosave_checkbutton = NULL;
	GObject* _tmp15_;
	GObject* _tmp16_;
	GtkSpinButton* autosave_spinbutton = NULL;
	GObject* _tmp17_;
	GtkSpinButton* _tmp18_;
	GtkLabel* autosave_label = NULL;
	GObject* _tmp19_;
	GtkLabel* _tmp20_;
	GObject* reopen_checkbutton = NULL;
	GObject* _tmp21_;
	GObject* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.editor");
	settings = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "display_line_nb_checkbutton");
	_tmp2_ = _g_object_ref0 (_tmp1_);
	display_line_nb_checkbutton = _tmp2_;
	g_settings_bind (settings, "display-line-numbers", display_line_nb_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp3_ = gtk_builder_get_object (builder, "tab_width_spinbutton");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_spin_button_get_type ()) ? ((GtkSpinButton*) _tmp3_) : NULL);
	tab_width_spinbutton = _tmp4_;
	preferences_dialog_set_spin_button_range (self, tab_width_spinbutton, settings, "tabs-size");
	g_settings_bind (settings, "tabs-size", (GObject*) tab_width_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp5_ = gtk_builder_get_object (builder, "insert_spaces_checkbutton");
	_tmp6_ = _g_object_ref0 (_tmp5_);
	insert_spaces_checkbutton = _tmp6_;
	g_settings_bind (settings, "insert-spaces", insert_spaces_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp7_ = gtk_builder_get_object (builder, "forget_no_tabs");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp7_) : NULL);
	forget_no_tabs = _tmp8_;
	g_settings_bind (settings, "forget-no-tabs", (GObject*) forget_no_tabs, "active", G_SETTINGS_BIND_DEFAULT);
	g_object_bind_property_with_closures (insert_spaces_checkbutton, "active", (GObject*) forget_no_tabs, "sensitive", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp9_ = gtk_builder_get_object (builder, "hl_current_line_checkbutton");
	_tmp10_ = _g_object_ref0 (_tmp9_);
	hl_current_line_checkbutton = _tmp10_;
	g_settings_bind (settings, "highlight-current-line", hl_current_line_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp11_ = gtk_builder_get_object (builder, "bracket_matching_checkbutton");
	_tmp12_ = _g_object_ref0 (_tmp11_);
	bracket_matching_checkbutton = _tmp12_;
	g_settings_bind (settings, "bracket-matching", bracket_matching_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp13_ = gtk_builder_get_object (builder, "backup_checkbutton");
	_tmp14_ = _g_object_ref0 (_tmp13_);
	backup_checkbutton = _tmp14_;
	g_settings_bind (settings, "create-backup-copy", backup_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp15_ = gtk_builder_get_object (builder, "autosave_checkbutton");
	_tmp16_ = _g_object_ref0 (_tmp15_);
	autosave_checkbutton = _tmp16_;
	g_settings_bind (settings, "auto-save", autosave_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp17_ = gtk_builder_get_object (builder, "autosave_spinbutton");
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, gtk_spin_button_get_type ()) ? ((GtkSpinButton*) _tmp17_) : NULL);
	autosave_spinbutton = _tmp18_;
	preferences_dialog_set_spin_button_range (self, autosave_spinbutton, settings, "auto-save-interval");
	g_settings_bind (settings, "auto-save-interval", (GObject*) autosave_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
	g_object_bind_property_with_closures (autosave_checkbutton, "active", (GObject*) autosave_spinbutton, "sensitive", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp19_ = gtk_builder_get_object (builder, "autosave_label");
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp19_) : NULL);
	autosave_label = _tmp20_;
	preferences_dialog_set_plural (self, autosave_label, settings, "auto-save-interval", ___lambda86__preferences_dialog_plural, self);
	_tmp21_ = gtk_builder_get_object (builder, "reopen_checkbutton");
	_tmp22_ = _g_object_ref0 (_tmp21_);
	reopen_checkbutton = _tmp22_;
	g_settings_bind (settings, "reopen-files", reopen_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (reopen_checkbutton);
	_g_object_unref0 (autosave_label);
	_g_object_unref0 (autosave_spinbutton);
	_g_object_unref0 (autosave_checkbutton);
	_g_object_unref0 (backup_checkbutton);
	_g_object_unref0 (bracket_matching_checkbutton);
	_g_object_unref0 (hl_current_line_checkbutton);
	_g_object_unref0 (forget_no_tabs);
	_g_object_unref0 (insert_spaces_checkbutton);
	_g_object_unref0 (tab_width_spinbutton);
	_g_object_unref0 (display_line_nb_checkbutton);
	_g_object_unref0 (settings);
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		PreferencesDialog* self;
		self = _data24_->self;
		_g_object_unref0 (_data24_->default_font_checkbutton);
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}

static void
__lambda87_ (Block24Data* _data24_)
{
	PreferencesDialog* self;
	self = _data24_->self;
	preferences_dialog_set_system_font_label (self, _data24_->default_font_checkbutton);
}

static void
___lambda87__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda87_ (self);
}

static void
preferences_dialog_init_font_and_colors_tab (PreferencesDialog* self,
                                             GtkBuilder* builder)
{
	Block24Data* _data24_;
	LatexilaSettings* settings = NULL;
	LatexilaSettings* _tmp0_;
	LatexilaSettings* _tmp1_;
	GSettings* editor_settings = NULL;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GObject* _tmp4_;
	GtkButton* _tmp5_;
	AppSettings* app_settings = NULL;
	AppSettings* _tmp6_;
	GObject* font_button = NULL;
	GObject* _tmp7_;
	GObject* _tmp8_;
	GtkWidget* font_hbox = NULL;
	GObject* _tmp9_;
	GtkWidget* _tmp10_;
	TeplStyleSchemeChooserWidget* style_scheme_chooser = NULL;
	GObject* _tmp11_;
	TeplStyleSchemeChooserWidget* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_data24_ = g_slice_new0 (Block24Data);
	_data24_->_ref_count_ = 1;
	_data24_->self = g_object_ref (self);
	_tmp0_ = latexila_settings_get_singleton ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	settings = _tmp1_;
	_tmp2_ = latexila_settings_peek_editor_settings (settings);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	editor_settings = _tmp3_;
	_tmp4_ = gtk_builder_get_object (builder, "default_font_checkbutton");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_button_get_type ()) ? ((GtkButton*) _tmp4_) : NULL);
	_data24_->default_font_checkbutton = _tmp5_;
	g_settings_bind (editor_settings, "use-default-font", (GObject*) _data24_->default_font_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	preferences_dialog_set_system_font_label (self, _data24_->default_font_checkbutton);
	_tmp6_ = app_settings_get_default ();
	app_settings = _tmp6_;
	g_signal_connect_data ((GObject*) app_settings, "notify::system-font", (GCallback) ___lambda87__g_object_notify, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
	_tmp7_ = gtk_builder_get_object (builder, "font_button");
	_tmp8_ = _g_object_ref0 (_tmp7_);
	font_button = _tmp8_;
	g_settings_bind (editor_settings, "editor-font", font_button, "font-name", G_SETTINGS_BIND_DEFAULT);
	_tmp9_ = gtk_builder_get_object (builder, "font_hbox");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp9_) : NULL);
	font_hbox = _tmp10_;
	g_object_bind_property_with_closures ((GObject*) _data24_->default_font_checkbutton, "active", (GObject*) font_hbox, "sensitive", (G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE) | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp11_ = gtk_builder_get_object (builder, "style_scheme_chooser");
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, tepl_style_scheme_chooser_widget_get_type ()) ? ((TeplStyleSchemeChooserWidget*) _tmp11_) : NULL);
	style_scheme_chooser = _tmp12_;
	g_settings_bind (editor_settings, "scheme", (GObject*) style_scheme_chooser, "tepl-style-scheme-id", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (style_scheme_chooser);
	_g_object_unref0 (font_hbox);
	_g_object_unref0 (font_button);
	_g_object_unref0 (app_settings);
	_g_object_unref0 (editor_settings);
	_g_object_unref0 (settings);
	block24_data_unref (_data24_);
	_data24_ = NULL;
}

static const gchar*
__lambda88_ (PreferencesDialog* self,
             gulong n)
{
	const gchar* result = NULL;
	result = ngettext ("character", "characters", n);
	return result;
}

static const gchar*
___lambda88__preferences_dialog_plural (gulong n,
                                        gpointer self)
{
	const gchar* result;
	result = __lambda88_ ((PreferencesDialog*) self, n);
	return result;
}

static void
preferences_dialog_init_interactive_completion_setting (PreferencesDialog* self,
                                                        GtkBuilder* builder)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GObject* interactive_comp_checkbutton = NULL;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GtkSpinButton* interactive_comp_spinbutton = NULL;
	GObject* _tmp3_;
	GtkSpinButton* _tmp4_;
	GtkLabel* interactive_comp_label = NULL;
	GObject* _tmp5_;
	GtkLabel* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.latex");
	settings = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "interactive_comp_checkbutton");
	_tmp2_ = _g_object_ref0 (_tmp1_);
	interactive_comp_checkbutton = _tmp2_;
	g_settings_bind (settings, "interactive-completion", interactive_comp_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp3_ = gtk_builder_get_object (builder, "interactive_comp_spinbutton");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_spin_button_get_type ()) ? ((GtkSpinButton*) _tmp3_) : NULL);
	interactive_comp_spinbutton = _tmp4_;
	preferences_dialog_set_spin_button_range (self, interactive_comp_spinbutton, settings, "interactive-completion-num");
	g_settings_bind (settings, "interactive-completion-num", (GObject*) interactive_comp_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
	g_object_bind_property_with_closures (interactive_comp_checkbutton, "active", (GObject*) interactive_comp_spinbutton, "sensitive", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp5_ = gtk_builder_get_object (builder, "interactive_comp_label");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp5_) : NULL);
	interactive_comp_label = _tmp6_;
	preferences_dialog_set_plural (self, interactive_comp_label, settings, "interactive-completion-num", ___lambda88__preferences_dialog_plural, self);
	_g_object_unref0 (interactive_comp_label);
	_g_object_unref0 (interactive_comp_spinbutton);
	_g_object_unref0 (interactive_comp_checkbutton);
	_g_object_unref0 (settings);
}

static void
preferences_dialog_init_spell_checking_settings (PreferencesDialog* self,
                                                 GtkBuilder* builder)
{
	GSettings* editor_settings = NULL;
	GSettings* _tmp0_;
	GspellLanguageChooserButton* spell_language_button = NULL;
	GObject* _tmp1_;
	GspellLanguageChooserButton* _tmp2_;
	GObject* inline_spell_checkbutton = NULL;
	GObject* _tmp3_;
	GObject* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.editor");
	editor_settings = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "spell_language_button");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gspell_language_chooser_button_get_type ()) ? ((GspellLanguageChooserButton*) _tmp1_) : NULL);
	spell_language_button = _tmp2_;
	g_settings_bind (editor_settings, "spell-checking-language", (GObject*) spell_language_button, "language-code", G_SETTINGS_BIND_DEFAULT);
	_tmp3_ = gtk_builder_get_object (builder, "inline_spell_checkbutton");
	_tmp4_ = _g_object_ref0 (_tmp3_);
	inline_spell_checkbutton = _tmp4_;
	g_settings_bind (editor_settings, "highlight-misspelled-words", inline_spell_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (inline_spell_checkbutton);
	_g_object_unref0 (spell_language_button);
	_g_object_unref0 (editor_settings);
}

static void
preferences_dialog_init_other_tab (PreferencesDialog* self,
                                   GtkBuilder* builder)
{
	GSettings* latex_settings = NULL;
	GSettings* _tmp0_;
	GObject* confirm_clean_up_checkbutton = NULL;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GtkWidget* auto_clean_up_checkbutton = NULL;
	GObject* _tmp3_;
	GtkWidget* _tmp4_;
	GObject* clean_up_entry = NULL;
	GObject* _tmp5_;
	GObject* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.latex");
	latex_settings = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, "confirm_clean_up_checkbutton");
	_tmp2_ = _g_object_ref0 (_tmp1_);
	confirm_clean_up_checkbutton = _tmp2_;
	g_settings_bind (latex_settings, "no-confirm-clean", confirm_clean_up_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp3_ = gtk_builder_get_object (builder, "auto_clean_up_checkbutton");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp3_) : NULL);
	auto_clean_up_checkbutton = _tmp4_;
	g_settings_bind (latex_settings, "automatic-clean", (GObject*) auto_clean_up_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
	g_object_bind_property_with_closures (confirm_clean_up_checkbutton, "active", (GObject*) auto_clean_up_checkbutton, "sensitive", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp5_ = gtk_builder_get_object (builder, "clean_up_entry");
	_tmp6_ = _g_object_ref0 (_tmp5_);
	clean_up_entry = _tmp6_;
	g_settings_bind (latex_settings, "clean-extensions", clean_up_entry, "text", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (clean_up_entry);
	_g_object_unref0 (auto_clean_up_checkbutton);
	_g_object_unref0 (confirm_clean_up_checkbutton);
	_g_object_unref0 (latex_settings);
}

static void
preferences_dialog_set_system_font_label (PreferencesDialog* self,
                                          GtkButton* button)
{
	AppSettings* app_settings = NULL;
	AppSettings* _tmp0_;
	gchar* label = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = app_settings_get_default ();
	app_settings = _tmp0_;
	_tmp1_ = app_settings_get_system_font (app_settings);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf (_ ("Use the system fixed width font (%s)"), _tmp2_);
	label = _tmp3_;
	gtk_button_set_label (button, label);
	_g_free0 (label);
	_g_object_unref0 (app_settings);
}

static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
	g_atomic_int_inc (&_data25_->_ref_count_);
	return _data25_;
}

static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
		PreferencesDialog* self;
		self = _data25_->self;
		_g_object_unref0 (_data25_->label);
		_g_object_unref0 (self);
		g_slice_free (Block25Data, _data25_);
	}
}

static void
__lambda85_ (Block25Data* _data25_,
             GSettings* setting,
             const gchar* k)
{
	PreferencesDialog* self;
	guint v = 0U;
	guint _tmp0_ = 0U;
	const gchar* _tmp1_;
	self = _data25_->self;
	g_return_if_fail (setting != NULL);
	g_return_if_fail (k != NULL);
	g_settings_get (setting, k, "u", &_tmp0_);
	v = _tmp0_;
	_tmp1_ = _data25_->plural ((gulong) v, _data25_->plural_target);
	gtk_label_set_label (_data25_->label, _tmp1_);
}

static void
___lambda85__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda85_ (self, _sender, key);
}

static void
preferences_dialog_set_plural (PreferencesDialog* self,
                               GtkLabel* label,
                               GSettings* settings,
                               const gchar* key,
                               PreferencesDialogPlural plural,
                               gpointer plural_target)
{
	Block25Data* _data25_;
	GtkLabel* _tmp0_;
	guint val = 0U;
	guint _tmp1_ = 0U;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	_data25_ = g_slice_new0 (Block25Data);
	_data25_->_ref_count_ = 1;
	_data25_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (label);
	_g_object_unref0 (_data25_->label);
	_data25_->label = _tmp0_;
	_data25_->plural = plural;
	_data25_->plural_target = plural_target;
	g_settings_get (settings, key, "u", &_tmp1_);
	val = _tmp1_;
	_tmp2_ = _data25_->plural ((gulong) val, _data25_->plural_target);
	gtk_label_set_label (_data25_->label, _tmp2_);
	_tmp3_ = g_strconcat ("changed::", key, NULL);
	g_signal_connect_data (settings, _tmp3_, (GCallback) ___lambda85__g_settings_changed, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
	_g_free0 (_tmp3_);
	block25_data_unref (_data25_);
	_data25_ = NULL;
}

static void
preferences_dialog_set_spin_button_range (PreferencesDialog* self,
                                          GtkSpinButton* spin_button,
                                          GSettings* settings,
                                          const gchar* key)
{
	GSettingsSchema* schema = NULL;
	GSettingsSchema* _tmp0_;
	GSettingsSchema* _tmp1_;
	GVariant* range = NULL;
	GSettingsSchemaKey* _tmp2_;
	GSettingsSchemaKey* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	gchar* range_type = NULL;
	GVariant* range_contents = NULL;
	gchar* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	guint min = 0U;
	guint max = 0U;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	guint cur_value = 0U;
	guint _tmp10_ = 0U;
	GtkAdjustment* adjustment = NULL;
	GtkAdjustment* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin_button != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	g_object_get (settings, "settings-schema", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	schema = _tmp1_;
	_tmp2_ = g_settings_schema_get_key (schema, key);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_settings_schema_key_get_range (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_settings_schema_key_unref0 (_tmp3_);
	range = _tmp5_;
	g_variant_get (range, "(sv)", &_tmp6_, &_tmp7_, NULL);
	_g_free0 (range_type);
	range_type = _tmp6_;
	_g_variant_unref0 (range_contents);
	range_contents = _tmp7_;
	g_return_if_fail (g_strcmp0 (range_type, "range") == 0);
	g_variant_get (range_contents, "(uu)", &_tmp8_, &_tmp9_, NULL);
	min = _tmp8_;
	max = _tmp9_;
	g_settings_get (settings, key, "u", &_tmp10_);
	cur_value = _tmp10_;
	_tmp11_ = gtk_adjustment_new ((gdouble) cur_value, (gdouble) min, (gdouble) max, 1.0, (gdouble) 0, (gdouble) 0);
	g_object_ref_sink (_tmp11_);
	adjustment = _tmp11_;
	gtk_spin_button_set_adjustment (spin_button, adjustment);
	_g_object_unref0 (adjustment);
	_g_variant_unref0 (range_contents);
	_g_free0 (range_type);
	_g_variant_unref0 (range);
	_g_settings_schema_unref0 (schema);
}

static void
preferences_dialog_class_init (PreferencesDialogClass * klass,
                               gpointer klass_data)
{
	preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = preferences_dialog_finalize;
}

static void
preferences_dialog_instance_init (PreferencesDialog * self,
                                  gpointer klass)
{
}

static void
preferences_dialog_finalize (GObject * obj)
{
	PreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREFERENCES_DIALOG, PreferencesDialog);
	G_OBJECT_CLASS (preferences_dialog_parent_class)->finalize (obj);
}

static GType
preferences_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialog), 0, (GInstanceInitFunc) preferences_dialog_instance_init, NULL };
	GType preferences_dialog_type_id;
	preferences_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "PreferencesDialog", &g_define_type_info, 0);
	return preferences_dialog_type_id;
}

GType
preferences_dialog_get_type (void)
{
	static volatile gsize preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_type_id__volatile)) {
		GType preferences_dialog_type_id;
		preferences_dialog_type_id = preferences_dialog_get_type_once ();
		g_once_init_leave (&preferences_dialog_type_id__volatile, preferences_dialog_type_id);
	}
	return preferences_dialog_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

