/* documents_panel.c generated by valac 0.48.10, the Vala compiler
 * generated from documents_panel.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010, 2011, 2017 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tepl/tepl.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gio/gio.h>

#define TYPE_DOCUMENTS_PANEL (documents_panel_get_type ())
#define DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanel))
#define DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))
#define IS_DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENTS_PANEL))
#define IS_DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENTS_PANEL))
#define DOCUMENTS_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))

typedef struct _DocumentsPanel DocumentsPanel;
typedef struct _DocumentsPanelClass DocumentsPanelClass;
typedef struct _DocumentsPanelPrivate DocumentsPanelPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
enum  {
	DOCUMENTS_PANEL_0_PROPERTY,
	DOCUMENTS_PANEL_NUM_PROPERTIES
};
static GParamSpec* documents_panel_properties[DOCUMENTS_PANEL_NUM_PROPERTIES];

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block13Data Block13Data;

#define TYPE_TAB_LABEL (tab_label_get_type ())
#define TAB_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_LABEL, TabLabel))
#define TAB_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_LABEL, TabLabelClass))
#define IS_TAB_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_LABEL))
#define IS_TAB_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_LABEL))
#define TAB_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_LABEL, TabLabelClass))

typedef struct _TabLabel TabLabel;
typedef struct _TabLabelClass TabLabelClass;

#define TYPE_CLEAN_BUILD_FILES (clean_build_files_get_type ())
#define CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFiles))
#define CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))
#define IS_CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLEAN_BUILD_FILES))
#define IS_CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLEAN_BUILD_FILES))
#define CLEAN_BUILD_FILES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))

typedef struct _CleanBuildFiles CleanBuildFiles;
typedef struct _CleanBuildFilesClass CleanBuildFilesClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
enum  {
	DOCUMENTS_PANEL_RIGHT_CLICK_SIGNAL,
	DOCUMENTS_PANEL_NUM_SIGNALS
};
static guint documents_panel_signals[DOCUMENTS_PANEL_NUM_SIGNALS] = {0};

struct _DocumentsPanel {
	TeplNotebook parent_instance;
	DocumentsPanelPrivate * priv;
};

struct _DocumentsPanelClass {
	TeplNotebookClass parent_class;
};

struct _DocumentsPanelPrivate {
	MainWindow* main_window;
};

struct _Block13Data {
	int _ref_count_;
	DocumentsPanel* self;
	DocumentTab* tab;
};

static gint DocumentsPanel_private_offset;
static gpointer documents_panel_parent_class = NULL;

GType documents_panel_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentsPanel, g_object_unref)
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
DocumentsPanel* documents_panel_new (MainWindow* main_window);
DocumentsPanel* documents_panel_construct (GType object_type,
                                           MainWindow* main_window);
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
void documents_panel_add_tab (DocumentsPanel* self,
                              DocumentTab* tab,
                              gint position,
                              gboolean jump_to);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
GType tab_label_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TabLabel, g_object_unref)
TabLabel* tab_label_new (DocumentTab* tab);
TabLabel* tab_label_construct (GType object_type,
                               DocumentTab* tab);
static gboolean __lambda51_ (Block13Data* _data13_,
                      GdkEventButton* event);
static gboolean ___lambda51__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
void documents_panel_remove_tab (DocumentsPanel* self,
                                 DocumentTab* tab);
GType clean_build_files_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CleanBuildFiles, g_object_unref)
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
Document* document_tab_get_document (DocumentTab* self);
CleanBuildFiles* clean_build_files_new (MainWindow* main_window,
                                        Document* doc);
CleanBuildFiles* clean_build_files_construct (GType object_type,
                                              MainWindow* main_window,
                                              Document* doc);
void clean_build_files_clean (CleanBuildFiles* self);
void documents_panel_remove_all_tabs (DocumentsPanel* self);
static void documents_panel_finalize (GObject * obj);
static GType documents_panel_get_type_once (void);

static inline gpointer
documents_panel_get_instance_private (DocumentsPanel* self)
{
	return G_STRUCT_MEMBER_P (self, DocumentsPanel_private_offset);
}

DocumentsPanel*
documents_panel_construct (GType object_type,
                           MainWindow* main_window)
{
	DocumentsPanel * self = NULL;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (DocumentsPanel*) g_object_new (object_type, NULL);
	self->priv->main_window = main_window;
	return self;
}

DocumentsPanel*
documents_panel_new (MainWindow* main_window)
{
	return documents_panel_construct (TYPE_DOCUMENTS_PANEL, main_window);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		DocumentsPanel* self;
		self = _data13_->self;
		_g_object_unref0 (_data13_->tab);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static gboolean
__lambda51_ (Block13Data* _data13_,
             GdkEventButton* event)
{
	DocumentsPanel* self;
	gboolean result = FALSE;
	self = _data13_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button == ((guint) 3)) {
		gtk_notebook_set_current_page ((GtkNotebook*) self, gtk_notebook_page_num ((GtkNotebook*) self, (GtkWidget*) _data13_->tab));
		g_signal_emit (self, documents_panel_signals[DOCUMENTS_PANEL_RIGHT_CLICK_SIGNAL], 0, event);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda51__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda51_ (self, event);
	return result;
}

void
documents_panel_add_tab (DocumentsPanel* self,
                         DocumentTab* tab,
                         gint position,
                         gboolean jump_to)
{
	Block13Data* _data13_;
	DocumentTab* _tmp0_;
	GtkEventBox* event_box = NULL;
	GtkEventBox* _tmp1_;
	GtkEventBox* _tmp2_;
	TabLabel* tab_label = NULL;
	TabLabel* _tmp3_;
	TabLabel* _tmp4_;
	GtkEventBox* _tmp5_;
	TabLabel* _tmp6_;
	GtkEventBox* _tmp7_;
	gint page_pos = 0;
	GtkEventBox* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (tab);
	_g_object_unref0 (_data13_->tab);
	_data13_->tab = _tmp0_;
	_tmp1_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp1_);
	event_box = _tmp1_;
	_tmp2_ = event_box;
	gtk_event_box_set_visible_window (_tmp2_, FALSE);
	_tmp3_ = tab_label_new (_data13_->tab);
	g_object_ref_sink (_tmp3_);
	tab_label = _tmp3_;
	_tmp4_ = tab_label;
	gtk_widget_show ((GtkWidget*) _tmp4_);
	_tmp5_ = event_box;
	_tmp6_ = tab_label;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = event_box;
	g_signal_connect_data ((GtkWidget*) _tmp7_, "button-press-event", (GCallback) ___lambda51__gtk_widget_button_press_event, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	_tmp8_ = event_box;
	page_pos = gtk_notebook_insert_page ((GtkNotebook*) self, (GtkWidget*) _data13_->tab, (GtkWidget*) _tmp8_, position);
	gtk_notebook_set_tab_reorderable ((GtkNotebook*) self, (GtkWidget*) _data13_->tab, TRUE);
	if (jump_to) {
		gtk_notebook_set_current_page ((GtkNotebook*) self, page_pos);
	}
	_g_object_unref0 (tab_label);
	_g_object_unref0 (event_box);
	block13_data_unref (_data13_);
	_data13_ = NULL;
}

void
documents_panel_remove_tab (DocumentsPanel* self,
                            DocumentTab* tab)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GSettings* _tmp2_;
	gint pos = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.latex");
	settings = _tmp0_;
	_tmp2_ = settings;
	if (g_settings_get_boolean (_tmp2_, "no-confirm-clean")) {
		GSettings* _tmp3_;
		_tmp3_ = settings;
		_tmp1_ = g_settings_get_boolean (_tmp3_, "automatic-clean");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		CleanBuildFiles* build_files = NULL;
		MainWindow* _tmp4_;
		Document* _tmp5_;
		Document* _tmp6_;
		CleanBuildFiles* _tmp7_;
		CleanBuildFiles* _tmp8_;
		_tmp4_ = self->priv->main_window;
		_tmp5_ = document_tab_get_document (tab);
		_tmp6_ = _tmp5_;
		_tmp7_ = clean_build_files_new (_tmp4_, _tmp6_);
		build_files = _tmp7_;
		_tmp8_ = build_files;
		clean_build_files_clean (_tmp8_);
		_g_object_unref0 (build_files);
	}
	pos = gtk_notebook_page_num ((GtkNotebook*) self, (GtkWidget*) tab);
	gtk_notebook_remove_page ((GtkNotebook*) self, pos);
	_g_object_unref0 (settings);
}

void
documents_panel_remove_all_tabs (DocumentsPanel* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gint n = 0;
		DocumentTab* tab = NULL;
		GtkWidget* _tmp0_;
		DocumentTab* _tmp1_;
		DocumentTab* _tmp2_;
		n = gtk_notebook_get_current_page ((GtkNotebook*) self);
		if (n == -1) {
			break;
		}
		_tmp0_ = gtk_notebook_get_nth_page ((GtkNotebook*) self, n);
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DOCUMENT_TAB, DocumentTab));
		tab = _tmp1_;
		_tmp2_ = tab;
		documents_panel_remove_tab (self, _tmp2_);
		_g_object_unref0 (tab);
	}
}

static void
documents_panel_class_init (DocumentsPanelClass * klass,
                            gpointer klass_data)
{
	documents_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DocumentsPanel_private_offset);
	G_OBJECT_CLASS (klass)->finalize = documents_panel_finalize;
	documents_panel_signals[DOCUMENTS_PANEL_RIGHT_CLICK_SIGNAL] = g_signal_new ("right-click", TYPE_DOCUMENTS_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, gdk_event_get_type ());
}

static void
documents_panel_instance_init (DocumentsPanel * self,
                               gpointer klass)
{
	self->priv = documents_panel_get_instance_private (self);
}

static void
documents_panel_finalize (GObject * obj)
{
	DocumentsPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENTS_PANEL, DocumentsPanel);
	G_OBJECT_CLASS (documents_panel_parent_class)->finalize (obj);
}

static GType
documents_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DocumentsPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) documents_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentsPanel), 0, (GInstanceInitFunc) documents_panel_instance_init, NULL };
	GType documents_panel_type_id;
	documents_panel_type_id = g_type_register_static (tepl_notebook_get_type (), "DocumentsPanel", &g_define_type_info, 0);
	DocumentsPanel_private_offset = g_type_add_instance_private (documents_panel_type_id, sizeof (DocumentsPanelPrivate));
	return documents_panel_type_id;
}

GType
documents_panel_get_type (void)
{
	static volatile gsize documents_panel_type_id__volatile = 0;
	if (g_once_init_enter (&documents_panel_type_id__volatile)) {
		GType documents_panel_type_id;
		documents_panel_type_id = documents_panel_get_type_once ();
		g_once_init_leave (&documents_panel_type_id__volatile, documents_panel_type_id);
	}
	return documents_panel_type_id__volatile;
}

